#!/usr/bin/perl -w
# NAME: addtitle.pl
# AIM: Very sepcific - given a HTML file, search for anchors, open anchor HREF file
# and insert the title.
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
require 'lib_html.pl' or die "Unable to load 'lib_html.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2012-07-18";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 1;
my $def_file = 'C:\Projects\OpenLayers\OpenLayers-2.12\examples\index.html';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub Get_File_Title($) {
    my $ff = shift;
    if (! open INF, "<$ff") {
        return "failed";
    }
    my @lines = <INF>;
    close INF;
    my $html = join("",@lines);
    my $ra = get_html_refarray($html);
    my $ta = get_whole_tag_array($ra,'title',0);
    my $tta = get_title_text($ta,0);
    return join(" ",@{$tta});
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$i,$lnn,$cnt,$ff,$title,$ok);
    my ($fnam,$fdir) = fileparse($inf);
    ut_fix_directory(\$fdir);
    $lnn = 0;
    $line = join(" ",@lines);
    my $ra = get_html_refarray($line); # my $content = shift;
    # show_html_refarray($ra);
    # my $ta = get_tag_array($ra,'title',0x8000);
    #  get_whole_tag_array
    my $ta = get_whole_tag_array($ra,'title',0x8000);
    show_html_refarray($ta);
    my $tta = get_title_text($ta,0);
    prt("Title: ".join(" ",@{$tta})."\n");
    # my $aa = get_whole_tag_array($ra,'a',0);
    my $hra = get_a_href_array($ra,0);
    $cnt = scalar @{$hra};
    prt("<p>\n");
    my $bgn = '<a target="_blank" href="';
    set_show_warnings(0);
    for ($i = 0; $i < $cnt; $i++) {
        $lnn = strip_quotes(${$hra}[$i]);
        $ok = 1;
        if (-f $lnn) {
            $ff = $lnn;
        } else {
            $ff = $fdir.$lnn;
            if ( !(-f $ff) ) {
                $ok = 0;
            }
        }
        if ($ok) {
            $title = Get_File_Title($ff);
            prt($bgn."$lnn\">$lnn</a> [$title]<br>\n");
        } else {
            prt($bgn."$lnn\">$lnn</a> NF!<br>\n");
        }
    }
    prt("</p>\n");

    #foreach $line (@lines) {
    #    chomp $line;
    #    $lnn++;
    #    if ($line =~ /\s*#\s*include\s+(.+)$/) {
    #        $inc = $1;
    #        prt("$lnn: $inc\n");
    #    }
    #}
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_file($in_file);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if (VERB1());
        }
        shift @av;
    }

    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = $def_file;
        prt("Set DEFAULT input to [$in_file]\n");
        $load_log = 1;
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
