#!/usr/bin/perl -w
# NAME: apsindir.pl
# AIM: Given a FG data directory, search for exisitng airports - like Terrain\w130n30\w123n37\KSFO.btg.gz,
# and maybe Airports\K\S\F\KSFO.groundnet.xml, KSFO.ils.xml, KSFO.jetways.xml, KSFO.rwyuse.xml, KSFO.threshold.xml, KSFO.twr.xml1
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.2 2014-01-13";
my $load_log = 0;
my $in_dir = '';
my $verbosity = 0;
my $out_file = '';
my $find_icao = '';

# ### DEBUG ###
my $debug_on = 0;
my $def_file = 'X:\fgsvnts';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

my %icao_found = ();

sub process_terrain($);

sub process_terrain($) {
    my ($dir) = @_;
    if (! opendir(DIR, "$dir") ) {
        pgm_exit(1,"ERROR: Unable to open directory [$dir]\n"); 
    }
    my @files = readdir(DIR);
    closedir(DIR);
    my $lncnt = scalar @files;
    prt("Processing $lncnt files items, from [$dir]...\n") if (VERB5());;
    ut_fix_directory(\$dir);
    my ($file,$ff,$icao);
    my %dirs = ();
    foreach $file (@files) {
        next if ($file eq '.');
        next if ($file eq '..');
        $ff = $dir.$file;
        if (-d $ff) {
            $dirs{$file} = 1;
        } elsif (-f $ff) {
            if ($file =~ /^(\w{4})\.btg\.gz$/) {
                $icao = $1;
                $icao_found{$icao} = $ff;
                prt("$ff\n") if (VERB9());
            }
        } else {
            pgm_exit(1,"ERROR: What is this [$ff'! ($file)\n");
        }
    }
    foreach $file (keys %dirs) {
        $ff = $dir.$file;
        process_terrain($ff);
    }
}

sub process_airports($) {
    my ($dir) = @_;
    if (! opendir(DIR, "$dir") ) {
        pgm_exit(1,"ERROR: Unable to open directory [$dir]\n"); 
    }
    my @files = readdir(DIR);
    closedir(DIR);
    my $lncnt = scalar @files;
    prt("Processing $lncnt files items, from [$dir]...\n") if (VERB5());;
    ut_fix_directory(\$dir);
    my ($file,$ff,$icao);
    my %dirs = ();
    foreach $file (@files) {
        next if ($file eq '.');
        next if ($file eq '..');
        $ff = $dir.$file;
        if (-d $ff) {
            $dirs{$file} = 1;
        } elsif (-f $ff) {
            if ($file =~ /^$find_icao/) {
                prt("$ff\n"); # if (VERB9());
            }
        } else {
            pgm_exit(1,"ERROR: What is this [$ff'! ($file)\n");
        }
    }
}


sub process_in_dir($) {
    my ($dir) = @_;
    if (! opendir(DIR, "$dir") ) {
        pgm_exit(1,"ERROR: Unable to open directory [$dir]\n"); 
    }
    my @files = readdir(DIR);
    closedir(DIR);
    my $lncnt = scalar @files;
    prt("Processing $lncnt files items, from [$dir]...\n");
    ut_fix_directory(\$dir);
    my ($file,$ff);
    my %dirs = ();
    foreach $file (@files) {
        next if ($file eq '.');
        next if ($file eq '..');
        $ff = $dir.$file;
        if (-d $ff) {
            $dirs{$file} = 1;
        } elsif (-f $ff) {
            # what are these???
        } else {
            pgm_exit(1,"ERROR: What is this [$ff'! ($file)\n");
        }
    }
    if (defined $dirs{Terrain}) {
        $ff = $dir.'Terrain';
        process_terrain($ff);
        @files = sort keys %icao_found;
        $lncnt = scalar @files;
        prt("Found $lncnt ICAO files in $ff\n");
        if (VERB1()) {
            prt(join(" ",@files)."\n");
        } else {
            prt("Use -v to print list...\n");
        }
        if (length($find_icao)) {
            if (defined $icao_found{$find_icao}) {
                $ff = $icao_found{$find_icao};
                prt("Found ICAO $find_icao - $ff\n");
                $ff = $dir.'Airports'.$PATH_SEP.substr($find_icao,0,1).$PATH_SEP.substr($find_icao,1,1).$PATH_SEP.substr($find_icao,2,1);
                if (-d $ff) {
                    process_airports($ff);
                } else {
                    prt("Directory $ff NOT found\n");
                }
            } else {
                prt("ICAO $find_icao NOT in list\n");
                if (VERB1()) {
                    my $ch = substr($find_icao,0,1);
                    my @arr = ();
                    foreach $file (@files) {
                        if (substr($file,0,1) eq $ch) {
                            push(@arr,$file);
                        }
                    }
                    $lncnt = scalar @arr;
                    if ($lncnt) {
                        prt("Found $lncnt commencing with the same letter '$ch'\n");
                        prt(join(" ",@arr)."\n");
                    } else {
                        prt("Found NONE commencing with the same letter '$ch'\n");
                    }
                }
            }
        }
    } else {
        prt("Unable to find 'Terrain' in '$dir'\n");
    }

}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_dir($in_dir);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    my $verb = VERB2();
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^i/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $find_icao = $sarg;
                prt("Set find icao to [$find_icao].\n") if ($verb);
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                $verb = VERB2();
                prt("Verbosity = $verbosity\n") if ($verb);
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if ($verb);
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if ($verb);
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_dir = $arg;
            prt("Set input to [$in_dir]\n") if ($verb);
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if (length($in_dir) ==  0) {
            $in_dir = $def_file;
            prt("Set DEFAULT input to [$in_dir]\n");
        }
        if (length($find_icao) == 0) {
            $find_icao = 'KSFO';
            prt("Set DEFAULT ICAO to [$find_icao]\n");
        }
    }
    if (length($in_dir) ==  0) {
        pgm_exit(1,"ERROR: No input directory found in command!\n");
    }
    if (! -d $in_dir) {
        pgm_exit(1,"ERROR: Unable to find in directory [$in_dir]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-dir\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
    prt(" --icao <XXXX> (-i) = Report if this ICAO is in the list.\n");
}

# eof - template.pl
