#!/usr/bin/perl -w
# NAME: check2cmake.pl
# AIM: Quite Specific reading a ./configure log, parsing the 'checking' lines,
# and convert to cmake form...
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2013-03-17";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 1;
my $def_file = 'F:\FG\18\build-xml2\bldlog-u.txt';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

my %heads = ();
my %funcs = ();
my %types = ();

sub process_checking($$) {
    my ($lnn,$inc) = @_;
    my ($itm,$msg,@arr,$cnt);
    @arr = split(/\s+/,$inc);
    $cnt = scalar @arr;
    if ($inc =~ /^for\s+(\S+)\.\.\./) {
        $itm = trim_all($1);
        $inc = trim_all(substr($inc,(4 + length($itm) + 3)));
        if (($inc =~ /yes/)||($inc =~ /no/)) {
            if ($itm =~ /\.h/) {
                $heads{$itm} = 1;
                $msg = 'H';
            } elsif ($itm =~ /_t$/) {
                $types{$itm} = 1;
                $msg = 'T';
            } else {
                $funcs{$itm} = 1;
                $msg = 'F';
            }
            prt("$lnn: FOR $msg $itm RES Y/N\n") if (VERB9());
        } else {
            prt("$lnn: FOR $itm RES $inc\n");
        }
    } elsif ( ($arr[0] =~ /\.h/ ) && ($cnt == 3) &&
        (($arr[1] eq 'usability...')||($arr[1] eq 'presence...')) &&
        (($arr[2] eq 'yes')||($arr[2] eq 'no')) ) {
        $heads{$arr[0]} = 1;
    } else {
        prt("$lnn: $inc\n");
    }

}

sub show_hdrs() {
    my ($cnt,$key,@arrh,$var,$minh,$len,$def,@defs,@arrf,$minf);
    @arrh = sort keys(%heads);
    @arrf = sort keys(%funcs);
    $minh = 0;
    foreach $key (@arrh) {
        $len = length($key);
        $minh = $len if ($len > $minh);
    }
    $minf = 0;
    foreach $key (@arrf) {
        $len = length($key);
        $minf = $len if ($len > $minf);
    }

    # headers
    $cnt = scalar @arrh;
    prt("\n# $cnt checks for headers\n");
    @defs = ();
    foreach $key (@arrh) {
        $var = uc($key);
        $var =~ s/\./_/g;
        $var =~ s/\//_/g;
        $def = "#cmakedefine HAVE_$var 1";
        push(@defs,$def);
        $key .= ' ' while (length($key) < $minh);
        prt(" check_include_file($key HAVE_$var)\n");
    }

    prt("\n".join("\n",@defs)."\n");

    # functions
    $cnt = scalar @arrf;
    prt("\n# $cnt checks for functions\n");
    @defs = ();
    foreach $key (@arrf) {
        $var = uc($key);
        $var =~ s/\./_/g;
        $var =~ s/\//_/g;
        $def = "#cmakedefine HAVE_$var 1";
        push(@defs,$def);
        $key .= ' ' while (length($key) < $minf);
        prt(" check_function_exists($key HAVE_$var)\n");
    }

    prt("\n".join("\n",@defs)."\n");

}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn,$bal,$itm,$msg);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /^checking\s+/) {
            $inc = substr($line,9);
            process_checking($lnn,$inc);
        }
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_file($in_file);
show_hdrs();
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if (VERB1());
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if ((length($in_file) ==  0) && $debug_on) {
            $in_file = $def_file;
            prt("Set DEFAULT input to [$in_file]\n");
        }
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
