#!/usr/bin/perl -w
# NAME: chkbuilds.pl
# AIM: A little specialised! Given an input directory, check for build directories,
# and check for a .x64 version, and if they need cleaning...
# 23/03/2015 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
my $cleanbat = $temp_dir.$PATH_SEP."tempclean.bat";
open_log($outfile);

# user variables
my $VERS = "0.0.5 2015-03-23";
my $load_log = 0;
my $in_dir = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 1;
my $def_file = 'F:\fg-new';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

sub process_in_dir($) {
    my ($dir) = @_;
    if (! opendir(DIR,$dir)) {
        pgm_exit(1,"Error: Unable to open directory $dir!\n");
    }
    my @files = readdir(DIR);
    closedir(DIR);
    my ($file,$ff,$ffc);
    ut_fix_directory(\$dir);
    my %dirs = ();
    my %dirs64 = ();
    my %needclean = ();
    foreach $file (@files) {
        next if ($file eq '.');
        next if ($file eq '..');
        next if (! ($file =~ /^build-/) );
        $ff = $dir.$file;
        if (-d $ff) {
            if ($file =~ /\.x64$/) {
                $dirs64{$ff} = 1;
            } else {
                $dirs{$ff} = 1;
            }
            $ffc = $ff.$PATH_SEP."CMakeCache.txt";
            if (-f $ffc) {
                $needclean{$ff} = 1;
            }
        }
    }
    my @arr = sort keys %dirs;
    my $cnt = scalar @arr;
    my @arr2 = sort keys %dirs64;
    my $cnt2 = scalar @arr2;
    my $cnt3 = $cnt - $cnt2;
    my %no64 = ();
    my $cnt4 = 0;
    foreach $dir (@arr) {
        $file = $dir.".x64";
        if (!defined $dirs64{$file}) {
            $no64{$dir} = 1;
            $cnt4++;
        }
    }
    prt("Got $cnt build dirs, $cnt2 64-bit builds, $cnt3 ($cnt4) without a 64-bit...\n");
    @arr = sort keys %no64;
    prt(join(" ",@arr)."\n");
    @arr2 = sort keys %needclean;
    $cnt2 = scalar @arr2;
    prt("$cnt2 need cleaning...\n");
    if ($cnt2) {
        prt(join(" ",@arr2)."\n");
        my $bat = '';
        foreach $dir (@arr2) {
            $bat .= "cd $dir\n";
            $bat .= "call cmake-clean\n";
            $bat .= "cd ..\n";
        }
        write2file($bat,$cleanbat);
        prt("Cleanup list written to $cleanbat\n");
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_dir($in_dir);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    my $verb = VERB2();
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                $verb = VERB2();
                prt("Verbosity = $verbosity\n") if ($verb);
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if ($verb);
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if ($verb);
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_dir = $arg;
            prt("Set input to [$in_dir]\n") if ($verb);
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if (length($in_dir) ==  0) {
            $in_dir = $def_file;
            prt("Set DEFAULT input to [$in_dir]\n");
        }
    }
    if (length($in_dir) ==  0) {
        pgm_exit(1,"ERROR: No input dorectory found in command!\n");
    }
    if (! -d $in_dir) {
        pgm_exit(1,"ERROR: Unable to find directory [$in_dir]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-directory\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
    prt(" Given an input directory, check for build directories present.\n");
}

# eof - chkbuilds.pl
