#!/usr/bin/perl -w
# NAME: chkfgmenu.pl
# AIM: VERY SPECIFIC - Check my fgmenu.js, and the compare with the fg folder,
# and report MISSING files - files that need to be added to the menu
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
use File::DosGlob 'glob';
my $perl_dir = 'C:\GTools\perl';
unshift(@INC, $perl_dir);
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 1;
my $in_dir = 'C:\HOMEPAGE\GA\fg';
my $in_file = $in_dir.'\fgmenu.js';
my $in_file2 = $in_dir.'\qlfgmenu.js';
my $in_file3 = $in_dir.'\index.htm';

# sub-set of Atlas pages - 
# from Atlas index fgfs-007.htm
my %excluded_atlas = (
    'fgfs-002.htm' => 1,
    'fgfs-003.htm' => 2,
    'fgfs-006.htm' => 3,
    'fgfs-044.htm' => 4,
    'fgfs-049.htm' => 5,
    'atlas-07.htm' => 6,
    'fgfse001.htm' => 7     # Atlas - Build Error Sample
    );

my %excluded_others = (
    'README.fgfs.htm' => 'a README',
    'blank.htm' => 'blank page',
    'fgfs-blank.htm' => 'another blank page',
    'fgall.htm' => '???',
    'fgfs-008.htm' => 'about DEBUGGING',
    'fgfs-008a.htm' => 'dbg 2',
    'fgfs-008b.htm' => 'dbg 3',
    'fgfs-008c.htm' => 'dbg 4',
    'fgfs-009.htm' => 'FGRUN...',
    'fgfs-011.htm' => 'am2dsp...',
    'fgfs-012.htm' => 'FG options',
    'fgfs-015.htm' => 'cont. Oct 2005',
    'fgfs-025.htm' => 'am2dsp more...',
    'fgfs-029.htm' => 'cygwin - July 2006',
    'fgfs-045b.htm' => 'TBD',
    'fgfs-049a.htm' => 'TBD',
    'fgfs-050a.htm' => 'TBD',
    'fgfs-050b.htm' => 'TBD',
    'fgfs-051.htm' => 'Mesa 3D',
    'fgfs-err01.htm' => 'TBD',
    'fgfs-err02.htm' => 'TBD',
    'xmlrpc-c-doc01.htm' => ' What ???',
    'pic1.htm' => 'Hmmmm...',
    'index2.htm' => 'Old index',
    'index3.htm' => 'And another...',
    'fgimgvw2.htm' => 'Image index',
    'keyboard.htm' => 'Quick Ref December 14, 2008',
    'machines.htm' => 'Machine Details',
    'fgsd-01.htm' => 'FlightGear Scenery Designer (fgsd)',
    'download.htm' => 'Avail downloads 2007'

);

# fgfs-053.htm

### program variables
my @warnings = ();
my $cwd = cwd();
my $os = $^O;

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg)
    }
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub show_warnings() {
   if (@warnings) {
      prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
      foreach my $itm (@warnings) {
         prt("$itm\n");
      }
      prt("\n");
   } else {
      prt( "\nNo warnings issued.\n\n" );
   }
}

sub get_file_list($) {
    my $dir = shift;
    pgm_exit(1,"ERROR: Can NOT locate directory [$dir]!\n") if (! -d $dir);
    $dir .= "\\" if ( !($dir =~ /(\\|\/)$/) );
    $dir .= "*.htm";
    my @files = glob($dir);
    my $cnt = scalar @files;
    pgm_exit(1,"ERROR: Got NO files from [$dir]!\n") if (!$cnt);
    prt("Got $cnt files in [$dir]\n");
    my @files2 = ();
    if ($cnt) {
        my ($file,$nam,$dir);
        foreach my $file (@files) {
            #prt("$file ");
            ($nam,$dir) = fileparse($file);
            #prt("$nam ");
            push(@files2,$nam);
        }
        #prt("\n");
    }
    return \@files2;
}

#   document.write("<a href=\"fgfs-047.htm\">2010-01-17</a><br>");
sub compare_to_menu($$) {
    my ($ra,$inf) = @_;
    my $cnt = scalar @{$ra};
    pgm_exit(1,"ERROR: Can NOT open file [$inf]!\n") if (!open INF,"<$inf");
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Got $lncnt lines, from [$inf]...\n");
    my ($line,$file,$fcnt,$fnd,$val,$i,$fcnt2,$xcnt);
    my @files = ();
    my @files2 = ();
    my %dupes = ();
    my %found = ();
    my %missed = ();
    $fcnt = 0;
    $fcnt2 = 0;
    foreach $file (@{$ra}) {
        push(@files2,[$file,0]);
        $found{$file} = $fcnt2; # index into array
        $fcnt2++;
    }
    $fcnt = 0;
    foreach $line (@lines) {
        if ($line =~ /=\\"(.+)\\"/) {
            $file = $1;
            next if ($file =~ /^\./);
            if (!defined $dupes{$file}) {
                #prt("$file\n");
                $fnd = 0;
                $val = -1;
                if (defined $found{$file}) {
                    $val = $found{$file};
                    $fnd = 1;
                    $files2[$val][1] = 1;
                }
                push(@files, [$file, $fnd]);
                $fcnt++;
                $dupes{$file} = 1;
            }
        }
    }
    prt("Found $fcnt files in [$inf]...\n");
    $fnd = 0;
    for ($i = 0; $i < $fcnt; $i++) {
        $file = $files[$i][0];
        if ($files[$i][1] == 0) {
            $fnd++;
        }
    }
    if ($fnd) {
        prt("List $fnd of $fcnt NOT in directory...\n");
        for ($i = 0; $i < $fcnt; $i++) {
            $file = $files[$i][0];
            if ($files[$i][1] == 0) {
                prt("$file ");
            }
        }
        prt("\n");
    } else {
        prt("NONE of $fcnt NOT in directory...\n");
    }
    $fnd = 0;
    $xcnt = 0;
    for ($i = 0; $i < $fcnt2; $i++) {
        $file = $files2[$i][0];
        if ($files2[$i][1] == 0) {
            if ( defined $excluded_atlas{$file} || defined $excluded_others{$file} ) {
                $xcnt++;
            } else {
                $missed{$file} = 1;
                $fnd++;
            }
        }
    }
    if ($fnd) {
        prt("List $fnd of $fcnt2 NOT in js menu... excluding $xcnt in exclude lists\n");
        my @arr = sort keys(%missed);
        #for ($i = 0; $i < $fcnt2; $i++) {
        #    $file = $files2[$i][0];
        #    if ($files2[$i][1] == 0) {
        #        prt("$file ");
        #    }
        #}
        prt(join(" ",@arr)."\n");
    } elsif ($xcnt) {
        prt("NONE of $fcnt2 NOT in js menu... but excluding $xcnt in exclude lists\n");
    }

}


#   new item( "index.htm", "2006/07/31", "FlightGear Build Center Index" ),
sub compare_to_qlmenu($$) {
    my ($ra,$inf) = @_;
    my $cnt = scalar @{$ra};
    pgm_exit(1,"ERROR: Can NOT open file [$inf]!\n") if (!open INF,"<$inf");
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Got $lncnt lines, from [$inf]...\n");
    my ($line,$file,$fcnt2,$fnd,$val,$fcnt,$xcnt,$i);
    my @files = ();
    my @files2 = ();
    my %found = ();
    my %dupes = ();
    my %missed = ();
    $fcnt = 0;
    $fcnt2 = 0;
    foreach $file (@{$ra}) {
        push(@files2,[$file,0]);
        $found{$file} = $fcnt2; # index into array
        $fcnt2++;
    }
    foreach $line (@lines) {
        if ($line =~ /\(\s*"(.+)\.htm"/) {
            $file = $1.".htm";
            next if ($file =~ /^\./);
            if (!defined $dupes{$file}) {
                #prt("$file\n");
                $fnd = 0;
                $val = -1;
                if (defined $found{$file}) {
                    $val = $found{$file};
                    $fnd = 1;
                    $files2[$val][1] = 1;
                }
                push(@files, [$file, $fnd]);
                $fcnt++;
                $dupes{$file} = 1;
            }
        }
    }
    $fnd = 0;
    $xcnt = 0;
    for ($i = 0; $i < $fcnt2; $i++) {
        $file = $files2[$i][0];
        if ($files2[$i][1] == 0) {
            if ( defined $excluded_atlas{$file} || defined $excluded_others{$file} ) {
                $xcnt++;
            } else {
                $missed{$file} = 1;
                $fnd++;
            }
        }
    }
    if ($fnd) {
        prt("List $fnd of $fcnt2 NOT in js quick menu... excluding $xcnt in exclude lists\n");
        my @arr = sort keys(%missed);
        prt(join(" ",@arr)."\n");
    } elsif ($xcnt) {
        prt("NONE of $fcnt2 NOT in js quick menu... but excluding $xcnt in exclude lists\n");
    }


}

sub check_excludes($) {
    my ($ra) = @_;
    my @arr1 = keys %excluded_atlas;
    my @arr2 = keys %excluded_others;
    my $cnt1 = scalar @arr1;
    my $cnt2 = scalar @arr2;
    my $tot = $cnt1 + $cnt2;
    my @arr = ();
    push(@arr,@arr1);
    push(@arr,@arr2);
    my $cnt = scalar @arr;
    $cnt = scalar @{$ra};
    my ($itm,$file,$fnd,$missed);
    $missed = 0;
    foreach $itm (@arr) {
        $fnd = 0;
        foreach $file (@{$ra}) {
            if ($itm eq $file) {
                $fnd = 1;
                last;
            }
        }
        if (!$fnd) {
            prt("File $itm, in excludes NOT found in directory!\n");
            $missed++;
        }
    }
    if ($missed) {
        prtw("WARNING: Above $missed missed, should be REMOVED from excludes.\n");
    }

}

sub compare_to_index($$) {
    my ($ra,$inf) = @_;
    my $cnt = scalar @{$ra};
    pgm_exit(1,"ERROR: Can NOT open file [$inf]!\n") if (!open INF,"<$inf");
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Got $lncnt lines, from [$inf]...\n");
    my ($line,$i,$len,$j,$ch,$element,$inele,$href,$fcnt);
    my ($fcnt2,$file,$fnd,$val,$xcnt);
    $inele = 0;
    $element = '';
    my @files = ();
    $fcnt = 0;
    my %dupes = ();
    $fcnt2 = 0;
    my @files2 = ();
    my %found = ();
    foreach $file (@{$ra}) {
        push(@files2,[$file,0]);
        $found{$file} = $fcnt2; # index into array
        $fcnt2++;
    }
    for ($i = 0; $i < $lncnt; $i++) {
        $line = trim_all($lines[$i]);
        $len = length($line);
        next if ($len == 0);
        for ($j = 0; $j < $len; $j++) {
            $ch = substr($line,$j,1);
            if ($inele) {
                $inele = 0 if ($ch eq '>');
                $element .= $ch;
                if (!$inele) {
                    if (length($element)) {
                        if ($element =~ /href="(.+)"(\s|>)/) {
                            $href = $1;
                            if (($href =~ /^#/)||
                                ($href =~ /\//)) {
                                # skip these
                            } elsif ($href =~ /\.htm$/) {
                                if (!defined $dupes{$href}) {
                                    $dupes{$href} = 1;
                                    #prt("$href\n");
                                    $fnd = 0;
                                    if (defined $found{$href}) {
                                        $val = $found{$href};
                                        $fnd = 1;
                                        $files2[$val][1] = 1;
                                    }
                                    push(@files,[$href,$fnd]);
                                    $fcnt++;
                                }
                            }
                        }
                        $element = '';
                    }
                }
            } else {
                if ($ch eq '<') {
                    $element = $ch;
                    $inele = 1;
                }
            }
        }
        $element .= ' ' if ( length($element) && !($element =~ /(\s|=)$/) );
    }
    prt("Got $fcnt HREF files...\n");
    $fnd = 0;
    for ($i = 0; $i < $fcnt; $i++) {
        $file = $files[$i][0];
        if ($files[$i][1] == 0) {
            $fnd++;
        }
    }
    if ($fnd) {
        prt("List $fnd of $fcnt NOT in directory...\n");
        for ($i = 0; $i < $fcnt; $i++) {
            $file = $files[$i][0];
            if ($files[$i][1] == 0) {
                prt("$file ");
            }
        }
        prt("\n");
    } else {
        prt("NONE of $fcnt NOT in directory...\n");
    }
    # ===============================================
    $fnd = 0;
    $xcnt = 0;
    my %missed = ();
    for ($i = 0; $i < $fcnt2; $i++) {
        $file = $files2[$i][0];
        if ($files2[$i][1] == 0) {
            if ( defined $excluded_atlas{$file} || defined $excluded_others{$file} ) {
                $xcnt++;
            } else {
                $missed{$file} = 1;
                $fnd++;
            }
        }
    }
    if ($fnd) {
        prt("List $fnd of $fcnt2 NOT in [$inf]... excluding $xcnt in exclude lists\n");
        my @arr = sort keys(%missed);
        prt(join(" ",@arr)."\n");
    } elsif ($xcnt) {
        prt("NONE of $fcnt2 NOT in [$inf]... but excluding $xcnt in exclude lists\n");
    }

}

#########################################
### MAIN ###
my $ra = get_file_list($in_dir);
check_excludes($ra);
compare_to_menu($ra,$in_file);
compare_to_qlmenu($ra,$in_file2);
compare_to_index($ra,$in_file3);
pgm_exit(0,"Normal exit(0)");
########################################
# eof - chkfgmenu.pl
