#!/usr/bin/perl -w
# chkpath2.pl
# 01/03/2015 - More UI updates
# 18/05/2014 - Improve UI 0=not found, 1=found, others use error
use strict;
use warnings;

my ($dir,$sdir);
my $verbosity = 0;

sub VERB1() { return ($verbosity >= 1); }
sub VERB2() { return ($verbosity >= 2); }
sub VERB5() { return ($verbosity >= 5); }
sub VERB9() { return ($verbosity >= 9); }

sub prt($) { print shift; }

my $find_path = '';
my $ret = 0;
my $path_env = $ENV{"PATH"};

sub add_escape($) {
    my $txt = shift;
    my $ntxt = '';
    my $len = length($txt);
    my ($i,$ch);
    for ($i = 0; $i < $len; $i++) {
        $ch = substr($txt,$i,1);
        if ($ch eq '\\') {
            $ntxt .= '\\';
        } elsif ($ch eq ':') {
            $ntxt .= '\\';
        }
        $ntxt .= $ch;
    }
    return $ntxt;
}

sub same_dir($$) {
    my ($dir1,$dir2) = @_;
    my $len1 = length($dir1);
    my $len2 = length($dir2);
    return 0 if ($len1 != $len2);
    my ($i,$ch1,$ch2);
    for ($i = 0; $i < $len1; $i++) {
        $ch1 = uc(substr($dir1,$i,1));
        $ch2 = uc(substr($dir2,$i,1));
        return 0 if ($ch1 ne $ch2);
    }
    return 1;
}

sub give_help {
    prt("chkpath [options] path_to_find\n");
    prt("options:\n");
    prt(" --help (-h or -?) = This help and exit 0\n");
    prt(" --verb[n]    (-v) = Bump or set verbosity (0,1,2,5,9) def=$verbosity\n");
}

foreach $dir (@ARGV) {
    if ($dir =~ /^-/) {
        $sdir = $dir;
        $sdir = substr($sdir,1) while ($sdir =~ /^-/);
        if ($sdir =~ /^v/) {
            $verbosity++;
            if ($sdir =~ /^v.*(\d+)$/) {
                $verbosity = $1;
            } else {
                $sdir = substr($sdir,1);
                while ($sdir =~ /^v/) {
                    $sdir = substr($sdir,1);
                    $verbosity++;
                }
            }
        } elsif (($sdir =~ /^h/)||($sdir eq '?')) {
            give_help();
            exit 0;
        } else {
            prt("Unknown command [$dir]!\n");
            $ret = 3;   # set ERROR
            prt("Exit with [$ret]\n");
            exit $ret;
        }
    } else {
        $find_path = $dir;
        prt("Finding path [$find_path]\n") if (VERB5());
    }
}


if (defined $path_env) {
	my @folds = split(/;/,$path_env);
	my $fcnt = scalar @folds;
	prt( "Got $fcnt directories...\n" ) if (VERB5());
    my $dcnt = 0;
    my $len = length($find_path);
    my $find = add_escape($find_path);
    my $edir = '';
    my $msg = '';
    my $ccnt = '';
    foreach $dir (@folds) {
        $dcnt++;
        $ccnt = sprintf("%2d",$dcnt);
        if ( -d $dir) {
            $msg = 'ok';
        } else {
            $msg = 'NF!';
        }
        $edir = add_escape($dir);
        prt("$ccnt of $fcnt: Compare '$dir' with '$find_path'\n") if (VERB9());
        if ($len) {
            if (same_dir($dir,$find_path)) {
                $ret = 1;   # set SUCCESS
                prt("$ccnt of $fcnt: Found [$dir] $msg\n") if (VERB1());
                last;
            }
        } else {
            prt("$ccnt: [$dir] $msg\n");
        }
    }
}

if (length($find_path) == 0) {
    prt("Note: Given NO path to find...\n");
    $ret = 2;   # set ERROR
}
prt("Exit with [$ret]\n") if (VERB2());
exit $ret;

# eof
