#!/usr/bin/perl -w
# NAME: cleaninstall.pl
# AIM: QUITE SPECIALIZED During the install to the 3rdParty folder, a copy of what has 
# been installed is written to say C:\FG|17\3rdParty\installed.txt
# But multiple builds of a project adds multiple set of that project to this file
# This script reads the files, and attempts to remove 'duplicates'
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2013-03-16";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 1;
my $def_file = 'C:\FG\17\3rdParty\installed.txt';
my $tmp_out_file = $temp_dir.$PATH_SEP."tempinst.txt";

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

# file format - each entry is separated by a blank line, and and = project, like
# C:/FG/17/install/msvc100/simgear/include/simgear/sound/readwav.hxx
# 
# = flightgear Release install 19/11/2012 12:26:43.12 
# C:/FG/17/install/msvc100/flightgear/bin/fgjs.exe

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn,$hadblank,$tline,$len,$proj,@arr,$msg);
    my ($cfg,$time,$date,$key,$prevkey,$prjcnt,$remcnt,$ra);
    my %projects = ();
    $lnn = 0;
    $hadblank = 1;
    my @plines = ();
    my @order = ();
    $prevkey = '';
    $prjcnt = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        $tline = trim_all($line);
        $len = length($tline);
        if ($len == 0) {
            $hadblank = 1;
            next;
        }
        if ($line =~ /^=\s+/) {
            if ($hadblank) {
                if (length($prevkey)) {
                    $len = scalar @plines;
                    prt("$lnn: Store $prevkey, with $len lines...\n") if (VERB5());
                    $projects{$prevkey} = [ @plines ];
                    @plines = ();
                }
                $prjcnt++;
                $tline =~ s/^=\s+//;
                @arr = split(/\s+/,$tline);
                $proj = $arr[0];
                $cfg  = $arr[1];
                $time = $arr[-1];
                $date = $arr[-2];
                if ($proj =~ /\\/) {
                    $proj = fileparse($proj);
                }
                $key = "$proj:$cfg";
                $msg = 'NEW';
                if (defined $projects{$key}) {
                    $msg = 'REPEAT';
                } else {
                    $projects{$key} = 1;
                    push(@order,$key);
                }
                #prt("$lnn: $key $date $time [$tline]\n");
                prt("$lnn: $key $date $time [$msg]\n") if (VERB9());
                $prevkey = $key;
            } else {
                pgm_exit(1,"$lnn: ERROR: [$tline]\n");
            }
            $hadblank = 0;
        }
        push(@plines,$line);
    }
    if (length($prevkey)) {
        $len = scalar @plines;
        prt("$lnn: Store $prevkey, with $len lines...\n") if (VERB5());
        $projects{$prevkey} = [ @plines ];
        @plines = ();
    }

    @arr = keys %projects;
    $remcnt = scalar @arr;
    $len = scalar @order;
    prt("From $prjcnt, have $remcnt ($len) remaining...\n");
    $line = "\n";
    foreach $key (@order) {
        $ra = $projects{$key};
        foreach $tline (@{$ra}) {
            $line .= "$tline\n";
        }
        $line .= "\n";
    }
    write2file($line,$tmp_out_file);
    prt("Written to $tmp_out_file file...\n");
    if ($len == $remcnt) {
        prt("No blocks eliminated! Nothing 'new' to write...\n");
        return;
    }
    prt("Overwrite [$inf] file?\nOnly 'y' continues : ");
    $key = <STDIN>;
    chomp $key;
    if ($key eq 'y') {
        prt("That's a YES...\n");
        rename_2_old_bak($inf);
        write2file($line,$inf);
        prt("Results written to [$inf]\n");
    } else {
        prt("Aborting... not a 'y'. Got [$key]\n");
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_file($in_file);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if (VERB1());
        }
        shift @av;
    }

    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = $def_file;
        prt("Set DEFAULT input to [$in_file]\n");
        ##$load_log = 1;
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
