#!/usr/bin/perl -w
# NAME: cmp2dirs.pl
# AIM: Given TWO input directories, list and compare, and show difference
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.5 2015-01-09";
my $load_log = 0;
my $in_dir1 = '';
my $in_dir2 = '';
my $verbosity = 0;
my $out_file = '';
my $perl_hash = 0;

# ### DEBUG ###
my $debug_on = 1;
my $def_dir1 = 'D:\FG\fgaddon\Aircraft';
my $def_dir2 = 'X:\fgdata\Aircraft';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

sub get_dir($) {
    my $dir = shift;
    if (! opendir(DIR,$dir)) {
        pgm_exit(1,"ERROR: Can NOT open $dir\n");
    }
    my @files = readdir(DIR);
    closedir(DIR);
    my ($file,$ff,$cnt,$json,$ra);
    ut_fix_directory(\$dir);
    my %d = ();
    foreach $file (@files) {
        next if ($file eq '.');
        next if ($file eq '..');
        $ff = $dir.$file;
        if (-d $ff) {
            $d{$file} = 1;
        } elsif (-f $ff) {

        } else {

        }
    }
    return \%d;
}

sub nocase_sort {
    return (lc($a) cmp lc($b));
}


sub process_in_dirs() {
    my $rh1 = get_dir($in_dir1);
    my $rh2 = get_dir($in_dir2);
    my @arr1 = sort { "\L$a" cmp "\L$b" } keys(%{$rh1});
    my @arr2 = sort { "\L$a" cmp "\L$b" } keys(%{$rh2});
    my $cnt1 = scalar @arr1;
    my $cnt2 = scalar @arr2;
    my ($line,$msg,$cnt);
    $msg = '';
    $line = "Dir1 $in_dir1 has $cnt1 directories...\n";
    $msg .= $line;
    prt($line);
    $line = "Dir2 $in_dir2 has $cnt2 directories...\n";
    $msg .= $line;
    prt($line);
    my ($dir1,$dir2);
    my $samecnt = 0;
    my $new1 = 0;
    my $new2 = 0;
    my %newin1 = ();
    my %newin2 = ();
    foreach $dir1 (@arr1) {
        if (defined ${$rh2}{$dir1}) {
            $samecnt++;
        } else {
            $new1++;
            $newin1{$dir1} = 1;
        }
    }
    foreach $dir2 (@arr2) {
        if (defined ${$rh1}{$dir2}) {
            ####$samecnt++;
        } else {
            $new2++;
            $newin2{$dir2} = 1;
        }
    }

    $line = "Total $samecnt are the SAME, $new1 only in 1, $new2 only in 2\n";
    $msg .= $line;
    prt($line);
    @arr1 = sort nocase_sort keys(%newin1);
    @arr2 = sort nocase_sort keys(%newin2);
    if (@arr1) {
        if ($perl_hash) {
            $line = "my \%dir_one = (\n";
            $cnt = 0;
            foreach $dir1 (@arr1) {
                $line .= "    '$dir1' => 1";
                $line .= ',' if ($cnt < $new1);
                $line .= "\n";
                $cnt++;
            }
            $line .= "    );\n";
            prt($line);
            $msg .= $line;
        } else {
            $line = "New in 1: ".join(" ",@arr1)."\n";
            $msg .= $line;
            prt($line);
        }
    }
    if (@arr2) {
        if ($perl_hash) {
            $line = "my \%dir_two = (\n";
            $cnt = 0;
            foreach $dir1 (@arr2) {
                $line .= "    '$dir1' => 1";
                $line .= ',' if ($cnt < $new2);
                $line .= "\n";
                $cnt++;
            }
            $line .= "    );\n";
            prt($line);
            $msg .= $line;
        } else {
            $line = "New in 2: ".join(" ",@arr2)."\n";
            $msg .= $line;
            prt($line);
        }
    }
    if (length($out_file)) {
        write2file($msg,$out_file);
        prt("Results written to '$out_file'\n");
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_dirs();
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg,$cnt);
    my $verb = VERB2();
    $cnt = 0;
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                $verb = VERB2();
                prt("Verbosity = $verbosity\n") if ($verb);
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if ($verb);
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if ($verb);
            } elsif ($sarg =~ /^p/) {
                $perl_hash = 1;
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            if ($cnt == 0) {
                $in_dir1 = $arg;
                if (! -d $in_dir1) {
                    pgm_exit(1,"ERROR: Unable to 'stat' directory 1 $in_dir1!\n");
                }
                prt("Set input to [$in_dir1]\n") if ($verb);
            } elsif ($cnt == 1) {
                $in_dir2 = $arg;
                if (! -d $in_dir2) {
                    pgm_exit(1,"ERROR: Unable to 'stat' directory 2 $in_dir2!\n");
                }
                prt("Set input to [$in_dir2]\n") if ($verb);
            } else {
                pgm_exit(1,"Error: Already have 2 directories\n$in_dir1\n$in_dir2\nWhat is THIS $arg!\n");
            }
            $cnt++;
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if (length($in_dir1) ==  0) {
            $in_dir1 = $def_dir1;
            prt("Set DEFAULT input 1 to [$in_dir1]\n");
            if (! -d $in_dir1) {
                pgm_exit(1,"ERROR: Unable to 'stat' directory 1 $in_dir1!\n");
            }
        }
        if (length($in_dir2) ==  0) {
            $in_dir2 = $def_dir2;
            prt("Set DEFAULT input 2 to [$in_dir2]\n");
            if (! -d $in_dir2) {
                pgm_exit(1,"ERROR: Unable to 'stat' directory 2 $in_dir2!\n");
            }
        }
        $perl_hash = 1;
        $load_log = 1;
    }
    if (length($in_dir1) ==  0) {
        pgm_exit(1,"ERROR: No input directories found in command!\n");
    }
    if (length($in_dir2) ==  0) {
        pgm_exit(1,"ERROR: No 2nd input directory found in command!\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-dir1 in_dir2\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
    prt(" --perl        (-p) = Output the differents dirs in a perl hash.\n");
    prt(" Compare the sub-directories in two given directories, and report same\n");
    prt(" count, and show new in 1 and new in 2, if any.\n");
}

# eof - template.pl
