#!/usr/bin/perl -w
# NAME: cmp3json.pl
# AIM: VERY SPEICIFIC just to compare the files in two directories
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.2 2014-01-13";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 0;
my $def_file = 'def_file';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

my $dir_count = 0;
my $file_count = 0;

sub get_three_js_files($$$);

sub get_three_js_files($$$) {
    my ($dir,$ra,$lev) = @_;
    if (!opendir(DIR,"$dir")) {
        prt("Failed to open dir $dir!\n");
        return;
    }
    $dir_count++;
    my @files = readdir(DIR);
    close(DIR);
    my ($file,$ff);
    ut_fix_directory(\$dir);
    my @dirs = ();
    prt("Processing directory $dir...\n") if ($lev == 0);
    foreach $file (@files) {
        next if ($file eq '.');
        next if ($file eq '..');
        $ff = $dir.$file;
        if (-d $ff) {
            push(@dirs,$ff)
        } elsif (-f $ff) {
            $file_count++;
            if ($file =~ /\.js$/) {
                push(@{$ra},[ $file, $ff ]);
            }
        } else {
            pgm_exit(1,"What is this $ff!\n");
        }
    }
    foreach $dir (@dirs) {
        get_three_js_files($dir,$ra,($lev + 1));
    }
}





sub check_files() {
    my $dir1 = 'F:\FGX\fgx-aircraft';
    my $dir2 = 'C:\OSGeo4W\apache\htdocs\map-test2\ac';
    #    $lev = scalar @ac_files;
    #    prt("Processed $dir_count dirs, $excl_dir_cnt excluded, $file_count files, $excl_files excluded, and found $lev .ac files...\n");
    #    write2file(join("\n",@ac_files)."\n",$out_file);
    #    prt("List written to $out_file...\n");
    my @js1 = ();
    my @js2 = ();
    my @nf1 = ();
    my @nf2 = ();
    my ($dc1,$fc1,$dc2,$fc2,$jc1,$jc2,$i1,$i2,$f1,$f2,$ff1,$ff2,$fnd,$ra1,$ra2);
    $dir_count = 0;
    $file_count = 0;
    get_three_js_files($dir1,\@js1,0);
    $dc1 = $dir_count;
    $fc1 = $file_count;
    $jc1 = scalar @js1;
    $dir_count = 0;
    $file_count = 0;
    get_three_js_files($dir2,\@js2,0);
    $dc2 = $dir_count;
    $fc2 = $file_count;
    $jc2 = scalar @js2;
    my $same1 = 0;
    my $same2 = 0;
    prt("dir1: $dir1: $dc1 dirs, $fc1 files, found $jc1 three.js\n");
    prt("dir2: $dir2: $dc2 dirs, $fc2 files, found $jc2 three.js\n");
    for ($i1 = 0; $i1 < $jc1; $i1++) {
        $ra1 = $js1[$i1]; 
        $f1  = ${$ra1}[0];
        $ff1 = ${$ra1}[1];
        $fnd = 0;
        for ($i2 = 0; $i2 < $jc2; $i2++) {
            $ra2 = $js2[$i2]; 
            $f2  = ${$ra2}[0];
            $ff2 = ${$ra2}[1];
            if ($f1 eq $f2) {
                $same1++;
                $fnd = 1;
                last;
            }
        }
        if ($fnd > 0) {
        } else {
            #push(@nf1,$ra1);
            push(@nf1,$f1);
        }
    }
    for ($i2 = 0; $i2 < $jc2; $i2++) {
        $ra2 = $js2[$i2]; 
        $f2  = ${$ra2}[0];
        $ff2 = ${$ra2}[1];
        $fnd = 0;
        for ($i1 = 0; $i1 < $jc1; $i1++) {
            $ra1 = $js1[$i1]; 
            $f1  = ${$ra1}[0];
            $ff1 = ${$ra1}[1];
            if ($f1 eq $f2) {
                $same2++;
                $fnd = 1;
                last;
            }
        }
        if ($fnd > 0) {
        } else {
            #push(@nf2,$ra2);
            push(@nf2,$f2);
        }
    }
    $fc1 = scalar @nf1;
    $fc2 = scalar @nf2;
    prt("Same name $same1, $same2\n");
    prt("In dir1, $fc1 NOT found in 2\n");
    prt(join(" ",@nf1)."\n");
    prt("In dir2, $fc2 NOT found in 1\n");
    prt(join(" ",@nf2)."\n");

}

#########################################
### MAIN ###
#parse_args(@ARGV);
#process_in_file($in_file);
check_files();
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    my $verb = VERB2();
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                $verb = VERB2();
                prt("Verbosity = $verbosity\n") if ($verb);
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if ($verb);
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if ($verb);
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if ($verb);
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if (length($in_file) ==  0) {
            $in_file = $def_file;
            prt("Set DEFAULT input to [$in_file]\n");
        }
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
