#!/perl -w
# NAME: cmpexports.pl
# AIM: Given two DLL files, run 'dumpbin /EXPORTS <DLL>' on each,
# and compare the results...
# 7/9/2009 - geoff mclane - http://geoffair.net/mperl/
#
use strict;
use warnings;
use Cwd;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hello, World ... MUST RUN vcvarsall x86 first\n" );

my $dump_dir = 'C:\Program Files\Microsoft Visual Studio 9.0\VC\bin';
my $dump_file = 'dumpbin.exe';
my $dump = "$dump_dir\\$dump_file";

if (! -f $dump) {
	prt("ERROR: can not locate [$dump]...\n");
	exit(1);
}

my $file1 = 'C:\Windows\System32\glu32.dll';
my $file2 = 'C:\DTEMP\temp\lib\glu32.dll';
my $tmpf1 = 'C:\tmp\temp1.txt';
my $tmpf2 = 'C:\tmp\temp2.txt';

if (! -f $file1) {
	prt("ERROR: can not locate [$file1]...\n");
	exit(1);
}

if (! -f $file2) {
	prt("ERROR: can not locate [$file2]...\n");
	exit(1);
}

my $pwd = cwd();
prt( "Current directory: [$pwd]\n" );
chdir( $dump_dir );
my $newpwd = cwd();
prt( "New directory: [$newpwd]\n" );
if (! -f $dump_file) {
	prt("ERROR: can not locate [$dump_file]...\n");
	exit(1);
}

#if (system("$dump_file /EXPORT $file1 > $tmpf1")) {
	#my @lines1 = <IN1>;
	#close(IN1);
	#prt(@lines1);
#} else {
#	prt("ERROR: could not run dump!\n");
#	exit(1);
#}

chdir($pwd);
my $last_dir = cwd();
prt( "Last directory: [$last_dir]\n" );

close_log($outfile,0);
exit(0);

# eof
