#!/perl -w
# NAME: cmpvcprojs02.pl
# AIM: This is a COMPLETE rewrite of cmpvcprojs.pl
# Just to load, and compare two vcproj files
# 2010/04/23  - geoff mclane - http://geoffair.net/mperl/
use strict;
use warnings;
use File::Basename;
use Cwd;
unshift(@INC, 'C:\GTools\perl');
require 'fgutils02.pl' or die "Unable to load fgutils02.pl ...\n";
require 'fgdsphdrs03.pl' or die "Unable to load fgdsphdrs03.pl ...\n";
require 'scanvc.pl' or die "Unable to load scanvc.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $perl_dir = 'C:\GTools\perl';
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $debug_on = 0;
my $def_fil1 = 'C:\Projects\fltk-1.1.10\vc2005\fltk.lib.vcproj';
my $def_fil2 = 'C:\Projects\fltk-1.1.10\vc2005\fltkdll.vcproj';
#my $def_fil1 = 'C:\FG\Atlas\Atlas-0.4.3\projects\msvc\Atlas.vcproj';
#my $def_fil2 = 'C:\FG\Atlas\Atlas-0.4.3\projects\msvc\trash\Atlas.vcproj';
my $load_log = 0;
my $in_file1 = '';
my $in_file2 = '';

### program variables
my @warnings = ();
my $cwd = cwd();
my $dbg_cmp_01 = 0; # show FULL list

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg)
    }
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub show_warnings() {
   if (@warnings) {
      prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
      foreach my $itm (@warnings) {
         prt("$itm\n");
      }
      prt("\n");
   } else {
      prt( "\nNo warnings issued.\n\n" );
   }
}

sub compare_vc_hashes($$$$) {
    my ($rh1,$rh2,$fil1,$fil2) = @_;
    prt("Compare 1[$fil1]\n with   2[$fil2]\n");
    if ($dbg_cmp_01) {
        show_hash_results3($rh1);
        show_hash_results3($rh2);
        prt("Compare 1[$fil1]\n with   2[$fil2]\n");
    }
    my ($key,$val1,$val2,$cnt1,$cnt2,$i,$j,$fnd,$cnt);
    my ($src1,$grp1,$flt1);
    my ($src2,$grp2,$flt2);
    my ($rsb1,@karr1,$scnt1);
    my ($rsb2,@karr2,$scnt2);
    my ($ky1,$v1,$ky2,$v2);
    my %done = ();
    my %source_shown1 = ();
    my %source_shown2 = ();
    foreach $key (keys %{$rh1}) {
        $val1 = ${$rh1}{$key};
        if ( $key =~ /^CURR_/ ) {
            # ignore these CURRENT state items
        } else {
            if (defined ${$rh2}{$key}) {
                $val2 = ${$rh2}{$key};
                if ($key eq 'PROJECT_SRCS') {
                    # compare source list array ref val1 and val2
                    prt("\nKEY: $key - compare...\n");
                    $cnt1 = scalar @{$val1};
                    $cnt2 = scalar @{$val2};
                    if ($cnt1 == $cnt2) {
                        prt("Have same number of sources $cnt1\n");
                    } else {
                        prt("Have DIFFERENT source counts $cnt1 vs $cnt2\n");
                    }
                    $cnt = 0;
                    prt("Finding $cnt1 file 1 sources in file 2 $cnt2 sources...\n");
                    for ($i = 0; $i < $cnt1; $i++) {
                        $src1 = ${$val1}[$i][0];
                        $grp1 = ${$val1}[$i][1];
                        $flt1 = ${$val1}[$i][2];
                        $fnd = 0;
                        for ($j = 0; $j < $cnt2; $j++) {
                            $src2 = ${$val2}[$j][0];
                            $grp2 = ${$val2}[$j][1];
                            $flt2 = ${$val2}[$j][2];
                            if ($src1 eq $src2) {
                                $fnd = 1;
                                last;
                            }
                        }
                        if (!$fnd) {
                            if (defined $source_shown1{$src1}) {
                                $source_shown1{$src1}++;
                            } else {
                                prt("[$src1] [$grp1] [$flt1] not found in file 2\n");
                                $source_shown1{$src1} = 1;
                            }
                            $cnt++;
                        }
                    }
                    if ($cnt) {
                        foreach $ky1 (keys %source_shown1) {
                            $v1 = $source_shown1{$ky1};
                            if ($v1 > 1) {
                                prt("Source [$ky1] listed $v1 times...\n");
                            }
                        }
                        prt("Result:1: $cnt source NOT found in 2\n");
                    } else {
                        prt("Result:1: All source 1 found in 2\n");
                    }
                    $cnt = 0;
                    prt("Finding $cnt2 file 2 sources in file 1 $cnt1 sources...\n");
                    for ($j = 0; $j < $cnt2; $j++) {
                        $src2 = ${$val2}[$j][0];
                        $grp2 = ${$val2}[$j][1];
                        $flt2 = ${$val2}[$j][2];
                        $fnd = 0;
                        for ($i = 0; $i < $cnt1; $i++) {
                            $src1 = ${$val1}[$i][0];
                            $grp1 = ${$val1}[$i][1];
                            $flt1 = ${$val1}[$i][2];
                            if ($src1 eq $src2) {
                                $fnd = 1;
                                last;
                            }
                        }
                        if (!$fnd) {
                            if (defined $source_shown2{$src2}) {
                                $source_shown2{$src2}++;
                            } else {
                                prt("[$src2] [$grp1] [$flt1] not found in file 1\n");
                                $source_shown2{$src2} = 1;
                            }
                            $cnt++;
                        }
                    }
                    if ($cnt) {
                        foreach $ky2 (keys %source_shown2) {
                            $v2 = $source_shown2{$ky2};
                            if ($v2 > 1) {
                                prt("Source [$ky2] listed $v2 times...\n");
                            }
                        }
                        prt("Result:2: $cnt sources NOT found in 1\n");
                    } else {
                        prt("Result:2: All source 2 found in 1\n");
                    }
                } elsif ($key eq 'PROJECT_CFGS') {
                    prt("\nKEY: $key - compared...\n");
                    $cnt1 = scalar @{$val1};
                    $cnt2 = scalar @{$val2};
                    if ($cnt1 == $cnt2) {
                        prt("Have same number of configs $cnt1\n");
                    } else {
                        prt("Have DIFFERENT config counts $cnt1 vs $cnt2\n");
                    }
                    # my $rcfgs = ${$rh}{'PROJECT_CFGS'};
                    #                   0       1      2      3
                    # push(@{$rcfgs}, [ $pname, $var1, $conf, $dsp_sub_sub ]);
                    #  -NEW_INCS- = [/I "." /I "..\include"]
                    $cnt = 0;
                    for ($i = 0; $i < $cnt1; $i++) {
                        $src1 = ${$val1}[$i][0];
                        $grp1 = ${$val1}[$i][1];
                        $flt1 = ${$val1}[$i][2];
                        $rsb1 = ${$val1}[$i][3];
                        @karr1 = keys(%{$rsb1});
                        $scnt1 = scalar @karr1;
                        $fnd = 0;
                        for ($j = 0; $j < $cnt2; $j++) {
                            $src2 = ${$val2}[$j][0];
                            $grp2 = ${$val2}[$j][1];
                            $flt2 = ${$val2}[$j][2];
                            $rsb2 = ${$val2}[$j][3];
                            @karr2 = keys(%{$rsb2});
                            $scnt2 = scalar @karr2;
                            if ($src1 eq $src2) {
                                $fnd = 1;
                                foreach $ky1 (@karr1) {
                                    $v1 = ${$rsb1}{$ky1};
                                    #if ($ky1 eq '-NEW_INCS-') {
                                    #foreach $ky2 (@karr2) {
                                    if (defined ${$rsb2}{$ky1}) {
                                        $v2 = ${$rsb2}{$ky1};
                                        if ($v1 ne $v2) {
                                            prt("Ky [$ky1] DIFFERENT file 1=[$v1] 2=[$v2]\n");
                                        }
                                    } else {
                                        prt("Ky [$ky1] = [$v1] NOT found in 2\n");
                                    }
                                }
                                last;
                            }
                        }
                        if (!$fnd) {
                            prt("[$src1] [$grp1] [$flt1] not found in file 2\n");
                            $cnt++;
                        }
                    }
                } else {
                    prt("KEY: $key - no results shown\n");
                }
            } else {
                prt("Key [$key] NOT in file1 hash\n");
            }
        }
        $done{$key} = 1;
    }
    foreach $key (keys %{$rh2}) {
        next if (defined $done{$key});
        $val2 = ${$rh2}{$key};
        if ( $key =~ /^CURR_/ ) {
            # ignore these CURRENT state items
        } else {
            prt("Key [$key] NOT in file2 hash\n");
        }
    }
    prt("EndComp 1[$fil1]\n with   2[$fil2]\n");
}


sub compare_files($$) {
    my ($inf1,$inf2) = @_;
    my $rh1 = process_VCPROJ3($inf1);
    my $rh2 = process_VCPROJ3($inf2);
    compare_vc_hashes($rh1,$rh2,$inf1,$inf2);
}

#########################################
### MAIN ###
#prt( "$pgmname: in [$cwd]: Hello, World...\n" );
parse_args(@ARGV);
compare_files($in_file1,$in_file2);
pgm_exit(0,"Normal exit(0)");
########################################
sub give_help() {
    my $help = <<EOF;
$pgmname: version 0.0.1 2010-04-23
Usage: $pgmname [options] in_file1 in_file2
Options:
  -h (-?) = This help.
  -l      = Load log at end
  -d      = Set debug flag for full output.
The two input files will be treated as vcproj files,
and their contents compared.
EOF
    prt($help);
}

sub parse_args {
    my (@av) = @_;
    my $cnt = 0;
    while (@av) {
        my $arg = $av[0];
        if ($arg =~ /^-/) {
            my $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            my $ch = substr($sarg,0,1);
            if (($ch =~ /^h/i)||($ch eq '?')) {
                give_help();
                pgm_exit(0,"HELP exit(0)\n");
            } elsif ($ch =~ /^l/i) {
                $load_log = 1;
            } elsif ($ch =~ /^d/i) {
                $dbg_cmp_01 = 1;
            } else {
                pgm_exit(1,"ERROR: Unknonw argument [$arg]! Try -?\n");
            }
        } else {
            if ($cnt == 0) {
                $in_file1 = $arg;
            } elsif ($cnt == 1) {
                $in_file2 = $arg;
            } else {
                pgm_exit(1,"ERROR: Only 2 input file names allowed\n");
            }
            $cnt++;
        }
        shift @av;
    }
    if ($debug_on) {
        $in_file1 = $def_fil1 if (length($in_file1) == 0);
        $in_file2 = $def_fil2 if (length($in_file2) == 0);
        $load_log = 1;
    }
    if (length($in_file1) && length($in_file2)) {
        if (! -f $in_file1) {
            pgm_exit(1,"ERROR: Can NOT locate [$in_file1]! Check name, location\n");
        }
        if (! -f $in_file2) {
            pgm_exit(1,"ERROR: Can NOT locate [$in_file2]! Check name, location\n");
        }
    } else {
        pgm_exit(1,"ERROR: Must give 2 valid input file names!\n");
    }
}

# eof - template.pl
