#!/perl -w
# NAME: def2stg.pl
# AIM: Read an input file ...
# search for '#define ABC	<something>
# output a WMSTR val, stg, 0 for each item ...
# geoff mclane - http://geoffmclane.com/mprel/index.htm - 20070408
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
my $pgmname = $0;
# log file stuff
my ($LF);
my $outfile = 'temp.'.$pgmname.'.txt';
if ($pgmname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgmname);
	$pgmname = $tmpsp[-1];
	$outfile = 'temp.$pgmname.txt';
}
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );
# default variable values
my $fileout = "tempout.txt";
my $filein = "G:\\GTools\\Tools\\mirror\\resource.h";
# debug
my $dbg1 = 0;	# show discarded items
# program variables
my @lines = ();
my $line = '';
my ($IF, $OF);
my $cnt = 0;
my @defines = ();
my @ifslist = ();
# run program
parse_args(@ARGV);
if ( ! -f $filein) {
	mydie( "ERROR: Can NOT locate [$filein] ...\n" );
}

open $IF, "<$filein" or mydie( "ERROR: Unable to open $filein ... $! ...\n" );
@lines = <$IF>;
close $IF;
$cnt = scalar @lines;
prt( "Processing $cnt lines from $filein ...\n" );
foreach $line (@lines) {
	$line = trim_all($line);
	if (substr($line,0,1) eq '#') {
		$line = trim_all( substr($line,1) );
		if ($line =~ /^define\s+(.*)\s+.*/) {
			if (@ifslist) {
				prt( "WARNING: Discards since in IF $ifslist[-1] ... [$line] ...\n" ) if ($dbg1);
			} else {
				push(@defines, $1);
			}
		} elsif ($line =~ /^ifdef\s+(.*)/) {
			push(@ifslist, $1);	# #ifdef APSTUDIO_INVOKED
		} elsif ($line =~ /^ifndef\s+(.*)/) {
			push(@ifslist, $1);	# #ifndef APSTUDIO_READONLY_SYMBOLS
		} elsif ($line =~ /^endif/) {
			if (@ifslist) {
				pop( @ifslist );
			} else {
				prt( "WARNING: Got ENDIF with no IF [$line] ...\n" );
			}
		}
	}
}
$cnt = scalar @defines;
if ($cnt) {
	prt( "Processing $cnt defines found ...\n" );
	open $OF, ">$fileout" or mydie( "ERROR: Unable to create $fileout ...\n" );
	print $OF "#ifdef   ADD_RESOURCE_DATA\n";
	print $OF "\n";
	print $OF "WMSTR sDefines[] = {\n";
	foreach $line (@defines) {
		print $OF "   { $line, \"$line\", 0 },\n";
	}
	print $OF "   { 0,          0,            0 }\n";
	print $OF "};\n";
	print $OF "\n";
	print $OF <<"EOF";
PTSTR Get_ID_Stg( UINT id )
{
   PWMSTR pwms = &sDefines[0];
   while( pwms->w_lpStg ) {
      if ( pwms->w_uiMsg == id )
         return pwms->w_lpStg;
      pwms++;
   }
   return NULL;
}

#endif // #ifdef   ADD_RESOURCE_DATA"
EOF
	
	prt( "Written $cnt to $fileout ...\n" );
	close $OF;
	system( $fileout );
} else {
	prt( "WARNING: Failed to find ANY 'defines' in $filein ...\n" );
}

close_log($outfile,0);
exit(0);

sub give_help {
	prt( "$pgmname [options] in_file\n" );
	prt( "options:\n" );
	prt( "-out=file_out - Name the ouput file. (def=$fileout)\n" );
	mydie( "                                         Happy Output...\n" );
}

sub parse_args {
	my (@av) = @_;
	while (@av) {
		my $arg = shift @av;
		if ($arg =~ /\?/) {
			give_help();
		} elsif (substr($arg,0,1) ne '-') {
			$filein = $arg;
			prt( "In file set to $filein ...\n" );
		} elsif ($arg =~ /^-out=(.*)/ ) {
			$fileout = $1;
			prt( "Out file set to $fileout ...\n" );
		} else {
			mydie( "ERROR: Unknonw input [$arg] ... Use ? for breif help.\n" );
		}
	}
}

# eof - def2stg.pl
