#!/usr/bin/perl -w
# NAME: epoch2date.pl
# AIM: Convert unix epoch seconds to date...
# 15/12/2013 - Show offset of 'local' from UTC
# 18/03/2013 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use DateTime;
use DateTime::TimeZone;
use Time::Local;
use Data::Dumper;
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}

# user variables
my $VERS = "0.0.1 2013-03-17";

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    exit($val);
}


#########################################
### MAIN ###
parse_args(@ARGV);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg,$cnt,$dt,$tmp);
    $cnt = 0;
    my $epoch = 0;
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $sarg = lu_get_YYYYMMDD_hhmmss_UTC($arg);
            prt("Epoch sec $arg is $sarg UTC\n");
            $sarg = lu_get_YYYYMMDD_hhmmss($arg);
            prt("Epoch sec $arg is $sarg LOCAL\n");
            $epoch = $arg;
            $cnt++;
        }
        shift @av;
    }
    if ($cnt == 0) {
        pgm_exit(1,"Give epoch seconds to convert to date...\n");
    } else {
        $dt = DateTime->now(); # same as ( epoch => time() )
        #$arg = $dt->time_zone_long_name();
        #$sarg = $dt->time_zone_short_name();
        my $tz = DateTime::TimeZone->new( name => 'local' );
        ###my $tz = DateTime::TimeZone->new( name => 'America/Los_Angeles' );
        my $offset = $tz->offset_for_datetime($dt) / 36;
        if (($offset =~ /^\+/)||($offset =~ /^-/)) {
            $tmp = $offset;
        } else {
            if ($offset >= 0) {
                $tmp = sprintf("+%d",$offset);
            } else {
                $tmp = sprintf("%d",$offset);
            }
        }
        prt("LOCAL Offset from UTC: $tmp (Hrs*100) ");
        # ==============================================
        # another way, maybe
        my @t = localtime($epoch);
        my $gmt_offset = (timegm(@t) - timelocal(@t)) / 36;
        if (($gmt_offset =~ /^\+/)||($gmt_offset =~ /^-/)) {
            $tmp = $gmt_offset;
        } else {
            if ($gmt_offset >= 0) {
                $tmp = sprintf("+%d",$gmt_offset);
            } else {
                $tmp = sprintf("%d",$gmt_offset);
            }
        }
        prt(" or $tmp\n");

        # to see a list of all valid names
        #$tmp = DateTime::TimeZone->all_names;
        #prt(Dumper($tmp));

    }

}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname epoch-secs\n");
}

# eof - template.pl
