@REM 2011-10-20 - Clone or update ALL aircraft...
@setlocal
@set TEMPF=%1
@set TEMPD=%2
@if "%~1x" == "x" (
@goto HELP
)
@if "%~2x" == "x" (
@goto HELP
)
@if NOT EXIST %TEMPF% (
@echo ERROR: Can NOT locate aircraft list file %TEMPF%!
@goto HELP
)
@if NOT EXIST %TEMPD%\. (
@echo ERROR: Can NOT locate aircraft output directory %TEMPD%!
@goto HELP
)

@echo Watch for git errors, and note failures, and repeat those at end...
@echo Moment, counting the aircraft to process...
@set TEMPC=0
@for /F "tokens=*" %%i in (%TEMPF%) do @(call :DOCNT %%i)
@echo Got %TEMPC% aircraft to process...
@echo *** CONTINUE? *** Only Ctrl+c to abort. All other keys continue...
@pause

@for /F "tokens=*" %%i in (%TEMPF%) do @(call :DOAIR %%i)

@goto END

:DOCNT
@if "%1x" == "x" goto :EOF
@set /A TEMPC+=1
@goto :EOF


:DOAIR
@if "%1x" == "x" goto :EOF
@setlocal
@cd %TEMPD%
@if EXIST %1\. (
@echo Updating %1 ... doing call git pull
@cd %1
@call git pull
) else (
@echo Cloning %1 ... doing call git clone git://gitorious.org/flightgear-aircraft/%1.git %1
@call git clone git://gitorious.org/flightgear-aircraft/%1.git %1
@if NOT EXIST %1\. (
@echo WARNING: Appears git clone FAILED! Make a note...
@pause
)
)
@endlocal
@goto :EOF

:HELP
@echo.
@echo Usage: %0 listfile target
@echo.
@echo listfile File with names to manage. One aircraft per line
@echo target   Base output directory
@echo.
@goto END


:END
@endlocal

