#!/perl -w
# NAME: fgmerge.pl
# AIM: SPECIALISED: Take two files - NEW and OLD, and merge the content
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
unshift(@INC, 'C:\GTools\perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $perl_dir = 'C:\GTools\perl';
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 0;
### NOTE ### THIS SHOULD BE OFF
my $do_debug = 0;
###############################

my $def_file1 = 'C:\HOMEPAGE\FG\Docs\getstart\temp.html';
my $def_file2 = 'C:\HOMEPAGE\FG\Docs\getstart\temp2.html';
my $def_out   = $perl_dir."\\tempfil2.html";
my $in_file1 = '';
my $in_file2 = '';
my $out_file = '';

### program variables
my @warnings = ();
my $cwd = cwd();

# DEBUG
my $dbg01 = 0;
my $dbg02 = 0;
my $dbg03 = 0;
my $tmpfil1 = $perl_dir."\\tempfil1.txt";
my $dbg04 = 0; # prt("[dbg04] $lnn:$cnt: $head ($i)\n") if ($dbg04); and MORE...
my $dbg05 = 0; # prt("[dbg05] [$key]=\"[$val]\"\n") if ($dbg05);
my $dbg06 = 0; # prt( "[dbg06] 'height' from [".${$ihr}{$key}."] to [$val]\n") if ($dbg06); and width
my $dbg07 = 0; # prt("[dbg07] $lnn: Deal with $bgnoff:$endoff:[$head]+[$nimg]!\n") if ($dbg07);
my $dbg08 = 0; # prt("[dbg08] $ii: Set NEW [$oline] cf=[$tail]\n") if ($dbg08);
my $dbg09 = 0; # prt("[dbg09] $lnn: No image tag change required...[$oline] [$nimg]\n") if ($dbg09);
my $dbg10 = 0; # prt("[dbg10] $ii: TABLE NEW [$oline] cf=[$tail]\n") if ($dbg10);
my $dbg11 = 0; # prt("[dbg11] Trailing = [$tail]\n") if ($dbg11); AND prt("[dbg11] [$key]=\"[$val]\"\n") if ($dbg11);
my $dbg12 = 0; # prt("[dbg12] $lnn: Table at $bgnoff:$endoff:[$head]+[$nimg]!\n") if ($dbg12);

my $dbg38 = 0; # prt( "[dbg38] Got [$hr2] = [$txt] [$fil]\n" ) if ($dbg38);
my $dbg39 = 0; # prt( "[dbg39] Got [$hr2] = [$txt] - no inverted commas! [$fil]\n" ) if ($dbg39);

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg)
    }
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub show_warnings() {
   if (@warnings) {
      prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
      foreach my $itm (@warnings) {
         prt("$itm\n");
      }
      prt("\n");
   } else {
      prt( "\nNo warnings issued.\n\n" );
   }
}

sub get_img_hash_ref($$$$) {
   my ($fank,$fil,$xml,$dbg) = @_;
   my %hash = ();
   my ($ank,$len,$i,$ch,$pc,$hr2,$txt,$tail);
   # 2010/04/06 - add 'i' case insensitive; 's' to treat as single line;
   if ($fank =~ /^<img\s+(.+)>{1}(.*)$/is) {
      $ank = trim_all($1);
      $tail = $2;
      $ank =~ s/\/$//;  # 2010/04/06 - remove any trailing '/'
      $ank = trim_all($ank);    # and trim again
      $len = length($ank);
      $ch = '';
      $hr2 = '';
      for ($i = 0; $i < $len; $i++) {
         $pc = $ch;
         $ch = substr($ank,$i,1);
         if ($ch =~ /\w/) {
            $hr2 .= $ch;   # accumulate \w chars - alphanumeric, including _
         } elsif (length($hr2)) {
            if (($ch ne '=') && ($ch =~ /\s/)) {
               $i++;
               for (; $i < $len; $i++) {
                  $ch = substr($ank,$i,1);
                  last if ($ch eq '=');
                  last if !($ch =~ /\s/);
               }
            }
            if ($ch eq '=') {
               # found our equal sign
               $i++; # move on...
               for (; $i < $len; $i++) {
                  $ch = substr($ank,$i,1);
                  last if ($ch =~ /('|")/);
                  last if !($ch =~ /\s/);
               }
               if (($ch eq '"')||($ch eq "'")) {
                  $pc = $ch;
                  $i++; # move on...
                  $txt = '';
                  for (; $i < $len; $i++) {
                     $ch = substr($ank,$i,1);
                     last if ($ch eq $pc);
                     $txt .= $ch;
                  }
                  if ($ch eq $pc) {
                     $hr2 = lc($hr2) if ($xml);
                     $hash{$hr2} = $txt;
                     prt( "[dbg38] Got [$hr2] = [$txt] [$fil]\n" ) if ($dbg38);
                  } else {
                     prtw("PROBLEM: got [$hr2]. At pos $i in [$ank], from [$fank], and NO END INVERTED COMMA! ($pc) [$fil]\n");
                     pgm_exit(1,"get_img_hash_ref: FAILED!") if ($dbg);
                  }
               } else {
                  if (($ch =~ /\w/) && (($hr2 =~ /name/i)||($hr2 =~ /id/i))) {
                     # accept these WITHOUT inverted comma
                     $txt = $ch;
                     $i++; # MOVING ON
                     for (; $i < $len; $i++) {
                        $ch = substr($ank,$i,1);
                        last if !($ch =~ /\w/);
                        $txt .= $ch;
                     }
                     $hr2 = lc($hr2) if ($xml);
                     $hash{$hr2} = $txt;
                     prt( "[dbg39] Got [$hr2] = [$txt] - no inverted commas! [$fil]\n" ) if ($dbg39);
                  } else {
                     prtw("PROBLEM: got [$hr2]. At pos $i in [$ank], from [$fank], and NO START INVERTED COMMA! [$fil]\n");
                     pgm_exit(1,"get_img_hash_ref: FAILED!") if ($dbg);
                  }
               }
            } else {
               prtw("PROBLEM: got [$hr2]. At pos $i in [$ank], from [$fank], and NO EQUAL SIGN! [$fil]\n");
               pgm_exit(1,"get_img_hash_ref: FAILED!") if ($dbg);
            }
            $hr2 = '';
         }
      }
   } else {
       prtw("PROBLEM: [$fank] FAILED initial image test regex! [$fil]\n");
       pgm_exit(1,"get_img_hash_ref: FAILED!") if ($dbg);
   }
   $hash{'_TRAILING_'} = $tail if (length($tail));
   return \%hash;
}

sub get_table_element($$) {
    my ($txt,$rt) = @_;
    my $len = length($txt);
    my $ttx = '';
    my ($ch,$t);
    for ($t = 0; $t < $len; $t++) {
        $ch = substr($txt,$t,1);
        if ($ch eq '>') {
            $t++;
            last;
        }
        $ttx .= $ch;
    }
    ${$rt} = substr($txt,$t);
    return $ttx;
}

sub get_table_hash_ref($$$$) {
   my ($fank,$fil,$xml,$dbg) = @_;
   my %hash = ();
   my ($ank,$len,$i,$ch,$pc,$hr2,$txt,$tail);
   # 2010/04/06 - add 'i' case insensitive; 's' to treat as single line;
   $ank = '';
   $tail = '';
   if ($fank =~ /^<table>(.*)$/is) {
       $tail = $1;
   } elsif ($fank =~ /^<table\s+>(.*)$/is) {
       $tail = $1;
   } elsif ($fank =~ /^<table\s+(.+)>{1}(.*)$/is) {
      #$ank = trim_all($1);
      #$tail = $2;
      get_table_element(substr($fank,6),\$tail);
      $ank =~ s/\/$//;  # 2010/04/06 - remove any trailing '/'
      $ank = trim_all($ank);    # and trim again
      $len = length($ank);
      $ch = '';
      $hr2 = '';
      for ($i = 0; $i < $len; $i++) {
         $pc = $ch;
         $ch = substr($ank,$i,1);
         if ($ch =~ /\w/) {
            $hr2 .= $ch;   # accumulate \w chars - alphanumeric, including _
         } elsif (length($hr2)) {
            if (($ch ne '=') && ($ch =~ /\s/)) {
               $i++;
               for (; $i < $len; $i++) {
                  $ch = substr($ank,$i,1);
                  last if ($ch eq '=');
                  last if !($ch =~ /\s/);
               }
            }
            if ($ch eq '=') {
               # found our equal sign
               $i++; # move on...
               for (; $i < $len; $i++) {
                  $ch = substr($ank,$i,1);
                  last if ($ch =~ /('|")/);
                  last if !($ch =~ /\s/);
               }
               if (($ch eq '"')||($ch eq "'")) {
                  $pc = $ch;
                  $i++; # move on...
                  $txt = '';
                  for (; $i < $len; $i++) {
                     $ch = substr($ank,$i,1);
                     last if ($ch eq $pc);
                     $txt .= $ch;
                  }
                  if ($ch eq $pc) {
                     $hr2 = lc($hr2) if ($xml);
                     $hash{$hr2} = $txt;
                     prt( "[dbg38] Got [$hr2] = [$txt] [$fil]\n" ) if ($dbg38);
                  } else {
                     prtw("PROBLEM: got [$hr2]. At pos $i in [$ank], from [$fank], and NO END INVERTED COMMA! ($pc) [$fil]\n");
                     pgm_exit(1,"get_table_hash_ref: FAILED! [1] [$fank]\n") if ($dbg);
                  }
               } else {
                  if (($ch =~ /\w/) && (($hr2 =~ /name/i)||($hr2 =~ /id/i))) {
                     # accept these WITHOUT inverted comma
                     $txt = $ch;
                     $i++; # MOVING ON
                     for (; $i < $len; $i++) {
                        $ch = substr($ank,$i,1);
                        last if !($ch =~ /\w/);
                        $txt .= $ch;
                     }
                     $hr2 = lc($hr2) if ($xml);
                     $hash{$hr2} = $txt;
                     prt( "[dbg39] Got [$hr2] = [$txt] - no inverted commas! [$fil]\n" ) if ($dbg39);
                  } else {
                     prtw("PROBLEM: got [$hr2]. At pos $i in [$ank], from [$fank], and NO START INVERTED COMMA! [$fil]\n");
                     pgm_exit(1,"get_img_table_ref: FAILED! [2] [$fank]\n") if ($dbg);
                  }
               }
            } else {
               prtw("PROBLEM: got [$hr2]. At pos $i in [$ank], from [$fank], and NO EQUAL SIGN! [$fil]\n");
               pgm_exit(1,"get_table_hash_ref: FAILED! [3] [$fank] [$ank]\n") if ($dbg);
            }
            $hr2 = '';
         }
      }
   } else {
       prtw("PROBLEM: [$fank] FAILED initial image test regex! [$fil]\n");
       pgm_exit(1,"get_table_hash_ref: FAILED! [4]") if ($dbg);
   }
   $hash{'_TRAILING_'} = $tail if (length($tail));
   return \%hash;
}

sub process_files($$) {
    my ($inf1,$inf2) = @_;
    if (! open INF1, "<$inf1") {
        pgm_exit(1,"$pgmname: Error: Can NOT open file [$inf1]\n");
    }
    if (! open INF2, "<$inf2") {
        pgm_exit(1,"$pgmname: Error: Can NOT open file [$inf2]\n");
    }
    my @lines1 = <INF1>;
    my @lines2 = <INF2>;
    close INF1;
    close INF2;
    my $lncnt1 = scalar @lines1;    # old content - take <body> ... </body>
    # and take TITLE from like <head><title>II Flying with FlightGear</title> 
    my $lncnt2 = scalar @lines2;    # new content - replace <h1>Heading...</h1><p>Blah, blah, blah...</p> with above content
    my ($i,$line,$len,$j,$ch,$tag,$gettag,$gotbody,$lnn,$bgnoff,$oline,$max,$title_line,$title);
    my ($ncnt1,$ncnt2,$head,$tail,$ii,$nxln,$ihr,$key,$val,$gotalt,$dnchg,$endoff,$nimg,$src,$gotsrc);
    my ($tmp,$tabcnt);
    prt("Checking $lncnt1 lines, of file $inf1...\n");
    $tag = '';
    $gotbody = 0;
    $lnn = 0;
    my @nlines1 = ();
    my @nlines2 = ();
    $title = '';
    $tabcnt = 0;
    for ($i = 0; $i < $lncnt1; $i++) {
        $lnn++;
        $line = $lines1[$i];
        $len = length($line);
        prt("$lnn:$len: $line") if ($dbg01);
        for ($j = 0; $j < $len; $j++) {
            $ch = substr($line,$j,1);
            if ($ch eq '<') {
                $tag = $ch;
                $gettag = 1;
                $j++;
                prt("Start tag...\n") if ($dbg01);
                while ($gettag && ($i < $lncnt1)) {
                    for (; $j < $len; $j++) {
                        $ch = substr($line,$j,1);
                        $tag .= $ch;
                        last if ($ch eq '>');
                    }
                    if (($ch ne '>') && ($j == $len)) {
                        $i++;
                        if ($i < $lncnt1) {
                            $lnn++;
                            $line = $lines1[$i];
                            $len = length($line);
                            prt("$lnn:$len; $line") if ($dbg01);
                        }
                        $j = 0;
                        next;
                    }
                    if ($tag =~ /^<body(\s|>)/i) {
                        $gotbody = 1;
                        prt("$lnn: Got BODY $tag\n") if ($dbg01);
                    } elsif ($tag =~ /<title>/i) {
                        $title = substr($line,$j+1);
                        $title =~ s/<\/title>//i;
                        $title = trim_all($title);
                        prt("Got TITLE [$title]\n");

                    }
                    if ($ch eq '>') {
                        $gettag = 0;
                    }
                }
            }
        }
        last if ($gotbody);
    }
    if ($gotbody) {
        prt("Found BODY [$tag]\n") if ($dbg01);
        $tag = '';
        $tag = substr($line,$j) if ($j < $len); # any balance of this line
        if (length($tag) && ($tag =~ /^\s+$/)) {
            push(@nlines1,$tag);
        }
        $i++;
        for (; $i < $lncnt1; $i++) {
            $lnn++;
            $line = $lines1[$i];
            $len = length($line);
            prt("$lnn:$len: $line") if ($dbg01);
            for ($j = 0; $j < $len; $j++) {
                $ch = substr($line,$j,1);
                if ($ch eq '<') {
                    $bgnoff = $j;   # keep beginning
                    $tag = $ch;
                    $gettag = 1;
                    $j++;
                    prt("Start tag...\n") if ($dbg01);
                    while ($gettag && ($i < $lncnt1)) {
                        for (; $j < $len; $j++) {
                            $ch = substr($line,$j,1);
                            $tag .= $ch;
                            last if ($ch eq '>');
                        }
                        if (($ch ne '>') && ($j == $len)) {
                            $i++;
                            if ($i < $lncnt1) {
                                $lnn++;
                                push(@nlines1,$line);
                                $line = $lines1[$i];
                                $len = length($line);
                                prt("$lnn:$len; $line") if ($dbg01);
                            }
                            $j = 0;
                            $bgnoff = $j;   # keep beginning
                            next;
                        }
                        if ($tag =~ /^<\/body>/i) {
                            $gotbody = 0;
                            prt("$lnn: End BODY $tag\n") if ($dbg01);
                            $tag = '';
                            if ($bgnoff) {
                                $tag = substr($line,0,$bgnoff);
                                push(@nlines1,$tag) if (!($tag =~ /^\s+$/));
                            }

                        }
                        if ($ch eq '>') {
                            $gettag = 0;
                        }
                    }
                }
            }
            last if (!$gotbody);
            push(@nlines1,$line);
        }
        $ncnt1 = scalar @nlines1;
        prt("Got $ncnt1 lines, from $lncnt1 lines...\n");
        $lnn = 0;
        my @arr = ();
        my $cnt = 0;
        $tail = '';
        # any post processing ...
        for ($i = 0; $i < $ncnt1; $i++) {
            if (length($tail)) {
                $oline = $tail;
                $i--;
            } else {
                $oline = $nlines1[$i];
                $lnn++;
            }
            $tail = '';
            $line = trim_all($oline);
            chomp $oline;
            prt("[dbg03] $lnn: [$oline]\n") if ($dbg03);
            if (length($line)) {
                prt("[dbg01] $lnn: [$line]\n") if ($dbg01);
                if ($oline =~ /^(.*)<img\s+(.*)$/i) {
                    $head = trim_all($1);
                    $nxln = $2;
                    $nimg = "<img $nxln";
                    $bgnoff = $i;
                    $ii = $i + 1;
                    while ( !($nimg =~ />/) && ($ii < $ncnt1)) {
                        $nxln = $nlines1[$ii];
                        $nimg .= $nxln;
                        last if ($nxln =~ />/);
                        $ii++;
                    }
                    $endoff = $ii;
                    pgm_exit(1,"EEK! Ran out of lines searching for the END of img!\n") if ($ii >= $ncnt1);
                    prt("[dbg07] $lnn: Deal with $bgnoff:$endoff:[$head]+[$nimg]!\n") if ($dbg07);
                    $ihr = get_img_hash_ref($nimg,$inf1,1,1);
                    $gotalt = 0;
                    $dnchg = 0;
                    $nimg = '';
                    $tail = '';
                    $src = '';
                    $gotsrc = 0;
                    foreach $key (keys %{$ihr}) {
                        $val = ${$ihr}{$key};
                        if ($key =~ '_TRAILING_') {
                            $tail = $val;
                            prt("[dbg05] Trailing = [$tail]\n") if ($dbg05);
                        } else {
                            prt("[dbg05] [$key]=\"[$val]\"\n") if ($dbg05);
                            if ($key =~ /^src$/i) {
                                $src = $val;
                                $gotsrc = 1;
                            } elsif ($key =~ /^height$/i) {
                                if (!($val =~ /^\d+$/)) {
                                    # if NOT all digits
                                    if ($val =~ /^(\d+)(.+)$/) {
                                        $val = $1;
                                        $tmp = $2;
                                        if ($tmp =~ /^\.\d+/) {
                                            $tmp = substr($tmp,1,1);
                                            if ($tmp >= 5) {
                                                $val++;
                                            }
                                        }
                                        prt( "[dbg06] 'height' from [".${$ihr}{$key}."] to [$val]\n") if ($dbg06);
                                        ${$ihr}{$key} = $val;
                                        $dnchg++;
                                    } else {
                                        pgm_exit(1,"ERROR: Code does NOT fix height.\n");
                                    }
                                }
                            } elsif ($key =~ /^width$/i) {
                                if (!($val =~ /^\d+$/)) {
                                    # if NOT all digits
                                    if ($val =~ /^(\d+)(.+)$/) {
                                        $val = $1;
                                        $tmp = $2;
                                        if ($tmp =~ /^\.\d+/) {
                                            $tmp = substr($tmp,1,1);
                                            if ($tmp >= 5) {
                                                $val++;
                                            }
                                        }
                                        prt( "[dbg06] 'width' from [".${$ihr}{$key}."] to [$val]\n") if ($dbg06);
                                        ${$ihr}{$key} = $val;
                                        $dnchg++;
                                    } else {
                                        pgm_exit(1,"ERROR: Code does NOT fix width.\n");
                                    }
                                }
                            } elsif ($key =~ /^alt$/i) {
                                if (length($val)) {
                                    $gotalt = 1;
                                } else {
                                    next;   # no alt length - do not add it now
                                }
                            } elsif ($key =~ /^src$/i) {
                                if (length($val)) {
                                    $gotsrc = 1;
                                    $src = $val;
                                }
                            }
                            $nimg .= ' ' if (length($nimg));
                            $nimg .= "$key=\"$val\"";
                        }
                    }
                    if (!$gotalt && $gotsrc) {
                       $nimg .= ' ' if (length($nimg));
                       $nimg .= "$key=\"image file $src\"";
                       $dnchg++;
                    }
                    if ($dnchg) {
                        if (length($head)) {
                            $cnt++;
                            push(@arr,$head);
                            prt("[dbg04] $lnn:$cnt: $head ($i)\n") if ($dbg04);
                        }
                        $nimg = "<img ".$nimg." />";
                        push(@arr,$nimg);
                        $cnt++;
                        prt("[dbg04] $lnn:$cnt: $nimg ($i)\n") if ($dbg04);
                        #if (length($tail)) {
                        #    $cnt++;
                        #    prt("$cnt: $tail ($i)\n");
                        #    push(@arr,$tail);
                        #}
                        #$oline = $head."<img ".$nimg." />$tail";    # build the new line
                        $oline = $head.$nimg;    # build the new line
                        $ii = $bgnoff;
                        $nlines1[$ii] = $oline;
                        $ii++;
                        for (; $ii <= $endoff; $ii++) {
                            $nlines1[$ii] = '';
                        }
                        prt("[dbg08] $ii: Set NEW [$oline] h=[$head] t=[$nimg] cf=[$tail]\n") if ($dbg08);
                        $oline = '';
                    } else {
                        prt("[dbg09] $lnn: No image tag change required...[$oline] [$nimg]\n") if ($dbg09);
                        $tail = '';
                    }
                    # pgm_exit(1,"$bgnoff:$endoff: Deal with [$head]+[<img $nimg />]+[$tail]!\n");
                # } elsif ($oline =~ /^(.*)<table(\s|>)+(.*)$/i) {
                } elsif ($oline =~ /^(.*)<table(.*)$/is) {
                    $head = trim_all($1);
                    $tmp  = $2;
                    $nimg = "<table$tmp";
                    if ( !($nimg =~ />/) ) { # was ($tmp ne '>')
                        $ii = $i + 1;   
                        while ( !($nimg =~ />/) && ($ii < $ncnt1)) {
                            $nxln = $nlines1[$ii];
                            $nimg .= $nxln;
                            last if ($nxln =~ />/);
                            $ii++;
                        }
                        pgm_exit(1,"EEK! Ran out of lines searching for the END of table!\n") if ($ii >= $ncnt1);
                    }
                    $endoff = $ii;
                    prt("[dbg12] Table at $bgnoff:$endoff:[$head]+[$nimg]\n") if ($dbg12);
                    $ihr = get_table_hash_ref($nimg,$inf1,1,1);
                    $tail = '';
                    $nimg = '';
                    $gotalt = 0;
                    $dnchg = 0;
                    foreach $key (keys %{$ihr}) {
                        $val = ${$ihr}{$key};
                        if ($key =~ '_TRAILING_') {
                            $tail = $val;
                            prt("[dbg11] Trailing = [$tail]\n") if ($dbg11);
                        } else {
                            prt("[dbg11] [$key]=\"[$val]\"\n") if ($dbg11);
                            if ($key =~ /^summary$/i) {
                                if (length($val)) {
                                    $gotalt = 1;
                                } else {
                                    next;
                                }
                            }
                            $nimg .= ' ' if (length($nimg));
                            $nimg .= "$key=\"$val\"";
                        }
                    }

                    if (!$gotalt) {
                        $tabcnt++;
                        $nimg .= ' ' if (length($nimg));
                        $nimg .= "summary=\"Table # $tabcnt\"";
                        $dnchg++;
                    }

                    if ($dnchg) {
                        if (length($head)) {
                            $cnt++;
                            push(@arr,$head);
                            prt("[dbg04] $lnn:$cnt: $head - Adding lead to table\n") if ($dbg04);
                        }
                        $nimg = "<table $nimg>";
                        push(@arr,$nimg);
                        $cnt++;
                        prt("[dbg04] $lnn:$cnt: $nimg - Added new table line tail=[$tail])\n") if ($dbg04);
                        $oline = $head.$nimg;    # build the new line
                        $ii = $bgnoff;
                        $nlines1[$ii] = $oline;
                        $ii++;
                        for (; $ii <= $endoff; $ii++) {
                            $nlines1[$ii] = '';
                        }
                        prt("[dbg10] $ii: TABLE NEW [$oline]  h=[$head] t=[$nimg] cf=[$tail]\n") if ($dbg10);
                        $oline = '';
                    } else {
                        # table element is ok
                    }
                }
                if (length($oline)) {
                    $cnt++;
                    push(@arr,$oline);
                    prt("[dbg04] $lnn:$cnt: $oline ($i)\n") if ($dbg04);
                }
                #if ($i > 580) {
                #    #pgm_exit(1,"What is this trap?\n");
                #    $dbg03 = 1;
                #}
            }
        }
        prt("Done post processing...\n");
        @nlines1 = @arr;

        prt("Kept ".scalar @nlines1." lines, from $lncnt1 lines...\n");
        write2file(join("\n",@nlines1)."\n",$tmpfil1);
        prt("Written to $tmpfil1...\n");

        $lnn = 0;
        $max = $lncnt2 - 6;
        $title_line = -1;
        for ($i = 0; $i < $max; $i++) {
            $lnn++;
            $line = $lines2[$i];
            chomp $line;
            $len = length($line);
            prt("$lnn:$len: $line") if ($dbg02);
            if ($line =~ /^\s*Blank - getstart - FlightGear/) {
                $title_line = $i;
                prt("$lnn: Found current title line...\n");
            } elsif ($line =~ /<h1>/) {
                # <h1>Heading...</h1><p>Blah, blah, blah...</p> with above content
                if ($lines2[$i+1] =~ /Heading.../) {
                    if ($lines2[$i+2] =~ /<\/h1>/) {
                        if ($lines2[$i+3] =~ /^\s+$/) {
                            if ($lines2[$i+4] =~ /<p>/) {
                                if ($lines2[$i+5] =~ /Blah, blah, blah\.\.\./) {
                                    if ($lines2[$i+6] =~ /<\/p>/) {
                                        prt("Found block to replace\n" );
                                        last;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            push(@nlines2,$line);
        }
        if ($i < $max) {
            foreach $line (@nlines1) {
                push(@nlines2,$line);
            }
            push(@nlines2,"   <hr />");
            $i += 7;
            for (; $i < $lncnt2; $i++) {
                $line = $lines2[$i];
                chomp $line;
                push(@nlines2,$line);
            }
            $ncnt2 = scalar @nlines2;
            prt("Got $ncnt2 lines, after sub in $lncnt2 lines...\n");
            $tag = $title . " - FlightGear";
            if (length($title) && ($title_line != -1) && ($title_line < $ncnt2) && ($nlines2[$title_line] =~ /Blank/i)) {
                $nlines2[$title_line] = $tag;
                prt("Set NEW title [$tag]\n");
            } else {
                prtw("WARNING: Failed to do title substitution\n");
            }
            # any post processing ...

            # --------------------
            write2file(join("\n",@nlines2)."\n",$out_file);
            prt("Written to $out_file...\n");
            # system($out_file);
        }

    } else {
        pgm_exit(1,"ERROR: File $inf1: NO BODY FOUND\n");
    }
}


#########################################
### MAIN ###
parse_args(@ARGV);
prt( "$pgmname: in [$cwd]: Processing $in_file1 and $in_file2...\n" );
process_files($in_file1,$in_file2);
pgm_exit(0,"Normal exit(0)");
########################################

sub parse_args {
    my (@av) = @_;
    my $cnt = 0;
    while (@av) {
        my $arg = $av[0];
        if ($cnt == 0) {
            $in_file1 = $arg;
        } elsif ($cnt == 1) {
            $in_file2 = $arg;
        } elsif ($cnt == 2) {
            $out_file = $arg;
        } else {
            pgm_exit(1, "$pgmname: Only take THREE arguments in file1, in file2 and out file...\n");
        }
        $cnt++;
        shift @av;
    }
    if ($do_debug && ($cnt != 2)) {
        $cnt = 3;
        $in_file1 = $def_file1;
        $in_file2 = $def_file2;
        $out_file = $def_out;
        unlink $out_file if (-f $out_file);
        $load_log = 1;
    }
    if ($cnt != 3) {
        pgm_exit(1, "$pgmname: Only take THREE arguments in file1, in file2 and out file...\n");
    } elsif (! -f $in_file1) {
        pgm_exit(1, "$pgmname: ERROR: Can NOT locate file [$in_file1]...\n");
    } elsif (! -f $in_file2) {
        pgm_exit(1, "$pgmname: ERROR: Can NOT locate file [$in_file2]...\n");
    } elsif (-f $out_file) {
        pgm_exit(1, "$pgmname: ERROR: OUT file [$out_file] EXISTS! Move, rename, or delete...\n");
    }
}
# eof - fgmerge.pl
