#!perl -w
# ###################################################################################
# NAME: fgslnlist.pl
# AIM: Given a MSVC SLN file, show the LIST of VCPROJ files it references
# add saving of the SOURCE files from vcproj files
# potentially scan all directroies, and show source files NOT present in VCPROJ files
# 23/09/2008 - write 'cfg' file for each project, and a
# dependency file ...
# The general processing consists of reading the vcproj xml, and buidling a set of
# has files, under each configuration given ($conf), and at the end, collect all
# the hashed information and store in a single hash, %v6_refall, where the keys ($mask) are
# the project|configuration|runtime - $proj|$conf|$rtime, where $conf is say Win32|Debug
# so we end with $v6_refall{$mask} = [@allarr];  # COPY the ARRAY to the HASH
# The @allarr itself consists of $reserved_word=$item_information
# push(@allarr, "$libraries=[$cdefs]"); from %v8_depend
# push(@allarr, "$defines=[$cdefs]");   from %v8_link (poorly names hash!)
# push(@allarr, "$includes=[$cincs]");  from %v8_includ, etc ... for
# $libpath from %v8_libdep, $outputs from $v8_config{$conf}, $linkout from $v8_linkout{$conf}
# Each %v8_<something> is cleared for each vcproj parsed, in fg_clear_proj_files
# 27/09/2008 added new $postevt from %v8_postbuild{$conf} = say - a TAB separates commands
# PostBuild_Desc=[Copy exe] PostBuild_Cmds=[copy Release\*.exe bin\.	copy test.h bin\.]
# ###################################################################################
use strict;
use warnings;
use File::Basename;
######################################################################################
require 'fgutils.pl' or die "Unable to load fgutils.pl ...\n";
# log file stuff
my ($LF);
my $pgname = $0;    # get perl module name
if ($pgname =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$pgname);
	$pgname= $tmpsp[-1];
}
my $outfile = "temp.$pgname.txt";
open_log($outfile);

my $show_rel = 1;
my $fix_rela = 1;
my $show_srcs = 1;	# also OUTPUT the SOURCE files in the project files
my $scan_directory = 0; # do a FULL directory scan - takes time ...
my $recursive = 1;  # if scan directory
my $do_alternative_scan = 1;    # more extensive decode of VCPROJ XML
my $do_old_scan2 = 0;

my $dbg_on = 1;	# to run without a command line

my $base_dir = "";
my $def_input = $base_dir."fgfs\\fgfs.sln";
my $in_file = '';
my @file_list = ();
my $pcnt = 0;
my ($fil_nm,$fil_dir,$fil_ext);
my @warnings = ();
my $wmsg = '';
my $sln_cnt = 0;
my $srccnt = 0;
my @srcsc = ();	# list FROM vcproj files
my @dir_list = ();	# list from DIRECTORY search
my $dir_cnt = 0;

my $dirs_count = 0;
my $file_count = 0;
my $tot_vclines = 0;

# debug items
my $dbg1 = 0;	# show missing as found ...
my $dbg3 = 0;
my @missing = ();

############################################################################
########### TRY FOR MORE DECODE OF THE XML #######
# Options
my $killfilt = 1;	# kill the filter name and type on </Filter>
my $addfiles2cfg = 1;   # write out the source files, per filter to cfg files

use constant {
    TT_UNK => 0,
    TT_BGN => 1,
    TT_END => 2,
    TT_BE  => 3,
    TT_DEC => 4
};

# failed for some reason
#my %tt_strings = (
#    TT_UNK => 'Unknown',
#    TT_BGN => 'Begin',
#    TT_END => 'End',
#    TT_BE  => 'BE',
#    TT_DEC => 'Decl'
#);

my $TYP_OPEN = 1;       # same as TT_BGN
my $TYP_CLOSE = 2;      # same as TT_END
my $TYP_OPENCLOSE = 3;  # same as TT_BE
my $TYP_VERSION = 4;    # saem as TT_DEC

my $v8_cfgexp = '<Configuration\\s+.*Name=\\"(\\S+)\\"\\s';
# default items for Application (windows and console)
my $def_runtime_rel = '/MT';
my $def_runtime_dbg = '/MTd';
my $def_defines_dbg = '/D "_CRT_SECURE_NO_WARNINGS"';
my $def_defines_rel = '/D "_CRT_SECURE_NO_WARNINGS"';
my $def_libs_rel = 'comctl32.lib Msimg32.lib Winmm.lib';
my $def_libs_dbg = 'comctl32.lib Msimg32.lib Winmm.lib';

my $dsp_runtime_rel = '';
my $dsp_runtime_dbg = '';
my $dsp_defines_dbg = '';
my $dsp_defines_rel = '';
my $dsp_libs_rel = '';
my $dsp_libs_dbg = '';

##                  [0]SRC [1]FUL [2]GRP    [3]FIL      [4]CMP [5]DON [6]PRJ     [7]SHR [8]EXC
##                  relnm  full   group      filter     cmp    done   project    grp    exclude
##	push(@v8_srcs, [$src,  $ff,   $filtname, $filttype, 0,     0,     $projname, shr,   excl] );
use constant {
    V8_SRC => 0,
    V8_FUL => 1,
    V8_GRP => 2,
    V8_FIL => 3,
    V8_CMP => 4,
    V8_DON => 5,
    V8_PRJ => 6,
    V8_SHR => 7,
    V8_EXC => 8
};

my @all_sources = (); # multidimensional array with lot of information
my @v8_srcs = ();   # multidimensional array with lot of information
my %v8_link = ();   # PREPROCESSOR compiler definitions, by configuration
my %v8_aptype = (); # application type, by configuration - see like fg = ConfigurationType="1"
my %v8_depend = (); # ADDITIONAL LINK dependencies, by configuration
# new 21/09/2008 
my %v8_runtim = (); # RUNTIME /MT or /MD, by configuration
my %v8_includ = ();
my %v8_filter = (); # SOLUTION: In <Files>, like <Filter Name="Assembler Files (Unsupported)"
# Filter="asm;obj;c;cpp;cxx;h;hpp;hxx">
# $key = Name, $val = Filter, for whole solution 
my %v8_apptypes = ();    # SOLUTION: full set of app type in solution, key = project name
my %v8_libdep = (); # ADDITIONAL LIB DIRS, by configuration
# new 22/09/2008
my %v8_config = ();  #  by configuration, OutputDirectory=".\Release", IntermediateDirectory="Release",
# and zlib = ConfigurationType="4", alut = ConfigurationType="2", fg = ConfigurationType="1"
#  // This is an internal type to Visual Studio, it seems that:
#  // 4 == static library
#  // 2 == dll
#  // 1 == executable
#  // 10 == utility
my %v8_linkout = (); # Name="VCLinkerTool" OutputFile=".\Release\FlightGear.exe", by configuration
# 27/09/2008
my %v8_postbuild = (); # Name="VCPostBuildEventTool", with
# Description="Copy Library to plib directory"
# CommandLine="copy debug\*.lib ..\..\*.*&#x0D;&#x0A;copy ul.h ..\..\ul.h&#x0D;&#x0A;copy ulRTTI.h ..\..\ulRTTI.h&#x0D;&#x0A;"
# the &#x0D;&#x0A; is replaced with a TAB (\t) in the DSP file

my $def_include_dirs_dbg = '';
my $def_include_dirs_rel = '';
my $dsp_includes_dbg = '';
my $dsp_includes_rel = '';

my $app_console = 'Console Application';
my $app_windows = 'Application';
my $app_dynalib = 'Dynamic-Link Library';
my $app_statlib = 'Static Library';
my $app_utility  = 'Utility';

# per <Configuration ... ConfigurationType="4" ...
my %v8_conftypes = (
    1  => $app_windows,
    2  => $app_dynalib,
    4  => $app_statlib,
    10 => $app_utility );
# and if 1 ($app_windows), then per SubSystem
# <Tool Name="VCLinkerTool" ... SubSystem="2"
# SubSystem="1" = :console or "2" = :window
my %v8_subsystems = (
    1 => $app_console,
    2 => $app_windows );

# and if that FAILS, then try to decode PreprocessorDefintiions
# maybe _WINDOWS => 'Application'
# but then Alu.vcproj only has -
# PreprocessorDefinitions="NDEBUG;WIN32;AL_BUILD_LIBRARY"
# so this is NOT sure ...
my %v8_defines = (
    '_CONSOLE' => $app_console,
    '_USRDLL'  => $app_dynalib,
    '_LIB'     => $app_statlib );
my $typelse = $app_windows;
my @special_typing = qw( libpng zlib visualc6 );	# make these STATIC LIBRARIES

#my $def_src_filt = "cpp;c;cxx;rc;def;r;odl;idl;hpj;bat;for;f90";
#my $def_hdr_filt = "h;hpp;hxx;hm;inl;fi;fd";
#my $def_rcs_filt = "ico;cur;bmp;dlg;rc2;rct;bin;cnt;rtf;gif;jpg;jpeg;jpe";
#my $def_spl_filt = "txt;vc5;h-msvc8;asm";
#
#my $def_src_grp = "Source Files";    # Begin Group "Source Files"
#my $def_hdr_grp = "Header Files";	# Begin Group "Header Files"
#my $def_rcs_grp = "Resource Files";	# Begin Group "Resource Files"
#my $def_spl_grp = "Special Files";
#my $def_unknown = "Unknown";

my $excl_mark = "EXCLUDED";

my @dsp_base_defs_rel = qw( WIN32 NDEBUG _WINDOWS _MBCS );
my @dsp_base_defs_dbg = qw( WIN32 _DEBUG _WINDOWS _MBCS );
my @dsp_base_libs_rel = qw( kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib 
advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib );
my @dsp_base_libs_dbg = qw( kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib 
advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib );

use constant {
    GRP_UNK => 0,
    GRP_SRC => 1,
    GRP_HDR => 2,    # also include extensionless files, maybe ...
    GRP_RCS => 3,
    GRP_SPL => 4    # special items
};

my $act_vcproj = "";

my @v6_srcs = ();  # relnm full group filter
my %v6_defs = ();
my %v6_conf = ();

# 20/09/2008 new items
# key = projname|$conf|$rtim, eg FlightGear|Debug|Win32|MDd
# value = string 'defines=[ list of defines ] $libraries=[ list of libraries ]
my %v6_refall = (); # instead of a scalar list, try to add a COPY of an array
my %v6_all = ();    # OLD - NOW NOT USED projects

my @xml_tag_map = ();
my @xml_lines = ();
my @xml_line_map = ();  # multi - [ new_line, begin_line, end_line ]
my $xml_last_line = 0;
my $act_file = '';  # last file source from project
my $act_disp = '';  # can be 'MISSED', 'EXCLUDED', or 'ok'

use constant {
    RT_NAM => 0,
    RT_LTS => 1,
    RT_STG => 2,
    RT_VAL => 3,
    RT_RES => 4
};

my $def_runtime_lts = "MD";
my $def_runtime_stg = "Multithreaded DLL";
my $def_runtime_val = 2;
#    0                  1     2                         3  4
my @runtimes_array = (
    ["RuntimeLibrary", "MT",  "Multithreaded",           0, 0],
    ["RuntimeLibrary", "MTd", "Multithreaded Debug",     1, 0],
    ["RuntimeLibrary", $def_runtime_lts, $def_runtime_stg, $def_runtime_val, 0],
    ["RuntimeLibrary", "MDd", "Multithreaded DLL Debug", 3, 0],
    ["RuntimeLibrary", "ML",  "Single Thread",           4, 0],
    ["RuntimeLibrary", "MLd", "Single Thread Debug",     5, 0]
);

# 23/09/2008 from fgsln2dsw.pl - get SOLUTION dependencies
my %sln_projects = ();	# projects FOUND in SLN file - key=name, data=vcproj file
my %sln_projpath = ();	# and the RELATIVE path of the project, IF ANY ...
my %sln_projids  = ();	# special ID used in SLN file
my %sln_depends  = ();	# dependencies, key by projname, with '|' list of values
my $tryharder = 0;	# needs more work to put this ON

##############################################################
# common 'reserved' words for config files
# for neatness only, make them all equal length
my $prjname   = 'projname';
my $ap_type   = 'app_type';
my $runtime   = 'runtime_';
my $platform  = 'platform';
my $linkout   = 'link_out';
my $includes  = 'inc_path';
my $libraries = 'add_libs';
my $libpath   = 'lib_path';
my $defines   = 'defines_';
my $outputs   = 'outputs_';
my $out_dir   = 'out__dir';
my $int_dir   = 'interout';
my $depends   = 'depends_';
my $filter    = 'filter__';
my $srcfiles  = 'src_file';
my $excfiles  = 'exc_file';
# 27/09/2008
my $postevt   = 'postbld_';
my $postdesc  = 'postdesc';
my $postcmds  = 'postcmds';
##############################################################

# DEBUG SWITCHES
# ##############

my $dbg_srcv = 0;
my $dbg_srcc = 0;
my $dbg_sln = 0;    # show prt( "$cnt: Project=[".$arr[0]."] Path=[".$arr[1]."] ...
my $dbg11 = 0;
my $dbg_src1  = 0;
my $dbg_src2  = 0;
my $dbg_src3  = 0;
my $dbg_src4 = 0;
my $dbg_src5 = 0;
my $dbg_src6 = 0;   # show prt( "Got configuration $conf
my $dbg_src7 = 0;   # show prt( "Got Tool name $tname and prt( "Is linker tool ...[$fline]
my $dbg_src8  = 0;  # show prt( "Setting DEFS: $conf [$ppdefs] $apptype ($ctype)
my $dbg_src9 = 0;
my $dbg_src10 = 0;
my $dbg_src11 = 0;  # show prt( "Project=$projname, v=$version GUID=$ProjectGUID
my $dbg_src12 = 0;  # show prt( "Setting LINKS: $conf [$adddeps]
my $dbg_src12a = 0;
my $dbg_src13 = 0;
my $dbg_src14 = 0;
my $dbg_src15 = 0;
my $dbg_src16 = 0;  # show prt( "SRC: [$ffnr] $itm
my $dgb_src17 = 0;  # show prt( "Got RUNTIME value [$ppdefs] ... config=$conf ($ctype) $itm (= $def)
my $dbg_src18 = 0;

my $dbg_x01 = 0;    # to do write2file( join("\n",@nlines), 'tempxml.txt'); and more
my $dbg_x02 = 0;    # show warning if from @special_type list
my $dbg_x03 = 0;    # show prt( "v6_all: Adding [$mask] with $libraries=[$cdefs] ...
my $dbg_x04 = 0;    # show each with 'Name' - prt( "tag=$xmltag, Name=$pname
my $dgb_x05 = 0;    # show massive debug information in sub exclude_from_build{...}
my $dbg_x06 = 0;    # show prt( "$lnnum: Enter Files ... ($fline), AND exit
my $dbg_x07 = 0;    # show prtw("WARNING: Got 'AdditionalIncludeDirectories' = $ppdefs, ... if (($act_disp ne 'EXCLUDED')
my $dbg_x08 = 0;    # show prt( "dbg_x08: Showing _ALL_ for tag=[$xmltag], line=[$fline]
my $dbg_x09 = 0;    # show prt( "$msg\n" ) if ($dbg_x09);    # done ONE application
my $dbg_x10 = 0;    # show prt( "Got equal split of [$key] = [$val]
my $dbg_x11 = 0;    # show prt( "VCLibrarianTool:$conf Suggests STATIC LIBRARY - out=$ppdefs - and that is what we have in v8_aptype...
my $dbg_x12 = 0;    # show prt( "VCPROJ Project: $projname, as $apptype, version=$version ... AND MORE
my $dbg_x13 = 0;    # show prt( "Defined Debug = $dsp_defines_dbg, Release = $dsp_defines_rel... AND MORE
my $dbg_x14 = 0;    # show prt("Set INCLUDES:$conf: to [$ppdefs]
my $dbg_x15 = 0;    # show prt( "Set APPTYPE:$conf: v8_aptype[$apptype] (ln=$lnnum)... AND MORE see $dgbx_08 also
my $dbg_x16 = 0;    # show prt("Got APPTYPE:$conf: NO CHANGE [$apptype] equals SubSystem ($adddeps) [".$v8_subsystems{$adddeps}."] ...
my $dbg_x17 = 0;    # show prt( "\nLoading [$in] file in directory [$in_fd] ...
my $dbg_x18 = 0;    # show prt( "Begin List - first solution name, then VCPROJ files ...
my $dbg_x19 = 0;    # show prt( "Writing $cnt potential dependencies to $outfil ... AND MORE

# 23/09/2008 from fgsln2dsw.pl
my $dbg_s13 = 0;    # show prt( "proj $projname, depends on $nmdeps ...
my $dbg_sl1 = 0;    # show prt( "Got PROJECT name=$projname, file=$projff, rel=[$relpath], like
# Got PROJECT name=FlightGear, file=FlightGear\FlightGear.vcproj, rel=[..\FlightGear\].
my $dbg_s12 = 0;    # show prt( "Proj $projname, dependant on $arr[0] ...
# ##############

#########################################################################
# PROGRAM COMMENCES

if ($dbg_on) {
	$in_file = $def_input;
    #foreach $cnt (keys %tt_strings) {
    #    prt( "$cnt ".$tt_strings{$cnt}."\n" );
    #}
    #exit(1);
}

if ((length($in_file) == 0) || !( -f $in_file )) {
	if (length($in_file)) {
		mydie( "ERROR: Can NOT locate [$in_file] ... $! ...\n" );
	} else {
		mydie( "ERROR: Must give a SLN input file ...\n" );
	}
}

($fil_nm,$fil_dir,$fil_ext) = fileparse( $in_file, qr/\.[^.]*/ );

if (lc($fil_ext) eq '.sln') {
    # push(@projs, [ $arr[0], $arr[1] ]);
    @file_list = process_sln_file( $in_file );
} else {
    if (lc($fil_ext) eq '.vcproj') {
        push(@file_list, [ $in_file, $fil_dir ]);
    } else {
        mydie( "ERROR: Not a SOLUTION (.sln), NOR PROJECT (.vcpoj) file [$in_file] ...\n" );
    }
}

$sln_cnt = scalar @file_list;
prt( "Got $sln_cnt files from $in_file ...\n" );
my $sln_file = substr($in_file, length($base_dir));

if ($dbg_x18) {
    prt( "Begin List - first solution name, then VCPROJ files ...\n" );
    prt( "$sln_file\n" );
    output_proj_list();
}
if ($do_old_scan2) {
    collect_xml_sources();
    do_directory_scan($base_dir) if ($scan_directory);
    prt("All Done ...\n");
}

# use the NEW 'alternate' - read MUCH BETTER scan of VCPROJ files
alternative_scan();
prt("\n");

###show_v6_all();
show_v6_refall();   # write out the results of the scan
write_out_depends( $fil_nm );   # and dependency file

show_warnings();    # show WARNING: again, IF ANY - should be none ;=))

close_log($outfile,1);
exit(0);

sub process_vcproj_xml_lines {
	my ($fil, @lines) = @_;
	my $max = scalar @lines;
	my $rp = substr($fil, length($base_dir));
	my ($nm,$dir) = fileparse($fil);
	prt( "Got $max lines from $rp to process ...\n" );
	my $fline = '';
	my $fcnt = 0;
    my $mcnt = 0;
    my $ccnt = 0;
    # process, line, by line ...
	for (my $i = 0; $i < $max; $i++) {
		my $line = $lines[$i];
		chomp $line;
		$line = trim_all($line);
		$fline .= ' ' if length($fline);
		$fline .= $line;
		if ($fline =~ />/) {
			$fline = trim_all($fline);
			my $src = '';
			my $asrc = '';
			my $msg = '';
			# check file name - include \w, which include _, ., \, and - - more?
			if ($fline =~ /<File\sRelativePath="{1}([\.\\\w-]+)"{1}\s*>/i) {
				$src = $1;
				$asrc = fix_rel($dir.$src);
				$msg = "MISSING!";
				$msg = "ok" if ( -f $asrc);
			} elsif ($fline =~ /<File\sRelativePath="{1}(.+)"{1}\s*>/i) {
				$src = $1;
				$asrc = fix_rel($dir.$src);
				$msg = "MISSING!";
				$msg = "ok" if ( -f $asrc);
				$msg .= " *** CHECK ME *** 2";
			}
			if (length($src)) {
				my ($nm2,$dir2,$ext2) = fileparse($src, qr/\.[^.]*/ ); 
				prt( "$asrc $msg $ext2\n" ) if ($dbg1);
				my $lcex = lc($ext2);
				if (($lcex eq '.c')||($lcex eq '.cpp')||($lcex eq '.cxx')) {
					push(@srcsc, $asrc);
                    $ccnt++;
				}
				$fcnt++;
				if ($msg =~ /^MISSING/) {
					push(@missing, [$fil, $asrc]);
                    $mcnt++;
				}
			}
			$fline = '';
		}
	}
	prt("Count $fcnt files, $ccnt C/C++ sources, missed $mcnt, in $fil ...\n");
	$srccnt += $fcnt;
}

sub unix_2_dos {
	my ($f) = shift;
	$f =~ s/\//\\/g;
	return $f;
}

sub fix_rel {
	my ($path) = shift;
	$path = unix_2_dos($path);	# ensure DOS separator
	my @a = split(/\\/, $path);	# split on DOS separator
	my $npath = '';
	my $max = scalar @a;
	my @na = ();
	for (my $i = 0; $i < $max; $i++) {
		my $p = $a[$i];
		if ($p eq '.') {
			# ignore this
		} elsif ($p eq '..') {
			if (@na) {
				pop @na;	# discard previous
			} else {
				$wmsg = "WARNING: Got relative .. without previous!!! [$path]";
				prt( "$wmsg\n" );
				push(@warnings,$wmsg);
			}
		} else {
			push(@na,$p);
		}
	}
	foreach my $pt (@na) {
		$npath .= "\\" if length($npath);
		$npath .= $pt;
	}
	return $npath;
}

# 23/09/2008 from fgsln2dsw.pl
sub is_vcproj {
	my $fil = shift;
	if ($fil =~ /\.vcproj$/i) {
		return 1;
	}
	return 0;
}

sub resolve_depends {
	my ($projname, $projdeps, @arr, $cnt);
	my ($depid, $pn, $projid);
	my ($nmdeps, $fnd);
	foreach $projname (keys %sln_projects) {
		$projdeps = $sln_depends{$projname};
		if (length($projdeps)) {
			# there is LENGTH, convert giant CID to simple project names
			@arr = split( /\|/, $projdeps );	# split em up
			$cnt = scalar @arr;	# get count of split
			#prt( "Proj $projname, depends on $cnt = $projdeps ...\n" );
			$nmdeps = '';	# build simple NAME set
			foreach $depid (@arr) {
				foreach $pn (keys %sln_projids) {
					if ($pn ne $projname) {
						$projid = $sln_projids{$pn};
						if ($depid eq $projid) {
							$nmdeps .= '|' if (length($nmdeps));
							$nmdeps .= $pn;
							last;
						}
					}
				}
			}
			@arr = split( /\|/, $nmdeps );
			prt( "proj $projname, depends on $nmdeps ...\n" ) if ($dbg_s13);
			if ($cnt != scalar @arr) {	# YEEK - Does NOT match - OH WELL
				prtw( "WARNING: Failed to get SAME count $cnt - got ".scalar @arr."!\n" );
			}
			$sln_depends{$projname} = $nmdeps;
		}
	}
}

# Read and store contents of SOLUTION (.sln) file
# 22/04/2008 - Extract DEPENDENCIES from solution file, and add to DSW output
sub process_SLN {
	my ($fil) = shift;
	my ($cnt, $line, $vers, @arr, $mver, $par, $ff, $itmnum);
	my ($projname, $projfile, $projff, $gotproj, $relpath);
	my ($tnm,$tpth);
	my ($inproj, $tline, $projid, $inpdeps, $projdeps);
	open IF, "<$fil" or mydie( "ERROR: Unable to open $fil ... $! ...\n" );
	my @lines = <IF>;
	close IF;
	$cnt = scalar @lines;
	my ($name,$sln_path) = fileparse($fil);
	prt( "\nProcessing $cnt lines ... n=[$name] p=[$sln_path] ...\n" );
	$projname = '';
	$projfile = '';
	$projff = '';
	$gotproj = 0;
	$inproj = 0;
	$inpdeps = 0;
    my @projs = ();
	foreach $line (@lines) {
		$tline = trim_all($line);
		if ($line =~ /.+Format\s+Version\s+(\d+\.\d+)$/i) {
			$vers = $1;	# get n.nn version
			@arr = split(/\./,$vers);
			$mver = $arr[0];
			prt( "Is MSVC Version $mver ...\n" );
		} elsif ($line =~ /^Project\s*\(/) {
			# seek like 
			#Project("{8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942}") = "abyss", "abyss.vcproj", "{8B384B8A-2B72-4DC4-8DF1-E3EF32F18850}"
			###prt( "Got project [$line] ...\n" );
			$inproj = 1;
			@arr = split( '=', $line );
			$cnt = scalar @arr;
			if ($cnt == 2) {
				$par = $arr[1];
				@arr = split(',', $par);
				$cnt = scalar @arr;
				if ($cnt == 3) {
					$projname = strip_quotes(trim_all($arr[0]));
					$projfile = strip_quotes(trim_all($arr[1]));
					$projid   = strip_quotes(trim_all($arr[2]));
					$projff = fix_rel_path($sln_path.$projfile);
					if ((length($projname)) && (is_vcproj($projfile)) && (-f $projff)) {
						$gotproj = 1;
						($tnm,$tpth) = fileparse($projff);
						$relpath = get_rel_dos_path($tpth, $sln_path);
						prt( "Got PROJECT name=$projname, file=$projff, rel=[$relpath][$tnm].\n" ) if ($dbg_sl1);
                        push(@projs, [$projname, $relpath.$tnm]);
						###push(@proj_files, $projff);
						if (defined $sln_projects{$projname}) {
							mydie( "A PROBLEM: Already GOT this project name $projname!!!\n" );
						} else {
							$sln_projects{$projname} = $projff;
							$sln_projpath{$projname} = $relpath; # can be BLANK, or say 'BvMath/'
							$sln_projids{$projname}  = $projid;
							$sln_depends{$projname}  = '';	# start dependencies, if any
						}
					} else {
						prt( "WARNING: " );
						if (!length($projname)) {
							prt( "Failed to get a project name!" );
						} elsif ( !is_vcproj($projfile) ) {
							prt( "Name [$projfile] NOT a VCPROJ name!" );
						} else {
							prt( "Unable to locate file [$projff]!" );
						}
						prt( " Line is (trimmed)\n$tline\n" );
					}
				} else {
					prtw( "Warning: Part 2 of Project line did NOT split into 3 on comma!???\n" );
				}
			} else {
				prtw( "Warning: Project line did NOT split in 2 on equal sign!???\n" );
			}

			# to switch on $tryharder requires additional work on parsing this line
			# =====================================================================
			if (!$gotproj && $tryharder) {
				@arr = split( /\"/, $line );
				$itmnum = 0;
				foreach $par (@arr) {
					$itmnum++;
					###prt( "$itmnum [$par]\n" );
					if (is_vcproj($par)) {
						$ff = $sln_path.$par;
						prt( "Got PROJECT file [$par] " );
						if ( -f $ff) {
							prt( "ok" );
							###push(@proj_files, $ff);
							my ($nm,$pt,$ex) = fileparse( $ff, qr/\.[^.]*/ );
							$projname = $nm;
							if (defined $sln_projects{$projname}) {
								mydie( "A PROBLEM: Already GOT this project name $projname!!!\n" );
							} else {
								($tnm,$tpth) = fileparse($ff);
								$relpath = get_rel_dos_path($tpth, $sln_path);
								$sln_projects{$projname} = $ff;
								$sln_projpath{$projname} = $relpath; # can be BLANK, or say 'BvMath/'
								# WARNING: TO BE DONE !!!
								$sln_projids{$projname}  = $projid;
								$sln_depends{$projname}  = '';	# start dependencies, if any
							}
						} else {
							prt( "FAILED" );
						}
						prt("\n");
					}
				}
			}
			# =====================================================================
		} elsif ($inproj) {
			# in the Project section - look for END of section, and DEPENDENCIES
			# ProjectSection(ProjectDependencies)
			if ($tline eq 'EndProject') {
			###if ($line =~ /^EndProject\s*/)
				$inproj = 0;
			} else {
				if ($inpdeps) {
					if ($tline eq 'EndProjectSection' ) {
						$inpdeps = 0;
					} else {
						# collect dependencies
						@arr = split( '=', $line );
						$cnt = scalar @arr;
						if ($cnt == 2) {
							$arr[0] = trim_all($arr[0]);
							$arr[1] = trim_all($arr[1]);
							if ($arr[0] eq $arr[1]) {
								$projdeps = $sln_depends{$projname};	# extract dependencies, if any
								$projdeps .= '|' if (length($projdeps));
								$projdeps .= $arr[0];
								prt( "Proj $projname, dependant on $arr[0] ...\n" ) if ($dbg_s12);
								##prt( "Proj $projname, dependant on $projdeps ...\n" );
								$sln_depends{$projname} = $projdeps;
							} else {
								prtw( "Warning: Found different IDS '$arr[0]' NE '$arr[1]'!!! \n" );
							}
						} else {
							prtw( "Warning: Project DEPENDENCY line did NOT split in 2 on equal sign!???\n" );
							prtw( "line=$line" );
						}
					}
				} elsif ($line =~ /ProjectSection\s*\(\s*ProjectDependencies\s*\)/) {
					$inpdeps = 1;
				}
			}
		}
	}
	###prt( "Done $fil ... got ".scalar @proj_files." project files ...\n" );
	prt( "Done $fil ... got ".scalar keys(%sln_projects)." project files ...\n" );
	# resolve dependencies, if possible - warn if NOT ...
	resolve_depends();
    return @projs;
}

## } elsif (lc($fil_ext) eq 'sln') {
sub process_sln_file {
	my ($fil) = shift;
    return process_SLN($fil);
}

sub process_sln_file_OLD_but_OK {
	my ($fil) = shift;
	my ($lc, $wmsg);
	if ( !open INF, "<$fil" ) {
		$wmsg = "WARNING: Unable to open [$fil] ...";
		prtw( "$wmsg\n" );
		return 0;
	}
	my @lines = <INF>;
	close INF;
	$lc = scalar @lines;
	prt( "Processing SLN file [$fil] ... $lc lines ...\n" );
	my $cnt = 0;
	my @projs = ();
	foreach my $line (@lines) {
		$line = trim_all($line);
		if ($line =~ /Project\(.*=(.*)/) {
			$cnt++;
			##prt( "$1\n" );
			my @arr = split(/,/, $1);
			if (scalar @arr >= 2) {
				$arr[0] = trim_all($arr[0]);
				$arr[1] = trim_all($arr[1]);
				$arr[0] = substr($arr[0],1,length($arr[0])-2);
				$arr[1] = substr($arr[1],1,length($arr[1])-2);
				prt( "$cnt: Project=[".$arr[0]."] Path=[".$arr[1]."] ...\n" ) if ($dbg_sln);
				push(@projs, [ $arr[0], $arr[1] ]);
			}
		}
	}
	$cnt = scalar @projs;
	prt( "Done $lc lines ... $cnt projects ...\n" );
	##for (my $i = 0; $i < $cnt; $i++) {
	##	process_vcproj( fix_rel($fil_dir.$projs[$i][1]) );
	##}
	return @projs;
}


sub is_my_file {
	my ($f) = shift;
	my ($nm,$dir,$ext) = fileparse( $f, qr/\.[^.]*/ );
	my $lext = lc($ext);
	if (($lext eq '.c')||($lext eq '.cpp')||($lext eq '.cxx')) {
		return 1;
	}
	return 0;
}

sub process_directory { ## $in_folder
	my ($inf, $lev) = @_;
	my $rcnt = 0;
	my ($DH);
    $inf = '.' if (length($inf) == 0);
	if ( !opendir($DH, $inf) ) {
		prt( "ERROR: Unable to OPEN FOLDER [$inf] ... $! ... \n" );
		return $rcnt;
	}
	my @files = readdir($DH);
	closedir $DH;
	my $fcnt = scalar @files;
	prt( "Have $fcnt to process from $inf ...\n" ) if ($dbg3);
	foreach my $file (@files) {
		if (($file eq '.') || ($file eq '..')) {
			next;
		}
		my $ff = $inf;
		$ff .= "\\" if !($ff =~ /\\$/);
		$ff .= $file;
		if ( -d $ff ) {
            $dirs_count++;
			if ($recursive) {
				###if (!in_excl_list($file)) {
				$rcnt += process_directory( $ff, $lev + 1 );
			}
		} else {
			# is a FILE
            $file_count++;
			if ( is_my_file($file) ) {
				push(@dir_list, $ff);
				$rcnt++;
			}
		}
	}
	return $rcnt;
}

sub do_directory_scan {
    my ($bd) = shift;
    prt( "Moment, doing a full directory scan ...\n" );
    $dir_cnt = process_directory( $bd, 0 );
    if ($srccnt) {
        my $ccnt = scalar @srcsc;
        prt( "\nScanned $dirs_count directories, finding $file_count files ...\n" );
        prt( "Found $srccnt source files, $ccnt C/C++ sources, $dir_cnt from search ...\n" );
        # compare push(@srcsc, $asrc); from vcproj, and
        # push(@dir_list, $ff); from directory search
        for (my $i = 0; $i < $dir_cnt; $i++) {
            my $fil1 = $dir_list[$i];
            my $fnd = 0;
            for (my $j = 0; $j < $ccnt; $j++) {
                my $fil2 = $srcsc[$j];
                if ($fil1 eq $fil2) {
                    $fnd = 1;
                    last;
                }
            }
            if (!$fnd) {
                prt( "$fil1 NOT IN VCPROJ files???\n" );
            }
        }
    }

    if (@missing) {
        my $mcnt = scalar @missing;
        prt( "Got $mcnt MISSING, as follows ...\n" );
        my $cfil = '';
        my ($fil, $mis, $i);
        for ($i = 0; $i < $mcnt; $i++) {
            $fil = $missing[$i][0];
            $mis = $missing[$i][1];
            if ($fil ne $cfil) {
                prt( "Missing from $fil ...\n" );
                $cfil = $fil;
            }
            prt( "$mis - MISSING\n" ); 
        }
    }
}

############################################################################
########### TRY FOR MORE DECODE OF THE XML #######

#################################################
##### VCPROJ XML PARSING #####
#################################################


sub get_xml_tag {
	my ($lin) = shift;
	my $len = length($lin);
	my $tag = '';
	my $pch = '';
	for (my $t = 0; $t < $len; $t++) {
		my $ch = substr($lin,$t,1);
		if ($ch eq '<') {
			prtw( "WARNING: Second TAG in line! ($lin)\n" ) if (length($tag));
			$tag = '';
			$t++;
			for ( ; $t < $len; $t++) {
				$ch = substr($lin,$t,1);
				if ($ch =~ /\s/) {
					# end of tag
					$t++;
					for ( ; $t < $len; $t++) {
						$ch = substr($lin,$t,1);
						if ($ch eq '>') {
							$tag .= $pch if ($pch eq '/');
							prtw( "WARNING: Premature CLOSE! ($lin)(1)\n" ) if (($t +1) < $len);
							last;	# end of TAG
						}
						$pch = $ch;	# keep last
					}
					last;
				} elsif ($ch eq '>') {
					prtw( "WARNING: Premature CLOSE! ($lin)(2)\n" ) if (($t +1) < $len);
					last;
				}
				$tag .= $ch;
			}
		}
	}
	return $tag;
}

sub tag_typ_2_stg {
	my ($typ) = shift;
	if ($typ == $TYP_OPEN) {
		return "OPEN";
	} elsif ($typ == $TYP_CLOSE) {
		return "CLOSE";
	} elsif ($typ == $TYP_OPENCLOSE) {
		return "OPENCLOSE";
	} elsif ($typ == $TYP_VERSION) {
		return "VERSION";
	}
	return "UNKNOWN";
}

sub get_tag_typ {
	my ($xt) = shift;
	my $typ = $TYP_OPEN;
	if ($xt =~ /^\//) {
        # starts with forward slash, so
		$typ = $TYP_CLOSE;
	} elsif ($xt =~ /\/$/) {
        # ends with forward slash, so
		$typ = $TYP_OPENCLOSE;
	} elsif ($xt eq '?xml') {
		$typ = $TYP_VERSION;
	}
    # none of the above, so return $TYP_OPEN
	###prt( "For [$xt] returning [$typ] ...\n" );
	return $typ;
}

# get application type
# one of Console Application, Application, static library, dynamic library
sub fg_get_app_type {
	my ($defs, $ln) = @_;
	my ($def, $key);
	my @arr = split(';',$defs);
	foreach $def (@arr) {
		foreach $key (keys %v8_defines) {
			if ($def eq $key) {
				return $v8_defines{$key};
			}
		}
	}
	# ok, nothing found - TRY HARDER
	foreach $def (@arr) {
		if ($def =~ /BUILD_LIBRARY/) {
			return $v8_defines{'_LIB'};
		} elsif ($def =~ /STATIC/) {
			return $v8_defines{'_LIB'};
		}
	}
	# UGH - still NOT FOUND - provide overrides for
	foreach $def (@special_typing) {
		if ($act_vcproj =~ /$def/) {
            if ($dbg_x02) {
                prtw( "WARNING: String [$defs] no clue to TYPE!!!\n".
                    "Typed from special_typing list!\n".
                    "$ln: $act_vcproj - return static library ??? CHECK ME\n" );
            }
			return $v8_defines{'_LIB'};
		}
	}
	prtw( "WARNING: String [$defs] does not give clue to TYPE!!!\n$ln: $act_vcproj - return def $typelse ??? CHECK ME\n" );
	return $typelse;
}

sub space_split_blocks {
	my ($txt) = shift;
	my $len = length($txt);
	my ($k, $ch, $tag, $inblk);
	my @arr = ();
	$tag = '';
	$inblk = 0;
	for ($k = 0; $k < $len; $k++) {
		$ch = substr($txt,$k,1);
		if ($inblk) {
			$inblk = 0 if ($ch eq ']');
			$tag .= $ch;
		} elsif ($ch =~ /\s/) {
			push(@arr, $tag) if (length($tag));
			$tag = '';
		} else {
			$tag .= $ch;
			$inblk = 1 if ($ch eq '[');
		}
	}
	push(@arr, $tag) if (length($tag));
	if ($dbg_src13) {
		prt( "space_split (".scalar @arr.") of [$txt]\n" );
		foreach $tag (@arr) {
			prt( " $tag\n" );
		}
	}
	return @arr;
}

sub array_2_hash_on_equals_OLD {
	my (@inarr) = @_;
	my %hash = ();
	my ($itm, @arr, $key, $val, $al, $a);
	foreach $itm (@inarr) {
		@arr = split('=',$itm);
		$al = scalar @arr;
		$key = $arr[0];
		$val = '';
		for ($a = 1; $a < $al; $a++) {
			$val .= '=' if length($val);    # put back the equal sign, if more than 1 component
			$val .= $arr[$a];
		}
		if (defined $hash{$key}) {
            if (length($val)) {
                prtw( "WARNING: Duplicate KEY: $key ...\n" );
                $hash{$key} .= "@".$val;
            }
		} else {
			$hash{$key} = $val;
		}
        prt( "Got equal split of [$key] = [$val]\n" ) if ($dbg_x10);
	}
	return %hash;
}

# @arr = split_conf( $dsp_defines_dbg );
sub split_conf {
	my ($cc) = shift;
	my $ln = length($cc);
	my @ar = ();
	my $itm = '';
	for (my $p = 0; $p < $ln; $p++) {
		my $ch = substr($cc,$p,1);
		if ($ch eq '"') {
			$p++;
			$itm = '';
			for (; $p < $ln; $p++) {
				$ch = substr($cc,$p,1);
				if ($ch eq '"') {
					last;
				}
				$itm .= $ch;
			}
			push(@ar,$itm) if length($itm);
		}
	}
	return @ar;
}

sub is_in_skip_conf_rel {
	my ($itm) = shift;
	foreach my $tst (@dsp_base_defs_rel) {
		if ($itm eq $tst) {
			return 1;
		}
	}
	return 0;
}
sub is_in_skip_conf_dbg {
	my ($itm) = shift;
	foreach my $tst (@dsp_base_defs_dbg) {
		if ($itm eq $tst) {
			return 1;
		}
	}
	return 0;
}

sub is_in_skip_lib_rel {
	my ($itm) = shift;
	foreach my $tst (@dsp_base_libs_rel) {
		if ($itm =~ /$tst/i) {
			return 1;
		}
	}
	return 0;
}
sub is_in_skip_lib_dbg {
	my ($itm) = shift;
	foreach my $tst (@dsp_base_libs_dbg) {
		if ($itm =~ /$tst/i) {
			return 1;
		}
	}
	return 0;
}

sub set_runtime_dbg { $dsp_runtime_dbg = shift; }
sub set_runtime_rel { $dsp_runtime_rel = shift; }
# new 21/09/2008
sub set_includes_dbg { $dsp_includes_dbg = shift; }
sub set_includes_rel { $dsp_includes_rel = shift; }

sub get_group_type {
    my ($src) = shift;
    my ($n,$d,$s) = fileparse($src, qr/\.[^.]*/ );
    my (@arr, $ext, $ex);
    $ex = substr($s,1) if ($s =~ /^\./);
    $ex = lc($ex);
    if (length($ex) == 0) {
        return GRP_HDR; # default to header is NO EXT
    }

    @arr = split(';', $def_src_filt);
    foreach $ext (@arr) {
        if ($ext eq $ex) {
            return GRP_SRC;
        }
    }

    @arr = split(';', $def_hdr_filt);
    foreach $ext (@arr) {
        if ($ext eq $ex) {
            return GRP_HDR;
        }
    }

    @arr = split(';', $def_rcs_filt);
    foreach $ext (@arr) {
        if ($ext eq $ex) {
            return GRP_RCS;
        }
    }

    @arr = split(';', $def_spl_filt);
    foreach $ext (@arr) {
        if ($ext eq $ex) {
            return GRP_SPL;
        }
    }

    prt( "CHECK EXTENSION: What group [$src], with ext [$s] or [$ex] ...\n" );
    return GRP_UNK; # not found, so UNKNOWN
}

sub get_def_group_name {
    my ($grp) = shift;
    if ($grp == GRP_SRC) {
        return $def_src_grp;
    }
    if ($grp == GRP_HDR) {
        return $def_hdr_grp;
    }
    if ($grp == GRP_RCS) {
        return $def_rcs_grp;
    }
    if ($grp == GRP_SPL) {
        return $def_spl_grp;
    }
    return $def_unknown." Group";
}

sub get_def_group_filter {
    my ($grp) = shift;
    if ($grp == GRP_SRC) {
        return $def_src_filt;
    }
    if ($grp == GRP_HDR) {
        return $def_hdr_filt;
    }
    if ($grp == GRP_RCS) {
        return $def_rcs_filt;
    }
    if ($grp == GRP_SPL) {
        return $def_spl_filt;
    }
    return $def_unknown." Filter";
}

# RUNTIME conversions
# #################################################
sub fg_get_runtime_val_2_lts {
	my ($rtn) = shift;
    my $len = scalar @runtimes_array;
    for (my $i = 0; $i < $len; $i++) {
        my $itm = $runtimes_array[$i][RT_VAL];  # [3];
        if ($itm == $rtn) {
            return "/" . $runtimes_array[$i][RT_LTS];   # [1];
        }
    }
    prtw( "WARNING: $rtn not found in runtimes_array! Using default '/$def_runtime_lts'!!\n" );
	return "/$def_runtime_lts";
}

# 24/09/2008 - convert letters to human string
sub fg_get_runtime_lts_2_stg {
	my ($rtn) = shift;
    my $len = scalar @runtimes_array;
    $rtn =~ s/^\///;    # remove any leading '/' ...
    for (my $i = 0; $i < $len; $i++) {
        my $itm = $runtimes_array[$i][RT_LTS];  # [1];
        if ($itm eq $rtn) {
            return $runtimes_array[$i][RT_STG]; # [2];
        }
    }
    prtw( "WARNING: [$rtn] not found in runtimes_array! Using default '$def_runtime_stg'!!\n" );
	return $def_runtime_stg;
}

sub fg_get_runtime_stg_2_val {
	my ($rtn) = shift;
    my $len = scalar @runtimes_array;
    for (my $i = 0; $i < $len; $i++) {
        my $itm = $runtimes_array[$i][RT_STG];
        if ($itm eq $rtn) {
            return $runtimes_array[$i][RT_VAL];
        }
    }
    prtw( "WARNING: [$rtn] not found in runtimes_array! Using default $def_runtime_val\n" );
	return $def_runtime_val;
}

sub fg_get_runtime_stg_2_lts {
	my ($rtn) = shift;
    my $len = scalar @runtimes_array;
    for (my $i = 0; $i < $len; $i++) {
        my $itm = $runtimes_array[$i][RT_STG];
        if ($itm eq $rtn) {
            return '/'.$runtimes_array[$i][RT_LTS];
        }
    }
    prtw( "WARNING: [$rtn] not found in runtimes_array! Using default /$def_runtime_lts\n" );
	return "/$def_runtime_lts";
}
# #################################################

sub get_runtime_stg_OLD_NOT_USED {
	my ($rtn) = shift;
	if ($rtn == 0) {
		return "/MT";
	} elsif ($rtn == 1) {
		return "/MTd";
	} elsif ($rtn == 2) {
		return "/MD";
	} elsif ($rtn == 3) {
		return "/MDd";
	}
	return "/MT";
}

sub fix_rel_path {
	my ($path) = shift;
	$path = path_u2d($path);	# ENSURE DOS PATH SEPARATOR (in relative.pl)
	my @a = split(/\\/, $path);
	my $npath = '';
	my $max = scalar @a;
	my @na = ();
	for (my $i = 0; $i < $max; $i++) {
		my $p = $a[$i];
		if ($p eq '.') {
			# ignore this
		} elsif ($p eq '..') {
			if (@na) {
				pop @na;	# discard previous
			} else {
				prtw( "WARNING: Got relative .. without previous!!! path=$path\n" );
			}
		} else {
			push(@na,$p);
		}
	}
	foreach my $pt (@na) {
		$npath .= "\\" if length($npath);
		$npath .= $pt;
	}
	return $npath;
}
### utitlity subs

sub get_suffix {
	my ($f) = shift;
	my @arr = split(/\./,$f);
	return $arr[-1];
}

sub is_rc_file {
    my ($f) = shift;
    my $s = get_suffix($f);
    if (lc($s) eq 'rc') {
        return 1;
    } elsif ($s =~ /^rc/i) {
        return 2;
    }
    return 0;
}

sub is_in_array_nc {
	my ($itm, @arr) = @_;
	foreach my $val (@arr) {
		if ($val =~ /$itm/i) {
			return 1;
		}
	}
	return 0;
}

sub get_tt_string {
    my ($val) = shift;
    if ($val == TT_UNK) {
        return "Unknown";
    } elsif ($val == TT_BGN) {
        return 'Begin';
    } elsif ($val == TT_END) {
        return 'End';
    } elsif ($val == TT_BE) {
        return 'BE';
    } elsif ($val == TT_DEC) {
        return 'Decl';
    }
    return "MISSED IT";
}

# search forward in the XML line array
# assumed to be already arranged in neat XML lines
# and if 'ExcludedFromBuild' found in FileConfiguration
sub exclude_from_build {
    my ($j) = shift;
    my $max = scalar @xml_lines;
    for ( ; $j < $max; $j++) {
        my $ln = trim_all( $xml_lines[$j] );
		my $xt = get_xml_tag($ln);
        prt( "DEBUG:$j: line=[$ln], tag=[$xt]\n" ) if ($dgb_x05);
        my %ah = array_2_hash_on_equals(space_split($ln));
        if (($xt eq 'File') && ( defined $ah{'RelativePath'} ) ) {
            # good START
            $j++;   # got to NEXT line, and go until </File>
            $ln = trim_all( $xml_lines[$j] );
    		$xt = get_xml_tag($ln);
            if ($ln =~ /<\/File>/) {
                prt( "DEBUG:$j:LAST: line=[$ln], tag=[$xt]\n" ) if ($dgb_x05);
                last;
            }
            %ah = array_2_hash_on_equals(space_split($ln));
            if ($ln =~ /<FileConfiguration/) {
                my $cfg = "unknown";
                if (defined $ah{'Name'}) {
                    $cfg = $ah{'Name'};
                }
                if (defined $ah{'ExcludedFromBuild'}) {
                    my $res = strip_quotes(trim_all($ah{'ExcludedFromBuild'}));
                    if ($res eq 'true') {
                        prt( "DEBUG:$j:true: cfg=$cfg, line=[$ln], tag=[$xt]\n" ) if ($dgb_x05);
                        return 1;
                    } else {
                        prt( "DEBUG:$j:false: cfg=$cfg, line=[$ln], tag=[$xt]\n" ) if ($dgb_x05);
                        return 0;
                    }
                }
            }
            prt( "DEBUG:$j: line=[$ln], tag=[$xt]\n" ) if ($dgb_x05);
        } else {
            last;
            prtw( "WARNING: Failed to get <File RelativePath>\n" );
            mydie( "FIX ME FIRST!\n" );
        }
    }
    return 0;
}

sub fg_reline_xml {
    my (@lns) = @_;
    my $intag = 0;
    my $text = '';
    my @nlines = ();
    my @tagmap = ();
    my @xlnmap = ();
    my ($fln, $ln, $ch, $pch, $nch, $len, $i, $i2, $tag, $xml, $dnx);
    my ($lnnm, $lnb, $nlnm);
    $pch = '';
    $nch = '';
    $tag = '';
    $xml = '';
    $dnx = 0;
    $lnnm = 0;
    $nlnm = 0;
    $lnb = 0;
    foreach $fln (@lns) {
        chomp $fln;
        $ln = trim_all($fln);
        $len = length($ln);
        $lnnm++;    # count another xml line
        for ($i = 0; $i < $len; $i++) {
            $i2 = $i + 1;
            $ch = substr($ln,$i,1);
            $nch = (($i2 < $len) ? substr($ln,$i2,1) : ' ');
            if ($intag) {
                # on first SPACE
                if ( !$dnx && (($ch eq ' ')||($ch eq "\t")||($ch =~ /\s/)) ) {
                    $dnx = 1;
                    $xml = substr($tag,1);
                    if ($xml =~ /^\?/) {
                        push(@tagmap, [$xml, TT_DEC, 1]);
                    } elsif ($xml =~ /^\//) {
                        $xml = substr($xml,1);
                        push(@tagmap, [$xml, TT_END, 1]);
                    } else {
                        push(@tagmap, [$xml, TT_BGN, 1]);
                    }
                }
                $tag .= $ch;
                if ($ch eq '>') {
                    # end of XML tag
                    if (!$dnx) {
                        $xml = substr($tag,1,length($tag)-2);
                        if ($xml =~ /^\?/) {
                            push(@tagmap, [$xml, TT_DEC, 2]);
                        } elsif ($xml =~ /^\//) {
                            $xml = substr($xml,1);
                            push(@tagmap, [$xml, TT_END, 2]);
                        } elsif ($pch eq '/') {
                            push(@tagmap, [$xml, TT_BE, 2]);
                        } else {
                            push(@tagmap, [$xml, TT_BGN, 2]);
                        }
                    } else {
                        if ($pch eq '/') {
                            $tagmap[-1][1] = TT_BE;
                        }
                    }
                    $nlnm++;
                    push(@nlines,$tag);
                    ### prt( "push(\@xlnmap, [ $nlnm, $lnb, $lnnm ]); # each NEW line has BEGIN and END\n" );
                    push(@xlnmap, [ $nlnm, $lnb, $lnnm ]); # each NEW line has BEGIN and END
                    $tag = '';
                    $intag = 0;
                    $xml = '';
                }
            } else {
                if ($ch eq '<') {
                    $tag = $ch; # start a tag line
                    $intag = 1; # signal in a tag
                    $xml = '';
                    $dnx = 0;
                    $lnb = $lnnm;    # set the BEGIN xml line
                }
            }
            $pch = $ch;
        }
        # done a line - this is like a SPACE
        if ($intag && length($tag)) {
            if ( !$dnx ) {
                $dnx = 1;
                $xml = substr($tag,1);
                if ($xml =~ /^\?/) {
                    push(@tagmap, [$xml, TT_DEC, 3]);
                } elsif ($xml =~ /^\//) {
                    $xml = substr($xml,1);
                    push(@tagmap, [$xml, TT_END, 3]);
                } else {
                    push(@tagmap, [$xml, TT_BGN, 3]);
                }
            }
            $tag .= ' ' if !($tag =~ /\s$/);
        }
    }
    if (length($tag)) {
        prtw("WARNING: xml re-lining error! Left pending tag [$tag]\nin $act_vcproj file ...\n");
    }

    # store global tag map, lines, and a line map
    @xml_tag_map = @tagmap;
    @xml_lines = @nlines;
    @xml_line_map = @xlnmap;
    $xml_last_line = 0;
    if ($dbg_x01) {
        $ln = 0;
        $tag = '';
        foreach $xml (@nlines) {
            $ln++;
            $tag .= "$ln: $xml\n";
        }
        write2file( $tag, 'tempxml.txt');
        #write2file( join("\n",@nlines), 'tempxml.txt');
        $len = scalar @tagmap;
        $ln = '';
        for ($i = 0; $i < $len; $i++) {
            $tag = $tagmap[$i][0];
            $ch = $tagmap[$i][1];
            $nch = $tagmap[$i][2];
            $pch = get_tt_string($ch);
            $ln .= "$tag $pch ($ch) [$nch]\n";
        }
        write2file( $ln, 'tempxml2.txt' );
    }
    return @nlines;
}

### $v8_filter{$filtname} = merge_filters($v8_filter{$filtname}, $filttype); 
sub merge_filters {
    my ($f1, $f2) = @_;
    my @a1 = split(";",$f1);
    my @a2 = split(";",$f2);
    my $nf = '';
    foreach my $f (@a2) {
        # if new is not in old
        if (! is_in_array($f, @a1) ) {
            $nf .= ';' if length($nf);
            $nf .= $f;
        }
    }
    $f1 .= ';' if length($nf);
    $f1 .= $nf;
}

sub get_mapped_lines {
    my ($nln) = shift;
    my $max = scalar @xml_line_map;
    my $n = $xml_last_line;
    my $nn;
    for (; $n < $max; $n++) {
        $nn = $xml_line_map[$n][0]; # extract new line number
        if ($nln == $nn) {
            $xml_last_line = $n;
            my $res = "$nln:".$xml_line_map[$n][1].":".$xml_line_map[$n][2];
            ### prt( "Found [$nln] == [$nn] - return $res\n" );
            return $res;
        } elsif ($nn > $nln) {
            $xml_last_line = $n;
            my $res = "$nln:".$xml_line_map[$n][1].":".$xml_line_map[$n][2];
            ### prt( "Found [$nln] > [$nn] - return $res\n" );
            return $res;
        }
    }
    return "$nln:?:?";
}

# get_xml_source
# process the XML project file (*.vcproj) and
# extract the SOURCE file list,
# but do lots MORE than that ...
sub get_xml_sources {
	my ($in) = shift;
	my ($in_name,$in_fd,$in_suffix) = fileparse($in);
	my ($src, $ff, $pline);
	my $stf = '<File\\s+RelativePath=\\"([\\.\\\\\\w-]+)+\\"+(.)+';
	#my $filt = '^<Filter\\s+Name=\\"([\\w\\s]+)\\"\\s+Filter=\\"([\\w;]+)\\"';
	my @lines = ();
	my $line = '';
	my $filtname = '';
	my $filttype = '';
	my $conf = '';
	my $tname = '';
	my $version = 'Unknown';
	my $projname = '';
	my $srccount = 0;
	my @xmltags = ();
	my $xmltag = '';
	my $tagtyp = 0;
	my $lnnum = 0;
	my $nlnnum = 0;
	my $bgn = 0;
	my $end = 0;
	my $ll = 0;
	my $ch = '';
	my $bgnend = '';
	my $inconfigs = 0;
	my $ppdefs = '';
	my $apptype = '';   # one of the various types
	my $adddeps = '';
	my @attribs = ();
	my %atthash = ();
	my $ctype = 0;
	my $def = '';
	my ($func, $itm, $ffnr, $shr, $tmpsrc);
    my $dnaptype = 0;
    my $gottoolname = 0;
    my ($funcinc, $pname, $ProjectGUID, $ckey);
    my ($i, $j, $msg, $tmpdbg);
    my $infiles = 0;    # in the <Files> section of the XML
    my $cfgcount = 0;   # each file will have multiple 'configurations', and some things are global
    $act_vcproj = $in;
	prt( "\nLoading [$in] file in directory [$in_fd] ...\n" ) if ($dbg_x17);
	open FH, "<$in" or mydie( "ERROR: Can not open [$in] ... aborting ...\n" );
	@lines = <FH>; # slurp the whole file
	close( FH );
	my $fline = '';
    my $lncnt = scalar @lines;
	prt( "Processing VCPROJ $lncnt lines in $in ...\n" );
    $tot_vclines += $lncnt;
	my $hadver = 0;
    my $hadlibtool = 0;
    @lines = fg_reline_xml(@lines);
    $lncnt = scalar @lines;
    if ($lncnt != scalar @xml_tag_map) {
        prtw( "WARNING: xml lines $lncnt NOT SAME AS xml_tag_map ".scalar @xml_tag_map." CHECK THIS!\n" );
    }
	###foreach $line (@lines) {
    for ($i = 0; $i < $lncnt; $i++) {
        $line = $lines[$i];
        $nlnnum++;  # bump the array line number
		$lnnum = get_mapped_lines($nlnnum);
		$line = trim_all($line);
		$ll = length($line);
		if ($ll) {
			if (length($fline)) {
				$fline .= ' '.$line;
			} else {
				$ch = substr($line,0,1);
				$fline .= $line;
				if ($ch eq '<') {
					$bgn = $lnnum;  # set the BEGIN line number
				}
			}
		} else {
			next;   # skip BLANK lines
		}
        # only get interested when the XML closes ...
		if ($fline =~ />/) {
			$bgnend = "$bgn-$lnnum";
			$bgn = -1;
			$xmltag = get_xml_tag($fline);
			$tagtyp = get_tag_typ($xmltag);
			prt( "$bgnend: $xmltag ".tag_typ_2_stg($tagtyp). " ($tagtyp)\n" ) if ($dbg_src9);
			@attribs = space_split($fline);
			%atthash = array_2_hash_on_equals(@attribs);
            if ($dbg_x08) {
                $ll = 0;
                prt( "dbg_x08: Showing _ALL_ for tag=[$xmltag], line=[$fline]\n" );
                foreach $ppdefs (sort @attribs) {
                    $ll++;
                    prt( "dbg_x08:ats:$ll: [$ppdefs]\n" );
                }
                $ctype = 0;
                foreach $ppdefs (sort keys %atthash) {
                    $ctype++;
                    prt( "dbg_x08:key:$ctype: [$ppdefs] = [".$atthash{$ppdefs}."]\n" );
                }
                if ($ll != $ctype) {
                    mydir( "DEAD IN THE WATER! Array size $ll not same as hash $ctype!!!\n" );
                }
            }

            $pname = '';
            if (defined $atthash{'Name'}) {
                $pname = strip_quotes(trim_all($atthash{'Name'}));
                prt( "tag=$xmltag, Name=$pname (ln=$lnnum)\n" ) if ($dbg_x04);
            }
			if ((defined $atthash{'<VisualStudioProject'}) || ($fline =~ /<VisualStudioProject\s+/)) {
                $version = '';
                $ProjectGUID = '';
                if (defined $atthash{'Version'}) {
                    $version = strip_quotes(trim_all($atthash{'Version'}));
                    $hadver = 1;
				}
                if (defined $atthash{'ProjectGUID'}) {
                    $ProjectGUID = strip_quotes(trim_all($atthash{'ProjectGUID'}));
                }
				$projname = $pname;
				##prt( "$fline\n" );
				prt( "Project=$projname, v=$version GUID=$ProjectGUID\n" ) if ($dbg_src11);
                mydie( "BIG PROBLEM! project name is blank!!\n" ) if (length($projname) == 0);
			} elsif ($fline =~ /$stf/) {
				# <File RelativePath="src\FDM\SP\ACMS.cxx" >
				$src = $1;
                $act_file = $src;
				$ff = $in_fd . $src;
				$ffnr = fix_rel_path($ff);
				$itm = "MISSING";
                if (exclude_from_build($i)) {
                    $itm = $excl_mark; # "EXCLUDED";
                } elsif (-f $ffnr) {
					$itm = "ok";
					prt( "SRC: [$ffnr] $itm\n" ) if ($dbg_src16);
				} else {
                    if (is_c_source($src) || $dbg_src16) {
        				prt( "SRC: [$ffnr] $itm [$src][$ff] CHECKME!\n" );	# always SHOW MISSING if ($dbg_src16);
                    }
				}
                $act_disp = $itm;   # can be 'MISSED', 'EXCLUDED', or 'ok'
                if (is_c_source($src)) {
					prt("SOURCE=[$src]\n") if ($dbg_src1);
				} elsif (is_h_source($src)) {
					prt("HEADER=[$src]\n") if ($dbg_src2);
				} elsif (is_h_special($src)) {
					prt("HEADER=[$src]\n") if ($dbg_src2);
				} else {
					prt("OTHER=[$src]\n") if ($dbg_src3);
				}
				$srccount++;
                $shr = get_group_type($src);
				prt( "$srccount v8_srcs: $src, $ffnr, $filtname, $filttype, 0, 0, $projname);\n" ) if ($dbg11);
				#                0    1      2          3          4  5  6          7     8
				push(@v8_srcs, [$src, $ffnr, $filtname, $filttype, 0, 0, $projname, $shr, $itm] );
			} elsif ((defined $atthash{'<Filter'})||($fline =~ /<Filter\s+/)) {
				# <Filter Name="Source Files" Filter="cpp;c;cxx;rc;def;r;odl;idl;hpj;bat">
				$filtname = ''; # = NO FILTER NAME, like Source Files
				$filttype = ''; # = NOR FILTER TYPE, like cpp;c;cxx;rc;def;r;odl;idl;hpj;bat
                if (defined $atthash{'Name'} ) {
                    $filtname = strip_quotes(trim_all($atthash{'Name'}));
                } elsif ($fline =~ /\s+Name=\"([\w\s]+)\"[\s>]+/) {
					$filtname = $1; # = Source Files
				}
                if (defined $atthash{'Filter'} ) {
                    $filttype = strip_quotes(trim_all($atthash{'Filter'}));
                } elsif ($fline =~ /\s+Filter=\"([\w;,]+)\"[\s>]+/) {
					$filttype = $1; # = cpp;c;cxx;rc;def;r;odl;idl;hpj;bat
				}
                if ( length($filtname) && length($filttype) ) {
                    if ( defined $v8_filter{$filtname} ) {
                        $v8_filter{$filtname} = merge_filters($v8_filter{$filtname}, $filttype); 
                    } else {
                        $v8_filter{$filtname} = $filttype;
                    }
                }
				prt("FILTNAME=[$filtname] [$filttype]\n") if ($dbg_src4);
			###} elsif ($fline =~ /$v8_cfgexp/ ) {
            } elsif ($fline =~ /<Configuration\s+(.+)$/) {
				##if ($fline =~ /<Configuration\s+.*Name=\"(\S+)\"\s/ )
                # <Configuration
                #  Name="LIB Release|Win32"
                #  OutputDirectory=".\Win32_LIB_Release"
                #  IntermediateDirectory=".\Win32_LIB_Release"
                #  ConfigurationType="4"
                #  InheritedPropertySheets="$(VCInstallDir)VCProjectDefaults\UpgradeFromVC60.vsprops"
                #  UseOfMFC="0"
                #  ATLMinimizesCRunTimeLibraryUsage="false">
				#@attribs = space_split($fline);
				#%atthash = array_2_hash_on_equals(@attribs);
                if (length($pname)) {
                    $conf = $pname;
                } elsif (defined $atthash{'Name'} ) {
                    $adddeps = strip_quotes(trim_all($atthash{'Name'}));
                    $conf = $adddeps;
                } else {
                    mydie("ERROR: No 'Name' found in [$fline] - def to [$conf] CHECK THIS! In $act_vcproj!\n");
                }
                $ctype = 0;
                $def = '<UNKNOWN-CHECK-ME>';
                # the name can be 'Name="LIB Release|Win32"', as in libpng ...
                ###if ($conf =~ /^Debug\|/) { this is TOO restrictive, try
                if ($conf =~ /Debug/i) {
                    $ctype = 1;
                    $def = $dsp_runtime_dbg;
                    $func = \&set_runtime_dbg;
                    $funcinc = \&set_includes_dbg;  # { $dsp_includes_dbg = shift; }
                } elsif ($conf =~ /Release/i) {
                    ###} elsif ($conf =~ /^Release\|/) { too restrictive
                    $ctype = 2;
                    $def = $dsp_runtime_rel;
                    $func = \&set_runtime_rel;
                    $funcinc = \&set_includes_rel;  # { $dsp_includes_rel = shift; }
                } else {
                    prtw( "WARNING: CHECK ME CONF: Not Debug or Release ... WHAT IS IT? [$conf] ASSUME RELEASE,\n".
                        "line=[$fline] ... \n".
                        "(ln=$lnnum) $act_vcproj!\n" );
                    $ctype = 2;
                    $def = $dsp_runtime_rel;
                    $func = \&set_runtime_rel;
                    $funcinc = \&set_includes_rel;  # { $dsp_includes_rel = shift; }
                }
                # my %v8_config = ();  #  by configuration, OutputDirectory=".\Release", IntermediateDirectory="Release",
                # and zlib = ConfigurationType="4", alut = ConfigurationType="2", fg = ConfigurationType="1"
                #  // This is an internal type to Visual Studio, it seems that:
                #  // 4 == static library
                #  // 2 == dll
                #  // 1 == executable
                #  // 10 == utility
                if (defined $atthash{'ConfigurationType'}) {
                    $adddeps = strip_quotes(trim_all($atthash{'ConfigurationType'}));
                    if (defined $v8_conftypes{$adddeps}) {
                        $apptype = $v8_conftypes{$adddeps};
                        $dnaptype = 1;  # signal, no need to try to parse defines
                    }
                }
                $adddeps = '';
                if (defined $atthash{'OutputDirectory'}) {
                    $adddeps .= "$out_dir=".add_quotes(strip_dotrel(strip_quotes(trim_all($atthash{'OutputDirectory'}))));
                }
                if (defined $atthash{'IntermediateDirectory'}) {
                    $adddeps .= ' ' if length($adddeps);
                    $adddeps .= "$int_dir=".add_quotes(strip_dotrel(strip_quotes(trim_all($atthash{'IntermediateDirectory'}))));
                }
                if (defined $v8_config{$conf}) {
                    if (length($adddeps)) {
                        if ($v8_config{$conf} ne $adddeps) {
                            prtw("WARNING: conf $conf ALREADY in v8_config as ".$v8_config{$conf}."! Adding $adddeps!! (ln=$lnnum)\n" );
                        }
                    }
                } else {
                    $v8_config{$conf} = $adddeps;
                }
                $cfgcount++;
				prt( "Got configuration [$conf] [$projname] [$apptype] (ln=$lnnum, cnt=$cfgcount)\n" ) if ($dbg_src6);
			} elsif ($fline =~ /<Tool\s+(.*)$/ ) {
				#} elsif ($fline =~ /$v8_toolexp/ ) {
				$pline = $1;
				#@attribs = space_split($fline);
				#%atthash = array_2_hash_on_equals(@attribs);
                $gottoolname = 0;
                if (length($pname)) {
                    $tname = $pname;
                    $gottoolname = 1;
                } elsif (defined $atthash{'Name'}) {
                    $tname = strip_quotes(trim_all($atthash{'Name'}));
                    $gottoolname = 1;
                }
				#prt( "Got Tool $pline\n" ) if ($dbg_src7);
				if ($gottoolname || ($pline =~ /\s*Name=\"*(\w+)\"*/)) {
                    if (!$gottoolname) {
    					$tname = $1;
                    }
					prt( "Got Tool name $tname ...\n" ) if ($dbg_src7);
					if ($tname eq 'VCCLCompilerTool') {
						# <Tool
						# Name="VCCLCompilerTool"
						# Optimization="0"
						# AdditionalIncludeDirectories="../lib,../lib/curl_transport,...
						# PreprocessorDefinitions="_DEBUG;WIN32;_LIB;ABYSS_WIN32;CURL_STATICLIB" 
						# MinimalRebuild="true" 
						# BasicRuntimeChecks="3" 
						# RuntimeLibrary="1" 
						# PrecompiledHeaderFile=".\Debug\xmlrpccpp/xmlrpccpp.pch" 
						# AssemblerListingLocation=".\Debug\xmlrpccpp/" 
						# ObjectFile=".\Debug\xmlrpccpp/" 
						# ProgramDataBaseFileName=".\Debug\xmlrpccpp/" 
						# WarningLevel="3" 
						# SuppressStartupBanner="true" 
						# DebugInformationFormat="4" />]
						prt( "Is compiler tool ...[$fline] ... $conf ($ctype)\n" ) if ($dbg_src14);
						## @attribs = space_split($fline);
						## %atthash = array_2_hash_on_equals(@attribs);
                        # set the PREPROCESSOR defines
                        ###########################################################
                        $ppdefs = "";   # maybe NONE
                        if ( defined $atthash{'PreprocessorDefinitions'} ) {
                            $ppdefs = strip_quotes(trim_all($atthash{'PreprocessorDefinitions'}));
                            if ($inconfigs) {
                                # try to GUESS application type from this string - UGH
                                $adddeps = fg_get_app_type($ppdefs, $lnnum);
                                if (! $dnaptype || (length($apptype) == 0)) {
                                    prt( "Set APPTYPE:$conf: [$apptype] to [$adddeps] (ln=$lnnum)\n" ) if ($dbg_src8);
                                    $apptype = $adddeps;
                                }
                                prt( "Set DEFINES:$conf: [$ppdefs] $apptype ($ctype) (ln=$lnnum)\n" ) if ($dbg_src8);
                                ###$v8_link{$conf} = $ppdefs;
                                if (defined $v8_aptype{$conf}) {
                                    if ($v8_aptype{$conf} ne $apptype) {
                                        prtw( "WARNING: ALREADY HAVE [$conf] in v8_aptype, with [".$v8_aptype{$conf}."] which is NOT [$apptype]!!! (ln=$lnnum) $act_vcproj\n" );
                                    }
                                } else {
                                    prt( "Set APPTYPE:$conf: v8_aptype[$apptype] (ln=$lnnum)\n" ) if ($dbg_x15);
                                    $v8_aptype{$conf} = $apptype;
                                }

                                if (defined $v8_apptypes{$projname}) {
                                    if ($v8_apptypes{$projname} ne $apptype) {
                                        if ($cfgcount < 2) {
                                            # unexpected ...
                                            prtw( "WARNING: ALREADY HAVE [$projname]  in v8_apptypes with [".$v8_apptypes{$projname}."] which is NOT [$apptype]!!! (ln=$lnnum) $act_vcproj\n" );
                                            # but is expected if running 2nd or subsequent configurations
                                            # so no warning ...
                                        }
                                    }
                                } else {
                                    prt( "Set APPTYPE: in v8_apptypes[$projname] to [$apptype] (ln=$lnnum)\n" ) if ($dbg_src8);
                                    $v8_apptypes{$projname} = $apptype;
                                }
                                $v8_link{$conf} = $ppdefs;  # set it PREPROCESSOR DEFINES ...
                            } elsif (length($ppdefs)) {
                                prtw( "WARNING: Got DEFS: $conf [$1] OUTSIDE Configurations! (ln=$lnnum) $act_vcproj\n" ); # if ($dbg_src10);
                            }
                        } else {
                            if ($inconfigs) {
                                prtw( "WARNING: Got NO 'PreprocessorDefinitions' for $conf - $act_vcproj!\n" );
                            }
                        }
                        ############################################################

						if ( defined $atthash{'RuntimeLibrary'} ) {
                            if ($inconfigs) {
                                $ppdefs = strip_quotes(trim_all($atthash{'RuntimeLibrary'}));
                                ###$itm = get_runtime_stg($ppdefs);
                                $itm = fg_get_runtime_val_2_lts($ppdefs);
                                if (($ctype == 1)||($ctype == 2)) {
                                    if ($itm eq $def) {
                                        prt( "Got RUNTIME:$conf: value [$ppdefs] ($ctype) $itm (= $def)\n" ) if ($dgb_src17);
                                    } else {
                                        $func->($itm);
                                        prt( "Set RUNTIME:$conf: value [$ppdefs] ($ctype) $itm (was $def)\n" ) if ($dgb_src17);
                                    }
                                } else {
                                    prtw( "WARNING:CHECKME:$conf: RUNTIME value [$ppdefs] ($ctype) $itm ($def) in $act_vcproj\n" );
                                }
                                if (defined $v8_runtim{$conf}) {
                                    if ($v8_runtim{$conf} ne $itm) {
                                        prtw( "WARNING: AREADY HAVE RUNTIME $conf of ".$v8_runtim{$conf}." versus $itm!! $act_vcproj\n" );
                                    }
                                } else {
                                    $v8_runtim{$conf} = $itm; # RUNTIME /MT or /MD, by configuration
                                }
                            } else {
                                prtw( "WARNING: Unhandled 'RuntimeLibrary' for $conf, $act_vcproj\n$lnnum: $fline\n$lnnum: $pline!\n" );
                            }
						} else {
                            if ($inconfigs) {
                                prtw( "WARNING: Did NOT find 'RuntimeLibrary' for $conf in configs, $act_vcproj\n$lnnum: $fline\n$lnnum: $pline!\n" );
                            }
                        }

                        ##################################################################
                        ### set AdditionalIncludeDirectories - VERY IMPORTANT
                        $ppdefs = '';
						if ( defined $atthash{'AdditionalIncludeDirectories'} ) {
                            $ppdefs = strip_quotes(trim_all($atthash{'AdditionalIncludeDirectories'}));
                            if ($inconfigs) {
                                $funcinc->($ppdefs);
                                prt("Set INCLUDES:$conf: to [$ppdefs]\n" ) if ($dbg_x14);
                                $v8_includ{$conf} = $ppdefs;
                            } else {
                                if (length($ppdefs)) {
                                    if (($act_disp ne 'EXCLUDED')||($dbg_x07)) {
                                        prtw("WARNING: Got 'AdditionalIncludeDirectories' = $ppdefs, outside configs unhandled!\n".
                                            "$conf $act_file $act_disp $act_vcproj [$fline]!!\n" );
                                    }
                                }
                            }
                        } else {
                            if ($inconfigs) {
                                $v8_includ{$conf} = $ppdefs;    # set NONE
                            }
                        }
                        ##################################################################
						prt( "Done VCCLCompilerTool atthash for $conf ...\n" )  if ($dbg_src15);
					} elsif ($tname eq 'VCLinkerTool') {
                        # this SUGGESTS an application or DLL, per ??? value
                        # SubSystem="1" - :console or "2" :window
						# <Tool
						# Name="VCLinkerTool"
						# AdditionalDependencies="comctl32.lib Msimg32.lib Winmm.lib"
						# LinkIncremental="1"
						# GenerateDebugInformation="true"
						# SubSystem="2"
						# OptimizeReferences="2"
						# EnableCOMDATFolding="2"
						# TargetMachine="1"
						# />
						prt( "Is linker tool ...[$fline]\n" ) if ($dbg_src7);
						## @attribs = space_split($fline);
						## %atthash = array_2_hash_on_equals(@attribs);
						if ($dbg_src12a) {	# DEBUG ONLY
							prt( "Split of attribs [$fline] ...\n" );
							foreach $adddeps (@attribs) {
								prt( " $adddeps\n" );
							}
							prt( "Show of HASH ...\n" );
							foreach $adddeps (keys %atthash) {
								prt( " $adddeps = ".$atthash{$adddeps}."\n" );
							}
						}
                        ##################################################################
                        $adddeps = '';
						if (defined $atthash{'AdditionalDependencies'} ) {
							$adddeps = strip_quotes(trim_all($atthash{'AdditionalDependencies'}));
							prt( "Set LINKLIB:$conf: [$adddeps]\n" ) if ($dbg_src12);
						}
						$v8_depend{$conf} = $adddeps;
                        ##################################################################
                        $adddeps = '';
                        if (defined $atthash{'AdditionalLibraryDirectories'}) {
							$adddeps = strip_quotes(trim_all($atthash{'AdditionalLibraryDirectories'}));
							prt( "Set LNKDIRS:$conf: [$adddeps]\n" ) if ($dbg_src12);
                        }
						$v8_libdep{$conf} = $adddeps;
                        ##################################################################
                        # my %v8_linkout = (); # Name="VCLinkerTool" OutputFile=".\Release\FlightGear.exe", by configuration
                        $adddeps = '';
                        if (defined $atthash{'OutputFile'}) {
							$adddeps = strip_quotes(trim_all($atthash{'OutputFile'}));
                        }
                        $v8_linkout{$conf} = $adddeps;
                        ##################################################################
                        $adddeps = '';
                        if (defined $atthash{'SubSystem'}) {
							$adddeps = strip_quotes(trim_all($atthash{'SubSystem'}));
                            # this should decide the $apptype
                            # $v8_aptype{$conf} = $apptype;
                            # $v8_apptypes{$projname} = $apptype;
                            if (defined $v8_subsystems{$adddeps}) {
                                $ppdefs = $v8_subsystems{$adddeps};
                                if ($apptype eq $ppdefs) {
                                    prt("Got APPTYPE:$conf: NO CHANGE [$apptype] equals SubSystem ($adddeps) [".$v8_subsystems{$adddeps}."] ...(ln=$lnnum)\n" ) if ($dbg_x16);
                                } else {
                                    if ($apptype eq $app_dynalib) {
                                        if ($ppdefs eq $app_windows) {
                                            # these are NOT incompatible, so NO CHANGE
                                            prt("Got APPTYPE:$conf: NO CHANGE [$apptype] EQUIVALENT to $ppdefs ($adddeps) ...(ln=$lnnum)\n" ) if ($dbg_x16);
                                        } else {
                                            prtw("WARNING: NO CHANGE :$conf: but [$apptype] NOT EQUIVALENT to $ppdefs ($adddeps) ...(ln=$lnnum)\n" );
                                        }
                                    } else {
                                        prt("Set APPTYPE:$conf: from $apptype, to $ppdefs - CHECK! (ln=$lnnum)\n" ) if ($dbg_x15);
                                        $apptype = $ppdefs;
                                    }
                                    if (! defined $v8_aptype{$conf}) {
                                        prtw("HEY! $conf NOT already set in v8_aptype - CHECK ORDER OF DECODE! (ln=$lnnum) $act_vcproj\n" );
                                    }
                                    $v8_aptype{$conf} = $apptype;
                                    if (! defined $v8_apptypes{$projname}) {
                                        prtw("HEY! $projname NOT already set in v8_apptypes - CHECK ORDER OF DECODE! (ln=$lnnum) $act_vcproj\n" );
                                    } else {
                                        prt( "Set APPTYPE: in v8_apptypes[$projname] to [$apptype] (ln=$lnnum)\n" ) if ($dbg_x15);
                                    }
                                    $v8_apptypes{$projname} = $apptype;
                                }
                            } else {
                                prtw( "WARNING: Got SubSystem='$adddeps', NOT in v8_subsystems! CHECK IT OUT!!! (ln=$lnnum) $act_vcproj: $fline\n" );
                                ### $tmpdbg = $dbg_x10;
                                ### $dbg_x10 = 1;
                                ### @attribs = space_split($fline);
                                ### %atthash = array_2_hash_on_equals(@attribs);
                                ### $adddeps = $atthash{'SubSystem'};
                                ### prt( "2nd run got $adddeps ...\n");
                                ### $dbg_x10 = $tmpdbg;
                            }
                        }
                        ##################################################################
                    } elsif ($tname eq 'VCLibrarianTool') {
                        # <Tool
                        #  Name="VCLibrarianTool"
                        #  OutputFile="Win32_LIB_Debug\libpngd.lib"
                        #  SuppressStartupBanner="true" />
                        $hadlibtool = 1;
                        $ppdefs = '';
						if ( defined $atthash{'OutputFile'} ) {
							$ppdefs = strip_quotes(trim_all($atthash{'OutputFile'}));
                        }
                        $v8_linkout{$conf} = $ppdefs;

                        ######################################################################
                        $adddeps = '';
                        if (defined $v8_aptype{$conf}) {
                            $adddeps = $v8_aptype{$conf};
                        }
                        if ($adddeps ne $app_statlib) {
                            prtw( "VCLibrarianTool:$conf: This suggests a STATIC LIBRARY ...out=$ppdefs\n".
                                "but v8_aptype[$conf] HAS [".$v8_aptype{$conf}."] CHECK FOR CHANGE!! (ln=$lnnum) $act_vcproj\n" );
                        } else {
                            prt( "VCLibrarianTool:$conf Suggests STATIC LIBRARY - out=$ppdefs".
                                " - and that is what we have in v8_aptype...\n" ) if ($dbg_x11);
                        }
                        if (! defined $v8_depend{$conf} ) {
    						$v8_depend{$conf} = "";
                        }
                        if (! defined $v8_libdep{$conf} ) {
    						$v8_libdep{$conf} = "";
                        }
                    } elsif ($tname eq 'VCPostBuildEventTool') {
                        # <Tool
                        #  Name="VCPostBuildEventTool"
                        #  Description="Copy Library to plib directory"
                        #  CommandLine="copy debug\*.lib ..\..\*.*&#x0D;&#x0A;copy ul.h ..\..\ul.h&#x0D;&#x0A;copy ulRTTI.h ..\..\ulRTTI.h&#x0D;&#x0A;"
                        #  />
                        # this will be output to the DSP, under the paticular, config, something like
                        # # Begin Special Build Tool
                        # SOURCE="$(InputPath)"
                        # PostBuild_Desc=Copy to bin
                        # PostBuild_Cmds=copy Release\*exe bin\.	copy test.h bin\.
                        # # End Special Build Tool
                        $ppdefs = '';
                        if (( defined $atthash{'Description'} ) || ( defined $atthash{'CommandLine'} ) ) {
                            $ppdefs = "$postdesc="; # to 'PostBuild_Desc=';
                            if ( defined $atthash{'Description'} ) {
                                $ppdefs .= add_quotes(strip_quotes(trim_all($atthash{'Description'})));
                            }
                            $ppdefs .= " $postcmds="; # to ' PostBuild_Cmds=';
                            if ( defined $atthash{'CommandLine'} ) {
                                $adddeps = strip_quotes(trim_all($atthash{'CommandLine'}));
                                $adddeps =~ s/&#x0D;&#x0A;/\t/g;
                                $adddeps =~ s/\t$//;
                                $ppdefs .= add_quotes($adddeps);
                            }
                        }
                        $v8_postbuild{$conf} = $ppdefs; # later, added under $postevt
					}
				} else {
					prtw( "WARNING: FAILED Name [$fline] in $act_vcproj!\n" );
				}
			} elsif ($fline =~ /<\/Filter>/) {
				if ($killfilt) {
					$filtname = ''; # = NO FILTER NAME, like Source Files
					$filttype = ''; # = NOR FILTER TYPE, like cpp;c;cxx;rc;def;r;odl;idl;hpj;bat
				}
			} elsif ($fline =~ /<Platforms/) {
				# 8-8: LINE=[<Platforms>]
			} elsif ($fline =~ /<Platform/) {
				# 9-11: LINE=[<Platform Name="Win32" />]
			} elsif ($fline =~ /<ToolFiles/) {
				# 13-13: LINE=[<ToolFiles>]
			} elsif ($fline =~ /<Configurations>/) {
				# 15-15: LINE=[<Configurations>]
				$inconfigs = 1;
				prt( "$lnnum: Enter Configurations ... ($fline)\n" ) if ($dbg_src10);
			} elsif ($fline =~ /<\/Configurations>/) {
				# LINE=[</Configurations>]
				$inconfigs = 0;
				prt( "$lnnum: Exit Configurations ... ($fline)\n" ) if ($dbg_src10);
            } elsif ($fline =~ /<\/Configuration>/) {
                $dnaptype = 0;
			} elsif ($fline =~ /<References/) {
				# 167-167: LINE=[<References>]
			} elsif ($fline =~ /<Files/) {
				# 169-169: LINE=[<Files>]
                $infiles = 1;
				prt( "$lnnum: Enter Files ... ($fline)\n" ) if ($dbg_x06);
			} elsif ($fline =~ /<\/Files/) {
				# 169-169: LINE=[<Files>]
                $infiles = 0;
				prt( "$lnnum: Exit Files ... ($fline)\n" ) if ($dbg_x06);
                $act_file = '';
                $act_disp = '';
			} elsif ($fline =~ /<FileConfiguration/) {
				# 177-179: LINE=[<FileConfiguration Name="Debug|Win32" >]
			} elsif ($fline =~ /<Globals/) {
				# 591-591: LINE=[<Globals>]
			} else {
				if ($tagtyp == $TYP_VERSION) {
					prt("$bgnend: LINE=[$fline]\n") if ($dbg_srcv);
				} elsif ($tagtyp == $TYP_CLOSE) {
					prt("$bgnend: LINE=[$fline]\n") if ($dbg_srcc);
				} else {
					prt("$bgnend: LINE=[$fline]\n") if ($dbg_src5);
				}
			}
			if ($tagtyp == $TYP_OPEN) {
				push(@xmltags,$xmltag);
			} elsif ($tagtyp == $TYP_CLOSE) {
				if (@xmltags) {
					my $tmptag = pop @xmltags;
					$xmltag = substr($xmltag,1);
					if ($tmptag ne $xmltag) {
						prtw( "WARNING: Closing TAG [$xmltag] not last [$tmptag]! $bgnend\n" );
					}
					if ($xmltag eq 'Configurations') {
						$inconfigs = 0;
						prt( "$lnnum: Exit Configurations ... ($fline)\n" ) if ($dbg_src10);
					}
				} else {
					prtw( "WARNING: CLOSE TAG NOT OPEN! [$fline]\n" );
				}
			}
			$fline = '';
		}
	}

	###prt( "Project: $projname, as $apptype\n" ); # eg 'Project: gshhs, as Console Application'
	my (@att2, @disc, @arr, $mask, $cdefs, $rtime, $cincs, $libdirs, @allarr);
    # COLLECT the information obtained
    # collect andd add to %v6_all under key $mask
    # The $mask is "$projname|$conf|$rtime"
    # $projname from XML line =~ /<VisualStudioProject\s+/ Name=
    # $conf is the key to each of the hashes
    # $rtime from $v8_runtim{$conf}
    # %v8_depend - gives $libraries=[$cdefs]
    # %v8_link - gives $defines=[$cdefs] (poorly names hash!)
    # %v8_includ - gives $includes=[$cincs]
    # %v8_libdep - gives $libpath=[$libdirs]
	foreach $conf (keys %v8_depend) {
		$ctype = 0;
		if ($conf =~ /Debug/i) {
			$ctype = 1;
			$func = \&is_in_skip_lib_dbg;
		} elsif ($conf =~ /Release/i) {
			$ctype = 2;
			$func = \&is_in_skip_lib_rel;
		} else {
			$func = \&is_in_skip_lib_rel;
            $ctype = 2;
            prtw( "WARNING: NOT Debug or Release - WHAT IS IT? [$conf]! Using Release\n" );
		}

        if (defined $v8_aptype{$conf}) {
            $apptype = $v8_aptype{$conf};
        } else {
            $apptype = $typelse;
            prtw( "WARNING: No application type in v8_aptype for $conf! Using default $apptype!!\n" );
        }
        if (defined $v8_runtim{$conf}) {
            $rtime = $v8_runtim{$conf};
        } else {
            if ($ctype == 1) {
                $rtime = $def_runtime_dbg;
            } else {
                $rtime = $def_runtime_rel;
            }
            prtw( "WARNING: No RUNTIME in v8_runtim for $conf! Using default $rtime!!\n" );
        }
        $rtime =~ s/^\///;
        $mask = "$projname|$conf|$rtime";  # start with project name and configuration
        # my %v6_all = ();    # all projects in this solution
        # key = projname|$conf eg FlightGear|Debug|Win32
        # value = string '$defines=[ list of defines ] $libraries=[ list of libraries ]

		$ppdefs = $v8_depend{$conf};
		@attribs = split(/ /,$ppdefs);
		@att2 = ();
		@disc = ();
		foreach $itm (@attribs) {
			if ( ! $func->($itm) ) {
				push(@att2,$itm);
			} else {
				push(@disc,$itm);
			}
		}

		prt( "\nLINK:Config: $conf=$ppdefs ... ".scalar @attribs." items\n" ) if ($dbg_src18);
		prt( "Reduced to ".scalar @att2." items ...Discarding [ @disc ], as already there...\n" ) if ($dbg_src18);
		if ($ctype == 1) {	# ($conf =~ /Debug/i)
			$def = $dsp_libs_dbg;
			@arr = split(/ /,$dsp_libs_dbg);
			@disc = ();
			prt( "Debug VERSION ... $conf ... [ @arr ]\n" ) if ($dbg_src18);
			foreach $itm (@att2) {
				if (is_in_array( $itm, @arr )) {
					push(@disc,$itm);
				} else {
					$dsp_libs_dbg .= ' '.$itm;
				}
			}
			prt( "Changed $def (\$dsp_libs_dbg) ...\n") if ($dbg_src18);
			prt( "To      $dsp_libs_dbg, discarding [ @disc ], as already there ...\n" ) if ($dbg_src18);
            $cdefs = $dsp_libs_dbg;
		} elsif ($ctype == 2) {	# $conf =~ /Release/)
			$def = $dsp_libs_rel;
			@arr = split(/ /, $dsp_libs_rel );
			prt( "Release VERSION ... $conf ... @arr\n" ) if ($dbg_src18);
			foreach $itm (@att2) {
				if (is_in_array( $itm, @arr )) {
					push(@disc,$itm);
				} else {
					$dsp_libs_rel .= ' '.$itm;
				}
			}
			prt( "Changed $def (\$dsp_libs_rel) ...\n" ) if ($dbg_src18);
			prt( "To      $dsp_libs_rel, discarding [ @disc ], as already there ...\n" ) if ($dbg_src18);
            $cdefs = $dsp_libs_rel;
		} else {
			prtw( "WARNING: CHECKME: VERSION NOT DEBUG OR RELEASE??? ... $conf ...\n" );
		}
        
        if ($ctype > 0) {
            if (defined $v6_all{$mask}) {
                prtw( "WARNING: $mask ALREADY IN v6_all!!! value=".$v6_all{$mask}."\n" );
            } else {
                $v6_all{$mask} = "$libraries=[$cdefs] ";
                prt( "v6_all: Adding [$mask] with $libraries=[$cdefs] ...\n" ) if ($dbg_x03);
            }
        }

        # add to v6_refall, as scalar for now
        $v6_refall{$mask} = "$libraries=[$cdefs]";
	}

	foreach $conf (keys %v8_link) {
		$ctype = 0;
		if ($conf =~ /Debug/i) {
			$ctype = 1;
			$func = \&is_in_skip_conf_dbg;
		} elsif ($conf =~ /Release/i) {
			$ctype = 2;
			$func = \&is_in_skip_conf_rel;
		} else {
            # default to RELEASE
			$func = \&is_in_skip_conf_rel;
            $ctype = 2;
			prtw( "WARNING: CHECKME: VERSION NOT DEBUG NOR RELEASE??? ... Got [$conf]! ASSUME RELEASE\n" );
		}
        if (defined $v8_aptype{$conf}) {
            $apptype = $v8_aptype{$conf};
        } else {
            $apptype = $typelse;
            prtw( "WARNING:$projname: No APPTYPE in v8_aptype for $conf! Using default [$apptype]!! $act_vcproj\n" );
        }
        if (defined $v8_runtim{$conf}) {
            $rtime = $v8_runtim{$conf};
        } else {
            if ($ctype == 1) {
                $rtime = $def_runtime_dbg;
            } else {
                $rtime = $def_runtime_rel;
            }
            prtw( "WARNING:$projname: No RUNTIME in v8_runtim for $conf! Using default [$rtime]!! $act_vcproj\n" );
        }
        if (defined $v8_includ{$conf}) {
            $cincs = $v8_includ{$conf};
        } else {
            if ($ctype == 1) {
                $cincs = $def_include_dirs_dbg;
            } else {
                $cincs = $def_include_dirs_rel;
            }
            prtw( "WARNING:$projname: No INCLUDES in v8_includ for $conf! Using default [$cincs]!! $act_vcproj\n" );
        }
        # could massage these $cincs, to REMOVE the MEANINGLESS (in windows) '.\', or do it later

        $rtime =~ s/^\///;
        $mask = "$projname|$conf|$rtime";  # start with project name and configuration

		$ppdefs = $v8_link{$conf};
		@attribs = split(/;/,$ppdefs);
		@att2 = ();
		@disc = ();
		foreach $itm (@attribs) {
			if ( ! $func->($itm) ) {
				push(@att2,$itm);
			} else {
				push(@disc,$itm);
			}
		}
		@arr = ();
		prt( "\nDEFS:Config: $conf=$ppdefs ... ".scalar @attribs." items\n" ) if ($dbg_src18);
		prt( "Reduced to ".scalar @att2." items ...Discarding [ @disc ], as already there...\n" ) if ($dbg_src18);
		if ($ctype == 1) {	# ($conf =~ /Debug/i)
			$def = $dsp_defines_dbg;
			@arr = split_conf( $dsp_defines_dbg );
			@disc = ();
			prt( "Debug VERSION ... $conf ... @arr\n" ) if ($dbg_src18);
			foreach $itm (@att2) {
				if (is_in_array( $itm, @arr )) {
					push(@disc,$itm);
				} else {
					$dsp_defines_dbg .= ' /D "'.$itm.'"';
				}
			}
			prt( "Changed $def (\$dsp_defines_dbg) ...\n" ) if ($dbg_src18);
			prt( "To      $dsp_defines_dbg, discarding [ @disc ], as already there ...\n" ) if ($dbg_src18);
            $cdefs = $dsp_defines_dbg;
		} elsif ($ctype == 2) {	# $conf =~ /Release/i)
			$def = $dsp_defines_rel;
			@arr = split_conf( $dsp_defines_rel );
			prt( "Release VERSION ... $conf ... @arr\n" ) if ($dbg_src18);
			foreach $itm (@att2) {
				if (is_in_array( $itm, @arr )) {
					push(@disc,$itm);
				} else {
					$dsp_defines_rel .= ' /D "'.$itm.'"';
				}
			}
			prt( "Changed $def (\$dsp_defines_rel) ...\n") if ($dbg_src18);
			prt( "To      $dsp_defines_rel, discarding [ @disc ], as already there ...\n" ) if ($dbg_src18);
            $cdefs = $dsp_defines_rel;
		}
        $libdirs = '';
        if (defined $v8_libdep{$conf} ) {
            $libdirs = $v8_libdep{$conf};
        } else {
            prtw( "WARNING:$mask: v8_libdep does not contain conf $conf ...\n" );
        }
        # my %v8_config = ();  #  by configuration, OutputDirectory=".\Release", IntermediateDirectory="Release",
        my $outs = '';
        if (defined $v8_config{$conf}) {
            $outs = $v8_config{$conf};
            ###prtw( "SHOW OUTS = [$outs]\n" );
        }

        my $lout = '';
        if (defined $v8_linkout{$conf}) {
            $lout = strip_dotrel($v8_linkout{$conf});
        }
        $msg = "$defines=[$cdefs] $includes=[$cincs] $libpath=[$libdirs] $outputs=[$outs] $linkout=[$lout]";

        if ($ctype > 0) {
            if (! defined $v6_all{$mask}) {
                prtw( "WARNING: $mask NOT already defined!!!\n" );
                $v6_all{$mask} = $msg;
            } else {
                $v6_all{$mask} .= $msg;
            }
        }
        my $post = '';
        if (defined $v8_postbuild{$conf}) {
            $post = $v8_postbuild{$conf};
        }

        @allarr = ();   # clear the array
        push(@allarr, $v6_refall{$mask});
        push(@allarr, "$defines=[$cdefs]");
        push(@allarr, "$includes=[$cincs]");
        push(@allarr, "$libpath=[$libdirs]");
        push(@allarr, "$outputs=[$outs]");
        push(@allarr, "$linkout=[$lout]");
        push(@allarr, "$postevt=[$post]");
        $v6_refall{$mask} = [@allarr];  # COPY the ARRAY to the HASH

	}

	my $new_srcs = scalar @v8_srcs;
	prt( "VCPROJ Project: $projname, as $apptype, version=$version\n" ) if ($dbg_x12); # eg 'Project: gshhs, as Console Application'
	prt( "Got new $new_srcs C/C++ files, header files, and others \n" ) if ($dbg_x12);
	prt( "Defined Debug = $dsp_defines_dbg, Release = $dsp_defines_rel\n" ) if ($dbg_x13);
	prt( "Library Debug = $dsp_libs_dbg, Release = $dsp_libs_rel\n" ) if ($dbg_x13);
}

sub fg_clear_proj_files {
	@v8_srcs = ();	    # start with NONE
	%v8_link = ();	    # PREPROCESSOR compiler definitions, by configuration
	%v8_depend = ();	# linker addtional dependencies, by configuration
    %v8_aptype = ();    # application type - console, static library, DLL, ...

	@v6_srcs = ();  # relnm full group filter
	%v6_defs = ();
	%v6_conf = ();

	# establish DEFAULT items for DSP generation
	# these can be altered by the XML decode
	$dsp_runtime_rel = $def_runtime_rel;
	$dsp_runtime_dbg = $def_runtime_dbg;
	$dsp_defines_dbg = $def_defines_dbg;
	$dsp_defines_rel = $def_defines_rel;
	$dsp_libs_rel = $def_libs_rel;
	$dsp_libs_dbg = $def_libs_dbg;

    # new items
    %v8_runtim = ();    # RUNTIME /MT /MD ...
    %v8_includ = ();    # INCLUDE DIRECTORIES for compiler
    ###%v8_filter = ();    # NO single list for whole solution - <Files><Filter Name="Source Files" ...
    %v8_libdep = (); # ADDITIONAL LIB DIRS, by configuration
    # new 22/09/2008
    %v8_config = ();  #  by configuration, OutputDirectory=".\Release", IntermediateDirectory="Release",
    # and zlib = ConfigurationType="4", alut = ConfigurationType="2", fg = ConfigurationType="1"
    %v8_linkout = (); # Name="VCLinkerTool" OutputFile=".\Release\FlightGear.exe", by configuration
    %v8_postbuild = (); # Name="VCPostBuildEventTool", with
    # Description="Copy Library to plib directory"
    # CommandLine="copy debug\*.lib ..\..\*.*&#x0D;&#x0A;copy ul.h ..\..\ul.h&#x0D;&#x0A;copy ulRTTI.h ..\..\ulRTTI.h&#x0D;&#x0A;"
    # the &#x0D;&#x0A; is replaced with a TAB (\t) in the DSP file
    @xml_tag_map = ();  # clear the xml_tag_map
    @xml_lines = ();    # neat xml lines from VCPRJ file
    $dsp_includes_dbg = $def_include_dirs_dbg;
    $dsp_includes_rel = $def_include_dirs_rel;
}

sub get_xml_sources_main {
    my ($f) = shift;
    fg_clear_proj_files();
    get_xml_sources($f);
    push(@all_sources,@v8_srcs);
}

############################################################################

sub prtw {
    my ($tx) = shift;
    if ($tx =~ /\n$/) {
        prt($tx);
        $tx =~ s/\n$//;
    } else {
        prt("$tx\n");
    }
    push(@warnings,$tx);
}

sub output_proj_list {
    ###	push(@projs, [ $arr[0], $arr[1] ]);
    my ($line, $rp);
    my $cnt = scalar @file_list;
    for (my $i = 0; $i < $cnt; $i++) {
        $line = $file_list[$i][1];
        $line = fix_rel($fil_dir.$line);
        $rp = substr($line, length($base_dir));
        if ($show_rel) {
            prt( "$rp\n" );
        } else {
            prt( "$line\n" );
        }
    }
    prt( "End of list of $cnt ...\n" );
}

sub collect_xml_sources {
    if ($show_srcs) {
        my ($line, $rp);
        my $cnt = scalar @file_list;
        for (my $i = 0; $i < $cnt; $i++) {
            $line = $file_list[$i][1];
            $line = fix_rel($fil_dir.$line);
            $rp = substr($line, length($base_dir));
            if (open(INF, "<$line")) {
                my @lns = <INF>;
                close INF;
                process_vcproj_xml_lines($line, @lns);
            } else {
                prt( "WARNING: FAILED TO OPEN [$line]! ... $! ...\n" );
            }
        }
    }
}

sub alternative_scan {
    if ($do_alternative_scan) {
        my $cnt = scalar @file_list;
        prt("\nAlternative SCAN of VCPROJ files ... from file_list, count $cnt ...\n" );
        for (my $j = 0; $j < $cnt; $j++) {
            my $line = $file_list[$j][1];
            $line = fix_rel($fil_dir.$line);
            get_xml_sources_main($line);
        }
        prt("Done SCAN of $cnt VCPROJ files ... total $tot_vclines lines ... ".
            "for ".scalar @all_sources." source files.\n" );   # multidimensional array with lot of information
    }
}

sub show_warnings {
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS ...\n" );
        foreach my $line (@warnings) {
            prt("$line\n" );
        }
        prt("\n");
    } else {
        prt("\nNo warnings issued.\n\n");
    }
}


sub array_ref_2_array {
    my ($ref) = shift;
    my @narr = ();
    foreach (@{$ref}) {
        push(@narr,$_);
    }
    return @narr;
}


# $defines=[/D "_CRT_SECURE_NO_WARNINGS" /D "_CRT_SECURE_NO_DEPRECATE"]
sub split_defines {
    my ($txt) = shift;
    my @darr = ();
    my $len = length($txt);
    my ($i, $ch, $inq, $tag);
    $inq = 0;
    $tag = '';
    for ($i = 0; $i < $len; $i++) {
        $ch = substr($txt,$i,1);
        if ($inq) {
            if ($ch eq '"') {
                push(@darr, $tag) if length($tag);
                $tag = '';
                $inq = 0;
            }
        } else {
            if ($ch eq '"') {
                $tag = '';
                $inq = 1;
            }
        }
    }
    return @darr;
}

sub prtf {
    my ($of, $txt) = @_;
    print $of $txt;
}

##                  [0]SRC [1]FUL [2]GRP    [3]FIL      [4]CMP [5]DON [6]PRJ     [7]SHR [8]EXC
##                  relnm  full   group      filter     cmp    done   project    grp    exclude
##	@all_sources   [$src,  $ff,   $filtname, $filttype, 0,     0,     $projname, shr,   excl] );
sub out_group_files {
    my ($OF, $pname, $max, $sep, $f, $grp, $filt, $scnt, $xcnt) = @_;
    my ($prj, $src, $grp2, $filt2);
    for (; $f < $max; $f++) {
        if ($all_sources[$f][V8_DON] == 0) {
            $prj = $all_sources[$f][V8_PRJ];
            $filt2 = $all_sources[$f][V8_FIL];
            $grp2  = $all_sources[$f][V8_GRP];
            if ( ($pname eq $prj) && ($grp eq $grp2) ) {
                $src = strip_dotrel($all_sources[$f][V8_SRC]);
                if ($all_sources[$f][V8_EXC] eq $excl_mark) {
                    prtf( $OF, $excfiles.$sep.$src."\n");
                    $$xcnt++;
                } else {
                    prtf( $OF, $srcfiles.$sep.$src."\n");
                    $$scnt++;
                }
                $all_sources[$f][V8_DON] = 1;
            }
        }
    }
}

sub add_source_files {
    my ($OF, $pname, $max, $sep) = @_;
    my $scnt = 0;
    my $xcnt = 0;
    my ($f, $prj, $filt, $grp);
    for ($f = 0; $f < $max; $f++) {
        if ($all_sources[$f][V8_DON] == 0) {
            $prj = $all_sources[$f][V8_PRJ];
            if ($pname eq $prj) {
                $filt = $all_sources[$f][V8_FIL];
                $grp  = $all_sources[$f][V8_GRP];
                # my $filter    = '_filter_';
                prtf( $OF, $filter.$sep.$grp.'='.$filt."\n");
                out_group_files($OF, $pname, $max, $sep, $f, $grp, $filt, \$scnt, \$xcnt);
                prtf( $OF, "\n");
            }
        }
    }
    prtf( $OF, "# Listed $scnt sources");
    if ($xcnt) {
        prtf( $OF, ", $xcnt excluded");
    }
    prtf( $OF, "\n\n");
}

sub get_refall_groups {
    my @groups = ();
    my (@keys, $kcnt, $gnum);
    my ($k, $key, @ar, $pname, $cond, $pform, $rtim);
    my ($j, $ky, $pname2, $cond2);
    @keys = sort keys(%v6_refall);
    $kcnt = scalar @keys;
    $gnum = 0;
    for ($k = 0; $k < $kcnt; $k++) {
        $key = $keys[$k];
        @ar = split(/\|/,$key);
        $pname = $ar[0];
        $cond  = $ar[1];
        $pform = $ar[2];
        $rtim  = $ar[3];
        #              0      1       2     3      4       5
        push(@groups, [$gnum, $pname, $key, $cond, $pform, $rtim]);
        for ($j = $k + 1; $j < $kcnt; $j++) {
            $ky = $keys[$j];
            @ar = split(/\|/,$ky);
            $pname2 = $ar[0];
            $cond2  = $ar[1];
            if ($pname eq $pname2) {
                $k++;
                #              0      1       2    3       4       5
                push(@groups, [$gnum, $pname, $ky, $cond2, $ar[2], $ar[3]]);
            } else {
                last;
            }
        }
        $gnum++;
    }
    return $gnum,@groups;
}

sub show_v6_refall {
    my ($key, $val, @ar, $pname);
    my ($atype, $msg, $mxky);
    my (@arr, %hash, $ky, $tmp);
    my ($cond, @keys, @groups, $kcnt, $k, $gnum, $j);
    my ($pname2, $cond2, $rcnt);
    my (@refs, $cont, $scnt, $xcnt);
    my ($outfil, $rtim, $pform);
    my (%h2);
    my $sep = "\t=\t";
    my $fcnt = 0;
    my $flist = '';
    my $max = scalar @all_sources; # multidimensional array with lot of information
    my ($f);
    $mxky = 32;
    $tmp = "\t";

    prt( "Now the LIST from v6_refall... " );
    $kcnt = scalar keys(%v6_refall);
    prt( "Grouping $kcnt keys... " );
    ($gnum, @groups) = get_refall_groups();
    prt( "into $gnum groups... " );
    # add sources to CFG files
    if ($addfiles2cfg && $max) {
        for ($f = 0; $f < $max; $f++) {
           $all_sources[$f][V8_DON] = 0;
        }
        prt( "cleared done ..." );
    }

    prt( "\n" );

    if ($kcnt != scalar @groups) {
        prtw( "WARNING: failed to divide into correct groups! [$kcnt] versus ".scalar @groups."! FIX CODE!!\n");
        mydie( "CAN NOT CONTINUE LIKE THIS!\n" );
        return;
    }
    for ($k = 0; $k < $kcnt; $k++) {
        $gnum  = $groups[$k][0];
        $pname = $groups[$k][1];
        $key   = $groups[$k][2];
        $cond  = $groups[$k][3];
        $pform = $groups[$k][4];
        $rtim  = $groups[$k][5];
        $val = $v6_refall{$key};
        if (defined $v8_apptypes{$pname}) {
            $atype = $v8_apptypes{$pname};
        } else {
            $atype = "UNKNOWN APPLICATION TYPE - CHECK ME Did not find $pname in v8_apptypes!!!";
            prtw( "$atype\n" );
            next;
        }
        $msg = '';
        # name of application or library
        # my $prjname   = 'projname';
        $msg .= $prjname.$sep.$pname."\n";
        # type = ConsoleApplication|StaticLibrary|DLL|Application
        # my $ap_type   = 'app_type';
        $msg .= $ap_type.$sep.$atype."\n";
        @refs = (); # clear last references
        # collect all with this $gnum
        #            0     1      2       3
        push(@refs, [$val, $cond, $pform, $rtim]);
        for ($j = $k + 1; $j < $kcnt; $j++) {
            if( $gnum == $groups[$j][0] ) {
                $ky    = $groups[$j][2];
                $cond2 = $groups[$j][3];
                $pform = $groups[$j][4];
                $rtim  = $groups[$j][5];
                $val = $v6_refall{$ky};
                #             0     1       2       3
                push(@refs, [ $val, $cond2, $pform, $rtim ]);
                $k++;   # skip this used one
            } else {
                last;
            }
        }
        $msg .= "\n";
        # have a set of refs
        $rcnt = scalar @refs;
        # $defines=[/D "_CRT_SECURE_NO_WARNINGS" /D "_CRT_SECURE_NO_DEPRECATE"]
        # outputs=[".\Win32_LIB_Debug" ".\Win32_LIB_Debug"]
	    # $linkout=[Win32_LIB_Debug\zlibd.lib]
        # $includes=[...]
        # $libraries=[comctl32.lib Msimg32.lib Winmm.lib]
        # $libpath=[...]
        for ($j = 0; $j < $rcnt; $j++) {
            $val   = $refs[$j][0];
            $cond  = $refs[$j][1];
            $pform = $refs[$j][2];
            $rtim  = $refs[$j][3];
            if ($j == 0) {
                $msg .= "if $cond\n\n";
            } elsif (($j + 1) < $rcnt) {
                $msg .= "\nelse if $cond\n\n";
            } else {
                $msg .= "\nelse\n\n";
            }

            $msg .= $platform.$sep.$pform."\n"; # add PLATFORM
            $msg .= $runtime.$sep.fg_get_runtime_lts_2_stg($rtim)."\n";   # add RUNTIME

            @arr = array_ref_2_array($val);
            %hash = array_2_hash_on_equals(@arr);
            foreach $ky (keys %hash) {
                $cont = $hash{$ky};
                $cont =~ s/^\[//;
                $cont =~ s/\]$//;
                if ($ky eq $defines) {
                    # defines=[/D "_CRT_SECURE_NO_WARNINGS" /D "_CRT_SECURE_NO_DEPRECATE"]
                    @arr = split_defines($cont);
                    foreach (@arr) {
                        $msg .= $defines.$sep.$_."\n";
                    }
                } elsif ($ky eq $outputs) {
                    ### $msg .= "# $outputs = $cont\n";
                    # outputs=[$out_dir=".\Release" $int_out=".\Release"]
                    # prtw( "SHOW OUTS: [$cont]\n" );
                    %h2 = array_2_hash_on_equals(space_split($cont));
                    foreach (keys (%h2)) {
                        $msg .= $_ .$sep.strip_quotes($h2{$_})."\n";
                    }
                } elsif ($ky eq $linkout) {
                    # $linkout=[.\Release\FlightGear.exe]
                    $msg .= $linkout.$sep.$cont."\n";
                } elsif ($ky eq $includes) {
                    # includes=[.,..,.\SimGear,..\zlib-1.2.3,C:\Program Files\OpenAL 1.1 SDK\include,..\openal\alut\include,..\OpenAL\include\AL,..\OpenSceneGraph\include,
                    # ..\OpenThreads\include,..\pthreads;..\alut\include]
                    $cont =~ s/&quot;/"/g;
                    foreach (split(/[;,]/,$cont)) {
                        $msg .= $includes.$sep.strip_dotrel($_)."\n";
                    }
                } elsif ($ky eq $libraries) {
                    # libraries=[comctl32.lib Msimg32.lib Winmm.lib openal32.lib]
                    foreach (split(/\s/,$cont)) {
                        $msg .= $libraries.$sep.$_."\n";
                    }
                } elsif ($ky eq $libpath) {
                    # lib_path=[..\SimGear\$(IntDir); ..\PLIB,..\zlib-1.2.3\projects\visualc6\Win32_LIB_Debug
                    foreach (split(/[,;]/,$cont)) {
                        # hmmmm, like the above, sometimes there is a SPACE beginning
                        # should I remove it? for now NO!
                        $msg .= $libpath.$sep.$_."\n";
                    }
                } elsif ($ky eq $postevt) {
                    if (length($cont)) {
                        # PostBuild_Desc=Copy to bin
                        # PostBuild_Cmds=copy Release\*exe bin\.	copy test.h bin\.
                        %h2 = array_2_hash_on_equals(space_split($cont));
                        foreach (keys (%h2)) {
                            $msg .= $_ .$sep.strip_quotes($h2{$_})."\n";
                        }
                        # for the DSP file
                        # $msg .= "# Begin Special Build Tool\n";
                        # $msg .= "# SOURCE=\"\$(InputPath)\"\n";
                        # $msg .= "# PostBuild_Desc=";
                        # if (defined $h2{$postdesc}) {
                        #    $msg .= strip_quotes($h2{$postdesc});
                        # }
                        # $msg .= "\n";
                        # $msg .= "# PostBuild_Cmds=";
                        # if (defined $h2{$postcmds}) {
                        #    $msg .= strip_quotes($h2{$postcmds});
                        #}
                        # $msg .= "\n";
                        # $msg .= "# End Special Build Tool\n";
                    }
                } else {
                    if (length($cont)) {
                        $cont =~ s/\t/\n/g;
                        prtw("WARNING: [$cond] Unhandle key [$ky], with value\n".
                            "[$cont]!!!\n" );
                    }
                }
                ###$msg .= "$ky=".$hash{$ky} . "\n";
            }
        }
        $msg .= "\nendif\n";
        prt( "$msg\n" ) if ($dbg_x09);    # done ONE application
        # generate a configuration file
        #########################################
        $outfil = "temp.$pname.cfg.txt";
        my ($OF);
        rename_2_old_bak($outfile);
        if (open $OF, ">$outfil") {
            $fcnt++;
            $flist .= '|' if length($flist);
            $flist .= $pname;
            $cont = "# configuration for $pname - generated by $pgname\n# on ".scalar localtime(time())."\n";
            prtf( $OF, $cont);
            prtf( $OF, "\n");
            prtf( $OF, $msg);
            prtf( $OF, "\n");
            # write out the source files, per filter to cfg files
            if ($addfiles2cfg && $max) {
                add_source_files( $OF, $pname, $max, $sep );
            }
            prtf( $OF, "# eof - $outfil\n" );
            close $OF;
        } else {
            prtw( "WARNING: Unable to create $outfil! ... $! ...\n" );
        }
        ##########################################
    }
    if ($addfiles2cfg && $max) {
        for ($f = 0; $f < $max; $f++) {
           if ($all_sources[$f][V8_DON] == 0) {
               prtw( "WARNING: Source MISSED [".$all_sources[$f][V8_PRJ]."] [".
                   strip_dotrel($all_sources[$f][V8_SRC])."] WHY????\n" );
           }
        }
    }

    prt("Written $fcnt configuration files ... one each for -\n$flist\n");
}

# my %sln_depends  = ();	# dependencies, key by projname, with '|' list of values
sub write_out_depends {
    my ($sln) = shift;
    my $outfil = 'temp.'.$sln.'.cfg.txt';
    my $msg = '';
    my $cnt = scalar keys(%sln_depends);
    my ($key, $val);
    prt( "Writing $cnt potential dependencies to $outfil ...\n" ) if ($dbg_x19);
    $cnt = 0;
    if (open OF, ">$outfil") {
        $msg = "# configuration for $sln - generated by $pgname\n# on ".scalar localtime(time())."\n";
        $msg = "# list of inter-project dependencies, if any ...\n";
        print OF $msg;
        print OF "\n";
        foreach $key (keys %sln_depends) {
            $val = $sln_depends{$key};
            if (length($val)) {
                $msg = $depends."\t=\t"."$key=$val\n";
                print OF $msg;
                prt($msg) if ($dbg_x19);
                $cnt++;
            }
        }
        print OF "\n";
        print OF "# eof - $outfil\n";
        close OF;
        prt( "Written $cnt dependencies to $outfil ...\n" );
    } else {
        prtw( "WARNING: Unable to create $outfil! ... $! ...\n" );
    }
}

sub set_modest_debug {
    $dbg_sln = 1;    # show prt( "$cnt: Project=[".$arr[0]."] Path=[".$arr[1]."] ...
    $dbg_src6 = 1;   # show prt( "Got configuration $conf
    $dbg_src8  = 1;  # show prt( "Setting DEFS: $conf [$ppdefs] $apptype ($ctype)
    $dbg_src11 = 1;  # show prt( "Project=$projname, v=$version GUID=$ProjectGUID
    $dbg_src12 = 1;  # show prt( "Setting LINKS: $conf [$adddeps]
    $dgb_src17 = 1;  # show prt( "Got RUNTIME value [$ppdefs] ... config=$conf ($ctype) $itm (= $def)
    $dbg_x12 = 1;    # show prt( "VCPROJ Project: $projname, as $apptype, version=$version ... AND MORE
    #$dbg_x13 = 1;    # show prt( "Defined Debug = $dsp_defines_dbg, Release = $dsp_defines_rel... AND MORE
    $dbg_x14 = 1;    # show prt("Set INCLUDES:$conf: to [$ppdefs]
    $dbg_x15 = 1;    # show prt( "Set APPTYPE:$conf: v8_aptype[$apptype] (ln=$lnnum)... AND MORE see $dgbx_08 also
    #$dbg_x16 = 1;    # show prt("Got APPTYPE:$conf: NO CHANGE [$apptype] equals SubSystem ($adddeps) [".$v8_subsystems{$adddeps}."] ...
    $dbg_x17 = 1;    # show 	prt( "\nLoading [$in] file in directory [$in_fd] ...
}

# eof - fgslnlist.pl
