#!/usr/bin/perl -w
# NAME: findpath.pl
# AIM: Given an input file, find and output the path to that file
# If not directory given, then use current directory
# 22/12/2013 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2013-12-22";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';
my $in_dir='.';
my $cmake_form = 0;
my @in_files = ();
my @found_list = ();

# ### DEBUG ###
my $debug_on = 0;
my $def_file = 'def_file';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub scan_directory($$$);
sub scan_directory($$$) {
    my ($dir,$ra,$lev) = @_;
    my @dirs = ();
    my ($file,$ff);
    if (opendir(DIR,$dir)) {
        my @files = readdir(DIR);
        closedir(DIR);
        ut_fix_directory(\$dir);
        foreach $file (@files) {
            next if ($file eq '.');
            next if ($file eq '..');
            $ff = $dir.$file;
            if (-d $ff) {
                push(@dirs,$ff);
            } elsif (-f $ff) {
                push(@{$ra},$ff);
            } else {
                prtw("WARNING: What is THIS [$ff]\n");
            }
        }
        foreach $dir (@dirs) {
            scan_directory($dir,$ra,$lev + 1);
        }
    } else {
        prtw("WARNING: Unable to open directory [$dir]\n");
    }
}

sub sub_in_dir($) {
    my $p = shift;
    my $d = $in_dir;
    my $len = length($p);
    ut_fix_directory(\$d);
    my $len2 = length($d);
    return $p if ($len < $len2);
    my $i = 0;
    for ($i = 0; $i < $len2; $i++) {
        last if (substr($p,$i,1) ne substr($d,$i,1));
    }
    return substr($p,$i);
}

sub process_in_files() {
    my @files = ();
    my $rfa = scan_directory($in_dir,\@files,0);
    my ($ff,$tfil,$dir,$file);
    foreach $ff (@files) {
        ($tfil,$dir) = fileparse($ff);
        foreach $file (@in_files) {
            if ($file eq $tfil) {
                $ff = sub_in_dir($ff);
                $ff = path_d2u($ff) if ($cmake_form);
                prt("$ff\n");
                push(@found_list,$file);
            }
        }
    }
    my $fnd = 0;
    my $found_cnt = 0;
    foreach $file (@in_files) {
        $fnd = 0;
        foreach $tfil (@found_list) {
            if ($file eq $tfil) {
                $fnd = 1;
                last;
            }
        }
        if ($fnd) {
            $found_cnt++;
        } else {
            prt("$file NOT FOUND in $in_dir\n");
        }
    }
    $fnd = scalar @in_files;
    prt("Found $found_cnt of $fnd.\n");
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_files();
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub load_input_list($) {
    my $file = shift;
    prt("Loading input files from [$file]\n") if (VERB5());
    if (open FIL, "<$file") {
        my @lines = <FIL>;
        close FIL;
        my $cnt = 0;
        foreach $in_file (@lines) {
            chomp $in_file;
            $in_file = trim_all($in_file);
            next if ($in_file =~ /^\#/);
            push(@in_files,$in_file);
            $cnt++;
        }
        prt("Search $cnt files, from input $file\n") if (VERB5());
        $in_file = $in_files[0] if ($cnt);
    } else {
        pgm_exit(1,"ERROR: Unable to open file [$file]\n");
    }
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    my $verb = VERB5();
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if ($verb);
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if ($verb);
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if ($verb);
            } elsif ($sarg =~ /^p/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $in_dir = $sarg;
                if (-d $in_dir) {
                    prt("Set search directory to [$in_file].\n") if ($verb);
                } else {
                    pgm_exit(1,"ERROR: Can NOT locate directory [$in_dir]\n");
                }
            } elsif ($sarg =~ /^c/) {
                $cmake_form = 1;
                prt("Set to output in cmake form (unix)\n") if ($verb);
            } elsif ($sarg =~ /^i/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                load_input_list($sarg);
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            push(@in_files,$in_file);
            prt("Set input to [$in_file]\n") if ($verb);
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if ((length($in_file) ==  0) && $debug_on) {
            $in_file = $def_file;
            push(@in_files,$in_file);
            prt("Set DEFAULT input to [$in_file]\n");
        }
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    ###if (! -f $in_file) {
    ###    pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    ###}
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help   (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]      (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load         (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>   (-o) = Write output to this file.\n");
    prt(" --path <path>  (-p) = Search in this path, else current. def=$in_dir\n");
    prt(" --cmake        (-c) = Show path in cmake form (unix). def=$cmake_form\n");
    prt(" --input <file> (-i) = Input file containing line delimiated list to search.\n");
}

# eof - findpath.pl
