#!/perl -w
# NAME: fixdsp01.pl
# AIM: Very specific changes to be made to a set of DSP files
# In this case, add 2 defines to the compile lines
# 1. Ensure /D "HAVE_CONFIG_H" is there
# 2. Add /D "NOMINMAX", and
# 3. Add /D "_CRT_SECURE_NO_WARNINGS"
#
# if $outtmpfile is 0 (after renaming the current to OLD/BAK)
# else output a temp.Nnamed>.dsp locally otherwise.
# 25/02/2009 - geoff mclane - http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
   my @tmpsp = split(/\\/,$pgmname);
   $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);

my $writeoutfile = 1;  # change to '1' to do the write the changed files
my $outtmpfile = 0;  # change to '0' to do the write the changed files
my $in_folder = "C:\\FG\\27\\terragear-cs\\projects\\msvc";
my @warnings = ();
prt( "$0 ... Processing $in_folder...\n" );

sub prtw($) {
   my ($t) = shift;
   prt($t);
   $t =~ s/\n$//;
   push(@warnings,$t);
}
sub show_warnings() {
   if (@warnings) {
      prt( "Got ".scalar @warnings." warnings...\n" );
      foreach my $w (@warnings) {
         prt("$w\n");
      }
   } else {
      prt( "No warnings...\n" );
   }
}

sub get_files($) {
   my ($ind) = shift;
   my @dsp_files = ();
   if (opendir( DIR, $ind )) {
		my @files = readdir(DIR);
		closedir DIR;
      foreach my $file (@files) {
         next if (($file eq ".") || ($file eq ".."));
         my $ff = $ind."\\".$file;
         if ( -d $ff ) {
            # what to do with sub-directories
         } else {
            if ((length($file) > 4) && (substr($file,-4) =~ /\.dsp/i)) {
               # prt( "File: $file\n" );
               push(@dsp_files, $ff);
            }
         }
      }
   } else {
      prt( "ERROR: Unable to open directory [$ind]...\n" );
   }
   return @dsp_files;
}

sub fix_line1($$$) {
   my ($ln, $v, $nv) = @_;
   my $len = length($ln);
   my $nline = '';
   my ($end, $ind);
   $ind = index($ln, $v);
   if ($ind != -1) {
      $nline = substr($ln,0,$ind);
      $end = substr($ln,$ind + length($v));
      $nline .= $nv;
      $nline .= $end;
      return $nline;
   }
   return $ln;
}

sub process_files($) {
   my ($flr) = shift;
   my $cnt = scalar @$flr;
   prt( "Processing $cnt files...\n" );
   my ($val, $nval, $ind, $outfile);
   my $find = '/D "HAVE_CONFIG_H" ';
   my $fl = length($find);
   my $add = '/D "NOMINMAX" /D "_CRT_SECURE_NO_WARNINGS" ';
   foreach my $file (@$flr) {
      my ($nm, $dir) = fileparse( $file );
      if (open INF, "<$file") {
         my @lines = <INF>;
         close INF;
         my $lncnt = scalar @lines;
         my $type = 'UNKNOWN';
         my $chgs = 0;
         my $chgd = '';
         for (my $i = 0; $i < $lncnt; $i++) {
            my $line = $lines[$i];
            my $len = length($line);
            if ($line =~ /^#\s+TARGTYPE\s+"(.+)"/) {
               my $tt = $1;
               # prt( "TYPE [$tt]\n" );
               if ($tt =~ /Console/) {
                  $type = 'Console';
               } elsif ($tt =~ /Library/) {
                  $type = "Library";
               }
            } elsif (substr($line,0,1) eq '#') {
               # # ADD CPP /nologo /MD ... /I "." /D "HAVE_CONFIG_H" /D "NDEBUG" /D "WIN32" /D "_WINDOWS" /D "_MBCS" /D "_LIB" ...
               if ($line =~ /\s+ADD\s+CPP\s+/) {
                  $ind = index($line, '/D "HAVE_CONFIG_H" ');
                  # if ($line =~ /\/D\s+"HAVE_CONFIG_H"\s+/) {
                  if ($ind > 0) {
                     if ( !($line =~ /_CRT_SECURE_NO_WARNINGS/) ) {
                        $chgs++;
                        $nval = substr($line,0, $ind + $fl);   # get beginning
                        $nval .= $add;                         # add new defined
                        $nval .= substr($line, $ind + $fl);    # get balance
                        $lines[$i] = $nval;
                        prt($line);
                        prt($nval);
                     }
                  }
               }
            }
         }
         prt( "file: $nm, $lncnt lines... $type $chgs [$chgd]\n" );
         prtw( "WARNING: Only got $chgs lines... instead of 2!\n" ) if ($chgs != 2);
         if ($writeoutfile) {
            if ($outtmpfile) {
               $outfile = 'temp.'.$nm;
            } else {
               rename2oldbak($file);
               $outfile = $file;
            }
            write_a_file($outfile, @lines);
            prt( "Written $outfile...\n" );
         }

      } else {
         prt("ERROR: can not open [$file]!\n");
      }
   }
}

my @file_list = get_files( $in_folder );
process_files( \@file_list );
show_warnings();
close_log($outfile,1);
exit(0);
# eof - fixdsp01.pl
