#!/usr/bin/perl -w
# NAME: fixsrc.pl
# AIM: Quite specific - read in file with list of sources, find source,
# and fax the list
# 03/08/2012 - initial cut
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2012-08-03";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';
my $root_dir = '';
my @repo_dirs = qw( CVS .svn .git );
my @exclude_dirs = ();

# ### DEBUG ###
my $debug_on = 1;
my $def_file = 'C:\Projects\notepad-plus\build\temp1s.txt';
my $def_root = 'C:\Projects\notepad-plus';
### program variables
my @warnings = ();
my $cwd = cwd();
my $total_files = 0;
my $total_dirs = 0;

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub is_in_ref_array($$) {
    my ($fil,$ra) = @_;
    my ($tst);
    foreach $tst (@{$ra}) {
        return 1 if ($tst eq $fil);
    }
    return 0;
}


sub is_repo_dir($) {
    my $fil = shift;
    return is_in_ref_array($fil,\@repo_dirs);
}

sub is_excluded_dir($) {
    my $fil = shift;
    return is_in_ref_array($fil,\@exclude_dirs);
}


sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub read_dir($$);

sub read_dir($$) {
    my ($dir,$rh) = @_;
    if (!opendir(DIR,$dir)) {
        prt("Failed to open dir [$dir]\n");
    }
    my @files = readdir(DIR);
    closedir(DIR);
    $total_dirs++;
    ut_fix_directory(\$dir);
    my ($file,$ff);
    my @dirs = ();
    my @fils = ();
    foreach $file (@files) {
        next if ($file eq '.');
        next if ($file eq '..');
        next if (is_repo_dir($file));
        next if (is_excluded_dir($file));
        $ff = $dir.$file;
        if (-d $ff) {
            push(@dirs,$ff);
        } elsif (-f $ff) {
            push(@fils,$file);
            $total_files++;
        } else {
            pgm_exit(1,"WHAT IS THIS [$file] [$ff]????\n");
        }
    }
    ${$rh}{$dir} = \@fils;
    foreach $dir (@dirs) {
        read_dir($dir,$rh);
    }
}


sub get_file_list() {
    my $dir = $cwd;
    if (length($root_dir)) {
        $dir = $root_dir;
    } else {
        $root_dir = $dir;
    }
    my %hash = ();
    read_dir($dir,\%hash);
    prt("Read $total_dirs dirs, for $total_files files.\n");
    return \%hash;
}

sub sub_root_dir($) {
    my $ff = shift;
    my $len = length($root_dir);
    return substr($ff,$len+1);
}


sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my $rh = get_file_list();
    my ($line,$inc,$lnn,$dir,$ra,$file,$fnd,$ff,$len);
    $lnn = 0;
    my @found = ();
    my @missed = ();
    foreach $line (@lines) {
        chomp $line;
        $line = trim_all($line);
        $len = length($line);
        next if ($len == 0);
        $fnd = 0;
        $lnn++;
        foreach $dir (keys %{$rh}) {
            $ra = ${$rh}{$dir};
            foreach $file (@{$ra}) {
                if ($line eq $file) {
                    $fnd = 1;
                    $ff = $dir.$line;
                    last;
                }
            }
            if ($fnd) {
                last;
            }
        }
        if ($fnd) {
            $ff = sub_root_dir($ff);
            prt("$ff\n") if (VERB9());
            push(@found,$ff);
        } else {
            prt("File [$line] NOT FOUND\n");
            push(@missed,$line);
        }
    }
    $fnd = scalar @found;
    $len = scalar @missed;
    prt("Of the $lnn items checked, found $fnd sources.\n");
    foreach $file (sort @found) {
        prt("   $file\n");
    }
    prt("Missed $len\n");
    foreach $line (@missed) {
        prt("$line\n");
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_file($in_file);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if (VERB1());
        }
        shift @av;
    }

    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = $def_file;
        prt("Set DEFAULT input to [$in_file]\n");
        $load_log = 3;
        push(@exclude_dirs,"scintilla2");
        push(@exclude_dirs,"build");
    }
    if ((length($root_dir) ==  0) && $debug_on) {
        $root_dir = $def_root;
        prt("Set DEFAULT root to [$root_dir]\n");
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - fixsrc.pl
