#!/usr/bin/perl -w
# NAME: fixvcproj.pl
# AIM: Quite specialized: Given a vcxproj file, check lib dependencies does 
# NOT include optimized.lib and/or debug.lib
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.5 2015-01-09";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 1;
my $def_file = 'X:\build-osg.x64\src\osgPlugins\png\osgdb_png.vcxproj';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub split_on_vbar($) {
    my $val = shift;
    my ($ch,$tag,$len,$i);
    $len = length($val);
    my @arr = ();
    $tag = '';
    for ($i = 0; $i < $len; $i++) {
        $ch = substr($val,$i,1);
        if ($ch eq '|') {
            push(@arr,$tag) if (length($tag));
            $tag = '';
        } else {
            $tag .= $ch;
        }
    }
    push(@arr,$tag) if (length($tag));
    return @arr;
}

#28: <PropertyGroup Condition="'$(Configuration)|$(Platform)'=='Debug|x64'" Label="Configuration">
#33: <PropertyGroup Condition="'$(Configuration)|$(Platform)'=='Release|x64'" Label="Configuration">
#38: <PropertyGroup Condition="'$(Configuration)|$(Platform)'=='MinSizeRel|x64'" Label="Configuration">
#43: <PropertyGroup Condition="'$(Configuration)|$(Platform)'=='RelWithDebInfo|x64'" Label="Configuration">
my @configs = qw( Debug Release MinSizeRel RelWithDebInfo );
sub is_a_config($) {
    my $conf = shift;
    my ($c,$cf);
    #my @arr = split("\|",$conf);
    my @arr = split_on_vbar($conf);
    $cf = $arr[0];
    foreach $c (@configs) {
        if ($c eq $cf) {
            return 1;
        } elsif ($conf =~ /$c/) {
            return 1;
        }
    }
    prt("Missed '$conf' et '$cf'\n");
    return 0;
}


sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($i,$line,$inc,$lnn,$len,$ch,$tag,$text,$ltag,@arr,$conf,$tmp,$ntxt);
    $lnn = 0;
    my @nlines = ();
    my $intag = 0;
    my $currcfg = '';
    $tag = '';
    $text = '';
    $ltag = '';
    my $changes = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        $len = length($line);
        for ($i = 0; $i < $len; $i++) {
            $ch = substr($line,$i,1);
            if ($intag) {
                if (length($text)) {
                    if ( !($text =~ /^\s+$/) ) {
                        if ($ltag eq '<AdditionalDependencies>') {
                            @arr = split(";",$text);
                            $ntxt = '';
                            foreach $tmp (@arr) {
                                if (($tmp =~ /optimized\.lib/)||($tmp =~ /debug\.lib/)) {
                                    prt("Discard $tmp\n");
                                    $changes++;
                                } else {
                                    $ntxt .= ';' if (length($ntxt));
                                    $ntxt .= $tmp;
                                }
                            }
                            $text = $ntxt;
                            prt("$lnn: $ltag [$text]\n");
                        } else {
                            prt("$lnn: $ltag [$text]\n");
                        }
                        push(@nlines,$text);
                    }
                    $text = '';
                }
                $tag .= $ch;
                if ($ch eq '>') {
                    # 169: <ItemDefinitionGroup Condition="'$(Configuration)|$(Platform)'=='MinSizeRel|x64'">
                    if ($tag =~ /^<ItemDefinitionGroup\s+/ ) {
                        @arr = split("==",$line);
                        $tmp = $arr[-1];
                        $tmp =~ s/\">$//;
                        $conf = strip_single_quotes($tmp);
                        if (is_a_config($conf)) {
                            $currcfg = $conf;
                            prt("$lnn: CONFIG: $currcfg $tag\n");
                        } else {
                            prt("$lnn: $tag\n");
                        }
                    } else {
                        prt("$lnn: $tag\n") if (VERB9());
                    }
                    push(@nlines,$tag);
                    $intag = 0;
                }
            } else {
                if ($ch eq '<') {
                    $intag = 1;
                    $ltag = $tag;
                    $tag = $ch;
                } else {
                    $text .= $ch;
                }
            }
        }
    }
    if ($changes) {
        prt("Have $changes changes...\n");
        $line = join("\n",@nlines)."\n";
        rename_2_old_bak($inf);
        write2file($line,$inf);
        prt("New contents written to $inf\n");
    }
    ###$load_log = 1;
}


sub test() {
    my $line = '<ItemDefinitionGroup Condition="\'$(Configuration)|$(Platform)\'==\'Debug|x64\'">';
    my @arr = split("==",$line);
    my ($tmp,$conf,$cf);
    my $cnt = 0;
    foreach $tmp (@arr) {
        $cnt++;
        prt("$cnt [$tmp]\n");
    }
    $tmp = $arr[-1];
    $tmp =~ s/\">$//;
    $conf = strip_single_quotes($tmp);
    #@arr = split('|',$conf);
    @arr = split_on_vbar($conf);
    $cf = $arr[0];

    prt("conf: $tmp - $conf - $cf\n");
    if (is_a_config($conf)) {
        prt("Is config\n");
    }
    pgm_exit(1,"TEMP EXIT\n");
}

#########################################
### MAIN ###
###test();
parse_args(@ARGV);
process_in_file($in_file);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    my $verb = VERB2();
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                $verb = VERB2();
                prt("Verbosity = $verbosity\n") if ($verb);
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if ($verb);
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if ($verb);
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if ($verb);
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if (length($in_file) ==  0) {
            $in_file = $def_file;
            prt("Set DEFAULT input to [$in_file]\n");
        }
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
