#!/usr/bin/perl
use strict; use warnings; use diagnostics;
package bar;
our $foo = "hello"; 
$bar::foo = "world";
print "foobar = [$foo $bar::foo]\n";

sub prt { print shift }
sub dispSymbols {
    my ($hashRef) = shift;
    my (%symbols,@symbols,$typ,$val);
    %symbols = %{$hashRef};
    @symbols = sort(keys(%symbols));
    my $msg = '';
    my $cnt = 0;
    foreach (@symbols) {
        $typ = '';
        $val = '';
    	no strict 'refs'; # allow symbol table manipulation
        if (defined ${$_}) {
            $typ .= "scalar ";
            $val = '=['.${$_}.']';
        }
        $typ .= "array  " if (defined @{$_});
        $typ .= "hash   " if (defined %{$_});
        $typ .= "sub    " if (defined &{$_});
        $typ .= "Uncased" if (length($typ) == 0);
        $msg .= "$typ ".sprintf("%-20.20s| %s $val\n", $_, $symbols{$_});
        $cnt++;
    }
    prt($msg);
    return $cnt;
}
sub displaylibSymbols() {
    my $pack = __PACKAGE__;
    prt("Show defined symbols in package [$pack]\n");
    my $sym = '\%'.$pack.'::';
    my $cnt = dispSymbols(eval $sym);
    prt("Done show of $cnt symbols in package [$pack]\n");
}
displaylibSymbols();
