#!/usr/bin/perl -w
# NAME: gcc2msvc.pl
# AIM: Rought attempt to convert gcc structure initialization to 
# something agreeable to MSVC
# NO! ABANDONED ;=(( TOO HARD TO WRITE A C/C++ PARSER
# ===================================================
# 25/03/2013 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2013-03-17";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 1;
my $def_file = 'C:\FG\18\golang\src\libmach\8db.c';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

my $struct_count = 0;
my $struct_name = '';
my $struct_cntstr = '';

sub is_integer($) {
    my $n = shift;
    return 1 if ($n =~ /^\d+$/); # { $res .= "[is positive integer]" }
    return 0;
}

sub ref_array_contains($$) {
    my ($ra,$op) = @_;
    my ($itm);
    foreach $itm (@{$ra}) {
        return 1 if ($itm eq '*');
    }
    return 0;
}

sub array_contains($$) {
    my ($ra,$op) = @_; # \@acts,"Optable"
    my ($itm,$cnt,$len,$i,$tmp,$incnt,$cntstr);
    $cnt = 0;
    $len = scalar @{$ra};
    $incnt = 0;
    $cntstr = '';
    return 0 if (ref_array_contains($ra,'*'));
    for ($i = 0; $i < $len; $i++) {
        $itm = ${$ra}[$i];
        return 0 if ($itm eq 'struct');
        $cnt++;
        if (($itm eq $op) && ($cnt < $len)) {
            $struct_name = ${$ra}[$cnt];
            $struct_count = 0;
            $i = $cnt;
            $i++;
            for (; $i < $len; $i++) {
                $itm = ${$ra}[$i];
                if ($incnt) {
                    if ($itm eq ']') {
                        $incnt = 0;
                        last;
                    } else {
                        $cntstr .= ' ' if (length($cntstr));
                        $cntstr .= $itm;
                        $struct_count += $itm if (is_integer($itm));
                    }
                } elsif ($itm eq '[') {
                    $incnt = 1;
                }
            }
            $struct_cntstr = $cntstr;
            return $cnt;
        }
    }
    return 0;
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$i,$lnn,$ch,$len,$j,$j2,$nc,$incomm,$comm,$bgn,$tag,$tmp,$act,$inact,$alen);
    my ($inquot,$qc,$quoted,$blen,$res,$tline);
    $lnn = 0;
    $incomm = 0;
    $inact = 0;
    my @acts = ();
    my @brackets = ();
    my @braces = ();
    my @squares = ();
    $qc = '';
    for ($i = 0; $i < $lncnt; $i++) {
        $line = $lines[$i];
        chomp $line;
        $lnn++;
        $tline = trim_all($line);
        $len = length($tline);
        next if ($len == 0);
#        while (($line =~ /\/$/)&&(($i+1) < $lncnt)) {
#            $i++;
#            $line =~ s/\/$//;
#            $line .= ' ' if (!($line =~ /\s+$/));
#            $tmp = $lines[$i];
#            chomp $tmp;
#            $lnn++;
#            $line .= $tmp;
#        }
        $len = length($line);
        if ($line =~ /^\s*\#/) {
            prt("$lnn: $line\n") if (VERB5());
            next;
        }
        for ($j = 0; $j < $len; $j++) {
            $j2 = $j + 1;
            $ch = substr($line,$j,1);
            $nc = ($j2 < $len) ? substr($line,$j2,1) : '';
            if ($incomm) {
                if (($nc eq '/') && ($ch eq '*')) {
                    $incomm = 0;
                    prt("$bgn:$lnn: $comm\n") if (length($comm) && VERB9());
                    $comm = '';
                    $j++;   # skip one char
                } else {
                    $comm .= $ch;
                }
            } else {
                if (($ch eq '/')&&($nc eq '/')) { # being of '//' or '/*' comments
                    last; # skip balance of line as comment
                } elsif (($ch eq '/')&&($nc eq '*')) {
                    $incomm = 1;
                    $j++;   # skip one char
                    $comm = '';
                    $bgn = $lnn;
                } else {
                    # NOT in a comment
                    if ($inquot) {
                        $quoted .= $ch;
                        if ($ch eq $qc) {
                            $inquot = 0;
                            $inact = 0;
                            push(@acts,$act) if (length($act));
                            ### prt("$lnn: pushed [$act]\n");
                            $act = '';
                            push(@acts,$quoted) if (length($quoted));
                            $quoted = '';
                        }
                        next;
                    } elsif (($ch eq '"')||($ch eq "'")) {
                        $qc = $ch;
                        $inquot = 1;
                        $quoted = $ch;
                        $inact = 0;
                        push(@acts,$act) if (length($act));
                        ### prt("$lnn: pushed [$act]\n");
                        $act = '';
                        next;
                    }

                    if ($inact) {
                        if ($ch =~ /\w/) {
                            $act .= $ch;
                        } else {
                            $inact = 0;
                            push(@acts,$act) if (length($act));
                            ### prt("$lnn: pushed [$act]\n");
                            $act = '';
                            if ($ch =~ /\s/) {
                                # skip spaces
                            } else {
                                push(@acts,$ch);
                            }
                        }
                    } else {
                        if ($ch =~ /\w/) {
                            $act .= $ch;
                            $inact = 1;
                        } elsif ($ch =~ /\s/) {
                            # skip spaces
                        } else {
                            push(@acts,$ch);
                        }
                    }

                    if (!$inquot) {
                        if ($ch eq '(') {
                            push(@brackets,$lnn);
                        } elsif ($ch eq ')') {
                            $blen = scalar @brackets;
                            if ($blen) {
                                pop @brackets;
                            } else {
                                prtw("WARNING: $lnn: close brackets [$line] NONE ON STACK!\n");
                            }
                        } elsif ($ch eq '{') {
                            push(@braces,$lnn);
                        } elsif ($ch eq '}') {
                            $blen = scalar @braces;
                            if ($blen) {
                                pop @braces;
                            } else {
                                prtw("WARNING: $lnn: close braces [$line] NONE ON STACK!\n");
                            }
                        } elsif ($ch eq '[') {
                            push(@squares,$lnn);
                        } elsif ($ch eq ']') {
                            $blen = scalar @squares;
                            if ($blen) {
                                pop @squares;
                            } else {
                                prtw("WARNING: $lnn: close squares [$line] NONE ON STACK!\n");
                            }
                        }
                    }


                    if ($ch eq ';') {
                        $tag .= $ch;
                        $alen = scalar @acts;
                        # ==================================================
                        $res = array_contains(\@acts,"Optable");
                        if (VERB9()) {
                            prt("$lnn: $tag ");
                            prt("[".join(" ",@acts)."]") if ($alen);
                            prt("\n");
                        } else {
                            prt("$lnn: [".join(" ",@acts)."]\n") if ($alen && VERB5());
                            if ($res) {
                                $tmp = $acts[$res];
                                prt("$lnn: BEGIN 'Optable' $tmp [$struct_count] $struct_cntstr\n");
                            }
                        }
                        # ==================================================
                        $tag = '';
                        @acts = ();
                    } else {
                        $tag .= $ch;
                    }
                }
            }
        }
        # =====================================
        # done a LINE
        if ($incomm) {
            # still in a comment
        } else {
            $tmp = trim_all($tag);
            push(@acts,$act) if (length($act));
            $alen = scalar @acts;
            if (length($tmp) || $alen) {
                # ==================================================
                $res = array_contains(\@acts,"Optable");
                if (VERB9()) {
                    prt("$lnn: $tag ");
                    prt("[".join(" ",@acts)."]") if ($alen);
                    prt("\n");
                } else {
                    prt("$lnn: [".join(" ",@acts)."]\n") if ($alen && VERB5());
                    if ($res) {
                        $tmp = $acts[$res];
                        prt("$lnn: BEGIN2 'Optable' $tmp [$struct_count] $struct_cntstr\n");
                    }
                }
                # ==================================================
            }
            $tag = '';
            @acts = ();
            $inact = 0;
            $act = '';
            $quoted = '';
            $inquot = 0;
        }
        # =====================================
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_file($in_file);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if (VERB1());
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if ((length($in_file) ==  0) && $debug_on) {
            $in_file = $def_file;
            prt("Set DEFAULT input to [$in_file]\n");
        }
        $load_log = 2;
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
