#!/perl
# NAME: genprimes.pl
# AIM: To generate all the primes numbers up to a maximum number,
# and insert them into an array, which expands itself ...
# see : http://www.perlmeme.org/tutorials/arrays.html
use strict;
use warnings;
my $num_primes = 0;
my @primes;
my $wrap = 10;
my $cnt = 0;
my $max_number = 50000;

# Put 2 as the first prime so we won't have an empty array
$primes[$num_primes] = 2;
$num_primes++;
print "Moment ... collecting the primes up to $max_number ...\n";
MAIN_LOOP: 
for my $number_to_check (3 .. $max_number) {
	for my $p (0 .. ($num_primes-1)) {
		if ($number_to_check % $primes[$p] == 0) {
			next MAIN_LOOP;
		}
	}
	# If we reached this point it means $number_to_check is not
	# divisable by any prime number that came before it.
	$primes[$num_primes] = $number_to_check; # store it
	$num_primes++;	# and bump prime count
}

print "Output of $num_primes prime numbers ...\n";
for my $p (0 .. ($num_primes-1))
{
	print $primes[$p];
	$cnt++;
	if ($cnt >= $wrap) {
		$cnt = 0;
		print "\n";
	} else {
		print ", ";
	}
}
if( $cnt ) {
	print "\n";
}
print "Done generation, and output of $num_primes prime numbers ...\n";
exit(0);
