#!/usr/bin/perl -w
# NAME: genreadme.pl
# AIM: Read all current perl scripts, seek 'NAME' and 'AIM', and generate a list
# 21/07/2014 - see also perl-list.pl, whihc does a similar job, outing to txt and html!
# and adds the use items, and the sub's contained.
# 21/07/2014 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use File::stat;
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.2 2014-01-13";
my $load_log = 0;
my $out_file = $temp_dir.$PATH_SEP.'README.htm';
my $verbosity = 0;
my $in_file = '';

# ### DEBUG ###
my $debug_on = 0;
my $def_file = 'def_file';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

my %lib_list = ();
my %hash = ();

sub html_head() {
    my $txt = <<EOF;
<html>
 <head>
  <title>Perl List</title>
  <link href="perl.css"
        rel="stylesheet"
        rev="stylesheet"
        type="text/css"
        media="screen">
 </head>
 <body>
 <h1 align="center">Perl List</h1>
EOF
    return $txt;
}

sub to_html($) {
    my $line = shift;
    $line =~ s/</&lt;/g;
    $line =~ s/>/&gt;/g;
    return $line;
}

sub show_hash() {
    my $dir = $perl_dir;
    my @arr = sort keys %hash;
    my ($key,$ra,$len,$txt);
    rename_2_old_bak($out_file);
	open WOF, ">$out_file" or mydie("ERROR: Unable to open $out_file! $!\n");
    print WOF html_head();
    # list NOT libraries
    my ($line,$sb,$ff,$dmsg);
    ut_fix_directory(\$dir);
    foreach $key (@arr) {
        next if (defined $lib_list{$key});
        $ff = $dir.$key;
        $dmsg = '';
        if ($sb = stat($ff)) {
            $dmsg = " - ".get_YYYYMMDD($sb->mtime);
        }
        $ra = $hash{$key};
        prt("$key $dmsg\n");
        $txt = "<p><b>$key</b> $dmsg<br>\n";
        $len = scalar @{$ra};
        if ($len) {
            foreach $line (@{$ra}) {
                $line = to_html($line);
                $txt .= "$line<br>\n";
            }
        }
        $txt .= "</p>\n";
       	print WOF $txt;
    }
    foreach $key (@arr) {
        next if (! defined $lib_list{$key});
        $ff = $dir.$key;
        $dmsg = '';
        if ($sb = stat($ff)) {
            $dmsg = " - ".get_YYYYMMDD($sb->mtime);
        }
        $ra = $hash{$key};
        prt("$key - library $dmsg\n");
        $txt = "<p><b>$key</b> - library $dmsg<br>\n";
        $len = scalar @{$ra};
        if ($len) {
            foreach $line (@{$ra}) {
                $line = to_html($line);
                $txt .= "$line<br>\n";
            }
            ### $txt .= join("<br>\n",@{$ra})."\n";
        }
        $txt .= "</p>\n";
       	print WOF $txt;
    }
    print WOF "</body>\n</html)\n";
    close WOF;
}

sub show_hash_txt() {
    my @arr = sort keys %hash;
    my ($key,$ra,$len,$txt);
    rename_2_old_bak($out_file);
	open WOF, ">$out_file" or mydie("ERROR: Unable to open $out_file! $!\n");
    # list NOT libraries
    foreach $key (@arr) {
        next if (defined $lib_list{$key});
        $ra = $hash{$key};
        $txt = "$key\n";
        prt($txt);
        $len = scalar @{$ra};
        if ($len) {
            $txt .= join("\n",@{$ra})."\n";
        }
       	print WOF $txt;
    }
    foreach $key (@arr) {
        next if (! defined $lib_list{$key});
        $ra = $hash{$key};
        $txt = "$key - library\n";
        prt($txt);
        $len = scalar @{$ra};
        if ($len) {
            $txt .= join("\n",@{$ra})."\n";
        }
       	print WOF $txt;
    }
    close WOF;
}

sub process_in_file($$) {
    my ($inf,$dir) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    my $base = substr($inf,length($dir));
    prt("$base: $lncnt lines...\n") if (VERB5());
    my ($line,$inc,$lnn,$len,$inaim);
    $lnn = 0;

    $inaim = 0;
    my @arr = ();
    my $islib = 0;
    foreach $line (@lines) {
        $lnn++;
        chomp $line;
        $line = trim_all($line);
        $len = length($line);
        next if ($len == 0);
        if ( !($line =~ /^\#/) ) {
            $islib = 1 if ($line =~ /^1/);
            $inaim = 0;
            next;
        }
        if ($inaim) {
            prt("$lnn: $line\n") if (VERB9());
            $line = to_html($line);
            push(@arr,$line);
        } elsif ($line =~ /^\#\s*AIM/) {
            prt("$lnn: $line\n") if (VERB9());
            $line = to_html($line);
            push(@arr,$line);
            $inaim = 1;
        }
    }
    $hash{$base} = \@arr;
    $lib_list{$base} = 1 if ($islib);
}

sub process_perl_dir() {
    my $dir = $perl_dir;
    if (!opendir(DIR,$dir)) {
        prt("Failed to open directory '$dir'\n");
        return;
    }
    my @files = readdir(DIR);
    closedir(DIR);
    my ($file,$ff,$cnt);
    ut_fix_directory(\$dir);
    my @perl_files = ();
    foreach $file (@files) {
        next if ( !($file =~ /\.pl$/) );
        $ff = $dir.$file;
        push(@perl_files,$ff);
    }
    @perl_files = sort @perl_files;
    $cnt = scalar @perl_files;
    prt("Found $cnt perl files, in '$dir'...\n");
    foreach $ff (@perl_files) {
        process_in_file($ff,$dir);
    }
    show_hash();
    ###$load_log = 1;
}


#########################################
### MAIN ###
parse_args(@ARGV);
process_perl_dir();
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    my $verb = VERB2();
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                $verb = VERB2();
                prt("Verbosity = $verbosity\n") if ($verb);
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if ($verb);
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if ($verb);
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if ($verb);
        }
        shift @av;
    }

#    if ($debug_on) {
#        prtw("WARNING: DEBUG is ON!\n");
#        if (length($in_file) ==  0) {
#            $in_file = $def_file;
#            prt("Set DEFAULT input to [$in_file]\n");
#        }
#    }
#    if (length($in_file) ==  0) {
#        pgm_exit(1,"ERROR: No input files found in command!\n");
#    }
#    if (! -f $in_file) {
#        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
#    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
