#!/usr/bin/perl -w
# NAME: getapt.pl
# AIM: *** VERY SPECIFIC *** Testing fetching and writing navdata json
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use LWP::Simple;
use JSON;
use Data::Dumper;
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.2 2014-01-13";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 0;
my $def_file = 'def_file';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

sub fetch_url($$) {
	my ($url,$ra) = @_;
    my $ret = 0;
	prt( "Fetching: $url\n" );
	my $txt = get($url);
	if ($txt && length($txt)) {
		# prt( "$txt\n" );
        @{$ra} = split("\n",$txt);
        $ret = scalar @{$ra};
    } else {
        prt("URL: $url FAILED!\n");
    }
    return $ret;
}

# Current total rows 11095, but need to redo 19
# x,y -100,30 -100,40 -90,30 -90,40 -80,40 -60,-30 -60,-20 -60,-10 -50,-30 -50,-20 -50,-10 -10,50 0,40 0,50
# x,y 10,40 10,50 130,-20 140,-40 140,-30
# http://navdata.fgx.ch/all.json?bbox=-100,30,-95,35&ntype=apt
sub getapts() {
    my ($gx,$x,$gy,$y,$file,$x2,$y2,$x3,$url,$bbox,$cnt,$json,$ff);

    # @REM wget -O 0014700349.json "http://navdata.fgx.ch/all.json?bbox=1.0,47.0,3.0,49.0&ntype=apt"
    # wget -O %TMPFIL% "http://navdata.fgx.ch/all.json?bbox=%BBOX%&ntype=apt"

    my $serv = "http://navdata.fgx.ch/all.json";
    my $dir = "F:\\DTEMP\\apt2";
    if (! -d $dir) {
        pgm_exit(1,"ERROR: dir $dir does NOT exist!\n");
    }
    $cnt = 0;
    for ($gx = -180; $gx < 180; $gx += 5) {
        $x = $gx;
        $x2 = $x + 5;
        $x3 = $x2;
        $x = -179.99 if ($x == -180);
        $x2 = 179.99 if ($x2 == 180);
        for ($gy = -90; $gy < 90; $gy += 5) {
            $y = $gy;
            $y2 = $y + 5;
            $file = "$gx$gy$x3$y2.json";
            $y = -89.99 if ($y == -90);
            $y2 = 89.99 if ($y2 == 90);
            #prt("$file ");
            $bbox = "$x,$y,$x2,$y2";
            $url = $serv."?bbox=$bbox&ntype=apt";
            $cnt++;
            prt("$cnt: Fetch: $url to $file\n");
            $ff = $dir.$PATH_SEP.$file;
            $json = get($url);
            # getstore( $url, "F:\\DTEMP\\apts\\$file" );
            if ($json && length($json)) {
                write2file($json,$ff);
                prt("$json\nwritten to $ff\n");
                ##pgm_exit(1,"TEMP");
            } else {
                prtw("WARNING: Fetch $url FAILED!\n");
            }
        }
    }
}

sub getaptsx10() {
    my ($gx,$x,$gy,$y,$file,$x2,$y2,$x3,$url,$bbox,$cnt,$json,$ff);

    # @REM wget -O 0014700349.json "http://navdata.fgx.ch/all.json?bbox=1.0,47.0,3.0,49.0&ntype=apt"
    # wget -O %TMPFIL% "http://navdata.fgx.ch/all.json?bbox=%BBOX%&ntype=apt"

    my $serv = "http://navdata.fgx.ch/all.json";
    my $dir = "F:\\DTEMP\\apts";
    if (! -d $dir) {
        pgm_exit(1,"ERROR: dir $dir does NOT exist!\n");
    }
    $cnt = 0;
    for ($gx = -180; $gx < 180; $gx += 10) {
        $x = $gx;
        $x2 = $x + 10;
        $x3 = $x2;
        $x = -179.99 if ($x == -180);
        $x2 = 179.99 if ($x2 == 180);
        for ($gy = -90; $gy < 90; $gy += 10) {
            $y = $gy;
            $y2 = $y + 10;
            $file = "$gx$gy$x3$y2.json";
            $y = -89.99 if ($y == -90);
            $y2 = 89.99 if ($y2 == 90);
            #prt("$file ");
            $bbox = "$x,$y,$x2,$y2";
            $url = $serv."?bbox=$bbox&ntype=apt";
            $cnt++;
            prt("$cnt: Fetch: $url to $file\n");
            $ff = $dir.$PATH_SEP.$file;
            $json = get($url);
            # getstore( $url, "F:\\DTEMP\\apts\\$file" );
            if ($json && length($json)) {
                write2file($json,$ff);
                prt("$json\nwritten to $ff\n");
                ##pgm_exit(1,"TEMP");
            } else {
                prtw("WARNING: Fetch $url FAILED!\n");
            }
        }
    }
}


my $total_rows = 0;

sub show_json($$$) {
    my ($rl,$file,$cnt) = @_; # \@lines
    my $line = join("",@{$rl});
    my $json = JSON->new->allow_nonref;
    my $perl_scalar = $json->decode( $line );
    ##prt(Dumper($perl_scalar));
    ##pgm_exit(1,"TEMP");
    my $rows = ${$perl_scalar}{row_count};
    my $rrows = ${$perl_scalar}{rows};
    my $max = scalar @{$rrows};
    if ($max) {
        prt("$cnt: $file: Row count $rows ($max)\n");
        $total_rows += $max;
    }
    return $max;
}


sub count_airports() {
    my ($gx,$x,$gy,$y,$file,$x2,$y2,$x3,$url,$bbox,$cnt,$json,$ff,$apts);

    # @REM wget -O 0014700349.json "http://navdata.fgx.ch/all.json?bbox=1.0,47.0,3.0,49.0&ntype=apt"
    # wget -O %TMPFIL% "http://navdata.fgx.ch/all.json?bbox=%BBOX%&ntype=apt"

    my $serv = "http://navdata.fgx.ch/all.json";
    my $dir = "F:\\DTEMP\\apts";
    if (! -d $dir) {
        pgm_exit(1,"ERROR: dir $dir does NOT exist!\n");
    }
    $cnt = 0;
    my @redo = ();
    for ($gx = -180; $gx < 180; $gx += 10) {
        $x = $gx;
        $x2 = $x + 10;
        $x3 = $x2;
        $x = -179.99 if ($x == -180);
        $x2 = 179.99 if ($x2 == 180);
        for ($gy = -90; $gy < 90; $gy += 10) {
            $y = $gy;
            $y2 = $y + 10;
            $file = "$gx$gy$x3$y2.json";
            $y = -89.99 if ($y == -90);
            $y2 = 89.99 if ($y2 == 90);
            #prt("$file ");
            $bbox = "$x,$y,$x2,$y2";
            $url = $serv."?bbox=$bbox&ntype=apt";
            $cnt++;
            $ff = $dir.$PATH_SEP.$file;
            if (-f $ff) {
                prt("$cnt: Read file $ff\n") if (VERB9());
                if (open INF, "<$ff") {
                    my @lines = <INF>;
                    close INF;
                    $apts = show_json(\@lines,$file,$cnt);
                    push(@redo,[$gx,$gy]) if ($apts == 200);
                } else {
                    prtw("WARNING: Unable to OPEN file $ff!\n");

                }
            } else {
                prtw("WARNING: File $ff does NOT exist!\n");
            }
            ###$json = get($url);
            ### getstore( $url, "F:\\DTEMP\\apts\\$file" );
            ###if ($json && length($json)) {
            ###    write2file($json,$ff);
            ###    prt("$json\nwritten to $ff\n");
            ###    ##pgm_exit(1,"TEMP");
            ###} else {
            ###    prtw("WARNING: Fetch $url FAILED!\n");
            ###}
        }
    }
    $cnt = scalar @redo;
    prt("Current total rows $total_rows, but need to redo $cnt\n");
    foreach my $ra (@redo) {
        prt("x,y ".${$ra}[0].','.${$ra}[1]."\n");
    }
    $load_log = 1;
}

#########################################
### MAIN ###
#parse_args(@ARGV);
#process_in_file($in_file);
getapts();
###count_airports();

pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    my $verb = VERB2();
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                $verb = VERB2();
                prt("Verbosity = $verbosity\n") if ($verb);
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if ($verb);
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if ($verb);
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if ($verb);
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if (length($in_file) ==  0) {
            $in_file = $def_file;
            prt("Set DEFAULT input to [$in_file]\n");
        }
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
