#!/usr/bin/perl -w
# NAME: getjson.pl
# AIM: Download http://cf.fgx.ch/data json data, or localhost
# 24/12/2012 - 
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
use LWP::Simple;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2012-07-18";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 0;
my $def_file = 'def_file';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

sub colon_split {
	my ($txt) = shift;
	my $len = length($txt);
	my ($k, $ch, $tag, $incomm, $k2, $nch);
	my @arr = ();
	$tag = '';
	$incomm = 0;
	for ($k = 0; $k < $len; $k++) {
		$ch = substr($txt,$k,1);
        $k2 = $k + 1;
        $nch = ($k2 < $len) ? substr($txt,$k2,1) : "";
		if ($incomm) {
			$incomm = 0 if ($ch eq '"');
			$tag .= $ch;
            # add 2010/05/05 to avoid say '"zlib">' begin a tag
            if (!$incomm) {
                push(@arr,$tag);
                $tag = '';
            }
		} elsif ($ch eq ':') { # any colon char
            push(@arr, $tag) if (length($tag));
			$tag = '';
		} elsif (($ch =~ /\//)&&($nch eq '>')) { # 04/10/2008, but only if before '>' 24/09/2008 add this as well
			push(@arr, $tag) if (length($tag));
			$tag = $ch; # restart tag with this character
		} else {
			$tag .= $ch;
			$incomm = 1 if ($ch eq '"');
		}
	}
	push(@arr, $tag) if (length($tag));
	return \@arr;
}


sub comma_split {
	my ($txt) = shift;
	my $len = length($txt);
	my ($k, $ch, $tag, $incomm, $k2, $nch);
	my @arr = ();
	$tag = '';
	$incomm = 0;
	for ($k = 0; $k < $len; $k++) {
		$ch = substr($txt,$k,1);
        #$k2 = $k + 1;
        #$nch = ($k2 < $len) ? substr($txt,$k2,1) : "";
		if ($incomm) {
			$incomm = 0 if ($ch eq '"');
			$tag .= $ch;
		} elsif ($ch eq ',') { # any comma char
            push(@arr, $tag) if (length($tag));
			$tag = '';
		} else {
			$tag .= $ch;
			$incomm = 1 if ($ch eq '"');
		}
	}
	push(@arr, $tag) if (length($tag));
	return \@arr;
}

my %fid_hash = ();
my %cs_hash = ();

sub split_json($) {
    my $txt = shift;
    my $rcoma = comma_split($txt);
    my $len = scalar @{$rcoma};
    my ($i,$tag,$ra,$sz,$fld,$val,$fid,$cs);
    my $line = '';
    my %hash = ();
    $fid = "unknown_fid";
    $cs  = 'unknown_cs';
    for ($i = 0; $i < $len; $i++) {
        $tag = ${$rcoma}[$i];
        $ra = colon_split($tag);
        $sz = scalar @{$ra};
        $fld = strip_double_quotes(${$ra}[0]);
        if ($sz == 2) {
            $val = strip_double_quotes(${$ra}[1]);
            $fid = $val if ($fld eq 'fid');
            $cs  = $val if ($fld eq 'callsign');
            $line .= "," if (length($line));
            $line .= "$fld=$val";
            $hash{$fld} = $val;
        } else {
            $line .= "," if (length($line));
            $line .= "t[$tag]$sz";
        }
    }
    $line = "$len [$line]";
    prt("$line\n") if (length($line) && VERB5());
    if (defined $fid_hash{$fid}) {
        prtw("WARNING: REPEATED FID [$fid]\n");
    }
    if (defined $cs_hash{$cs}) {
        prtw("WARNING: REPEATED CS [$cs]\n");
    }
    $fid_hash{$fid} = \%hash;
    $cs_hash{$cs}   = \%hash;
}

sub show_json($) {
    my $txt = shift;
    my $len = length($txt);
    return if ($len == 0);
    my ($ch,$i,$inbr,$stg);
    my @braces = ();
    my $max = 90;
    for ($i = 0; $i < $len; $i++) {
        $ch = substr($txt,$i,1);
        if ($ch eq '{') {
            $i++;
            $stg = '';
            for (; $i < $len; $i++) {
                $ch = substr($txt,$i,1);
                if ($ch eq '}') {
                    if (length($stg) > $max) {
                        prt(substr($stg,0,$max)."\n") if (VERB9());
                    } else {
                        prt("$stg\n") if (length($stg));
                    }
                    split_json($stg) if (length($stg));
                    last;
                } elsif ($ch eq "{") {
                    if (length($stg) > $max) {
                        prt(substr($stg,0,$max)."\n") if (VERB9());
                    } else {
                        prt("$stg\n") if (length($stg));
                    }
                    split_json($stg) if (length($stg));
                    last;
                }
                $stg .= $ch if (!($ch =~ /\s/));
            }
        }
    }
}

sub get_json() {
    my $url = "http://localhost:3335?/data";
    prt("Doing get($url)...\n");
    my $txt = get($url);
    if (length($txt)) {
        prt("$txt\n");
    } else {
        prt("Get FAILED\n");
    }
}
    

sub get_json2() {
    my $url = "http://cf.fgx.ch/data";
    prt("Doing get($url)...\n");
    my $txt = get($url);
    my $cnt = 1;
    my $max = 20;
    if (length($txt)) {
        prt("$txt\n") if (VERB9());
        prt("On first try...\n");
    } else {
        while ((length($txt) == 0)&&($cnt < $max)) {
            $cnt++;
            prt("Try $cnt...\n");
            $txt = get($url);
        }
        if (length($txt)) {
            prt("$txt\n") if (VERB9());
            prt("After $cnt tries...\n");
        } else {
            prt("Got nothing after $cnt tries!\n");
        }
    }
    show_json($txt) if (length($txt));
}

#########################################
### MAIN ###
parse_args(@ARGV);
# process_in_file($in_file);
get_json();
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if (VERB1());
        }
        shift @av;
    }

    #if ((length($in_file) ==  0) && $debug_on) {
    #    $in_file = $def_file;
    #    prt("Set DEFAULT input to [$in_file]\n");
    #}
    #if (length($in_file) ==  0) {
    #    pgm_exit(1,"ERROR: No input files found in command!\n");
    #}
    #if (! -f $in_file) {
    #    pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    #}
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
