#!/usr/bin/perl -w
# NAME: getopts.pl
# AIM: Just testing the GetOpts package, but so many examples not tried...
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Getopt::Long;       # pour rcuprer les options en ligne de commande
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.2 2014-11-13";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 0;
my $def_file = 'def_file';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

my $texte_aide = <<EOF;
$pgmname, v. $VERS

Just testing GetOpts::Long package.

syntaxe: $pgmname [options]
options:
    [-v | --vor-a-vor] [--preferer-vor] [--km]
    [--help] [-a | --arr=string]
    [--dist=value]
    [--more] Can be repeated
EOF


#########################################
### MAIN ###
my ($vor_a_vor,$vor_preferes,$km,$help,$arrivee,$dist,$more);
my $options = GetOptions ( "v|vor-a-vor" => \$vor_a_vor,
               "preferer-vor"=> \$vor_preferes,
               "km"          => \$km,
               "a|arr=s"     => \$arrivee,
               "help"        => \$help,
               "dist=i"      => \$dist,
               "more+"       => \$more
               );
prt("Value of 'options' = $options\n");
prt("Got -a or --arr=$arrivee\n") if ($arrivee);
prt("Got --dist=$dist\n") if ($dist);
prt("Got -v or --vor-a-vor\n") if ($vor_a_vor);
prt("Got --preferer-vor\n") if ($vor_preferes);
prt("Got --km\n") if ($km);
prt("Got --more $more times\n") if ($more);
prt("$texte_aide\n") if ($help);
##process_in_file($in_file);
pgm_exit(0,"");
########################################

# eof - getopt.pl
