#!/usr/bin/perl -w
# NAME: gitlist.pl
# AIM: Given an input directory, search for cnake project, and list which are already 
# part of a REPO
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.3 2014-12-27";
my $load_log = 0;
my $in_dir = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 0;
###my $def_file = 'C:\Gtools\tools';
my $def_file = 'C:\Gtools\conapps';
###my $def_file = 'F:\Projects';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

my %ignore_dirs = (
    'fg-64-prev' => 1,
    'fg-64' => 1,
    'fg-32' => 1
    );

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}


#  url = git@github.com:geoffmcl/cf-log.git
sub get_url_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n") if (VERB9());
    my ($line,$inc,$lnn,$len);
    $lnn = 0;
    $inc = '';
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        $line = trim_all($line);
        $len = length($line);
        next if ($len == 0);
        if ($line =~ /url\s*=\s*(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n") if (VERB9());
            last;
        }
    }
    return $inc;
}

# project(FooBar C)
sub get_project_in_cmake($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n") if (VERB9());
    my ($line,$inc,$lnn,$len,@arr);
    $lnn = 0;
    $inc = '';
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        $line = trim_all($line);
        $len = length($line);
        next if ($len == 0);
        if ($line =~ /project\s*\(\s*(.+)\s*\)/i) {
            $inc = $1;
            @arr = split(/\s+/,$inc);
            $inc = $arr[0];
            prt("$lnn: $inc\n") if (VERB9());
            last;
        }
    }
    return $inc;
}


my @urls_found = ();
my %dir_url = ();
my @projs_found = ();

sub show_git_urls() {
    my $cnt = scalar @urls_found;
    prt("Got $cnt git urls in $in_dir scan...\n");
    my ($ra,$ff,$url);
    my ($min,$len);
    $min = 0;
    foreach $ra (@urls_found) {
        $ff  = ${$ra}[0];
        $len = length($ff);
        $min = $len if ($len > $min);
    }
    foreach $ra (@urls_found) {
        $ff  = ${$ra}[0];
        $url = ${$ra}[1];
        # display
        $ff .= ' ' while (length($ff) < $min);
        prt("$ff $url\n");
    }
}

sub show_projects() {
    my $cnt = scalar @projs_found;
    prt("Got $cnt projects in $in_dir scan...\n");
    my ($ra,$ff,$url,$dir);
    my ($min,$len,$min2);
    $min = 0;
    $min2 = 0;
    foreach $ra (@projs_found) {
        $ff  = ${$ra}[0];
        $len = length($ff);
        $min = $len if ($len > $min);
        $url = ${$ra}[1];
        $len = length($url);
        $min2 = $len if ($len > $min2);
    }
    foreach $ra (@projs_found) {
        $ff  = ${$ra}[0];
        $dir = ${$ra}[1];
        $url = '';
        if (defined $dir_url{$dir}) {
            $url = $dir_url{$dir};
        }

        # display
        $ff .= ' ' while (length($ff) < $min);
        $dir .= ' ' while (length($dir) < $min2);

        prt("$ff $dir $url\n");
    }
}


sub process_in_dir($$);

sub process_in_dir($$) {
    my ($dir,$lev) = @_;
    if (!opendir(DIR,$dir)) {
        prt("Failed to open dir $dir!\n");
        return;
    }
    my @files = readdir(DIR);
    closedir(DIR);
    my ($file,$ff,$cf);
    my $indir = $dir;
    ut_fix_directory(\$dir);
    my @dirs = ();
    my $fndgit = 0;
    my $fndrepo = 0;
    my $ignore = 0;
    my $fndcmake = 0;
    my $cmake = '';
    my $url = '';
    my $proj = '';
    foreach $file (@files) {
        next if ($file eq '.');
        next if ($file eq '..');
        $ff = $dir.$file;
        if (-f $ff) {
            if ($file eq 'CMakeLists.txt') {
                $proj = get_project_in_cmake($ff);
                prt("Found CMake $file ($ff) $proj\n") if (VERB5());
                if (length($proj)) {
                    push(@projs_found,[$proj,$indir]);
                }
                $cmake = $ff;
                $fndcmake = 1;
            }
        } elsif (-d $ff) {
            if ($file eq '.git') {
                $cf = $ff.$PATH_SEP.'config';
                $url = '';
                if (-f $cf) {
                    $url = get_url_in_file($cf);
                }
                prt("Found GIT $file ($ff) $url\n") if (VERB5());
                push(@urls_found, [$indir,$url]);
                $dir_url{$indir} = $url;
                $fndgit = 1;
                #$ignore = 1;
            } elsif ($file eq '.svn') {
                $fndrepo = 1;
                #$ignore = 1;
            } elsif ($file eq 'CSV') {
                $fndrepo = 1;
                #$ignore = 1;
            } elsif (defined $ignore_dirs{$file}) {
                #$ignore = 1;
            } elsif ($file =~ /^build/) {

            } elsif ($file =~ /^temp/i) {
                #$ignore = 1;
            } else {
                push(@dirs,$ff);
            }
        } else {
            pgm_exit(1,"What is this? $ff $file! *** FIX ME ***\n");
        }
    }
    if (!$ignore) {
        if ($lev && $fndcmake) {
        ### if ($lev && $fndcmake && ($fndgit || $fndrepo)) {
            # no need to go deeper
        } else {
            foreach $dir (@dirs) {
                process_in_dir($dir,($lev + 1));
            }
        }
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_dir($in_dir,0);
show_git_urls();
show_projects();
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    my $verb = VERB2();
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                $verb = VERB2();
                prt("Verbosity = $verbosity\n") if ($verb);
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if ($verb);
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if ($verb);
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_dir = $arg;
            prt("Set input to [$in_dir]\n") if ($verb);
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if (length($in_dir) ==  0) {
            $in_dir = $def_file;
            prt("Set DEFAULT input to [$in_dir]\n");
        }
    }
    if (length($in_dir) ==  0) {
        pgm_exit(1,"ERROR: No input directory found in command!\n");
    }
    if (! -d $in_dir) {
        pgm_exit(1,"ERROR: Unable to find in dir [$in_dir]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-dir\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
