#!/perl -w
# NAME: hashref02.pl
# AIM: Just testing how to add values to a hash, return that hash, and show
# the values in the hash (reference)
# Inspiration for this example came from -
# http://www.cs.mcgill.ca/~abatko/computers/programming/perl/howto/hash/ - a great page about hashes
# 29/10/2008 - geoff mclane - http://geoffair.net/mperl
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
prt( "$0 ... Hahsing around ;=)) ...\n" );

my %hash = get_hash();
show_hash(\%hash);

close_log($outfile,1);
exit(0);

sub show_hash {
    my ($hr) = @_;  # get the hash reference
    my ($key, $val, $cnt, $i, $src, $h2r, $msg, $k, $v);
    prt( "Show hash (reference) contents ...\n" );
    foreach $key (keys %{$hr}) {
        $val = $$hr{$key};
        if ($key eq 'C_SOURCES') {
            $cnt = scalar @{$val}; # this is an array
            prt( "Got $cnt sources ...\n" );
            for ($i = 0; $i < $cnt; $i++) {
                $src = $$val[$i][0];
                $h2r = $$val[$i][3];    # this is a hash reference
                $msg = "$src ";
                foreach $k (keys %{$h2r}) {
                    $v = $$h2r{$k};
                    $msg .= " [$k = $v]";
                }
                prt( "$msg\n" );
            }
        } else {
            prt( "$key = $val\n" );
        }
    }
}

sub get_hash {
    my %h = ();
    my @srcs = ();
    my $hr;
    $h{'-NEW_RT_DBG'} = '/MDd';
    $h{'-NEW_RT_REL'} = '/MD';
    $hr = {};   # clear the hash reference
    $hr->{'debug'} = 'Debug';       # add some values
    $hr->{'release'} = 'Release';
    push(@srcs, ["file1.c", "group", "filter", $hr]); # store it
    $hr = {};   # clear reference
    $hr->{'debug2'} = 'Debug/Dupe'; # add some other values
    $hr->{'release2'} = 'Release/Dupe';
    push(@srcs, ["file2.c", "group", "filter", $hr]); # store it
    $h{'C_SOURCES'} = [@srcs];  # copy the array into the hash
    return %h;
}


# eof - hashref02.pl

