#!/usr/bin/perl -w
# NAME: hilogmax.pl
# AIM: *** VERY SPECIFIC *** Read a fgms.log, and NOTE the highest 'max: nn' clients
# 10/03/2014 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.2 2014-01-13";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 1;
my $def_file = 'C:\Users\user\Downloads\logs\temp\fgms-01.log';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

# Lines
# Addding a pilot
# 22.10.2013 20:15:50 New REMOTE Client: yeison@mpserver01:5000 (Aircraft/fokker100/Models/fokker100.xml) current clients: 39 max: 46
# 22.10.2013 20:15:53 New REMOTE Client: TEST_ww@mpserver01:5000 (OpenRadar) current clients: 40 max: 46
# 22.10.2013 20:16:03 New LOCAL Client: F-Optms@81.249.227.235:5000 (Aircraft/777/Models/777-300ER.xml) current clients: 41 max: 46
# Dropping a pilot - note duplicated lines
# 22.10.2013 20:16:34 TTL exceeded, dropping pilot F-Optms@LOCAL after 31 seconds. Current clients: 40 max: 46
# 22.10.2013 20:16:34 TTL exceeded, dropping pilot F-Optms@LOCAL after 31 seconds. Current clients: 40 max: 46
# 22.10.2013 20:16:44 TTL exceeded, dropping pilot flagada@mpserver01 after 106 seconds. Current clients: 39 max: 46
sub get_model($) {
    my $m = shift;
    my ($n,$d) = fileparse($m);
    $n =~ s/\.xml$//;
    return $n;
}
sub get_pilot($) {
    my $p = shift;
    my @a = split('@',$p);
    return $a[0];
}


sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn,$time,$len,$tline,$msg);
    $lnn = 0;
    my $max = 0;
    my $last_max = 0;
    my $last_lnn = 0;
    my $start_time = '';
    my $end_time = '';
    my $last_time = '';
    my $long_secs = 0;
    my $long_line = '';
    my ($pilot,$model,$comb,$add,$rh,@arr2);
    my @arr = ();
    my %pilots = ();
    my %models = ();
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        $tline = trim_all($line);
        $len = length($tline);
        next if ($len == 0);
        $last_time = substr($line,0,19);
        if ($line =~ /\s+clients:\s+(\d+)\s+max:\s+(\d+)\s*$/) {
            $inc = $1;
            # 1234567890123456789
            # 26.01.2014 11:34:29 '
            if ($inc > $max) {
                $max = $inc;
                $time = substr($line,0,19);
                prt("$lnn: $time A clients: $max\n");
                $last_lnn = $lnn;
            }
            if ($inc > $last_max) {
                $time = substr($line,0,19);
                $last_max = $inc;
                if ($lnn > $last_lnn) {
                    prt("$lnn: $time C clients: $max\n");
                }
            }
        } elsif ($line =~ /\s+My\s+PID\s+is\s+/ ) {
            $end_time = $last_time;
            prt("Sart $start_time to $end_time\n");
            if (length($start_time)) {
                $msg = "Start $start_time End $end_time Max $last_max";
                prt("$msg\n");
                push(@arr,$msg);
            }
            $start_time = $end_time;
            $last_max = 0;
        }
        $add = 0;
        if ($line =~ /New\s+REMOTE\s+Client:\s+(.+)\s+\((.+)\)\s+current/) {
            $pilot = get_pilot($1); # like yeison@mpserver01:5000 
            $model = get_model($2); # Aircraft/fokker100/Models/fokker100.xml
            $add = 1;
        } elsif ($line =~ /\s+New\s+LOCAL\s+Client:\s+(.+)\s+\((.+)\)\s+current/) {
            $pilot = get_pilot($1); #  F-Optms@81.249.227.235:5000
            $model = get_model($2); # Aircraft/777/Models/777-300ER.xml
            $add = 1;
        }
        if ($add) {
            if (!defined $pilots{$pilot}) {
                $pilots{$pilot} = {};
                $comb = $pilot;
                $comb .= ' ' while (length($comb) < 8);
                prt("$comb $model\n");
            }
            $rh = $pilots{$pilot};
            ${$rh}{$model} = 1;
            if (defined $models{$model}) {
                $models{$model}++;
            } else {
                $models{$model} = 1;
            }
        }
        if ($line =~ /\s+after\s+(\d+)\s+seconds/) {
            $inc = $1;
            if ($inc > $long_secs) {
                $long_secs = $inc;
                $long_line = $line;
            }
        }
    }
    if (length($start_time)) {
        $end_time = $last_time;
        $msg = "Start $start_time End $end_time Max $last_max";
        prt("$msg\n");
        push(@arr,$msg);
    }
    $inc = scalar @arr;
    prt("\nLog indicates $inc start/stop sessions\n");
    prt(join("\n",@arr)."\n\n");
    prt("\nPilots with 'most' flight seconds\n");
    prt("$long_line\n");
    prt("That is ".secs_HHMMSS($long_secs).". Nice flight\n");
    @arr2 = keys %pilots;
    $lnn = scalar @arr2;
    $msg = "Some $lnn callsigns,";
    @arr2 = keys %models;
    $lnn = scalar @arr2;
    $msg .= " flew some $lnn models";
    prt("$msg\n");
    
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_file($in_file);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    my $verb = VERB2();
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                $verb = VERB2();
                prt("Verbosity = $verbosity\n") if ($verb);
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if ($verb);
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if ($verb);
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if ($verb);
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if (length($in_file) ==  0) {
            $in_file = $def_file;
            prt("Set DEFAULT input to [$in_file]\n");
        }
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
