#!/perl -w
# hrefsub - make substitutions in <A HREF="..."> fields of HTML files
# from Gisle Aas <gisle@aas.no>
# using HTML sample below
# and run with
# hrefsub.pl this that temp.htm
# this was close, but
# <p><a href="this" onmousemove="mm(self);"></p>
# was translated to ...
# <p><a href="that " onmousemove="mm(self); "></p>
# this seems 'fixed' if the line
#   $tmp .= qq( $_="$encoded ");
# is changed to
#   $tmp .= qq( $_="$encoded");
# WILL MAKE THIS CHANGE IN THE ORIGINAL
#sub usage { die "Usage: $0 <from> <to> <file>...\n" }
my $from = shift || 'this';
my $to   = shift || 'that';
##usage unless @ARGV;

# The HTML::Filter subclass to do the substitution.
package MyFilter;
require HTML::Filter;
@ISA=qw(HTML::Filter);
use HTML::Entities qw(encode_entities);
my $dbg1 = 0;
sub start {
   my($self, $tag, $attr, $attrseq, $orig) = @_;
   if ($tag eq 'a' && exists $attr->{href}) {
	   my $val = $attr->{href};
	   if ($val =~ /$from/) {
           ###if ($attr->{href} =~ s/\Q$from/$to/g) {
		   print "Got [$val] ...\n" if ($dbg1);
           if ($val =~ s/\Q$from/$to/g) {
				$attr->{href} = $val;
				print "Changed to [$val] ...\n" if ($dbg1);
               # must reconstruct the start tag based on $tag and $attr.
               # wish we instead were told the extent of the 'href' value
               # in $orig.
               my $tmp = "<$tag";
			   my $acnt = scalar @$attrseq;
			   my $cnt = 0;
               for (@$attrseq) {
                   my $encoded = encode_entities($attr->{$_});
				   $cnt++;
				   ##if ($cnt < $acnt) {
	               ##    $tmp .= qq( $_="$encoded ");
				   ##} else {
	                   $tmp .= qq( $_="$encoded");
				   ##}
				   print "encoded [$encoded]\n" if ($dbg1);
               }
               $tmp .= ">";
			   print "new [$tmp]\n" if ($dbg1);
               $self->output($tmp);
               return;
           }
	   }
   }
   $self->output($orig);
}

# Now use the class.

package main;
###foreach (@ARGV) {
###        MyFilter->new->parse_file($_);
###}
my $fil = 'temphtm.htm';
my $sample = <<EOF;
<html>
<head>
<title>test.htm</title>
</head>
<body>
<p><a href="this.htm" onmousemove="mm(self);" onmousehover="mh(self);" onmouseout="mo(self);">test</a></p>
</body>
</html>
EOF
open WOF, ">$fil" or die "ERROR: Unable to open $fil!!!\n";
print WOF $sample;
close WOF;
###MyFilter->new->parse_file($_);
MyFilter->new->parse_file($fil);
#-----------------------------
#eof - hrefsub02.pl - 2006.09.17
