#!/Perl -w
## Function-Oriented vs Object-Oriented Use
## http://search.cpan.org/src/LDS/CGI.pm-3.08/cgi_docs.html
## A simple function-oriented script looks like this:
use CGI qw(:standard);

print header;
print start_html('A Simple Example'),
    h1('A Simple Example'),
    start_form,
    "What's your name? ",textfield('name'),
    p,
    "What's the combination?",
    p,
    checkbox_group(-name=>'words',
		   -values=>['eenie','meenie','minie','moe'],
		   -defaults=>['eenie','minie']),
    p,
    "What's your favorite color? ",
    popup_menu(-name=>'color',
	       -values=>['red','green','blue','chartreuse']),
    p,
    submit,
    end_form,
    hr;

if (param()) {
    print 
	"Your name is",em(param('name')),
	p,
	"The keywords are: ",em(join(", ",param('words'))),
	p,
	"Your favorite color is ",em(param('color')),
	hr;
}
print end_html;

## using the object-oriented style looks like this: 
use CGI;

my $query = new CGI;
print $query->header;
print $query->start_html("A Clickable Image");
print <<END;
<H1>A Clickable Image</H1>
</A>
END
print "Sorry, this isn't very exciting!\n";

print $query->startform;
print $query->image_button('picture',"./wilogo.gif");
print "Give me a: ",$query->popup_menu('letter',['A','B','C','D','E','W']),"\n"; # 
print "<P>Magnification: ",$query->radio_group('magnification',['1X','2X','4X','20X']),"\n";
print "<HR>\n";

if ($query->param) {
    print "<P>Magnification, <EM>",$query->param('magnification'),"</EM>\n";
    print "<P>Selected Letter, <EM>",$query->param('letter'),"</EM>\n";
    my ($x,$y) = ($query->param('picture.x'),$query->param('picture.y'));
    print "<P>Selected Position <EM>($x,$y)</EM>\n";
}

print $query->end_html;


