#!/usr/bin/perl -w
# NAME: htmlconv.pl
# AIM: SPECIALISED - Add an alphbaetic list to openlayers.html
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2012-07-18";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = $temp_dir.$PATH_SEP."temphtm.html";

# ### DEBUG ###
my $debug_on = 1;
my $def_file = 'C:\OSGeo4W\apache\htdocs\openlayers.html';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn,$i,$len,$ch,$pc,$tag,$txt,$attr,$msg,$tmp,$name,$cnt);
    my $inquot = 0;
    my $incomm = 0;
    my $intable = 0;
    my $intag = 0;
    my $hadsp = 0;
    my $inbody = 0;
    my $intr = 0;
    my $tdcnt = 0;
    my $trcnt = 0;
    my $http = '';
    my $lsttxt = '';
    my $ptxt = '';
    my $endtable = 0;
    $lnn = 0;
    $ch = '';
    $tag = '';
    $txt = '';
    $attr = '';
    my @list = ();
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        # $line = trim_all($line);
        $len = length($line);
        next if ($len == 0);
        for ($i = 0; $i < $len; $i++) {
            $pc = $ch;
            $ch = substr($line,$i,1);
            if ($intag) {
                if ($ch eq '>') {
                    #prt("$txt\n");
                    $msg = "<$tag";
                    $msg .= " $attr" if (length($attr));
                    $msg .= $ch;
                    $intag = 0;
                    if ($inbody) {
                        if ($intable) {
                            if ($tag =~ /^\/table$/i) {
                                $intable = 0;
                                $endtable = 1;
                            } else {
                                if ($tag =~ /^\//) {
                                    # end tag
                                    if ($tag =~ /^\/tr$/i) {
                                        $intr = 0;
                                    } elsif ($tag =~ /^\/td$/i) {
                                        if ($tdcnt == 2) {
                                            $ptxt = $txt;
                                            $list[-1][3] = $ptxt;
                                        }
                                    }
                                } else {
                                    if ($tag =~ /^tr$/i) {
                                        $intr = 1;
                                        $tdcnt = 0;
                                        $trcnt++;
                                    } elsif ($tag =~ /^td$/i) {
                                        $tdcnt++;
                                    }
                                    if ($tdcnt == 1) {
                                        if (($tag =~ /^a$/i)&&($attr =~ /^href=/i) && 
                                            ($attr =~ /\.\.\/openlayers/) &&
                                            ($attr =~ /\/(\w+)\.html"$/)) {
                                            $name = $1;
                                            $tmp = "name=\"td$trcnt\"";
                                            $msg = "<$tag";
                                            $msg .= " $tmp $attr" if (length($attr));
                                            $msg .= $ch;
                                            push(@list, [$trcnt,$msg,$name,""]);
                                        } 
                                        prt("$trcnt: $msg\n");
                                    } elsif ($tdcnt == 2) {
                                        #$list[-1][3] = $lsttxt;
                                        #$list[-1][3] = $ptxt;
                                    }
                                }
                            }
                        } else {
                            if ($tag =~ /^\/body$/i) {
                                $inbody = 0;
                            } elsif ($tag =~ /^table$/i) {
                                $intable = 1;
                            } else {
                                #prt("$msg\n");
                            }
                        }
                    } elsif ($tag =~ /^body$/i) {
                        $inbody = 1;
                    }
                    if (length($txt)) {
                        $lsttxt = $txt;
                        $http .= "$txt\n";
                    }
                    $http .= "$msg\n";
                    $txt = '';
                    $tag = '';
                    $attr = '';
                    if ($endtable) {
                        $cnt = scalar @list;
                        $tmp = "<p><a name=\"alist\"></a>\n";
                        for ($i = 0; $i < $cnt; $i++) {
                            # push(@list, [$trcnt,$msg,$name,""]);
                            $trcnt = $list[$i][0];
                            $msg = $list[$i][1];
                            $name = $list[$i][2];
                            $txt = $list[$i][3];
                            #prt("$trcnt $msg $name $txt\n");
                            $msg = "<a href=\"#td$trcnt\">$txt</a>\n";
                            $tmp .= $msg;
                            # prt($msg);
                        }
                        $tmp .= "</p>\n";
                        $http .= $tmp;
                        $endtable = 0;
                    }
                } elsif ($hadsp) {
                    $attr .= $ch;
                } elsif ($ch =~ /\s/) {
                    $hadsp = 1;
                } else {
                    $tag .= $ch;
                }
            } else {
                if ($ch eq '<') {
                    $intag = 1;
                    $hadsp = 0;
                    $attr = '';
                    $tag = '';
                } else {
                    $txt .= $ch;
                }
            }
        }
        # end of line
        if ($intag) {
            if ($hadsp) {
                ###$attr .= ' ' if (length($attr));
                $attr .= "\n" if (length($attr));
            } else {
                $hadsp = 1;
            }
        } else {
            $txt .= "\n" if (length($txt));
        }
    }
    write2file($http,$out_file);
    prt("New HTML wirtten to $out_file\n");
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_file($in_file);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if (VERB1());
        }
        shift @av;
    }

    if ((length($in_file) ==  0) && $debug_on) {
        $in_file = $def_file;
        prt("Set DEFAULT input to [$in_file]\n");
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
