# NAME: isils.pl
# AIM: Given an input frequency, output if it is an ILS localiser or no
# from : http://en.wikipedia.org/wiki/Instrument_landing_system#Frequency_list
# Carrier frequency pairings for localiser and glide slope
# LOC and GS carrier frequencies are paired so that the navigation radio 
#  automatically tunes the GS frequency which corresponds to the selected 
#  LOC frequency. The LOC signal is in the 110 MHz range while the GS signal 
#  is in the 330 MHz range.[2]
# LOC carrier frequencies range between 108.10 MHz and 111.95 MHz (with the 100 kHz 
#  first decimal digit always odd, so 108.10, 108.15, 108.30, etc., are LOC frequencies 
#  and are not used for any other purpose). 
# See Instrument Landing System (ILS) Frequencies on even-numbered TACAN channels from 18X to 56Y.
# Variant
# Instrument Guidance System (IGS) (Localizer Type Directional Aid (LDA) in the United States) - 
#  a modified ILS to accommodate a non-straight approach; the most famous example was for 
#  the approach to runway 13 at Kai Tak Airport, Hong Kong.
# 06/12/2014 geoff mclane http://geoffair.net/mperl 
use strict;
use warnings;

my $bad = 1;
my ($freq);

sub prt($) { print shift; }

sub is_decimal($) {
    my $num = shift;
    return 1 if ($num =~ /^[-+]?[0-9]*\.?[0-9]+$/);
    return 0;
}

sub is_ils($) {
    my $num = shift;
    return 0 if ($num < 108.10);
    return 0 if ($num > 111.95);
    my $bar = int(($num + 0.001) * 10 ) - (int($num) * 10);
    return 1 if ($bar & 0x01);
    return 0;
}

if (@ARGV) {
    $freq = $ARGV[0];
    if (is_decimal($freq)) {
        $bad = 0;
        if (is_ils($freq)) {
            prt("Appears $freq is an ILS localiser\n");
        } else {
            prt("Appears $freq is *** NOT *** an ILS localiser\n");
        }
    }
}
if ($bad) {
    prt("Did not find a decimal frequency in the command!\n");
}
exit($bad);

# eof
