#!/perl -w
# NAME: isnumber.pl
# AIM: Various way to determine if a 'variable' is a number...
# 24/08/2009 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
   my @tmpsp = split(/\\/,$pgmname);
   $pgmname = $tmpsp[-1];
}
my $outfile = "temp.$pgmname.txt";
open_log($outfile);
# prt( "$0 ... Hello, World ...\n" );

sub is_number($) {
   my ($n) = shift;
   prt( "Processing $n - " );
   my $res = '';
   if ($n =~ /\D/)      { $res .= "[has nondigits]"; }
   if ($n =~ /^\d+$/)   { $res .= "[is whole number]" }
   if ($n =~ /^-?\d+$/) { $res .= "[is integer]" }
   if ($n =~ /^[+-]?\d+$/) { $res .= "[is +/- integer]" }
   if ($n =~ /^-?\d+\.?\d*$/) { $res .= "[is real number]" }
   if ($n =~ /^-?(?:\d+(?:\.\d*)?\.\d+)$/) { $res .= "[is decimal number]" }
   if ($n =~ /^([+-]?)(?:\d+(?:\.\d*)?\.\d+)([Ee]([+-]?\d+))$/) { $res .= "[is scientific notation]" }
   #if ($n =~ /^([+-]?)(?=\d\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/) { $res .= "[is C float]" }
   prt( "$res...\n" );
}

my @test_set = ( "123a", "12", "-65", "2.5", "-3.567", "=7.1E-3" );

foreach my $val (@test_set) {
   is_number($val);
}


close_log($outfile,0);
exit(0);

# eof
