#!/usr/bin/perl -w
# NAME: json2html.pl
# AIM: Read a JSON file, and output it as HTML
# Based on javascript idea at http://json.bloople.net/
# 10/03/2013 geoff mclane http://geoffair.net/mperl 
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
use JSON;
use Data::Dumper;
use Time::gmtime;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2013-03-10";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 0;
my $def_file = 'C:\FG\17\fgx-globe\apt1000\EHAM.json';
#my $def_file = 'C:\FG\17\fgx-globe\apt1000\EDLN.json';
#my $def_file = 'C:\FG\17\fgx-globe\apt1000\KDFW.json';
my $def_out = $temp_dir.$PATH_SEP."temp.$pgmname.html";

### program variables
my @warnings = ();
my $cwd = cwd();
my $html = '';
my $in_table = 0;

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_hash($$$);


my %ref_types = (
    'SCALAR' => 1,
    'ARRAY' => 1,
    'HASH' => 1,
    'CODE' => 1,
    'REF' => 1,
    'GLOB' => 1,
    'LVALUE' => 1,
    'FORMAT' => 1,
    'IO' => 1,
    'VSTRING' => 1,
    'Regexp' => 1
    );

# sort by first text
sub mycmp_ascend_t0 {
   return -1 if (${$a}[0] lt ${$b}[0]);
   return  1 if (${$a}[0] gt ${$b}[0]);
   return 0;
}

sub get_hash_keys($) {
    my $rh = shift;
    my @a = keys(%{$rh});
    return \@a;
}

my $post_process_arrays = 1;
my @post_arrays = ();

sub process_hash($$$) {
    my ($rh,$base,$lev) = @_;
    my $type = ref($rh);
    return if ($type ne 'HASH');
    my ($key,$val,$vt,$cnt,$itm,$ra);
    my $ind = '   ' x $lev;
    my @arr = ();
    $html .= $ind."<table border=\"1\" width=\"100%\">\n";
    $html .= $ind."<tr>\n";
    $html .= $ind."<th>Name</th><th>Value</th>\n";
    $html .= $ind."</tr>\n";
    foreach $key (keys %{$rh}) {
        $val = ${$rh}{$key};
        $vt = ref($val);
        if ($vt eq 'ARRAY') {
            $cnt = scalar @{$val};
            if ($post_process_arrays) {
                push(@post_arrays, [ $key, $val, $lev, $cnt ]);
            } else {
                $cnt = 0;
                $html .= $ind."<tr>\n";
                $html .= $ind."<td valign=\"top\">$key</td>\n";
                $html .= $ind."<td>\n";
                # =============================================
                $html .= $ind."<table border=\"1\" width=\"100%\">\n";
                $html .= $ind."<tr>\n";
                $html .= $ind."<th>Index</th><th>Value</th>\n";
                $html .= $ind."</tr>\n";
                foreach $itm (@{$val}) {
                    $cnt++;
                    $vt = ref($itm);
                    if ($vt eq 'HASH') {
                        $html .= $ind."<tr>\n";
                        $html .= $ind."<td valign=\"top\">$cnt</td>\n";
                        $html .= $ind."<td>\n";
                        process_hash($itm,$key,$lev+1);
                        $html .= $ind."</td>\n";
                        $html .= $ind."</tr>\n";
                    } else {
                        pgm_exit(1,"1: Item is [$vt] - FIX ME\n");
                    }
                }
                # ===============================================
                $html .= $ind."</table>\n";
                $html .= $ind."</td>\n";
                $html .= "</tr>\n";
            }
        } else {
            $html .= $ind."<tr>\n";
            $html .= $ind."<td valign=\"top\">$key</td>\n";
            $html .= $ind."<td>$val</td>\n";
            $html .= "</tr>\n";
        }
    }
    if ($post_process_arrays && ($lev == 0)) {
        @arr = sort mycmp_ascend_t0 @post_arrays;
        $cnt = scalar @arr;
        $val = '';
        foreach $rh (@arr) {
            #push(@arr, [ $key, $itm, $lev ]);
            $key = ${$rh}[0];
            $val .= ', ' if (length($val));
            $val .= $key;
        }
        prt("Post processing $cnt ARRAYS... $val\n");
        foreach $rh (@arr) {
            #push(@arr, [ $key, $itm, $lev ]);
            $key = ${$rh}[0];
            $val = ${$rh}[1];
            $lev = ${$rh}[2];
            #$cnt = ${$rh}[3];
            $html .= $ind."<tr>\n";
            $html .= $ind."<td valign=\"top\">$key</td>\n";
            $html .= $ind."<td>\n";
            # =============================================
            $cnt = scalar @{$val};
            if ($cnt == 1) {
                $itm = ${$val}[0];  # get the ONE item
                $vt = ref($itm);
                if ($vt eq '') {
                    $html .= $ind."<tr>\n";
                    $html .= $ind."<td colspan=\"2\">$itm</td>\n";
                    $html .= $ind."</tr>\n";
                    next;
                }
            }
            $html .= $ind."<table border=\"1\" width=\"100%\">\n";
            $html .= $ind."<tr>\n";
            $html .= $ind."<th>Index</th><th>Value</th>\n";
            $html .= $ind."</tr>\n";
            $cnt = 0;
            foreach $itm (@{$val}) {
                $cnt++;
                $vt = ref($itm);
                if ($vt eq 'HASH') {
                    $html .= $ind."<tr>\n";
                    $html .= $ind."<td valign=\"top\">$cnt</td>\n";
                    $html .= $ind."<td>\n";
                    process_hash($itm,$key,$lev+1);
                    $html .= $ind."</td>\n";
                    $html .= $ind."</tr>\n";
                } elsif ($vt eq '') {
                    $html .= $ind."<tr>\n";
                    $html .= $ind."<td colspan=\"2\">$itm</td>\n";
                    $html .= $ind."</tr>\n";
                } else {
                    pgm_exit(2,"2: Item is [$vt] - [$itm] FIX ME\n");
                }
            }
            # ===============================================
            $html .= $ind."</table>\n";
            $html .= $ind."</td>\n";
            $html .= "</tr>\n";
        }
    }
    $html .= "</table>\n";
}

sub process_hash_VERY_GOOD_BUT($$$) {
    my ($rh,$base,$lev) = @_;
    my $type = ref($rh);
    return if ($type ne 'HASH');
    my ($key,$val,$vt,$cnt,$itm,$ra);
    my $ind = '   ' x $lev;
    my @arr = ();
    $html .= $ind."<table border=\"1\" width=\"100%\">\n";
    $html .= $ind."<tr>\n";
    $html .= $ind."<th>Name</th><th>Value</th>\n";
    $html .= $ind."</tr>\n";
    foreach $key (keys %{$rh}) {
        $val = ${$rh}{$key};
        $vt = ref($val);
        if ($vt eq 'ARRAY') {
            $cnt = scalar @{$val};
            if ($post_process_arrays) {
                push(@arr, [ $key, $val, $lev, $cnt ]);
            } else {
                $cnt = 0;
                $html .= $ind."<tr>\n";
                $html .= $ind."<td valign=\"top\">$key</td>\n";
                $html .= $ind."<td>\n";
                # =============================================
                $html .= $ind."<table border=\"1\" width=\"100%\">\n";
                $html .= $ind."<tr>\n";
                $html .= $ind."<th>Index</th><th>Value</th>\n";
                $html .= $ind."</tr>\n";
                foreach $itm (@{$val}) {
                    $cnt++;
                    $vt = ref($itm);
                    if ($vt eq 'HASH') {
                        $html .= $ind."<tr>\n";
                        $html .= $ind."<td valign=\"top\">$cnt</td>\n";
                        $html .= $ind."<td>\n";
                        process_hash($itm,$key,$lev+1);
                        $html .= $ind."</td>\n";
                        $html .= $ind."</tr>\n";
                    } else {
                        pgm_exit(1,"1: Item is [$vt] - FIX ME\n");
                    }
                }
                # ===============================================
                $html .= $ind."</table>\n";
                $html .= $ind."</td>\n";
                $html .= "</tr>\n";
            }
        } else {
            $html .= $ind."<tr>\n";
            $html .= $ind."<td valign=\"top\">$key</td>\n";
            $html .= $ind."<td>$val</td>\n";
            $html .= "</tr>\n";
        }
    }
    if ($post_process_arrays) {
        @arr = sort mycmp_ascend_t0 @arr;
        $cnt = scalar @arr;
        ###prt("Post processing $cnt ARRAYS...\n");
        foreach $rh (@arr) {
            #push(@arr, [ $key, $itm, $lev ]);
            $key = ${$rh}[0];
            $val = ${$rh}[1];
            $lev = ${$rh}[2];
            #$cnt = ${$rh}[3];
            $html .= $ind."<tr>\n";
            $html .= $ind."<td valign=\"top\">$key</td>\n";
            $html .= $ind."<td>\n";
            # =============================================
            $cnt = scalar @{$val};
            if ($cnt == 1) {
                $itm = ${$val}[0];  # get the ONE item
                $vt = ref($itm);
                if ($vt eq '') {
                    $html .= $ind."<tr>\n";
                    $html .= $ind."<td colspan=\"2\">$itm</td>\n";
                    $html .= $ind."</tr>\n";
                    next;
                }
            }
            $html .= $ind."<table border=\"1\" width=\"100%\">\n";
            $html .= $ind."<tr>\n";
            $html .= $ind."<th>Index</th><th>Value</th>\n";
            $html .= $ind."</tr>\n";
            $cnt = 0;
            foreach $itm (@{$val}) {
                $cnt++;
                $vt = ref($itm);
                if ($vt eq 'HASH') {
                    $html .= $ind."<tr>\n";
                    $html .= $ind."<td valign=\"top\">$cnt</td>\n";
                    $html .= $ind."<td>\n";
                    process_hash($itm,$key,$lev+1);
                    $html .= $ind."</td>\n";
                    $html .= $ind."</tr>\n";
                } elsif ($vt eq '') {
                    $html .= $ind."<tr>\n";
                    $html .= $ind."<td colspan=\"2\">$itm</td>\n";
                    $html .= $ind."</tr>\n";
                } else {
                    pgm_exit(2,"2: Item is [$vt] - [$itm] FIX ME\n");
                }
            }
            # ===============================================
            $html .= $ind."</table>\n";
            $html .= $ind."</td>\n";
            $html .= "</tr>\n";
        }
    }
    $html .= "</table>\n";
}


sub process_hash_QUITE_GOOD($$$) {
    my ($rh,$base,$lev) = @_;
    my $type = ref($rh);
    return if ($type ne 'HASH');
    my ($key,$val,$vt,$cnt,$itm,$ra);
    my $ind = '   ' x $lev;

    $html .= $ind."<table border=\"1\" width=\"100%\">\n";
    $html .= $ind."<tr>\n";
    $html .= $ind."<th>Name</th><th>Value</th>\n";
    $html .= $ind."</tr>\n";
    foreach $key (keys %{$rh}) {
        $html .= $ind."<tr>\n";
        $html .= $ind."<td valign=\"top\">$key</td>\n";
        $val = ${$rh}{$key};
        $vt = ref($val);
        if ($vt eq 'ARRAY') {
            $cnt = 0;
            $html .= $ind."<td>\n";
            # =============================================
            $html .= $ind."<table border=\"1\" width=\"100%\">\n";
            $html .= $ind."<tr>\n";
            $html .= $ind."<th>Index</th><th>Value</th>\n";
            $html .= $ind."</tr>\n";
            foreach $itm (@{$val}) {
                $cnt++;
                $vt = ref($itm);
                if ($vt eq 'HASH') {
                    ##push(@arr, [ $key, $itm, $lev, $cnt ]);
                    $html .= $ind."<tr>\n";
                    $html .= $ind."<td valign=\"top\">$cnt</td>\n";
                    $html .= $ind."<td>\n";
                    process_hash($itm,$key,$lev+1);
                    $html .= $ind."</td>\n";
                    $html .= $ind."</tr>\n";
                } else {
                    pgm_exit(1,"Item is [$vt] - FIX ME\n");
                }
            }
            # ===============================================
            $html .= $ind."</table>\n";
            $html .= $ind."</td>\n";
        } else {
            $html .= $ind."<td>$val</td>\n";
        }
        $html .= "</tr>\n";
    }
    $html .= "</table>\n";
}


sub process_hash_hmmmmmm($$$) {
    my ($rh,$base,$lev) = @_;
    my $type = ref($rh);
    ###prt("This is a [$type]\n");
    my ($key,$val,$vt,$cnt,$itm,$ra);
    my @arr = ();
    my %hash = ();
    my $ind = ' ' x $lev;
    foreach $key (keys %{$rh}) {
        $val = ${$rh}{$key};
        $vt = ref($val);
        if ($vt eq 'ARRAY') {
            $cnt = scalar @{$val};
            prt($ind."$base: Key [$key} is an $vt of $cnt items...\n") if (VERB9());
            ###prt(join(",",@{$val})."\n");
            foreach $itm (@{$val}) {
                $vt = ref($itm);
                if ($vt eq 'HASH') {
                    push(@arr, [ $key, $itm, $lev, $cnt ]);
                } else {
                    prt($ind."$base: Item is [$vt]\n");
                }
            }
        } else {
            prt($ind."$base: Key [$key} = [$val]\n") if (VERB5());
            if ($in_table) {
                $html .= $ind."<td>$key</td><td>$val</td>\n";
                $hash{$key} = [] if (!defined $hash{$key});
                $ra = $hash{$key};
                push(@{$ra},$val);
            } else {
                $html .= $ind."<b>$key</b> = $val<br>\n";
            }
        }
    }
    ##my @a = keys(%hash);
    ##prt(join(",",@a)."\n");
    @arr = sort mycmp_ascend_t0 @arr;
    $val = '';
    foreach $rh (@arr) {
        #push(@arr, [ $key, $itm, $lev ]);
        $key = ${$rh}[0];
        $itm = ${$rh}[1];
        $lev = ${$rh}[2];
        $cnt = ${$rh}[3];
        if ($key ne $val) {
            $html .= $ind."</table>\n" if (length($val));
            $val = $key;
            $html .= "<p><b>$key</b></p>\n";;
            $html .= "$ind<table border=\"1\">\n";
        }
        $in_table++;
        $html .= $ind."<tr>\n";
        process_hash($itm,$key,$lev+1);
        $html .= $ind."</tr>\n";
        $in_table-- if ($in_table);
    }
    $html .= $ind."</table>\n" if (length($val));
}

sub get_header($) {
    my $title = shift;
    my $txt = <<EOF;
<!DOCTYPE html>
<html>
 <head>
  <title>$title</title>
 </head>
 <body>

EOF
    return $txt;
}

sub get_tail() {
    my $txt = <<EOF;

 </body>
</html>

EOF
    return $txt;
}


sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $line = join(" ",@lines);
    my $json = JSON->new->allow_nonref;
    my $perl_scalar = $json->decode( $line );
    process_hash($perl_scalar,'',0);
    if (VERB5()) {
        $lnn = Dumper($perl_scalar);
        prt("Dump of perl scalar...\n");
        prt("$lnn\n");
        prt("End DUMP\n");
    }
    $line = get_header($inf);
    $line .= $html;
    $line .= get_tail();
    #prt("$html\n");
    if (length($out_file)) {
        write2file($line,$out_file);
        prt("Output written to [$out_file]\n");
        system($out_file);
    } else {
        prt($line);
        prt("No out file given...\n");
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_file($in_file);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if (VERB1());
        }
        shift @av;
    }
    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if (length($in_file) ==  0) {
            $in_file = $def_file;
            prt("Set DEFAULT input to [$in_file]\n");
        }
        if (length($out_file) == 0) {
            $out_file = $def_out;
            prt("Set DEFAULT output to [$out_file]\n");
        }
        ##$load_log = 1;
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - json2html.pl
