#!/usr/bin/perl
#< lib_cmakeread.pl - 20120418 - Take a project hash, and write a set of CMakeLists.txt files
# 28/04/2012 - begin adding CMake READING
use strict;
use warnings;
my $os = $^O;
my $PATH_SEP = '/';
if ($os =~ /win/i) {
    $PATH_SEP = "\\";
}

################################################################################################
######### READING CMAKE FILES #################
# the LIST of .cmake files in C:\Program Files (x86)\CMake 2.8\share\cmake-2.8\Modules\Platform
# similar list in /usr/share/cmake-2.8/Modules/Plafrorm
my @cmake_system_names = qw( AIX-GNU-C AIX-GNU-CXX AIX-GNU-Fortran AIX-GNU AIX-VisualAge-C AIX-VisualAge-CXX
    AIX-VisualAge-Fortran AIX-XL-ASM AIX-XL-C AIX-XL-CXX AIX-XL-Fortran AIX-XL AIX
    BeOS BlueGeneL BlueGeneP-base BlueGeneP-dynamic-GNU-C BlueGeneP-dynamic-GNU-CXX BlueGeneP-dynamic-GNU-Fortran
    BlueGeneP-dynamic-XL-C BlueGeneP-dynamic-XL-CXX BlueGeneP-dynamic-XL-Fortran BlueGeneP-dynamic
    BlueGeneP-static-GNU-C BlueGeneP-static-GNU-CXX BlueGeneP-static-GNU-Fortran BlueGeneP-static-XL-C 
    BlueGeneP-static-XL-CXX BlueGeneP-static-XL-Fortran BlueGeneP-static BSDOS Catamount cl
    CYGWIN-GNU-C CYGWIN-GNU-CXX CYGWIN-GNU-Fortran CYGWIN-GNU CYGWIN-windres CYGWIN
    Darwin-Absoft-Fortran Darwin-GNU-C Darwin-GNU-CXX Darwin-GNU-Fortran Darwin-GNU Darwin-icc
    Darwin-icpc Darwin-NAG-Fortran Darwin-VisualAge-C Darwin-VisualAge-CXX Darwin-XL-C Darwin-XL-CXX Darwin
    DragonFly eCos FreeBSD gas
    Generic-ADSP-ASM Generic-ADSP-C Generic-ADSP-Common Generic-ADSP-CXX Generic-SDCC-C Generic
    GNU GNUtoMS_lib.bat.in GNUtoMS_lib
    Haiku
    HP-UX-GNU-C HP-UX-GNU-CXX HP-UX-GNU-Fortran HP-UX-GNU HP-UX-HP-ASM HP-UX-HP-C HP-UX-HP-CXX HP-UX-HP-Fortran HP-UX-HP HP-UX
    IRIX IRIX64 kFreeBSD
    Linux-Absoft-Fortran Linux-Clang-C Linux-Clang-CXX Linux-como Linux-GNU-C Linux-GNU-CXX Linux-GNU-Fortran Linux-GNU
    Linux-Intel-C Linux-Intel-CXX Linux-Intel-Fortran Linux-Intel Linux-NAG-Fortran Linux-PathScale-C Linux-PathScale-CXX
    Linux-PathScale-Fortran Linux-PathScale Linux-PGI-C Linux-PGI-CXX Linux-PGI-Fortran Linux-PGI Linux-SunPro-CXX
    Linux-TinyCC-C Linux-VisualAge-C Linux-VisualAge-CXX Linux-VisualAge-Fortran Linux-XL-C Linux-XL-CXX Linux-XL-Fortran Linux
    MP-RAS NetBSD OpenBSD OpenVMS OSF1 QNX RISCos SCO_SV SINIX SunOS-GNU-C SunOS-GNU-CXX SunOS-GNU-Fortran SunOS-GNU SunOS
    syllable Tru64 ULTRIX UnixPaths UnixWare UNIX_SV
    Windows-Borland-C Windows-Borland-CXX Windows-Borland Windows-cl Windows-cl.in Windows-df Windows-G95-Fortran
    Windows-GNU-C-ABI Windows-GNU-C Windows-GNU-CXX-ABI Windows-GNU-CXX Windows-GNU-Fortran-ABI Windows-GNU-Fortran
    Windows-GNU Windows-Intel-ASM Windows-Intel-C Windows-Intel-CXX Windows-Intel-Fortran Windows-Intel Windows-NMcl
    Windows-wcl386 Windows-windres Windows WindowsPaths Xenix );

sub set_cmake_defines($) {
    my $rh = shift;
    my $rdh = ${$rh}{'CMAKE_DEFINES'};
    ${$rdh}{'CMAKE_VERSION'} = "2.8.3";
    ${$rdh}{'UNIX'} = 0;
    ${$rdh}{'APPLE'} = 0;
    ${$rdh}{'WIN32'} = 1;
    ${$rdh}{'CYGWIN'} = 0;
    ${$rdh}{'MSYS'} = 0;
    ${$rdh}{'BORLAND'} = 0;
    ${$rdh}{'MINGW'} = 0;
    ${$rdh}{'XCODE'} = 0;
    ${$rdh}{'Q_WS_MAC'} = 0;
    ${$rdh}{'Q_WS_WIN'} = 0;
    ${$rdh}{'Q_WS_X11'} = 0;
    my ($tmp);
    my @dirarr = qw(CMAKE_INSTALL_BINDIR CMAKE_INSTALL_DATADIR CMAKE_INSTALL_DATAROOTDIR CMAKE_INSTALL_DOCDIR
        CMAKE_INSTALL_INCLUDEDIR CMAKE_INSTALL_INFODIR CMAKE_INSTALL_LIBDIR CMAKE_INSTALL_LIBEXECDIR
        CMAKE_INSTALL_LOCALEDIR CMAKE_INSTALL_LOCALSTATEDIR CMAKE_INSTALL_MANDIR CMAKE_INSTALL_OLDINCLUDEDIR
        CMAKE_INSTALL_SBINDIR CMAKE_INSTALL_SHAREDSTATEDIR CMAKE_INSTALL_SYSCONFDIR );
    foreach $tmp (@dirarr) {
        ${$rdh}{$tmp} = ".";
    }

    my @vcarr = qw( MSVC MSVC10 MSVC11 MSVC60 MSVC70 MSVC71 MSVC80 MSVC90 );
    foreach $tmp (@vcarr) {
        ${$rdh}{$tmp} = 0;
    }
    # TODO - set this/these from the environment
    ${$rdh}{'MCVC'} = 1;  
    ${$rdh}{'MCVC10'} = 1;
    ${$rdh}{'MSVC_VERSION'} = 1600; # In Visual Studio 2010, _MSC_VER is defined as 1600

    ${$rdh}{'CMAKE_CXX_COMPILER_ID'} = "Intel";
    ${$rdh}{'CMAKE_C_COMPILER_ID'} = "Intel";
    ${$rdh}{'CMAKE_SYSTEM_NAME'} = "Windows"; # or "CYGWIN" - see above list
    ${$rdh}{'CMAKE_C_PLATFORM_ID'} = "Intel";
    ${$rdh}{'CMAKE_GENERATOR'} = "Visual Studio 10"; # or "Visual Studio 10 Win64"
    ${$rdh}{'CMAKE_CMAKE_COMMAND'} = "cmake";
    #IF(${__cpack_system_name} MATCHES Windows) (=3) [C:\Program Files (x86)\CMake 2.8\share\cmake-2.8\Modules\CPack.cmake]305
    ${$rdh}{'__cpack_system_name'} = "Windows";
}

sub get_cmake_ref_hash() {
    my %hash = ();
    my $rh = \%hash;
    my $val = 0;

    ${$rh}{'per_line_dbg'} = $val;

    # if NOT coded
    ${$rh}{'warn_not_yet'}  = 0;

    my %defines = ();
    ${$rh}{'CMAKE_DEFINES'} = \%defines;

    my %macros = ();
    ${$rh}{'CMAKE_MACROS'} = \%macros;
    ${$rh}{'warn_macro_overwrites'} = 0;    # warning when MACRO overwritten
    ${$rh}{'show_macro_dbg'} = 0;

    # FindPackageMessage # FIND_PACKAGE_MESSAGE(<name> "message for user" "find result details")
    my %functions = ();
    ${$rh}{'CMAKE_FUNCTIONS'} = \%functions;
    my %functions_not_yet = ();
    ${$rh}{'CMAKE_FUNCTIONS_NOT_YET'} = \%functions_not_yet;
    ${$rh}{'show_function_lines'} = 0;
    ${$rh}{'show_function_dbg'} = 0;
    ${$rh}{'warn_functions_ny'} = 0;

    # FOREACH
    ${$rh}{'foreach_depth'} = 0;
    ${$rh}{'show_foreach_dbg'} = 0;
    ${$rh}{'show_foreach_list'} = 0;
    ${$rh}{'warn_foreach_sub_failed'} = 0;
    ${$rh}{'warn_foreach_no_args'} = 0;

    my %set_macros = ();
    ${$rh}{'CMAKE_SETMACROS'} = \%set_macros;
    ${$rh}{'show_set_dbg'} = 0;
    ${$rh}{'warn_set_overwrites'} = 0;
    ${$rh}{'show_set_no_delete'} = 0;
    ${$rh}{'warn_no_set_or_list'} = 0;

    my %list_items = ();
    ${$rh}{'CMAKE_LISTS'} = \%list_items;
    ${$rh}{'warn_list_no_code'} = 0;
    ${$rh}{'show_list_dbg'} = 0;
    ${$rh}{'show_list_dbg2'} = $val;

    my %exes_sources = ();
    ${$rh}{'CMAKE_EXES'} = \%exes_sources;
    my %libs_sources = ();
    ${$rh}{'CMAKE_LIBS'} = \%libs_sources;
    ${$rh}{'show_addlib_dbg'} = $val;

    # ADD_SUBDIRECTORY
    #                 0      1
    # push(@{$rsubs},[$item1,$ff]);
    my %subdirs = ();
    ${$rh}{'CMAKE_SUBDIRS'} = \%subdirs;
    ${$rh}{'show_addsub_dbg'} = 0;

    my %subs_done = ();
    ${$rh}{'CMAKE_SUBSDONE'} = \%subs_done;


    my @install_actions = ();
    ${$rh}{'CMAKE_INSTALLS'} = \@install_actions;
    ${$rh}{'show_install_dbg'} = $val;

    my %if_tags = ();
    ${$rh}{'CMAKE_IFTAGS'} = \%if_tags;
    my @if_actions = ();
    ${$rh}{'CMAKE_IFACTS'} = \@if_actions;
    my @if_stack = ();
    ${$rh}{'CURR_IF_STACK'} = \@if_stack;
    ${$rh}{'CURR_IN_IF'} = 0;   # NOT in any IF
    ${$rh}{'show_if_diags'} = 0;

    ${$rh}{'warnings_avoided'} = 0;

    my @options = ();
    ${$rh}{'CMAKE_OPTIONS'} = \@options;

    my @cmake_files = ();
    ${$rh}{'CMAKE_FILES'} = \@cmake_files;
    my @installed_files = ();
    ${$rh}{'CMAKE_INSTALLED_FILES'} = \@installed_files;

    my %cmake_files_loaded = ();    # files loaded and script processed
    ${$rh}{'CMAKE_FILES_LOADED'} = \%cmake_files_loaded;    # init of ref hash
    ###my %cmake_files_done = ();
    ###${$rh}{'CMAKE_FILES_DONE'} = \%cmake_files_done;

    ${$rh}{'warn_include_failed'} = 0;
    ${$rh}{'show_process_dbg'} = $val;
    ${$rh}{'show_process_dbg2'} = $val;
    ${$rh}{'show_process_dbg3'} = $val;
    ${$rh}{'show_include_dbg'} = $val;

    my %not_found_in_set_or_list = ();
    ${$rh}{'not_found_in_set_or_list'} = \%not_found_in_set_or_list;
    ${$rh}{'warn_substitution_for'} = 1;
    
    ${$rh}{'CURR_LINE_SOURCE'} = "Not specified!";
    ${$rh}{'CURR_DBG_FLAG'} = 0;
    ${$rh}{"ACT_LCNT"} = 0;

    my @ss = ();
    ${$rh}{'save_stack'} = \@ss;
    ${$rh}{'save_counter'} = 0;
    ${$rh}{'show_refstack_dbg'} = 0;

    my %new_directives_found = ();
    ${$rh}{'new_directives_found'} = \%new_directives_found;

    set_cmake_defines($rh);
    return $rh;
}

sub set_rh_debug_flags($$) {
    my ($rh,$val) = @_;
    ${$rh}{'show_macro_dbg'} = $val;
    ${$rh}{'show_function_dbg'} = $val;
    ${$rh}{'show_foreach_dbg'} = $val;
    ${$rh}{'show_list_dbg'} = $val;
    ${$rh}{'show_list_dbg2'} = $val;
    ${$rh}{'show_set_dbg'} = $val;
    ${$rh}{'show_if_diags'} = $val;
    ${$rh}{'show_refstack_dbg'} = $val;
    ${$rh}{'show_addsub_dbg'} = $val;
    ${$rh}{'show_process_dbg'} = $val;
    ${$rh}{'show_process_dbg2'} = $val;
    ${$rh}{'show_process_dbg3'} = $val;
    ${$rh}{'show_include_dbg'} = $val;
    ${$rh}{'show_install_dbg'} = $val;
    ${$rh}{'show_addlib_dbg'} = $val;
    ${$rh}{'show_refstack_dbg'} = $val;
    # maybe not ${$rh}{'per_line_dbg'} = $val;
}

sub set_foreach_debug_flags($$) {
    my ($rh,$val) = @_;
    ${$rh}{'show_foreach_dbg'} = $val;
    ${$rh}{'show_foreach_list'} = $val;
    ${$rh}{'warn_foreach_sub_failed'} = $val;
    ${$rh}{'warn_foreach_no_args'} = $val;
}

sub get_cmake_dbg_flag($) {
    my $rh = shift;
    my $dbg_flag = 0;
    if (defined ${$rh}{'CURR_DBG_FLAG'}) {
        $dbg_flag = ${$rh}{'CURR_DBG_FLAG'};
    }
    return $dbg_flag;
}

my @tmpifstk = ();
sub save_cmake_ref_hash_stack($) {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $rssa = ${$rh}{'save_stack'};
    my $scnt = ${$rh}{'save_counter'};

    ${$rssa}[$scnt][0] = ${$rh}{'PROJECT_SOURCE_DIR'};
    ${$rssa}[$scnt][1] = ${$rh}{"BASE_FILE"};
    ${$rssa}[$scnt][2] = ${$rh}{"BASE_LINES"};
    ${$rssa}[$scnt][3] = ${$rh}{'CURR_IF_STACK'};
    ${$rssa}[$scnt][4] = ${$rh}{'CURR_IN_IF'};   # zero IF counter
    ${$rssa}[$scnt][5] = ${$rh}{"ACT_LCNT"};
    ${$rssa}[$scnt][6] = ${$rh}{'ACT_I'};
    ${$rssa}[$scnt][7] = ${$rh}{'CURR_LINE_SOURCE'}; # = "File [$inf]" or 'Macro $mnm';
    # 29/04/2012 - add some more
    ${$rssa}[$scnt][8] = ${$rh}{"CLEAN_LINES"}; # my $rclines
    ${$rssa}[$scnt][9] = ${$rh}{"ACT_RA"};      # my $ra
    ${$rssa}[$scnt][10] = ${$rh}{'CURR_DBG_FLAG'};
    @tmpifstk = ();
    ${$rh}{'CURR_IF_STACK'} = \@tmpifstk;
    my $svif = ${$rssa}[$scnt][1];
    prt("\n[d8000] save_cmake_ref_hash_stack: [$svif] $scnt\n")
        if (($dbg_flag & 0x8000) && ${$rh}{'show_refstack_dbg'});
    $scnt++;
    ${$rh}{'save_counter'} = $scnt;
}

sub restore_cmake_ref_hash_stack($) {
    my $rh = shift;
    my $rssa = ${$rh}{'save_stack'};
    my $scnt = ${$rh}{'save_counter'};
    if ($scnt) {
        $scnt--;
    } else {
        pgm_exit(1,"ERROR: restore_ref_hash_stack call out of turn!\n");
    }
    ${$rh}{'PROJECT_SOURCE_DIR'} = ${$rssa}[$scnt][0];
    ${$rh}{"BASE_FILE"}          = ${$rssa}[$scnt][1];
    ${$rh}{"BASE_LINES"}         = ${$rssa}[$scnt][2];
    ${$rh}{'CURR_IF_STACK'}      = ${$rssa}[$scnt][3];
    ${$rh}{'CURR_IN_IF'}         = ${$rssa}[$scnt][4];
    ${$rh}{"ACT_LCNT"}           = ${$rssa}[$scnt][5];
    ${$rh}{'ACT_I'}              = ${$rssa}[$scnt][6];
    ${$rh}{'CURR_LINE_SOURCE'}   = ${$rssa}[$scnt][7]; # = "File [$inf]" or 'Macro $mnm';
    # 29/04/2012 - add some more
    ${$rh}{"CLEAN_LINES"}        = ${$rssa}[$scnt][8]; # my $rclines
    ${$rh}{"ACT_RA"}             = ${$rssa}[$scnt][9]; # my $ra
    ${$rh}{'CURR_DBG_FLAG'}      = ${$rssa}[$scnt][10];
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $svif = ${$rssa}[$scnt][1];
    ${$rh}{'save_counter'} = $scnt;
    prt("[d8000] restore_cmake_ref_hash_stack: [$svif] $scnt\n\n")
        if (($dbg_flag & 0x8000) && ${$rh}{'show_refstack_dbg'});
}

my $max_debug_line_len = 95;
sub set_max_debug_line_len($) { $max_debug_line_len = shift; }
sub max_debug_line($) {
    my $line = shift;
    my $len = length($line);
    if ($len > $max_debug_line_len) {
        my $hlen = int($max_debug_line_len / 2);
        my $tmp = substr($line,0,$hlen);
        $tmp .= "...";
        $tmp .= substr($line,($len-$hlen));
        $line = $tmp;
    }
    return $line;
}

sub cmake_token_split_ra($) {
    my $ra = shift;
    my @tarr = ();
    my ($txt,$len,$i,$ch,$intxt,$tag,$inquot,$pc);
    $intxt = 0;
    $inquot = 0;
    foreach $txt (@{$ra}) {
        if ($txt =~ /\$\{(\w+)\}/) {
            push(@tarr,$txt);   # if it contains a MACRO store as is
        } elsif ($txt =~ /\$ENV\{(\w+)\}/) {
            # if(NOT "$ENV{BUILD_ID}" STREQUAL "")
            push(@tarr,$txt);   # if it contains an ENV item, store as is
        } elsif ($txt =~ /^\w+$/) {
            push(@tarr,$txt);   # store the non-alphanumeric as a block
        } else {
            # mixed type
            $len = length($txt);
            ### $intxt = ($txt =~ /^\w/) ? 1 : 0;   # set start, but not really needed
            $intxt = 0;  # assume NOT text
            $inquot = 0; # and NOT quotes
            $tag = '';  # start no tag
            $ch = '';
            for ($i = 0; $i < $len; $i++) {
                $pc = $ch;
                $ch = substr($txt,$i,1);
                if ($inquot) {
                    $tag .= $ch;
                    #$inquot = 0 if ($ch eq '"');
                    $inquot = 0 if (($ch eq '"') && ($pc ne "\\"));
                } elsif ($intxt) {
                    if ($ch eq '"') {
                        $tag .= $ch;
                        $inquot = 1;
                    } elsif ($ch =~ /\W/) {
                        push(@tarr,$tag) if (length($tag));
                        $tag = $ch;
                        $intxt = 0;
                    } else {
                        $tag .= $ch;
                    }
                } else {
                    # not text - switch if it is
                    if ($ch eq '"') {
                        $tag .= $ch;
                        $inquot = 1;    # set QUOTE processing
                    } elsif ($ch =~ /\w/) {
                        push(@tarr,$tag) if (length($tag));
                        $tag = $ch;
                        $intxt = 1;     # set TEXT processing
                    } else {
                        $tag .= $ch;    # else accumulate NON text outside quotes
                    }
                }
            }
            push(@tarr,$tag) if (length($tag));
        }
    }
    return \@tarr;
}

sub cmake_space_split($) {
	my ($txt) = shift;
	my $len = length($txt);
	my ($k,$ch,$tag,$incomm,$pc);
	my @arr = ();
	$tag = '';
	$incomm = 0;
    $ch = '';
	for ($k = 0; $k < $len; $k++) {
        $pc = $ch;
		$ch = substr($txt,$k,1);
		if ($incomm) {
			$tag .= $ch;
			###$incomm = 0 if ($ch eq '"');
			$incomm = 0 if (($ch eq '"') && ($pc ne "\\")); # skip escaped, like " a\"s"
		} elsif ($ch =~ /\s/) { # any spacey char NOT in double inverted commas
            push(@arr, $tag) if (length($tag));
			$tag = '';
		} else {
			$tag .= $ch;
			$incomm = 1 if ($ch eq '"');
		}
	}
	push(@arr, $tag) if (length($tag));
	return \@arr;
}

sub cmake_token_split($) {
    my $txt = shift;
    my $ra = cmake_space_split($txt);
    return cmake_token_split_ra($ra);
}

sub cmake_token_split_ra2($) {
    my $ra = shift;
    my @tarr = ();
    my ($txt,$len,$i,$ch,$intxt,$tag,$inquot,$pc);
    $intxt = 0;
    $inquot = 0;
    foreach $txt (@{$ra}) {
        if ($txt =~ /\$\{(\w+)\}/) {
            push(@tarr,$txt);   # if it contains a MACRO store as is
        } elsif ($txt =~ /\$ENV\{(\w+)\}/) {
            # if(NOT "$ENV{BUILD_ID}" STREQUAL "")
            push(@tarr,$txt);   # if it contains an ENV item, store as is
        } elsif ($txt =~ /^\w+$/) {
            push(@tarr,$txt);   # store the non-alphanumeric as a block
        } else {
            # mixed type
            $len = length($txt);
            ### $intxt = ($txt =~ /^\w/) ? 1 : 0;   # set start, but not really needed
            $intxt = 0;  # assume NOT text
            $inquot = 0; # and NOT quotes
            $tag = '';  # start no tag
            $ch = '';
            for ($i = 0; $i < $len; $i++) {
                $pc = $ch;
                $ch = substr($txt,$i,1);
                if ($inquot) {
                    $tag .= $ch;
                    #$inquot = 0 if ($ch eq '"');
                    $inquot = 0 if (($ch eq '"') && ($pc ne "\\"));
                } elsif ($intxt) {
                    if ($ch eq '"') {
                        $tag .= $ch;
                        $inquot = 1;
                    } elsif (($ch =~ /\W/)&&($ch ne '.')&&($ch ne '-')) {
                        push(@tarr,$tag) if (length($tag));
                        $tag = $ch;
                        $intxt = 0;
                    } else {
                        $tag .= $ch;
                    }
                } else {
                    # not text - switch if it is
                    if ($ch eq '"') {
                        $tag .= $ch;
                        $inquot = 1;    # set QUOTE processing
                    } elsif ($ch =~ /\w/) {
                        push(@tarr,$tag) if (length($tag));
                        $tag = $ch;
                        $intxt = 1;     # set TEXT processing
                    } else {
                        $tag .= $ch;    # else accumulate NON text outside quotes
                    }
                }
            }
            push(@tarr,$tag) if (length($tag));
        }
    }
    return \@tarr;
}

sub cmake_drop_brackets($) {
    my $ra = shift;
    my @arr = ();
    my ($inbr,$tcnt,$tmp);
    $inbr = 0;
    $tcnt = 0;
    foreach $tmp (@{$ra}) {
        $tcnt++;
        if ($tmp eq '(') {
            if ($inbr) {
                #prt("BOToken: $tmp\n");
                push(@arr,$tmp);
            }
            $inbr++;
        } elsif ($tmp eq ')') {
            $inbr-- if ($inbr);
            if ($inbr) {
                #prt("BCToken: $tmp\n");
                push(@arr,$tmp);
            }
        } else {
            #if ($tcnt == 1) {
            #    prt("Action: $tmp\n");
            #} else {
            #    prt("Token: $tmp\n");
            #}
            push(@arr,$tmp);
        }
    }
    return \@arr;
}


sub cmake_token_split2($) {
    my $txt = shift;
    my $ra = cmake_space_split($txt);
    my $ra2 = cmake_token_split_ra2($ra);
    return cmake_drop_brackets($ra2);
}


sub cmake_fix_directory($) {
    my $rd = shift;
    if (!(${$rd} =~ /(\\|\/)$/)) {
        ${$rd} .= $PATH_SEP;
    }
}

sub cmake_macro_sub($$) {
    my ($rvar,$rh) = @_;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $csrc  = ${$rh}{'CURR_LINE_SOURCE'};
    my $lnn   = ${$rh}{"ACT_LNN"};
    ###my $act   = ${$rh}{"ACT_ACT"};
    my $line = ${$rh}{"ACT_LINE"};

    my $rsmh = ${$rh}{'CMAKE_SETMACROS'};
    my $rlih = ${$rh}{'CMAKE_LISTS'};

    my $dbg_on = 0;
    $dbg_on++ if (${$rh}{'show_set_dbg'});
    $dbg_on++ if (${$rh}{'show_list_dbg'} || ${$rh}{'show_list_dbg2'});
    $dbg_on++ if (${$rh}{'show_foreach_dbg'});

    $bfile .= $csrc if ($bfile ne $csrc);

    my ($var,$mcnt,$dcnt,@subs,$ok);
    my ($val,$sval,$rval,$tmp,$msg,$ovar);
    ###$vcnt = scalar @{$rvara};
    $mcnt = 0;
    $dcnt = 0;
    @subs = ();
    $ok = 0;
    $ovar = ${$rvar};
    ###for ($i = 0; $i < $vcnt; $i++) {
        $var = ${$rvar};
        ###$ok = (length($var) ? 1 : 0);
        if ($var =~ /\$\{(\w+)\}/) {
            $mcnt++;
            $ok = 0;    # not ok is assumed, until substitution done, at least one
            while ($var =~ /\${(\w+)\}/) {
                $val = $1;
                $sval = '';
                if (defined ${$rsmh}{$val}) {
                    # - found in 'SET' lists
                    $rval = ${$rsmh}{$val};
                    $sval = join(" ",@{$rval});
                    if ($sval && length($sval)) {
                        $sval = strip_quotes($sval);
                        $ok = 1 if (length($sval));
                    } elsif ($sval) {
                        # this is just a blank
                    } else {
                        $tmp = join(" ",@{$rval});
                        pgm_exit(1,"ERROR: How come this [$val] 'SET' item is NOT defined!\n".
                           "Values [$tmp] [$bfile}$lnn\n");
                    }
                } elsif (defined ${$rlih}{$val}) {
                    # - found in 'LIST' lists
                    $rval = ${$rsmh}{$val};
                    # $sval = ${$rval}[0];
                    $sval = join(" ",@{$rval});
                    if ($sval && length($sval)) {
                        $sval = strip_quotes($sval);
                        $ok = 2 if (length($sval));
                    } elsif ($sval) {
                        # just a blank
                    } else {
                        $tmp = join(" ",@{$rval});
                        pgm_exit(1,"ERROR: How come this [$val] 'LIST' item is NOT defined!\n".
                            "Values [$tmp] [$bfile}$lnn\n");
                    }
                } else {
                    # where else to LOOK? meantime
                    $sval = '';
                }
                if ($ok) {
                    # DO THE SUBSTITUTION
                    $msg = "Substitution in [$var] of \${$val} with [$sval]";
                    $var =~ s/\$\{$val\}/$sval/g;
                    $msg .= " gives [$var]";
                    prt("[d100] $msg\n") if (($dbg_flag & 0x100) && $dbg_on);
                    if ($var eq $ovar) {
                        $ok = 0;    # SUB FAILED???
                        last;   # FAILED - exit while
                    } else {
                        $dcnt++;    # count a SUBSTITUTION done
                        ${$rvar} = $var;   # change the value
                    }
                    prt("[d100] $msg ($ok)\n") if (($dbg_flag & 0x100) && $dbg_on);
                } else {
                    push(@subs,$val);
                    my $rnf = ${$rh}{'not_found_in_set_or_list'};
                    if (!defined ${$rnf}{$val} && !defined ${$rnf}{$var}) {
                        ${$rnf}{$val} = 1;
                        ${$rnf}{$var} = 1;
                        if (${$rh}{'warn_substitution_for'} && ${$rh}{'warn_no_set_or_list'}) {
                            prtw("WARNING: Substitution for [$val] [$var] NOT FOUND IN 'SET' or 'LIST'! [$line] [$bfile]$lnn\n");
                        } elsif (($dbg_flag & 0x400) && $dbg_on) {
                            prt("[d400] Sub for [$val] [$var] NOT FOUND 'SET' or 'LIST'! [$line] [$bfile]$lnn\n");
                        } else {
                            ${$rh}{'warnings_avoided'}++;
                        }
                    } else {
                        ${$rh}{'warnings_avoided'}++;
                    }
                    last;   # FAILED - exit while
                }
            }
        }
    ###}
    return $ok;
}

# passed a simple ARRAY of variables, do any substitution required
sub cmake_macro_substitutions($$) {
    my ($rvara,$rh) = @_;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $csrc  = ${$rh}{'CURR_LINE_SOURCE'};
    my $lnn   = ${$rh}{"ACT_LNN"};
    ###my $act   = ${$rh}{"ACT_ACT"};
    my $line = ${$rh}{"ACT_LINE"};

    my $rsmh = ${$rh}{'CMAKE_SETMACROS'};
    my $rlih = ${$rh}{'CMAKE_LISTS'};

    my $dbg_on = 0;
    $dbg_on++ if (${$rh}{'show_set_dbg'});
    $dbg_on++ if (${$rh}{'show_list_dbg'} || ${$rh}{'show_list_dbg2'});
    $dbg_on++ if (${$rh}{'show_foreach_dbg'});

    $bfile .= $csrc if ($bfile ne $csrc);

    my ($var,$vcnt,$i,$mcnt,$dcnt,@subs,$ok);
    my ($val,$sval,$rval,$tmp,$msg);
    $vcnt = scalar @{$rvara};
    $mcnt = 0;
    $dcnt = 0;
    @subs = ();
    for ($i = 0; $i < $vcnt; $i++) {
        $var = ${$rvara}[$i];
        $ok = (length($var) ? 1 : 0);
        if ($var =~ /\$\{(\w+)\}/) {
            $mcnt++;
            $ok = 0;    # not ok is assumed, until substitution done, at least one
            while ($var =~ /\${(\w+)\}/) {
                $val = $1;
                $sval = '';
                if (defined ${$rsmh}{$val}) {
                    # - found in 'SET' lists
                    $rval = ${$rsmh}{$val};
                    $sval = join(" ",@{$rval});
                    if ($sval && length($sval)) {
                        $sval = strip_quotes($sval);
                        $ok = 1 if (length($sval));
                    } elsif ($sval) {
                        # this is just a blank
                    } else {
                        $tmp = join(" ",@{$rval});
                        pgm_exit(1,"ERROR: How come this [$val] 'SET' item is NOT defined!\n".
                           "Values [$tmp] [$bfile}$lnn\n");
                    }
                } elsif (defined ${$rlih}{$val}) {
                    # - found in 'LIST' lists
                    $rval = ${$rsmh}{$val};
                    # $sval = ${$rval}[0];
                    $sval = join(" ",@{$rval});
                    if ($sval && length($sval)) {
                        $sval = strip_quotes($sval);
                        $ok = 1 if (length($sval));
                    } elsif ($sval) {
                        # just a blank
                    } else {
                        $tmp = join(" ",@{$rval});
                        pgm_exit(1,"ERROR: How come this [$val] 'LIST' item is NOT defined!\n".
                            "Values [$tmp] [$bfile}$lnn\n");
                    }
                } else {
                    # where else to LOOK? meantime
                    $sval = '';
                }
                if ($ok) {
                    # DO THE SUBSTITUTION
                    $msg = "Substitution in [$var] of \${$val} with [$sval]";
                    $var =~ s/\$\{$val\}/$sval/g;
                    $msg .= " gives [$var]";
                    prt("[d100] $msg\n") if (($dbg_flag & 0x100) && $dbg_on);
                    $dcnt++;    # count a SUBSTITUTION done
                    ${$rvara}[$i] = $var;   # change the value
                } else {
                    push(@subs,$val);
                    my $rnf = ${$rh}{'not_found_in_set_or_list'};
                    if (!defined ${$rnf}{$val} && !defined ${$rnf}{$var}) {
                        ${$rnf}{$val} = 1;
                        ${$rnf}{$var} = 1;
                        if (${$rh}{'warn_substitution_for'} && ${$rh}{'warn_no_set_or_list'}) {
                            prtw("WARNING: Substitution for [$val] [$var] NOT FOUND IN 'SET' or 'LIST'! [$line] [$bfile]$lnn\n");
                        } elsif (($dbg_flag & 0x400) && $dbg_on) {
                            prt("[d400] Sub for [$val] [$var] NOT FOUND 'SET' or 'LIST'! [$line] [$bfile]$lnn\n");
                        } else {
                            ${$rh}{'warnings_avoided'}++;
                        }
                    } else {
                        ${$rh}{'warnings_avoided'}++;
                    }
                    last;   # FAILED - exit while
                }
            }
        }
    }
    ${$rh}{"ACT_MCNT"} = $mcnt; # count of macros found
    ${$rh}{"ACT_DCNT"} = $dcnt; # count of sustitutions done
    ${$rh}{"ACT_SUBS"} = \@subs;    # list of MACRO items NOT FOUND
}

###################################################################
############# CMAKE IF PARSING #############

sub cmake_if_parsing($$$);

#   if(<constant>)
# True if the constant is 1, ON, YES, TRUE, Y, or a non-zero number. False if the constant 
# is 0, OFF, NO, FALSE, N, IGNORE, "", or ends in the suffix '-NOTFOUND'. Named boolean constants 
# are case-insensitive. If the argument is not one of these constants, it is treated as a variable:
my %cmake_boolean_constants = (
   '1'  => 1,
   'ON' => 1,
   'YES' => 1,
   'TRUE' => 1,
   'Y'  => 1,
   # or a non-zero number are all TRUE(1).
   '0'  => 0,
   'OFF' => 0,
   'NO'  => 0,
   'FALSE' => 0,
   'N'   => 0,
   'IGNORE' => 0 );
   # plus "", or ends in the suffix '-NOTFOUND' are all FALSE(0)

my %cmake_operators = (
    'AND' => 1,
    'OR'  => 2,
    'EQUAL' => 3,
    'LESS'  => 4,
    'GREATER' => 5,
    'MATCHES'  => 6,
    'STREQUAL' => 7,
    'STRLESS' => 8,
    'STRGREATER' => 9 );

#   if(<variable|string> MATCHES regex)
#True if the given string or variable's value matches the given regular expression.
#   if(<variable|string> LESS <variable|string>)
#   if(<variable|string> GREATER <variable|string>)  
#   if(<variable|string> EQUAL <variable|string>)
#True if the given string or variable's value is a valid number and the inequality or equality is true.
#   if(<variable|string> STRLESS <variable|string>)
#   if(<variable|string> STRGREATER <variable|string>)
#   if(<variable|string> STREQUAL <variable|string>)
#True if the given string or variable's value is lexicographically less (or greater, or equal) 
#than the string or variable on the right.

my %cmake_special_opers = (
    'COMMAND' => 20,    # if(COMMAND command-name) True if the given name is a command, macro or function that can be invoked.
    'POLICY'  => 21,    # if(POLICY policy-id) True if the given name is an existing policy (of the form CMP<NNNN>).
    'TARGET'  => 22,    # if(TARGET target-name) True if the given name is an existing target, built or imported.
    'EXIST'   => 23,    # if(EXISTS file-name) or if(EXISTS directory-name) True if the named file or directory exists. Behavior is well-defined only for full paths.
    'IS_NEWER_THAN' => 24, # if(file1 IS_NEWER_THAN file2) True if file1 is newer than file2 or if one of the two files doesn't exist.
    'IS_DIRECTORY' => 25, # if(IS_DIRECTORY directory-name) True if the given name is a directory. (only for full paths).
    'IS_SYMLINK' => 26, # if(IS_SYMLINK file-name) True if the given name is a symbolic link.
    'IS_ABSOLUTE' => 27, # if(IS_ABSOLUTE path) True if the given path is an absolute path.
    'VERSION_LESS' => 30, #   if(<variable|string> VERSION_LESS <variable|string>)
    'VERSION_EQUAL' => 31, #   if(<variable|string> VERSION_EQUAL <variable|string>)
    'VERSION_GREATER' => 32); #   if(<variable|string> VERSION_GREATER <variable|string>)
#Component-wise integer version number comparison (version format is major[.minor[.patch[.tweak]]]).
# IF("${CMAKE_MINIMUM_REQUIRED_VERSION}" VERSION_LESS "2.8.3.20101214") (=3) [C:\Program Files (x86)\CMake 2.8\share\cmake-2.8\Modules\Platform\CYGWIN.cmake]1
# IF("${CMake_VERSION_TWEAK}" VERSION_LESS 20000000) (=3) [C:\FGCVS\cmake\CMakeLists.txt]426
# IF("${Ruby_FIND_VERSION_SHORT_NODOT}" VERSION_LESS "19") (=3) [C:\Program Files (x86)\CMake 2.8\share\cmake-2.8\Modules\FindRuby.cmake]56
# IF("${_CURRENT_OSX_VERSION}" VERSION_LESS "10.5") (=3) [C:\Program Files (x86)\CMake 2.8\share\cmake-2.8\Modules\Platform\Darwin.cmake]190

sub cmake_version_comp($$$$) {
    my ($oper,$ver1,$ver2,$rh) = @_;
    return 1 if ($ver1 eq $ver2);
    return 0;
}

sub cmake_if_parsing($$$) {
    my ($act,$rh,$lev) = @_;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $dbg_if = ($dbg_flag & 0x2000);
    my $rdh = ${$rh}{'CMAKE_DEFINES'};
    my $rta = cmake_token_split($act);
    my $acnt = scalar @{$rta};
    my $rcmso = \%cmake_special_opers;
    my $rcmop = \%cmake_operators;
    my $rcmbool = \%cmake_boolean_constants;
    my ($tok,$val,$tmp,$str1,$str2,$cnt,$i,$msg,$tmp1,$tmp2,$tmps1,$tmps2,$i2,$rop,$fval,$rtok,$tcnt,$nta);
    $msg = ($lev ? 'sub if' : "\nPARSE IF");
    $msg .= " [ $act ] split $acnt array";
    prt("$msg\n") if ($dbg_if);
    ###my @braces = ();
    my @resarr = ();
    my $oper = '';
    my $isstr = 0;
    my @vals = ();
    my @svals = ();
    my @opersm = ();
    my $fop = 0;
    $str1 = '';
    $str2 = '';
    $cnt = 0;
    my $nact = '';
    my $hadq = 0;
    my $pcnt = 0;
    for ($i = 0; $i < $acnt; $i++) {
        $i2 = $i + 1;
        $pcnt = $cnt;
        $rtok = ${$rta}[$i];
        $tok = strip_quotes($rtok);
        $hadq = ($rtok eq $tok) ? 0 : 1;
        $msg = "$cnt:$i2:$acnt: Token [$rtok]$hadq ";
        if ($rtok eq '(') {
            $tmps1 = '';
            $i++;
            my @br = ();
            push(@br,$i);
            for (; $i < $acnt; $i++) {
                $tmp = ${$rta}[$i];
                ### $tmp = strip_quotes($tmp);
                if ($tmp eq ')') {
                    pop @br if (@br);
                    last if (!@br);
                } elsif ($tmp eq '(') {
                    push(@br,$i);
                }
                $tmps1 .= ' ' if (length($tmps1));
                $tmps1 .= $tmp;
            }
            $val = cmake_if_parsing($tmps1,$rh,($lev+1)); 
            $msg .= "br.parsed [$tmps1] = [$val]";
            if (@opersm && ($opersm[-1][0] eq 'NOT')) {
                pop @opersm;
                $val = ($val ? 0 : 1);
                $vals[$cnt] = $val;
                $msg .= "NOT = $val";
            }
            $vals[$cnt] = $val;
            if ($val =~ /^\d+$/) {
                $svals[$cnt] = ($val == 0) ? "" : "$val";
            } else {
                $svals[$cnt] = $val;
            }
            $cnt++;
        } elsif ($rtok eq 'NOT') {
            if ($i == 0) {
                $msg .= "store 1st op $rtok";
                $fop = 1;   # negates the result
            } else {
                $oper = $rtok;
                push(@opersm,[$rtok,0]);
                $msg .= "push op $rtok";
            }
        } elsif (defined ${$rcmop}{$rtok}) {
            $isstr = ${$rcmop}{$rtok};
            $oper = $rtok;
            push(@opersm,[$rtok,$isstr]);
            $msg .= "push op $rtok";
        } elsif (defined ${$rcmso}{$rtok}) {
            $isstr = ${$rcmop}{$rtok};
            $oper = $rtok;
            push(@opersm,[$rtok,$isstr]);
            $msg .= "push spl op $rtok";
        } elsif (defined ${$rcmbool}{$rtok}) {
            $val = ${$rcmbool}{$rtok};
            $msg .= "bool val [$val] ";
            if (@opersm && ($opersm[-1][0] eq 'NOT')) {
                pop @opersm;
                $val = ($val ? 0 : 1);
                $msg .= "NOT = $val";
            }
            $vals[$cnt] = $val;
            $svals[$cnt] = ($val == 0) ? "" : "$val";
            $cnt++;
        } elsif (@opersm && ($opersm[-1][0] eq 'MATCHES')) {
            $vals[$cnt] = $tok;
            ###$svals[$cnt] = ($tok == 0) ? "" : "$tok";
            $svals[$cnt] = "$tok";
            $cnt++;
        } else {
            if ($cnt && !@opersm) {
                # hmmm next token, but no OPERATION YET - back up and accumulate
                $cnt--;
                $fval = $vals[$cnt];
            } else {
                $fval = ''; # accumulate value
            }
            if ($rtok eq $tok) {
                $nta = cmake_token_split($rtok);
            } else {
                if (($tok =~ /\$\{\w+\}/) || ($tok =~ /\$ENV\{(\w+)\}/)) {
                    $nta = cmake_token_split($tok); # use de-cloaked version
                } else {
                    $nta = cmake_token_split($rtok); # use raw version
                }
            }
            $tmp2 = scalar @{$nta};
            $tcnt = 0;
            foreach $rtok (@{$nta}) {
                $tcnt++;
                $tok = strip_quotes($rtok);
                if ($tok =~ /\$\{(\w+)\}/) {
                    # a macro token
                    $tmp = $1;
                    $tmps2 = $tok;
                    if (defined ${$rdh}{$tmp}) {
                        $tmps2 = ${$rdh}{$tmp};
                        $tok =~ s/\$\{$tmp\}/$tmps2/;
                        $val = $tok;
                        $msg .= "$i2:$tcnt: def [$rtok] [$tmp] = [$tmps2] = [$val] ";
                    } elsif (cmake_macro_sub(\$tmps2,$rh)) {
                        $tok =~ s/\$\{$tmp\}/$tmps2/;
                        $val = $tok;
                        $msg .= "$i2:$tcnt: mac [$rtok] [$tmp] = [$tmps2] = [$val] ";
                    } else {
                        $msg .= "$i2:$tcnt: nods set 0";
                        $val = 0;
                    }
                } elsif ($tok =~ /\$ENV\{(\w+)\}/) {
                    # an enviroment token (or more)
                    $tmp = $1;
                    if (exists $ENV{$tmp}) {
                        $tmps2 = $ENV{$tmp};
                        $tok =~ s/\$ENV\{$tmp\}/$tmps2/;
                        $val = $tok;
                        $msg .= "$i2:$tcnt: env [$rtok] [$tmp] = [$tmps2] = [$val] ";
                    } else {
                        $tmps2 = '';
                        $tok =~ s/\$ENV\{$tmp\}/$tmps2/;
                        $val = $tok;
                        $msg .= "$i2:$tcnt: no-env [$rtok] [$tmp] so [$val] ";
                    }
                } elsif ($tok =~ /^\d+$/) {
                    $val = $tok;
                    $msg .= "$i2:$tcnt: digit $tok";
                } elsif ($tok =~ /^\w+$/) {
                    # also a macro?
                    $tmp = "\${$tok}";
                    $tmp1 = $tmp;
                    if (defined ${$rdh}{$tok}) {
                        $val = ${$rdh}{$tok};
                        $msg .= "$i2:$tcnt: Def = [$val]";
                    } elsif (cmake_macro_sub(\$tmp,$rh)) {
                        $val = $tmp;
                        $msg .= "$i2:$tcnt: Mac [$tmp1] = $val";
                    } else {
                        $val = $tok;
                        $msg .= "$i2:$tcnt: NF [$tmp1] set $val";
                    }
                } else {
                    # what is this
                    if (length($tok)) {
                        $msg .= "$i2:$tcnt: asm str ";
                        $val = $tok;
                    } else {
                        $msg .= "$i2:$tcnt: UNK set 0";
                        $val = 0;
                    }
                }
                # accumulate into final value, if anything to accumulate
                if (length($val)) {
                    if ($val =~ /^\d+$/) {
                        #if ($val > 0) {
                            $fval .= ' ' if (length($fval));
                            $fval .= $val;
                        #}
                    } else {
                        $fval .= ' ' if (length($fval));
                        $fval .= $val;
                    }
                }
            }
            $msg .= "fin [$fval] " if ($tmp2 > 1);
            $vals[$cnt] = $fval;
            if ($fval =~ /^\d+$/) {
                $svals[$cnt] = ($fval == 0) ? "" : "$fval";
            } else {
                $svals[$cnt] = $fval;
            }
            if (@opersm && ($opersm[-1][0] eq 'NOT')) {
                pop @opersm;
                $val = ($fval ? 0 : 1);
                $vals[$cnt] = $val;
                $msg .= "NOT = $val";
            }
            $cnt++;
        }
        prt("$msg\n") if ($dbg_if);
        if ($cnt == 2) {
            $i++;
            last;
        }
    }
    $msg = "Result:$lev: ";
    my $res = 0;
    if ($cnt > 1) {
        $tmp1 = $vals[0];
        $tmp2 = $vals[1];
        $tmps1 = $svals[0];
        $tmps2 = $svals[1];
        $msg .= "2 values [$tmp1] [$tmp2] ";
        if (@opersm) {
            # $oper = pop @ops;
            $rop = pop @opersm;
            $oper = ${$rop}[0];
            if (defined ${$rcmop}{$oper}) {
                # standard operators
                $isstr = ${$rcmop}{$tok};
                #   'AND' => 1, 'OR'  => 2, 'EQUAL' => 3, 'LESS'  => 4, 'GREATER' => 5, 'MATCHES'  => 6,
                # 'STREQUAL' => 7, 'STRLESS' => 8, 'STRGREATER' => 9 );
                if ($oper eq 'AND') {
                    $res = ($tmp1 && $tmp2) ? 1 : 0;
                    $msg .= "AND ";
                } elsif ($oper eq 'OR') {
                    $res = ($tmp1 || $tmp2) ? 1 : 0;
                    $msg .= "OR ";
                } elsif ($oper eq 'EQUAL') {
                    $msg .= "$oper ";
                    if (($tmp1 =~ /^\d+$/) && ($tmp2 =~ /^\d+$/)) {
                        # both are digits, so
                        $res = ($tmp1 == $tmp2) ? 1 : 0;
                        $msg .= "= ";
                    } else {
                        $res = ($tmps1 eq $tmps2) ? 1 : 0;
                        $msg .= "eq ";
                    }
                } elsif ($oper eq 'LESS') {
                    $msg .= "$oper ";
                    if (($tmp1 =~ /^\d+$/) && ($tmp2 =~ /^\d+$/)) {
                        # both are digits, so
                        $res = ($tmp1 < $tmp2) ? 1 : 0;
                        $msg .= "< ";
                    } else {
                        $res = ($tmps1 eq $tmps2) ? 1 : 0;
                        $msg .= "lt ";
                    }
                } elsif ($oper eq 'GREATER') {
                    $msg .= "$oper ";
                    if (($tmp1 =~ /^\d+$/) && ($tmp2 =~ /^\d+$/)) {
                        # both are digits, so
                        $res = ($tmp1 > $tmp2) ? 1 : 0;
                        $msg .= "> ";
                    } else {
                        $res = ($tmps1 eq $tmps2) ? 1 : 0;
                        $msg .= "gt ";
                    }
                } elsif ($oper eq 'MATCHES') {
                    $msg .= "MATCHING $tmps1 =~ /$tmps2/ ";
                    if ($tmp1 =~ /$tmp2/) {
                        $res = 1;
                        $msg .= "t2 in t1 ";
                    } else {
                        $msg .= "NO MATCH ";
                    }
                } elsif ($oper eq 'STREQUAL') {
                    $res = ($tmps1 eq $tmps2) ? 1 : 0;
                    $msg .= "STREQUAL ";
                } elsif ($oper eq 'STRLESS') {
                    $res = ($tmps1 lt $tmps2) ? 1 : 0;
                    $msg .= "STRLESS ";
                } elsif ($oper eq 'STRGREATER') {
                    $res = ($tmps1 gt $tmps2) ? 1 : 0;
                    $msg .= "STRGREATER ";
                } else {
                    prtw("IF Operation NOT CODED! [$oper]\n");
                    $msg .= "$oper NOT CODED! ";
                }
            } elsif (defined ${$rcmso}{$oper}) {
                if ($oper eq 'VERSION_EQUAL') {
                    my $rvers = cmake_space_split($tmps1);  # maybe more than one given
                    my $rvcnt = scalar @{$rvers};
                    foreach $tmp (@{$rvers}) {
                        if (cmake_version_comp($oper,$tmp,$tmps2,$rh)) {
                            # got version equal
                            $res = 1;
                            $msg .= "fnd [$tmps2] in $rvcnt ";
                            last;
                        }
                    }
                    if (!$res) {
                        $msg .= "NO fnd [$tmps2] in $rvcnt ";
                    }
                } else {
                    prtw("IF SPECIAL Operation NOT CODED! [$oper]\n");
                    $msg .= "SPL $oper NOT CODED! ";
                }
            } else {
                prtw("IF SPECIAL Operation  NOT LISTED! [$oper]\n");
                $msg .= "$oper NOT LISTED! ";
            }
        } else {
            $msg .= "NO OPS - some problem ";
            $res = 0;
        }
    } else {
        $tmp1 = $vals[0];
        $tmp2 = $svals[0];
        $msg .= "Single [$tmp1] ";
        if ($tmp1 =~ /^\d+$/) {
            $res = $tmp1;
        } else {
            if (length($tmp2)) {
                $res = 1;
            }
        }
    }
    if ($i < $acnt) {
        $tmps1 = "$res";
        $tmp1 = 0;
        for (; $i < $acnt; $i++) {
            $tmp = ${$rta}[$i];
            $tmps1 .= " $tmp";  # add the token
            if (($tmp1 == 0) && (defined ${$rcmop}{$tmp})) {
                $tmps1 .= " ("; # start brackets
                $tmp1 = 1;
            }
        }
        $tmps1 .= " )" if ($tmp1);
        $res = cmake_if_parsing($tmps1,$rh,($lev+1));
        prt("sub parsed [$tmps1] with res [$res]\n");
    }
    if ($fop) {
        $res = ($res ? 0 : 1);
        $msg .= "NOT"
    }
    prt("$msg return $res\n") if ($dbg_if);
    return $res;
}


###################################################################
############# FUNCTION HANDLERS ############

sub hand_nul { }


sub hand {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    prtw("WARNING: $tag( $act ) NOT YET CODED! [$bfile]$lnn\n");
}

sub fn_complain {
    my $rh = shift;
    my $bfile = ${$rh}{'BASE_FILE'};
    my $csrc  = ${$rh}{'CURR_LINE_SOURCE'};
    my $act = ${$rh}{"ACT_ACT"};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    prtw("WARNING: Encountered [$tag( $act )] NOT HANDLED! [$bfile]$lnn\n");
    my $lncnt = ${$rh}{"ACT_LCNT"};
    my $rclines = ${$rh}{"CLEAN_LINES"};
    my $ln = ${$rh}{"ACT_I"};
    #$lncnt = scalar @{$rclines};
    my ($rcln,$line,$bgnln,$endln,$todo);
    if ($ln > 5) {
        $ln -= 5;
        $todo = 5;
    } else {
        $todo = $ln;
        $ln = 0;
    }
    prt("Previous $todo lines...[$csrc] bgn $ln of $lncnt\n");
    #                  0     1      2       3      4
    #push(@{$rclines},[$line,$ucdir,$action,$bgnln,$endln]);
    if ($todo) {
        for (; $ln < $lncnt; $ln++) {
            $rcln = ${$rclines}[$ln];
            $line = ${$rcln}[0];
            $bgnln = ${$rcln}[3];
            $endln = ${$rcln}[4];
            prt("$bgnln:$endln: $line\n");
            $todo--;
            last if ($todo == 0);
        }
    }
    $ln = ${$rh}{"ACT_I"};
    prt("Following lines... from $ln of $lncnt.\n");
    $todo = 0;
    for (; $ln < $lncnt; $ln++) {
        $rcln = ${$rclines}[$ln];
        $line = ${$rcln}[0];
        $bgnln = ${$rcln}[3];
        $endln = ${$rcln}[4];
        prt("$bgnln:$endln: $line\n");
        $todo++;
        last if ($todo == 5);
    }
}

# $tag eq "INCLUDE"
# This maybe a FILE to be loaded like include(FlightGearComponent) = <root>\CMakeModules\FlightGearComponent.cmake file
# or it can be a 'standard' CMakeMoudles file from the installation 
# See Directory of C:\Program Files (x86)\CMake 2.8\share\cmake-2.8\Modules (and \Platform)
# =====================================================================================================================
sub fn_INCLUDE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

    my $incfil = ${$ra}[0];   # get INCLUDE base name
    my ($n,$d) = fileparse($bfile);
    my $modfil = $d.$incfil;
    $modfil .= '.cmake' if ( !($modfil =~ /\.cmake$/i) );
    my $ok = 0;
    my @tries = ();
    push(@tries,$modfil);
    if (-f $modfil) {
        $ok = 1;
    }
    if (!$ok) {
        $modfil = $d."CMakeModules".$PATH_SEP.$incfil;
        $modfil .= '.cmake' if ( !($modfil =~ /\.cmake$/i) );
        push(@tries,$modfil);
        if (-f $modfil) {
            $ok = 1;
        }
    }
    if ($incfil =~ /^\$\{CMAKE_CURRENT_LIST_DIR\}(\\|\/)/) {
        my $tmp = substr($incfil,26);;
        # $tmp = s/\$\{CMAKE_CURRENT_LIST_DIR\}(\\|\/)//;
        $modfil = $d.$tmp;
        $modfil .= '.cmake' if ( !($modfil =~ /\.cmake$/i) );
        push(@tries,$modfil);
        if (-f $modfil) {
            $ok = 1;
        }
    }
    if (!$ok) {
        $modfil = join("\n",@tries);
        prtw("WARNING: Failed to LOAD 'INCLUDE'!\nTried [$modfil]\nBase [$bfile]$lnn\n")
            if (${$rh}{'warn_include_failed'});
        return;
    }
    my $rflh = ${$rh}{'CMAKE_FILES_LOADED'};    # fn_INCLUDE: avoid already LOADED = \%cmake_files_loaded;
    if (defined ${$rflh}{$modfil} || defined ${$rflh}{$incfil}) {
        # already loaded - silently forget it
        return;
    }
    ${$rflh}{$modfil} = 1;
    ${$rflh}{$incfil} = 1;
    prt("[d100] Loading 'INCLUDE' [$modfil]...\n") if (($dbg_flag & 0x100) && ${$rh}{'show_include_dbg'});
    # SAVE CERTAIN VARIABLES FROM CHANGE
    save_cmake_ref_hash_stack($rh);
    process_in_file($modfil,$rh);
    # RESTORE CERTAIN VARIABLES BACK TO FORMER
    restore_cmake_ref_hash_stack($rh);
}

sub fn_INSTALL {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $act = ${$rh}{"ACT_ACT"};
    my $lnn = ${$rh}{"ACT_LNN"};
    # ${$rh}{"ACT_LNN"} .= ":$eln" if ($bln != $eln);
    # ${$rh}{"ACT_LINE"} = $line;
    # @arr = space_split($act);
    my $ria = ${$rh}{'CMAKE_INSTALLS'};
    push(@{$ria},[$lnn,$act]);
    prt("[d100] INSTALL( $act ) [$bfile]$lnn\n") if (($dbg_flag & 0x100) && ${$rh}{'show_install_dbg'});
}

# also see SUBDIRS, which seems to be an OLDER version, but allowed MULTIPLE directories
sub fn_ADD_SUBDIRECTORY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my ($bname,$bdir) = fileparse($bfile);
    # @arr = space_split($act);
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    my ($i,$itm,$tmp,$msg,$list);
    my $rsubs = ${$rh}{'CMAKE_SUBDIRS'};
    $list = '';
    for ($i = 0; $i < $cnt; $i++) {
        $itm = ${$ra}[$i];
        $tmp = $bdir.$itm.$PATH_SEP."CMakeLists.txt";
        if (-f $tmp) {
            ${$rsubs}{$tmp} = [$itm,$tmp];
            ###push(@{$rsubs},[$itm,$tmp]);
            $list .= "$tmp ";
        } else {
            if ($tmp =~ /\$\{(\w+)\}/) {
                $msg = "WARNING: Can NOT locate [$tmp]!\n Maybe due unexpanded macro [$1] base [$bfile]";
            } else {
                $msg = "WARNING: Can NOT locate [$tmp]! base [$bfile]";
            }
            prtw("$msg\n");
        }
        prt("[d100] ADD_SUBDIRECTORY( $list ) [$bfile]$lnn\n")
            if (($dbg_flag & 0x100) && ${$rh}{'show_addsub_dbg'});
    }
}

# 03/05/2012 - looks like 'older' version of ADD_DIRECTORY, which seems to only add ONE AT A TIME
sub fn_SUBDIRS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my ($bname,$bdir) = fileparse($bfile);
    # @arr = space_split($act);
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    my ($i,$itm,$tmp,$msg,$list);
    my $rsubs = ${$rh}{'CMAKE_SUBDIRS'};
    $list = '';
    for ($i = 0; $i < $cnt; $i++) {
        $itm = ${$ra}[$i];
        $tmp = $bdir.$itm.$PATH_SEP."CMakeLists.txt";
        if (-f $tmp) {
            ${$rsubs}{$tmp} = [$itm,$tmp];
            ###push(@{$rsubs},[$itm,$tmp]);
            $list .= "$tmp ";
        } else {
            if ($tmp =~ /\$\{(\w+)\}/) {
                $msg = "WARNING: Can NOT locate [$tmp]!\n Maybe due unexpanded macro [$1] base [$bfile]";
            } else {
                $msg = "WARNING: Can NOT locate [$tmp]! base [$bfile]";
            }
            prtw("$msg\n");
        }
        prt("[d100] SUBDIRS( $list ) [$bfile]$lnn\n")
            if (($dbg_flag & 0x100) && ${$rh}{'show_addsub_dbg'});
    }
}


my @cmake_add_library_adjectives = qw ( SHARED STATIC MODULE UNKNOWN IMPORTED GLOBAL EXCLUDE_FROM_ALL );
sub is_cmake_add_library_adjective($) {
    my $act = shift;
    my ($itm);
    foreach $itm (@cmake_add_library_adjectives) {
        return 1 if ($act eq $itm);
    }
    return 0;
}


# ($tag eq 'ADD_LIBRARY')
# add_library(<name>; <SHARED|STATIC|MODULE|UNKNOWN> IMPORTED [GLOBAL])
# add_library(<name> [STATIC | SHARED | MODULE] [EXCLUDE_FROM_ALL] source1 source2 ... sourceN)
# my %libs_sources = ();
# $hash{'CMAKE_LIBS'} = \%libs_sources;
sub fn_ADD_LIBRARY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    my $rlibs = ${$rh}{'CMAKE_LIBS'};
    my $lib = ${$ra}[0];   # get LIBRARY name
    my ($i,$src,$msg);
    if ($cnt >= 2) {
        my @lsrcs = ();
        $msg = '';
        for ($i = 1; $i < $cnt; $i++) {
            $src = ${$ra}[$i];   # get adjective or first source
            next if (is_cmake_add_library_adjective($src));
            push(@lsrcs,$src);
            $msg .= "$src ";
        }
        if (defined ${$rlibs}{$lib}) {
            prtw("WARNING: add_library entry IS DUPLICATED [$bfile]\n");
        } else {
            ${$rlibs}{$lib} = \@lsrcs;
            prt("[d100] ADD_LIBRARY [$lib] $msg \n") if (($dbg_flag & 0x100) && ${$rh}{'show_addlib_dbg'});
        }
    } else {
        prtw("WARNING: BAD add_library entry [$lib] $act [$bfile]\n");
    }
}


# $tag eq 'SET'
# should be a VARIABLE item1 [item2 [item3...]]]
#   set(&lt;variable&gt; &lt;value&gt; [[CACHE &lt;type&gt; &lt;docstring&gt; [FORCE]] | PARENT_SCOPE])
# The value for &lt;type&gt; may be one of
#   FILEPATH = File chooser dialog.  PATH = Directory chooser dialog.  STRING = Arbitrary string. BOOL  Boolean ON/OFF checkbox.
#   INTERNAL = No GUI entry (used for persistent variables).
# SET(ASM_DIALECT "-ATT")
# *.S files are supposed to be preprocessed, so they should not be passed to
# assembler but should be processed by gcc
# SET(CMAKE_ASM${ASM_DIALECT}_SOURCE_FILE_EXTENSIONS s;asm)
# SET(CMAKE_ASM${ASM_DIALECT}_COMPILE_OBJECT "<CMAKE_ASM${ASM_DIALECT}_COMPILER> <FLAGS> -o <OBJECT> <SOURCE>")
# NOTE: If <value> is not specified then the variable is removed instead of set. See also: the unset() command.
sub fn_SET {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $csrc  = ${$rh}{'CURR_LINE_SOURCE'};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    my $lnn = ${$rh}{"ACT_LNN"};

    $bfile .= ":$csrc" if ($bfile ne $csrc);
    my $setdbg = 0;
    $setdbg = ${$rh}{'show_set_dbg'} if (defined ${$rh}{'show_set_dbg'});
    my $rsmh = ${$rh}{'CMAKE_SETMACROS'};
    my $rta = cmake_token_split($act);  # but not YET used here
    my ($i,$msg,$tmp,$nval,$bal,$scnt,$val,$rval,$val2,$sact,$ok);
    my @list = ();
    my %dlist = ();
    my $nul = '""';
    $sact = ''; 
    $bal = '';
    my $var = ${$ra}[0]; # get the variable name
    # collect RAW actions AFTER name
    $scnt = 0;  # count parameters AFTER name
    for ($i = 1; $i < $cnt; $i++) {
        $tmp = ${$ra}[$i];
        if (($tmp eq 'CACHE') || ($tmp eq 'PARENT_SCOPE')) {
            $bal = $tmp;
            $i++;
            for (; $i < $cnt; $i++) {
                $tmp = ${$ra}[$i];
                $bal .= " $tmp";
            }
            last;
        }
        $sact .= ' ' if (length($sact));
        $sact .= $tmp;
        $scnt++;
    }
    prt("[d100] SET( $var [$sact] ) $scnt [$bal] [$bfile]$lnn\n") if (($dbg_flag & 0x100) && ${$rh}{'show_set_dbg'});

    # deal with possible NAME substitutions
    $ok = (length($var) ? 1 : 0);
    if ( $ok && ($var =~ /\$\{(\w+)\}/)) {
        $ok = 0;
        $msg = "[sbdg] For set name [$var], act [$sact], ";
        while ($var =~ /\$\{(\w+)\}/) {
            $tmp = $1;
            $msg .= " sustitution of \${$tmp} ";
            if (defined ${$rsmh}{$tmp}) {
                $rval = ${$rsmh}{$tmp};
                #$nval = join(";",@{$rval});
                $nval = strip_quotes(${$rval}[0]);
                $msg .= "with [$nval]";
                $var =~ s/\$\{$tmp\}/$nval/g;
                $ok = 1;
            } else {
                $nval = '';
                $msg .= " WARNING not found ";
                last;
            }
            $msg .= "gives [$var] ";
        }
        prt("$msg $lnn\n") if ($setdbg);
    }

    if (!$ok) {
        prt("[d100] UGH - SET name length or sustitution FAILED! Nothing SET\n")
             if (($dbg_flag & 0x100) && ${$rh}{'show_set_dbg'});
        return;
    }

    if (length($sact) == 0) {
        # doing a deletion only
        $msg = "[d100] DELETED SET($var";
        if (defined ${$rsmh}{$var}) {
            delete ${$rsmh}{$var};
            $msg .= ") [$bal]";
        } else {
            $msg .= ") does NOT exist to be DELETED! [$bal]";
            return if (!${$rh}{'show_set_no_delete'});
        }
        prt("$msg\n") if (($dbg_flag & 0x100) && ${$rh}{'show_set_dbg'});
        return;
    }

    # ok we are going to do something
    $bal = '';
    $scnt = 0;  # restart count
    for ($i = 1; $i < $cnt; $i++) {
        $tmp = ${$ra}[$i];
        if (($tmp eq 'CACHE') || ($tmp eq 'PARENT_SCOPE')) {
            $bal = $tmp;
            $i++;
            for (; $i < $cnt; $i++) {
                $tmp = ${$ra}[$i];
                $bal .= " $tmp";
            }
            last;
        }
        #$tmp = strip_quotes($tmp);
        $ok = 1;
        if ($tmp =~ /\$\{(\w+)\}/) {
            $ok = 0;
            $msg = "[sdbg] For value [$tmp], ";
            while ($tmp =~ /\$\{(\w+)\}/) {
                $val = $1;
                $msg .= "substitution of \${$val} ";
                if (defined ${$rsmh}{$val}) {
                    $rval = ${$rsmh}{$val};
                    $val2 = strip_quotes(${$rval}[0]);
                    $msg .= "with [$val2] ";
                    $tmp =~ s/\$\{$val\}/$val2/g;
                    $msg .= "gives [$tmp]";
                    $ok = 1;
                } else {
                    $val2 = '';
                    $msg .= "WARNING not found ";
                    last;
                }
            }
            prt("$msg\n") if ($setdbg);
        }

        if ($ok && !defined $dlist{$tmp}) {
            $dlist{$tmp} = 1;
            push(@list,$tmp);
        }
    }
    $scnt = scalar @list;
    if ($scnt == 0) {
        prt("[d100] UGH - SET sustitution FAILED! Nothing to SET\n")
             if (($dbg_flag & 0x100) && ${$rh}{'show_set_dbg'});
        return;
    }

    # $set_macros{$val} = \@list;
    my ($rsa);
    if ($scnt && defined ${$rsmh}{$var}) {
        if (${$rh}{'warn_set_overwrites'}) {
            if ((${$rh}{'CURR_IN_IF'} == 0) && !($var =~ /^CMAKE_/i)) {
                $rsa = ${$rsmh}{$var};
                if (not_same_ref_array($rsa,\@list)) {
                    $msg = "WARNING: SET variable [$var] being overwritten with NEW list! No IF \nIn file [$bfile]($lnn)]\n";
                    $msg .= "prev [".join(";",sort @{$rsa})."]\n";
                    $msg .= "curr [".join(";",sort @list)."]\n";
                    prtw($msg);
                }
            } else {
               ${$rh}{'warnings_avoided'}++;
            }
        } else {
            ${$rh}{'warnings_avoided'}++;
        }
    }
    # show the RESULTS
    $msg = "[d200] SET($var";
    ${$rsmh}{$var} = \@list;
    $rsa = ${$rsmh}{$var};
    $msg .= " ".join(" ",@{$rsa}).") $scnt [$bal]";
    prt("$msg [$bfile]$lnn\n") if (($dbg_flag & 0x200) && ${$rh}{'show_set_dbg'});
}


# $tag eq 'LIST'
# # $hash{'CMAKE_LISTS'} = \%list_items;
# list(APPEND SOURCES "UIUCModel/${component}")
#    my %list_items = ();
#    ${$rh}{'CMAKE_LISTS'} = \%list_items;
#    my %list_defines = ();
#    ${$rh}{'CMAKE_LISTS'} = \%list_defines;
#  LIST( LENGTH length_before  )
# LIST( FIND HDF5_VALID_COMPONENTS C _component_location )
#   list(FIND <list> <value> <output variable>)  
# FIND will return the index of the element specified in the list or -1 if it wasn't found.
sub fn_LIST {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $csrc  = ${$rh}{'CURR_LINE_SOURCE'};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    my $lnn = ${$rh}{"ACT_LNN"};
    my $line = ${$rh}{"ACT_LINE"};

    $bfile .= ":$csrc" if ($bfile ne $csrc);
    my $rli = ${$rh}{'CMAKE_LISTS'};
    my $rta = cmake_token_split($act);  # but not yet USED here
    my $oper = ${$ra}[0]; # get OPERATION
    my $list = ${$ra}[1]; # get LIST name
    if (($cnt >= 2) && length($oper) && length($list)) {
        if ((length($list) == 0)||($list =~ /^\s+$/)) {
            prtw("WARNING: LIST( $act ) no valid name! [$bfile]$lnn\n") if (${$rh}{'warn_list_no_code'});
            return;
        }
        my @larr = ();  # start ARRAY of parameters
        my $lcnt = 0;
        my ($i,$rla,$tmp,$msg);
        my $itms = '';
        my $icnt = 0;
        for ($i = 2; $i < $cnt; $i++) {
            $tmp = ${$ra}[$i];
            if (length($tmp)) {
                $lcnt++;
                $itms .= ' ' if (length($itms));
                $itms .= $tmp;
                push(@larr,$tmp);
                $icnt++;
            }
        }
        prt("[d100] LIST( $oper $list [$itms]$icnt ) [$bfile]$lnn\n")  if (($dbg_flag & 0x100) && ${$rh}{'show_list_dbg'});
        if ($oper eq 'APPEND') {
            if ($icnt) {
                $msg = "[d200] LIST APPEND ";
                cmake_macro_substitutions(\@larr,$rh);
                if ( defined ${$rli}{$list} ) {
                    $rla = ${$rli}{$list};
                    $tmp = join(" ",@{$rla});
                    push(@{$rla},@larr);
                } else {
                    ${$rli}{$list} = \@larr;
                    $rla = ${$rli}{$list};
                    $tmp = join(" ",@{$rla});
                    $msg .= "*NEW* ";
                }
                prt("$msg [$tmp]\n") if (($dbg_flag & 0x200) && ${$rh}{'show_list_dbg2'});
            } else {
                prtw("WARNING: LIST( $act ) no values to APPEND! [$bfile]$lnn\n") if (${$rh}{'warn_list_no_code'});
            }
        } elsif ($oper eq 'LENGTH') {
            if ($lcnt == 1) {
                my @ca = ();
                $msg = "[d200] LIST LENGTH to $itms ";
                if (defined ${$rli}{$list}) {
                    $rla = ${$rli}{$list};
                    $tmp = join(" ",@{$rla});
                    $icnt = scalar @{$rla};
                    push(@ca,$icnt);
                    $msg .= "= $icnt [$tmp]";
                } else {
                    push(@ca,0);
                    $msg .= "= 0 since [$list] does NOT exist!";
                }
                ${$rli}{$itms} = \@ca;  # set the COUNT
                prt("$msg\n") if (($dbg_flag & 0x200) && ${$rh}{'show_list_dbg2'});
                # prt("$msg\n"); # if (($dbg_flag & 0x200) && ${$rh}{'show_list_dbg2'});
            } else {
                prtw("WARNING: LIST( $oper $list $itms ) $lcnt NOT CODED! [$bfile]$lnn\n") if (${$rh}{'warn_list_no_code'});
            }
        } elsif ($oper eq 'INSERT') {
            prtw("WARNING: LIST( $oper $list $itms ) $lcnt NOT CODED! using APPEND [$bfile]$lnn\n") if (${$rh}{'warn_list_no_code'});
            # ***TBD*** TODO
            if ($icnt) {
                $msg = "[d200] LIST INSERT ";
                cmake_macro_substitutions(\@larr,$rh);
                if (defined ${$rli}{$list}) {
                    $rla = ${$rli}{$list};
                    push(@{$rla},@larr);
                    $tmp = join(" ",@{$rla});
                    $msg .= "[$tmp]";
                } else {
                    ${$rli}{$list} = \@larr;
                    $rla = ${$rli}{$list};
                    $tmp = join(" ",@{$rla});
                    $msg .= "*NEW* [$tmp]";
                }
                prt("$msg\n") if (($dbg_flag & 0x200) && ${$rh}{'show_list_dbg2'});
            } else {
                prtw("WARNING: LIST( $act ) no values to INSERT! [$bfile]$lnn\n") if (${$rh}{'warn_list_no_code'});
            }
        } elsif ($oper eq 'FIND') {
            #   list(FIND <list> <value> <output variable>)  
            # FIND will return the index of the element specified in the list or -1 if it wasn't found.
            if ($lcnt == 2) {
                my $find = $larr[0];
                my $out  = $larr[1];
                $msg = "[d200] LIST FIND [$find] in [$list] ";
                my $index = 0;
                my $ok = (length($find) && length($out)) ? 1 : 0;
                if ($ok && defined ${$rli}{$list}) {
                    $rla = ${$rli}{$list};
                    foreach $tmp (@{$rla}) {
                        if ($tmp eq $find) {
                            $ok = 1;
                            last;
                        }
                        $index++;
                    }
                    if ($ok) {
                        $msg .= "found at index $index";
                    } else {
                        $msg .= "NOT FOUND!";
                        $index = -1;
                    }
                } elsif ($ok) {
                    $index = -1;
                    $msg .= "list does NOT exist!";
                } else {
                    $index = -1;
                    $msg .= "find or out value error!";
                }
                my @a = ();
                push(@a,$index);
                ${$rli}{$out} = \@a;
                prt("$msg\n") if (($dbg_flag & 0x200) && ${$rh}{'show_list_dbg2'});
            } else {
                # ***TBD*** TODO
                prtw("WARNING: LIST( $oper $list $itms ) $lcnt NOT CODED! [$bfile]$lnn\n") if (${$rh}{'warn_list_no_code'});
            }
        } elsif ($oper eq 'GET') {
            # list(GET <list> <element index> [<element index> ...]       <output variable>)
            # list(GET _cl_version_list 0 _major)
            my $newvar = $larr[-1]; # last item is OUTPUT variable
            if (($lcnt >= 2) && length($newvar)) {
                $msg = "[d200] LIST GET ";
                my @ngarr = ();
                if (defined ${$rli}{$list}) {
                    $rla = ${$rli}{$list};
                    my $acnt = scalar @{$rla};  # get LENGTH
                    if ($acnt) {
                        $msg .= "with $acnt elements ";
                        $lcnt--;    # back off last item
                        for ($i = 0; $i < $lcnt; $i++) {
                            $tmp = $larr[$i];   # get desired index
                            if ($tmp =~ /^\d+$/) {
                                if ($tmp < $acnt) {
                                    $itms = ${$rla}[$tmp]; # extract desired
                                    push(@ngarr,$itms);
                                    $msg .= "+$itms ";
                                } else {
                                    $msg .= "but index [$tmp] out of range!";
                                }
                            } else {
                                $msg .= "but index [$tmp] not a number!";
                            }
                        }
                        ${$rli}{$newvar} = \@ngarr;
                        $msg .= "set [$newvar] ";
                    } else {
                        $msg .= "but [$list] has no entries!";
                    }
                } else {
                    $msg .= "but [$list] does NOT exist!";
                }
                prt("$msg\n") if (($dbg_flag & 0x200) && ${$rh}{'show_list_dbg2'});
            } else {
                prtw("WARNING: LIST( $oper $list $itms ) $lcnt NOT CODED! [$bfile]$lnn\n") if (${$rh}{'warn_list_no_code'});
            }
        } elsif ($oper eq 'REMOVE_ITEM') {
            $msg = "[d200] LIST REMOVED_ITEM ";
            if (defined ${$rli}{$list}) {
                my @narr = ();
                $rla = ${$rli}{$list};
                foreach $tmp (@{$rla}) {
                    next if (is_in_array($tmp,@larr));
                    push(@narr,$tmp);
                }
                $tmp = "[".join(" ",@{$rla})."]";
                ${$rli}{$list} = \@narr;
                $rla = ${$rli}{$list};
                $tmp .= "to[".join(" ",@{$rla})."]";
                $msg .= "$tmp";
            } else {
                #   ${$rli}{$list} = [];
                $msg .= "but [$list] does NOT exist!";
            }
            prt("$msg\n") if (($dbg_flag & 0x200) && ${$rh}{'show_list_dbg2'});
        } elsif ($oper eq 'REMOVE_DUPLICATES') {
            $msg = "[d200] LIST REMOVED_DUPLICATES ";
            if (defined ${$rli}{$list}) {
                my %dupes = ();
                $rla = ${$rli}{$list};
                foreach $tmp (@{$rla}) {
                    $dupes{$tmp} = 1;
                }
                $tmp = "[".join(" ",@{$rla})."]";
                my @ndarr = keys(%dupes);
                ${$rli}{$list} = \@ndarr;
                #### @{$rla} = @arr;
                $rla = ${$rli}{$list};
                $tmp .= "to[".join(" ",@{$rla})."]";
                $msg .= "$tmp";
            } else {
                # ${$rli}{$list} = [];
                $msg .= "but [$list] does NOT exist!";
            }
            prt("4msg\n") if (($dbg_flag & 0x200) && ${$rh}{'show_list_dbg2'});
        } elsif ($oper eq 'REVERSE') {
            $msg = "[d200] LIST REVERSE ";
            if (defined ${$rli}{$list}) {
                $rla = ${$rli}{$list};
                $tmp = "[".join(" ",@{$rla})."]";
                my @nrarr = ();
                $cnt = scalar @{$rla};
                while ($cnt > 0) {
                    $cnt--;
                    push(@nrarr,${$rla}[$cnt]);
                }
                ### @{$rla} = @narr;
                ${$rli}{$list} = \@nrarr;
                $rla = ${$rli}{$list};
                $tmp .= "to[".join(" ",@{$rla})."]";
                $msg .= "$tmp";
            } else {
                # ${$rli}{$list} = [];
                $msg .= "but [$list] does NOT exist!";
            }
            prt("$msg\n") if (($dbg_flag & 0x200) && ${$rh}{'show_list_dbg2'});
        } elsif ($oper eq 'SORT') {
            $msg = "[d200] LIST SORT ";
            if (defined ${$rli}{$list}) {
                $rla = ${$rli}{$list};
                $tmp = "[".join(" ",@{$rla})."]";
                @{$rla} = sort @{$rla};
                $rla = ${$rli}{$list};
                $tmp .= "to[".join(" ",@{$rla})."]";
                $msg .= "$tmp";
            } else {
                $msg .= "but [$list] does NOT exist!";
                #  ${$rli}{$list} = [];
            }
            prt("$msg\n") if (($dbg_flag & 0x200) && ${$rh}{'show_list_dbg2'});
        } elsif ($oper eq 'REMOVE_AT') {
            # ***TBD*** TODO
            prtw("WARNING: LIST( $oper $list $itms ) $lcnt NOT CODED! [$bfile]$lnn\n") if (${$rh}{'warn_list_no_code'});
        } else {
            if (!defined ${$rh}{'missing_list_action'}) {
                my %h = ();
                ${$rh}{'missing_list_action'} = \%h;
            }
            my $rmlh = ${$rh}{'missing_list_action'};
            if (!defined ${$rmlh}{$oper}) {
                ${$rmlh}{$oper} = 1;
                prtw("WARNING: LIST( $oper $list $itms ) $lcnt operation NOT handled yet TODO! [$bfile]$lnn\n");
            } else {
                ${$rh}{'warnings_avoided'}++;
            }
        }
    } else {
        my $rclines = ${$rh}{"CLEAN_LINES"};
        my $ln = ${$rh}{"ACT_I"};
        my $rcln = ${$rclines}[$ln];
        $line = ${$rcln}[0];
        my $bgnln = ${$rcln}[3];
        my $endln = ${$rcln}[4];
        # prt("$bgnln:$endln: $line\n");
        prtw("WARNING: LIST op [$oper] has no elements! [$act] [$line]$ln [$bfile]$lnn\n");
    }
}

# $tag eq 'PROJECT'
# CMAKE_PROJECT_NAME
sub fn_PROJECT {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    my $lnn = ${$rh}{"ACT_LNN"};
    my $rsmh = ${$rh}{'CMAKE_SETMACROS'};
    my $val = strip_quotes(${$ra}[0]);
    ${$rh}{'PROJ_NAME'} = $val;
    ${$rsmh}{'CMAKE_PROJECT_NAME'} = [$val];
    prt("[d100] PROJECT( \"$val\" ) [$bfile]$lnn\n")  if ($dbg_flag & 0x100);
}

# $tag eq 'IF'
sub fn_IF {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    my $lnn = ${$rh}{"ACT_LNN"};

    my $ria = ${$rh}{'CMAKE_IFACTS'};
    push(@{$ria},[$act,$bfile,$lnn]);

    ${$rh}{'CURR_IN_IF'}++;   # bump IF counter

    my $ras = cmake_if_parsing($act,$rh,0);
    my $rifstk = ${$rh}{'CURR_IF_STACK'};
    push(@{$rifstk},[$act,$lnn]);

    $cnt = ${$rh}{'CURR_IN_IF'};   # get bumped IF counter
    prt("[d100] IF( $act ) $cnt [$bfile]$lnn\n") if (($dbg_flag & 0x100) && ${$rh}{'show_if_diags'});
}

sub fn_ELSEIF {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    my $lnn = ${$rh}{"ACT_LNN"};
    my $rifstk = ${$rh}{'CURR_IF_STACK'};

    my $ria = ${$rh}{'CMAKE_IFACTS'};
    push(@{$ria},[$act,$bfile,$lnn]);

    ### ${$rh}{'CURR_IN_IF'}++;   # bump IF counter
    my $ras = cmake_if_parsing($act,$rh,0);
    ### push(@{$rifstk},[$act,$lnn]);
    $cnt = ${$rh}{'CURR_IN_IF'};   # get bumped IF counter
    prt("[d100] ELSEIF( $act ) $cnt [$bfile]$lnn\n")  if (($dbg_flag & 0x100) && ${$rh}{'show_if_diags'});

}
sub fn_ELSE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    my $lnn = ${$rh}{"ACT_LNN"};
    $cnt = ${$rh}{'CURR_IN_IF'};   # get bumped IF counter
    prt("[d100] ELSE( $act ) $cnt [$bfile]$lnn\n")  if (($dbg_flag & 0x100) && ${$rh}{'show_if_diags'});
}

sub fn_ENDIF {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    my $lnn = ${$rh}{"ACT_LNN"};
    my $rifstk = ${$rh}{'CURR_IF_STACK'};
    $cnt = ${$rh}{'CURR_IN_IF'};   # get IF counter
    if ($cnt) {
        $cnt--; # decrement IF counter
        ${$rh}{'CURR_IN_IF'} = $cnt;  
        pop @{$rifstk};
    }
    prt("[d100] ENDIF( $act ) $cnt [$bfile]$lnn\n")  if (($dbg_flag & 0x100) && ${$rh}{'show_if_diags'});
}

# ($tag eq 'MACRO')
# must collect until ENDMACRO
sub fn_MACRO {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    my $lnn = ${$rh}{"ACT_LNN"};

    my $mac = ${$ra}[0];   # get MACRO name
    my $ln = ${$rh}{"ACT_I"};
    my $lncnt = ${$rh}{"ACT_LCNT"};
    my $rclines = ${$rh}{"CLEAN_LINES"};
    my $macro = '';
    my $args = '';
    my $argc = 0;
    my ($i);
    for ($i = 1; $i < $cnt; $i++) {
        $args .= ' ' if (length($args));
        $args .= ${$ra}[$i];
        $argc++;
    }
    my $bgn = $ln;
    my $line = '';
    $ln++;  # bump to next line
    my @arr = ();
    push(@arr,$ln);
    my $acnt = scalar @arr;
    my $mdep = 1;
    for (;$ln < $lncnt ; $ln++) {
         $line = ${$rclines}[$ln][0];
         if ($line =~ /^\s*ENDMACRO\s*\(/i) {
             pop @arr if ($acnt);
             $acnt = scalar @arr;
             last if ($acnt == 0);
         } elsif ($line =~ /^\s*MACRO\s*\(/) {
             push(@arr,$ln);
             $mdep++;
             $acnt = scalar @arr;
         }
         $macro .= "$line\n";
    }
    my $end = $ln + 1;
    $macro =~ s/\s$//g;
    my $rma = ${$rh}{'CMAKE_MACROS'};
    if (defined ${$rma}{$mac}) {
        if ( ${$rh}{'CURR_IN_IF'} == 0 ) {   # NOT in any IF
            if (${$rh}{'warn_macro_overwrites'}) {
                 prtw("WARNING: Macro [$mac] ALREADY EXIST! Being overwritten!\n");
            } else {
                 ${$rh}{'warnings_avoided'}++;
            }
        }
    }
    #                0     1
    ${$rma}{$mac} = [$args,$macro];
    $i = $end - $bgn;
    prt("[d100] MACRO( $mac $args ) argc=$argc lns=$i [$bgn:$end] dep=$mdep [$bfile]$lnn\n")
        if (($dbg_flag & 0x100) && ${$rh}{'show_macro_dbg'});
    prt("[d200] MACRO $mac(...)\n$macro\nENDMACRO] [$bgn:$end] $i of $lncnt\n")
        if (($dbg_flag & 0x200) && ${$rh}{'show_macro_dbg'});
    ${$rh}{"ACT_I"} = $ln;  # eat these LINES
}


# $tag eq 'FUNCTION'
# must eat until ENDFUNCTION
# FindPackageMessage # FIND_PACKAGE_MESSAGE(<name> "message for user" "find result details")
# my %functions = ();
# ${$rh}{'CMAKE_FUNCTIONS'} = \%functions;
sub fn_FUNCTION {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    my $lnn = ${$rh}{"ACT_LNN"};

    my $mac = ${$ra}[0];   # get FUNCION name
    my $ln = ${$rh}{"ACT_I"};
    my $lncnt = ${$rh}{"ACT_LCNT"};
    my $rclines = ${$rh}{"CLEAN_LINES"};
    my $macro = '';
    my $args = '';
    my $argc = 0;
    my ($i);
    for ($i = 1; $i < $cnt; $i++) {
        $args .= ' ' if (length($args));
        $args .= ${$ra}[$i];
        $argc++;
    }
    my $bgn = $ln;
    my $line = '';
    $ln++;  # bump to next line
    my @arr = ();
    push(@arr,$ln);
    my $acnt = scalar @arr;
    my $mdep = 1;
    for (;$ln < $lncnt ; $ln++) {
         $line = ${$rclines}[$ln][0];
         if ($line =~ /^\s*ENDFUNCTION\s*\(/i) {
             pop @arr if ($acnt);
             $acnt = scalar @arr;
             last if ($acnt == 0);
         } elsif ($line =~ /^\s*FUNCTION\s*\(/) {
             push(@arr,$ln);
             $mdep++;
             $acnt = scalar @arr;
         }
         $macro .= "$line\n";
    }
    my $end = $ln + 1;
    $macro =~ s/\s$//g;
    my $rma = ${$rh}{'CMAKE_FUNCTIONS'};
    if (defined ${$rma}{$mac}) {
        if ( ${$rh}{'CURR_IN_IF'} == 0 ) {   # NOT in any IF
            if (${$rh}{'warn_function_overwrites'}) {
                 prtw("WARNING: Fuction [$mac] ALREADY EXIST! Being overwritten!\n");
            } else {
                 ${$rh}{'warnings_avoided'}++;
            }
        }
    }
    #                0     1
    ${$rma}{$mac} = [$args,$macro];
    $i = $end - $bgn;
    prt("[d100] FUNCTION( $mac $args ) argc=$argc lns=$i [$bgn:$end] dep=$mdep [$bfile]$lnn\n")
        if (($dbg_flag & 0x100) && ${$rh}{'show_function_dbg'});
    my $msg = "[d200] FUNCTION name $mac(...)\n$macro\nENDFUNCTION] [$bgn:$end] $i of $lncnt";
    $mdep = ${$rh}{'show_function_lines'};
    prt("$msg ($mdep)\n") if ( ($dbg_flag & 0x200) && $mdep);
    ${$rh}{"ACT_I"} = $ln;  # eat these LINES
}

# ($tag eq 'FOREACH')
# must eat until ENDFOREACH
# BUT WATCH OUT FOR NESTED FOREACH LIKE
# foreach (lang C CXX Fortran)
#  foreach (id GNU Intel PGI XL)
#    if (NOT CMAKE_${lang}_COMPILER_ID OR "${CMAKE_${lang}_COMPILER_ID}" STREQUAL "${id}")
#      list(APPEND _MPI_${lang}_COMPILER_NAMES ${_MPI_${id}_${lang}_COMPILER_NAMES})
#    endif()
#    unset(_MPI_${id}_${lang}_COMPILER_NAMES)    # clean up the namespace here
#  endforeach()
# endforeach()
sub fn_FOREACH {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    my $lnn = ${$rh}{"ACT_LNN"};    # this is the REAL FILE line

    my $item1 = ${$ra}[0];   # get FOREACH variable name
    my $rclines = ${$rh}{"CLEAN_LINES"};
    my $lncnt = ${$rh}{"ACT_LCNT"};
    my $ln = ${$rh}{"ACT_I"};
    my $macro = '';
    my ($i,$tmp,$val,$ok,$msg,$rval,$sval);
    my $rsmh = ${$rh}{'CMAKE_SETMACROS'};
    my $rli = ${$rh}{'CMAKE_LISTS'};
    ${$rh}{'foreach_depth'}++;  # BUMP FOREACH DEPTH
    my $fedep = ${$rh}{'foreach_depth'};
    my @subs = ();
    my $arglist = '';
    my $argc = 0;
    for ($i = 1; $i < $cnt; $i++) {
        $tmp = ${$ra}[$i];    # extract the ARGUMENT item
        $arglist .= ' ' if (length($arglist));
        $arglist .= $tmp;
        $argc++;
    }
    my $bgn = $ln;  # store BEGINNING line in CLEAN_LINES array = ACT_I
    my ($line,$tucdir,$taction,$tbgnln,$tendln);
    my @arr = ();
    $ln++;
    my ($rcln);
    # get the CLEAN LINES into a NEW array
    my @clarr = ();
    push(@arr,$ln); # start stack
    $macro = '';
    my $flcnt = 0;  # line count of FOREACH lined (in CLEAN_LINES)
    my $maxdep = 1;
    my $cdep = 1;
    for (;$ln < $lncnt ; $ln++) {
        $rcln = ${$rclines}[$ln];
        #                  0     1      2       3      4
        #push(@{$rclines},[$line,$ucdir,$action,$bgnln,$endln]);
        $line    = ${$rcln}[0];
        $tucdir  = ${$rcln}[1];
        $taction = ${$rcln}[2];
        $tbgnln  = ${$rcln}[3];
        $tendln  = ${$rcln}[4];
        if ($line =~ /^\s*ENDFOREACH\s*\(/i) {
            if ($cdep) {
                pop @arr;
                $cdep--;
            }
            last if (!$cdep);
        } elsif ($line =~ /^\s*FOREACH\s*\(/i) {
            push(@arr,$ln);
            $cdep++;
            $maxdep = $cdep if ($cdep > $maxdep);
        }
        $macro .= "$line\n";
        push(@clarr,$rcln);
        #### push(@clarr,[$line,$tucdir,$taction,$tbgnln,$tendln]);  # build a NEW CLEAN LINE array
        $flcnt++;
    }
    $macro =~ s/\s$//g;
    # ============================================
    ${$rh}{'ACT_I'}         = $ln; # move forward
    # ============================================
    my $end = $ln + 1;
    $i = $end - $bgn;
    prt("[d100] FOREACH( $item1 $arglist ) argc=$argc lns=$i [$bgn:$end] dep=$fedep:$maxdep [$bfile]$lnn\n")
        if (($dbg_flag & 0x100) && ${$rh}{'show_foreach_dbg'});
    # show args before substitutions, and collected foreach set of item

    # now process arguments again doing substitutions...
    $argc = 0;
    my @newarr = ();
    $arglist = '';  # restart argument list
    for ($i = 1; $i < $cnt; $i++) {
        $tmp = ${$ra}[$i];    # extract the ARGUMENT item
        $ok = (length($tmp) ? 1 : 0);
        if ($tmp =~ /\$\{\w+\}/) {
            # got a macro to EXPAND
            $ok = 0;    # not ok is assumed, until substitution done, at least one
            while ($tmp =~ /\${(\w+)\}/) {
                $val = $1;
                $sval = '';
                if (defined ${$rsmh}{$val}) {
                    # - found in 'SET' lists
                    $rval = ${$rsmh}{$val};
                    ##### $sval = ${$rval}[0];
                    $sval = join(" ",@{$rval});
                    if ($sval && length($sval)) {
                        $sval = strip_quotes($sval);
                        $ok = 1 if (length($sval));
                    } elsif ($sval) {
                        # this is just a blank
                    } else {
                        $tmp = join(" ",@{$rval});
                        pgm_exit(1,"ERROR: How come this [$val] 'SET' item is NOT defined!\n".
                            "Values [$tmp] [$bfile}$lnn\n");
                    }
                } elsif (defined ${$rli}{$val}) {
                    # - found in 'LIST' lists
                    $rval = ${$rli}{$val};
                    ####$sval = ${$rval}[0];
                    $sval = join(" ",@{$rval});
                    if ($sval && length($sval)) {
                        $sval = strip_quotes($sval);
                        $ok = 1 if (length($sval));
                    } elsif ($sval) {
                        # just a blank
                    } else {
                        $tmp = join(" ",@{$rval});
                        pgm_exit(1,"ERROR: How come this [$val] 'LIST' item is NOT defined!\n".
                            "Values [$tmp] [$bfile}$lnn\n");
                    }
                } else {
                    # where else to LOOK? meantime
                    $sval = '';
                }
                if ($ok) {
                    # DO THE SUBSTITUTION
                    $msg = "Substitution in [$tmp] of \${$val} with [$sval]";
                    $tmp =~ s/\$\{$val\}/$sval/g;
                    $msg .= " gives [$tmp]";
                    prt("[d100] $msg\n") if (($dbg_flag & 0x100) && ${$rh}{'show_foreach_dbg'});
                } else {
                    push(@subs,$val);
                    my $rnf = ${$rh}{'not_found_in_set_or_list'};
                    if (!defined ${$rnf}{$val}) {
                         ${$rnf}{$val} = 1;
                         if (${$rh}{'warn_substitution_for'}) {
                             prtw("WARNING: Substitution for [$tmp] [$val] NOT FOUND IN 'SET' or 'LIST'! act [$act] [$bfile]$lnn\n") 
                                 if (${$rh}{'warn_no_set_or_list'});
                         } else {
                             ${$rh}{'warnings_avoided'}++;
                         }
                    } else {
                         ${$rh}{'warnings_avoided'}++;
                    }
                    last;   # FAILED - exit while
                }
            }
        }
        if ($ok) {
            $arglist .= ' ' if (length($arglist));
            $arglist .= $tmp;
            push(@newarr,$tmp);
            $argc++;
        }
    }
    ###prt("[d400] FOREACH( $item1 $args ) argc=$argc lns=$bgn:$end dep=$mdep [$bfile]$lnn\n") if ($dbg_flag & 0x400);
    $i = $end - $bgn;
    my $maclist = '';
    foreach $rcln (@clarr) {
        $line    = ${$rcln}[0];
        $tucdir  = ${$rcln}[1];
        $taction = ${$rcln}[2];
        $tbgnln  = ${$rcln}[3];
        $tendln  = ${$rcln}[4];
        $maclist .= "\n" if (length($maclist));
        $maclist .= " $tbgnln: $line"
    }
    prt("[d400] FOREACH \${$item1} set to each of [$arglist] do\n$maclist\n ENDFOREACH] [$bgn:$end] $i of $lncnt dep=$fedep:$maxdep for $argc args.\n")
        if (($dbg_flag & 0x400) && ${$rh}{'show_foreach_list'});
    # if (@newarr && @clarr) {
    if ($argc && $flcnt) {
        my $svdbg = ${$rh}{'CURR_DBG_FLAG'};
        ${$rh}{'CURR_DBG_FLAG'} = -1;
        save_cmake_ref_hash_stack($rh);
        $msg = '';
        $cnt = scalar @newarr;  # get argument count
        for ($i = 0; $i < $cnt; $i++) {
            my $arg = $newarr[$i];
            $macro = '';
            my $orgtxt = '';
            my @subarr = ();
            foreach $rcln (@clarr) {
                $line    = ${$rcln}[0];    # extract the original CLEAN line
                $tucdir  = ${$rcln}[1];
                $taction = ${$rcln}[2];
                $tbgnln  = ${$rcln}[3];
                $tendln  = ${$rcln}[4];
                $orgtxt .= "$line\n";   # store original text
                $line =~ s/\$\{$item1\}/$arg/;    # do any substitutions
                $taction =~ s/\$\{$item1\}/$arg/;
                $macro .= "$line\n";    # add to 'changed' text
                ## CANNOT DESTROY CLEAN LINE ARRAY #${$rcln}[0] = $line; # may be NEEDED for next SUB, if more than 1
                #             0     1       2        3       4
                push(@subarr,[$line,$tucdir,$taction,$tbgnln,$tendln]); # create a NEW CLEAN LINE ARRAY TO PROCESS
                #if ($tucdir eq 'LIST') {
                #    $tmp = ${$rcln}[2];
                #    prt("push(\@subarr,[[$line],[$tucdir],[$taction]from[$tmp],[$tbgnln],[$tendln]]) creating a NEW CLEAN LINE ARRAY\n");
                #}
            }
            # $macro =~ s/\$\{$item1\}/$args/g;
            # prt("[v9] After substitution [$macro]\n"); # if (VERB9() || $dbg_06);
            if (($orgtxt eq $macro)&&(length($msg)==0)) {
                $macro =~ s/\s$//g;
                $msg = "WARNING: In org txt [$macro], substitution of \${$item1} to [$arg] FAILED! ";
                $msg .= " [$bfile]($bgn)";
                prtw("$msg\n") if (${$rh}{'warn_foreach_sub_failed'});
            } else {
                $macro =~ s/\s$//g;
                prt("[d400] FOREACH \${$item1} set to [$arg] do\n$macro\nENDFOREACH] [$bgn:$end] $i of $cnt dep=$fedep:$maxdep for $argc args.\n")
                    if (($dbg_flag & 0x400) && ${$rh}{'show_foreach_list'});
            }
            ####${$rh}{"CLEAN_LINES"} = \@clarr;
            ${$rh}{"CLEAN_LINES"} = \@subarr;   # setup the new CLEAN LINES to process
            $arg = substr($arg,0,12)."..." if (length($arg) > 16);   # reduce length if a LONG line
            ${$rh}{'CURR_LINE_SOURCE'} = "FEsub [$item1=$arg] ($fedep)";
            process_clean_ref_array2($rh);   # was process_cmake_script($rh);  # from FOREACH processing
        }
        # prt("$msg\n") if (length($msg));
        # prt("[v9] Completed $argc FOREACH($item1) substitutions...\n"); # if (VERB9() || $dbg_06); 
        # RESTORE CERTAIN VARIABLES BACK TO FORMER
        restore_cmake_ref_hash_stack($rh);
        ${$rh}{'CURR_DBG_FLAG'} = $svdbg;
        # note move the file lines FORWARD at end
        # pgm_exit(1,"TEMP EXIT");
    } elsif ($flcnt) {
        # we have foreach lines, so NO ARGUMENTS!!!
        $msg = "FOREACH( $item1 $arglist ) argc=$argc dep=$fedep:$maxdep NO ARGUMENTS!";
        if (@subs) {
            $msg .= " Probably subs FAILED! [";
            $msg .= join(" ",@subs);
            $msg .= "]";
        }
        $msg .= " [$bfile]$lnn $bgn:$end";
        #if (${$rh}{'warn_foreach_no_args'}) {
        #    prtw("WARNING: $msg\n");
        #} elsif (($dbg_flag & 0x100) && ${$rh}{'show_foreach_dbg'}) {
        if (($dbg_flag & 0x100) && ${$rh}{'show_foreach_dbg'}) {
            prt("[d100] $msg\n");
        }
    } else {
        prtw("WARNING: FOREACH( $item1 $arglist ) argc=$argc lns=$bgn:$end dep=$fedep:$maxdep No lines to RUN! [$bfile]$lnn\n");
    }
    ${$rh}{'foreach_depth'}--;  # DECREMENT FOREACH DEPTH
}

# =======================================
# some incomplete implementations - may or maynot ever be completed

sub fn_NOT_YET {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    prtw("WARNING: $tag( $act ) NOT YET IMPLEMENTED! [$bfile]$lnn\n") if (${$rh}{'warn_not_yet'});

}



# $tag eq 'FIND_PROGRAM'
# like
# FIND_PROGRAM(  HDF5_C_COMPILER_EXECUTABLE
#   NAMES h5cc h5pcc 
#   HINTS ENV HDF5_ROOT PATH_SUFFIXES bin Bin 
#   DOC "HDF5 Wrapper compiler. Used only to detect HDF5 compile flags."  )
# from [C:\Program Files (x86)\CMake 2.8\share\cmake-2.8\Modules\FindHDF5.cmake]92:96
sub fn_FIND_PROGRAM {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};

    my $item1 = ${$ra}[0];   # get PROGRAM variable name
    fn_NOT_YET($rh);
}

# $tag eq 'MARK_AS_ADVANCED'
sub fn_MARK_AS_ADVANCED {
    my $rh = shift;
    # decided how to mark it...
    fn_NOT_YET($rh);
}

# $tag eq 'FIND_PATH'
# FIND_PATH(  HDF5_${LANGUAGE}_INCLUDE_DIR ${HDF5_INCLUDE_FILENAME} 
#   HINTS ${HDF5_${LANGUAGE}_INCLUDE_FLAGS} ENV HDF5_ROOT 
#   PATHS $ENV{HOME}/.local/include 
#   PATH_SUFFIXES include Include  )
# from [C:\Program Files (x86)\CMake 2.8\share\cmake-2.8\Modules\FindHDF5.cmake]249:259
sub fn_FIND_PATH {
    my $rh = shift;
    # decided what to do...
    fn_NOT_YET($rh);
}

# $tag eq 'FIND_PACKAGE'
# FIND_PACKAGE(  HDF5 QUIET NO_MODULE  )
# [C:\Program Files (x86)\CMake 2.8\share\cmake-2.8\Modules\FindHDF5.cmake]187
sub fn_FIND_PACKAGE {
    my $rh = shift;
    # decided what to do...
    fn_NOT_YET($rh);
}

# $tag eq 'FILE'
# FILE(  STRINGS "${_dir}/H5pubconf.h" HDF5_HAVE_PARALLEL_DEFINE REGEX "HAVE_PARALLEL 1"  )
sub fn_FILE {
    my $rh = shift;
    # decided what to do...
    fn_NOT_YET($rh);
}


# $tag eq 'FIND_PACKAGE_HANDLE_STANDARD_ARGS'
sub fn_FIND_PACKAGE_HANDLE_STANDARD_ARGS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $rma = ${$rh}{'CMAKE_FUNCTIONS'};
    # simply, has this FUNCTION been loaded
    if (defined ${$rma}{$tag}) {
        # TODO - run the function with standard args
    } else {
        my $rfny = ${$rh}{'CMAKE_FUNCTIONS_NOT_YET'}; # = \%functions_not_yet;
        if (!defined ${$rfny}{$tag}) {
            ${$rfny}{$tag} = 1;
            if (${$rh}{'warn_functions_ny'}) {
                prtw("WARNING: $tag($act) NOT YET LOADED! [$bfile]$lnn\n");
            } else {
                ${$rh}{'warnings_avoided'}++;
            }
        } else {
            ${$rh}{'warnings_avoided'}++;
        }
    }
}

# $tag eq 'GET_TARGET_PROPERTY'
# GET_TARGET_PROPERTY(  _comp_location ${HDF5_${_component}_TARGET} LOCATION  )
# [C:\Program Files (x86)\CMake 2.8\share\cmake-2.8\Modules\FindHDF5.cmake]198
sub fn_GET_TARGET_PROPERTY {
    my $rh = shift;
    # decided what to do...
    fn_NOT_YET($rh);
}
# GET_TEST_PROPERTY
sub fn_GET_TEST_PROPERTY {
    my $rh = shift;
    # decided what to do...
    fn_NOT_YET($rh);
}

sub fn__REMOVE_DUPLICATES_FROM_BEGINNING {
    my $rh = shift;
    # decided what to do...
    fn_NOT_YET($rh);
}

# $tag eq '_HDF5_INVOKE_COMPILER'
sub fn_HDF5_INVOKE_COMPILER { }
sub fn_HDF5_PARSE_COMPILE_LINE { }

# $tag eq 'RETURN'
# like
#if(__CMAKE_PARSE_ARGUMENTS_INCLUDED)
#  return()
#endif()
#set(__CMAKE_PARSE_ARGUMENTS_INCLUDED TRUE)
sub fn_RETURN {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    if (${$rh}{'CURR_IN_IF'}) {
        # ***TBD*** TODO - need to evaluate the IF( ), and if TRUE eat the rest of the FILE
        my $rclines = ${$rh}{"CLEAN_LINES"};
        my $lncnt = ${$rh}{"ACT_LCNT"};
        my $ln = ${$rh}{"ACT_I"};
        # ${$rh}{"ACT_I"} = $lncnt; # dumping all the file lines is as simple as when ready

    } else {
        prtw("WARNING: See 'RETURN' NOT IN 'IF'! [$bfile]$lnn\n");
    }
}


# stubs
sub fn_STRING { }
sub fn_MESSAGE { }
sub fn_EXECUTE_PROCESS { }
sub fn_ENABLE_LANGUAGE { }
sub fn_CONFIGURE_FILE { }
sub fn___WINDOWS_COMPILER_INTEL { }
sub fn___WINDOWS_COMPILER_GNU { }
sub fn___WINDOWS_COMPILER_GNU_ABI { }

sub fn_ADD_CUSTOM_COMMAND {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_ADD_CUSTOM_TARGET {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_ADD_DEFINITIONS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_ADD_DEPENDENCIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_ADD_EXECUTABLE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_ADD_FILE_DEPENDENCIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_ADD_TEST {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_ADJUST_CMAKE_SYSTEM_VARIABLES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_BISON_TARGET_OPTION_EXTRAOPTS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_BISON_TARGET_OPTION_VERBOSE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_BREAK {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_BUILD_COMMAND {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_CXX_ACCEPTS_FLAG {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_CXX_COMPILER_FLAG {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_CXX_SOURCE_COMPILES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_CXX_SYMBOL_EXISTS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_C_SOURCE_COMPILES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_CXX_SOURCE_RUNS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_FORTRAN_FUNCTION_EXISTS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_FORTRAN_LIBRARIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_FUNCTION_EXISTS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_INCLUDE_FILE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_INCLUDE_FILES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_INCLUDE_FILE_CXX {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_LAPACK_LIBRARIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_LIBRARY_EXISTS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_STRUCT_HAS_MEMBER {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_SYMBOL_EXISTS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_TYPE_SIZE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CHECK_VERSION {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CLEAR_BUNDLE_KEYS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CMAKE_DETERMINE_COMPILER_ABI {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CMAKE_DETERMINE_COMPILER_ID {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CMAKE_DETERMINE_COMPILER_ID_BUILD {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CMAKE_DETERMINE_COMPILER_ID_CHECK {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CMAKE_DETERMINE_COMPILER_ID_VENDOR {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CMAKE_DETERMINE_COMPILER_ID_WRITE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CMAKE_FIND_FRAMEWORKS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CMAKE_GNU_HAS_ISYSROOT {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CMAKE_GNU_SET_OSX_DEPLOYMENT_TARGET_FLAG {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CMAKE_MINIMUM_REQUIRED {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CMAKE_PARSE_ARGUMENTS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CMAKE_PARSE_IMPLICIT_LINK_INFO {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CMAKE_POLICY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CMAKE_POP_CHECK_STATE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CMAKE_PUSH_CHECK_STATE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_COPY_RESOLVED_FRAMEWORK_INTO_BUNDLE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_COPY_RESOLVED_ITEM_INTO_BUNDLE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CPACK_APPEND_OPTION_SET_COMMAND {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CPACK_APPEND_STRING_VARIABLE_SET_COMMAND {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CPACK_APPEND_VARIABLE_SET_COMMAND {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CPACK_CHECK_FILE_EXISTS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CPACK_ENCODE_VARIABLES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CPACK_OPTIONAL_APPEND {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CPACK_PARSE_ARGUMENTS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CPACK_SET_IF_NOT_SET {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CRT_VERSION {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CUDA_ADD_CUDA_INCLUDE_ONCE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CUDA_BUILD_SHARED_LIBRARY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CUDA_COMPUTE_BUILD_PATH {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CUDA_EXECUTE_PROCESS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CUDA_FIND_HELPER_FILE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CUDA_GET_SOURCES_AND_OPTIONS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CUDA_INCLUDE_NVCC_DEPENDENCIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CUDA_PARSE_NVCC_OPTIONS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_CUDA_WRAP_SRCS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_DBG_MSG {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_DBG_MSG_V {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_DEFINE_PROPERTY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_DUMP_FILE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_ECOS_ADD_TARGET_LIB {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_ENABLE_TESTING {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
    fn_NOT_YET($rh);
}
sub fn_ENDFOREACH {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_ENDFUNCTION {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_ENDMACRO {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_ENDWHILE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_ERROR_MESSAGE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_EXEC_PROGRAM {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_EXTERNALPROJECT_ADD_STEP {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_EXTERNALPROJECT_ADD_STEPTARGETS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_EXTERNALPROJECT_GET_PROPERTY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_FEATURE_SUMMARY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_FIND_CUDA_HELPER_LIBS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_FIND_FILE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_FIND_IMAGEMAGICK_API {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_FIND_IMAGEMAGICK_EXE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_FIND_LIBRARY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_FIND_LIBRARY_LOCAL_FIRST {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_FIND_PACKAGE_MESSAGE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_FIXUP_BUNDLE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_FIXUP_BUNDLE_ITEM {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GETDEFAULTWINDOWSPREFIXBASE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GET_BUNDLE_ALL_EXECUTABLES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GET_BUNDLE_AND_EXECUTABLE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GET_BUNDLE_KEYS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GET_BUNDLE_MAIN_EXECUTABLE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GET_CMAKE_PROPERTY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GET_DIRECTORY_PROPERTY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GET_DOTAPP_DIR {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GET_FILENAME_COMPONENT {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GET_ITEM_KEY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GET_PREREQUISITES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GET_PROPERTY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GET_SOURCE_FILE_PROPERTY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GET_VS_VERSION_STRING {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GP_APPEND_UNIQUE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GP_FILE_TYPE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GP_ITEM_DEFAULT_EMBEDDED_PATH {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GP_ITEM_DEFAULT_EMBEDDED_PATH_OVERRIDE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GP_RESOLVED_FILE_TYPE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GP_RESOLVED_FILE_TYPE_OVERRIDE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GP_RESOLVE_ITEM {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_GP_RESOLVE_ITEM_OVERRIDE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_INCLUDE_DIRECTORIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_INSTALL_FILES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
}
# INSTALL_TARGETS
sub fn_INSTALL_TARGETS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;
}
sub fn_INSTALL_QT4_PLUGIN {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_INSTALL_QT4_PLUGIN_PATH {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_INTERROGATE_MPI_COMPILER {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_IS_FILE_EXECUTABLE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_JAVA_APPEND_LIBRARY_DIRECTORIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_KDE3_INSTALL_LIBTOOL_FILE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_KDE3_PRINT_RESULTS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_LINK_DIRECTORIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_LINK_LIBRARIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_LIST_PREREQUISITES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_LOAD_CACHE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_MACRO_ADD_FILE_DEPENDENCIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_MAKE_DIRECTORY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_MATH {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_MFC_FILES_FOR_VERSION {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_MSG {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_MSVCRT_FILES_FOR_VERSION {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_OPTION {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_OSG_FIND_LIBRARY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_OSG_FIND_PATH {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_OSG_MARK_AS_ADVANCED {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_PERL_ADJUST_DARWIN_LIB_VARIABLE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_PKG_CHECK_MODULES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_PRINTTESTCOMPILERSTATUS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_PROCESSORCOUNT {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}

# [CREATE_TEST_SOURCELIST] act [(CMakeLib_TEST_SRCS CMakeLibTests.cxx ${CMakeLib_TESTS})] [C:\FGCVS\cmake\Tests\CMakeLib\CMakeLists.txt]18:18
sub fn_CREATE_TEST_SOURCELIST {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}

# [QT4_WRAP_UI]            act [(UI_SRCS CMakeSetupDialog.ui Compilers.ui CrossCompiler.ui AddCacheEntry.ui MacInstallDialog.ui )] [C:\FGCVS\cmake\Source\QtDialog\CMakeLists.txt]39:45
sub fn_QT4_WRAP_UI {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
# [QT4_WRAP_CPP]           act [(MOC_SRCS AddCacheEntry.h Compilers.h CMakeSetupDialog.h FirstConfigure.h QCMake.h QCMakeCacheView.h QCMakeWidgets.h QMacInstallDialog.h )] [C:\FGCVS\cmake\Source\QtDialog\CMakeLists.txt]46:55
sub fn_QT4_WRAP_CPP {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
# [QT4_ADD_RESOURCES]      act [(RC_SRCS CMakeSetup.qrc)] [C:\FGCVS\cmake\Source\QtDialog\CMakeLists.txt]56:56
sub fn_QT4_ADD_RESOURCES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}

sub fn_QT4_ADD_DBUS_INTERFACE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_QT4_ADD_TRANSLATION {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_QT4_CREATE_MOC_COMMAND {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_QT4_EXTRACT_OPTIONS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_QT4_GENERATE_MOC {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_QT4_GET_MOC_FLAGS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_QT4_MAKE_OUTPUT_FILE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_RESOLVE_QT4_PATHS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_RTI_MESSAGE_QUIETLY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SANITYCHECKSDKANDDEPLOYTARGET {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SELECT_LIBRARY_CONFIGURATIONS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SEPARATE_ARGUMENTS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SET_BUNDLE_KEY_VALUES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SET_COMPILE_FLAGS_VAR {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SET_DIRECTORY_PROPERTIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SET_IF_NOT_SET {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SET_IF_SET_AND_NOT_SET {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SET_LINK_FLAGS_VAR {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SET_PACKAGE_INFO {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SET_PROPERTY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SET_SOURCE_FILES_PROPERTIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SET_TARGET_PROPERTIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SET_TESTS_PROPERTIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SITE_NAME {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SWIG_ADD_SOURCE_TO_MODULE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SWIG_GET_EXTRA_OUTPUT_FILES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_SWIG_MODULE_INITIALIZE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_TARGET_LINK_LIBRARIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_TEST_BIG_ENDIAN {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_TRY_COMPILE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_TRY_REGULAR_COMPILER {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_TRY_RUN {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_UNSET {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_VERIFY_APP {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_VERIFY_BUNDLE_PREREQUISITES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_VERIFY_BUNDLE_SYMLINKS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_WHILE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_WRITE_QT4_CONF {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_WX_CLEAR_ALL_DBG_LIBS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_WX_CLEAR_ALL_LIBS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_WX_CLEAR_ALL_REL_LIBS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_WX_CLEAR_LIB {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_WX_CONFIG_SELECT_GET_DEFAULT {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_WX_CONFIG_SELECT_QUERY_BOOL {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_WX_CONFIG_SELECT_SET_OPTIONS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_WX_FIND_LIBS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_WX_GET_DEPENDENCIES_FROM_XML {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_WX_GET_NAME_COMPONENTS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_WX_SET_LIBRARIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn_WX_SPLIT_ARGUMENTS_ON {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__BOOST_ADJUST_LIB_VARS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__BOOST_CHECK_SPELLING {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__BOOST_COMPILER_DUMPVERSION {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__BOOST_MARK_COMPONENTS_FOUND {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__BOOST_PREPEND_LIST_WITH_THREADAPI {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__BOOST_SWAP_WITH_REALPATH {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__BULLET_APPEND_LIBRARIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__CHECK_CXX_COMPILER_ATTRIBUTE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__CHECK_SYMBOL_EXISTS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__DETERMINEVSSERVICEPACKFROMCOMPILER {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__DETERMINEVSSERVICEPACK_CHECKVERSIONWITHTRYCOMPILE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__DETERMINEVSSERVICEPACK_CHECKVERSIONWITHTRYRUN {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__DETERMINEVSSERVICEPACK_FASTCHECKVERSIONWITHCOMPILER {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__DETERMINE_GCC_SYSTEM_INCLUDE_DIRS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__DO_GENERATE_EXPORT_HEADER {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__DO_SET_MACRO_VALUES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_ADD_BUILD_COMMAND {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_ADD_CONFIGURE_COMMAND {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_ADD_DOWNLOAD_COMMAND {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_ADD_INSTALL_COMMAND {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_ADD_MKDIR_COMMAND {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_ADD_PATCH_COMMAND {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_ADD_TEST_COMMAND {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_ADD_UPDATE_COMMAND {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_GET_BUILD_COMMAND {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_GET_CONFIGURATION_SUBDIR_SUFFIX {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_GET_CONFIGURE_COMMAND_ID {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_GET_GIT_VERSION {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_IS_DIR_EMPTY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_PARSE_ARGUMENTS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_REPLACE_LOCATION_TAGS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_SET_DIRECTORIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_WRITE_DOWNLOADFILE_SCRIPT {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_WRITE_EXTRACTFILE_SCRIPT {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_WRITE_GITCLONE_SCRIPT {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_WRITE_INITIAL_CACHE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_WRITE_LOG_SCRIPT {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__EP_WRITE_VERIFYFILE_SCRIPT {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__FIND_BULLET_LIBRARY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__FIND_ECLIPSE_VERSION {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__FPHSA_FAILURE_MESSAGE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__FPHSA_HANDLE_FAILURE_CONFIG_MODE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__FS_GET_FEATURE_SUMMARY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__GTEST_APPEND_DEBUGS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__GTEST_FIND_LIBRARY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__GTK2_FIND_INCLUDE_DIR {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__GTK2_FIND_LIBRARY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__GTK2_GET_VERSION {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__HDF5_INVOKE_COMPILER {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__HDF5_PARSE_COMPILE_LINE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__KDE3_ADD_ICON_INSTALL_RULE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__PKGCONFIG_INVOKE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__PKGCONFIG_INVOKE_DYN {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__PKGCONFIG_PARSE_OPTIONS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__PKGCONFIG_SET {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__PKGCONFIG_UNSET {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__PKG_CHECK_MODULES_INTERNAL {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__PROTOBUF_FIND_LIBRARIES {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__QT4_ADJUST_LIB_VARS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__QT4_QUERY_QMAKE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__SET_LIBRARY_NAME {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__TEST_COMPILER_HAS_DEPRECATED {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn__TEST_COMPILER_HIDDEN_VISIBILITY {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___AIX_COMPILER_GNU {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___AIX_COMPILER_XL {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___BLUEGENEP_SET_DYNAMIC_FLAGS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___BLUEGENEP_SET_STATIC_FLAGS {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___BORLAND_LANGUAGE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___CHECK_TYPE_SIZE_IMPL {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___COMPILER_GNU {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___COMPILER_PATHSCALE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___COMPILER_PGI {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___COMPILER_SCO {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___COMPILER_XL {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___CYGWIN_COMPILER_GNU {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___DARWIN_COMPILER_GNU {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___HPUX_COMPILER_GNU {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___HPUX_COMPILER_HP {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___JAVA_COPY_FILE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___LINUX_COMPILER_GNU {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___LINUX_COMPILER_INTEL {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___LINUX_COMPILER_PATHSCALE {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___LINUX_COMPILER_PGI {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}
sub fn___SUNOS_COMPILER_GNU {
    my $rh = shift;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lnn = ${$rh}{"ACT_LNN"};
    my $tag = ${$rh}{"ACT_TAG"};
    my $act = ${$rh}{"ACT_ACT"};
    my $ra  = ${$rh}{"ACT_RA"};
    my $cnt = ${$rh}{"ACT_CNT"};    # = scalar @arr;

}

my %directive_hash = (
  'ADD_CUSTOM_COMMAND'           => \&fn_ADD_CUSTOM_COMMAND,
  'ADD_CUSTOM_TARGET'            => \&fn_ADD_CUSTOM_TARGET,
  'ADD_DEFINITIONS'              => \&fn_ADD_DEFINITIONS,
  'ADD_DEPENDENCIES'             => \&fn_ADD_DEPENDENCIES,
  'ADD_EXECUTABLE'               => \&fn_ADD_EXECUTABLE,
  'ADD_FILE_DEPENDENCIES'        => \&fn_ADD_FILE_DEPENDENCIES,
  'ADD_LIBRARY'                  => \&fn_ADD_LIBRARY,
  'ADD_SUBDIRECTORY'             => \&fn_ADD_SUBDIRECTORY,
  'ADD_TEST'                     => \&fn_ADD_TEST,
  'ADJUST_CMAKE_SYSTEM_VARIABLES' => \&fn_ADJUST_CMAKE_SYSTEM_VARIABLES,
  'BISON_TARGET_OPTION_EXTRAOPTS' => \&fn_BISON_TARGET_OPTION_EXTRAOPTS,
  'BISON_TARGET_OPTION_VERBOSE'  => \&fn_BISON_TARGET_OPTION_VERBOSE,
  'BREAK'                        => \&fn_BREAK,
  'BUILD_COMMAND'                => \&fn_BUILD_COMMAND,
  'CHECK_CXX_ACCEPTS_FLAG'       => \&fn_CHECK_CXX_ACCEPTS_FLAG,
  'CHECK_CXX_COMPILER_FLAG'      => \&fn_CHECK_CXX_COMPILER_FLAG,
  'CHECK_CXX_SOURCE_COMPILES'    => \&fn_CHECK_CXX_SOURCE_COMPILES,
  'CHECK_CXX_SOURCE_RUNS'        => \&fn_CHECK_CXX_SOURCE_RUNS,
  'CHECK_CXX_SYMBOL_EXISTS'      => \&fn_CHECK_CXX_SYMBOL_EXISTS,
  'CHECK_C_SOURCE_COMPILES'      => \&fn_CHECK_C_SOURCE_COMPILES,
  'CHECK_FORTRAN_FUNCTION_EXISTS' => \&fn_CHECK_FORTRAN_FUNCTION_EXISTS,
  'CHECK_FORTRAN_LIBRARIES'      => \&fn_CHECK_FORTRAN_LIBRARIES,
  'CHECK_FUNCTION_EXISTS'        => \&fn_CHECK_FUNCTION_EXISTS,
  'CHECK_INCLUDE_FILE'           => \&fn_CHECK_INCLUDE_FILE,
  'CHECK_INCLUDE_FILES'          => \&fn_CHECK_INCLUDE_FILES,
  'CHECK_INCLUDE_FILE_CXX'       => \&fn_CHECK_INCLUDE_FILE_CXX,
  'CHECK_LAPACK_LIBRARIES'       => \&fn_CHECK_LAPACK_LIBRARIES,
  'CHECK_LIBRARY_EXISTS'         => \&fn_CHECK_LIBRARY_EXISTS,
  'CHECK_STRUCT_HAS_MEMBER'      => \&fn_CHECK_STRUCT_HAS_MEMBER,
  'CHECK_SYMBOL_EXISTS'          => \&fn_CHECK_SYMBOL_EXISTS,
  'CHECK_TYPE_SIZE'              => \&fn_CHECK_TYPE_SIZE,
  'CHECK_VERSION'                => \&fn_CHECK_VERSION,
  'CLEAR_BUNDLE_KEYS'            => \&fn_CLEAR_BUNDLE_KEYS,
  'CMAKE_DETERMINE_COMPILER_ABI' => \&fn_CMAKE_DETERMINE_COMPILER_ABI,
  'CMAKE_DETERMINE_COMPILER_ID'  => \&fn_CMAKE_DETERMINE_COMPILER_ID,
  'CMAKE_DETERMINE_COMPILER_ID_BUILD' => \&fn_CMAKE_DETERMINE_COMPILER_ID_BUILD,
  'CMAKE_DETERMINE_COMPILER_ID_CHECK' => \&fn_CMAKE_DETERMINE_COMPILER_ID_CHECK,
  'CMAKE_DETERMINE_COMPILER_ID_VENDOR' => \&fn_CMAKE_DETERMINE_COMPILER_ID_VENDOR,
  'CMAKE_DETERMINE_COMPILER_ID_WRITE' => \&fn_CMAKE_DETERMINE_COMPILER_ID_WRITE,
  'CMAKE_FIND_FRAMEWORKS'        => \&fn_CMAKE_FIND_FRAMEWORKS,
  'CMAKE_GNU_HAS_ISYSROOT'       => \&fn_CMAKE_GNU_HAS_ISYSROOT,
  'CMAKE_GNU_SET_OSX_DEPLOYMENT_TARGET_FLAG' => \&fn_CMAKE_GNU_SET_OSX_DEPLOYMENT_TARGET_FLAG,
  'CMAKE_MINIMUM_REQUIRED'       => \&fn_CMAKE_MINIMUM_REQUIRED,
  'CMAKE_PARSE_ARGUMENTS'        => \&fn_CMAKE_PARSE_ARGUMENTS,
  'CMAKE_PARSE_IMPLICIT_LINK_INFO' => \&fn_CMAKE_PARSE_IMPLICIT_LINK_INFO,
  'CMAKE_POLICY'                 => \&fn_CMAKE_POLICY,
  'CMAKE_POP_CHECK_STATE'        => \&fn_CMAKE_POP_CHECK_STATE,
  'CMAKE_PUSH_CHECK_STATE'       => \&fn_CMAKE_PUSH_CHECK_STATE,
  'CONFIGURE_FILE'               => \&fn_CONFIGURE_FILE,
  'COPY_RESOLVED_FRAMEWORK_INTO_BUNDLE' => \&fn_COPY_RESOLVED_FRAMEWORK_INTO_BUNDLE,
  'COPY_RESOLVED_ITEM_INTO_BUNDLE' => \&fn_COPY_RESOLVED_ITEM_INTO_BUNDLE,
  'CPACK_APPEND_OPTION_SET_COMMAND' => \&fn_CPACK_APPEND_OPTION_SET_COMMAND,
  'CPACK_APPEND_STRING_VARIABLE_SET_COMMAND' => \&fn_CPACK_APPEND_STRING_VARIABLE_SET_COMMAND,
  'CPACK_APPEND_VARIABLE_SET_COMMAND' => \&fn_CPACK_APPEND_VARIABLE_SET_COMMAND,
  'CPACK_CHECK_FILE_EXISTS'      => \&fn_CPACK_CHECK_FILE_EXISTS,
  'CPACK_ENCODE_VARIABLES'       => \&fn_CPACK_ENCODE_VARIABLES,
  'CPACK_OPTIONAL_APPEND'        => \&fn_CPACK_OPTIONAL_APPEND,
  'CPACK_PARSE_ARGUMENTS'        => \&fn_CPACK_PARSE_ARGUMENTS,
  'CPACK_SET_IF_NOT_SET'         => \&fn_CPACK_SET_IF_NOT_SET,
  'CREATE_TEST_SOURCELIST'       => \&fn_CREATE_TEST_SOURCELIST,
  'CRT_VERSION'                  => \&fn_CRT_VERSION,
  'CUDA_ADD_CUDA_INCLUDE_ONCE'   => \&fn_CUDA_ADD_CUDA_INCLUDE_ONCE,
  'CUDA_BUILD_SHARED_LIBRARY'    => \&fn_CUDA_BUILD_SHARED_LIBRARY,
  'CUDA_COMPUTE_BUILD_PATH'      => \&fn_CUDA_COMPUTE_BUILD_PATH,
  'CUDA_EXECUTE_PROCESS'         => \&fn_CUDA_EXECUTE_PROCESS,
  'CUDA_FIND_HELPER_FILE'        => \&fn_CUDA_FIND_HELPER_FILE,
  'CUDA_GET_SOURCES_AND_OPTIONS' => \&fn_CUDA_GET_SOURCES_AND_OPTIONS,
  'CUDA_INCLUDE_NVCC_DEPENDENCIES' => \&fn_CUDA_INCLUDE_NVCC_DEPENDENCIES,
  'CUDA_PARSE_NVCC_OPTIONS'      => \&fn_CUDA_PARSE_NVCC_OPTIONS,
  'CUDA_WRAP_SRCS'               => \&fn_CUDA_WRAP_SRCS,
  'DBG_MSG'                      => \&fn_DBG_MSG,
  'DBG_MSG_V'                    => \&fn_DBG_MSG_V,
  'DEFINE_PROPERTY'              => \&fn_DEFINE_PROPERTY,
  'DUMP_FILE'                    => \&fn_DUMP_FILE,
  'ECOS_ADD_TARGET_LIB'          => \&fn_ECOS_ADD_TARGET_LIB,
  'ELSE'                         => \&fn_ELSE,
  'ELSEIF'                       => \&fn_ELSEIF,
  'ENABLE_LANGUAGE'              => \&fn_ENABLE_LANGUAGE,
  'ENABLE_TESTING'               => \&fn_ENABLE_TESTING,
  'ENDFOREACH'                   => \&fn_complain,  # \&fn_ENDFOREACH,
  'ENDFUNCTION'                  => \&fn_complain,  # \&fn_ENDFUNCTION,
  'ENDIF'                        => \&fn_ENDIF,
  'ENDMACRO'                     => \&fn_complain,  # \&fn_ENDMACRO,
  'ENDWHILE'                     => \&fn_ENDWHILE,
  'ERROR_MESSAGE'                => \&fn_ERROR_MESSAGE,
  'EXECUTE_PROCESS'              => \&fn_EXECUTE_PROCESS,
  'EXEC_PROGRAM'                 => \&fn_EXEC_PROGRAM,
  'EXTERNALPROJECT_ADD_STEP'     => \&fn_EXTERNALPROJECT_ADD_STEP,
  'EXTERNALPROJECT_ADD_STEPTARGETS' => \&fn_EXTERNALPROJECT_ADD_STEPTARGETS,
  'EXTERNALPROJECT_GET_PROPERTY' => \&fn_EXTERNALPROJECT_GET_PROPERTY,
  'FEATURE_SUMMARY'              => \&fn_FEATURE_SUMMARY,
  'FILE'                         => \&fn_FILE,
  'FIND_CUDA_HELPER_LIBS'        => \&fn_FIND_CUDA_HELPER_LIBS,
  'FIND_FILE'                    => \&fn_FIND_FILE,
  'FIND_IMAGEMAGICK_API'         => \&fn_FIND_IMAGEMAGICK_API,
  'FIND_IMAGEMAGICK_EXE'         => \&fn_FIND_IMAGEMAGICK_EXE,
  'FIND_LIBRARY'                 => \&fn_FIND_LIBRARY,
  'FIND_LIBRARY_LOCAL_FIRST'     => \&fn_FIND_LIBRARY_LOCAL_FIRST,
  'FIND_PACKAGE'                 => \&fn_FIND_PACKAGE,
  'FIND_PACKAGE_HANDLE_STANDARD_ARGS' => \&fn_FIND_PACKAGE_HANDLE_STANDARD_ARGS,
  'FIND_PACKAGE_MESSAGE'         => \&fn_FIND_PACKAGE_MESSAGE,
  'FIND_PATH'                    => \&fn_FIND_PATH,
  'FIND_PROGRAM'                 => \&fn_FIND_PROGRAM,
  'FIXUP_BUNDLE'                 => \&fn_FIXUP_BUNDLE,
  'FIXUP_BUNDLE_ITEM'            => \&fn_FIXUP_BUNDLE_ITEM,
  'FLTK_WRAP_UI'                 => \&hand_nul,
  'FOREACH'                      => \&fn_FOREACH,
  'FUNCTION'                     => \&fn_FUNCTION,
  'GETDEFAULTWINDOWSPREFIXBASE'  => \&fn_GETDEFAULTWINDOWSPREFIXBASE,
  'GET_BUNDLE_ALL_EXECUTABLES'   => \&fn_GET_BUNDLE_ALL_EXECUTABLES,
  'GET_BUNDLE_AND_EXECUTABLE'    => \&fn_GET_BUNDLE_AND_EXECUTABLE,
  'GET_BUNDLE_KEYS'              => \&fn_GET_BUNDLE_KEYS,
  'GET_BUNDLE_MAIN_EXECUTABLE'   => \&fn_GET_BUNDLE_MAIN_EXECUTABLE,
  'GET_CMAKE_PROPERTY'           => \&fn_GET_CMAKE_PROPERTY,
  'GET_DIRECTORY_PROPERTY'       => \&fn_GET_DIRECTORY_PROPERTY,
  'GET_DOTAPP_DIR'               => \&fn_GET_DOTAPP_DIR,
  'GET_FILENAME_COMPONENT'       => \&fn_GET_FILENAME_COMPONENT,
  'GET_ITEM_KEY'                 => \&fn_GET_ITEM_KEY,
  'GET_PREREQUISITES'            => \&fn_GET_PREREQUISITES,
  'GET_PROPERTY'                 => \&fn_GET_PROPERTY,
  'GET_SOURCE_FILE_PROPERTY'     => \&fn_GET_SOURCE_FILE_PROPERTY,
  'GET_TARGET_PROPERTY'          => \&fn_GET_TARGET_PROPERTY,
  'GET_TEST_PROPERTY'            => \&fn_GET_TEST_PROPERTY,
  'GET_VS_VERSION_STRING'        => \&fn_GET_VS_VERSION_STRING,
  'GP_APPEND_UNIQUE'             => \&fn_GP_APPEND_UNIQUE,
  'GP_FILE_TYPE'                 => \&fn_GP_FILE_TYPE,
  'GP_ITEM_DEFAULT_EMBEDDED_PATH' => \&fn_GP_ITEM_DEFAULT_EMBEDDED_PATH,
  'GP_ITEM_DEFAULT_EMBEDDED_PATH_OVERRIDE' => \&fn_GP_ITEM_DEFAULT_EMBEDDED_PATH_OVERRIDE,
  'GP_RESOLVED_FILE_TYPE'        => \&fn_GP_RESOLVED_FILE_TYPE,
  'GP_RESOLVED_FILE_TYPE_OVERRIDE' => \&fn_GP_RESOLVED_FILE_TYPE_OVERRIDE,
  'GP_RESOLVE_ITEM'              => \&fn_GP_RESOLVE_ITEM,
  'GP_RESOLVE_ITEM_OVERRIDE'     => \&fn_GP_RESOLVE_ITEM_OVERRIDE,
  'IF'                           => \&fn_IF,
  'INCLUDE'                      => \&fn_INCLUDE,
  'INCLUDE_DIRECTORIES'          => \&fn_INCLUDE_DIRECTORIES,
  'INSTALL'                      => \&fn_INSTALL,
  'INSTALL_TARGETS'              => \&fn_INSTALL_TARGETS,
  'INSTALL_FILES'                => \&fn_INSTALL_FILES,
  'INSTALL_QT4_PLUGIN'           => \&fn_INSTALL_QT4_PLUGIN,
  'INSTALL_QT4_PLUGIN_PATH'      => \&fn_INSTALL_QT4_PLUGIN_PATH,
  'INTERROGATE_MPI_COMPILER'     => \&fn_INTERROGATE_MPI_COMPILER,
  'IS_FILE_EXECUTABLE'           => \&fn_IS_FILE_EXECUTABLE,
  'JAVA_APPEND_LIBRARY_DIRECTORIES' => \&fn_JAVA_APPEND_LIBRARY_DIRECTORIES,
  'KDE3_INSTALL_LIBTOOL_FILE'    => \&fn_KDE3_INSTALL_LIBTOOL_FILE,
  'KDE3_PRINT_RESULTS'           => \&fn_KDE3_PRINT_RESULTS,
  'LINK_DIRECTORIES'             => \&fn_LINK_DIRECTORIES,
  'LINK_LIBRARIES'               => \&fn_LINK_LIBRARIES,
  'LIST'                         => \&fn_LIST,
  'LIST_PREREQUISITES'           => \&fn_LIST_PREREQUISITES,
  'LOAD_CACHE'                   => \&fn_LOAD_CACHE,
  'MACRO'                        => \&fn_MACRO,
  'MACRO_ADD_FILE_DEPENDENCIES'  => \&fn_MACRO_ADD_FILE_DEPENDENCIES,
  'MAKE_DIRECTORY'               => \&fn_MAKE_DIRECTORY,
  'MARK_AS_ADVANCED'             => \&fn_MARK_AS_ADVANCED,
  'MATH'                         => \&fn_MATH,
  'MESSAGE'                      => \&fn_MESSAGE,
  'MFC_FILES_FOR_VERSION'        => \&fn_MFC_FILES_FOR_VERSION,
  'MSG'                          => \&fn_MSG,
  'MSVCRT_FILES_FOR_VERSION'     => \&fn_MSVCRT_FILES_FOR_VERSION,
  'OPTION'                       => \&fn_OPTION,
  'OSG_FIND_LIBRARY'             => \&fn_OSG_FIND_LIBRARY,
  'OSG_FIND_PATH'                => \&fn_OSG_FIND_PATH,
  'OSG_MARK_AS_ADVANCED'         => \&fn_OSG_MARK_AS_ADVANCED,
  'PERL_ADJUST_DARWIN_LIB_VARIABLE' => \&fn_PERL_ADJUST_DARWIN_LIB_VARIABLE,
  'PKG_CHECK_MODULES'            => \&fn_PKG_CHECK_MODULES,
  'PRINTTESTCOMPILERSTATUS'      => \&fn_PRINTTESTCOMPILERSTATUS,
  'PROCESSORCOUNT'               => \&fn_PROCESSORCOUNT,
  'PROJECT'                      => \&fn_PROJECT,
  'QT4_ADD_DBUS_INTERFACE'       => \&fn_QT4_ADD_DBUS_INTERFACE,
  'QT4_ADD_TRANSLATION'          => \&fn_QT4_ADD_TRANSLATION,
  'QT4_CREATE_MOC_COMMAND'       => \&fn_QT4_CREATE_MOC_COMMAND,
  'QT4_EXTRACT_OPTIONS'          => \&fn_QT4_EXTRACT_OPTIONS,
  'QT4_GENERATE_MOC'             => \&fn_QT4_GENERATE_MOC,
  'QT4_GET_MOC_FLAGS'            => \&fn_QT4_GET_MOC_FLAGS,
  'QT4_MAKE_OUTPUT_FILE'         => \&fn_QT4_MAKE_OUTPUT_FILE,
  'QT4_WRAP_UI'                  => \&fn_QT4_WRAP_UI,   # act [(UI_SRCS CMakeSetupDialog.ui Compilers.ui CrossCompiler.ui AddCacheEntry.ui MacInstallDialog.ui )] [C:\FGCVS\cmake\Source\QtDialog\CMakeLists.txt]39:45
  'QT4_WRAP_CPP'                 => \&fn_QT4_WRAP_CPP,  # act [(MOC_SRCS AddCacheEntry.h Compilers.h CMakeSetupDialog.h FirstConfigure.h QCMake.h QCMakeCacheView.h QCMakeWidgets.h QMacInstallDialog.h )] [C:\FGCVS\cmake\Source\QtDialog\CMakeLists.txt]46:55
  'QT4_ADD_RESOURCES'            => \&fn_QT4_ADD_RESOURCES, # act [(RC_SRCS CMakeSetup.qrc)] [C:\FGCVS\cmake\Source\QtDialog\CMakeLists.txt]56:56
  'RESOLVE_QT4_PATHS'            => \&fn_RESOLVE_QT4_PATHS,
  'RETURN'                       => \&fn_RETURN,
  'RTI_MESSAGE_QUIETLY'          => \&fn_RTI_MESSAGE_QUIETLY,
  'SANITYCHECKSDKANDDEPLOYTARGET' => \&fn_SANITYCHECKSDKANDDEPLOYTARGET,
  'SELECT_LIBRARY_CONFIGURATIONS' => \&fn_SELECT_LIBRARY_CONFIGURATIONS,
  'SEPARATE_ARGUMENTS'           => \&fn_SEPARATE_ARGUMENTS,
  'SET'                          => \&fn_SET,
  'SET_BUNDLE_KEY_VALUES'        => \&fn_SET_BUNDLE_KEY_VALUES,
  'SET_COMPILE_FLAGS_VAR'        => \&fn_SET_COMPILE_FLAGS_VAR,
  'SET_DIRECTORY_PROPERTIES'     => \&fn_SET_DIRECTORY_PROPERTIES,
  'SET_IF_NOT_SET'               => \&fn_SET_IF_NOT_SET,
  'SET_IF_SET_AND_NOT_SET'       => \&fn_SET_IF_SET_AND_NOT_SET,
  'SET_LINK_FLAGS_VAR'           => \&fn_SET_LINK_FLAGS_VAR,
  'SET_PACKAGE_INFO'             => \&fn_SET_PACKAGE_INFO,
  'SET_PROPERTY'                 => \&fn_SET_PROPERTY,
  'SET_SOURCE_FILES_PROPERTIES'  => \&fn_SET_SOURCE_FILES_PROPERTIES,
  'SET_TARGET_PROPERTIES'        => \&fn_SET_TARGET_PROPERTIES,
  'SET_TESTS_PROPERTIES'         => \&fn_SET_TESTS_PROPERTIES,
  'SITE_NAME'                    => \&fn_SITE_NAME,
  'STRING'                       => \&fn_STRING,
  'SUBDIRS'                      => \&fn_SUBDIRS,
  'SWIG_ADD_SOURCE_TO_MODULE'    => \&fn_SWIG_ADD_SOURCE_TO_MODULE,
  'SWIG_GET_EXTRA_OUTPUT_FILES'  => \&fn_SWIG_GET_EXTRA_OUTPUT_FILES,
  'SWIG_MODULE_INITIALIZE'       => \&fn_SWIG_MODULE_INITIALIZE,
  'TARGET_LINK_LIBRARIES'        => \&fn_TARGET_LINK_LIBRARIES,
  'TEST_BIG_ENDIAN'              => \&fn_TEST_BIG_ENDIAN,
  'TRY_COMPILE'                  => \&fn_TRY_COMPILE,
  'TRY_REGULAR_COMPILER'         => \&fn_TRY_REGULAR_COMPILER,
  'TRY_RUN'                      => \&fn_TRY_RUN,
  'UNSET'                        => \&fn_UNSET,
  'VERIFY_APP'                   => \&fn_VERIFY_APP,
  'VERIFY_BUNDLE_PREREQUISITES'  => \&fn_VERIFY_BUNDLE_PREREQUISITES,
  'VERIFY_BUNDLE_SYMLINKS'       => \&fn_VERIFY_BUNDLE_SYMLINKS,
  'WHILE'                        => \&fn_WHILE,
  'WRITE_QT4_CONF'               => \&fn_WRITE_QT4_CONF,
  'WX_CLEAR_ALL_DBG_LIBS'        => \&fn_WX_CLEAR_ALL_DBG_LIBS,
  'WX_CLEAR_ALL_LIBS'            => \&fn_WX_CLEAR_ALL_LIBS,
  'WX_CLEAR_ALL_REL_LIBS'        => \&fn_WX_CLEAR_ALL_REL_LIBS,
  'WX_CLEAR_LIB'                 => \&fn_WX_CLEAR_LIB,
  'WX_CONFIG_SELECT_GET_DEFAULT' => \&fn_WX_CONFIG_SELECT_GET_DEFAULT,
  'WX_CONFIG_SELECT_QUERY_BOOL'  => \&fn_WX_CONFIG_SELECT_QUERY_BOOL,
  'WX_CONFIG_SELECT_SET_OPTIONS' => \&fn_WX_CONFIG_SELECT_SET_OPTIONS,
  'WX_FIND_LIBS'                 => \&fn_WX_FIND_LIBS,
  'WX_GET_DEPENDENCIES_FROM_XML' => \&fn_WX_GET_DEPENDENCIES_FROM_XML,
  'WX_GET_NAME_COMPONENTS'       => \&fn_WX_GET_NAME_COMPONENTS,
  'WX_SET_LIBRARIES'             => \&fn_WX_SET_LIBRARIES,
  'WX_SPLIT_ARGUMENTS_ON'        => \&fn_WX_SPLIT_ARGUMENTS_ON,
  '_BOOST_ADJUST_LIB_VARS'       => \&fn__BOOST_ADJUST_LIB_VARS,
  '_BOOST_CHECK_SPELLING'        => \&fn__BOOST_CHECK_SPELLING,
  '_BOOST_COMPILER_DUMPVERSION'  => \&fn__BOOST_COMPILER_DUMPVERSION,
  '_BOOST_MARK_COMPONENTS_FOUND' => \&fn__BOOST_MARK_COMPONENTS_FOUND,
  '_BOOST_PREPEND_LIST_WITH_THREADAPI' => \&fn__BOOST_PREPEND_LIST_WITH_THREADAPI,
  '_BOOST_SWAP_WITH_REALPATH'    => \&fn__BOOST_SWAP_WITH_REALPATH,
  '_BULLET_APPEND_LIBRARIES'     => \&fn__BULLET_APPEND_LIBRARIES,
  '_CHECK_CXX_COMPILER_ATTRIBUTE' => \&fn__CHECK_CXX_COMPILER_ATTRIBUTE,
  '_CHECK_SYMBOL_EXISTS'         => \&fn__CHECK_SYMBOL_EXISTS,
  '_DETERMINEVSSERVICEPACKFROMCOMPILER' => \&fn__DETERMINEVSSERVICEPACKFROMCOMPILER,
  '_DETERMINEVSSERVICEPACK_CHECKVERSIONWITHTRYCOMPILE' => \&fn__DETERMINEVSSERVICEPACK_CHECKVERSIONWITHTRYCOMPILE,
  '_DETERMINEVSSERVICEPACK_CHECKVERSIONWITHTRYRUN' => \&fn__DETERMINEVSSERVICEPACK_CHECKVERSIONWITHTRYRUN,
  '_DETERMINEVSSERVICEPACK_FASTCHECKVERSIONWITHCOMPILER' => \&fn__DETERMINEVSSERVICEPACK_FASTCHECKVERSIONWITHCOMPILER,
  '_DETERMINE_GCC_SYSTEM_INCLUDE_DIRS' => \&fn__DETERMINE_GCC_SYSTEM_INCLUDE_DIRS,
  '_DO_GENERATE_EXPORT_HEADER'   => \&fn__DO_GENERATE_EXPORT_HEADER,
  '_DO_SET_MACRO_VALUES'         => \&fn__DO_SET_MACRO_VALUES,
  '_EP_ADD_BUILD_COMMAND'        => \&fn__EP_ADD_BUILD_COMMAND,
  '_EP_ADD_CONFIGURE_COMMAND'    => \&fn__EP_ADD_CONFIGURE_COMMAND,
  '_EP_ADD_DOWNLOAD_COMMAND'     => \&fn__EP_ADD_DOWNLOAD_COMMAND,
  '_EP_ADD_INSTALL_COMMAND'      => \&fn__EP_ADD_INSTALL_COMMAND,
  '_EP_ADD_MKDIR_COMMAND'        => \&fn__EP_ADD_MKDIR_COMMAND,
  '_EP_ADD_PATCH_COMMAND'        => \&fn__EP_ADD_PATCH_COMMAND,
  '_EP_ADD_TEST_COMMAND'         => \&fn__EP_ADD_TEST_COMMAND,
  '_EP_ADD_UPDATE_COMMAND'       => \&fn__EP_ADD_UPDATE_COMMAND,
  '_EP_GET_BUILD_COMMAND'        => \&fn__EP_GET_BUILD_COMMAND,
  '_EP_GET_CONFIGURATION_SUBDIR_SUFFIX' => \&fn__EP_GET_CONFIGURATION_SUBDIR_SUFFIX,
  '_EP_GET_CONFIGURE_COMMAND_ID' => \&fn__EP_GET_CONFIGURE_COMMAND_ID,
  '_EP_GET_GIT_VERSION'          => \&fn__EP_GET_GIT_VERSION,
  '_EP_IS_DIR_EMPTY'             => \&fn__EP_IS_DIR_EMPTY,
  '_EP_PARSE_ARGUMENTS'          => \&fn__EP_PARSE_ARGUMENTS,
  '_EP_REPLACE_LOCATION_TAGS'    => \&fn__EP_REPLACE_LOCATION_TAGS,
  '_EP_SET_DIRECTORIES'          => \&fn__EP_SET_DIRECTORIES,
  '_EP_WRITE_DOWNLOADFILE_SCRIPT' => \&fn__EP_WRITE_DOWNLOADFILE_SCRIPT,
  '_EP_WRITE_EXTRACTFILE_SCRIPT' => \&fn__EP_WRITE_EXTRACTFILE_SCRIPT,
  '_EP_WRITE_GITCLONE_SCRIPT'    => \&fn__EP_WRITE_GITCLONE_SCRIPT,
  '_EP_WRITE_INITIAL_CACHE'      => \&fn__EP_WRITE_INITIAL_CACHE,
  '_EP_WRITE_LOG_SCRIPT'         => \&fn__EP_WRITE_LOG_SCRIPT,
  '_EP_WRITE_VERIFYFILE_SCRIPT'  => \&fn__EP_WRITE_VERIFYFILE_SCRIPT,
  '_FIND_BULLET_LIBRARY'         => \&fn__FIND_BULLET_LIBRARY,
  '_FIND_ECLIPSE_VERSION'        => \&fn__FIND_ECLIPSE_VERSION,
  '_FPHSA_FAILURE_MESSAGE'       => \&fn__FPHSA_FAILURE_MESSAGE,
  '_FPHSA_HANDLE_FAILURE_CONFIG_MODE' => \&fn__FPHSA_HANDLE_FAILURE_CONFIG_MODE,
  '_FS_GET_FEATURE_SUMMARY'      => \&fn__FS_GET_FEATURE_SUMMARY,
  '_GTEST_APPEND_DEBUGS'         => \&fn__GTEST_APPEND_DEBUGS,
  '_GTEST_FIND_LIBRARY'          => \&fn__GTEST_FIND_LIBRARY,
  '_GTK2_FIND_INCLUDE_DIR'       => \&fn__GTK2_FIND_INCLUDE_DIR,
  '_GTK2_FIND_LIBRARY'           => \&fn__GTK2_FIND_LIBRARY,
  '_GTK2_GET_VERSION'            => \&fn__GTK2_GET_VERSION,
  '_HDF5_INVOKE_COMPILER'        => \&fn__HDF5_INVOKE_COMPILER,
  '_HDF5_PARSE_COMPILE_LINE'     => \&fn__HDF5_PARSE_COMPILE_LINE,
  '_KDE3_ADD_ICON_INSTALL_RULE'  => \&fn__KDE3_ADD_ICON_INSTALL_RULE,
  '_PKGCONFIG_INVOKE'            => \&fn__PKGCONFIG_INVOKE,
  '_PKGCONFIG_INVOKE_DYN'        => \&fn__PKGCONFIG_INVOKE_DYN,
  '_PKGCONFIG_PARSE_OPTIONS'     => \&fn__PKGCONFIG_PARSE_OPTIONS,
  '_PKGCONFIG_SET'               => \&fn__PKGCONFIG_SET,
  '_PKGCONFIG_UNSET'             => \&fn__PKGCONFIG_UNSET,
  '_PKG_CHECK_MODULES_INTERNAL'  => \&fn__PKG_CHECK_MODULES_INTERNAL,
  '_PROTOBUF_FIND_LIBRARIES'     => \&fn__PROTOBUF_FIND_LIBRARIES,
  '_QT4_ADJUST_LIB_VARS'         => \&fn__QT4_ADJUST_LIB_VARS,
  '_QT4_QUERY_QMAKE'             => \&fn__QT4_QUERY_QMAKE,
  '_REMOVE_DUPLICATES_FROM_BEGINNING' => \&fn__REMOVE_DUPLICATES_FROM_BEGINNING,
  '_SET_LIBRARY_NAME'            => \&fn__SET_LIBRARY_NAME,
  '_TEST_COMPILER_HAS_DEPRECATED' => \&fn__TEST_COMPILER_HAS_DEPRECATED,
  '_TEST_COMPILER_HIDDEN_VISIBILITY' => \&fn__TEST_COMPILER_HIDDEN_VISIBILITY,
  '__AIX_COMPILER_GNU'           => \&fn___AIX_COMPILER_GNU,
  '__AIX_COMPILER_XL'            => \&fn___AIX_COMPILER_XL,
  '__BLUEGENEP_SET_DYNAMIC_FLAGS' => \&fn___BLUEGENEP_SET_DYNAMIC_FLAGS,
  '__BLUEGENEP_SET_STATIC_FLAGS' => \&fn___BLUEGENEP_SET_STATIC_FLAGS,
  '__BORLAND_LANGUAGE'           => \&fn___BORLAND_LANGUAGE,
  '__CHECK_TYPE_SIZE_IMPL'       => \&fn___CHECK_TYPE_SIZE_IMPL,
  '__COMPILER_GNU'               => \&fn___COMPILER_GNU,
  '__COMPILER_PATHSCALE'         => \&fn___COMPILER_PATHSCALE,
  '__COMPILER_PGI'               => \&fn___COMPILER_PGI,
  '__COMPILER_SCO'               => \&fn___COMPILER_SCO,
  '__COMPILER_XL'                => \&fn___COMPILER_XL,
  '__CYGWIN_COMPILER_GNU'        => \&fn___CYGWIN_COMPILER_GNU,
  '__DARWIN_COMPILER_GNU'        => \&fn___DARWIN_COMPILER_GNU,
  '__HPUX_COMPILER_GNU'          => \&fn___HPUX_COMPILER_GNU,
  '__HPUX_COMPILER_HP'           => \&fn___HPUX_COMPILER_HP,
  '__JAVA_COPY_FILE'             => \&fn___JAVA_COPY_FILE,
  '__LINUX_COMPILER_GNU'         => \&fn___LINUX_COMPILER_GNU,
  '__LINUX_COMPILER_INTEL'       => \&fn___LINUX_COMPILER_INTEL,
  '__LINUX_COMPILER_PATHSCALE'   => \&fn___LINUX_COMPILER_PATHSCALE,
  '__LINUX_COMPILER_PGI'         => \&fn___LINUX_COMPILER_PGI,
  '__SUNOS_COMPILER_GNU'         => \&fn___SUNOS_COMPILER_GNU,
  '__WINDOWS_COMPILER_GNU'       => \&fn___WINDOWS_COMPILER_GNU,
  '__WINDOWS_COMPILER_GNU_ABI'   => \&fn___WINDOWS_COMPILER_GNU_ABI,
  '__WINDOWS_COMPILER_INTEL'     => \&fn___WINDOWS_COMPILER_INTEL
);

sub get_ref_directory_hash() {
    # my $rdh = \%cmake_directives;
    my $rdh = \%directive_hash;
    return $rdh;
}

sub is_a_known_directive($) {
    my $dir = shift;
    my $rdh = get_ref_directory_hash();
    ### return 1 if (defined $cmake_directives{$dir});
    return 1 if ( defined ${$rdh}{$dir} );
    return 0;
}

sub get_directive_function($) {
    my $dir = shift;
    my $rdh = get_ref_directory_hash();
    ### return 1 if (defined $cmake_directives{$dir});
    return ${$rdh}{$dir} if ( defined ${$rdh}{$dir} );
    return undef;
}


# LOT OF EFFORT ON THIS ;=()
# FINAL - generalized version - which maybe works, and can be extended
sub is_quote_char_unescaped2($$$$$) {
    my ($rh,$ch,$pc,$pc2,$line) = @_;
    my $dbg_flag =  0;
    my $iret = 0;
    if (defined ${$rh}{'CURR_DBG_FLAG'}) {
        $dbg_flag = ${$rh}{'CURR_DBG_FLAG'};
    }
    my $lnn = ${$rh}{'CURR_LNN'};
    #return 1 if ( ($ch eq '"') && ( ($pc ne "\\") || ( ($pc eq "\\")&&($pc2 eq "\\") ) ) );
    if ($ch eq '"') {
        $iret = 1;  # have a QUOTE char unless ESCAPED
        prt("[d16]2 $lnn: Got [$pc2$pc$ch]   ") if ($dbg_flag & 16);
        if ($pc ne "\\") {
            prt("Return 1 since previous NOT '\\' NO ESCAPE\n") if ($dbg_flag & 16);
        } elsif ( ($pc eq "\\")&&($pc2 eq "\\") ) {
            # but need to backtrack further in the line forming
            #                        6   5   4   3   2   1
            #                        ?   \   \   \   \   "
            #                        pc5 pc4 pc3 pc2 pc1 ch
            my $len = length($line);
            my $pc3 = (($len >= 4) ? substr($line,($len-4),1) : '');
            if ($pc3 eq "\\") {
                my $pc4 = (($len >= 5) ? substr($line,($len-5),1) : '');
                if ($pc4 eq "\\") {
                    my $pc5 = (($len >= 6) ? substr($line,($len-6),1) : '');
                    if ($pc5 eq "\\") {
                        prt("Return 0 due both are '\\', like pc3 and pc4, and prev pc5\n") if ($dbg_flag & 16);
                        $iret = 0;
                    } else {
                        prt("Return 1 due both are '\\', like pc3 and pc4, but not pc4=$pc4\n") if ($dbg_flag & 16);
                    }
                } else {
                    # but this BREAKS on simple "\\\"" 
                    # from [C:\Program Files (x86)\CMake 2.8\share\cmake-2.8\Modules\FindCUDA\run_nvcc.cmake]132
                    # prt("Return 1 since both are '\\', as is pc3 but not pc4\n") if ($dbg_flag & 16);
                    # so
                    prt("Return 0 since both are '\\', as is pc3 but not pc4=$pc4\n") if ($dbg_flag & 16);
                    $iret = 0;
                }
            } else {
                prt("Return 1 since both are '\\', but pc3=$pc3 is NOT\n") if ($dbg_flag & 16);
                ###prt("Return 0 since both are '\\', but pc3 is NOT\n") if ($dbg_flag & 16);
                ###$iret = 0;
            }
        } else {
            prt("Return 0 since pc2 not '\\' QUOTE ESCAPED\n") if ($dbg_flag & 16);
            $iret = 0;

        }
    }
    return $iret;
}

sub is_quote_char_unescaped_NEARLY_ok_BUT($$$) {
    # UGH: still FAILED on string(REPLACE "\"" "\\\"" arg ${arg})
    my ($ch,$pc,$pc2) = @_;
    return 1 if ( ($ch eq '"') && ( ($pc ne "\\") || ( ($pc eq "\\")&&($pc2 eq "\\") ) ) );
    return 0;
}
sub is_quote_char_unescaped($$$$$$$) {
    my ($rh,$ch,$pc,$pc2,$pc3,$pc4,$line) = @_;
    my $dbg_flag =  0;
    my $iret = 0;
    if (defined ${$rh}{'CURR_DBG_FLAG'}) {
        $dbg_flag = ${$rh}{'CURR_DBG_FLAG'};
    }
    my $lnn = ${$rh}{'CURR_LNN'};
    #return 1 if ( ($ch eq '"') && ( ($pc ne "\\") || ( ($pc eq "\\")&&($pc2 eq "\\") ) ) );
    if ($ch eq '"') {
        $iret = 1;  # have a QUOTE char unless ESCAPED
        prt("[d16] $lnn: Got [$pc4$pc3$pc2$pc$ch]   ") if ($dbg_flag & 16);
        if ($pc ne "\\") {
            prt("Return 1 since previous NOT '\\' NO ESCAPE\n") if ($dbg_flag & 16);
        } elsif ( ($pc eq "\\")&&($pc2 eq "\\") ) {
            if ($pc3 eq "\\") {
                if ($pc4 eq "\\") {
                    # but need to backtrack further in the line forming
                    #                        6  5    4   3   2  1
                    #                           \    \   \   \  "
                    #                        ?  pc4 pc3 pc2 pc1 ch
                    my $len = length($line);
                    if ($len < 6) {
                        prt("Return 1 due both are '\\', and so are pc3 and pc4, and no prev len\n") if ($dbg_flag & 16);
                    } else {
                        my $tch = substr($line,($len - 6),1);
                        if ($tch eq "\\") {
                            prt("Return 0 due both are '\\', like pc3 and pc4, and prev [$tch]\n") if ($dbg_flag & 16);
                            $iret = 0;
                        } else {
                            prt("Return 1 due both are '\\', like pc3 and pc4, and not prev [$tch]\n") if ($dbg_flag & 16);
                        }
                    }
                } else {
                    # but this BREAKS on simple "\\\"" 
                    # from [C:\Program Files (x86)\CMake 2.8\share\cmake-2.8\Modules\FindCUDA\run_nvcc.cmake]132
                    # prt("Return 1 since both are '\\', as is pc3 but not pc4\n") if ($dbg_flag & 16);
                    # so
                    prt("Return 0 since both are '\\', as is pc3 but not pc4\n") if ($dbg_flag & 16);
                    $iret = 0;
                }
            } else {
                prt("Return 1 since both are '\\', but pc3 is NOT\n") if ($dbg_flag & 16);
                ###prt("Return 0 since both are '\\', but pc3 is NOT\n") if ($dbg_flag & 16);
                ###$iret = 0;
            }
        } else {
            prt("Return 0 since pc2 not '\\' QUOTE ESCAPED\n") if ($dbg_flag & 16);
            $iret = 0;

        }
    }
    my $tret = is_quote_char_unescaped2($rh,$ch,$pc,$pc2,$line);
    pgm_exit(1,"ERROR: DIFFERENCE between current and version 2!\nline [$line]\n") if ($tret != $iret);
    return $iret;
}

sub clean_cmake_raw_lines($) {
    my $rh = shift;
    my @clines = ();    # cleaned, trimmed CMake lines
    my @warns = ();
    my $rclines = \@clines;
    my ($rwarns,$msg);
    my $rlines = ${$rh}{"BASE_LINES"};
    if ( defined ${$rh}{'CURR_WARNINGS'} ) {
        $rwarns = ${$rh}{'CURR_WARNINGS'};
    } else {
        $rwarns = \@warns;
        ${$rh}{'CURR_WARNINGS'} = $rwarns;
    }
    my $dbg_flag =  0;
    ${$rh}{"CLEAN_LINES"} = $rclines;
    if (defined ${$rh}{'CURR_DBG_FLAG'}) {
        $dbg_flag = ${$rh}{'CURR_DBG_FLAG'};
    } else {
        ${$rh}{'CURR_DBG_FLAG'} = $dbg_flag;
    }
    my $bfile = ${$rh}{'BASE_FILE'};
    my $lncnt = scalar @{$rlines};
    ${$rh}{"ACT_LCNT"} = $lncnt;

    prt("[d8] Loaded $lncnt lines from [$bfile]\n") if ($dbg_flag & 8);
    my ($lnn,$trline,$line,$len,$j,$ch,$inquot,$pc,$pc2,$tag,@braces2,$gottag,$action);
    my ($tmp,$bq,$brcnt,$ln,$scnt,$ind,$tlen,$brcyc,$ucdir,$rlbr2,$elin,$pc3,$pc4);
    my ($bgnln,$endln);
    my $csrc = $bfile;
    $pc3 = '';
    $pc2 = '';
    $pc = '';
    $ch = '';
    $tag = '';
    $inquot = 0;
    @braces2 = ();
    $gottag = 0;
    $line = '';
    $j = 0;
    $len = 0;
    $scnt = 0;
    $ind = 0;
    $brcyc = 0;
    $elin = '';
    $lnn = 0;
    ${$rh}{'CURR_LNN'} = $lnn;
    $bgnln = 0;
    $endln = 0;
    for ($ln = 0; $ln < $lncnt; $ln++) {
        if (($len == 0) || ($j >= $len)) {
            # time for a NEW line to be extracted
            $lnn = $ln + 1;
            ${$rh}{'CURR_LNN'} = $lnn;
            $bgnln = $ln + 1;
            $trline = ${$rlines}[$ln];  # extract file line
            chomp $trline;              # clean end
            $trline = trim_all($trline);# clean ALL
            $msg = "[d8] $lnn: Loaded line [";
            $ind = length($msg);
            $msg .= "$trline]";
            prt("$msg\n") if ($dbg_flag & 8);
            next if ($trline =~ /^\#/); # skip comments
            $len = length($trline);     # get length
            next if ($len == 0);        # skip blank lines
            if ($trline =~ /^\@\w+\@$/) {
                # example - ALSO NOTE TRAILING comment '# list'
                # set(CUDA_NVCC_FLAGS @CUDA_NVCC_FLAGS@ ;; @CUDA_WRAP_OPTION_NVCC_FLAGS@) # list
                # @CUDA_NVCC_FLAGS_CONFIG@
                # set(nvcc_flags @nvcc_flags@) # list
                # ***TBD*** What to do with THIS??????
                push(@{$rclines},[$trline,"","",$bgnln,$bgnln]);
                $len = 0;
                next;   # and load NEXT line
            }
            $j = 0; # restart processing of the line data char by char
            $tag = '';  # no DIRECTIVE yet
        } else {
            # continuing an existing line after close of braces - sometimes a comment there...
            for (; $j < $len; $j++) {
                $pc4 = $pc3;
                $pc3 = $pc2;
                $pc2 = $pc;
                $pc = $ch;
                $ch = substr($trline,$j,1);
                last if ($ch =~ /\S/);
            }
            if ($ch eq '#') {
                $tmp = substr($trline,$j);
                prt("[d2] $lnn: Skipping BALANCE of line [$tmp]\n") if ($dbg_flag & 2);
                $j = $len;
            } else {
                $tmp = substr($trline,$j);
                prt("[d2] $lnn: Processing BALANCE of line [$tmp]\n") if ($dbg_flag & 2);
            }
            $len = 0;
            $ln-- if ($ln); # This tail processing should have been done at END, but ok now....
            next;   # got an GET next line
        }
        # line processing
        for (; $j < $len; $j++) {
            $pc4 = $pc3;
            $pc3 = $pc2;
            $pc2 = $pc;
            $pc = $ch;
            $ch = substr($trline,$j,1);
            last if ($ch =~ /\W/);  # END OF DIRECTIVE
            $line .= $ch;   # add to clean line
            $tag .= $ch;    # and accumulate the directive
        }
        if (length($tag) == 0) {
            pgm_exit(1,"ERROR: Parsing FAILED! No 'directive' found! [$bfile]$lnn\n");
        }

        $ucdir = uc($tag);

        # continue eating any spaces
        for (; $j < $len; $j++) {
            $pc4 = $pc3;
            $pc3 = $pc2;
            $pc2 = $pc;
            $pc = $ch;
            $ch = substr($trline,$j,1);
            last if ($ch =~ /\S/);
        }
        # this should be the BEGINNING of a directive (... until ...) end
        if ($ch eq '(') {
            $line .= $ch;
            @braces2 = ();
            push(@braces2,[$ch,$lnn,$j]);
            $brcnt = scalar @braces2;
            $j++;
            if ($dbg_flag & 4) {
                $tmp = $j + $ind;
                $msg = ' ' x $tmp;
                $msg .= "<- BEGIN BRACKETS bc=$brcnt";
                prt("$msg\n");
            }
            $action = $ch;  # start the action
            $inquot = 0;
            $elin = '';
            # continue on the line - skip over quote "..."
            $pc = '';
            for (; $j < $len; $j++) {
                $pc4 = $pc3;
                $pc3 = $pc2;
                $pc2 = $pc;
                $pc = $ch;
                $ch = substr($trline,$j,1);
                $action .= $ch; # add character to 'action', within braces
                $line .= $ch;
                $elin .= $ch;
                if ($inquot) {
                    $inquot = 0 if (is_quote_char_unescaped($rh,$ch,$pc,$pc2,$pc3,$pc4,$line));
                    if ($inquot == 0) {
                        if ($dbg_flag & 8) {
                            $tmp = $j + $ind + 1;
                            $msg = ' ' x $tmp;
                            $msg .= "<- END QUOTE";
                            prt("$msg\n");
                        }
                    #} elsif ($ch eq ')') {
                    #    # crazy exception
                    #    $tmp = scalar @braces;
                    #    if (($tmp == 1)&&($j == ($bq + 1))) {
                    #        prt("Special exceptional quote close!\n");
                    #        pop @braces;
                    #        $brcnt = scalar @braces;
                    #        $inquot = 0;
                    #    } else {
                    #        prt("Closing brace in QUOTES ignored bq=$bq j=$j bc=$tmp\n");
                    #    }
                    }
                } else {
                    if ($ch eq '(') {
                        push(@braces2,[$ch,$lnn,$j]);
                        $brcnt = scalar @braces2;
                        if ($dbg_flag & 4) {
                            $tmp = $j + $ind;
                            $msg = ' ' x $tmp;
                            $msg .= "<- BEGIN BRACKETS bc=$brcnt";
                            prt("$msg\n");
                        }
                    } elsif ($ch eq ')') {
                        if (@braces2) {
                            $rlbr2 = pop @braces2;    # pop this brace
                            $brcnt = scalar @braces2;
                            if ($dbg_flag & 4) {
                                $tmp = ${$rlbr2}[2];
                                $tmp += length($elin);
                                $tmp++; # bump one
                                $msg = ' ' x ($tmp + $ind);
                                $msg .= "<- END BRACKETS bc=$brcnt";
                                prt("$msg\n");
                            }
                        } else {
                            $msg = "WARNING: Encountered ')' with none on stack! $line [$bfile]$lnn";
                            if ($csrc ne $bfile) {
                                $msg .= " src [$csrc]";
                            }
                            prtw("$msg\n");
                        }
                        $brcnt = scalar @braces2;
                        if ($brcnt == 0) {
                            $j++;   # bump past this closing char
                            last;   # done this part of the line
                        }
                    } elsif (is_quote_char_unescaped($rh,$ch,$pc,$pc2,$pc3,$pc4,$line)) {
                        $inquot = 1;
                        $bq = $j;
                        if ($dbg_flag & 8) {
                            $msg = ' ' x ($j+1+$ind);
                            $msg .= "<- BEGIN QUOTE";
                            prt("$msg\n");
                        }
                    }
                }
            }   # continue processing first line
            # done the line
            prt("[d8] $lnn: Got tag [$tag] act [$action] brcnt=$brcnt iq=$inquot\n") if ($dbg_flag & 8);
            prtw("WARNING: [d10] $lnn: End of LINE while still in QUOTES! bc=$brcnt\n") if ($inquot && ($dbg_flag & 0x10));
            $brcyc = 0;
            $elin = '';
            while ($brcnt) {
                # but are in OPEN braces, so continue to NEXT line/lines until $brcnt is ZERO
                $ln++;  # bump tp NEXT line
                $brcyc++;
                $lnn = $ln + 1;
                $action .= ' ';
                if ($ln < $lncnt) {
                    $line .= ' ' if ($line =~ /\S$/);   # 30/04/2012 - ADD space to line, if NOT ending space
                    $trline = ${$rlines}[$ln]; # get NEXT line
                    chomp $trline;
                    $trline = trim_all($trline);
                    $len = length($trline);
                    $msg = "[d8] $lnn:$brcyc: next line [";
                    $ind = length($msg);
                    $msg .= "$trline] brc=$brcnt iq=$inquot";
                    prt("$msg\n") if ($dbg_flag & 8);
                    if ($trline =~ /^\#/) {
                        prt("[d8] Skipping comment line\n") if ($dbg_flag & 8);
                        next;
                    }
                    # process this NEXT line, again skipping quotes
                    $ch = '';
                    $pc = '';
                    $elin = '';
                    for ($j = 0; $j < $len; $j++) {
                        $pc4 = $pc3;
                        $pc3 = $pc2;
                        $pc2 = $pc;
                        $pc = $ch;
                        $ch = substr($trline,$j,1);
                        $action .= $ch;
                        $line .= $ch;
                        $elin .= $ch;
                        if ($inquot) {
                            $inquot = 0 if (is_quote_char_unescaped($rh,$ch,$pc,$pc2,$pc3,$pc4,$line));
                            if ($inquot == 0) {
                                if ($dbg_flag & 8) {
                                    $tmp = length($elin);
                                    $tmp += $ind;
                                    $msg = ' ' x $tmp;
                                    $msg .= "<- END Quote";
                                    prt("$msg\n");
                                }
                            #} elsif ($ch eq ')') {
                            #    # crazy exception NONE YET
                            #    }
                            }
                        } else {
                            if ($ch eq '(') {
                                push(@braces2,[$ch,$lnn,$j]);
                                $brcnt = scalar @braces2;
                                if ($dbg_flag & 4) {
                                    $msg = ' ' x ($j + 1+ $ind);
                                    $msg .= "<- BEGIN Brackets bc=$brcnt";
                                    prt("$msg\n");
                                }
                            } elsif ($ch eq ')') {
                                if (@braces2) {
                                    $rlbr2 = pop @braces2;
                                    if ($dbg_flag & 4) {
                                        #$tmp = ${$rlbr2}[2];
                                        $tmp = length($elin);
                                        $tmp += $ind;
                                        $msg = ' ' x $tmp;
                                        $msg .= "<- END Brackets br=$brcnt";
                                        prt("$msg\n");
                                    }
                                } else {
                                    $msg = "WARNING: Encountered ')' with none on stack! [$line] [$bfile]$lnn";
                                    $msg .= " src [$csrc]" if ($bfile ne $csrc);
                                    prtw("$msg\n");
                                }
                                $brcnt = scalar @braces2;
                                if ($brcnt == 0) {  # end this line/lines processing, if out of braces
                                    $j++;   # but ensure character count bumped - using this char
                                    last;
                                }
                            } elsif (is_quote_char_unescaped($rh,$ch,$pc,$pc2,$pc3,$pc4,$line)) {
                                $inquot = 1;
                                $bq = $j;
                                if ($dbg_flag & 8) {
                                    $msg = ' ' x ($j+1+$ind);
                                    $msg .= "<- BEGIN Quote";
                                    prt("$msg\n");
                                }
                            }
                        }
                    }
                    prtw("WARNING: [d10] $lnn: End of next LINE while still in QUOTES! bc=$brcnt\n") if ($inquot && ($dbg_flag & 0x10));
                } else {
                    $tmp = max_debug_line($line);
                    my $ra = $braces2[-1];
                    my $blnn = ${$ra}[1];
                    $msg = "WARNING: Ran out of lines in a brace! Began line $blnn\n[$tmp] [$bfile]$lnn";
                    $msg .= " src [$csrc]" if ($bfile ne $csrc);
                    prtw("$msg\n");
                    last;
                }
            }   # while ($brcnt)

            if ($inquot) {
                $tmp = max_debug_line($trline);
                $msg = "WARNING: Ended line in QUOTES! [";
                $tlen = length($msg);
                $msg .= "$tmp] [$bfile]$lnn";
                $msg .= " src [$csrc]" if ($bfile ne $csrc);
                if ($bq < 80) {
                    $msg .= "\n";
                    $msg .= ' ' x ($tlen+$bq+$ind);
                    $msg .= "<- BEGIN HERE";
                }
                push(@{$rwarns},$msg);
                prtw("$msg\n") if ($dbg_flag & 1);
                return 1 if ($dbg_flag & 0x8000);
            }
            $endln = $ln + 1;
            if (length($line) && length($ucdir)) {
                $scnt++;
                prt("[d8] $scnt: Storing [$ucdir] [$action] [j=$j len=$len]\n") if ($dbg_flag & 8);
                #                 0     1      2       3      4
                push(@{$rclines},[$line,$ucdir,$action,$bgnln,$endln]);
            } else {
                prtw("WARNING: Have no DIRECTIVE length, or no line length! [$bfile]$lnn\n");
            }
            $line = '';
            $tag = '';
            $action = '';
        } else {
            $msg = "WARNING: First char after directive NOT '('! [$line] [$bfile]$lnn";
            $msg .= " src [$csrc]" if ($bfile ne $csrc);
            push(@{$rwarns},$msg);
            prtw("$msg\n") if ($dbg_flag & 1);
            return 1 if ($dbg_flag & 0x8000);
            next;
        }
    }
    return 0;   # return CLEAN cmake script ref array
}


sub load_cmake_script_file($) {
    my $rh = shift;
    my @lines = ();     # actual raw FILE lines
    my @clines = ();    # cleaned, trimmed CMake lines
    my @warns = ();
    my $rlines = \@lines;
    my $rclines = \@clines; # put CLEAN lines in HERE
    my ($rwarns,$msg);
    if ( defined ${$rh}{'CURR_WARNINGS'} ) {
        $rwarns = ${$rh}{'CURR_WARNINGS'};
    } else {
        $rwarns = \@warns;
        ${$rh}{'CURR_WARNINGS'} = $rwarns;
    }
    my $dbg_flag =  0;
    ${$rh}{"BASE_LINES"} = $rlines;
    ${$rh}{"CLEAN_LINES"} = $rclines;   # save reference
    if (defined ${$rh}{'CURR_DBG_FLAG'}) {
        $dbg_flag = ${$rh}{'CURR_DBG_FLAG'};
    } else {
        ${$rh}{'CURR_DBG_FLAG'} = $dbg_flag;
    }
    my $bfile = ${$rh}{'BASE_FILE'};
    if (! open INF, "<$bfile") {
        prtw("WARNING: Unable to open file [$bfile]!\n");
        return 1;
    }
    @{$rlines} = <INF>;
    close INF;
    return clean_cmake_raw_lines($rh);
}

# ==============================================================================
# ******************************************************************************

sub is_a_loaded_macro2($$$$) {
    my ($tag,$rh,$rargs,$rmacro) = @_;
    my $dbg_flag = get_cmake_dbg_flag($rh);
    my $iret = 0;
    my $rmh = ${$rh}{'CMAKE_MACROS'};
    # if (defined ${$rma}{$mac}) {
    #                  0     1
    # ${$rma}{$mac} = [$args,$macro];
    my $min = 0;
    my $max = 32;
    my ($mac,$len,$rma,$args,$macro);
    my @arr = keys(%{$rmh});
    my $cnt = scalar @arr;
    # prt("\nDisplay of $cnt MACROS collected...\n");
    foreach $mac (@arr) {
        $rma = ${$rmh}{$mac};
        $args = ${$rma}[0];
        $macro = ${$rma}[1];
        #prt("$mac $args [$macro}\n");
        if ($tag eq uc($mac)) {
            $iret = 1;
            ${$rargs} = $args;
            ${$rmacro} = $macro;
            last;
        }
    }
    #if ($tag eq 'ADD_CMAKEONLY_TEST') {
    #    if ($iret) {
    #        prtw("WARNING: MACRO [$tag] NOT PROCESSED, FOUND in\n[".join(" ",sort @arr)."]!\n");
    #    } else {
    #        prtw("WARNING: MACRO [$tag] NOT FOUND in\n[".join(" ",sort @arr)."]????\n");
    #    }
    #}
    return $iret;
}

sub cmake_clean_action2($) {
    my $act = shift;
    $act =~ s/^\(//;
    $act =~ s/\)$//;
    $act = trim_all($act);
    # 04/05/2012 CAN NOT DO THIS - consider the case of mutiple tokens, like
    # "${VAR}" MATCHES "this" - has quote begin and end. BUT MUST NOT BE REMOVED
    #if (($act =~ /^\"/) && ($act =~ /\"$/)) {
    #	$act = substr($act,1,length($act)-2);   # if ($act =~ /^".*"$/);
    #    $act = trim_all($act);
    #}
    return $act;
}

my $debug_level_proc2 = 0x100 | 0x200 | 0x400;
my $debug_level_load2 = $debug_level_proc2;

sub process_clean_ref_array2($) {    # was process_cmake_script($)
    my $rh = shift;
    if (!defined ${$rh}{'BASE_FILE'}) {
        pgm_exit(1,"ERROR: Ref hash does NOT define 'BASE_FILE'!\n");
    }
    my $bfile = ${$rh}{'BASE_FILE'};
    if (!defined ${$rh}{"CLEAN_LINES"}) {
        prtw("WARNING: No 'CLEAN_LINES' in ref hash. No [$bfile] processing!\n");
        return 1;
    }
    my $rclines = ${$rh}{"CLEAN_LINES"};
    my $csrc   = ${$rh}{'CURR_LINE_SOURCE'};
    my $cnt = scalar @{$rclines};
    my $dbg_flag = 0;
    if (defined ${$rh}{'CURR_DBG_FLAG'}) {
        $dbg_flag = ${$rh}{'CURR_DBG_FLAG'};
    } else {
        ${$rh}{'CURR_DBG_FLAG'} = $debug_level_proc2;
    }
    my $src = $bfile;
    my $dbg = 0;
    if ($csrc eq $bfile) {
        $dbg = ${$rh}{'show_process_dbg'};
    } else {
        # prt("\n") if ($dbg_flag & 0x100);;
        $src = $csrc;
        $dbg = ${$rh}{'show_process_dbg2'};
    }
    prt("[d100] Processing $cnt lines, from [$src]...\n") if (($dbg_flag & 0x100) && $dbg);
    #                   0     1    2       3    4
    # push(@{$rclines},[$line,$tag,$action,$bln,$eln]);
    my ($i,$line,$tag,$action,$func,$bln,$eln,$act,@arr,$tmp,$args,$macro);
    ${$rh}{"ACT_LCNT"} = $cnt;  # lines to process

    for ($i = 0; $i < $cnt; $i++) {
        $line = ${$rclines}[$i][0];
        next if ($line =~ /^\@/);   # skip these for now '@something@
        $tag = ${$rclines}[$i][1];
        $action = ${$rclines}[$i][2];
        $bln = ${$rclines}[$i][3];
        $eln = ${$rclines}[$i][4];
        $act = cmake_clean_action2($action);
        #$act = clean_cmake_action($action);
        @arr = space_split($act);
        ${$rh}{"ACT_TAG"} = $tag;
        ${$rh}{"ACT_ACT"} = $act;
        ${$rh}{"ACT_RA"}  = \@arr;
        ${$rh}{"ACT_LNN"} = $bln;
        ${$rh}{"ACT_LNN"} .= ":$eln" if ($bln != $eln);
        ${$rh}{"ACT_LINE"} = $line;
        ${$rh}{"ACT_CNT"} = scalar @arr;
        ${$rh}{'ACT_I'} = $i; # current line position
        prt("[d80] $bln:$eln: $line\n") if (${$rh}{'per_line_dbg'});
        if (is_a_loaded_macro2($tag,$rh,\$args,\$macro)) {
            prt("[d100] Run MACRO NOT YET CODED! [$tag $args \n[$macro]]\n") if (($dbg_flag & 0x100) && ${$rh}{'show_macro_dbg'});
        } elsif (is_a_known_directive($tag)) {
            $tmp = join(" ",@arr);
            #if ($tag eq 'LIST') {
            #    prt("[d200] Processing DIRECTIVE [$tag] $i of $cnt ($action) ($tmp) $bln:$eln [$src]\n") if ($dbg_flag & 0x200);
            #}
            $func = get_directive_function($tag);
            # =======================================
            $func->($rh); # CALL THE FUNCTION HANDLER
            # =======================================
            $i = ${$rh}{'ACT_I'}; # potentially updated line position
            ###prt("[d400] Done DIRECTIVE [$tag] $i of $cnt\n") if ($dbg_flag & 0x400);
        } else {
            my $rdirh = ${$rh}{'new_directives_found'};   # process_clean_ref_array; was process_cmake_script: adding to \%directives if NOT FOUND
            if (defined ${$rdirh}{$tag}) {
                ${$rdirh}{$tag}++;
                ${$rh}{'warnings_avoided'}++;
            } else {
                ${$rdirh}{$tag} = 1;
                prtw("WARNING: [$tag] is NOT a known directive, nor loaded MACRO act [$action] [$bfile]$bln:$eln\n");
            }
        }

    }

}

# if ($dump_cmake_file) - dump cleaned lines to a debug file
my $add_uctag2 = 1;
my $add_if_depth2 = 0;
my $add_foreach_depth2 = 0;
my $add_macro_depth2 = 0;
my $add_skipped_lines2 = 0;
my $add_line_nums2 = 0;
my $add_tag_action2 = 0;
sub dump_cmake2($) {
    my $rh = shift;
    my ($fh);
    my ($rcln,$line,$clnn,$tag,$tdep);
    if (!defined ${$rh}{'CURR_DUMP_NAME'}) {
        prt("No 'CURR_DUMP_NAME' in hash!\n");
        return;
    }
    my $tmp_cmake = ${$rh}{'CURR_DUMP_NAME'};
    if (!defined ${$rh}{'CURR_DUMP_HANDLE'}) {
        if ( !open($fh,">$tmp_cmake") ) {   # open the TEMP DUMP file
            pgm_exit(1,"ERROR: Unable to OPEN dump [$tmp_cmake]\n");
        }
        ${$rh}{'CURR_DUMP_HANDLE'} = $fh;
        ${$rh}{'CURR_DUMP_NAME'} = $tmp_cmake;
        $line = "# Dianostic DUMP file created: ";
        $line .= lu_get_YYYYMMDD_hhmmss(time());
        print $fh "$line\n"
    }
    $fh = ${$rh}{'CURR_DUMP_HANDLE'};
    my $rclines = ${$rh}{"CLEAN_LINES"};
    my $cnt = scalar @{$rclines};
    my $bfile = ${$rh}{'BASE_FILE'};
    $line = "\nContents of [$bfile] $cnt 'cleaned' lines";
   	print $fh "$line\n";
    $rcln = ${$rclines}[-1];
    my $lnn = ${$rcln}[3];
    my $frm = sprintf("%d",length($lnn));
    $frm = '%'.$frm.'d';
    my $idep = 0;
    my $ind = '';
    my $isif = 0;
    my $pdep = 0;
    my $plnn = 1;
    my $endln = 0;
    my $fedep = 0;
    my $isfe = 0;
    my $pfedep = 0;
    my $comm = '';
    my $cind = "\t";
    my $mcdep = 0;
    my $pmcdep = 0;
    my $ismac = 0;
    my $act = '';
    my $msg = '';
    foreach $rcln (@{$rclines}) {
        #                  0     1      2       3      4
        #push(@{$rclines},[$line,$ucdir,$action,$bgnln,$endln]);
        $line = ${$rcln}[0];
        $tag = ${$rcln}[1];
        $act = ${$rcln}[2];
        $lnn = ${$rcln}[3];
        $endln = ${$rcln}[4];
        $ind = '';
        $isif = 0;
        if ($add_uctag2) {
            $comm = " # $tag $lnn:$endln";
        }
        if ($add_if_depth2) {
            if ($tag eq 'IF') {
                $pdep = $idep;
                $idep++;
                $isif = 1;
            } elsif ($tag eq 'ENDIF') {
                $idep-- if ($idep > 0);
                $pdep = $idep;
                $isif = 1;
            } elsif ($tag eq 'ELSE') {
                $isif = 2;
            } elsif ($tag eq 'ELSEIF') {
                $isif = 3;
            }
            #if ($isif) {
            #    $ind = ' ' x $pdep;
            #} else {
            #    $ind = ' ' x $idep;
            #}
        }
        $isfe = 0;
        if ($add_foreach_depth2) {
            if ($tag eq 'FOREACH') {
                $isfe = 1;
                $pfedep = $fedep;
                $fedep++;
            } elsif ($tag eq 'ENDFOREACH') {
                $isfe = 1;
                $fedep-- if ($fedep);
                $pfedep = $fedep;
            }
        }
        # $add_macro_depth2
        $ismac = 0;
        if ($add_macro_depth2) {
            if ($tag eq 'MACRO') {
                $ismac = 1;
                $pmcdep = $mcdep;
                $mcdep++;
            } elsif ($tag eq 'ENDMACRO') {
                $ismac = 1;
                $mcdep-- if ($mcdep);
                $pmcdep = $mcdep;
            }
        }

        if ($add_if_depth2 || $add_foreach_depth2 || $add_macro_depth2) {
            $tdep = 0;
            if ($isif) {
                $tdep += $pdep;
            } else {
                $tdep += $idep;
            }
            if ($isfe) {
                $tdep += $pfedep;
            } else {
                $tdep += $fedep;
            }
            if ($ismac) {
                $tdep += $pmcdep;
            } else {
                $tdep += $mcdep;
            }
            $ind = $cind x $tdep;
        }

        # collect the INFORMATION
        $msg = '';
        if ($add_skipped_lines2) {
            while ($plnn < $lnn) {
                if ($add_line_nums2) {
                    $clnn = sprintf($frm,$plnn);
                    $msg .= "$clnn: # skipped\n";
                } else {
                    $msg .= "# skipped\n";
                }
                $plnn++;
            }
        }
        if ($add_line_nums2) {
            $clnn = sprintf($frm,$lnn);
            $msg .= "$clnn: $ind$line$comm\n";
            if ($add_tag_action2) {
                $msg .= "$clnn: $ind$tag$act\n";
            }
        } else {
            $msg .= "$ind$line$comm\n";
            if ($add_tag_action2) {
                $msg .= "$ind$tag$act\n";
            }
        }

        if ($add_skipped_lines2) {
            while ($lnn < $endln) {
                $lnn++;
                if ($add_line_nums2) {
                    $clnn = sprintf($frm,$lnn);
                    $msg .= "$clnn:\n";
                } else {
                    $msg .= "\n";
                }
            }
        }
        # output of the INFORMATION
        # ============================================
        print $fh $msg;
        # ============================================
        $plnn = $lnn + 1;   # update line number
    }
    $line = "# eof - from [$bfile]";
   	print $fh "$line\n";
}


1;

# eof - lib_cmakeread.pl
