#!/usr/bin/perl -w
# NAME: lib_incinc.pl
# AIM: Get list of INCLUDES in a C/C++ file
# 16/03/2013 - renamed to lib_incinc.pl
# 11/09/2009 - first cut

# remove /* ... */
# and // to end of line
sub delete_comments_from_line($) {
   my ($tln) = shift;
   my $len = length($tln);
   my ($j,$c,$nc);
   my $nln = '';
   for ($j = 0; $j < $len; $j++) {
      $c = substr($tln,$j,1);
      $nc = (($j + 1) < $len) ? substr($tln,$j+1,1) : '';
      if (($c eq '/')&&($nc eq '*')) {
         # stay and EAT comment until end comment
         $j += 2;
         for (; $j < $len; $j++) {
            $c = substr($tln,$j,1);
            $nc = (($j + 1) < $len) ? substr($tln,$j+1,1) : '';
            if (($c eq '*')&&($nc eq '/')) {
               $j++;
               last;
            }
         }
         next;
      } elsif (($c eq '/')&&($nc eq '/')) {
         $j += 2;
         # stay and EAT comment until EOL
         for (; $j < $len; $j++) {
            $c = substr($tln,$j,1);
            if ($c eq "\n") {
               $j--;
               last;
            }
         }
         next;
      }
      $nln .= $c; # add char to 'new' line
   }
   return $nln;
}

sub get_includes_from_rla($) {
    my $ra = shift;
    my @arr = ();
    my ($line,$inc);
    foreach $line (@{$ra}) {
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = trim_all($1);
            $inc = delete_comments_from_line($inc);
            $inc = trim_all($inc);
            push(@arr,$inc);
        }
    }
    return \@arr;
}


sub get_include_file_list($) {
   my ($fil) = shift;
   my ($line,$inc);
   my @arr = ();
   if (open INF, "<$fil") {
      my @lines = <INF>;
      close INF;
      return get_includes_from_rla(\@lines);
   } else {
      prt("ERROR: Can NOT open file [$fil]!\n");
   }
   return \@arr;
}

1;
# eof - lib_incinc.pl
