#!/perl -w
# NAME: lineendings.pl
# AIM: Check the line ending of a file
# 14/10/2013 - update style and functionality
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.2 2013-10-14";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 0;
my $def_file = 'def_file';
my $dbg1 = 0;

### program variables
my @warnings = ();
my $cwd = cwd();
my @fnd_files = ();
my %fnd_hash = ();
my $typ = '';

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}


sub add_2_found {
	my ($ty, $fi) = @_;
	push(@fnd_files, [$ty, $fi]);
	$fnd_hash{$ty} .= '*' if (defined $fnd_hash{$ty});
	$fnd_hash{$ty} .= $fi;
	while (length($ty) < 8) {
		$ty .= ' ';
	}
	prt( "$ty $fi\n" );
}

sub process_directory {
	my ($inf) = shift;
	prt( "Processing $inf folder ...\n" );
	if ( opendir( DIR, $inf ) ) {
		my @files = readdir(DIR);
		closedir DIR;
		foreach my $fl (@files) {
			if (($fl eq '.') || ($fl eq '..')) {
				next;
			}
			my $ff = $inf . "\\" . $fl;
			if (-f $ff) {
				$typ = process_file($ff);
				add_2_found( $typ, $fl );
			}
		}
	} else {
		prt( "ERROR: Could not open folder [$inf] ...\n" );
	}
}

sub process_file {
	my ($if) = shift;
	my $type = "UNKNOWN";
	if (open INF, "<$if") {
		binmode INF;
		my @lines = <INF>;
		close INF;
		my $cnt = scalar @lines;
		prt( "Got $cnt lines to process from [$if] ...\n" ); # if ($dbg1);
		my $crlfcnt = 0;
		my $crcnt = 0;
		my $lfcnt = 0;
		my $ncnt = 0;
		my $lcnt = 0;
		foreach my $line (@lines) {
			$lcnt++;
			my $ll = length($line);
			my $ch = '';
			my $gotcr = 0;
			my $gotlf = 0;
			for (my $i = $ll - 1; $i >= 0; $i--) {
			###for (my $i = 0; $i < $ll; $i++) {
				$ch = substr($line, $i, 1);
				if ($ch eq "\n") {
					$gotlf = 1;
				} elsif ($ch eq "\r") {
					$gotcr = 1;
				} else {
					last;
				}
			}
			if( $gotcr && $gotlf ) {
				$crlfcnt++;
			} elsif ( $gotcr ) {
				$crcnt++;
			} elsif ( $gotlf ) {
				$lfcnt++;
			} else {
				$ncnt++;
			}
		}
		if (($crlfcnt == $cnt)||($crlfcnt == ($cnt - 1))) {
			$type = "CRLF";
		} elsif (($crcnt == $cnt)||($crcnt == ($cnt - 1))) {
			$type = "MAC";
		} elsif (($lfcnt == $cnt)||($lfcnt == ($cnt - 1))) {
			$type = "UNIX";
		} else {
			$type = "MIXED";
		}
		prt( "$type - both=$crlfcnt cr=$crcnt lf=$lfcnt none=$ncnt ...\n" ); # if ($dbg1);

	} else {
		prt( "ERROR: Failed to open [$if] ...\n" );
	}
	return $type;
}

sub process_input() {
    if (-f $in_file) {
        $typ = process_file($in_file);
        add_2_found($typ, $in_file);
    } elsif (-d $in_file) {
        process_directory($in_file);
    } else {
        prt( "ERROR: [$in_file] is NOT file or folder???\n" );
    }
    foreach my $key (keys %fnd_hash) {
        my $val = $fnd_hash{$key};
        $val =~ s/\*/, /g;
        prt( "$key = $val\n" );
    }
}

##########################################
### MAIN ###
parse_args(@ARGV);
process_input();
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if (VERB1());
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if ((length($in_file) ==  0) && $debug_on) {
            $in_file = $def_file;
            prt("Set DEFAULT input to [$in_file]\n");
        }
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if ((! -f $in_file)&&(! -d $in_file)) {
        pgm_exit(1,"ERROR: Unable to find in file or folder [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - lineends.pl
