#!/perl -w
# NAME: linkhtml02.pl
# AIM: Given one input HTML file, parse HTML elements, and show each 'link' given in the file...
# 2010/04/14 - moved main contents to htmllib.pl
# 2010/04/13 - looking good...
# 2010/04/12 - geoff mclane - http://geoffair.net/mperl/
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
unshift(@INC, 'C:\GTools\perl');
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
require 'htmllib.pl' or die "Unable to load htmlib.pl ...\n";
# log file stuff
my ($LF);
my $pgmname = $0;
if ($pgmname =~ /\w{1}:\\.*/) {
    my @tmpsp = split(/\\/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $perl_dir = 'C:\GTools\perl';
my $outfile = $perl_dir."\\temp.$pgmname.txt";
open_log($outfile);

# user variables
my $load_log = 0;
my $def_infile = 'C:/HOMEPAGE/FG/Downloads/scenery-0.9.10.html';
#my $def_infile = 'C:\HOMEPAGE\FG\testpage2.htm';
#my $def_infile = 'C:\HOMEPAGE\FG\Docs\getstart\getstartch9.html';
#my $def_infile = 'C:\HOMEPAGE\FG\Projects\747-JW\index.html';
my $in_file = '';
my $ignore_close_element = 1;   # dangerous - ignoring a close element
my $dbg_flag = 0;
my $options = $ignore_close_element;    # 1 = no_ignore_close_element
my $out_html = $perl_dir."\\temphtml.htm";

### program variables
my $verbosity = 0;
my @warnings = ();
my $cwd = cwd();

# debug
my $dbg01 = 0; # show each item pushed to the stack
my $dbg38 = 0; # prt( "[dbg38] Got [$hr2] = [$txt] [$fil]\n" ) if ($dbg38);
my $dbg39 = 0; # prt( "[dbg39] Got [$hr2] = [$txt] - no inverted commas! [$fil]\n" ) if ($dbg39);

sub VERB1() { return (($verbosity > 0) ? 1 : 0); }
sub VERB5() { return (($verbosity >= 5) ? 1 : 0); }
sub VERB9() { return (($verbosity >= 9) ? 1 : 0); }

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg)
    }
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub show_warnings() {
   if (@warnings) {
      prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
      foreach my $itm (@warnings) {
         prt("$itm\n");
      }
      prt("\n");
   } else {
      prt( "\nNo warnings issued.\n\n" );
   }
}

#########################################
### MAIN ###
parse_args(@ARGV);
prt( "$pgmname: in [$cwd]: Process $in_file...\n" );
my $hash_ref = get_html_file_hash($in_file,$options,$dbg_flag);
list_files_in_hash_ref($hash_ref,$out_html);
pgm_exit(0,"Normal exit(0)");
########################################

sub give_help {
    prt("$pgmname: version 0.0.1 2010-04-06\n");
    prt("Usage: $pgmname [options] in_file_name\n");
    prt("Options:\n");
    prt(" -h (or -?) = THis help, and exit 0\n");
    prt(" -l         = Load log file at end.\n");
    prt(" -v[num]    = Bump, or set verbosity to [num]\n");
    prt("Parse input file, and report any problems...\n");

}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg,$ch);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            $ch = substr($sarg,0,1);
            if ($ch =~ /h/i) {
                give_help();
                pgm_exit(0,"Help exit");
            } elsif ($ch =~ /l/i) {
                $load_log = 1;
                prt("Set to load log at end\n");
            } elsif ($ch =~ /v/i) {
                $sarg = substr($sarg,1);
                if (length($sarg)) {
                    if ($sarg =~ /^\d+$/) {
                        $verbosity = $sarg;
                        prt("Set verbosity to [$verbosity]\n");
                    } else {
                        pgm_exit(1,"Unknown argument [$arg] - verbosity is -v[num]. Try -h for help\n");
                    }
                } else {
                    $verbosity++;
                    prt("Bumped verbosity to [$verbosity]\n");
                }
            } else {
                pgm_exit(1,"Unknown argument [$arg]  Try -h for help\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input file to [$in_file]\n");
        }
        shift @av;
    }
    if (!length($in_file)) {
        $in_file = $def_infile;
        $load_log = 1;
        $verbosity = 9;
        prt("Set DEFAULT input file to [$in_file], and set load_log=1, and verbosity=$verbosity\n");
        
    }
}

# eof - template.pl
