#!/usr/bin/perl -w
# NAME: list3rdParty.pl
# AIM: Given a 3rdParty folder, list contents
# 21/03/2015 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.5 2015-03-21";
my $load_log = 0;
my $in_dir1 = '';
my $verbosity = 0;
my $out_file = '';
my $list_bin = 0;
my $list_libs = 0;
my $list_include = 0;

# ### DEBUG ###
my $debug_on = 0;
my $def_dir1 = 'F:\Projects\software';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn);
    $lnn = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if ($line =~ /\s*#\s*include\s+(.+)$/) {
            $inc = $1;
            prt("$lnn: $inc\n");
        }
    }
}

sub get_dir_contents($$$);

sub get_dir_contents($$$) {
    my ($dir,$rh,$lev) = @_;
    if (!opendir(DIR,$dir)) {
        pgm_exit(1,"Unable to open dir $dir!\n");
    }
    my @files = readdir(DIR);
    closedir(DIR);
    ut_fix_directory(\$dir);
    my ($file,$ff);
    my @fils = ();
    my @dirs = ();
    foreach $file (@files) {
        next if ($file eq '.');
        next if ($file eq '..');
        $ff = $dir.$file;
        if (-d $ff) {
            if (($file eq 'bin')||($file eq 'lib')||($file eq 'include')) {
                push(@dirs,$ff);
            } elsif ($dir =~ /include/) {
                push(@dirs,$ff);
            }
        } elsif (-f $ff) {
            push(@fils,$ff);
        } else {
            prtw("WARNING: Unprocessed item '$ff'!\n");
        }
    }
    my %h = ();
    $h{files} = \@fils;
    $h{dirs}  = \@dirs;
    ${$rh}{$dir} = \%h;

    $file = scalar @fils;
    $ff = scalar @dirs;
    prt("Got $file files, and $ff dirs, from $dir\n") if ($lev == 0);
    foreach $dir (@dirs) {
        get_dir_contents($dir,$rh,$lev+1);
    }
    ###return \%h;
}

sub process_in_dir($) {
    my ($dir1) = @_;
    my %h1 = ();
    get_dir_contents($dir1,\%h1,0);
    my @arr1 = sort keys %h1;
    my $cnt1 = scalar @arr1;
    my ($key1,$rh1,$key2,$rh2,$rfa1,$rfa2,$acnt,$len);
    prt("Keys in dir1 $cnt1...\n");
    prt("\nDir1 $dir1 list...\n");
    $len = length($dir1);
    # prt(join("\n",@arr1)."\n");
    my $msg = '';
    foreach $key1 (@arr1) {
        $rh1 = $h1{$key1};
        $rfa1 = ${$rh1}{files};
        $cnt1 = scalar @{$rfa1};
        next if ($cnt1 == 0);
        $acnt = sprintf("%3d",$cnt1);
        #prt("$key1 has $cnt1 files\n");
        $key1 = substr($key1,$len+1);
        $key1 = '.' if (length($key1) == 0);
        $msg .= "$acnt files in $key1\n";
        if ($list_bin && ($key1 =~ /^bin/)) {
            $msg .= join("\n",@{$rfa1})."\n";
        }
        if ($list_include && ($key1 =~ /^include/)) {
            $msg .= join("\n",@{$rfa1})."\n";
        }
        if ($list_libs && ($key1 =~ /^lib/)) {
            $msg .= join("\n",@{$rfa1})."\n";
        }
    }
    if (length($out_file)) {
        write2file($msg,$out_file);
        prt("List written to $out_file\n");
    } else {
        prt($msg);
    }
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_dir($in_dir1);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    my $verb = VERB2();
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^B/) {
                $list_bin = 1;
            } elsif ($sarg =~ /^I/) {
                $list_include = 1;
            } elsif ($sarg =~ /^L/) {
                $list_libs = 1;
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                $verb = VERB2();
                prt("Verbosity = $verbosity\n") if ($verb);
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if ($verb);
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if ($verb);
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_dir1 = $arg;
            prt("Set input to [$in_dir1]\n") if ($verb);
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if (length($in_dir1) ==  0) {
            $in_dir1 = $def_dir1;
            prt("Set DEFAULT input to [$in_dir1]\n");
        }
    }
    if (length($in_dir1) ==  0) {
        pgm_exit(1,"ERROR: No input directory found in command!\n");
    }
    if (! -d $in_dir1) {
        pgm_exit(1,"ERROR: Unable to find directory [$in_dir1]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-dir\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
    prt(" --Bin         (-B) = List bin files found.\n");
    prt(" --Inc         (-I) = List include files found.\n");
    prt(" --Lib         (-L) = List library files found.\n");
    prt(" Given a 3rdParty directory, show count in bin, include and lib folders\n");
}

# eof - template.pl
