#!/usr/bin/perl -w
# NAME: listhdrs.pl
# AIM: Given an input directory, produce a cmake like header list
# 10/12/2014 - Add to check header IN source files. a WIP
# 27/10/2013 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.2 2014-12-10";
###my $VERS = "0.0.1 2013-03-17";
my $load_log = 0;
my $in_dir = '';
my $verbosity = 0;
my $out_file = '';
my $recursive = 0;
my $in_source = 0;

# ### DEBUG ###
my $debug_on = 0;
my $def_dir = 'def_file';

### program variables
my @warnings = ();
my $cwd = cwd();
my %header_files = ();
my %source_files = ();
my %include_files = ();

my $file_count = 0;
my $dir_count = 0;

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

# 1: trim off '//...' or /* ...
# 2: trim off double quotes, or <...>
sub trim_inc($) {
    my $inc = shift;
    my $len = length($inc);
    my $tinc = '';
    my ($i,$ch,$nc,$i2);
    $ch = '';
    for ($i = 0; $i < $len; $i++) {
        $i2 = $i + 1;
        $ch = substr($inc,$i,1);
        $nc = (($i2 < $len) ? substr($inc,$i2,1) : '');
        if (($ch eq '/')&&(($nc eq '/')||($nc eq '*'))) {
            last;
        }
        $tinc .= $ch;
    }
    $tinc = trim_all($tinc);
    $tinc = substr($tinc,1,length($tinc)-2) if ($tinc =~ /^".*"$/);
    $tinc = substr($tinc,1,length($tinc)-2) if ($tinc =~ /^<.*>$/);
    return $tinc;
}


sub process_in_file($) {
    my ($inf) = @_;
    my @inc_files = ();
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
        return @inc_files;
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n") if (VERB9());
    my ($line,$inc,$lnn,$len,$pc,$ch,$tline,$i,$ff);
    $lnn = 0;
    my $incom = 0;
    my ($name,$dir) = fileparse($inf);
    ut_fix_directory(\$dir);
    my $inc_cnt = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        $line = trim_all($line);
        $len = length($line);
        next if ($len == 0);
        $ch = '';
        $tline = '';
        for ($i = 0; $i < $len; $i++) {
            $pc = $ch;
            $ch = substr($line,$i,1);
            if ($incom) {
                if (($pc eq '*') && ($ch eq '/')) {
                    $incom = 0;
                }
            } elsif (($pc eq '/') && ($ch eq '*')) {
                $tline =~ s/\/$//;
                $incom = 1;
            } elsif (($pc eq '/') && ($ch eq '/')) {
                $tline =~ s/\/$//;
                last;
            } else {
                $tline .= $ch;
            }
        }
        if (!$incom) {
            if ($tline =~ /^\s*#\s*include\s+(.+)$/) {
                $inc = $1;
                $inc = trim_inc($inc);
                $ff = $dir.$inc;
                $inc_cnt++;
                if (-f $ff) {
                    if (defined $include_files{$inc}) {
                        $include_files{$inc}++;
                    } else {
                        $include_files{$inc} = 1;
                        prt("$lnn: $inc\n") if (VERB5());
                    }
                    push(@inc_files,[$inc,$ff,$inc_cnt]);
                } else {
                    push(@inc_files,[$inc,'_NF_',$inc_cnt]);
                }
            }
        }
    }
    return \@inc_files;
}

sub show_headers() {
    my ($file,$cmake,@arr,$cnt,$name,$dir,$ria);
    my ($inc,$ff,$icnt,@arr2,$ra);
    my $allcmake = '';
    @arr = sort keys(%source_files);
    $cnt = scalar @arr;
    prt("Source: $cnt sources...\n");
    my %per_src_incs = ();
    if ($cnt) {
        $cmake = "set(source_SRCS\n";
        foreach $file (@arr) {
            my ($name,$dir) = fileparse($file);
            $ria = process_in_file($file);
            $per_src_incs{$file} = $ria;
            $cmake .= "    $name\n";
        }
        $cmake .= "    )\n";
        prt($cmake);
        $allcmake .= $cmake;

        my %inc_cnts = ();
        foreach $file (@arr) {
            $ria = $per_src_incs{$file};
           foreach $ra (@{$ria}) {
                $inc  = ${$ra}[0];
                $ff   = ${$ra}[1];
                $icnt = ${$ra}[2];
                prt("$inc $ff $icnt\n") if (VERB9());
                if ($ff ne '_NF_') {
                    if (defined $inc_cnts{$inc}) {
                        $inc_cnts{$inc}++;
                    } else {
                        $inc_cnts{$inc} = 1;
                    }
                }
            }
        }
        @arr2 = keys(%inc_cnts);
        my $maxcnt = 0;
        my $maxinc = '';
        foreach $inc (@arr2) {
            $icnt = $inc_cnts{$inc};
            prt("inc: $inc $icnt\n") if (VERB5());
            if ($icnt > $maxcnt) {
                $maxcnt = $icnt;
                $maxinc = $inc;
            }
        }
        prt("Of $cnt sources, the most included was $maxinc $maxcnt\n");

    }
    @arr = sort keys(%include_files);
    $cnt = scalar @arr;
    if ($cnt) {
        prt("Source: $cnt headers...\n");
        $cmake = "set(source_HDRS\n";
        foreach $file (@arr) {
            $file = path_d2u($file);
            $cmake .= "    $file\n";
        }
        $cmake .= "    )\n";
        prt($cmake);
        $allcmake .= $cmake;

    }

    @arr = sort keys(%header_files);
    $cnt = scalar @arr;
    prt("Listing $cnt headers...\n");
    $cmake = "set(header_LIST\n";
    foreach $file (@arr) {
        $file = path_d2u($file);
        $cmake .= "    $file\n";
    }
    $cmake .= "    )\n";
    if (length($out_file)) {
        $allcmake .= $cmake;
        write2file($allcmake,$out_file);
        prt("List written the [$out_file]\n");
    } else {
        prt($cmake);
        prt("No -o out_file specified\n");
    }
}

sub process_in_dir($$);
sub process_in_dir($$) {
    my ($dir,$lev) = @_;
    if (! opendir(DIR, "$dir")) {
        pgm_exit(1,"ERROR: Unable to open directory [$dir]\n"); 
    }
    my @files = readdir(DIR);
    closedir(DIR);
    my $lncnt = scalar @files;
    prt("Processing $lncnt items, in [$dir]...\n");
    my ($file,$ff);
    ut_fix_directory(\$dir);
    $dir = '' if ($dir =~ /^.(\\|\/)$/);
    my @dirs = ();
    $dir_count++;
    foreach $file (@files) {
        next if ($file eq '.');
        next if ($file eq '..');
        $ff = $dir.$file;
        if (-d $ff) {
            push(@dirs,$ff);
        } elsif (-f $ff) {
            $file_count++;
            if (is_c_source($file)) {
                $source_files{$ff} = 1;
            } elsif (is_h_source($file)) {
                $header_files{$ff} = 1;
            }
        } else {
            prtw("WARNING: What is this [$ff]! FIX ME\n");
        }

    }
    if ($recursive) {
        foreach $dir (@dirs) {
            process_in_dir($dir,($lev + 1));
        }
    }
    if ($lev == 0) {
        $lncnt = scalar keys(%header_files);
        prt("Scanned $dir_count directories, found $file_count files, $lncnt are header sources\n");
    }
}


#########################################
### MAIN ###
parse_args(@ARGV);
process_in_dir($in_dir,0);
show_headers();
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if (VERB1());
            } elsif ($sarg =~ /^r/) {
                $recursive = 1;
                prt("Set recursive [$recursive].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_dir = $arg;
            prt("Set input to [$in_dir]\n") if (VERB1());
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if (length($in_dir) ==  0) {
            $in_dir = $def_dir;
            prt("Set DEFAULT input to [$in_dir]\n");
        }
    }
    if (length($in_dir) ==  0) {
        pgm_exit(1,"ERROR: No input directory found in command!\n");
    }
    if (! -d $in_dir) {
        pgm_exit(1,"ERROR: Unable to find in directory [$in_dir]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
#    prt(" --insrc       (-i) = List headers found in sources.\n");
    prt(" --recursive   (-r) = Process all subdirectories.\n");

}

# eof - template.pl
