#!/usr/bin/perl -w
# NAME: map2ll.pl
# AIM: VERY SPECIALIZED! Readm scenery HTML and output wsg84 coordinates of blocks
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.5 2015-01-09";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 1;
my $def_file = 'D:\Scenery\scenery-v2.12.html';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

# Lines of enterest
# <IMG SRC="map-1.0.0.png" WIDTH="720" HEIGHT="450" USEMAP="#map">
# <MAP NAME="map">
# <AREA SHAPE=rect COORDS=360,200,380,225 HREF="http://mirrors.ibiblio.org/pub/mirrors/flightgear/ftp/Scenery-v2.12/e000n00.tgz" ALT="e000n00  48.44 Mb   2/17/2012">
# <AREA SHAPE=rect COORDS=360,175,380,200 HREF="http://mirrors.ibiblio.org/pub/mirrors/flightgear/ftp/Scenery-v2.12/e000n10.tgz" 
# ALT="e000n10  64.96 Mb   2/17/2012">

#             x1   y1  x2   y2

#     co-ords 0    425 20   450, alt lon -180 lat -90, file w180s90
#             -180 -80 -170 -90
# 522 co-ords 0 425 20 450, alt lon -180 lat -90, file w180s90 -180,-80,-170,-90

#     co-ords 700  425 720  450, alt lon 170 lat -90, file e170s90
#              170 -80 180  -90
# 289 co-ords 700 425 720 450, alt lon 170 lat -90, file e170s90 170,-80,180,-90

# 514 co-ords 0     0  20    25, alt lon -180 lat 80, file w180n80
#             -180  90 -170  80
# 514 co-ords 0 0 20 25, alt lon -180 lat 80, file w180n80 -180,90,-170,80

# 289 co-ords 700  425 720  450, alt lon 170 lat -90, file e170s90
#              170 -80 180  -90
# 289 co-ords 700 425 720 450, alt lon 170 lat -90, file e170s90 170,-80,180,-90

#  x 0   == -180
#  x 720 ==  180

#  y 0   ==   90
#  y 450 ==  -90

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn,$len,@arr,$width,$height,$cords,$alt,@ar2,$tmp,@cd);
    my ($ew,$ns,$lon,$lat,$cnt,$x1,$y1,$x2,$y2,$file, $lat1,$lat2,$lon1,$lon2,$file2);
    my ($x,$y,$msg);
    $lnn = 0;
    $width = 720;
    $height = 450;
    my %files = ();
    my $acnt = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        $line = trim_all($line);
        $len = length($line);
        next if ($len == 0);
        if ($line =~ /^<IMG\s+/) {
            @arr = split(/\s+/,$line);
            foreach $inc (@arr) {
                if ($inc =~ /WIDTH=\"(\d+)\"/) {
                    $tmp = $1;
                    if ($width != $tmp) {
                        pgm_exit(1,"Error: Width FAILED got $tmp, should be $width!\n"); 
                    }
                } elsif ($inc =~ /HEIGHT=\"(\d+)\"/) {
                    $tmp = $1;
                    if ($height != $tmp) {
                        pgm_exit(1,"Error: Height FAILED got $tmp, should be $height!\n"); 
                    }
                }
            }
            prt("$lnn: $width x $height\n");
        } elsif ($line =~ /^<AREA\s/) {
            #prt("$lnn: $line\n");
            $acnt++;
            @arr = space_split($line);
            $cords = undef;
            $alt = undef;
            foreach $inc (@arr) {
                if ($inc =~ /^COORDS=/) {
                    $tmp = substr($inc,7);
                    @cd = split(",",$tmp);
                    $cnt = scalar @cd;
                    if ($cnt == 4) {
                        $x1 = $cd[0];
                        $y1 = $cd[1];
                        $x2 = $cd[2];
                        $y2 = $cd[3];
                        $lon1 = (($x1 / $width) * 360) - 180;
                        $lon2 = (($x2 / $width) * 360) - 180;
                        $lat1 = (($y1 / $height) * -180) + 90;
                        $lat2 = (($y2 / $height) * -180) + 90;
                        $cords = $cd[0]." ".$cd[1]." ".$cd[2]." ".$cd[3];
                        $ew = 'e';
                        $ns = 'n';
                        $x = $lon1;
                        if ($x < 0) {
                            $ew = 'w';
                            $x *= -1;
                        }
                        $y = $lat2;
                        if ($y < 0) {
                            $ns = 's';
                            $y *= -1;
                        }
                        $x = '0'.$x while (length($x) < 3);
                        $y = '0'.$y while (length($y) < 2);
                        $file2 = "$ew$x$ns$y";
                    }
                } elsif ($inc =~/ALT=\"(.+)\"/) {
                    @ar2 = split(/\s+/,$1);
                    $file = $ar2[0];
                    if ($file =~ /(e|w)(\d{3})(n|s)(\d{2})/) {
                        $ew = $1;
                        $lon = $2;
                        $ns = $3;
                        $lat = $4;
                        $lon *= -1 if ($ew eq 'w');
                        $lat *= -1 if ($ns eq 's');
                        $alt = "lon $lon lat $lat";
                    }
                }
            }
            if ($cords && $alt) {
                $msg = "$lnn co-ords $cords, alt $alt, file $file ($lon1,$lat1,$lon2,$lat2)";
                if ($file ne $file2) {
                    $msg .= " FAILED! CHECK ME!! $file2";
                    pgm_exit(1,"Error: $msg\n");
                }
                prt("$msg\n") if (VERB9());
                $files{$file} = 1;
            } else {
                foreach $inc (@arr) {
                    prt("$inc\n");
                }
                pgm_exit(1,"$lnn: $line FAILED\n");
            }
        }
    }
    my @missed = ();
    for ($lon1 = -180; $lon1 < 180; $lon1 += 10) {
        for ($lat2 = -90; $lat2 < 90; $lat2 += 10) {
            $ew = 'e';
            $ns = 'n';
            $x = $lon1;
            if ($x < 0) {
                $ew = 'w';
                $x *= -1;
            }
            $y = $lat2;
            if ($y < 0) {
                $ns = 's';
                $y *= -1;
            }
            $x = '0'.$x while (length($x) < 3);
            $y = '0'.$y while (length($y) < 2);
            $file2 = "$ew$x$ns$y";
            if (!defined $files{$file2}) {
                push(@missed,$file2);
            }
        }
    }
    @arr = keys %files;
    $cnt = scalar @arr;
    $x = scalar @missed;
    prt("Found $cnt ($acnt) files in MAP, missed $x\n");
    #prt(join(" ",@missed)."\n");
    $line = '';
    $x = 100;
    foreach $file (@missed) {
        $line .= " " if (length($line));
        $line .= $file;
        if (length($line) > $x) {
            prt("$line\n");
            $line = '';
        }
    }
    prt("$line\n") if (length($line));
    ## $load_log = 1;
}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_file($in_file);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    my $verb = VERB2();
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                $verb = VERB2();
                prt("Verbosity = $verbosity\n") if ($verb);
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if ($verb);
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if ($verb);
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if ($verb);
        }
        shift @av;
    }

    if ($debug_on) {
        #prtw("WARNING: DEBUG is ON!\n");
        if (length($in_file) ==  0) {
            $in_file = $def_file;
            prt("Set DEFAULT input to [$in_file]\n");
        }
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
