#!/Perl
require "logfile.pl" or die "ERROR: Unable to load logfile.pl ... $! ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );

#File:        03modlist.data
#Description: These are the data that are published in the module
#        list, but they may be more recent than the latest posted
#        modulelist. Over time we'll make sure that these data
#        can be used to print the whole part two of the
#        modulelist. Currently this is not the case.
#Modcount:    4200
#Written-By:  Id: mldistwatch 836 2006-10-28 06:50:50Z k 
$RDate = 'Wed, 29 Nov 2006 23:25:20 GMT';
###$RDate = scalar localtime(time());

#package CPAN::Modulelist;
# Usage: print Data::Dumper->new([CPAN::Modulelist->data])->Dump or similar
# cannot 'use strict', because we normally run under Safe
# use strict;
sub data {
    my $result = {};
    my $primary = "modid";
    for (@$CPAN::Modulelist::data){
        my %hash;
        @hash{@$CPAN::Modulelist::cols} = @$_;
        $result->{$hash{$primary}} = \%hash;
    }
    $result;
}
#$CPAN::Modulelist::cols = [
@cols = [
'modid',
'statd',
'stats',
'statl',
'stati',
'statp',
'description',
'userid',
'chapterid'
];
#$CPAN::Modulelist::data = [
@mdata = (
[
'Fcntl',
'S',
'd',
'c',
'f',
'?',
'Defines fcntl() constants (see File::Lock)',
'JHI',
'4'
],
[
'Errno',
'c',
'd',
'p',
'f',
'?',
'Constants from errno.h EACCES, ENOENT etc',
'P5P',
'4'
],
[
'Statistics::LTU',
'R',
'd',
'p',
'O',
'?',
'Implements Linear Threshold Units',
'TOMFA',
'6'
],
[
'IPC::SysV',
'S',
'u',
'c',
'r',
'?',
'shared memory, semaphores, messages etc',
'P5P',
'5'
],
[
'Set::Scalar',
'M',
'd',
'p',
'O',
'p',
'Set of scalars (inc references)',
'JHI',
'6'
],
[
'Opcode',
'S',
'u',
'p',
'f',
'?',
'Disable named opcodes when compiling code',
'P5P',
'2'
],
[
'I18N::Collate',
'S',
'd',
'p',
'r',
'?',
'Locale based comparisons',
'JHI',
'13'
],
[
'Term::Prompt',
'a',
'd',
'p',
'f',
'?',
'Prompt a user',
'ALLENS',
'8'
],
[
'IPC::Mmap',
'b',
'd',
'h',
'O',
'a',
'memory mapped file IPC for POSIX and Win32',
'DARNOLD',
'5'
],
[
'Proxy',
'i',
'',
'',
'',
'?',
'Transport-independent remote processing',
'MICB',
'5'
],
[
'Proxy::Tk',
'?',
'',
'',
'',
'?',
'Tk transport class for Proxy (part of Tk)',
'MICB',
'5'
],
[
'Async::Group',
'a',
'd',
'p',
'O',
'?',
'Deal with simultaneous asynchronous calls',
'DDUMONT',
'4'
],
[
'CGI::Imagemap',
'R',
'd',
'p',
'h',
'?',
'Imagemap handling for specialized apps',
'MIKEH',
'15'
],
[
'Tcl',
'R',
'd',
'c',
'O',
'?',
'Complete access to Tcl',
'MICB',
'9'
],
[
'Tcl::Tk',
'R',
'd',
'c',
'O',
'?',
'Complete access to Tk *via Tcl*',
'MICB',
'9'
],
[
'Des',
'a',
'd',
'c',
'f',
'?',
'DES encryption (libdes)',
'MICB',
'14'
],
[
'constant',
'S',
'u',
'p',
'f',
'?',
'Define compile-time constants',
'P5P',
'27'
],
[
'Math::VecStat',
'R',
'd',
'p',
'r',
'?',
'Some basic numeric stats on vectors',
'ASPINELLI',
'6'
],
[
'Math::Spline',
'R',
'd',
'p',
'O',
'?',
'Cubic Spline Interpolation of data',
'JARW',
'6'
],
[
'Net::Traceroute',
'b',
'd',
'p',
'O',
'o',
'Trace routes in IPv4, v6',
'HAG',
'5'
],
[
'Win32::MSAgent',
'R',
'd',
'p',
'O',
'p',
'Interface to Microsoft Agent',
'JOUKE',
'22'
],
[
'Net::Domain',
'a',
'd',
'p',
'f',
'?',
'Try to determine TCP domain name of system',
'GBARR',
'5'
],
[
'Devel::DProf',
'R',
'd',
'c',
'f',
'?',
'Execution profiler',
'DMR',
'3'
],
[
'Class::Eroot',
'R',
'd',
'p',
'O',
'?',
'Eternal Root - Object persistence',
'DMR',
'6'
],
[
'Class::Template',
'R',
'd',
'p',
'r',
'?',
'Struct/member template builder',
'DMR',
'6'
],
[
'Ioctl',
'a',
'd',
'c',
'f',
'?',
'ioctl(2) constants',
'JPRIT',
'4'
],
[
'Term::Info',
'a',
'd',
'p',
'f',
'?',
'Terminfo interface (currently just Tput)',
'KJALB',
'8'
],
[
'Term::ReadLine',
'S',
'd',
'c',
'f',
'?',
'Common interface for various implementations',
'ILYAZ',
'8'
],
[
'Term::Control',
'i',
'd',
'p',
'f',
'?',
'Basic curses-type screen controls (gotxy)',
'KJALB',
'8'
],
[
'Math::Amoeba',
'R',
'd',
'p',
'r',
'p',
'Multidimensional Function Minimisation',
'TOM',
'6'
],
[
'MSDOS::SysCalls',
'a',
'd',
'c',
'f',
'?',
'MSDOS interface (interrupts, port I/O)',
'DMO',
'4'
],
[
'SGI::SysCalls',
'c',
'd',
'c',
'f',
'?',
'SGI-specific system calls',
'AMOSS',
'4'
],
[
'SGI::GL',
'a',
'd',
'c',
'r',
'?',
'SGI\'s Iris GL library',
'AMOSS',
'4'
],
[
'SGI::FM',
'a',
'd',
'c',
'r',
'?',
'SGI\'s Font Management library',
'AMOSS',
'4'
],
[
'VMS::SysCalls',
'i',
'',
'',
'',
'?',
'VMS-specific system calls',
'CBAIL',
'4'
],
[
'VMS::Filespec',
'S',
'd',
'c',
'f',
'?',
'VMS and Unix file name syntax',
'CBAIL',
'4'
],
[
'SICStus',
'a',
'd',
'c',
'O',
'?',
'Interface to SICStus Prolog Runtime',
'CBAIL',
'9'
],
[
'Net::Ping',
'S',
'u',
'p',
'O',
'p',
'TCP, UDP, or ICMP ping',
'BBB',
'5'
],
[
'Tie::Mem',
'a',
'd',
'c',
'O',
'?',
'Bind perl variables to memory addresses',
'PMQS',
'6'
],
[
'DB_File',
'S',
'u',
'c',
'O',
'p',
'Tie to DB files',
'PMQS',
'7'
],
[
'ExtUtils::MakeMaker',
'S',
'u',
'p',
'O',
'?',
'Writes Makefiles for extensions',
'MMML',
'3'
],
[
'Net::IRC',
'c',
'd',
'p',
'O',
'?',
'Internet Relay Chat interface',
'JEEK',
'5'
],
[
'Mail::MH',
'a',
'd',
'c',
'r',
'?',
'MH mail interface',
'MRG',
'19'
],
[
'Net::SMTP',
'a',
'd',
'p',
'f',
'?',
'Interface to Simple Mail Transfer Protocol',
'GBARR',
'5'
],
[
'Net::SOCKS',
'c',
'd',
'c',
'f',
'?',
'TCP/IP access through firewalls using SOCKS',
'SCOOPER',
'5'
],
[
'Getopt::Gnu',
'a',
'd',
'c',
'f',
'?',
'GNU form of long option handling',
'WSCOT',
'12'
],
[
'Net::NIS',
'M',
'd',
'c',
'r',
'?',
'Interface to Sun\'s NIS',
'ESM',
'5'
],
[
'Net::NISPlus',
'a',
'd',
'c',
'O',
'?',
'Interface to Sun\'s NIS+',
'RIK',
'5'
],
[
'Net::Gen',
'R',
'd',
'c',
'O',
'p',
'Generic support for socket usage',
'SPIDB',
'5'
],
[
'Net::Inet',
'R',
'd',
'c',
'O',
'p',
'Internet (IP) socket usage',
'SPIDB',
'5'
],
[
'Net::TCP',
'R',
'd',
'c',
'O',
'p',
'TCP-specific socket usage',
'SPIDB',
'5'
],
[
'Net::UDP',
'R',
'd',
'c',
'O',
'p',
'UDP-specific socket usage',
'SPIDB',
'5'
],
[
'Net::Dnet',
'c',
'd',
'c',
'O',
'?',
'DECnet-specific socket usage',
'SPIDB',
'5'
],
[
'RPC::ONC',
'a',
'd',
'c',
'O',
'?',
'ONC RPC interface (works with perlrpcgen)',
'JAKE',
'5'
],
[
'ToolTalk',
'a',
'd',
'c',
'r',
'?',
'Interface to the ToolTalk messaging service',
'MARCP',
'5'
],
[
'Math::BigInt',
'S',
'u',
'p',
'O',
'p',
'Arbitrary size integer math package',
'TELS',
'6'
],
[
'Math::Complex',
'S',
'd',
'p',
'O',
'p',
'Complex number data type',
'RAM',
'6'
],
[
'Math::Pari',
'a',
'd',
'c',
'f',
'?',
'Interface to the powerful PARI library',
'ILYAZ',
'6'
],
[
'Text::TeX',
'c',
'd',
'p',
'O',
'?',
'TeX typesetting language input parser',
'ILYAZ',
'11'
],
[
'Text::Trie',
'a',
'd',
'p',
'f',
'?',
'Find common heads and tails from strings',
'ILYAZ',
'11'
],
[
'Array::Vec',
'i',
'd',
'p',
'',
'?',
'Implement array using vec()',
'LWALL',
'6'
],
[
'Array::Substr',
'i',
'd',
'p',
'',
'?',
'Implement array using substr()',
'LWALL',
'6'
],
[
'Array::Virtual',
'i',
'd',
'p',
'',
'?',
'Implement array using a file',
'LWALL',
'6'
],
[
'Tie::SubstrHash',
'S',
'd',
'p',
'O',
'?',
'Very compact hash stored in a string',
'LWALL',
'6'
],
[
'Tie::ShiftSplice',
'i',
'',
'',
'',
'?',
'Defines shift et al in terms of splice',
'LWALL',
'6'
],
[
'Date::Time',
'i',
'd',
'p',
'O',
'?',
'Lightweight normalised datetime data type',
'TOBIX',
'6'
],
[
'Date::Interval',
'i',
'd',
'p',
'O',
'?',
'Lightweight normalised interval data type',
'KTORP',
'6'
],
[
'Tie::Quick',
'i',
'',
'',
'',
'?',
'Simple way to create ties',
'P5P',
'6'
],
[
'Tie::Watch',
'R',
'd',
'p',
'O',
'p',
'Watch variables, run code when read/written',
'LUSOL',
'6'
],
[
'DBD::Oracle',
'M',
'm',
'c',
'O',
'?',
'Oracle Driver for DBI',
'DBIML',
'7'
],
[
'DBD::Ingres',
'b',
'm',
'c',
'O',
'p',
'Ingres Driver for DBI',
'HTOUG',
'7'
],
[
'Oraperl',
'R',
'm',
'p',
'f',
'?',
'Oraperl emulation interface for DBD::Oracle',
'DBIML',
'7'
],
[
'Ingperl',
'R',
'm',
'p',
'f',
'p',
'Ingperl emulation interface for DBD::Ingres',
'HTOUG',
'7'
],
[
'Tie::File',
'R',
'd',
'p',
'r',
'p',
'Tie array to lines of a file',
'MJD',
'6'
],
[
'ConfigReader',
'c',
'd',
'p',
'O',
'?',
'Read directives from configuration file',
'AMW',
'12'
],
[
'Math::Trig',
'b',
'd',
'p',
'f',
'?',
'tan asin acos sinh cosh tanh sech cosech',
'JHI',
'6'
],
[
'Devel::Peek',
'a',
'd',
'c',
'f',
'?',
'Peek at internal representation of Perl data',
'ILYAZ',
'3'
],
[
'DBI',
'M',
'm',
'c',
'O',
'p',
'Generic Database Interface (see DBD modules)',
'DBIML',
'7'
],
[
'DBD::DB2',
'M',
'd',
'h',
'O',
'o',
'DB2 Driver for DBI',
'IBMTORDB2',
'7'
],
[
'DBD::Sybase',
'R',
'm',
'c',
'O',
'p',
'Sybase Driver for DBI',
'MEWP',
'7'
],
[
'Sybase::DBlib',
'M',
'd',
'c',
'O',
'p',
'Sybase DBlibrary interface',
'MEWP',
'7'
],
[
'Sybase::Sybperl',
'R',
'd',
'p',
'f',
'p',
'sybperl 1.0xx compatibility module',
'MEWP',
'7'
],
[
'Sybase::CTlib',
'M',
'd',
'c',
'O',
'p',
'Sybase CTlibrary interface',
'MEWP',
'7'
],
[
'DBZ_File',
'a',
'd',
'c',
'',
'?',
'Tie to dbz files (mainly for news history)',
'IANPX',
'7'
],
[
'DTREE',
'c',
'd',
'c',
'f',
'?',
'Interface to Faircom DTREE multikey ISAM db',
'JWAT',
'7'
],
[
'Sx',
'R',
'd',
'c',
'f',
'?',
'Simple Athena widget interface',
'FMC',
'8'
],
[
'AsciiDB::Parse',
'i',
'',
'',
'',
'?',
'Generic text database parsing',
'MICB',
'7'
],
[
'Protect',
'b',
'd',
'p',
'f',
'?',
'declare subs private or member',
'JDUNCAN',
'2'
],
[
'Fresco',
'c',
'd',
'+',
'O',
'?',
'Interface to Fresco (post X11R6 version)',
'BPETH',
'8'
],
[
'Curses',
'R',
'd',
'c',
'f',
'p',
'Character screen handling and windowing',
'GIRAFFED',
'8'
],
[
'PV',
'b',
'd',
'p',
'O',
'p',
'Text-mode user interface widgets',
'AGUL',
'8'
],
[
'UNIVERSAL',
'S',
'u',
'c',
'O',
'p',
'Internal universal base-class',
'P5P',
'2'
],
[
'SGML::Element',
'c',
'd',
'p',
'O',
'?',
'Build a SGML element structure tree',
'LSTAF',
'11'
],
[
'Error',
'a',
'd',
'p',
'O',
'p',
'Error/exception handling in an OO-ish way',
'SHLOMIF',
'2'
],
[
'Getopt::Long',
'S',
'd',
'p',
'r',
'?',
'Advanced handling of command line options',
'JV',
'12'
],
[
'DES',
'a',
'd',
'c',
'f',
'?',
'DES encryption (libdes)',
'EAYNG',
'14'
],
[
'Authen::Krb4',
'R',
'd',
'c',
'O',
'?',
'Interface to Kerberos 4 API',
'JHORWITZ',
'14'
],
[
'URI::URL',
'R',
'm',
'p',
'O',
'?',
'Uniform Resource Locator objects',
'LWWWP',
'15'
],
[
'Religion',
'a',
'd',
'p',
'r',
'?',
'Control where you go when you die()/warn()',
'KJALB',
'20'
],
[
'CGI::Base',
'R',
'm',
'p',
'O',
'?',
'Complete HTTPD CGI Interface class',
'CGIP',
'15'
],
[
'CGI::MiniSvr',
'R',
'm',
'p',
'O',
'?',
'Fork CGI app as a per-session mini server',
'CGIP',
'15'
],
[
'CGI::Request',
'R',
'm',
'p',
'O',
'?',
'Parse CGI request and handle form fields',
'CGIP',
'15'
],
[
'Mail::Alias',
'b',
'd',
'p',
'O',
'?',
'Manipulate E-mail aliases and alias files',
'ZELT',
'19'
],
[
'News::NNTPClient',
'M',
'd',
'p',
'O',
'p',
'Support for clients of NNTP servers',
'RVA',
'19'
],
[
'Test::Harness',
'S',
'm',
'p',
'f',
'p',
'Executes perl-style tests',
'PETDANCE',
'3'
],
[
'Nexus',
'c',
'd',
'c',
'O',
'?',
'Interface to Nexus (threads/ipc/processes)',
'RDO',
'23'
],
[
'Tk',
'b',
'm',
'c',
'O',
'?',
'Object oriented version of Tk v4',
'TKML',
'8'
],
[
'CGI::Response',
'a',
'm',
'p',
'O',
'?',
'Response construction for CGI applications',
'MGH',
'15'
],
[
'File::CounterFile',
'R',
'd',
'p',
'O',
'?',
'Persistent counter class',
'GAAS',
'10'
],
[
'HTML::QuickCheck',
'c',
'd',
'p',
'f',
'?',
'Fast simple validation of HMTL text',
'YLU',
'15'
],
[
'DBD::mysql',
'R',
'm',
'c',
'O',
'?',
'MySQL driver for DBI',
'CAPTTOFU',
'7'
],
[
'Text::Parser',
'a',
'd',
'p',
'O',
'?',
'String parser using patterns and states',
'PATM',
'11'
],
[
'Archie',
'R',
'd',
'p',
'f',
'p',
'Archie queries via Prospero ARDP protocol',
'GBOSS',
'23'
],
[
'PGPLOT',
'R',
'd',
'o',
'f',
'?',
'PGPLOT plotting library - scientific graphs',
'KGB',
'18'
],
[
'Sys::AlarmCall',
'R',
'u',
'p',
'f',
'?',
'Timeout on any sub. Allows nested alarms',
'ABH',
'4'
],
[
'Server::Server::EventDriven',
'R',
'n',
'p',
'O',
'?',
'See \'EventServer\' (compatibility maintained)',
'JACKS',
'16'
],
[
'SelfLoader',
'S',
'u',
'p',
'O',
'?',
'Automatic function loader (using __DATA__)',
'P5P',
'2'
],
[
'File::Which',
'b',
'd',
'p',
'f',
'p',
'Portable implementation of `which\'',
'PEREINAR',
'10'
],
[
'Language::Prolog',
'a',
'n',
'p',
'O',
'?',
'An implementation of Prolog',
'JACKS',
'9'
],
[
'Mail::Internet',
'a',
'd',
'p',
'O',
'?',
'Functions for RFC822 address manipulations',
'MARKOV',
'19'
],
[
'Array::Heap',
'c',
'd',
'p',
'f',
'?',
'Manipulate array elements as a heap',
'JMM',
'6'
],
[
'Filter::decrypt',
'b',
'd',
'c',
'f',
'?',
'Template for a perl source decryption filter',
'PMQS',
'2'
],
[
'Mac::AppleEvents::Simple',
'R',
'm',
'p',
'h',
'p',
'Simple access to Mac::AppleEvents',
'CNANDOR',
'4'
],
[
'DBD::mSQL',
'R',
'm',
'c',
'O',
'?',
'Msql Driver for DBI',
'JWIED',
'7'
],
[
'SGMLS',
'R',
'd',
'p',
'O',
'?',
'A Post-Processor for SGMLS and NSGMLS',
'INGOMACH',
'11'
],
[
'Fortran::NameList',
'a',
'd',
'p',
'f',
'?',
'Interface to FORTRAN NameList data',
'SGEL',
'9'
],
[
'PCL::Simple',
'R',
'd',
'p',
'f',
'p',
'Create PCL for printing plain text files',
'PRL',
'11'
],
[
'PixDraw',
'a',
'd',
'c',
'O',
'?',
'Drawing and manipulating true color images',
'KSB',
'18'
],
[
'Filter::tee',
'b',
'd',
'c',
'f',
'?',
'Copies to file perl source being compiled',
'PMQS',
'2'
],
[
'Pg',
'R',
'd',
'c',
'f',
'?',
'PostgreSQL SQL database interface',
'MERGL',
'7'
],
[
'Mail::Address',
'a',
'd',
'p',
'f',
'?',
'Manipulation of electronic mail addresses',
'MARKOV',
'19'
],
[
'Font::AFM',
'R',
'd',
'p',
'O',
'?',
'Parse Adobe Font Metric files',
'GAAS',
'11'
],
[
'PostScript::Resources',
'R',
'd',
'p',
'O',
'?',
'loads Unix PostScript Resources file',
'JV',
'11'
],
[
'VCS::PVCS',
'i',
'',
'',
'',
'?',
'PVCS Version Manager (intersolv.com)',
'BMIDD',
'3'
],
[
'Devel::Symdump',
'R',
'd',
'p',
'O',
'?',
'Perl symbol table access and dumping',
'ANDK',
'3'
],
[
'String::BitCount',
'a',
'd',
'p',
'f',
'?',
'Count number of "1" bits in strings',
'WINKO',
'11'
],
[
'BSD::Resource',
'R',
'd',
'c',
'f',
'?',
'getrusage(), s/getrlimit(), s/getpriority()',
'JHI',
'4'
],
[
'Time::HiRes',
'R',
'd',
'c',
'f',
'?',
'High resolution time, sleep, and alarm',
'JHI',
'6'
],
[
'DCE::Registry',
'R',
'd',
'c',
'O',
'g',
'DCE registry functions',
'PHENSON',
'5'
],
[
'Net::Telnet',
'R',
'd',
'p',
'O',
'?',
'Interact with TELNET port or other TCP ports',
'JROGERS',
'5'
],
[
'GSS',
'a',
'd',
'c',
'O',
'?',
'Generic Security Services API (RFC 2078)',
'MSHLD',
'14'
],
[
'Term::Gnuplot',
'a',
'd',
'c',
'f',
'?',
'Draw vector graphics on terminals etc',
'ILYAZ',
'8'
],
[
'Filter::exec',
'b',
'd',
'c',
'f',
'?',
'Filters script through an external command',
'PMQS',
'2'
],
[
'HTML::Base',
'a',
'd',
'p',
'O',
'?',
'Object-oriented way to build pages of HTML',
'GAND',
'15'
],
[
'String::Parity',
'a',
'd',
'p',
'f',
'?',
'Parity (odd/even/mark/space) handling',
'WINKO',
'11'
],
[
'Remedy::AR',
'a',
'd',
'c',
'O',
'?',
'Interface to Remedy\'s Action Request API',
'RIK',
'23'
],
[
'Text::Stem',
'b',
'd',
'p',
'f',
'?',
'Porter algorithm for stemming English words',
'IANPX',
'11'
],
[
'FreezeThaw',
'b',
'd',
'p',
'f',
'?',
'Convert arbitrary objects to/from strings',
'ILYAZ',
'6'
],
[
'VCS::RCE',
'i',
'd',
'c',
'f',
'?',
'Perl layer over RCE C API',
'RJRAY',
'3'
],
[
'VCS::RCS',
'i',
'd',
'p',
'f',
'?',
'Interface layer over RCS (See also Rcs)',
'RJRAY',
'3'
],
[
'Marpa',
'c',
'd',
'+',
'O',
'?',
'Context Free Parser',
'JKEGL',
'11'
],
[
'String::Approx',
'R',
'd',
'p',
'f',
'?',
'Approximate string matching and substitution',
'JHI',
'11'
],
[
'Pod::Text',
'S',
'u',
'p',
'f',
'?',
'convert POD data to formatted ASCII text',
'TOMC',
'26'
],
[
'Msql',
'R',
'm',
'c',
'O',
'?',
'Mini-SQL database interface',
'JWIED',
'7'
],
[
'Image::Size',
'R',
'd',
'p',
'f',
'?',
'Measure size of images in common formats',
'RJRAY',
'18'
],
[
'Mail::Send',
'a',
'd',
'p',
'O',
'?',
'Simple interface for sending mail',
'MARKOV',
'19'
],
[
'GD',
'M',
'd',
'c',
'O',
'p',
'Interface to Gd Graphics Library',
'LDS',
'18'
],
[
'Devel::DumpStack',
'R',
'n',
'p',
'f',
'?',
'Dumping of the current function stack',
'JACKS',
'3'
],
[
'Filter::sh',
'b',
'd',
'c',
'f',
'?',
'Filters script through a shell command',
'PMQS',
'2'
],
[
'Tie::IxHash',
'R',
'd',
'p',
'O',
'?',
'Indexed hash (ordered array/hash composite)',
'GSAR',
'6'
],
[
'SNMP',
'R',
'd',
'c',
'O',
'?',
'Interface to the UCD SNMP toolkit',
'GSM',
'5'
],
[
'HTML::Stream',
'R',
'd',
'p',
'O',
'p',
'HTML output stream',
'DSTAAL',
'15'
],
[
'Math::LinearProg',
'i',
'd',
'p',
'',
'?',
'Linear programming utilities',
'JONO',
'6'
],
[
'Devel::CallerItem',
'R',
'n',
'p',
'O',
'?',
'\'caller()\' Object wrapper + useful methods',
'JACKS',
'3'
],
[
'Config::IniFiles',
'R',
'm',
'p',
'h',
'p',
'Read/Write INI-Style configuration files',
'WADG',
'12'
],
[
'String::Edit',
'a',
'd',
'p',
'f',
'?',
'Assorted handy string editing functions',
'TOMC',
'11'
],
[
'Math::Approx',
'a',
'd',
'p',
'O',
'?',
'Approximate x,y-values by a function',
'ULPFR',
'6'
],
[
'Math::Matrix',
'a',
'd',
'p',
'O',
'?',
'Matrix data type (transpose, multiply etc)',
'ULPFR',
'6'
],
[
'ExtUtils::Embed',
'S',
'd',
'p',
'f',
'?',
'Utilities for embedding Perl in C/C++ apps',
'DOUGM',
'3'
],
[
'Net::SSLeay',
'R',
'm',
'c',
'f',
'r',
'Secure Socket Layer (based on OpenSSL)',
'FLORA',
'5'
],
[
'Safe',
'S',
'd',
'c',
'O',
'?',
'Restrict eval\'d code to safe subset of ops',
'MICB',
'2'
],
[
'VMS::System',
'R',
'd',
'c',
'f',
'?',
'VMS-specific system calls',
'DSUGAL',
'4'
],
[
'RPC::Simple',
'R',
'd',
'p',
'O',
'p',
'Simple OO sync/async remote procedure calls',
'CEDWARDS',
'5'
],
[
'Filter::cpp',
'b',
'd',
'c',
'f',
'?',
'Filters script through C preprocessor',
'PMQS',
'2'
],
[
'NetCDF',
'b',
'm',
'c',
'r',
'?',
'Interface to netCDF API for scientific data',
'SEMM',
'7'
],
[
'Devel::Leak',
'R',
'd',
'c',
'f',
'?',
'Find perl objects that are not reclaimed',
'PETDANCE',
'3'
],
[
'Roman',
'R',
'd',
'p',
'f',
'?',
'Convert Roman numbers to and from Arabic',
'OZAWA',
'23'
],
[
'FindBin',
'a',
'd',
'p',
'f',
'?',
'Locate current script bin directory',
'P5P',
'3'
],
[
'Net::FTP',
'a',
'd',
'p',
'f',
'?',
'Interface to File Transfer Protocol',
'GBARR',
'5'
],
[
'Math::Fortran',
'R',
'd',
'p',
'f',
'?',
'Implements Fortran log10 & sign functions',
'JARW',
'6'
],
[
'URI::Escape',
'R',
'm',
'p',
'f',
'?',
'General URI escaping/unescaping functions',
'LWWWP',
'15'
],
[
'HTTP::Date',
'R',
'm',
'p',
'f',
'?',
'Date conversion for HTTP date formats',
'LWWWP',
'15'
],
[
'HTTP::Headers',
'R',
'm',
'p',
'O',
'?',
'Class encapsulating HTTP Message headers',
'LWWWP',
'15'
],
[
'HTTP::Message',
'R',
'm',
'p',
'O',
'?',
'Base class for Request/Response',
'LWWWP',
'15'
],
[
'HTTP::Request',
'R',
'm',
'p',
'O',
'?',
'Class encapsulating HTTP Requests',
'LWWWP',
'15'
],
[
'HTTP::Response',
'R',
'm',
'p',
'O',
'?',
'Class encapsulating HTTP Responses',
'LWWWP',
'15'
],
[
'HTTP::Status',
'R',
'm',
'p',
'f',
'?',
'HTTP Status code processing',
'LWWWP',
'15'
],
[
'WWW::RobotRules',
'a',
'm',
'p',
'O',
'?',
'Parse /robots.txt file',
'LWWWP',
'15'
],
[
'File::Copy',
'a',
'd',
'p',
'f',
'?',
'Copying files or filehandles',
'ASHER',
'10'
],
[
'Ptty',
'a',
'd',
'c',
'f',
'?',
'Pseudo terminal interface functions',
'PETDANCE',
'5'
],
[
'Socket',
'S',
'm',
'c',
'f',
'p',
'Defines socket-related constants',
'GNAT',
'5'
],
[
'diagnostics',
'S',
'd',
'p',
'f',
'?',
'For reporting perl diagnostics in full form',
'TOMC',
'27'
],
[
'Term::Query',
'R',
'd',
'p',
'f',
'?',
'Intelligent user prompt/response driver',
'AKSTE',
'8'
],
[
'Storable',
'S',
'm',
'c',
'r',
'p',
'Persistent data structure mechanism',
'AMS',
'6'
],
[
'Mail::Mailer',
'a',
'd',
'p',
'O',
'?',
'Simple mail agent interface (see Mail::Send)',
'MARKOV',
'19'
],
[
'Mail::Util',
'a',
'd',
'p',
'f',
'?',
'Mail utilities (for by some Mail::* modules)',
'MARKOV',
'19'
],
[
'Safe::Hole',
'b',
'd',
'c',
'O',
'?',
'Exec subs in the original package from Safe',
'SEYN',
'2'
],
[
'Devel::TraceFuncs',
'a',
'd',
'p',
'O',
'?',
'Trace funcs by using object destructions',
'JOEHIL',
'3'
],
[
'Math::Derivative',
'R',
'd',
'p',
'r',
'?',
'1st and 2nd order differentiation of data',
'JARW',
'6'
],
[
'CORE',
'S',
'u',
'c',
'f',
'?',
'Internal package for perl native functions',
'P5P',
'2'
],
[
'Time::CTime',
'R',
'd',
'p',
'f',
'o',
'Format Times ala ctime(3) with many formats',
'MUIR',
'6'
],
[
'Net::Cmd',
'c',
'd',
'p',
'O',
'?',
'For command based protocols (FTP, SMTP etc)',
'GBARR',
'5'
],
[
'Time::JulianDay',
'R',
'd',
'p',
'f',
'o',
'Converts y/m/d into seconds',
'MUIR',
'6'
],
[
'Time::Timezone',
'R',
'd',
'p',
'f',
'o',
'Figures out timezone offsets',
'MUIR',
'6'
],
[
'Time::DaysInMonth',
'R',
'd',
'p',
'f',
'o',
'Returns the number of days in a month',
'MUIR',
'6'
],
[
'Algorithm::Numerical::Sample',
'R',
'D',
'p',
'h',
'?',
'Knuth\'s sample algorithm',
'ABIGAIL',
'6'
],
[
'Math::Brent',
'R',
'd',
'p',
'r',
'?',
'One-dimensional Function Minimisation',
'JARW',
'6'
],
[
'Text::Tabs',
'S',
'd',
'p',
'f',
'o',
'Expand and contract tabs ala expand(1)',
'MUIR',
'11'
],
[
'Text::Wrap',
'S',
'd',
'p',
'f',
'o',
'Wraps lines to make simple paragraphs',
'MUIR',
'11'
],
[
'Softref',
'b',
'd',
'c',
'f',
'?',
'Extension for weak/soft referenced SVs',
'ILYAZ',
'2'
],
[
'HTML::Simple',
'b',
'd',
'p',
'f',
'?',
'Simple functions for generating HTML',
'TOMC',
'15'
],
[
'MIME::Base64',
'R',
'd',
'h',
'f',
'?',
'Encode/decode Base 64 (RFC 2045)',
'GAAS',
'15'
],
[
'MIME::QuotedPrint',
'R',
'd',
'p',
'f',
'?',
'Encode/decode Quoted-Printable',
'GAAS',
'15'
],
[
'Compress::Zlib',
'R',
'd',
'c',
'O',
'p',
'Interface to zlib compression library',
'PMQS',
'17'
],
[
'OpenGL',
'a',
'd',
'c',
'f',
'?',
'Interface to OpenGL drawing/imaging library',
'FIJI',
'18'
],
[
'Mail::Cap',
'a',
'd',
'p',
'O',
'?',
'Parse mailcap files as specified in RFC 1524',
'MARKOV',
'19'
],
[
'Callback',
'R',
'd',
'p',
'O',
'o',
'Define easy to use function callback objects',
'MUIR',
'20'
],
[
'LWP::MediaTypes',
'R',
'm',
'p',
'f',
'?',
'Media types and mailcap processing',
'LWWWP',
'15'
],
[
'LWP::Simple',
'R',
'm',
'p',
'f',
'?',
'Simple procedural interface to libwww-perl',
'LWWWP',
'15'
],
[
'LWP::UserAgent',
'R',
'm',
'p',
'O',
'?',
'A WWW UserAgent class',
'LWWWP',
'15'
],
[
'LWP::RobotUA',
'R',
'm',
'p',
'O',
'?',
'A UserAgent for robot applications',
'LWWWP',
'15'
],
[
'Postgres',
'R',
'n',
'c',
'O',
'?',
'PostgreSQL interface with Perl5 coding style',
'DAVEHOLL',
'7'
],
[
'ExtUtils::Manifest',
'S',
'u',
'p',
'f',
'?',
'Utilities for managing MANIFEST files',
'RKOBES',
'3'
],
[
'Proc::times',
'a',
'd',
'p',
'f',
'?',
'By-name interface to process times function',
'TOMC',
'4'
],
[
'Net::hostent',
'a',
'd',
'p',
'f',
'?',
'A by-name interface for hosts functions',
'TOMC',
'5'
],
[
'Net::netent',
'a',
'd',
'p',
'f',
'?',
'A by-name interface for networks functions',
'TOMC',
'5'
],
[
'Net::protoent',
'a',
'd',
'p',
'f',
'?',
'A by-name interface for protocols functions',
'TOMC',
'5'
],
[
'Net::servent',
'a',
'd',
'p',
'f',
'?',
'A by-name interface for services functions',
'TOMC',
'5'
],
[
'Time::gmtime',
'S',
'u',
'p',
'f',
'?',
'A by-name interface for gmtime',
'TOMC',
'6'
],
[
'Time::localtime',
'S',
'u',
'p',
'f',
'?',
'A by-name interface for localtime',
'TOMC',
'6'
],
[
'Object::Info',
'R',
'n',
'p',
'f',
'?',
'General info about objects (is-a, ...)',
'JACKS',
'6'
],
[
'Data::Dumper',
'S',
'd',
'p',
'O',
'p',
'Convert data structure into perl code',
'GSAR',
'6'
],
[
'DBD::Informix',
'M',
'm',
'c',
'O',
'p',
'IBM Informix Database Driver for Perl DBI',
'JOHNL',
'7'
],
[
'DBD::QBase',
'a',
'm',
'c',
'O',
'?',
'QBase Driver for DBI',
'BENLI',
'7'
],
[
'File::stat',
'S',
'u',
'p',
'f',
'?',
'A by-name interface for the stat function',
'TOMC',
'10'
],
[
'Filesys::dfent',
'a',
'd',
'p',
'f',
'?',
'By-name interface',
'TOMC',
'10'
],
[
'Filesys::mntent',
'a',
'd',
'p',
'f',
'?',
'By-name interface',
'TOMC',
'10'
],
[
'Filesys::statfs',
'a',
'd',
'p',
'f',
'?',
'By-name interface',
'TOMC',
'10'
],
[
'String::Scanf',
'R',
'd',
'p',
'f',
'?',
'Implementation of C sscanf function',
'JHI',
'11'
],
[
'User::pwent',
'a',
'd',
'p',
'f',
'?',
'A by-name interface to password database',
'TOMC',
'14'
],
[
'User::grent',
'a',
'd',
'p',
'f',
'?',
'A by-name interface to groups database',
'TOMC',
'14'
],
[
'SDDF',
'c',
'd',
'+',
'O',
'?',
'Interface to Pablo Self Defining Data Format',
'FIS',
'23'
],
[
'Set::Infinite',
'b',
'd',
'p',
'O',
'p',
'Infinite Set Theory module, with Date, Time',
'FGLOCK',
'6'
],
[
'Proc::Forkfunc',
'R',
'd',
'p',
'f',
'?',
'Simple lwall-style fork wrapper',
'MUIR',
'4'
],
[
'DBIx::Recordset',
'b',
'm',
'p',
'O',
'p',
'DB-Abtractionlayer / Access via Arrays/Hashs',
'GRICHTER',
'7'
],
[
'Module::Reload',
'R',
'd',
'p',
'f',
'?',
'Reloads files in %INC based on timestamps',
'JPRIT',
'2'
],
[
'Fame',
'M',
'd',
'c',
'O',
'p',
'Interface to FAME database and language',
'TRIAS',
'7'
],
[
'CGI::BasePlus',
'R',
'm',
'p',
'O',
'?',
'Extra CGI::Base methods (incl file-upload)',
'CGIP',
'15'
],
[
'CGI::Carp',
'c',
'm',
'p',
'f',
'?',
'Drop-in Carp replacement for CGI scripts',
'CGIP',
'15'
],
[
'Alias',
'b',
'd',
'c',
'f',
'p',
'Convenient access to data/code via aliases',
'GSAR',
'2'
],
[
'Set::IntSpan',
'R',
'd',
'p',
'O',
'p',
'Set of integers newsrc style \'1,5-9,11\' etc',
'SWMCD',
'6'
],
[
'Datascope',
'R',
'd',
'c',
'f',
'?',
'Interface to Datascope RDBMS',
'DANMQ',
'7'
],
[
'Term::ReadKey',
'R',
'd',
'c',
'f',
'?',
'Read keystrokes and change terminal modes',
'JSTOWE',
'8'
],
[
'Text::Template',
'M',
'd',
'p',
'O',
'?',
'Expand template text with embedded perl',
'MJD',
'11'
],
[
'Getopt::Regex',
'a',
'd',
'',
'',
'?',
'Option handling using regular expressions',
'JARW',
'12'
],
[
'Getopt::Help',
'b',
'd',
'p',
'f',
'?',
'Yet another getopt, has help and defaults',
'IANPX',
'12'
],
[
'Pod::Lyx',
'a',
'd',
'p',
'O',
'?',
'A pod to LyX format conversion class',
'RICHARDJ',
'26'
],
[
'HTTPD::UserAdmin',
'b',
'd',
'p',
'O',
'?',
'Management of server user databases',
'LDS',
'15'
],
[
'HTTPD::Access',
'c',
'd',
'p',
'O',
'?',
'Management of server access control files',
'LDS',
'15'
],
[
'Log::Topics',
'R',
'd',
'p',
'f',
'?',
'Control flow of topic based logging messages',
'JARW',
'21'
],
[
'WinNT',
'c',
'd',
'c',
'f',
'?',
'Interface to Windows NT specific functions',
'WIN32',
'22'
],
[
'NT',
'c',
'd',
'c',
'f',
'?',
'Old name for WinNT - being phased out',
'WIN32',
'22'
],
[
'Win95',
'i',
'',
'',
'',
'?',
'Interface to Windows 95 specific functions',
'WIN32',
'22'
],
[
'Wais',
'R',
'd',
'c',
'f',
'?',
'Interface to the freeWAIS-sf libraries',
'ULPFR',
'7'
],
[
'Psion::Db',
'i',
'd',
'p',
'O',
'?',
'Handle Psion palmtop computer database files',
'IANPX',
'23'
],
[
'Statistics::Descriptive',
'R',
'd',
'p',
'O',
'?',
'Descriptive statistical methods',
'COLINK',
'6'
],
[
'Statistics::ChiSquare',
'R',
'd',
'p',
'f',
'?',
'Chi Square test - how random is your data?',
'DCANTRELL',
'6'
],
[
'Symbol',
'S',
'u',
'p',
'O',
'?',
'Create \'anonymous\' symbol (typeglobs) refs',
'CHIPS',
'2'
],
[
'Filter::Util::Exec',
'b',
'd',
'c',
'f',
'?',
'Interface for creation of coprocess Filters',
'PMQS',
'2'
],
[
'Filter::Util::Call',
'b',
'd',
'c',
'f',
'?',
'Interface for creation of Perl Filters',
'PMQS',
'2'
],
[
'Make',
'a',
'd',
'p',
'O',
'?',
'Makefile parsing, and \'make\' replacement',
'PETDANCE',
'3'
],
[
'Xbase',
'b',
'd',
'p',
'f',
'?',
'Read Xbase files with simple IDX indexes',
'PRATP',
'7'
],
[
'MLDBM',
'R',
'd',
'p',
'O',
'p',
'Transparently store multi-level data in DBM',
'GSAR',
'7'
],
[
'Term::Screen',
'R',
'd',
'p',
'O',
'p',
'Basic screen + input class (uses Term::Cap)',
'JSTOWE',
'8'
],
[
'Getopt::Mixed',
'R',
'd',
'p',
'f',
'g',
'Supports both long and short options',
'CJM',
'12'
],
[
'EventServer',
'R',
'n',
'p',
'O',
'?',
'Triggers objects on i/o, timers & interrupts',
'JACKS',
'16'
],
[
'Mail::POP3Client',
'R',
'd',
'p',
'O',
'?',
'Support for clients of POP3 servers',
'SDOWD',
'19'
],
[
'News::Newsrc',
'R',
'd',
'p',
'O',
'p',
'Manage .newsrc files',
'SWMCD',
'19'
],
[
'DirHandle',
'S',
'u',
'p',
'O',
'?',
'Directory handle objects and methods',
'CHIPS',
'21'
],
[
'SelectSaver',
'S',
'u',
'p',
'O',
'?',
'Save and restore selected file handle',
'CHIPS',
'21'
],
[
'Win32::OLE',
'R',
'm',
'+',
'h',
'p',
'Interface to OLE Automation',
'JDB',
'22'
],
[
'Win32::EventLog',
'a',
'd',
'c',
'f',
'?',
'Interface to Win32 EventLog functions',
'WIN32',
'22'
],
[
'Win32::NetAdmin',
'a',
'd',
'c',
'f',
'?',
'Interface to Win32 NetAdmin functions',
'WIN32',
'22'
],
[
'Win32::NetResource',
'a',
'd',
'c',
'f',
'?',
'Interface to Win32 NetResource functions',
'WIN32',
'22'
],
[
'Win32::WinError',
'a',
'd',
'c',
'f',
'?',
'Interface to Win32 WinError functions',
'WIN32',
'22'
],
[
'Win32::Registry',
'a',
'd',
'c',
'f',
'?',
'Interface to Win32 Registry functions',
'WIN32',
'22'
],
[
'Win32::Process',
'a',
'd',
'c',
'f',
'?',
'Interface to Win32 Process functions',
'WIN32',
'22'
],
[
'File::Listing',
'R',
'd',
'p',
'f',
'?',
'Parse directory listings',
'GAAS',
'10'
],
[
'HTML::Element',
'R',
'd',
'p',
'O',
'p',
'Representation of a HTML parsing tree',
'PETDANCE',
'15'
],
[
'HTML::Entities',
'R',
'm',
'p',
'f',
'?',
'Encode/decode HTML entities',
'LWWWP',
'15'
],
[
'HTML::Formatter',
'a',
'm',
'p',
'O',
'?',
'Convert HTML to plain text or Postscript',
'JGOFF',
'15'
],
[
'LWP::UA',
'a',
'm',
'p',
'O',
'?',
'LWPng stuff',
'LWWWP',
'15'
],
[
'HTTP::Negotiate',
'R',
'm',
'p',
'f',
'?',
'HTTP content negotiation',
'LWWWP',
'15'
],
[
'overload',
'S',
'd',
'p',
'O',
'?',
'Overload perl operators for new data types',
'ILYAZ',
'27'
],
[
'Math::ematica',
'a',
'd',
'c',
'O',
'?',
'Interface to the powerful Mathematica system',
'ULPFR',
'6'
],
[
'Array::PrintCols',
'a',
'd',
'p',
'f',
'?',
'Print elements in vertically sorted columns',
'AKSTE',
'6'
],
[
'Time::ParseDate',
'R',
'd',
'p',
'f',
'o',
'Parses many forms of dates and times',
'MUIR',
'6'
],
[
'Tie::Cache',
'M',
'd',
'p',
'r',
'p',
'In memory size limited LRU cache',
'CHAMAS',
'6'
],
[
'Text::Bib',
'R',
'd',
'p',
'O',
'?',
'Module moved to Text::Refer',
'ERYQ',
'11'
],
[
'Text::German',
'a',
'd',
'p',
'f',
'?',
'German language stemming',
'ULPFR',
'11'
],
[
'IO::Handle',
'c',
'd',
'p',
'O',
'?',
'Base class for input/output handles',
'P5P',
'21'
],
[
'IO::Pipe',
'c',
'd',
'p',
'O',
'?',
'Methods for pipe handles',
'P5P',
'21'
],
[
'IO::Socket',
'c',
'd',
'p',
'O',
'?',
'Methods for socket input/output handles',
'P5P',
'21'
],
[
'IO::Seekable',
'c',
'd',
'p',
'O',
'?',
'Methods for seekable input/output handles',
'P5P',
'21'
],
[
'IO::File',
'c',
'd',
'p',
'O',
'?',
'Methods for disk file based i/o handles',
'P5P',
'21'
],
[
'HTTP::Size',
'b',
'd',
'p',
'f',
'a',
'get the download size for web resources',
'BDFOY',
'15'
],
[
'Usage',
'b',
'n',
'p',
'r',
'?',
'Type and range checking on subroutine args',
'JACKS',
'3'
],
[
'Include',
'a',
'd',
'p',
'O',
'?',
'Parse C header files for use in XS',
'GBARR',
'3'
],
[
'Pod::Parser',
'b',
'd',
'p',
'O',
'?',
'Base class for parsing pod syntax',
'BRADAPP',
'26'
],
[
'Quota',
'M',
'd',
'c',
'f',
'p',
'Disk quota system functions, local & remote',
'TOMZO',
'4'
],
[
'Mac::Memory',
'R',
'm',
'c',
'h',
'p',
'Memory Manager',
'CNANDOR',
'4'
],
[
'Mac::Resources',
'R',
'm',
'c',
'h',
'p',
'Resource Manager',
'CNANDOR',
'4'
],
[
'Mac::AppleEvents',
'R',
'm',
'c',
'h',
'p',
'Apple Event Manager and AEGizmos',
'CNANDOR',
'4'
],
[
'Mac::Files',
'R',
'm',
'c',
'h',
'p',
'File Manager',
'CNANDOR',
'4'
],
[
'Mac::Processes',
'R',
'm',
'c',
'h',
'p',
'Process Manager',
'CNANDOR',
'4'
],
[
'OS2::ExtAttr',
'R',
'd',
'c',
'O',
'?',
'(Tied) access to extended attributes',
'ILYAZ',
'4'
],
[
'OS2::PrfDB',
'R',
'd',
'c',
'O',
'?',
'(Tied) access to .INI-style databases',
'ILYAZ',
'4'
],
[
'OS2::REXX',
'R',
'd',
'c',
'O',
'?',
'Access to REXX DLLs and REXX runtime',
'ILYAZ',
'4'
],
[
'OS2::FTP',
'b',
'n',
'c',
'f',
'?',
'Access to ftplib interface',
'ILYAZ',
'4'
],
[
'OS2::UPM',
'b',
'n',
'c',
'f',
'?',
'User Profile Management',
'ILYAZ',
'4'
],
[
'Math::BigFloat',
'S',
'u',
'p',
'O',
'p',
'Arbitrary size floating point math package',
'TELS',
'6'
],
[
'Math::BigInteger',
'a',
'd',
'c',
'',
'?',
'Arbitrary size integer as XS extension',
'TELS',
'6'
],
[
'Math::BigRat',
'R',
'd',
'p',
'O',
'p',
'Arbitrary size rational numbers (fractions)',
'TELS',
'6'
],
[
'Math::TrulyRandom',
'i',
'',
'',
'',
'?',
'based on interrupt timing discrepancies',
'TELS',
'6'
],
[
'Date::Parse',
'R',
'd',
'p',
'f',
'?',
'ASCII Date parser using regexp\'s',
'GBARR',
'6'
],
[
'Date::Format',
'R',
'd',
'p',
'f',
'?',
'Date formatter ala strftime',
'GBARR',
'6'
],
[
'Time::Zone',
'R',
'd',
'p',
'f',
'?',
'Timezone info and translation routines',
'GBARR',
'6'
],
[
'Text::TreeFile',
'b',
'd',
'p',
'O',
'?',
'Reads tree of strings into a data structure',
'JNK',
'11'
],
[
'C::Scan',
'R',
'd',
'p',
'O',
'?',
'Heuristic parse of C files',
'ILYAZ',
'9'
],
[
'Crypt::DES',
'M',
'd',
'h',
'h',
'd',
'DES encryption (libdes)',
'DPARIS',
'14'
],
[
'Crypt::IDEA',
'M',
'd',
'h',
'h',
'?',
'International Data Encryption Algorithm',
'DPARIS',
'14'
],
[
'CGI_Lite',
'M',
'n',
'p',
'O',
'?',
'Light-weight interface for fast apps',
'SHGUN',
'15'
],
[
'HTTPD::GroupAdmin',
'b',
'd',
'p',
'O',
'?',
'Management of server group databases',
'LDS',
'15'
],
[
'HTTPD::Authen',
'b',
'd',
'p',
'O',
'?',
'Preform HTTP Basic and Digest Authentication',
'LDS',
'15'
],
[
'HTTPD::Config',
'c',
'd',
'p',
'O',
'?',
'Management of server configuration files',
'LDS',
'15'
],
[
'MIME::Decoder',
'R',
'd',
'p',
'O',
'?',
'OO interface for decoding MIME messages',
'ERYQ',
'15'
],
[
'MIME::Entity',
'R',
'd',
'p',
'O',
'?',
'An extracted and decoded MIME entity',
'ERYQ',
'15'
],
[
'MIME::Head',
'R',
'd',
'p',
'O',
'?',
'A parsed MIME header',
'ERYQ',
'15'
],
[
'MIME::Parser',
'R',
'd',
'p',
'O',
'?',
'Parses streams to create MIME entities',
'ERYQ',
'15'
],
[
'Apache',
'R',
'm',
'c',
'O',
'?',
'Interface to the Apache server API',
'DOUGM',
'15'
],
[
'PDL',
'a',
'm',
'c',
'f',
'?',
'Perl Data Language - numeric analysis env',
'PERLDL',
'6'
],
[
'Graphics::Simple',
'i',
'd',
'c',
'O',
'?',
'Simple drawing primitives',
'NEERI',
'18'
],
[
'Graphics::Turtle',
'i',
'd',
'p',
'',
'?',
'Turtle graphics package',
'NEERI',
'18'
],
[
'Neural',
'a',
'd',
'+',
'O',
'?',
'Generic simulation of neural networks',
'LUKKA',
'23'
],
[
'Proc::Simple',
'a',
'd',
'p',
'O',
'?',
'Fork wrapper with objects',
'MSCHILLI',
'4'
],
[
'MARC',
'b',
'm',
'p',
'O',
'?',
'MAchine Readable Catalog (library bib. data)',
'PERL4LIB',
'7'
],
[
'Resources',
'b',
'd',
'p',
'f',
'?',
'Application defaults management in Perl',
'FRANCOC',
'12'
],
[
'Convert::UU',
'b',
'd',
'p',
'f',
'?',
'UUencode and UUdecode',
'ANDK',
'17'
],
[
'Logfile',
'R',
'd',
'p',
'O',
'?',
'Generic methods to analyze logfiles',
'ULPFR',
'23'
],
[
'B',
'a',
'u',
'c',
'O',
'?',
'The Perl Compiler',
'MICB',
'2'
],
[
'O',
'a',
'u',
'c',
'O',
'?',
'Perl Compiler frontends',
'MICB',
'2'
],
[
'Devel::RegExp',
'a',
'd',
'c',
'O',
'?',
'Access perl internal regex functions',
'ILYAZ',
'3'
],
[
'Tie::Array',
'S',
'u',
'p',
'r',
'?',
'Base class for implementing tied arrays',
'P5P',
'6'
],
[
'Cdk',
'R',
'd',
'c',
'O',
'?',
'Collection of Curses widgets',
'GLOVER',
'8'
],
[
'Text::English',
'a',
'd',
'p',
'f',
'?',
'English language stemming',
'IANPX',
'11'
],
[
'NNTP::Server',
'i',
'',
'',
'',
'?',
'Support for an NNTP server',
'JOEHIL',
'19'
],
[
'Win32::FUtils',
'b',
'd',
'c',
'f',
'?',
'Implements missing File Utility functions',
'JOCASA',
'22'
],
[
'ARS',
'M',
'm',
'h',
'h',
'?',
'Interface to Remedy\'s Action Request API',
'JMURPHY',
'23'
],
[
'Agent',
'c',
'a',
'p',
'O',
'a',
'Transportable Agent module',
'SPURKIS',
'23'
],
[
'Devel::CoreStack',
'a',
'd',
'p',
'f',
'?',
'generate a stack dump from a core file',
'ADESC',
'3'
],
[
'Net::NNTP',
'a',
'd',
'p',
'O',
'?',
'Client interface to NNTP protocol',
'GBARR',
'5'
],
[
'Net::Netrc',
'a',
'd',
'p',
'O',
'?',
'Support for .netrc files',
'GBARR',
'5'
],
[
'Net::POP3',
'a',
'd',
'p',
'O',
'?',
'Client interface to POP3 protocol',
'GBARR',
'5'
],
[
'Net::SNPP',
'a',
'd',
'p',
'O',
'p',
'Client interface to SNPP protocol',
'TOBEYA',
'5'
],
[
'Net::Time',
'a',
'd',
'p',
'f',
'?',
'Obtain time from remote machines',
'GBARR',
'5'
],
[
'Parallel::Pvm',
'b',
'd',
'c',
'f',
'?',
'Interface to the PVM messaging service',
'DLECONTE',
'5'
],
[
'Date::Language',
'a',
'd',
'p',
'O',
'?',
'Multi-language date support',
'GBARR',
'6'
],
[
'Tie::Dir',
'a',
'd',
'p',
'r',
'?',
'Tie hash for reading directories',
'GBARR',
'6'
],
[
'File::Flock',
'M',
'd',
'p',
'h',
'o',
'flock() wrapper.  Auto-create locks',
'MUIR',
'10'
],
[
'File::Slurp',
'M',
'd',
'p',
'f',
'o',
'Read/write/append files quickly',
'URI',
'10'
],
[
'CGI::Out',
'a',
'd',
'p',
'f',
'?',
'Buffer CGI output and report errors',
'MUIR',
'15'
],
[
'Mail::Folder',
'a',
'd',
'p',
'O',
'?',
'Base-class for mail folder handling',
'KJOHNSON',
'19'
],
[
'IO::Select',
'a',
'd',
'p',
'O',
'?',
'Object interface to system select call',
'P5P',
'21'
],
[
'SUPER',
'S',
'u',
'c',
'O',
'?',
'Internal class to access superclass methods',
'P5P',
'2'
],
[
'DynaLoader',
'S',
'u',
'c',
'O',
'?',
'Dynamic loader for shared libraries',
'P5P',
'2'
],
[
'AutoLoader',
'S',
'u',
'p',
'O',
'?',
'Automatic function loader (using AutoSplit)',
'P5P',
'2'
],
[
'Exporter',
'S',
'u',
'p',
'O',
'?',
'Implements default import method for modules',
'P5P',
'2'
],
[
'Carp',
'S',
'u',
'p',
'f',
'?',
'Throw exceptions outside current package',
'P5P',
'2'
],
[
'Config',
'S',
'u',
'p',
'f',
'?',
'Stores details of perl build configuration',
'P5P',
'2'
],
[
'English',
'S',
'u',
'p',
'f',
'?',
'Defines English names for special variables',
'P5P',
'2'
],
[
'strict',
'S',
'u',
'p',
'f',
'?',
'Controls averments (similar to pragmas)',
'P5P',
'27'
],
[
'integer',
'S',
'u',
'p',
'f',
'?',
'Controls float vs. integer arithmetic',
'P5P',
'27'
],
[
'less',
'S',
'u',
'p',
'f',
'?',
'Controls optimisations (yet unimplemented)',
'P5P',
'27'
],
[
'subs',
'S',
'u',
'p',
'f',
'?',
'use subs qw(x y); is short for sub x; sub y;',
'P5P',
'27'
],
[
'vars',
'S',
'u',
'p',
'f',
'?',
'predeclare variable names',
'P5P',
'27'
],
[
'lib',
'S',
'u',
'p',
'f',
'?',
'Simple way to add/delete directories in @INC',
'P5P',
'27'
],
[
'sigtrap',
'S',
'u',
'p',
'f',
'?',
'For trapping an abort and giving a traceback',
'P5P',
'27'
],
[
'Pod::HTML',
'c',
'd',
'p',
'r',
'?',
'converter to HTML',
'KJALB',
'26'
],
[
'Pod::Index',
'b',
'd',
'p',
'O',
'p',
'Index and search POD files that use X<>',
'ITUB',
'26'
],
[
'Pod::Latex',
'c',
'd',
'p',
'r',
'?',
'converter to LaTeX',
'KJALB',
'26'
],
[
'Pod::Man',
'c',
'd',
'p',
'r',
'?',
'converter to man page',
'KJALB',
'26'
],
[
'Pod::Pod',
'c',
'd',
'p',
'r',
'?',
'converter to canonical pod',
'KJALB',
'26'
],
[
'Pod::RTF',
'c',
'd',
'p',
'r',
'?',
'converter to RTF',
'KJALB',
'26'
],
[
'Pod::Texinfo',
'c',
'd',
'p',
'r',
'?',
'converter to texinfo',
'KJALB',
'26'
],
[
'AutoSplit',
'S',
'u',
'p',
'f',
'?',
'Splits modules into files for AutoLoader',
'P5P',
'3'
],
[
'Benchmark',
'S',
'u',
'p',
'f',
'?',
'Easy way to time fragments of perl code',
'P5P',
'3'
],
[
'NetServer::Portal',
'b',
'm',
'p',
'O',
'?',
'Sets up a mini-server accessible via telnet',
'JPRIT',
'16'
],
[
'ExtUtils::DynaGlue',
'a',
'd',
'c',
'r',
'?',
'Methods for generating Perl extension files',
'DOUGM',
'3'
],
[
'POSIX',
'S',
'u',
'p',
'O',
'?',
'An interface to most (all?) of POSIX.1',
'P5P',
'4'
],
[
'Env',
'S',
'u',
'p',
'f',
'?',
'Alias environment variables as perl vars',
'P5P',
'4'
],
[
'Shell',
'S',
'u',
'p',
'f',
'?',
'Run shell commands transparently within perl',
'P5P',
'4'
],
[
'Sys::Hostname',
'S',
'u',
'p',
'f',
'?',
'Implements a portable hostname function',
'P5P',
'4'
],
[
'Sys::Syslog',
'S',
'u',
'p',
'f',
'?',
'Provides same functionality as BSD syslog',
'P5P',
'4'
],
[
'Mac::Components',
'R',
'm',
'c',
'h',
'p',
'(QuickTime) Component Manager',
'CNANDOR',
'4'
],
[
'Mac::Gestalt',
'R',
'm',
'c',
'h',
'p',
'Gestalt Manager (environment enquiries)',
'CNANDOR',
'4'
],
[
'Mac::MoreFiles',
'R',
'm',
'c',
'h',
'p',
'Further file management routines',
'CNANDOR',
'4'
],
[
'Mac::OSA',
'R',
'm',
'c',
'h',
'p',
'Open Scripting Architecture',
'CNANDOR',
'4'
],
[
'Mac::Types',
'R',
'm',
'c',
'h',
'p',
'(Un-)Packing of Macintosh-specific types',
'CNANDOR',
'4'
],
[
'IPC::Open2',
'S',
'u',
'p',
'f',
'?',
'Open a process for both reading and writing',
'P5P',
'5'
],
[
'IPC::Open3',
'S',
'u',
'p',
'f',
'?',
'Like IPC::Open2 but with error handling',
'P5P',
'5'
],
[
'Text::Invert',
'c',
'd',
'p',
'O',
'?',
'Create/query inv. index of text entities',
'NNEUL',
'11'
],
[
'DCE::Login',
'R',
'd',
'c',
'O',
'g',
'Interface to login functions',
'PHENSON',
'5'
],
[
'Text::DelimMatch',
'R',
'd',
'p',
'O',
'?',
'Match (possibly nested) delimited strings',
'NWALSH',
'11'
],
[
'DCE::Status',
'R',
'd',
'c',
'r',
'g',
'Make sense of DCE status codes',
'PHENSON',
'5'
],
[
'DCE::UUID',
'R',
'd',
'c',
'f',
'g',
'Misc uuid functions',
'PHENSON',
'5'
],
[
'DCE::ACL',
'R',
'd',
'c',
'O',
'g',
'Interface to Access Control List protocol',
'PHENSON',
'5'
],
[
'ObjStore',
'R',
'm',
'+',
'O',
'?',
'ObjectStore OODBMS Interface',
'JPRIT',
'7'
],
[
'DCE::RPC',
'R',
'd',
'c',
'f',
'g',
'Remote Procedure Calls',
'PHENSON',
'5'
],
[
'Riscos',
'i',
'',
'',
'',
'?',
'Namespace for Risc-OS (Acorn et.al.)',
'RISCOSML',
'4'
],
[
'Date::Manip',
'R',
'd',
'p',
'f',
'p',
'Complete date/time manipulation package',
'SBECK',
'6'
],
[
'Time::Local',
'S',
'u',
'p',
'f',
'?',
'Implements timelocal() and timegm()',
'P5P',
'6'
],
[
'Tie::Hash',
'S',
'u',
'p',
'r',
'?',
'Base class for implementing tied hashes',
'P5P',
'6'
],
[
'Tie::Scalar',
'S',
'u',
'p',
'r',
'?',
'Base class for implementing tied scalars',
'P5P',
'6'
],
[
'Sort::Versions',
'R',
'd',
'p',
'f',
'?',
'sorting of revision (and similar) numbers',
'EDAVIS',
'6'
],
[
'NDBM_File',
'S',
'u',
'c',
'',
'?',
'Tie to NDBM files',
'P5P',
'7'
],
[
'GDBM_File',
'S',
'u',
'c',
'',
'?',
'Tie to GDBM files',
'P5P',
'7'
],
[
'SDBM_File',
'S',
'u',
'c',
'',
'?',
'Tie to SDBM files',
'P5P',
'7'
],
[
'ODBM_File',
'S',
'u',
'c',
'',
'?',
'Tie to ODBM files',
'P5P',
'7'
],
[
'AnyDBM_File',
'S',
'u',
'p',
'',
'?',
'Uses first available *_File module above',
'P5P',
'7'
],
[
'Term::Complete',
'S',
'u',
'p',
'f',
'?',
'Tab word completion using stty raw',
'P5P',
'8'
],
[
'Term::Cap',
'S',
'u',
'p',
'f',
'?',
'Basic termcap: Tgetent, Tputs, Tgoto',
'TSANDERS',
'8'
],
[
'Cwd',
'S',
'u',
'p',
'f',
'?',
'Current working directory functions',
'P5P',
'10'
],
[
'File::Basename',
'S',
'u',
'p',
'f',
'?',
'Return basename of a filename',
'P5P',
'10'
],
[
'File::CheckTree',
'S',
'u',
'p',
'f',
'?',
'Check file/dir tree against a specification',
'P5P',
'10'
],
[
'File::Find',
'S',
'u',
'p',
'f',
'?',
'Call func for every item in a directory tree',
'P5P',
'10'
],
[
'File::Path',
'S',
'u',
'p',
'f',
'?',
'File path and name utilities',
'P5P',
'10'
],
[
'Text::Abbrev',
'S',
'u',
'p',
'f',
'?',
'Builds hash of all possible abbreviations',
'P5P',
'11'
],
[
'Text::ParseWords',
'S',
'u',
'p',
'f',
'?',
'Parse strings containing shell-style quoting',
'HALPOM',
'11'
],
[
'Text::Soundex',
'S',
'd',
'h',
'f',
'?',
'Encode a string as a soundex value.',
'MARKM',
'11'
],
[
'Search::Dict',
'S',
'u',
'p',
'f',
'?',
'Search a dictionary ordered text file',
'P5P',
'11'
],
[
'Getopt::Std',
'S',
'u',
'p',
'f',
'?',
'Implements basic getopt and getopts',
'P5P',
'12'
],
[
'Locale::gettext',
'R',
'd',
'c',
'f',
'?',
'Multilanguage messages',
'PVANDRY',
'13'
],
[
'EventServer::Functions',
'R',
'n',
'p',
'f',
'?',
'Utility functions for initializing servers',
'JACKS',
'16'
],
[
'Pogo',
'a',
'd',
'+',
'O',
'?',
'Interface for GOODS object database',
'SEYN',
'7'
],
[
'EventServer::Gettimeofday',
'R',
'n',
'p',
'r',
'?',
'gettimeofday syscall wrapper',
'JACKS',
'16'
],
[
'EventServer::Signal',
'R',
'n',
'p',
'r',
'?',
'signalhandler for the eventserver',
'JACKS',
'16'
],
[
'IO::STREAMS',
'c',
'd',
'c',
'O',
'?',
'Methods for System V style STREAMS control',
'PETDANCE',
'21'
],
[
'FileHandle',
'S',
'u',
'p',
'O',
'?',
'File handle objects and methods',
'P5P',
'21'
],
[
'FileCache',
'S',
'u',
'p',
'f',
'?',
'Keep more files open than the system permits',
'P5P',
'21'
],
[
'Pod::Select',
'b',
'd',
'p',
'f',
'?',
'Print only selected sections of pod docs',
'BRADAPP',
'26'
],
[
'VMS::Queue',
'b',
'd',
'c',
'f',
'?',
'Manage queues and entries',
'DSUGAL',
'4'
],
[
'BarCode::UPC',
'i',
'',
'',
'',
'?',
'Produce PostScript UPC barcodes',
'JONO',
'23'
],
[
'Sort::PolySort',
'b',
'd',
'p',
'O',
'?',
'general rules-based sorting of lists',
'DMACKS',
'6'
],
[
'Data::Flow',
'R',
'd',
'p',
'O',
'?',
'Acquire data based on recipes',
'ILYAZ',
'6'
],
[
'PDL::PP',
'a',
'm',
'c',
'f',
'?',
'Automatically generate C code for PDL',
'PERLDL',
'6'
],
[
'Penguin::Easy',
'R',
'd',
'p',
'O',
'?',
'Provides quick, easy access to Penguin API',
'JDUNCAN',
'23'
],
[
'Audio::Sox',
'i',
'',
'',
'',
'?',
'sox sound library as one or more modules',
'PETDANCE',
'23'
],
[
'Pod::Simplify',
'c',
'd',
'p',
'r',
'?',
'Common pod parsing code',
'KJALB',
'26'
],
[
'Pod::Usage',
'b',
'd',
'p',
'f',
'?',
'Print Usage messages based on your own pod',
'BRADAPP',
'26'
],
[
'CPAN',
'R',
'd',
'p',
'O',
'?',
'Perl Archive browse and download',
'ANDK',
'23'
],
[
'FCGI',
'R',
'd',
'h',
'r',
'd',
'Fast CGI',
'SKIMO',
'15'
],
[
'AtExit',
'R',
'd',
'p',
'r',
'?',
'atexit() function to register exit-callbacks',
'BRADAPP',
'20'
],
[
'SyslogScan::SyslogEntry',
'b',
'd',
'p',
'O',
'?',
'Parse UNIX syslog',
'RHNELSON',
'23'
],
[
'SyslogScan::SendmailLine',
'b',
'd',
'p',
'O',
'?',
'Summarize sendmail transactions',
'RHNELSON',
'23'
],
[
'VMS::Process',
'R',
'd',
'c',
'f',
'?',
'Process management on VMS',
'DSUGAL',
'4'
],
[
'WWW::Search',
'M',
'm',
'p',
'O',
'?',
'Front-end to Web search engines',
'MTHURN',
'15'
],
[
'AppleII::Disk',
'b',
'd',
'p',
'O',
'?',
'Read/write Apple II disk image files',
'CJM',
'17'
],
[
'AppleII::ProDOS',
'b',
'd',
'p',
'O',
'?',
'Manipulate files on ProDOS disk images',
'CJM',
'17'
],
[
'AppleII::DOS33',
'i',
'',
'',
'',
'?',
'Manipulate files on DOS 3.3 disk images',
'CJM',
'17'
],
[
'AppleII::Pascal',
'i',
'',
'',
'',
'?',
'Manipulate files on Apple Pascal disk images',
'CJM',
'17'
],
[
'VRML::VRML1',
'R',
'd',
'p',
'O',
'?',
'VRML methods with the VRML 1.0 standard',
'HPALM',
'18'
],
[
'VRML::VRML2',
'R',
'd',
'p',
'O',
'?',
'VRML methods with the VRML 2.0 standard',
'HPALM',
'18'
],
[
'NNML::Server',
'a',
'd',
'p',
'O',
'?',
'An simple RFC 977 NNTP server',
'ULPFR',
'19'
],
[
'PDL::Meschach',
'a',
'm',
'c',
'f',
'?',
'Links PDL to meschach matrix library',
'EGROSS',
'6'
],
[
'PDL::Slatec',
'a',
'm',
'o',
'f',
'?',
'Interface to slatec (linpack+eispack) lib.',
'PERLDL',
'6'
],
[
'Net::ICB',
'b',
'd',
'p',
'O',
'?',
'ICB style chat server interface',
'JMV',
'5'
],
[
'Text::CSV',
'a',
'd',
'p',
'O',
'?',
'Manipulate comma-separated value strings',
'JZUCKER',
'11'
],
[
'DBIx::HTMLView',
'c',
'd',
'p',
'O',
'?',
'Creating web userinterfaces to DBI dbs',
'HAKANARDO',
'7'
],
[
'LWP::Protocol',
'R',
'm',
'p',
'O',
'?',
'LWP support for URL schemes (http, file etc)',
'LWWWP',
'15'
],
[
'MIME::IO',
'?',
'd',
'p',
'O',
'?',
'DEPRECATED: now part of IO::',
'ERYQ',
'15'
],
[
'MIME::Latin1',
'?',
'd',
'p',
'O',
'?',
'DEPRECATED and removed',
'ERYQ',
'15'
],
[
'MIME::Lite',
'R',
'd',
'p',
'O',
'a',
'Easily create MIME/SMTP mails w/attachements',
'YVES',
'15'
],
[
'Win32::AdminMisc',
'R',
'd',
'c',
'f',
'?',
'Misc admin and net functions',
'DAVEROTH',
'22'
],
[
'Win32::GD',
'R',
'd',
'c',
'O',
'?',
'Win32 port of the GD extension (gif module)',
'DAVEROTH',
'22'
],
[
'Win32::Message',
'b',
'd',
'c',
'f',
'?',
'Network based message passing',
'DAVEROTH',
'22'
],
[
'Win32::ODBC',
'R',
'd',
'+',
'O',
'?',
'ODBC interface for accessing databases',
'DAVEROTH',
'22'
],
[
'Win32::Pipe',
'R',
'd',
'+',
'O',
'?',
'Named Pipes and assorted function',
'DAVEROTH',
'22'
],
[
'Pod::MIF',
'a',
'd',
'p',
'O',
'?',
'converter to FrameMaker MIF',
'JNH',
'26'
],
[
'Net::Ident',
'R',
'd',
'p',
'O',
'?',
'Performs ident (rfc1413) lookups',
'JPC',
'5'
],
[
'Math::MatrixCplx',
'i',
'd',
'p',
'O',
'p',
'Matrix data type for Complex Numbers',
'STBEY',
'6'
],
[
'Math::MatrixReal',
'R',
'd',
'p',
'O',
'p',
'Manipulate NxN matrices',
'LETO',
'6'
],
[
'Apache::LogIgnore',
'R',
'd',
'p',
'O',
'g',
'mod_perl log handler to ignore connections',
'BEATNIK',
'16'
],
[
'File::ManualFlock',
'a',
'd',
'p',
'O',
'p',
'Manual file locking; system flock not req',
'WCATLAN',
'10'
],
[
'PDF::PlainLayout',
'b',
'd',
'p',
'O',
'g',
'Package providing simple PDF layout elements',
'STRAITJAC',
'11'
],
[
'Graph::Kruskal',
'R',
'd',
'p',
'f',
'p',
'Kruskal Algorithm for Minimal Spanning Trees',
'STBEY',
'6'
],
[
'ExtUtils::F77',
'R',
'd',
'p',
'O',
'?',
'Facilitate use of FORTRAN from Perl/XS code',
'KGB',
'3'
],
[
'CDB_File',
'a',
'd',
'c',
'',
'?',
'Tie to CDB (Bernstein\'s constant DB) files',
'MSERGEANT',
'7'
],
[
'Term::ANSIColor',
'S',
'd',
'p',
'f',
'p',
'Color output using ANSI escape sequences',
'RRA',
'8'
],
[
'Qt',
'a',
'd',
'+',
'O',
'?',
'Interface to the Qt toolkit',
'AWIN',
'8'
],
[
'Getopt::EvaP',
'M',
'd',
'p',
'f',
'p',
'Long/short options, multilevel help',
'LUSOL',
'12'
],
[
'WWW::Search::Google',
'R',
'd',
'p',
'O',
'p',
'search Google via SOAP',
'LBROCARD',
'15'
],
[
'Net::DNS',
'R',
'm',
'h',
'O',
'p',
'Interface to the DNS resolver',
'OLAF',
'5'
],
[
'Time::Period',
'R',
'd',
'p',
'f',
'?',
'Code to deal with time periods',
'PRYAN',
'6'
],
[
'Term::ReadLine::Perl',
'R',
'd',
'p',
'O',
'?',
'GNU Readline history and completion in Perl',
'ILYAZ',
'8'
],
[
'Taint',
'b',
'd',
'p',
'f',
'?',
'Utilities related to tainting',
'PHOENIX',
'2'
],
[
'Filesys::Df',
'R',
'd',
'p',
'r',
'?',
'Disk free based on Filesys::Statvfs',
'IGUTHRIE',
'10'
],
[
'Parse::Lex',
'a',
'd',
'p',
'O',
'?',
'Generator of lexical analysers',
'PVERD',
'11'
],
[
'Netscape::History',
'b',
'd',
'p',
'O',
'?',
'Class for accessing Netscape history DB',
'NEILB',
'15'
],
[
'Netscape::HistoryURL',
'b',
'd',
'p',
'O',
'?',
'Like a URI::URL, but with visit time',
'NEILB',
'15'
],
[
'Sprite',
'R',
'd',
'p',
'O',
'?',
'Limited SQL interface to flat file databases',
'SHGUN',
'7'
],
[
'Term::ReadLine::Gnu',
'R',
'd',
'c',
'O',
'p',
'GNU Readline XS library wrapper',
'HAYASHI',
'8'
],
[
'X11::Fvwm',
'R',
'd',
'c',
'O',
'?',
'interface to the FVWM window manager API',
'RJRAY',
'8'
],
[
'File::Sync',
'b',
'd',
'c',
'f',
'p',
'POSIX/*nix fsync() and sync()',
'CEVANS',
'10'
],
[
'POE::Session',
'R',
'm',
'p',
'O',
'p',
'an event driven POE task',
'RCAPUTO',
'5'
],
[
'POE::Kernel',
'R',
'm',
'p',
'O',
'p',
'a event based "kernel" for POE sessions',
'RCAPUTO',
'5'
],
[
'BerkeleyDB',
'R',
'd',
'c',
'O',
'p',
'Interface to Berkeley DB version 2, 3 or 4',
'PMQS',
'7'
],
[
'No::Dato',
'R',
'd',
'p',
'f',
'?',
'Norwegian stuff',
'GAAS',
'13'
],
[
'No::KontoNr',
'R',
'd',
'p',
'f',
'?',
'Norwegian stuff',
'GAAS',
'13'
],
[
'No::PersonNr',
'R',
'd',
'p',
'f',
'?',
'Norwegian stuff',
'GAAS',
'13'
],
[
'No::Sort',
'R',
'd',
'p',
'f',
'?',
'Norwegian stuff',
'GAAS',
'13'
],
[
'No::Telenor',
'R',
'd',
'p',
'f',
'?',
'Norwegian stuff',
'GAAS',
'13'
],
[
'WWW::Robot',
'a',
'd',
'p',
'O',
'?',
'Web traversal engine for robots & agents',
'NEILB',
'15'
],
[
'GIFgraph',
'R',
'd',
'p',
'O',
'p',
'Obsolete, see GD::Graph',
'MVERB',
'18'
],
[
'File::Rsync',
'b',
'd',
'p',
'O',
'p',
'Copy efficiently over the net and locally',
'LEAKIN',
'10'
],
[
'Math::SigFigs',
'R',
'd',
'p',
'f',
'p',
'Math using scientific significant figures',
'SBECK',
'6'
],
[
'User::utent',
'c',
'd',
'c',
'O',
'?',
'Interface to utmp/utmpx/wtmp/wtmpx database',
'ROSCH',
'14'
],
[
'Authen::Krb5',
'R',
'd',
'c',
'O',
'?',
'Interface to Kerberos 5 API',
'JHORWITZ',
'14'
],
[
'VMS::Persona',
'R',
'd',
'c',
'f',
'?',
'Interface to the VMS Persona services',
'DSUGAL',
'4'
],
[
'IO::Dir',
'c',
'd',
'p',
'O',
'?',
'Directory handle objects and methods',
'P5P',
'21'
],
[
'Tie::SentientHash',
'b',
'd',
'p',
'r',
'?',
'Tracks changes to nested data structures',
'ANDREWF',
'6'
],
[
'Math::Bezier::Convert',
'a',
'd',
'p',
'f',
'p',
'convert cubic and quadratic bezier curve',
'YSAS',
'6'
],
[
'DBD::mysqlPP',
'b',
'd',
'p',
'O',
'p',
'Pure Perl MySQL driver for the DBI',
'OYAMA',
'7'
],
[
'Proc::ExitStatus',
'R',
'd',
'p',
'f',
'?',
'Interpret and act on wait() status values',
'ROSCH',
'4'
],
[
'Net::LDAP',
'a',
'm',
'p',
'O',
'p',
'Interface to LDAP Protocol (RFC1777)',
'PLDAP',
'5'
],
[
'Math::Fraction',
'b',
'd',
'p',
'O',
'?',
'Fraction Manipulation',
'KEVINA',
'6'
],
[
'PDL::NetCDF',
'R',
'd',
'c',
'O',
'p',
'Reads/Writes NetCDF files from/to PDL objs',
'DHUNT',
'6'
],
[
'Bit::Vector',
'M',
'd',
'c',
'O',
'p',
'Fast virtual arbitrary-size-machineword CPU',
'STBEY',
'6'
],
[
'Date::Convert',
'c',
'd',
'p',
'O',
'?',
'Conversion between Gregorian, Hebrew, more?',
'MORTY',
'6'
],
[
'PerlMenu',
'M',
'd',
'p',
'f',
'?',
'Curses-based menu and template system',
'SKUNZ',
'8'
],
[
'CGI::Session',
'R',
'd',
'p',
'O',
'p',
'Session management in CGI  applications',
'SHERZODR',
'15'
],
[
'Mac::Apps::Launch',
'R',
'd',
'p',
'f',
'p',
'Mac module to launch / quit apps',
'CNANDOR',
'4'
],
[
'X11::XEvent',
'b',
'd',
'c',
'O',
'?',
'provides perl OO acess to XEvent structures',
'MARTINB',
'8'
],
[
'X11::XFontStruct',
'b',
'd',
'c',
'O',
'?',
'provides perl OO access to XFontStruct',
'MARTINB',
'8'
],
[
'X11::Xforms',
'b',
'd',
'c',
'O',
'?',
'provides the binding to the xforms library',
'MARTINB',
'8'
],
[
'Text::Vpp',
'R',
'd',
'p',
'O',
'p',
'Versatile text pre-processor',
'DDUMONT',
'11'
],
[
'Font::TFM',
'R',
'd',
'p',
'O',
'?',
'Read info from TeX font metric files',
'JANPAZ',
'11'
],
[
'TeX::DVI',
'R',
'd',
'p',
'O',
'?',
'Methods for writing DVI (DeVice Independent)',
'JANPAZ',
'11'
],
[
'TeX::Hyphen',
'R',
'd',
'p',
'O',
'?',
'Hyphenate words using TeX\'s patterns',
'JANPAZ',
'11'
],
[
'HTML::Embperl',
'R',
'm',
'c',
'f',
'p',
'Build dynamic Websites (e.g. embed Perl)',
'GRICHTER',
'15'
],
[
'MIME::Words',
'R',
'd',
'p',
'f',
'?',
'Encode/decode RFC1522-escaped header strings',
'ERYQ',
'15'
],
[
'Netscape::Cache',
'R',
'd',
'p',
'O',
'p',
'Access Netscape cache files',
'SREZIC',
'15'
],
[
'Convert::BER',
'a',
'd',
'p',
'O',
'?',
'Class for encoding/decoding BER messages',
'GBARR',
'17'
],
[
'Convert::BinHex',
'a',
'n',
'p',
'O',
'?',
'Convert to/from RFC1741 HQX7 (Mac BinHex)',
'ERYQ',
'17'
],
[
'Image::Magick',
'R',
'd',
'c',
'O',
'?',
'Read, query, transform, and write images',
'JCRISTY',
'18'
],
[
'IO::Scalar',
'R',
'd',
'p',
'O',
'?',
'I/O handle to read/write to a string',
'DSKOLL',
'21'
],
[
'IO::ScalarArray',
'R',
'd',
'p',
'O',
'?',
'I/O handle to read/write to array of scalars',
'DSKOLL',
'21'
],
[
'Schedule::At',
'R',
'd',
'p',
'f',
'p',
'OS independent interface to the at command',
'JOSERODR',
'4'
],
[
'Net::ACAP',
'a',
'd',
'p',
'O',
'?',
'Interface to ACAP Protocol (Internet-Draft)',
'KJOHNSON',
'5'
],
[
'Net::Bind',
'a',
'd',
'p',
'O',
'p',
'Interface to bind daemon related files',
'BBB',
'5'
],
[
'Net::ICAP',
'a',
'd',
'p',
'O',
'?',
'Interface to ICAP Protocol (Internet-Draft)',
'KJOHNSON',
'5'
],
[
'Net::IMAP',
'a',
'd',
'p',
'O',
'?',
'Interface to IMAP Protocol (RFC2060)',
'KJOHNSON',
'5'
],
[
'Net::xAP',
'a',
'd',
'p',
'O',
'?',
'Interface to IMAP,ACAP,ICAP substrate',
'KJOHNSON',
'5'
],
[
'Set::IntRange',
'R',
'd',
'c',
'O',
'p',
'Set of integers (arbitrary intervals, fast)',
'STBEY',
'6'
],
[
'Set::Window',
'R',
'd',
'p',
'O',
'p',
'Manages an interval on the integer line',
'SWMCD',
'6'
],
[
'DBD::Solid',
'a',
'm',
'c',
'O',
'?',
'Solid Driver for DBI',
'TWENRICH',
'7'
],
[
'Term::Size',
'a',
'd',
'c',
'f',
'?',
'Simple way to get terminal size',
'TIMPX',
'8'
],
[
'Text::Refer',
'R',
'd',
'p',
'O',
'?',
'Parse refer(1)-style bibliography files',
'ERYQ',
'11'
],
[
'Locale::Country',
'R',
'd',
'p',
'f',
'?',
'ISO 3166 two letter country codes',
'NEILB',
'13'
],
[
'Locale::Language',
'R',
'd',
'p',
'f',
'?',
'ISO 639 two letter language codes',
'NEILB',
'13'
],
[
'MailBot',
'c',
'd',
'p',
'O',
'?',
'Archive server, listserv, auto-responder',
'RHNELSON',
'16'
],
[
'ThreeD',
'i',
'',
'',
'',
'?',
'Namespace root for all kinds of 3D modules',
'ADESC',
'18'
],
[
'Proc::SafePipe',
'b',
'd',
'p',
'f',
'?',
'popen() and `` without calling the shell',
'ROSCH',
'4'
],
[
'Proc::SyncExec',
'R',
'd',
'p',
'f',
'p',
'Spawn processes but report exec() errors',
'ROSCH',
'4'
],
[
'PDA::Pilot',
'a',
'm',
'c',
'O',
'?',
'Interface to pilot-link library',
'KJALB',
'4'
],
[
'Net::SNMP',
'M',
'd',
'p',
'O',
'p',
'Object oriented interface to SNMP',
'DTOWN',
'5'
],
[
'IPC::Signal',
'R',
'd',
'p',
'f',
'p',
'Translate signal names to/from numbers',
'ROSCH',
'5'
],
[
'DCE::DFS',
'R',
'd',
'c',
'O',
'g',
'DCE Distributed File System interface',
'PHENSON',
'5'
],
[
'B::Graph',
'b',
'd',
'p',
'r',
'p',
'Perl Compiler backend to diagram OP trees',
'SMCCAM',
'2'
],
[
'File::lockf',
'M',
'd',
'c',
'h',
'g',
'Interface to lockf system call',
'PHENSON',
'10'
],
[
'String::ShellQuote',
'R',
'd',
'p',
'f',
'p',
'Quote string for safe passage through shells',
'ROSCH',
'11'
],
[
'News::Gateway',
'a',
'm',
'p',
'O',
'p',
'Mail/news gatewaying, moderation support',
'RRA',
'19'
],
[
'Parse::RecDescent',
'M',
'd',
'p',
'O',
'?',
'Recursive descent parser generator',
'DCONWAY',
'11'
],
[
'Cz::Sort',
'R',
'd',
'p',
'O',
'?',
'Czech sorting',
'JANPAZ',
'13'
],
[
'Cz::Cstocs',
'R',
'd',
'p',
'O',
'?',
'Charset reencoding',
'JANPAZ',
'13'
],
[
'Archive::Tar',
'R',
'd',
'p',
'O',
'p',
'Read, write and manipulate tar files',
'KANE',
'17'
],
[
'Chart::Base',
'R',
'd',
'p',
'O',
'?',
'Business chart widget collection',
'NINJAZ',
'18'
],
[
'Rcs',
'a',
'd',
'c',
'f',
'?',
'Alternate RCS interface (see VCS::RCS)',
'CFRETER',
'3'
],
[
'Sys::Sysconf',
'b',
'd',
'p',
'f',
'?',
'Defines constants for POSIX::sysconf()',
'PETDANCE',
'4'
],
[
'Net::LDAPapi',
'R',
'd',
'c',
'f',
'?',
'Interface to UMICH and Netscape LDAP C API',
'CDONLEY',
'5'
],
[
'Net::Pcap',
'a',
'd',
'c',
'r',
'?',
'An interface for LBL\'s packet capture lib',
'PLISTER',
'5'
],
[
'Tie::Handle',
'R',
'd',
'p',
'O',
'p',
'Base class for implementing tied filehandles',
'STBEY',
'6'
],
[
'Data::Locations',
'R',
'd',
'c',
'O',
'p',
'Insert data into data streams w/o temp files',
'STBEY',
'6'
],
[
'Tree::Base',
'c',
'd',
'p',
'O',
'?',
'Defines a basic binary search tree',
'MSCHWERN',
'6'
],
[
'Tree::Smart',
'c',
'd',
'p',
'O',
'?',
'Splay tree, fastest for commonly accessed ke',
'MSCHWERN',
'6'
],
[
'X11::Protocol',
'b',
'd',
'p',
'O',
'p',
'Raw interface to X Window System servers',
'SMCCAM',
'8'
],
[
'X11::Keysyms',
'b',
'd',
'p',
'f',
'o',
'X11 key symbols (translation of keysymdef.h)',
'SMCCAM',
'8'
],
[
'X11::Auth',
'b',
'd',
'p',
'O',
'p',
'Read and handle X11 \'.Xauthority\' files',
'SMCCAM',
'8'
],
[
'X11::Wcl',
'b',
'd',
'c',
'O',
'?',
'Interface to the Widget Creation Library',
'JHPB',
'8'
],
[
'Locale::Msgcat',
'R',
'd',
'c',
'O',
'?',
'Access to XPG4 message catalog functions',
'CHRWOLF',
'13'
],
[
'PGP::Sign',
'b',
'd',
'p',
'r',
'p',
'Create/verify PGP/GnuPG signatures, securely',
'RRA',
'14'
],
[
'RenderMan',
'a',
'',
'',
'',
'?',
'Manipulate RenderMan objects',
'GMLEWIS',
'18'
],
[
'IO::Tee',
'R',
'd',
'p',
'O',
'?',
'Multiplex output to multiple handles',
'KENSHAN',
'21'
],
[
'Devel::Coverage',
'a',
'd',
'p',
'f',
'?',
'Coverage analysis for Perl code',
'RJRAY',
'3'
],
[
'Devel::DebugInit',
'b',
'd',
'p',
'f',
'?',
'Create a .gdbinit or similar file',
'JASONS',
'3'
],
[
'Devel::SmallProf',
'R',
'd',
'p',
'f',
'?',
'Line-by-line profiler',
'ASHTED',
'3'
],
[
'Algorithm::Numerical::Shuffle',
'R',
'd',
'p',
'h',
'?',
'Knuth\'s shuffle algorithm',
'ABIGAIL',
'6'
],
[
'MSDOS::Attrib',
'R',
'd',
'c',
'f',
'p',
'Get/set DOS file attributes in OS/2 or Win32',
'CJM',
'4'
],
[
'VMS::Priv',
'R',
'd',
'c',
'f',
'?',
'Access VMS Privileges for processes',
'DSUGAL',
'4'
],
[
'PDA::PilotDesktop',
'i',
'',
'',
'',
'?',
'Managing Pilot Desktop databases software',
'JWIEGLEY',
'4'
],
[
'Net::PH',
'R',
'd',
'p',
'O',
'?',
'CCSO Nameserver Client class',
'GBARR',
'5'
],
[
'RADIUS::Dictionary',
'b',
'd',
'p',
'O',
'?',
'Object interface to RADIUS dictionaries',
'CHRMASTO',
'14'
],
[
'RADIUS::Packet',
'b',
'd',
'p',
'O',
'?',
'Object interface to RADIUS (rfc2138) packets',
'CHRMASTO',
'14'
],
[
'Math::Interpolate',
'R',
'd',
'p',
'r',
'?',
'Polynomial interpolation of data',
'MATKIN',
'6'
],
[
'Math::Polynomial',
'R',
'd',
'p',
'O',
'?',
'Polynomials as objects',
'MATKIN',
'6'
],
[
'Calendar::CSA',
'a',
'd',
'c',
'O',
'?',
'interface with calenders such as Sun and CDE',
'KJALB',
'6'
],
[
'DBD::XBase',
'R',
'm',
'p',
'O',
'?',
'XBase driver for DBI',
'JANPAZ',
'7'
],
[
'DBD::pNET',
'a',
'm',
'c',
'O',
'?',
'DBD proxy driver',
'JWIED',
'7'
],
[
'LotusNotes',
'c',
'd',
'c',
'O',
'p',
'Interface to Lotus Notes C API',
'CCLOUTIER',
'24'
],
[
'XBase',
'R',
'd',
'p',
'O',
'?',
'Read/write interface to XBase files',
'JANPAZ',
'7'
],
[
'AsciiDB::TagFile',
'R',
'd',
'p',
'O',
'p',
'Tie class for a simple ASCII database',
'JOSERODR',
'7'
],
[
'OLE::PropertySet',
'a',
'u',
'p',
'O',
'?',
'Property Set interface',
'MSCHWARTZ',
'7'
],
[
'OLE::Storage',
'a',
'u',
'p',
'O',
'?',
'Structured Storage / OLE document interface',
'MSCHWARTZ',
'7'
],
[
'Dir::Purge',
'R',
'd',
'p',
'f',
'?',
'Delete files in directory based on timestamp',
'JV',
'10'
],
[
'Net::Interface',
'a',
'd',
'c',
'O',
'?',
'ifconfig(1) implementation',
'SRZ',
'5'
],
[
'Device::SVGA',
'c',
'',
'',
'',
'?',
'SVGA Graphic card driver',
'SCOTTVR',
'4'
],
[
'VMS::Lock',
'R',
'n',
'c',
'O',
'?',
'Object interface to $ENQ (VMS lock mgr)',
'BHUGHES',
'4'
],
[
'MSDOS::Descript',
'R',
'd',
'p',
'O',
'p',
'Manage 4DOS style DESCRIPT.ION files',
'CJM',
'4'
],
[
'Pod::Sdf',
'c',
'd',
'p',
'f',
'?',
'converter to SDF',
'IANC',
'26'
],
[
'Pod::Diff',
'c',
'd',
'p',
'f',
'?',
'compare two POD files and report diff',
'IANC',
'26'
],
[
'Gtk',
'b',
'd',
'c',
'O',
'?',
'binding of the Gtk library used by GIMP',
'KJALB',
'8'
],
[
'X11::Lib',
'b',
'd',
'c',
'O',
'?',
'X11 library interface',
'KENFOX',
'8'
],
[
'X11::Motif',
'b',
'd',
'c',
'O',
'?',
'Motif widget set interface',
'KENFOX',
'8'
],
[
'X11::Toolkit',
'b',
'd',
'c',
'O',
'?',
'X11 Toolkit library interface',
'KENFOX',
'8'
],
[
'C::DynaLib',
'b',
'd',
'c',
'O',
'?',
'Allows direct calls to dynamic libraries',
'JTOBEY',
'9'
],
[
'File::Spec',
'b',
'd',
'p',
'O',
'?',
'Handling files and directories portably',
'KWILLIAMS',
'10'
],
[
'Text::BibTeX',
'a',
'd',
'c',
'O',
'?',
'Parse BibTeX files',
'GWARD',
'11'
],
[
'Text::Metaphone',
'b',
'd',
'c',
'f',
'?',
'A modern soundex. Phonetic encoding of words',
'MSCHWERN',
'11'
],
[
'Text::Morse',
'c',
'd',
'p',
'f',
'?',
'convert text to/from Morse code',
'SCHOP',
'11'
],
[
'Parse::ePerl',
'R',
'd',
'c',
'r',
'?',
'Embedded Perl (ePerl) parser',
'RSE',
'11'
],
[
'Chatbot::Eliza',
'M',
'd',
'p',
'O',
'p',
'Eliza algorithm encapsulated in an object',
'JNOLAN',
'11'
],
[
'Getopt::Simple',
'M',
'd',
'p',
'O',
'o',
'A simple-to-use interface to Getopt::Long',
'RSAVAGE',
'12'
],
[
'Getopt::Tabular',
'a',
'd',
'p',
'r',
'?',
'Table-driven argument parsing with help text',
'GWARD',
'12'
],
[
'CGI::LogCarp',
'R',
'd',
'p',
'h',
'p',
'Error, log, bug streams, httpd style format',
'MIKEKING',
'15'
],
[
'HTML::ParseForm',
'i',
'',
'',
'',
'?',
'Parse and handle HTML forms via templates',
'NMONNET',
'15'
],
[
'HTML::TableLayout',
'b',
'd',
'p',
'O',
'?',
'an extensible OO layout manager',
'PERSICOM',
'15'
],
[
'Netscape::Server',
'a',
'd',
'c',
'O',
'?',
'Perl interface to Netscape httpd API',
'BSUGARS',
'15'
],
[
'Convert::EBCDIC',
'a',
'd',
'p',
'f',
'?',
'ASCII to/from EBCDIC',
'CXL',
'17'
],
[
'Convert::Recode',
'R',
'd',
'p',
'f',
'?',
'Mapping functions between character sets',
'GAAS',
'17'
],
[
'Convert::Translit',
'M',
'd',
'p',
'O',
'?',
'String conversion among many character sets',
'GENJISCH',
'17'
],
[
'Image::Colorimetry',
'c',
'd',
'p',
'O',
'?',
'transform colors between colorspaces',
'JONO',
'18'
],
[
'Mail::Field',
'R',
'd',
'p',
'O',
'?',
'Base class for handling mail header fields',
'MARKOV',
'19'
],
[
'Mail::Header',
'R',
'd',
'p',
'O',
'?',
'Manipulate mail RFC822 compliant headers',
'MARKOV',
'19'
],
[
'News::Scan',
'c',
'd',
'p',
'O',
'?',
'Gathers and reports newsgroup statistics',
'GBACON',
'19'
],
[
'Net::Hotline',
'R',
'd',
'p',
'O',
'p',
'Interface to the Hotline protocol',
'JSIRACUSA',
'5'
],
[
'Win32API::Registry',
'M',
'?',
'c',
'f',
'?',
'Win32 Registry functions/constants',
'TYEMQ',
'22'
],
[
'Win32API::File',
'M',
'?',
'c',
'f',
'?',
'Win32 file/dir functions/constants',
'TYEMQ',
'22'
],
[
'Win32API::Window',
'c',
'd',
'c',
'f',
'?',
'Win32 Windowing functions/constants',
'TYEMQ',
'22'
],
[
'Chemistry::Elements',
'R',
'd',
'p',
'O',
'p',
'Working with Chemical Elements',
'BDFOY',
'23'
],
[
'Emacs::Lisp',
'b',
'd',
'c',
'h',
'?',
'Perl-to-Emacs-Lisp glue',
'JTOBEY',
'8'
],
[
'File::Sort',
'R',
'd',
'p',
'f',
'p',
'Sort a file or merge sort multiple files',
'CNANDOR',
'10'
],
[
'File::Tail',
'b',
'd',
'p',
'O',
'?',
'A more efficient tail -f',
'MGRABNAR',
'10'
],
[
'File::MultiTail',
'a',
'd',
'p',
'O',
'?',
'Tail multiple files',
'SGMIANO',
'10'
],
[
'Number::Format',
'R',
'd',
'p',
'O',
'a',
'Package for formatting numbers for display',
'WRW',
'11'
],
[
'SGML::SPGrove',
'b',
'd',
'+',
'O',
'?',
'Load SGML, XML, and HTML files',
'KMACLEOD',
'11'
],
[
'Mail::UCEResponder',
'i',
'',
'',
'',
'?',
'Spamfilter',
'CHSTROSS',
'19'
],
[
'News::Article',
'a',
'd',
'p',
'O',
'?',
'Module for handling Usenet articles',
'AGIERTH',
'19'
],
[
'IO::Stty',
'R',
'd',
'p',
'f',
'p',
'POSIX compliant stty interface',
'RGIERSIG',
'21'
],
[
'IO::Wrap',
'R',
'd',
'p',
'O',
'?',
'Wrap old-style FHs in standard OO interface',
'DSKOLL',
'21'
],
[
'Heap::Binary',
'b',
'd',
'p',
'O',
'?',
'Implement Binary Heap',
'JMM',
'6'
],
[
'Heap::Binomial',
'b',
'd',
'p',
'O',
'?',
'Implement Binomial Heap',
'JMM',
'6'
],
[
'Heap::Fibonacci',
'b',
'd',
'p',
'O',
'?',
'Implement Fibonacci Heap',
'JMM',
'6'
],
[
'Perl',
'a',
'd',
'c',
'O',
'?',
'Create Perl interpreters from within Perl',
'GSAR',
'2'
],
[
'Be::Attribute',
'R',
'd',
'+',
'f',
'?',
'Manipulate BeOS BFS MIME file attributes',
'TSPIN',
'4'
],
[
'Tie::CPHash',
'R',
'd',
'p',
'O',
'p',
'Case preserving but case insensitive hash',
'CJM',
'6'
],
[
'Tie::DBI',
'M',
'd',
'p',
'O',
'p',
'Tie hash to a DBI handle',
'LDS',
'6'
],
[
'Class::Singleton',
'b',
'd',
'p',
'O',
'?',
'Implementation of a "Singleton" class',
'ABW',
'6'
],
[
'Class::TOM',
'R',
'm',
'p',
'O',
'?',
'Transportable Object Model for perl',
'JDUNCAN',
'6'
],
[
'Sort::Fields',
'b',
'd',
'p',
'f',
'?',
'sort text lines by alpha or numeric fields',
'JNH',
'6'
],
[
'Data::Check',
'c',
'd',
'p',
'O',
'?',
'Checks values for various data formats',
'KENHOLM',
'6'
],
[
'Tree::Fat',
'R',
'd',
'c',
'f',
'?',
'Embeddable F-Tree algorithm suite',
'JPRIT',
'6'
],
[
'Sybase::BCP',
'R',
'd',
'c',
'O',
'p',
'Sybase BCP interface',
'MEWP',
'7'
],
[
'Mysql',
'R',
'm',
'c',
'O',
'?',
'mysql database interface',
'CAPTTOFU',
'7'
],
[
'Db::Ctree',
'R',
'd',
'c',
'r',
'p',
'Faircom\'s CTREE+ database interface',
'REDEN',
'7'
],
[
'Db::Documentum',
'R',
'd',
'c',
'f',
'p',
'Documentum API interface to Perl',
'MSROTH',
'24'
],
[
'Event',
'b',
'm',
'c',
'h',
'?',
'fast, generic event loop',
'JPRIT',
'16'
],
[
'GUI::Guido',
'i',
'',
'',
'',
'?',
'bd+O Communicate with objects in a GUI',
'TBRADFUTE',
'8'
],
[
'File::Compare',
'S',
'u',
'p',
'f',
'?',
'Compare file contents quickly',
'P5P',
'10'
],
[
'String::CRC',
'R',
'd',
'c',
'f',
'o',
'Cyclic redundency check generation',
'MUIR',
'11'
],
[
'Text::Format',
'R',
'd',
'p',
'O',
'?',
'Advanced paragraph formatting',
'GABOR',
'11'
],
[
'Text::Balanced',
'M',
'd',
'p',
'f',
'p',
'Extract balanced-delimiter substrings',
'DMANURA',
'11'
],
[
'Lingua::PT',
'b',
'u',
'p',
'f',
'?',
'Namespace for Portugese language modules',
'EGROSS',
'11'
],
[
'FrameMaker::FDK',
'i',
'd',
'c',
'O',
'?',
'Interface to Adobe FDK',
'PEASE',
'11'
],
[
'FrameMaker::MIF',
'c',
'd',
'p',
'O',
'?',
'Parse and Manipulate FrameMaker MIF files',
'PEASE',
'11'
],
[
'FrameMaker::Control',
'c',
'd',
'p',
'O',
'?',
'Control a FrameMaker session',
'PEASE',
'11'
],
[
'Authen::TacacsPlus',
'a',
'd',
'c',
'O',
'?',
'Authentication on tacacs+ server',
'MSHOYHER',
'14'
],
[
'CGI::Screen',
'a',
'd',
'p',
'O',
'?',
'Create multi screen CGI-scripts',
'ULPFR',
'15'
],
[
'HTML::Table',
'R',
'u',
'p',
'O',
'p',
'Write HTML tables via spreadsheet metaphor',
'AJPEACOCK',
'15'
],
[
'HTTP::Request::Form',
'R',
'd',
'p',
'O',
'p',
'Generates HTTP::Request objects out of forms',
'GBAUER',
'15'
],
[
'VRML::Color',
'R',
'd',
'p',
'f',
'?',
'color functions and X11 color names',
'HPALM',
'18'
],
[
'VRML::Base',
'R',
'd',
'p',
'O',
'?',
'common basic methods',
'HPALM',
'18'
],
[
'Memoize',
'S',
'd',
'p',
'r',
'p',
'Automatically cache results of functions',
'MJD',
'20'
],
[
'Win32::ChangeNotify',
'R',
'd',
'c',
'O',
'p',
'Monitor changes to files and directories',
'CJM',
'22'
],
[
'Win32::Event',
'R',
'd',
'c',
'O',
'p',
'Use Win32 event objects for IPC',
'CJM',
'22'
],
[
'Win32::IPC',
'R',
'd',
'c',
'O',
'p',
'Base class for Win32 synchronization objects',
'CJM',
'22'
],
[
'Win32::Mutex',
'R',
'd',
'c',
'O',
'p',
'Use Win32 mutex objects for IPC',
'CJM',
'22'
],
[
'Win32::Semaphore',
'R',
'd',
'c',
'O',
'p',
'Use Win32 semaphore objects for IPC',
'CJM',
'22'
],
[
'Business::CreditCard',
'R',
'd',
'p',
'f',
'p',
'Credit card number check digit test',
'IVAN',
'23'
],
[
'Business::ISBN',
'R',
'd',
'p',
'O',
'?',
'Work with ISBN as objects',
'BDFOY',
'23'
],
[
'FAQ::OMatic',
'R',
'd',
'p',
'O',
'?',
'A CGI-based FAQ/help database maintainer',
'ABH',
'23'
],
[
'enum',
'c',
'd',
'p',
'f',
'?',
'resemble enumerated types in C',
'ZENIN',
'27'
],
[
'Devel::DebugAPI',
'b',
'd',
'p',
'f',
'?',
'Interface to the Perl debug environment',
'JHA',
'3'
],
[
'Net::CDDB',
'c',
'd',
'p',
'r',
'?',
'Interface to the CDDB (CD Database)',
'DSTALDER',
'5'
],
[
'Net::Netmask',
'R',
'd',
'p',
'O',
'o',
'Understand and manipulate network blocks',
'MUIR',
'5'
],
[
'Net::TFTP',
'c',
'd',
'p',
'f',
'?',
'Interface to Trivial File Transfer Protocol',
'GSM',
'5'
],
[
'IPC::ChildSafe',
'R',
'd',
'c',
'O',
'?',
'Control child process w/o risk of deadlock',
'DSB',
'5'
],
[
'CORBA::IOP::IOR',
'a',
'd',
'p',
'O',
'?',
'Decode, munge, and re-encode CORBA IORs',
'PHILIPA',
'5'
],
[
'Math::Expr',
'a',
'd',
'p',
'O',
'?',
'Parses agebraic expressions',
'HAKANARDO',
'6'
],
[
'Statistics::ROC',
'b',
'd',
'p',
'f',
'?',
'ROC curves with nonparametric conf. bounds',
'HAKESTLER',
'6'
],
[
'Heap',
'b',
'd',
'p',
'O',
'?',
'Define Heap interface',
'JMM',
'6'
],
[
'Heap::Elem',
'b',
'd',
'p',
'O',
'?',
'Heap Element interface, ISA',
'JMM',
'6'
],
[
'Heap::Elem::Num',
'b',
'd',
'p',
'O',
'?',
'Numeric heap element container',
'JMM',
'6'
],
[
'Heap::Elem::NumRev',
'b',
'd',
'p',
'O',
'?',
'Numeric element reversed order',
'JMM',
'6'
],
[
'Heap::Elem::Str',
'b',
'd',
'p',
'O',
'?',
'String heap element container',
'JMM',
'6'
],
[
'Heap::Elem::StrRev',
'b',
'd',
'p',
'O',
'?',
'String element reversed order',
'JMM',
'6'
],
[
'Heap::Elem::Ref',
'b',
'd',
'p',
'O',
'?',
'Obj ref heap element container',
'JMM',
'6'
],
[
'Heap::Elem::RefRev',
'b',
'd',
'p',
'O',
'?',
'Obj ref element reversed order',
'JMM',
'6'
],
[
'Set::Object',
'b',
'd',
'c',
'O',
'?',
'Set of Objects (smalltalkish: IdentitySet)',
'JLLEROY',
'6'
],
[
'Date::Calc',
'M',
'd',
'c',
'h',
'p',
'Gregorian calendar date calculations',
'STBEY',
'6'
],
[
'Tie::DB_Lock',
'R',
'd',
'p',
'r',
'p',
'Tie DB_File with automatic locking',
'KWILLIAMS',
'6'
],
[
'Tie::TextDir',
'R',
'd',
'p',
'r',
'p',
'ties a hash to a directory of textfiles',
'KWILLIAMS',
'6'
],
[
'DBD::Altera',
'b',
'd',
'p',
'O',
'?',
'Altera SQL Server for DBI - pure Perl code',
'DSOUFLIS',
'7'
],
[
'DBD::CSV',
'R',
'm',
'p',
'O',
'p',
'SQL engine and DBI driver for CSV files',
'JZUCKER',
'7'
],
[
'Metadata::Base',
'b',
'd',
'p',
'O',
'?',
'Base metadata functionality',
'DJBECKETT',
'7'
],
[
'Metadata::IAFA',
'b',
'd',
'p',
'O',
'?',
'IAFA templates metadata',
'DJBECKETT',
'7'
],
[
'Metadata::SOIF',
'b',
'd',
'p',
'O',
'?',
'Harvest SOIF metadata',
'DJBECKETT',
'7'
],
[
'Language::PGForth',
'i',
'',
'',
'',
'?',
'Peter Gallasch\'s Forth implementation',
'PETERGAL',
'9'
],
[
'LockFile::Simple',
'a',
'd',
'p',
'r',
'a',
'Simple file locking mechanism',
'JV',
'10'
],
[
'Stat::lsMode',
'R',
'd',
'p',
'f',
'?',
'Translate mode 0644 to -rw-r--r--',
'MJD',
'10'
],
[
'Text::CSV_XS',
'R',
'd',
'c',
'O',
'p',
'Fast 8bit clean version of Text::CSV',
'JZUCKER',
'11'
],
[
'Text::Graphics',
'R',
'd',
'p',
'O',
'?',
'Graphics rendering toolkit with text output',
'SFARRELL',
'11'
],
[
'Lingua::EN',
'i',
'',
'',
'',
'?',
'Namespace for English language modules',
'',
'11'
],
[
'Lingua::EN::Inflect',
'M',
'd',
'p',
'f',
'?',
'English sing->plur, a/an, nums, participles',
'DCONWAY',
'11'
],
[
'Lingua::EN::Cardinal',
'M',
'n',
'p',
'f',
'r',
'Converts numbers to words',
'HIGHTOWE',
'11'
],
[
'Lingua::EN::Ordinal',
'M',
'n',
'p',
'f',
'r',
'Converts numbers to words',
'HIGHTOWE',
'11'
],
[
'RTF::Base',
'i',
'',
'',
'',
'?',
'Classes for Microsoft Rich Text Format',
'PETDANCE',
'11'
],
[
'SQL::Statement',
'b',
'm',
'p',
'O',
'p',
'Small SQL parser and engine',
'JZUCKER',
'11'
],
[
'Quiz::Question',
'R',
'a',
'p',
'O',
'p',
'Questions and Answers wrapper',
'RFOLEY',
'11'
],
[
'I18N::LangTags',
'M',
'd',
'p',
'f',
'p',
'compare & extract language tags (RFC3066)',
'SBURKE',
'13'
],
[
'Crypt::CBC',
'M',
'd',
'p',
'O',
'p',
'Cipherblock chaining for Crypt::DES/IDEA',
'LDS',
'14'
],
[
'Authen::ACE',
'a',
'd',
'c',
'O',
'?',
'Interface to Security Dynamics ACE (SecurID)',
'DCARRIGAN',
'14'
],
[
'Authen::PAM',
'R',
'd',
'c',
'h',
'p',
'Interface to PAM library',
'NIKIP',
'14'
],
[
'Business::Cashcow',
'i',
'?',
'?',
'?',
'?',
'Internet payment with the Danish PBS',
'GKE',
'23'
],
[
'CGI::CList',
'b',
'd',
'p',
'O',
'?',
'Manages hierarchical collapsible lists',
'PEARCEC',
'15'
],
[
'CGI::Cache',
'a',
'd',
'p',
'f',
'?',
'Speed up slow CGI scripts by caching',
'DCOPPIT',
'15'
],
[
'CGI::Query',
'a',
'd',
'p',
'O',
'?',
'Parse CGI quiry strings',
'MPECK',
'15'
],
[
'CGI::Validate',
'a',
'd',
'p',
'O',
'?',
'Advanced CGI form parser',
'ZENIN',
'15'
],
[
'HTML::Mason',
'M',
'd',
'p',
'O',
'p',
'Build sites from modular Perl/HTML blocks',
'JSWARTZ',
'15'
],
[
'LWP::Parallel',
'R',
'm',
'p',
'O',
'p',
'Allows parallel http, https and ftp access',
'MARCLANG',
'15'
],
[
'HyperWave::CSP',
'c',
'd',
'p',
'O',
'?',
'Interface to HyperWave\'s HCI protocol',
'GOSSAMER',
'15'
],
[
'WebFS::FileCopy',
'R',
'd',
'p',
'f',
'?',
'Get, put, copy, delete files located by URL',
'BZAJAC',
'15'
],
[
'Convert::SciEng',
'b',
'd',
'p',
'O',
'?',
'Convert numbers with scientific notation',
'COLINK',
'17'
],
[
'VRML::Browser',
'i',
'',
'',
'',
'?',
'A complete VRML viewer',
'LUKKA',
'18'
],
[
'Image::Grab',
'R',
'd',
'p',
'O',
'p',
'Grabbing images off the Internet',
'MAHEX',
'18'
],
[
'Chart::Plot',
'b',
'd',
'c',
'O',
'?',
'Graph two-dimensional data (uses GD.pm)',
'SMORTON',
'18'
],
[
'T3D',
'c',
'd',
'p',
'O',
'?',
'Realtime extensible 3D rendering',
'GJB',
'18'
],
[
'Hook::PrePostCall',
'a',
'd',
'p',
'O',
'?',
'Add actions before and after a routine',
'PVERD',
'20'
],
[
'IO::AtomicFile',
'R',
'd',
'p',
'O',
'?',
'Write a file which is updated atomically',
'DSKOLL',
'21'
],
[
'IO::Lines',
'R',
'd',
'p',
'O',
'?',
'I/O handle to read/write to array of lines',
'DSKOLL',
'21'
],
[
'IO::WrapTie',
'R',
'd',
'p',
'O',
'?',
'Tie your handles & retain full OO interface',
'DSKOLL',
'21'
],
[
'IO::Zlib',
'b',
'd',
'p',
'O',
'?',
'IO:: style interface to Compress::Zlib',
'TOMHUGHES',
'21'
],
[
'Win32::SerialPort',
'R',
'd',
'p',
'O',
'?',
'Win32 Serial functions/constants/interface',
'BBIRTH',
'22'
],
[
'HP200LX::DB',
'c',
'd',
'p',
'O',
'?',
'Handle HP 200LX palmtop computer database',
'GGONTER',
'23'
],
[
'HP200LX::DBgui',
'c',
'd',
'p',
'O',
'?',
'Tk base GUI for HP 200LX db files',
'GGONTER',
'23'
],
[
'Decision::Markov',
'b',
'd',
'p',
'O',
'?',
'Build/evaluate Markov models for decisions',
'ALANSZ',
'6'
],
[
'TFTP',
'b',
'd',
'p',
'O',
'?',
'Interface to TFTP (rfc1350)',
'GSM',
'5'
],
[
'Games::WordFind',
'b',
'd',
'p',
'O',
'?',
'Generate word-find type puzzles',
'AJOHNSON',
'23'
],
[
'Cisco::Conf',
'a',
'd',
'p',
'O',
'?',
'Cisco router administratian via TFTP',
'JWIED',
'23'
],
[
'Resolute::RAPS',
'c',
'd',
'+',
'O',
'?',
'Interface to Resolute Software\'s RAPS',
'CHGOETZE',
'24'
],
[
'Async::Process',
'i',
'',
'',
'',
'?',
'class to run sub-processes',
'DDUMONT',
'4'
],
[
'Proc::Background',
'R',
'd',
'p',
'O',
'?',
'OS independent background process objects',
'BZAJAC',
'4'
],
[
'Proc::ProcessTable',
'b',
'd',
'c',
'O',
'?',
'Unix process table information',
'DURIST',
'4'
],
[
'Unix::UserAdmin',
'R',
'a',
'p',
'f',
'?',
'Interface to Unix Account Information',
'JZAWODNY',
'4'
],
[
'SNMP::Monitor',
'a',
'd',
'p',
'O',
'?',
'Accounting and graphical display',
'JWIED',
'5'
],
[
'CORBA::IDLtree',
'R',
'd',
'p',
'f',
'p',
'IDL to symbol tree translator',
'OMKELLOGG',
'5'
],
[
'Math::Fourier',
'i',
'',
'',
'',
'?',
'Fast Fourier Transforms',
'AQUMSIEH',
'6'
],
[
'Math::Integral',
'i',
'',
'',
'',
'?',
'Integration of data',
'AQUMSIEH',
'6'
],
[
'Math::MatrixBool',
'R',
'd',
'c',
'O',
'p',
'Matrix of booleans (Boolean Algebra)',
'STBEY',
'6'
],
[
'Statistics::MaxEntropy',
'R',
'd',
'p',
'f',
'?',
'Maximum Entropy Modeling',
'TERDOEST',
'6'
],
[
'Statistics::OLS',
'b',
'd',
'p',
'O',
'?',
'ordinary least squares (curve fitting)',
'SMORTON',
'6'
],
[
'DBD::ODBC',
'a',
'm',
'c',
'O',
'?',
'ODBC Driver for DBI',
'DBIML',
'7'
],
[
'Db::dmObject',
'c',
'd',
'p',
'O',
'?',
'Object-based interface to Documentum EDMS',
'JGARRISON',
'7'
],
[
'Clips',
'a',
'd',
'p',
'O',
'?',
'Interface to the Expert System Clips',
'MSULLIVAN',
'9'
],
[
'ShellScript::Env',
'a',
'd',
'p',
'O',
'?',
'Simple sh and csh script generator',
'SVENH',
'9'
],
[
'File::BSDGlob',
'b',
'd',
'c',
'f',
'?',
'Secure, csh-compatible filename globbing',
'GBACON',
'10'
],
[
'Tie::Hash::Regex',
'R',
'd',
'p',
'r',
'p',
'Look up values in hashes using regexes',
'DAVECROSS',
'6'
],
[
'Filesys::DiskFree',
'a',
'd',
'p',
'O',
'?',
'OS independant parser of the df command',
'ABARCLAY',
'10'
],
[
'Filesys::Statvfs',
'R',
'd',
'c',
'f',
'?',
'Interface to the statvfs() system call',
'IGUTHRIE',
'10'
],
[
'Text::FillIn',
'R',
'd',
'p',
'O',
'p',
'Fill-in text templates',
'KWILLIAMS',
'11'
],
[
'ERG',
'R',
'd',
'p',
'f',
'?',
'An extensible report generator framework',
'PHOENIXL',
'11'
],
[
'Parse::Yapp',
'R',
'd',
'p',
'O',
'p',
'Generates OO LALR parser modules',
'FDESAR',
'11'
],
[
'SQL::Builder',
'a',
'd',
'p',
'O',
'?',
'OO interface for creating SQL statements',
'ZENIN',
'11'
],
[
'I18N::Charset',
'R',
'd',
'p',
'f',
'p',
'Character set names and aliases',
'MTHURN',
'13'
],
[
'RADIUS::UserFile',
'R',
'd',
'p',
'O',
'p',
'Manipulate a RADIUS users file',
'OEVANS',
'14'
],
[
'HTML::EP',
'a',
'd',
'p',
'O',
'?',
'Modular, extensible Perl embedding',
'JWIED',
'15'
],
[
'HTML::SimpleParse',
'R',
'd',
'p',
'O',
'p',
'Bare-bones HTML parser',
'KWILLIAMS',
'15'
],
[
'NetServer::Generic',
'R',
'd',
'p',
'O',
'?',
'generic OOP class for internet servers',
'CHSTROSS',
'16'
],
[
'Expect',
'R',
'd',
'p',
'O',
'p',
'Perl version of Don Libes\' Tcl-Expect',
'RGIERSIG',
'21'
],
[
'Penguin',
'R',
'd',
'p',
'O',
'?',
'Remote Perl in Secure Environment',
'AMERZKY',
'23'
],
[
'MIDI',
'M',
'd',
'p',
'h',
'p',
'read/edit/compose MIDI files',
'SBURKE',
'23'
],
[
'Geo::METAR',
'R',
'd',
'p',
'f',
'?',
'Process Aviation Weather (METAR) Data',
'JZAWODNY',
'23'
],
[
'Geo::WeatherNOAA',
'R',
'd',
'p',
'f',
'?',
'Current/forecast weather from NOAA',
'MSOLOMON',
'23'
],
[
'Silly::StringMaths',
'a',
'd',
'p',
'f',
'?',
'Do maths with letters and strings',
'SKINGTON',
'23'
],
[
'AltaVista::SearchSDK',
'c',
'd',
'c',
'f',
'?',
'Perl Wrapper for AltaVista SDK functionality',
'JTURNER',
'24'
],
[
'DBIx::Tree',
'a',
'd',
'p',
'O',
'?',
'Expand self-referential table into a tree',
'BJEPS',
'7'
],
[
'Spreadsheet::Excel',
'i',
'',
'',
'',
'?',
'Interface to Excel spreadsheets',
'RRAWLINGS',
'7'
],
[
'Spreadsheet::Lotus',
'i',
'',
'',
'',
'?',
'Interface to Lotus 1-2-3 spreadsheets',
'RRAWLINGS',
'7'
],
[
'Gnome',
'b',
'd',
'c',
'O',
'?',
'Bindings to the Gnome Desktop Toolkit',
'KJALB',
'8'
],
[
'X11::XRT',
'a',
'd',
'c',
'O',
'?',
'XRT widget set (commercial) interface',
'KENFOX',
'8'
],
[
'X11::Xbae',
'a',
'd',
'c',
'O',
'?',
'Xbae matrix (spreadsheet like) interface',
'KENFOX',
'8'
],
[
'X11::Xpm',
'a',
'd',
'c',
'f',
'?',
'X Pixmap library interface',
'KENFOX',
'8'
],
[
'Lingua::EN::Squeeze',
'b',
'd',
'p',
'f',
'?',
'Shorten english text for Pagers/GSM phones',
'JARIAALTO',
'11'
],
[
'XML',
'R',
'm',
'h',
'O',
'?',
'Large collection of XML related modules',
'XMLML',
'11'
],
[
'Getopt::Declare',
'M',
'd',
'p',
'O',
'?',
'An easy-to-use WYSIWYG command-line parser',
'DCONWAY',
'12'
],
[
'Cz::Speak',
'b',
'd',
'p',
'f',
'?',
'number, etc. convertor to the Czech language',
'YENYA',
'13'
],
[
'Compress::LZO',
'M',
'd',
'c',
'f',
'g',
'Interface to the LZO compression library',
'MFX',
'17'
],
[
'PDL::Options',
'R',
'd',
'p',
'h',
'p',
'Provides hash options handling for PDL',
'TJENNESS',
'6'
],
[
'Win32::ASP',
'R',
'd',
'p',
'r',
'?',
'Makes PerlScript ASP development easier',
'WNODOM',
'22'
],
[
'Watchdog::Service',
'a',
'd',
'p',
'O',
'?',
'Look for service in process table',
'PSHARPE',
'23'
],
[
'Watchdog::HTTPService',
'a',
'd',
'p',
'O',
'?',
'Test status of HTTP server',
'PSHARPE',
'23'
],
[
'Watchdog::MysqlService',
'a',
'd',
'p',
'O',
'?',
'Test status of Mysql server',
'PSHARPE',
'23'
],
[
'Real::Encode',
'i',
'',
'',
'',
'?',
'Interface to Progressive Network\'s RealAudio',
'KMELTZ',
'24'
],
[
'Mac::Glue',
'R',
'm',
'p',
'O',
'p',
'Control apps with AppleScript terminology',
'CNANDOR',
'4'
],
[
'Mac::OSA::Simple',
'R',
'm',
'p',
'h',
'p',
'Simple access to Mac::OSA',
'CNANDOR',
'4'
],
[
'Carp::Assert',
'a',
'd',
'p',
'f',
'p',
'Stating the obvious to let the computer know',
'YVES',
'3'
],
[
'Net::DLookup',
'a',
'd',
'p',
'O',
'?',
'Lookup domains on Internic and 2-letter TLDs',
'DJASMINE',
'5'
],
[
'MOP',
'b',
'd',
'p',
'',
'?',
'Meta Object Protocol (Tool collection)',
'ORTALO',
'6'
],
[
'Sort::ArbBiLex',
'M',
'd',
'p',
'f',
'p',
'sort functions for arbitrary sort orders',
'SBURKE',
'13'
],
[
'Data::DRef',
'a',
'd',
'p',
'h',
'?',
'Nested data access using delimited strings',
'EVO',
'6'
],
[
'Data::Reporter',
'R',
'd',
'c',
'O',
'?',
'Ascii Report Generator',
'RVAZ',
'6'
],
[
'Crypt::ElGamal',
'b',
'd',
'p',
'O',
'?',
'ElGamal digital signatures and keys',
'VIPUL',
'14'
],
[
'Crypt::Keys',
'a',
'd',
'p',
'O',
'?',
'Management system for cryptographic keys',
'BTROTT',
'14'
],
[
'Crypt::RSA',
'b',
'm',
'p',
'O',
'?',
'RSA public-key cryptosystem.',
'VIPUL',
'14'
],
[
'OpenCA',
'R',
'm',
'p',
'O',
'b',
'PKIs Object Management Tools',
'MADWOLF',
'14'
],
[
'CGI::Authent',
'M',
'd',
'p',
'p',
'p',
'conditionaly send the HTTP authent request',
'JENDA',
'15'
],
[
'CGI::Deurl',
'M',
'd',
'p',
'h',
'p',
'decode the CGI parameters',
'JENDA',
'15'
],
[
'CGI::Enurl',
'M',
'd',
'p',
'f',
'p',
'encode the CGI parameters',
'JENDA',
'15'
],
[
'CGI::XMLForm',
'a',
'd',
'p',
'O',
'?',
'Create/query XML for forms',
'MSERGEANT',
'15'
],
[
'WING',
'R',
'm',
'h',
'O',
'?',
'Apache based IMAP/NNTP Gateway',
'MICB',
'15'
],
[
'Chart::XMGR',
'R',
'd',
'p',
'h',
'p',
'interface to XMGR plotting package',
'TJENNESS',
'18'
],
[
'Mail::Sender',
'M',
'd',
'p',
'O',
'p',
'socket() based mail with attachments, SMTP',
'JENDA',
'19'
],
[
'Win32::AbsPath',
'R',
'd',
'p',
'f',
'p',
'relative paths to absolute, understands UNCs',
'JENDA',
'22'
],
[
'Win32::FileOp',
'M',
'd',
'p',
'f',
'p',
'file operations + fancy dialogs, INI files',
'JENDA',
'22'
],
[
'Win32::FileType',
'R',
'd',
'p',
'O',
'p',
'modify Win32 file type mapping',
'JENDA',
'22'
],
[
'Ace',
'R',
'd',
'p',
'O',
'p',
'Interface to ACEDB (Popular Genome DB)',
'LDS',
'7'
],
[
'Gtk::Dialog',
'a',
'd',
'p',
'h',
'?',
'Simple interface to create dialogs in Gtk',
'ALISTAIRC',
'8'
],
[
'Authorizenet',
'b',
'd',
'p',
'f',
'?',
'Get Credit Card Info from authorizenet',
'DLINCOLN',
'15'
],
[
'BnP',
'R',
'd',
'o',
'O',
'p',
'Build\'n\'Play all-purpose batch install. tool',
'STBEY',
'23'
],
[
'Devel::PPPort',
'S',
'd',
'c',
'n',
'p',
'Portability aid for your XS code',
'MHX',
'3'
],
[
'MVS::VBFile',
'R',
'd',
'p',
'f',
'p',
'Read MVS VB (variable-length) files',
'GROMMEL',
'4'
],
[
'Solaris::MapDev',
'b',
'd',
'p',
'f',
'?',
'Maps sdNN disk names to cNtNdN disk names',
'ABURLISON',
'4'
],
[
'Solaris::Kstat',
'a',
'd',
'c',
'O',
'?',
'Access kernel performance statistics',
'ABURLISON',
'4'
],
[
'Solaris::Kmem',
'i',
'd',
'c',
'f',
'?',
'Read values from the running kernel',
'ABURLISON',
'4'
],
[
'Solaris::MIB',
'i',
'd',
'c',
'O',
'?',
'Access STREAMS network statistics',
'ABURLISON',
'4'
],
[
'Solaris::NDD',
'i',
'd',
'c',
'O',
'?',
'Access network device statistics',
'ABURLISON',
'4'
],
[
'Algorithm::Diff',
'R',
'd',
'p',
'f',
'p',
'Diff (also Longest Common Subsequence)',
'ANDREWC',
'6'
],
[
'DBD::FreeTDS',
'a',
'd',
'c',
'O',
'?',
'DBI driver for MS SQLServer and Sybase',
'SPANNRING',
'7'
],
[
'DBD::SearchServer',
'c',
'd',
'c',
'O',
'?',
'PCDOCS/Fulcrum SearchServer Driver for DB',
'SHARI',
'7'
],
[
'DbFramework::Attribute',
'a',
'd',
'p',
'O',
'?',
'Relational attribute class',
'PSHARPE',
'7'
],
[
'DbFramework::DataModel',
'a',
'd',
'p',
'O',
'?',
'Relational data model/schema class',
'PSHARPE',
'7'
],
[
'DbFramework::DataType',
'a',
'd',
'p',
'O',
'?',
'Attribute data type class',
'PSHARPE',
'7'
],
[
'DbFramework::ForeignKey',
'a',
'd',
'p',
'O',
'?',
'Relational foreign key class',
'PSHARPE',
'7'
],
[
'DbFramework::Key',
'a',
'd',
'p',
'O',
'?',
'Relational key class',
'PSHARPE',
'7'
],
[
'DbFramework::Persistent',
'a',
'd',
'p',
'O',
'?',
'Persistent object class',
'PSHARPE',
'7'
],
[
'DbFramework::PrimaryKey',
'a',
'd',
'p',
'O',
'?',
'Relational primary key class',
'PSHARPE',
'7'
],
[
'DbFramework::Table',
'a',
'd',
'p',
'O',
'?',
'Relational table/entity class',
'PSHARPE',
'7'
],
[
'DbFramework::Util',
'a',
'd',
'h',
'O',
'?',
'Utility functions/methods',
'PSHARPE',
'7'
],
[
'PostScript::Font',
'R',
'd',
'p',
'O',
'?',
'analyzes PostScript font files',
'JV',
'11'
],
[
'PostScript::FontMetrics',
'R',
'd',
'p',
'O',
'?',
'analyzes Adobe Font Metric files',
'JV',
'11'
],
[
'PostScript::FontInfo',
'R',
'd',
'p',
'O',
'?',
'analyzes Windows font info files',
'JV',
'11'
],
[
'CfgTie',
'a',
'd',
'p',
'h',
'?',
'Framework for tieing system admin tasks',
'RANDYM',
'12'
],
[
'Locale::PGetText',
'b',
'd',
'p',
'f',
'?',
'What GNU gettext does, written in pure perl',
'MSHOYHER',
'13'
],
[
'HTML::Subtext',
'a',
'd',
'p',
'O',
'?',
'Text substitutions on an HTML template',
'KAELIN',
'15'
],
[
'Compress::Bzip2',
'R',
'd',
'c',
'h',
'p',
'Interface to the Bzip2 compression library',
'ARJAY',
'17'
],
[
'Chart::Pie',
'a',
'd',
'p',
'O',
'?',
'Implements "new Chart::Pie()"',
'KARLON',
'18'
],
[
'IMAP::Admin',
'R',
'd',
'p',
'O',
'?',
'IMAP Administration',
'EESTABROO',
'19'
],
[
'Gedcom',
'b',
'm',
'p',
'O',
'p',
'Interface to genealogy Gedcom files',
'PJCJ',
'23'
],
[
'Business::ISSN',
'a',
'd',
'p',
'O',
'?',
'Object and functions to work with ISSN',
'SAPAPO',
'23'
],
[
'List::Util',
'b',
'd',
'c',
'f',
'?',
'List utilities (eg min, max, reduce)',
'GBARR',
'6'
],
[
'Unicode::String',
'R',
'd',
'c',
'O',
'?',
'String manipulation for Unicode strings',
'GAAS',
'13'
],
[
'Tie::RndHash',
'b',
'd',
'p',
'O',
'?',
'choose a random key of a hash in O(1) time',
'DFAN',
'6'
],
[
'Tie::ShadowHash',
'a',
'd',
'p',
'O',
'p',
'Merge multiple data sources into a hash',
'RRA',
'6'
],
[
'Class::Tree',
'M',
'd',
'p',
'O',
'o',
'C++ class hierarchies & disk directories',
'RSAVAGE',
'6'
],
[
'Tangram',
'R',
'm',
'p',
'O',
'?',
'Object persistence in relational databases',
'JLLEROY',
'6'
],
[
'Tree::Trie',
'b',
'd',
'p',
'O',
'?',
'An implementation of the Trie data structure',
'AVIF',
'6'
],
[
'DBD::Empress',
'a',
'd',
'c',
'O',
'?',
'Empress RDBMS Driver',
'SWILLIAM',
'7'
],
[
'Sybase::Async',
'c',
'd',
'p',
'O',
'?',
'interact with a Sybase asynchronously',
'WORENKD',
'7'
],
[
'Emacs',
'a',
'd',
'p',
'f',
'?',
'Support for Perl embedded in GNU Emacs',
'JTOBEY',
'8'
],
[
'File::Signature',
'b',
'd',
'p',
'O',
'p',
'Heuristics for uniquely identifying files',
'JEREMY',
'10'
],
[
'String::CRC32',
'R',
'?',
'c',
'?',
'?',
'ZMODEM-like CRC32 generation',
'SOENKE',
'11'
],
[
'Lingua::EN::Infinitive',
'M',
'd',
'p',
'O',
'o',
'Find infinitive of a conjugated word',
'RSAVAGE',
'11'
],
[
'PostScript::Barcode',
'b',
'd',
'p',
'f',
'?',
'Various types of barcodes as PostScript',
'COLEMAN',
'11'
],
[
'PostScript::Basic',
'b',
'd',
'p',
'O',
'?',
'Basic methods for postscript generation',
'STWIGGER',
'11'
],
[
'Font::TTF',
'b',
'd',
'p',
'O',
'?',
'TrueType font manipulation module',
'MHOSKEN',
'11'
],
[
'CGI::Formalware',
'M',
'd',
'p',
'O',
'o',
'Convert an XML file to a suite of CGI forms',
'RSAVAGE',
'15'
],
[
'CGI::SpeedyCGI',
'M',
'm',
'c',
'n',
'?',
'Run perl CGI scripts persistenly',
'HORROCKS',
'15'
],
[
'HTML::Validator',
'b',
'd',
'p',
'O',
'?',
'HTML validator utilizing nsgmls and libwww',
'SAIT',
'15'
],
[
'WebCache::Digest',
'b',
'd',
'p',
'f',
'?',
'Internet Cache Protocol (RFCs 2186 and 2187)',
'MHAMILTON',
'15'
],
[
'Catalog',
'b',
'm',
'p',
'O',
'g',
'Manage/display resources catalog (URLs etc.)',
'LDACHARY',
'15'
],
[
'Graphics::Libplot',
'R',
'd',
'c',
'O',
'?',
'Binding for C libplotter plotting library',
'JLAPEYRE',
'18'
],
[
'Graphics::Plotter',
'R',
'd',
'+',
'O',
'?',
'Binding for C++ libplotter plotting library',
'MAKLER',
'18'
],
[
'Mail::Sendmail',
'R',
'd',
'p',
'f',
'p',
'Simple platform independent mailer',
'MIVKOVIC',
'19'
],
[
'Win32::COM',
'c',
'd',
'+',
'O',
'?',
'Access to native COM interfaces',
'JDB',
'22'
],
[
'Games::Dice',
'a',
'd',
'p',
'f',
'b',
'Simulates rolling dice',
'RJBS',
'23'
],
[
'Be::Query',
'R',
'a',
'+',
'f',
'p',
'Query a BeOS file system',
'TSPIN',
'4'
],
[
'NetPacket::ARP',
'a',
'd',
'p',
'O',
'?',
'Address Resolution Protocol',
'ATRAK',
'5'
],
[
'NetPacket::Ethernet',
'a',
'd',
'p',
'O',
'?',
'Ethernet framed data',
'ATRAK',
'5'
],
[
'NetPacket::IGMP',
'a',
'd',
'p',
'O',
'?',
'Internet Group Management Protocol',
'ATRAK',
'5'
],
[
'NetPacket::IP',
'a',
'd',
'p',
'O',
'?',
'Internet Protocol',
'ATRAK',
'5'
],
[
'NetPacket::TCP',
'a',
'd',
'p',
'O',
'?',
'Transmission Control Protocol',
'ATRAK',
'5'
],
[
'Schedule::Match',
'a',
'd',
'p',
'f',
'?',
'Pattern-based crontab-like schedule',
'TAIY',
'23'
],
[
'NetPacket::UDP',
'a',
'd',
'p',
'O',
'?',
'User Datagram Protocol',
'ATRAK',
'5'
],
[
'Persistence::Object',
'a',
'd',
'p',
'O',
'?',
'Store Object definitions with Data::Dumper',
'VIPUL',
'6'
],
[
'File::chmod',
'M',
'd',
'p',
'f',
'?',
'Allows for symbolic chmod notation',
'PINYAN',
'10'
],
[
'Text::Bastardize',
'c',
'd',
'p',
'O',
'p',
'corrupts text in various ways',
'AYRNIEU',
'11'
],
[
'Crypt::Random',
'R',
'd',
'p',
'h',
'?',
'Cryptographically Strong Random Numbers',
'VIPUL',
'14'
],
[
'Crypt::Rot13',
'c',
'd',
'p',
'O',
'?',
'simple encryption often seen on usenet',
'AYRNIEU',
'14'
],
[
'CGI::Debug',
'M',
'd',
'p',
'h',
'?',
'show CGI debugging data',
'JONAS',
'15'
],
[
'CGI::Persistent',
'a',
'd',
'p',
'O',
'?',
'Transparent State Persistence in CGI scripts',
'VIPUL',
'15'
],
[
'Chart::Graph',
'R',
'm',
'p',
'r',
'?',
'front-end to gnuplot and XRT',
'CAIDAPERL',
'18'
],
[
'Chart::Gdchart',
'b',
'd',
'c',
'h',
'?',
'based on Bruce V\'s C gdchart distribution',
'MHEMPEL',
'18'
],
[
'Win32API::CommPort',
'R',
'd',
'p',
'O',
'?',
'Win32 Serial functions/constants/interface',
'BBIRTH',
'22'
],
[
'Tie::ListKeyedHash',
'R',
'd',
'p',
'r',
'?',
'Use lists to key multi-level hashes',
'SNOWHARE',
'6'
],
[
'DFA::Command',
'M',
'd',
'p',
'O',
'o',
'Discrete Finite Automata command processor',
'RSAVAGE',
'6'
],
[
'DFA::Kleene',
'R',
'd',
'p',
'f',
'p',
'Kleene\'s Algorithm for DFA',
'STBEY',
'6'
],
[
'DFA::Simple',
'c',
'd',
'p',
'O',
'?',
'An "augmented transition network"',
'RANDYM',
'6'
],
[
'DBIx::Table',
'b',
'd',
'p',
'O',
'?',
'OO access to DBI database tables',
'DLOWE',
'7'
],
[
'X500::DN::Parser',
'M',
'd',
'p',
'O',
'o',
'X500 Distinguished Name parser',
'RSAVAGE',
'6'
],
[
'HTML::Template',
'M',
'm',
'p',
'O',
'p',
'a simple HTML templating system',
'SAMTREGAR',
'15'
],
[
'Astro::SLA',
'R',
'd',
'c',
'f',
'p',
'Interface to SLALIB positional astronomy lib',
'TJENNESS',
'23'
],
[
'MQSeries',
'R',
'd',
'c',
'O',
'?',
'IBM\'s MQSeries messaging product interface',
'HBIERSMA',
'24'
],
[
'Unix::ConfigFile',
'a',
'd',
'p',
'O',
'?',
'Abstract interfaces to Unix config files',
'SSNODGRA',
'4'
],
[
'Hardware::Simulator',
'a',
'd',
'p',
'f',
'?',
'Simulate different pieces of hardware',
'GSLONDON',
'4'
],
[
'IPC::Session',
'b',
'n',
'p',
'O',
'?',
'remote shell session mgr; wraps open3()',
'STEVEGT',
'5'
],
[
'Exporter::Import',
'R',
'd',
'p',
'n',
'?',
'Alternate symbol exporter',
'GARROW',
'2'
],
[
'Scalar::Util',
'b',
'd',
'c',
'f',
'?',
'Scalar utilities (dualvar reftype etc)',
'GBARR',
'6'
],
[
'Time::Avail',
'R',
'd',
'p',
'f',
'?',
'Calculate min. remaining in time interval',
'PSANTORO',
'6'
],
[
'Verilog::Pli',
'R',
'd',
'c',
'h',
'p',
'Access to simulator functions',
'WSNYDER',
'9'
],
[
'Verilog::Language',
'R',
'd',
'p',
'f',
'p',
'Language support, number parsing, etc',
'WSNYDER',
'9'
],
[
'Verilog::Parser',
'R',
'd',
'p',
'O',
'p',
'Language parsing',
'WSNYDER',
'9'
],
[
'Verilog::SigParser',
'R',
'd',
'p',
'O',
'p',
'Signal and module extraction',
'WSNYDER',
'9'
],
[
'Unicode::Map8',
'R',
'd',
'c',
'O',
'?',
'Convert between most 8bit encodings',
'GAAS',
'13'
],
[
'Digest::MD5',
'R',
'd',
'c',
'h',
'p',
' MD5 message digest algorithm',
'GAAS',
'14'
],
[
'Digest::MD2',
'R',
'd',
'c',
'h',
'?',
' MD2 message digest algorithm',
'GAAS',
'14'
],
[
'Digest::SHA1',
'c',
'd',
'c',
'h',
'?',
' NIST SHA message digest algorithm',
'UWEH',
'14'
],
[
'Digest::HMAC',
'R',
'd',
'p',
'h',
'?',
' HMAC message integrity check',
'GAAS',
'14'
],
[
'URI::Attr',
'a',
'm',
'p',
'O',
'?',
'Stores attributes in the URI name space',
'LWWWP',
'15'
],
[
'HTML::HeadParser',
'R',
'm',
'p',
'O',
'?',
' Parse <HEAD> section of HTML documents',
'LWWWP',
'15'
],
[
'HTML::LinkExtor',
'R',
'm',
'p',
'O',
'?',
' Extract links from HTML documents',
'LWWWP',
'15'
],
[
'HTML::Parser',
'R',
'm',
'c',
'O',
'?',
'Basic HTML Parser',
'LWWWP',
'15'
],
[
'HTML::TokeParser',
'R',
'm',
'p',
'O',
'?',
' Alternative HTML::Parser interface',
'LWWWP',
'15'
],
[
'HTTP::Cookies',
'R',
'm',
'p',
'O',
'?',
'Storage of cookies',
'LWWWP',
'15'
],
[
'HTTP::Daemon',
'R',
'm',
'p',
'O',
'?',
'Base class for simple HTTP servers',
'LWWWP',
'15'
],
[
'HTTP::Request::Common',
'R',
'm',
'p',
'f',
'?',
'Functions that generate HTTP::Requests',
'LWWWP',
'15'
],
[
'LWP::Conn',
'a',
'm',
'p',
'O',
'?',
'LWPng stuff',
'LWWWP',
'15'
],
[
'CIPP',
'R',
'd',
'p',
'O',
'p',
'Preprocessor for embedding Perl, SQL in HTML',
'JRED',
'15'
],
[
'Device::SerialPort',
'R',
'd',
'h',
'O',
'g',
'POSIX clone of Win32::SerialPort',
'COOK',
'4'
],
[
'ControlX10::CM10',
'R',
'm',
'p',
'O',
'?',
'Control unit for X10 modules',
'BBIRTH',
'5'
],
[
'ControlX10::CM17',
'R',
'm',
'p',
'O',
'?',
'inexpensive RF transmit-only X10',
'BBIRTH',
'5'
],
[
'PostScript::Document',
'b',
'd',
'p',
'O',
'?',
'Generate multi-page PostScript',
'SHAWNPW',
'11'
],
[
'PostScript::Elements',
'b',
'd',
'p',
'O',
'?',
'Objects for shapes, lines, images',
'SHAWNPW',
'11'
],
[
'PostScript::Metrics',
'b',
'd',
'p',
'O',
'?',
'Font metrics data used by PS::TextBlock',
'SHAWNPW',
'11'
],
[
'PostScript::TextBlock',
'b',
'd',
'p',
'O',
'?',
'Objects used by PS::Document',
'SHAWNPW',
'11'
],
[
'Crypt::Passwd',
'M',
'd',
'h',
'f',
'?',
'Perl wrapper around the UFC Crypt',
'LUISMUNOZ',
'14'
],
[
'Crypt::PasswdMD5',
'M',
'd',
'h',
'f',
'?',
'Interoperable MD5-based crypt() function',
'LUISMUNOZ',
'14'
],
[
'Astro::Time',
'R',
'd',
'p',
'f',
'p',
'General time conversions for Astronomers',
'CPHIL',
'23'
],
[
'Astro::Coord',
'R',
'd',
'p',
'f',
'p',
'Transform telescope and source coordinates',
'CPHIL',
'23'
],
[
'Astro::Misc',
'R',
'd',
'p',
'f',
'p',
'Miscellaneous astronomical routines',
'CPHIL',
'23'
],
[
'FFI',
'c',
'd',
'c',
'f',
'?',
'Low-level Foreign Function Interface',
'PMOORE',
'9'
],
[
'FFI::Library',
'c',
'd',
'c',
'O',
'?',
'Access to functions in shared libraries',
'PMOORE',
'9'
],
[
'FFI::Win32::Typelib',
'i',
'd',
'c',
'O',
'?',
'FFI taking definitions from a type library',
'PMOORE',
'9'
],
[
'FFI::Win32::COM',
'i',
'd',
'c',
'O',
'?',
'Access to COM using VTBL interface',
'PMOORE',
'9'
],
[
'String::RexxParse',
'R',
'd',
'p',
'h',
'?',
'Perl implementation of REXX \'parse\' command',
'BLCKSMTH',
'11'
],
[
'B::Fathom',
'b',
'd',
'p',
'O',
'?',
'Estimate the readability of Perl code',
'KSTAR',
'2'
],
[
'ClearCase',
'i',
'd',
'c',
'f',
'?',
'Environment for ClearCase revision control',
'BRADAPP',
'3'
],
[
'X500::RDN',
'a',
'd',
'p',
'O',
'p',
'handle X.500 Relative Distinguished Names',
'RJOOP',
'6'
],
[
'Tie::HashDefaults',
'a',
'd',
'p',
'r',
'?',
'Let a hash have default values',
'JDPORTER',
'6'
],
[
'Tie::Multidim',
'a',
'd',
'p',
'r',
'?',
'"tie"-like multidimensional data structures',
'JDPORTER',
'6'
],
[
'Tie::OffsetArray',
'a',
'd',
'p',
'r',
'?',
'Tie one array to another, with index offset',
'JDPORTER',
'6'
],
[
'Text::Macros',
'a',
'd',
'p',
'O',
'?',
'template macro expander (OO)',
'JDPORTER',
'11'
],
[
'Text::SimpleTemplate',
'a',
'd',
'p',
'O',
'?',
'Template for dynamic text generation',
'TAIY',
'11'
],
[
'Lingua::DetectCharset',
'R',
'd',
'p',
'f',
'p',
'Heuristics to detect coded character sets',
'JNEYSTADT',
'11'
],
[
'Lingua::RU::Charset',
'a',
'n',
'p',
'f',
'?',
'Detect/Convert russian character sets.',
'FARBER',
'11'
],
[
'Mac::AssistantFrames',
'R',
'd',
'p',
'O',
'p',
'Easy creation of assistant dialogs',
'GBAUER',
'4'
],
[
'B::LexInfo',
'b',
'd',
'c',
'O',
'?',
'Show info about subroutine lexical variables',
'DOUGM',
'2'
],
[
'B::Size',
'b',
'd',
'c',
'O',
'?',
'Measure size of Perl OPs and SVs',
'DOUGM',
'2'
],
[
'B::TerseSize',
'b',
'd',
'p',
'O',
'?',
'Info about ops and their (estimated) size',
'DOUGM',
'2'
],
[
'GTop',
'b',
'd',
'c',
'O',
'?',
'Perl interface to libgtop',
'MJH',
'4'
],
[
'DBM::DBass',
'a',
'd',
'p',
'f',
'?',
'DBM with hashes, locking and XML records',
'SPIDERBOY',
'7'
],
[
'File::LckPwdF',
'a',
'd',
'c',
'f',
'?',
'Lock and unlock the passwd file',
'ALLENS',
'10'
],
[
'FrameMaker',
'c',
'd',
'p',
'O',
'?',
'Top level FrameMaker interface',
'PEASE',
'11'
],
[
'HTML::CalendarMonth',
'R',
'm',
'p',
'O',
'p',
'Calendar Months as easy HTML::Element trees',
'MSISK',
'15'
],
[
'HTML::ElementGlob',
'R',
'm',
'p',
'O',
'p',
'Manipulate multiple HTML elements as one',
'MSISK',
'15'
],
[
'HTML::ElementRaw',
'R',
'm',
'p',
'O',
'p',
'Graft HTML strings onto an HTML::Element',
'MSISK',
'15'
],
[
'HTML::ElementSuper',
'R',
'm',
'p',
'O',
'?',
'Various HTML::Element extensions',
'MSISK',
'15'
],
[
'HTML::ElementTable',
'R',
'm',
'p',
'O',
'?',
'Tables as easy HTML element structures',
'MSISK',
'15'
],
[
'Xmms',
'b',
'd',
'c',
'O',
'?',
'Interactive remote control shell for xmms',
'DOUGM',
'18'
],
[
'Xmms::Config',
'b',
'd',
'c',
'O',
'?',
'Perl interface to the xmms_cfg_* API',
'DOUGM',
'18'
],
[
'Xmms::Remote',
'b',
'd',
'c',
'O',
'?',
'Perl interface to the xmms_remote_* API',
'DOUGM',
'18'
],
[
'Xmms::Plugin',
'i',
'',
'',
'',
'?',
'Perl interface to the xmms plugin APIs',
'DOUGM',
'18'
],
[
'Audio::CD',
'b',
'd',
'c',
'O',
'?',
'Perl interface to libcdaudio (cd + cddb)',
'DOUGM',
'23'
],
[
'Algorithm::Permute',
'b',
'd',
'c',
'O',
'g',
'Handy and fast permutation with OO interface',
'EDPRATOMO',
'6'
],
[
'Lingua::Ispell',
'a',
'd',
'p',
'f',
'?',
'Interface to the Ispell spellchecker',
'JDPORTER',
'11'
],
[
'Geo::Storm_Tracker',
'i',
'',
'',
'',
'?',
'Retrieves tropical storm advisories',
'CARPENTER',
'23'
],
[
'Net::Goofey',
'R',
'd',
'p',
'O',
'?',
'Communicate with a Goofey server',
'GOSSAMER',
'5'
],
[
'Net::ICQ',
'b',
'm',
'p',
'O',
'?',
'Client interface to ICQ messaging',
'JMUHLICH',
'5'
],
[
'Unix::Syslog',
'R',
'd',
'c',
'f',
'a',
'Interface to syslog functions in a C-library',
'MHARNISCH',
'4'
],
[
'Glade',
'b',
'd',
'p',
'h',
'p',
'Glade/Gtk+/Gnome UI source code generator',
'DMUSGR',
'8'
],
[
'Image::ParseGIF',
'R',
'a',
'p',
'O',
'?',
'Parse GIF images into component parts',
'BENL',
'18'
],
[
'DBD::Multiplex',
'R',
'm',
'p',
'O',
'?',
'Spreading database load across servers',
'TKISHEL',
'7'
],
[
'Authen::Ticket',
'a',
'd',
'p',
'O',
'?',
'Suite consisting of master/client/tools',
'JSMITH',
'14'
],
[
'MIME::Types',
'M',
'd',
'p',
'O',
'p',
'Information and processing MIME types',
'MARKOV',
'15'
],
[
'R3',
'b',
'd',
'c',
'O',
'p',
'Interface to SAP R/3 using RFCSDK',
'SCHOEN',
'24'
],
[
'Math::Geometry',
'a',
'd',
'p',
'f',
'?',
'2D and 3D algorithms',
'GMCCAR',
'6'
],
[
'VDBM',
'c',
'd',
'p',
'h',
'?',
'Client/server-layers on top of DBM files',
'RAM',
'7'
],
[
'Mail::Ezmlm',
'b',
'd',
'p',
'O',
'?',
'Object methods for ezmlm mailing lists',
'GHALSE',
'19'
],
[
'Exporter::Options',
'a',
'd',
'p',
'O',
'?',
'Extends Exporter to handle use-line options',
'YSTH',
'2'
],
[
'Exporter::PkgAlias',
'a',
'd',
'p',
'f',
'?',
'Load a module into multiple namespaces',
'JDPORTER',
'2'
],
[
'Coy',
'R',
'd',
'p',
'n',
'?',
'Like Carp - only prettier',
'DCONWAY',
'3'
],
[
'Calendar::Hebrew',
'c',
'd',
'p',
'O',
'?',
'Hebrew calendar conversion/manipulation',
'YSTH',
'6'
],
[
'Lingua::EN::Hyphenate',
'b',
'd',
'p',
'f',
'?',
'Syllable based hyphenation',
'DCONWAY',
'11'
],
[
'Chart::PNGgraph',
'R',
'd',
'p',
'O',
'?',
'Package to generate PNG graphs, uses GD.pm',
'SBONDS',
'18'
],
[
'Test',
'S',
'd',
'p',
'f',
'?',
'Utilities for writing test scripts',
'SBURKE',
'3'
],
[
'Devel::TraceLoad',
'R',
'd',
'p',
'f',
'p',
'Traces the loading of perl source code',
'PVERD',
'3'
],
[
'IPChains',
'R',
'd',
'c',
'O',
'?',
'Create and Manipulate ipchains',
'JESSICAQ',
'5'
],
[
'Mon::Client',
'R',
'd',
'p',
'O',
'?',
'Network monitoring client',
'TROCKIJ',
'5'
],
[
'Mon::SNMP',
'R',
'd',
'p',
'O',
'?',
'Network monitoring suite',
'TROCKIJ',
'5'
],
[
'Time::Warp',
'R',
'm',
'c',
'f',
'?',
'Change the start and speed of Event time',
'JPRIT',
'16'
],
[
'Event::Stats',
'R',
'm',
'c',
'f',
'?',
'Collects statistics for Event',
'JPRIT',
'16'
],
[
'Event::tcp',
'b',
'm',
'p',
'O',
'?',
'TCP session layer library',
'JPRIT',
'16'
],
[
'URI::Bookmarks',
'b',
'd',
'p',
'O',
'?',
'A Class for bookmark collections',
'ASPIERS',
'15'
],
[
'Exception::Cxx',
'R',
'd',
'+',
'f',
'?',
'Cause perl to longjmp using C++ exceptions',
'JPRIT',
'3'
],
[
'Symbol::Table',
'R',
'd',
'p',
'O',
'p',
'OO interface to package symbols',
'GSLONDON',
'2'
],
[
'Carp::CheckArgs',
'R',
'd',
'p',
'f',
'?',
'Check subroutine argument types',
'GARROW',
'3'
],
[
'Proc::Spawn',
'R',
'd',
'p',
'f',
'p',
'Run external programs',
'GARROW',
'4'
],
[
'SOOP',
'R',
'd',
'p',
'O',
'?',
'Safe Object Oriented Programming',
'GARROW',
'6'
],
[
'Rc',
'c',
'd',
'c',
'O',
'?',
'Perl interface for the Rc shell',
'JPRIT',
'9'
],
[
'IO::React',
'R',
'd',
'p',
'O',
'p',
'Object oriented expect-like communication',
'GARROW',
'21'
],
[
'Tie::SecureHash',
'R',
'd',
'p',
'O',
'?',
'Enforced encapsulation of Perl objects',
'DCONWAY',
'6'
],
[
'Class::Multimethods',
'R',
'd',
'p',
'f',
'?',
'A multiple dispatch mechanism for Perl',
'DCONWAY',
'6'
],
[
'Tie::Cache::LRU',
'a',
'd',
'p',
'r',
'?',
'A Least-Recently Used cache',
'MSCHWERN',
'6'
],
[
'Curses::Forms',
'b',
'm',
'p',
'O',
'g',
'Form management for Curses::Widgets',
'CORLISS',
'8'
],
[
'RTF::Generator',
'b',
'd',
'p',
'O',
'p',
'Generation of RTF documents',
'RRWO',
'11'
],
[
'RTF::Parser',
'a',
'',
'',
'',
'?',
'Base class for parsing RTF files',
'SARGIE',
'11'
],
[
'Crypt::UnixCrypt',
'R',
'd',
'p',
'f',
'?',
'Perl-only implementation of crypt(3)',
'MVORL',
'14'
],
[
'Tie::FileLRUCache',
'R',
'd',
'p',
'h',
'p',
'File based persistent LRU cache',
'SNOWHARE',
'6'
],
[
'Class::NamedParms',
'M',
'd',
'p',
'O',
'p',
'A named parameter accessor base class',
'SNOWHARE',
'6'
],
[
'Class::ParmList',
'M',
'd',
'p',
'h',
'p',
'A named parameter list processor',
'SNOWHARE',
'6'
],
[
'Data::Walker',
'R',
'd',
'p',
'O',
'p',
'Navigate through Perl data structures',
'JNOLAN',
'6'
],
[
'Lingua::Stem',
'M',
'd',
'p',
'h',
'p',
'Word stemmer with localization',
'SNOWHARE',
'11'
],
[
'Search::InvertedIndex',
'R',
'd',
'p',
'O',
'?',
'Inverted index database support',
'SNOWHARE',
'11'
],
[
'CGI::Minimal',
'M',
'd',
'p',
'O',
'p',
'A micro-sized CGI handler',
'SNOWHARE',
'15'
],
[
'Perf::ARM',
'a',
'd',
'c',
'f',
'?',
'Application Response Measurement',
'BBACKER',
'3'
],
[
'VCS',
'a',
'm',
'p',
'O',
'p',
'Generic interface to Version Control Systems',
'GMCCAR',
'3'
],
[
'Net::IMAP::Simple',
'b',
'd',
'p',
'O',
'?',
'Only implements the basic IMAP features',
'JPAF',
'5'
],
[
'DBD::Illustra',
'b',
'm',
'c',
'O',
'?',
'Illustra Driver for DBI',
'PMH',
'7'
],
[
'BBDB',
'R',
'd',
'p',
'h',
'?',
'Insiduous big brother database',
'LAXEN',
'7'
],
[
'Lingua::EN::Syllable',
'a',
'',
'',
'',
'?',
'Estimate syllable count in words',
'GREGFAST',
'11'
],
[
'Log::Agent',
'a',
'd',
'p',
'O',
'a',
'A general logging framework',
'MROGASKI',
'21'
],
[
'Win32::GuiTest',
'M',
'm',
'c',
'f',
'p',
'SendKeys, FindWindowLike and more',
'ERNGUI',
'22'
],
[
'WDDX',
'R',
'd',
'p',
'O',
'p',
'Allows distributed data exchange via XML',
'ZOMBITHRD',
'15'
],
[
'Text::Wrap::Hyphenate',
'a',
'',
'',
'',
'?',
'Like Text::Wrap with ability to hyphenate',
'MJD',
'11'
],
[
'LWP',
'R',
'm',
'p',
'O',
'?',
'Libwww-perl',
'LWWWP',
'15'
],
[
'VRML',
'R',
'd',
'p',
'O',
'?',
'VRML methods independent of specification',
'HPALM',
'18'
],
[
'Unix::Processors',
'R',
'd',
'c',
'O',
'p',
'Interface to per-processor information',
'WSNYDER',
'4'
],
[
'IPC::Locker',
'R',
'd',
'p',
'O',
'p',
'Shared semaphore locks across a network',
'WSNYDER',
'5'
],
[
'Object::Transaction',
'R',
'd',
'p',
'O',
'o',
'Transactions on serialized HASH files',
'MUIR',
'6'
],
[
'DBD::ASAny',
'a',
'd',
'c',
'O',
'?',
'Adaptive Server Anywhere Driver for DBI',
'SMIRNIOS',
'7'
],
[
'Term::TUI',
'b',
'd',
'p',
'f',
'p',
'User interface based on Term::ReadLine',
'SBECK',
'8'
],
[
'Curses::Widgets',
'b',
'm',
'p',
'O',
'g',
'Assorted widgets for rapid interface design',
'CORLISS',
'8'
],
[
'Crypt::Twofish',
'R',
'd',
'c',
'O',
'a',
'The Twofish Encryption Algorithm',
'AMS',
'14'
],
[
'BizTalk',
'R',
'd',
'p',
'O',
'?',
'Microsoft BizTalk Framework Toolkit',
'SIMONJ',
'15'
],
[
'Mail::Freshmeat',
'R',
'd',
'p',
'O',
'g',
'Parses newsletters from http://freshmeat.net',
'FOX',
'19'
],
[
'PQI',
'c',
'd',
'c',
'O',
'?',
'Perl Queuing Interface, to MQSeries, MSMQ',
'SIMONJ',
'24'
],
[
'Getopt::ArgvFile',
'M',
'd',
'p',
'f',
'a',
'Take options from files',
'JSTENZEL',
'12'
],
[
'MARC::XML',
'a',
'm',
'p',
'O',
'?',
'MAchine Readable Catalog / XML Extension',
'PERL4LIB',
'7'
],
[
'LockFile::Lock',
'a',
'd',
'p',
'O',
'a',
'Lock handles created by LockFile::* schemes',
'JV',
'10'
],
[
'LockFile::Manager',
'a',
'd',
'p',
'O',
'a',
'Records locks created by LockFile::*',
'JV',
'10'
],
[
'LockFile::Scheme',
'a',
'd',
'p',
'O',
'a',
'Abstract superclass for locking modules',
'JV',
'10'
],
[
'CGI::MxScreen',
'a',
'd',
'p',
'O',
'a',
'Screen multi-plexer framework',
'PURDY',
'15'
],
[
'Spool::Queue',
'i',
'',
'',
'',
'?',
'Generic printer spooling facilities',
'RAM',
'16'
],
[
'Sybase::Simple',
'b',
'd',
'p',
'O',
'p',
'Simplified db access using Sybase::CTlib',
'MEWP',
'7'
],
[
'Statistics::ConwayLife',
'R',
'd',
'p',
'O',
'?',
'Simulates life using Conway\'s algorithm',
'DANB',
'6'
],
[
'Pod::LaTeX',
'b',
'd',
'p',
'O',
'p',
'Converts pod to latex with Pod::Parser',
'TJENNESS',
'26'
],
[
'Tree::Ternary',
'b',
'd',
'p',
'O',
'p',
'Perl implementation of ternary search trees',
'MROGASKI',
'6'
],
[
'Tree::Ternary_XS',
'a',
'd',
'c',
'O',
'p',
'XS implementation of ternary search trees',
'LBROCARD',
'6'
],
[
'Finance::Quote',
'R',
'm',
'p',
'O',
'g',
'Fetch stock prices over the Internet',
'HAMPTON',
'23'
],
[
'Modem::Vgetty',
'b',
'd',
'p',
'O',
'?',
'Interface to voice modems using vgetty',
'YENYA',
'5'
],
[
'PGP',
'a',
'd',
'p',
'O',
'?',
'Simple interface to PGP subprocess via pipes',
'PGPML',
'14'
],
[
'File::Backup',
'b',
'd',
'p',
'f',
'p',
'Easy file backup & rotation automation',
'GENE',
'10'
],
[
'Math::BaseCalc',
'R',
'd',
'p',
'O',
'p',
'Convert numbers between various bases',
'KWILLIAMS',
'6'
],
[
'Tie::LLHash',
'R',
'd',
'p',
'r',
'p',
'Fast ordered hashes via linked lists',
'KWILLIAMS',
'6'
],
[
'Boulder',
'M',
'd',
'p',
'O',
'?',
'Generalized tag/value data objects',
'LDS',
'6'
],
[
'Lingua::EN::MatchNames',
'b',
'd',
'p',
'f',
'?',
'Smart matching for human names',
'BRIANL',
'11'
],
[
'Lingua::EN::Nickname',
'b',
'd',
'p',
'f',
'?',
'Genealogical nickname matching(Peggy=Midge)',
'BRIANL',
'11'
],
[
'DBIx::OracleSequence',
'a',
'd',
'p',
'O',
'p',
'OO access to Oracle sequences via DBD-Oracle',
'BLABES',
'7'
],
[
'GD::Text',
'R',
'd',
'p',
'O',
'p',
'Classes for string handling with GD',
'MVERB',
'18'
],
[
'GD::Graph',
'R',
'd',
'p',
'O',
'p',
'Create charts using GD',
'MVERB',
'18'
],
[
'Schedule::ByClock',
'R',
'd',
'p',
'O',
'p',
'Return to caller at given second/minute',
'SCHAFFTER',
'4'
],
[
'Device::ISDN::OCLM',
'b',
'd',
'?',
'?',
'?',
'Perl interface to the 3com OCLM ISDN TA',
'MERLIN',
'4'
],
[
'GnuPG',
'b',
'd',
'p',
'O',
'?',
'Perl interface to the GNU privacy guard.',
'FRAJULAC',
'14'
],
[
'Fwctl',
'b',
'm',
'p',
'O',
'?',
'Interface to Linux packet filtering firewall',
'FRAJULAC',
'5'
],
[
'IPChains::PortFW',
'b',
'd',
'p',
'O',
'?',
'Interface to ipmasqadm portfw command',
'FRAJULAC',
'5'
],
[
'Text::iPerl',
'a',
'd',
'p',
'f',
'?',
'Bring text-docs to life via embedded Perl',
'PFEIFFER',
'11'
],
[
'Geography::States',
'R',
'd',
'p',
'?',
'?',
'Map states and provinces to their codes',
'ABIGAIL',
'13'
],
[
'Lingua::EN::AddressParse',
'R',
'd',
'p',
'O',
'p',
'Manipulate geographical addresses',
'KIMRYAN',
'11'
],
[
'Lingua::EN::NameParse',
'R',
'd',
'p',
'O',
'p',
'Manipulate persons name',
'KIMRYAN',
'11'
],
[
'Lingua::EN::Fathom',
'R',
'd',
'p',
'O',
'p',
'Measure readability of English text',
'KIMRYAN',
'11'
],
[
'LSF',
'c',
'd',
'c',
'O',
'p',
'Interface to the Load Sharing Facility API',
'DXIAO',
'5'
],
[
'Astro::SunTime',
'c',
'd',
'p',
'f',
'p',
'Calculate sun rise/set times',
'ROBF',
'23'
],
[
'Business::UPC',
'b',
'd',
'p',
'O',
'p',
'manipulating Universal Product Codes',
'ROBF',
'23'
],
[
'Proc::Short',
'a',
'd',
'p',
'O',
'?',
'System calls with timeout option',
'JHKIM',
'4'
],
[
'Games::Hex',
'c',
'd',
'p',
'O',
'?',
'Object library for hexmap-based board games',
'JHKIM',
'23'
],
[
'Spreadsheet::WriteExcel',
'R',
'u',
'p',
'O',
'?',
'Write cross-platform Excel binary file.',
'JMCNAMARA',
'7'
],
[
'Tie::MmapArray',
'b',
'd',
'c',
'r',
'?',
'Ties a file to an array',
'ANDREWF',
'6'
],
[
'Class::Fields',
'b',
'd',
'p',
'h',
'?',
'Inspect the fields of a class',
'MSCHWERN',
'6'
],
[
'Class::Accessor',
'b',
'd',
'p',
'O',
'?',
'Automated accessor generation',
'KASEI',
'6'
],
[
'Class::DBI',
'R',
'm',
'p',
'O',
'p',
'Simple Database Abstraction',
'TMTM',
'6'
],
[
'Win32::Clipboard',
'R',
'd',
'c',
'h',
'p',
'Interaction with the Windows clipboard',
'ACALPINI',
'22'
],
[
'Win32::Console',
'R',
'd',
'c',
'h',
'p',
'Win32 Console and Character mode functions',
'ACALPINI',
'22'
],
[
'Win32::GUI',
'b',
'm',
'c',
'h',
'p',
'Perl-Win32 Graphical User Interface',
'ACALPINI',
'22'
],
[
'Win32::Internet',
'R',
'd',
'c',
'O',
'p',
'Perl Module for Internet Extensions',
'ACALPINI',
'22'
],
[
'Win32::Shortcut',
'R',
'd',
'+',
'O',
'p',
'Manipulate Windows Shortcut files',
'ACALPINI',
'22'
],
[
'Win32::Sound',
'R',
'd',
'c',
'h',
'p',
'An extension to play with Windows sounds',
'ACALPINI',
'22'
],
[
'Schedule::Cron',
'b',
'd',
'p',
'O',
'p',
'cron-like scheduler for perl subroutines',
'ROLAND',
'4'
],
[
'Net::Syslog',
'R',
'd',
'p',
'O',
'p',
'Forwarded syslog protocol',
'LHOWARD',
'5'
],
[
'MP3::ID3v1Tag',
'M',
'd',
'p',
'O',
'p',
'ID3v1 MP3 Tag Reader/Writer',
'SVANZOEST',
'23'
],
[
'MPEG::MP3Play',
'R',
'd',
'h',
'O',
'p',
'Create your own MPEG audio player',
'JRED',
'23'
],
[
'SOAP',
'c',
'm',
'p',
'O',
'?',
'SOAP/Perl language mapping',
'KBROWN',
'5'
],
[
'MPEG::ID3v2Tag',
'b',
'd',
'p',
'O',
'p',
'OO, extensible ID3 v2.3 tagging module',
'CBTILDEN',
'23'
],
[
'DB_File::Lock',
'R',
'd',
'p',
'O',
'?',
'DB_File wrapper with flock-based locking',
'DHARRIS',
'7'
],
[
'Net::Jabber',
'R',
'd',
'p',
'O',
'l',
'Access to the Jabber protocol',
'REATMON',
'5'
],
[
'Argv',
'b',
'd',
'p',
'h',
'?',
'Provide an OO interface to an ARGV',
'DSB',
'12'
],
[
'DWH_File',
'b',
'd',
'p',
'O',
'p',
'DBM storage of complex data and objects',
'SUMUS',
'7'
],
[
'Math::Cephes',
'a',
'd',
'c',
'f',
'p',
'Interface to St. Moshier\'s Cephes library',
'RKOBES',
'6'
],
[
'Math::CDF',
'b',
'd',
'c',
'h',
'?',
'Cumulative Distribution Functions',
'CALLAHAN',
'6'
],
[
'IPC::SharedCache',
'R',
'm',
'p',
'r',
'?',
'Manage a cache in SysV IPC shared memory',
'SAMTREGAR',
'5'
],
[
'Test::Cmd',
'R',
'd',
'p',
'O',
'?',
'Portable test infrastructure for commands',
'KNIGHT',
'3'
],
[
'Tie::DB_FileLock',
'R',
'd',
'p',
'r',
'?',
'Locking access to Berkeley DB 1.x.',
'JMV',
'6'
],
[
'Games::Cards',
'a',
'd',
'p',
'O',
'?',
'Tools to write card games in Perl',
'AKARGER',
'23'
],
[
'HtDig',
'R',
'd',
'p',
'O',
'?',
'Interface for the HtDig indexing system',
'JTILLMAN',
'24'
],
[
'Template',
'R',
'd',
'p',
'O',
'?',
'Extensive Toolkit for template processing',
'ABW',
'11'
],
[
'SSLeay',
'c',
'd',
'c',
'O',
'?',
'Interface to SSLeay',
'EAYNG',
'14'
],
[
'Bio',
'i',
'',
'',
'',
'?',
'Utilities for molecular biology',
'SEB',
'23'
],
[
'Schedule::Load',
'R',
'd',
'p',
'O',
'p',
'Remote system load, processes, scheduling',
'WSNYDER',
'4'
],
[
'Astro::MoonPhase',
'R',
'd',
'p',
'f',
'p',
'Information about the phase of the Moon.',
'BRETT',
'23'
],
[
'Tie::Discovery',
'R',
'd',
'p',
'r',
'?',
'Discover data by caching sub results',
'SIMON',
'6'
],
[
'Solaris::ACL',
'R',
'd',
'c',
'h',
'p',
'Provides access to ACLs in Solaris',
'IROBERTS',
'4'
],
[
'RAS::PortMaster',
'R',
'd',
'p',
'O',
'?',
'Interface to Livingston PortMaster',
'STIGMATA',
'5'
],
[
'RAS::AS5200',
'R',
'd',
'p',
'O',
'?',
'Interface to Cisco AS5200 dialup server',
'STIGMATA',
'5'
],
[
'RAS::HiPerARC',
'R',
'd',
'p',
'O',
'?',
'Interface to 3Com TotalControl HiPerARC',
'STIGMATA',
'5'
],
[
'Crypt::Blowfish_PP',
'b',
'd',
'p',
'O',
'p',
'Blowfish encryption algorithm in Pure Perl',
'MATTBM',
'14'
],
[
'Archive::Zip',
'R',
'd',
'p',
'O',
'p',
'Provides an interface to ZIP archive files',
'SMPETERS',
'17'
],
[
'Crypt::Blowfish',
'M',
'd',
'h',
'h',
'd',
'XS-based implementation of Blowfish',
'DPARIS',
'14'
],
[
'Socket::PassAccessRights',
'a',
'd',
'c',
'f',
'p',
'Pass file descriptor via Unix domain socket',
'SAMPO',
'5'
],
[
'SMIMEUtil',
'R',
'm',
'h',
'f',
'o',
'Sign, encrypt, verify, decrypt S/MIME mail',
'SAMPO',
'14'
],
[
'IPC::Cache',
'a',
'd',
'p',
'O',
'?',
'Shared-memory object cache',
'DCLINTON',
'5'
],
[
'URI::Find',
'a',
'd',
'p',
'O',
'p',
'Find URIs in plain text',
'ROSCH',
'15'
],
[
'String::DiffLine',
'b',
'd',
'c',
'f',
'?',
'line # & position of first diff',
'ALLEN',
'11'
],
[
'IPC::LDT',
'R',
'd',
'p',
'O',
'a',
'Implements a length based IPC protocol',
'JSTENZEL',
'5'
],
[
'BTRIEVE::SAVE',
'b',
'd',
'p',
'O',
'?',
'Read-write access to BTRIEVE SAVE files',
'DLANE',
'7'
],
[
'HTML::TableExtract',
'R',
'm',
'p',
'O',
'?',
'Flexible HTML table extraction',
'MSISK',
'15'
],
[
'Finance::QuoteHist',
'R',
'd',
'p',
'O',
'p',
'Historical stock quotes from multiple sites',
'MSISK',
'23'
],
[
'Test::Unit',
'b',
'm',
'p',
'O',
'p',
'framework for XP style unit testing',
'MCAST',
'3'
],
[
'Persistent::Base',
'b',
'd',
'p',
'O',
'?',
'Persistent base classes (& DBM/File classes)',
'DWINTERS',
'6'
],
[
'Persistent::DBI',
'b',
'd',
'p',
'O',
'?',
'Persistent abstract class for DBI databases',
'DWINTERS',
'6'
],
[
'Persistent::MySQL',
'b',
'd',
'p',
'O',
'?',
'Persistent class for MySQL databases',
'DWINTERS',
'6'
],
[
'Persistent::Oracle',
'b',
'd',
'p',
'O',
'?',
'Persistent class for Oracle databases',
'DWINTERS',
'6'
],
[
'Persistent::Sybase',
'b',
'd',
'p',
'O',
'?',
'Persistent class for Sybase databases',
'DWINTERS',
'6'
],
[
'Persistent::mSQL',
'b',
'd',
'p',
'O',
'?',
'Persistent class for mSQL databases',
'DWINTERS',
'6'
],
[
'Persistent::LDAP',
'b',
'd',
'p',
'O',
'?',
'Persistent class for LDAP directories',
'DWINTERS',
'6'
],
[
'PPresenter',
'M',
'd',
'p',
'O',
'p',
'Create presentations with Tk in Perl or XML',
'MARKOV',
'8'
],
[
'HTML::Demoroniser',
'a',
'd',
'p',
'O',
'?',
'Correct moronic and incompatible HTML',
'JDPORTER',
'15'
],
[
'Filesys::SamFS',
'b',
'd',
'c',
'f',
'a',
'Interface to SamFS API',
'LUPE',
'10'
],
[
'WAIT',
'a',
'd',
'h',
'O',
'?',
'A rewrite of the freeWAIS-sf engine in Perl',
'ULPFR',
'7'
],
[
'Email::Find',
'a',
'd',
'p',
'f',
'p',
'Find RFC 822 email addresses in plain text',
'MIYAGAWA',
'11'
],
[
'Business::OnlinePayment',
'R',
'd',
'p',
'O',
'p',
'Ecommerce middleware',
'JASONK',
'23'
],
[
'Class::Mutator',
'b',
'd',
'p',
'O',
'?',
'Dynamic polymorphism implemented in Perl',
'GMCCAR',
'6'
],
[
'File::Cache',
'a',
'd',
'p',
'O',
'?',
'Share data between processes via filesystem',
'DCLINTON',
'10'
],
[
'Hash::NoVivify',
'R',
'd',
'c',
'f',
'?',
'Provide non-autovivifying hash functions',
'BPOWERS',
'6'
],
[
'Lingua::Ident',
'R',
'd',
'p',
'O',
'p',
'Statistical language identification',
'MPIOTR',
'11'
],
[
'Text::Iconv',
'R',
'd',
'c',
'O',
'p',
'Interface to iconv codeset conversion',
'MPIOTR',
'11'
],
[
'User::Utmp',
'R',
'd',
'c',
'f',
'p',
'Perl access to UNIX utmp(x)-style databases',
'MPIOTR',
'14'
],
[
'File::Remote',
'R',
'd',
'p',
'h',
'?',
'Read/write/edit remote files transparently',
'NWIGER',
'10'
],
[
'IPC::XPA',
'a',
'd',
'c',
'h',
'?',
'Interface to SAO XPA messaging system',
'DJERIUS',
'5'
],
[
'Image::DS9',
'a',
'd',
'p',
'O',
'?',
'Interface to SAO DS9 image & analysis prog',
'DJERIUS',
'18'
],
[
'Text::Merge',
'b',
'd',
'p',
'?',
'p',
'Methods for text templating and data merging',
'SHARRIS',
'11'
],
[
'Array::Compare',
'R',
'd',
'p',
'O',
'p',
'Class to compare two arrays',
'DAVECROSS',
'6'
],
[
'MSSQL::DBlib',
'M',
'd',
'+',
'O',
'?',
'Access MS SQL Server through DB-Library.',
'SOMMAR',
'7'
],
[
'MSSQL::Sqllib',
'M',
'd',
'p',
'O',
'?',
'High-level interface using MSSQL::DBlib.',
'SOMMAR',
'7'
],
[
'DBD::Unify',
'b',
'd',
'c',
'O',
'p',
'Unify driver for DBI',
'HMBRAND',
'7'
],
[
'IPC::Shareable',
'b',
'd',
'p',
'r',
'?',
'Tie a variable to shared memory',
'BSUGARS',
'5'
],
[
'Language::Basic',
'a',
'd',
'p',
'O',
'?',
'Implementation of BASIC',
'AKARGER',
'9'
],
[
'Class::MethodMaker',
'M',
'd',
'p',
'O',
'p',
'Create generic class methods',
'FLUFFY',
'6'
],
[
'Thread',
'c',
'u',
'h',
'O',
'?',
'Manipulate threads in Perl (EXPERIMENTAL)',
'P5P',
'2'
],
[
'Thread::Group',
'b',
'd',
'p',
'h',
'?',
'Wait()-like and grouping functions',
'DSUGAL',
'2'
],
[
'Thread::IO',
'i',
'',
'',
'',
'?',
'IO routines',
'DSUGAL',
'2'
],
[
'Thread::Object',
'i',
'',
'',
'',
'?',
'OO routines',
'DSUGAL',
'2'
],
[
'Thread::Pool',
'b',
'd',
'p',
'O',
'p',
'Worker pools to run Perl code asynchronously',
'ELIZABETH',
'2'
],
[
'Thread::Queue',
'c',
'u',
'p',
'h',
'?',
'Thread-safe queues',
'P5P',
'2'
],
[
'Thread::Semaphore',
'c',
'u',
'p',
'h',
'?',
'Thread-safe semaphores',
'P5P',
'2'
],
[
'Thread::Signal',
'c',
'u',
'h',
'h',
'?',
'A thread which runs signal handlers reliably',
'P5P',
'2'
],
[
'Thread::Specific',
'c',
'u',
'h',
'h',
'?',
'Thread-specific keys',
'P5P',
'2'
],
[
'RPC::PlServer',
'R',
'd',
'p',
'O',
'?',
'Interface for building Perl Servers',
'THOWELL',
'5'
],
[
'RPC::PlClient',
'R',
'd',
'p',
'O',
'?',
'Interface for building pServer Clients',
'THOWELL',
'5'
],
[
'NetServer::Compiler',
'i',
'd',
'p',
'h',
'?',
'State machine compiler for TCP/IP servers',
'CHSTROSS',
'16'
],
[
'Net::Printer',
'R',
'd',
'p',
'O',
'?',
'Direct to lpd printing',
'CFUHRMAN',
'5'
],
[
'DBIx::glueHTML',
'b',
'd',
'p',
'O',
'?',
'CGI interface to DBI databases',
'JFURNESS',
'7'
],
[
'WAP::Wbmp',
'i',
'?',
'?',
'?',
'?',
'Wireless bitmap manipulation module',
'SAA',
'15'
],
[
'WAP::WML',
'i',
'?',
'?',
'?',
'?',
'Wireless Markup language routines',
'SAA',
'15'
],
[
'Math::Logic',
'R',
'd',
'p',
'O',
'?',
'Provides pure 2, 3 or multi-value logic',
'SUMMER',
'6'
],
[
'DBIx::Abstract',
'R',
'm',
'p',
'O',
'?',
'Wrapper for DBI that generates SQL',
'TURNERA',
'7'
],
[
'MP3::Info',
'R',
'd',
'p',
'h',
'a',
'Manipulate / fetch info from MP3 audio files',
'DANIEL',
'23'
],
[
'Array::IntSpan',
'R',
'd',
'p',
'O',
'?',
'Handling arrays using IntSpan techniques',
'DDUMONT',
'6'
],
[
'Spectrum::CLI',
'R',
'd',
'p',
'O',
'?',
'API for Spectrum Enterprise Mgr. CLI',
'PLONKA',
'7'
],
[
'Thesaurus',
'R',
'd',
'p',
'O',
'p',
'Create associations between related things',
'DROLSKY',
'6'
],
[
'Log::Dispatch',
'R',
'd',
'p',
'O',
'p',
'Log messages to multiple outputs',
'DROLSKY',
'21'
],
[
'LEGO::RCX',
'b',
'd',
'p',
'O',
'p',
'Control you Lego Mindstorm RCX computer',
'JQUILLAN',
'23'
],
[
'IPC::Run',
'R',
'd',
'p',
'h',
'o',
'Child procs w/ piping, redir and psuedo-ttys',
'RSOD',
'5'
],
[
'ASP',
'R',
'd',
'p',
'r',
'?',
'Interface for ASP PerlScript and Apache::ASP',
'TIMMY',
'15'
],
[
'DBD::Sqlflex',
'R',
'd',
'c',
'O',
'?',
'SQLFLEX driver for DBI',
'INFOFLEX',
'7'
],
[
'DBIx::AnyDBD',
'b',
'd',
'p',
'O',
'?',
'Module to make cross db applications easier',
'MSERGEANT',
'7'
],
[
'Time::Object',
'a',
'd',
'p',
'O',
'?',
'Object Oriented time objects',
'MSERGEANT',
'6'
],
[
'Win32::ADO',
'a',
'd',
'p',
'f',
'?',
'ADO Constants and helper functions',
'MSERGEANT',
'22'
],
[
'Text::Banner',
'a',
'd',
'p',
'f',
'?',
'Resembles UNIX banner command',
'LORY',
'11'
],
[
'DBIx::CGITables',
'a',
'd',
'p',
'O',
'?',
'Easy DB access from a CGI',
'TOBIX',
'7'
],
[
'DBIx::Copy',
'a',
'd',
'p',
'O',
'?',
'Copying databases',
'TOBIX',
'7'
],
[
'Convert::ASN1',
'a',
'd',
'p',
'O',
'?',
'Standard en/decode of ASN.1 structures',
'GBARR',
'17'
],
[
'HTTP::Browscap',
'c',
'd',
'p',
'O',
'?',
'Provides info on web browser capabilities',
'JAMESPO',
'15'
],
[
'RPM',
'a',
'd',
'c',
'O',
'?',
'RPM package management',
'RJRAY',
'17'
],
[
'RPM::Constants',
'a',
'd',
'c',
'O',
'?',
'Constants for RPM package management',
'RJRAY',
'17'
],
[
'RPM::Database',
'a',
'd',
'c',
'O',
'?',
'DB interface for RPM package management',
'RJRAY',
'17'
],
[
'RPM::Headers',
'a',
'd',
'c',
'O',
'?',
'Headers for RPM package management',
'RJRAY',
'17'
],
[
'Java',
'R',
'd',
'h',
'O',
'l',
'A Perl front-end for JVM communication',
'METZZO',
'9'
],
[
'Crypt::CBCeasy',
'b',
'd',
'p',
'f',
'?',
'Easy things make really easy with Crypt::CBC',
'MBLAZ',
'14'
],
[
'Win32::RASE',
'R',
'd',
'p',
'f',
'?',
'Dialup entries and connections on Win32',
'MBLAZ',
'22'
],
[
'SQL::Schema',
'b',
'd',
'p',
'O',
'?',
'Convert a data dictionary to SQL statements',
'TODD',
'11'
],
[
'DBD::RAM',
'b',
'm',
'p',
'O',
'?',
'a DBI driver for files and data structures',
'JZUCKER',
'7'
],
[
'Socket6',
'a',
'd',
'c',
'f',
'?',
'getaddrinfo/getnameinfo support module',
'UMEMOTO',
'5'
],
[
'HTTP::BrowserDetect',
'a',
'd',
'p',
'h',
'?',
'Detect browser, version, OS from UserAgent',
'LHS',
'15'
],
[
'HTML::WebMake',
'R',
'm',
'p',
'O',
'?',
'simple web site management system',
'JMASON',
'15'
],
[
'File::Temp',
'R',
'd',
'p',
'f',
'p',
'Create temporary files safely',
'TJENNESS',
'10'
],
[
'CGI::ArgChecker',
'b',
'd',
'p',
'O',
'?',
'Consistent, extensible CGI param validation',
'DLOWE',
'15'
],
[
'URI::Bookmark',
'b',
'd',
'p',
'O',
'?',
'A Class for bookmarks',
'ASPIERS',
'15'
],
[
'String::Strip',
'R',
'd',
'c',
'f',
'?',
'xs Module to remove white-space from strings',
'BPOWERS',
'11'
],
[
'Memoize::ExpireLRU',
'R',
'd',
'p',
'r',
'?',
'Provide LRU Expiration for Memoize',
'BPOWERS',
'20'
],
[
'Pod::Pdf',
'b',
'd',
'p',
'f',
'?',
'Converter to PDF',
'AJFRY',
'26'
],
[
'Barcode::Code128',
'R',
'd',
'p',
'O',
'n',
'Generate CODE 128 bar codes',
'WRW',
'18'
],
[
'Mac::Serial',
'b',
'd',
'p',
'O',
'?',
'Interface to Macintosh serial ports',
'DIVERDI',
'4'
],
[
'WWW::BBSWatch',
'R',
'd',
'p',
'O',
'?',
'email WWW bulletin board postings',
'TAYERS',
'15'
],
[
'Router::LG',
'b',
'd',
'p',
'O',
'?',
'Execute commands on routers (based on lg.pl)',
'CHRISJ',
'23'
],
[
'Mail::Field::Received',
'R',
'd',
'p',
'O',
'?',
'Parses Received headers as per RFC822',
'ASPIERS',
'19'
],
[
'CGI::QuickForm',
'R',
'd',
'p',
'f',
'?',
'Handles UI & validation for CGI forms',
'SUMMER',
'15'
],
[
'Lingua::EN::NameCase',
'R',
'd',
'p',
'f',
'?',
'Convert NAMES and names to Correct Case',
'SUMMER',
'11'
],
[
'Clone',
'i',
'd',
'c',
'h',
'?',
'Recursive copy of nested objects',
'RDF',
'6'
],
[
'Solaris::Procfs',
'a',
'd',
'h',
'h',
'p',
'Access to the Solaris /proc filesystem',
'JNOLAN',
'4'
],
[
'VMS::Device',
'R',
'd',
'c',
'r',
'?',
'Access info about any device on a VMS system',
'DSUGAL',
'4'
],
[
'VMS::ICC',
'b',
'd',
'c',
'r',
'?',
'Interface to the ICC facilities in VMS 7.2+',
'DSUGAL',
'4'
],
[
'VMS::Misc',
'R',
'd',
'c',
'r',
'?',
'Miscellaneous VMS utility routines',
'DSUGAL',
'4'
],
[
'VMS::Monitor',
'R',
'd',
'c',
'r',
'?',
'Access VMS system performance info',
'DSUGAL',
'4'
],
[
'VMS::User',
'b',
'd',
'c',
'r',
'?',
'Read access to system UAF data',
'DSUGAL',
'4'
],
[
'GnuPG::Interface',
'M',
'd',
'p',
'O',
'?',
'OO interface to GNU Privacy Guard',
'FTOBIN',
'14'
],
[
'Net::Daemon::SSL',
'R',
'd',
'p',
'O',
'?',
'SSL extension for Net::Daemon',
'MKUL',
'5'
],
[
'Net::Daemon',
'a',
'd',
'p',
'O',
'?',
'Abstract base class for portable servers',
'THOWELL',
'5'
],
[
'PPM',
'R',
'd',
'p',
'f',
'?',
'Perl Package Manager',
'MURRAY',
'17'
],
[
'Net::VNC',
'i',
'?',
'?',
'?',
'?',
'Interface VNC remote frame buffer protocol',
'LBROCARD',
'5'
],
[
'HTTP::DAV',
'a',
'm',
'p',
'O',
'?',
'A client module for the WebDAV protocol',
'PCOLLINS',
'15'
],
[
'Net::Telnet::Cisco',
'R',
'm',
'p',
'O',
'p',
'Automate telnet sessions w/ routers&switches',
'JOSHUA',
'5'
],
[
'Dialog',
'b',
'd',
'c',
'h',
'?',
'interface library to libdialog',
'UNCLE',
'8'
],
[
'FestVox',
'i',
'?',
'?',
'?',
'?',
'Build synthetic voices (cf. www.festvox.org)',
'LENZO',
'23'
],
[
'HTML::StickyForms',
'a',
'd',
'p',
'O',
'?',
'HTML form generation for mod_perl/CGI',
'PMH',
'15'
],
[
'Tie::Persistent',
'R',
'd',
'p',
'r',
'p',
'Persistent data structures via tie made easy',
'RGIERSIG',
'6'
],
[
'ElectricArc',
'R',
'd',
'p',
'O',
'?',
'Generic diagram manipulation toolset',
'SELKOVJR',
'18'
],
[
'DBIx::FullTextSearch',
'b',
'm',
'p',
'O',
'p',
'Index documents with MySQL as storage',
'TJMATHER',
'7'
],
[
'CGI::WML',
'R',
'd',
'p',
'O',
'?',
'Subclass of CGI.pm for WML output',
'AWOOD',
'15'
],
[
'HTML::FillInForm',
'R',
'd',
'p',
'O',
'?',
'Fill in HTML forms, separating HTML and code',
'TJMATHER',
'15'
],
[
'Locale::SubCountry',
'R',
'd',
'p',
'O',
'p',
'ISO 3166-2 two letter subcountry codes',
'KIMRYAN',
'13'
],
[
'Env::Path',
'a',
'd',
'p',
'O',
'?',
'Advanced operations on path variables',
'DSB',
'4'
],
[
'Text::Templar',
'b',
'd',
'p',
'O',
'a',
'An object-oriented text templating system',
'GED',
'11'
],
[
'DBIx::TableAdapter',
'a',
'd',
'p',
'O',
'a',
'A object-relational table adapter class',
'GED',
'7'
],
[
'Class::Translucent',
'R',
'd',
'p',
'O',
'?',
'Translucent (ala perltootc) method creation',
'GED',
'6'
],
[
'NetAddr::IP',
'R',
'd',
'p',
'O',
'p',
'Manipulation and operations on IP addresses',
'LUISMUNOZ',
'5'
],
[
'Devel::StackTrace',
'R',
'd',
'p',
'O',
'p',
'Stacktrace object w/ info form caller()',
'DROLSKY',
'3'
],
[
'Exception::Class',
'R',
'd',
'p',
'O',
'p',
'Declare exception class hierarchies',
'DROLSKY',
'20'
],
[
'X500::DN',
'a',
'd',
'p',
'O',
'p',
'Handle X.500 DNs (Distinguished Names)',
'RJOOP',
'6'
],
[
'DBIx::Password',
'M',
'd',
'p',
'O',
'?',
'Abstration layer for database passwords',
'KROW',
'7'
],
[
'Unicode::Normal',
'i',
'?',
'?',
'?',
'?',
'Composition, canonical ordering, blocks',
'MHOSKEN',
'13'
],
[
'Net::MsgLink',
'c',
'd',
'p',
'O',
'?',
'Abstraction of "user" part for message link',
'RAM',
'5'
],
[
'CGI::Application',
'M',
'm',
'p',
'O',
'p',
'Framework for building reusable web-apps',
'JERLBAUM',
'15'
],
[
'WML::Card',
'R',
'd',
'p',
'O',
'?',
'Builds WML code for different wap browsers',
'MALVARO',
'15'
],
[
'WML::Deck',
'R',
'd',
'p',
'O',
'?',
'WML Deck generator',
'MALVARO',
'15'
],
[
'DBD::SQLrelay',
'b',
'd',
'p',
'O',
'?',
'SQLrelay driver for DBI',
'DMOW',
'7'
],
[
'Date::Roman',
'R',
'd',
'p',
'O',
'a',
'Manipulating Roman-style dates',
'HOBBIT',
'6'
],
[
'Crypt::Solitaire',
'R',
'd',
'p',
'O',
'p',
'A very simple encryption system',
'SIFUKURT',
'14'
],
[
'Crypt::RC4',
'R',
'd',
'p',
'O',
'p',
'Implements the RC4 encryption algorithm',
'SIFUKURT',
'14'
],
[
'Crypt::OTP',
'R',
'd',
'p',
'f',
'?',
'Implements One Time Pad encryption',
'SIFUKURT',
'14'
],
[
'Net::AIM',
'a',
'd',
'p',
'O',
'?',
'AOL Instant Messenger TOC protocol',
'ARYEH',
'5'
],
[
'Net::AOLIM',
'R',
'd',
'p',
'O',
'?',
'AOL Instant Messenger OO Interface (TOC)',
'RWAHBY',
'5'
],
[
'SGI::FAM',
'R',
'd',
'c',
'O',
'?',
'Interface to SGI/Irix File Access Monitor',
'JGLICK',
'4'
],
[
'Tie::SortHash',
'R',
'd',
'p',
'r',
'?',
'Provides persistent sorting for hashes',
'CTWETEN',
'6'
],
[
'SGML::Parser',
'a',
'd',
'p',
'O',
'p',
'SGML instance parser',
'EHOOD',
'11'
],
[
'SGML::Entity',
'R',
'd',
'p',
'O',
'?',
'An entity defined in an SGML or XML document',
'KMACLEOD',
'11'
],
[
'Sendmail::Milter',
'R',
'd',
'c',
'h',
'?',
'Write mail filters for sendmail in Perl',
'CYING',
'19'
],
[
'Search::Binary',
'R',
'd',
'p',
'f',
'?',
'Generic binary search',
'RANT',
'11'
],
[
'SNMP::Util',
'R',
'd',
'p',
'O',
'?',
'Perform SNMP set,get,walk,next,walk_hash,...',
'WMARQ',
'5'
],
[
'Set::Bag',
'R',
'd',
'p',
'O',
'?',
'Bag (multiset) class',
'JHI',
'6'
],
[
'Set::NestedGroups',
'R',
'd',
'p',
'O',
'?',
'Grouped data eg ACL\'s, city/state/country',
'ABARCLAY',
'6'
],
[
'Orac',
'R',
'd',
'p',
'O',
'?',
'DBA GUI tool for Oracle, Informix and Sybase',
'ANDYDUNC',
'8'
],
[
'Spreadsheet::ParseExcel',
'R',
'd',
'p',
'O',
'p',
'Get information from Excel file',
'SZABGAB',
'7'
],
[
'Statistics::Distributions',
'R',
'd',
'p',
'O',
'p',
'Perl module for calculating critical values',
'MIKEK',
'6'
],
[
'String::Random',
'R',
'd',
'p',
'O',
'?',
'Perl module to generate random strings based',
'STEVE',
'11'
],
[
'Tie::RDBM',
'R',
'd',
'p',
'O',
'?',
'Tie hashes to relational databases',
'LDS',
'6'
],
[
'Log::TraceMessages',
'R',
'd',
'p',
'O',
'?',
'Print developer\'s trace messages',
'EDAVIS',
'21'
],
[
'Parse::Tokens',
'b',
'd',
'p',
'O',
'p',
'Base class for parsing tokens from text',
'MCKAY',
'11'
],
[
'Crypt::RandPasswd',
'R',
'd',
'p',
'O',
'?',
'Random password generator based on FIPS-181',
'JDPORTER',
'14'
],
[
'Mail::CheckUser',
'R',
'd',
'p',
'f',
'p',
'Check email addresses for validity',
'ILYAM',
'19'
],
[
'Mail::Procmail',
'R',
'd',
'p',
'f',
'?',
'Procmail-like facility for creating easy mai',
'JV',
'19'
],
[
'Getargs::Long',
'a',
'd',
'p',
'f',
'a',
'Parses long function args f(-arg => value)',
'DCOPPIT',
'12'
],
[
'Parallel::ForkManager',
'R',
'd',
'p',
'O',
'p',
'A simple parallel processing fork manager',
'DLUX',
'5'
],
[
'dTemplate',
'R',
'm',
'h',
'O',
'p',
'Fast and flexible templating system',
'DLUX',
'11'
],
[
'Mac::Macbinary',
'b',
'd',
'p',
'O',
'?',
'Decodes MacBinary files.',
'MIYAGAWA',
'4'
],
[
'Math::Round',
'b',
'd',
'p',
'f',
'p',
'Perl extension for rounding numbers',
'GROMMEL',
'6'
],
[
'Filesys::Ext2',
'R',
'd',
'p',
'f',
'p',
'Interface to e2fs filesystem attributes',
'JPIERCE',
'10'
],
[
'WWW::Search::AlltheWeb',
'R',
'd',
'p',
'O',
'?',
'Class for searching AlltheWeb',
'JSMYSER',
'15'
],
[
'WWW::Search::Go',
'R',
'd',
'p',
'O',
'?',
'Backend class for searching with go.com',
'ALIAN',
'15'
],
[
'GD::Barcode',
'b',
'd',
'p',
'O',
'p',
'Create barcode image with GD',
'KWITKNR',
'18'
],
[
'Net::Patricia',
'R',
'd',
'c',
'O',
'?',
'Patricia Trie perl module for fast IP addres',
'PLONKA',
'5'
],
[
'Term::ProgressBar',
'R',
'd',
'p',
'O',
'p',
'Progress bar in just ASCII / using Term',
'FLUFFY',
'8'
],
[
'Log::Agent::Logger',
'a',
'd',
'p',
'O',
'a',
'Application-level logging interface',
'MROGASKI',
'21'
],
[
'Win32::SystemInfo',
'R',
'd',
'p',
'O',
'p',
'Memory and Processor information',
'CJOHNSTON',
'22'
],
[
'AI::NeuralNet',
'R',
'd',
'p',
'O',
'?',
'A simple back-prop neural net',
'JBRYAN',
'23'
],
[
'AI::Fuzzy',
'R',
'd',
'p',
'O',
'?',
'Perl extension for Fuzzy Logic',
'SABREN',
'23'
],
[
'Flash::SWF',
'c',
'm',
'p',
'O',
'?',
'Read/Write Macromedia Flash SWF files',
'SABREN',
'18'
],
[
'MIME::Lite::HTML',
'b',
'm',
'p',
'O',
'?',
'Provide routine to transform HTML to MIME',
'ALIAN',
'15'
],
[
'MP3::Tag',
'b',
'd',
'p',
'O',
'?',
'Tag - Module for reading tags of mp3 files',
'THOGEE',
'23'
],
[
'Tree::Nary',
'R',
'd',
'p',
'O',
'p',
'Perl implementation of N-ary search trees',
'FSORIANO',
'6'
],
[
'Db::DFC',
'a',
'd',
'p',
'O',
'a',
'OO Interface to Documentum\'s DFC using JPL',
'MSROTH',
'24'
],
[
'Crypt::Rijndael',
'b',
'd',
'c',
'h',
'?',
'AES/Rijndael Encryption Module',
'BDFOY',
'14'
],
[
'Data::Random',
'R',
'd',
'p',
'f',
'p',
'Generate random sets of data',
'ADEO',
'6'
],
[
'Sub::Curry',
'R',
'd',
'p',
'h',
'p',
'Create curried subroutines',
'LODIN',
'3'
],
[
'Mail::IMAPClient',
'R',
'd',
'p',
'O',
'p',
'An IMAP Client API',
'DJKERNEN',
'19'
],
[
'ex::implements',
'R',
'd',
'p',
'O',
'?',
'Study in Polymorphism',
'PDCAWLEY',
'2'
],
[
'ex::interface',
'R',
'd',
'p',
'O',
'?',
'Another study in polymorphism',
'PDCAWLEY',
'2'
],
[
'Apache::AddrMunge',
'b',
'd',
'p',
'f',
'?',
'Munge email addresses in webpages',
'MJD',
'15'
],
[
'Apache::AutoIndex',
'R',
'd',
'p',
'f',
'p',
'Lists directory content',
'GOZER',
'15'
],
[
'Apache::Archive',
'b',
'd',
'p',
'f',
'?',
'Make linked contents pages of .tar(.gz)',
'JPETERSON',
'15'
],
[
'Apache::ASP',
'M',
'd',
'p',
'O',
'g',
'Active Server Pages for Apache and mod_perl',
'CHAMAS',
'15'
],
[
'Apache::BBS',
'c',
'd',
'p',
'O',
'?',
'BBS like System for Apache',
'MKOSSATZ',
'15'
],
[
'Apache::CallHandler',
'c',
'd',
'p',
'f',
'?',
'Map filenames to subroutine calls',
'GKNOPS',
'15'
],
[
'Apache::Compress',
'b',
'd',
'p',
'O',
'p',
'Compress content on the fly',
'KWILLIAMS',
'15'
],
[
'Apache::Dir',
'i',
'',
'',
'',
'?',
'OO (subclassable) mod_dir replacement',
'DWHEELER',
'15'
],
[
'Apache::Dispatch',
'b',
'm',
'p',
'f',
'?',
'Call PerlHandlers as CGI scripts',
'GEOFF',
'15'
],
[
'Apache::Embperl',
'R',
'm',
'c',
'f',
'p',
'Build dynamic Websites (e.g. embed Perl)',
'GRICHTER',
'15'
],
[
'Apache::ePerl',
'R',
'd',
'p',
'r',
'?',
'Fast emulated Embedded Perl (ePerl)',
'RSE',
'15'
],
[
'Apache::Filter',
'R',
'd',
'p',
'O',
'p',
'Lets handlers filter each others\' output',
'KWILLIAMS',
'15'
],
[
'Apache::Forward',
'b',
'd',
'p',
'O',
'?',
'OutputChain like functionality',
'MPB',
'15'
],
[
'Apache::FTP',
'i',
'',
'',
'',
'?',
'Full-fledged FTP proxy',
'PMKANE',
'15'
],
[
'Apache::Gateway',
'R',
'd',
'p',
'f',
'p',
'A multiplexing gateway',
'CCWF',
'15'
],
[
'Apache::GzipChain',
'b',
'm',
'p',
'f',
'?',
'Compress files on the fly',
'ANDK',
'15'
],
[
'Apache::iNcom',
'b',
'd',
'p',
'f',
'?',
'An e-commerce framework',
'FRAJULAC',
'15'
],
[
'Apache::Layer',
'b',
'd',
'p',
'f',
'?',
'Layer content tree over one or more',
'SAM',
'15'
],
[
'Apache::Magick',
'b',
'd',
'p',
'f',
'?',
'Image conversion on-the-fly',
'MPB',
'15'
],
[
'Apache::Mason',
'b',
'd',
'p',
'O',
'?',
'Build sites w/ modular Perl/HTML blocks',
'JSWARTZ',
'15'
],
[
'Apache::ModuleDoc',
'b',
'd',
'p',
'f',
'?',
'Self documentation for Apache C modules',
'DOUGM',
'15'
],
[
'Apache::NavBar',
'b',
'd',
'p',
'O',
'?',
'Navigation bar generator',
'MPB',
'15'
],
[
'Apache::NNTPGateway',
'R',
'd',
'p',
'n',
'p',
'A Web based NNTP (usenet) interface',
'BOUBAKER',
'15'
],
[
'Apache::OutputChain',
'b',
'm',
'p',
'O',
'?',
'Chain output of stacked handlers',
'JANPAZ',
'15'
],
[
'Apache::OWA',
'b',
'd',
'p',
'f',
'?',
'Runs Oracle PL/SQL Web Toolkit apps',
'SVINTO',
'15'
],
[
'Apache::PageKit',
'M',
'm',
'p',
'O',
'o',
'MVC Web App framework, based on mod_perl/XML',
'TJMATHER',
'15'
],
[
'Apache::PassFile',
'b',
'd',
'p',
'f',
'?',
'Send file via OutputChain',
'ANDK',
'15'
],
[
'Apache::PerlRun',
'S',
'm',
'p',
'f',
'?',
'Run unaltered CGI scripts',
'APML',
'15'
],
[
'Apache::PrettyPerl',
'R',
'd',
'p',
'f',
'?',
'Syntax highlighting for Perl files',
'RA',
'15'
],
[
'Apache::PrettyText',
'b',
'd',
'p',
'f',
'?',
'Re-format .txt files for client display',
'CHTHORMAN',
'15'
],
[
'Apache::RandomLocation',
'c',
'd',
'p',
'f',
'p',
'Random image display',
'RKOBES',
'15'
],
[
'Apache::Registry',
'S',
'm',
'p',
'f',
'?',
'Run unaltered CGI scripts',
'APML',
'15'
],
[
'Apache::RobotRules',
'c',
'd',
'p',
'f',
'?',
'Enforce robot rules (robots.txt)',
'PARKER',
'15'
],
[
'Apache::Sandwich',
'M',
'm',
'p',
'f',
'p',
'Layered document (sandwich) maker',
'VKHERA',
'15'
],
[
'Apache::ShowRequest',
'b',
'd',
'p',
'f',
'?',
'Show phases and module participation',
'DOUGM',
'15'
],
[
'Apache::SimpleReplace',
'a',
'm',
'p',
'f',
'?',
'Simple replacement template tool',
'GEOFF',
'15'
],
[
'Apache::SSI',
'R',
'm',
'p',
'O',
'p',
'Implement server-side includes in Perl',
'KWILLIAMS',
'15'
],
[
'Apache::SSIChain',
'b',
'm',
'p',
'O',
'?',
'SSI on other modules output',
'JANPAZ',
'15'
],
[
'Apache::Stage',
'R',
'd',
'p',
'f',
'?',
'Manage a document staging directory',
'ANDK',
'15'
],
[
'Apache::TarGzip',
'c',
'',
'',
'',
'?',
'Manage .tar.gz file',
'ZENIN',
'15'
],
[
'Apache::TimedRedirect',
'b',
'd',
'p',
'f',
'?',
'Redirect urls for a given time period',
'PETERM',
'15'
],
[
'Apache::UploadSvr',
'b',
'd',
'p',
'O',
'?',
'A lightweight publishing system',
'ANDK',
'15'
],
[
'Apache::VhostSandwich',
'c',
'd',
'p',
'f',
'?',
'Virtual host layered document maker',
'MARKC',
'15'
],
[
'Apache::WDB',
'b',
'd',
'p',
'f',
'?',
'Database query/edit tool using DBI',
'JROWE',
'15'
],
[
'Apache::WebSQL',
'c',
'd',
'p',
'O',
'?',
'Adaptation of Sybase\'s WebSQL',
'GUNTHER',
'15'
],
[
'Apache::RequestNotes',
'a',
'm',
'p',
'f',
'?',
'Pass cookie & form data around pnotes',
'GEOFF',
'15'
],
[
'Config::FreeForm',
'b',
'd',
'p',
'f',
'p',
'Provide in-memory configuration data',
'BTROTT',
'12'
],
[
'Apache::AuthAny',
'b',
'd',
'p',
'f',
'?',
'Authenticate with any username/password',
'MPB',
'15'
],
[
'Apache::AuthenCache',
'R',
'd',
'p',
'n',
'g',
'Cache authentication credentials',
'JBODNAR',
'15'
],
[
'Apache::AuthCookie',
'R',
'd',
'p',
'O',
'?',
'Authen + Authz via cookies',
'MSCHOUT',
'15'
],
[
'Apache::AuthenDBI',
'b',
'm',
'p',
'O',
'?',
'Authenticate via Perl\'s DBI',
'MERGL',
'15'
],
[
'Apache::AuthenGSS',
'c',
'd',
'p',
'f',
'?',
'Generic Security Service (RFC 2078)',
'DOUGM',
'15'
],
[
'Apache::AuthenIMAP',
'b',
'd',
'p',
'f',
'?',
'Authentication via an IMAP server',
'MICB',
'15'
],
[
'Apache::AuthenPasswdSrv',
'a',
'n',
'p',
'f',
'o',
'External authentication server',
'JEFFH',
'15'
],
[
'Apache::AuthenPasswd',
'b',
'd',
'p',
'f',
'?',
'Authenticate against /etc/passwd',
'SPEEVES',
'15'
],
[
'Apache::AuthLDAP',
'b',
'd',
'p',
'f',
'?',
'LDAP authentication module',
'CDONLEY',
'15'
],
[
'Apache::AuthPerLDAP',
'b',
'd',
'p',
'f',
'?',
'LDAP authentication module (PerLDAP)',
'HENRIK',
'15'
],
[
'Apache::AuthenNIS',
'b',
'd',
'p',
'f',
'?',
'NIS authentication',
'SPEEVES',
'15'
],
[
'Apache::AuthNISPlus',
'b',
'd',
'p',
'F',
'?',
'NIS Plus authentication/authorization',
'VALERIE',
'15'
],
[
'Apache::AuthenRaduis',
'b',
'd',
'p',
'f',
'?',
'Authentication via a Radius server',
'DANIEL',
'15'
],
[
'Apache::AuthenSmb',
'b',
'd',
'p',
'f',
'p',
'Authenticate against NT server',
'PARKER',
'15'
],
[
'Apache::AuthenURL',
'b',
'd',
'p',
'f',
'?',
'Authenticate via another URL',
'JGROENVEL',
'15'
],
[
'Apache::DBILogin',
'b',
'd',
'p',
'f',
'?',
'Authenticate/authorize to backend database',
'JGROENVEL',
'15'
],
[
'Apache::DCELogin',
'b',
'd',
'p',
'f',
'?',
'Obtain a DCE login context',
'DOUGM',
'15'
],
[
'Apache::PHLogin',
'b',
'd',
'p',
'f',
'?',
'Authenticate via a PH database',
'JGROENVEL',
'15'
],
[
'Apache::TicketAccess',
'b',
'd',
'p',
'O',
'?',
'Ticket based access/authentication',
'MPB',
'15'
],
[
'DBD::InterBase',
'b',
'm',
'c',
'O',
'g',
'DBI driver for Firebird and InterBase RDBMS',
'EDPRATOMO',
'7'
],
[
'Apache::AuthzAge',
'b',
'm',
'p',
'f',
'?',
'Authorize based on age',
'APML',
'15'
],
[
'Apache::AuthzDCE',
'c',
'd',
'p',
'f',
'?',
'DFS/DCE ACL based access control',
'DOUGM',
'15'
],
[
'Apache::AuthzDBI',
'b',
'm',
'p',
'O',
'?',
'Group authorization via Perl\'s DBI',
'MERGL',
'15'
],
[
'Apache::AuthzGender',
'b',
'd',
'p',
'f',
'?',
'Authorize based on gender',
'MPB',
'15'
],
[
'Apache::AuthzNIS',
'b',
'd',
'p',
'f',
'?',
'NIS authorization',
'SPEEVES',
'15'
],
[
'Apache::AuthzPasswd',
'b',
'd',
'p',
'f',
'?',
'Authorize against /etc/passwd',
'SPEEVES',
'15'
],
[
'Apache::AuthzSSL',
'b',
'd',
'p',
'f',
'?',
'Authorize based on client cert',
'MPB',
'15'
],
[
'Apache::RoleAuthz',
'i',
'',
'',
'',
'?',
'Role-based authorization',
'DOUGM',
'15'
],
[
'Apache::AccessLimitNum',
'b',
'm',
'p',
'f',
'?',
'Limit user access by number of requests',
'APML',
'15'
],
[
'Apache::BlockAgent',
'b',
'd',
'p',
'f',
'?',
'Block access from certain agents',
'MPB',
'15'
],
[
'Apache::DayLimit',
'b',
'm',
'p',
'f',
'?',
'Limit access based on day of week',
'MPB',
'15'
],
[
'Apache::UploadMeter',
'a',
'd',
'p',
'n',
'p',
'Provides GUI progress meter for HTTP uploads',
'ISAAC',
'15'
],
[
'Apache::RobotLimit',
'c',
'd',
'p',
'f',
'?',
'Limit access of robots',
'PARKER',
'15'
],
[
'Apache::SpeedLimit',
'b',
'd',
'p',
'f',
'?',
'Control client request rate',
'MPB',
'15'
],
[
'Pod::Rtf',
'R',
'd',
'p',
'O',
'?',
'Converter from POD to Rich Text Format',
'PVHP',
'26'
],
[
'Apache::MIME',
'b',
'd',
'c',
'f',
'?',
'Perl implementation of mod_mime',
'MPB',
'15'
],
[
'Apache::MimeDBI',
'b',
'd',
'p',
'f',
'?',
'Type mapping from a DBI database',
'MPB',
'15'
],
[
'Apache::MimeXML',
'b',
'd',
'p',
'f',
'?',
'mime encoding sniffer for XML files',
'MSERGEANT',
'15'
],
[
'Apache::AdBlocker',
'b',
'd',
'p',
'f',
'?',
'Block advertisement images',
'MPB',
'15'
],
[
'Apache::AddHostPath',
'a',
'd',
'p',
'f',
'?',
'Prepends parts of hostname to URI',
'RJENKS',
'15'
],
[
'Apache::AnonProxy',
'b',
'd',
'p',
'f',
'?',
'Anonymizing proxy',
'MPB',
'15'
],
[
'Apache::Checksum',
'b',
'd',
'p',
'f',
'?',
'Manage document checksum trees',
'MPB',
'15'
],
[
'Apache::DynaRPC',
'i',
'',
'',
'',
'?',
'Dynamically translate URIs into RPCs',
'DOUGM',
'15'
],
[
'Apache::LowerCaseGETs',
'b',
'd',
'p',
'f',
'?',
'Lowercase URI\'s when needed',
'PLISTER',
'15'
],
[
'Apache::MsqlProxy',
'b',
'm',
'p',
'f',
'?',
'Translate URI\'s into mSQL queries',
'APML',
'15'
],
[
'Apache::ProxyPass',
'b',
'd',
'p',
'f',
'?',
'Perl implementation of ProxyPass',
'MJS',
'15'
],
[
'Apache::ProxyPassThru',
'b',
'd',
'p',
'O',
'?',
'Skeleton for vanilla proxy',
'RMANGI',
'15'
],
[
'Apache::ProxyCache',
'i',
'',
'',
'',
'?',
'Caching proxy',
'DOUGM',
'15'
],
[
'Apache::StripSession',
'b',
'd',
'p',
'f',
'?',
'Strip session info from URI',
'MPB',
'15'
],
[
'Apache::Throttle',
'b',
'd',
'p',
'f',
'?',
'Speed-based content negotiation',
'DONS',
'15'
],
[
'Apache::TransLDAP',
'b',
'd',
'p',
'f',
'?',
'Translate URIs to LDAP queries',
'CDONLEY',
'15'
],
[
'Perlbug',
'R',
'a',
'p',
'O',
'p',
'Database driven bug tracking system (mysql)',
'RFOLEY',
'3'
],
[
'Apache::Timeit',
'b',
'm',
'p',
'f',
'?',
'Benchmark PerlHandlers',
'APML',
'15'
],
[
'Apache::Usertrack',
'b',
'd',
'p',
'f',
'?',
'Perl version of mod_usertrack',
'ABH',
'15'
],
[
'Apache::DBILogConfig',
'R',
'd',
'p',
'n',
'g',
'Custom format logging via DBI for mod_perl',
'JBODNAR',
'15'
],
[
'Apache::DBILogger',
'b',
'd',
'p',
'f',
'?',
'Logging via DBI',
'ABH',
'15'
],
[
'Apache::DumpHeaders',
'b',
'd',
'p',
'f',
'?',
'Watch HTTP transaction via headers',
'DOUGM',
'15'
],
[
'Apache::LogMail',
'b',
'd',
'p',
'f',
'?',
'Log certain requests via email',
'MPB',
'15'
],
[
'Apache::Traffic',
'b',
'd',
'p',
'f',
'?',
'Logs bytes transferred, per-user basis',
'MAURICE',
'15'
],
[
'Apache::WatchDog',
'c',
'',
'',
'',
'?',
'Look for problematic URIs',
'DOUGM',
'15'
],
[
'Apache::Resource',
'S',
'm',
'p',
'f',
'?',
'Limit resources used by httpd children',
'APML',
'15'
],
[
'Apache::ConfigLDAP',
'i',
'',
'',
'',
'?',
'Config via LDAP and <Perl>',
'MARKK',
'15'
],
[
'Apache::ModuleConfig',
'S',
'm',
'c',
'O',
'?',
'Interface to configuration API',
'APML',
'15'
],
[
'Apache::PerlSections',
'S',
'm',
'p',
'O',
'?',
'Utilities for <Perl> sections',
'APML',
'15'
],
[
'Apache::httpd_conf',
'b',
'm',
'p',
'O',
'?',
'Methods to configure and run an httpd',
'APML',
'15'
],
[
'Apache::src',
'S',
'm',
'p',
'O',
'?',
'Finding and reading bits of source',
'APML',
'15'
],
[
'Apache::DBI',
'M',
'm',
'p',
'O',
'?',
'Persistent DBI connection mgmt.',
'PGOLLUCCI',
'15'
],
[
'Apache::Mysql',
'b',
'd',
'p',
'O',
'?',
'Persistent connection mgmt. for Mysql',
'NJENSEN',
'15'
],
[
'Apache::Sybase::DBlib',
'b',
'm',
'p',
'O',
'?',
'Persistent DBlib connection mgmt.',
'BMILLETT',
'15'
],
[
'Apache::Sybase::CTlib',
'M',
'd',
'p',
'n',
'?',
'Persistent CTlib connection mgmt for Apache',
'MDOWNING',
'15'
],
[
'Apache::Backhand',
'b',
'd',
'c',
'r',
'?',
'Bridge between mod_backhand + mod_perl',
'DLOWE',
'15'
],
[
'Apache::CmdParms',
'S',
'm',
'c',
'O',
'?',
'Interface to Apache cmd_parms struct',
'APML',
'15'
],
[
'Apache::Command',
'b',
'm',
'c',
'O',
'?',
'Interface to Apache command_rec struct',
'APML',
'15'
],
[
'Apache::Connection',
'S',
'm',
'c',
'O',
'?',
'Inteface to Apache conn_rec struct',
'APML',
'15'
],
[
'Apache::Constants',
'S',
'm',
'c',
'f',
'?',
'Constants defined in httpd.h',
'APML',
'15'
],
[
'Apache::ExtUtils',
'S',
'm',
'p',
'O',
'?',
'Utils for Apache:C/Perl glue',
'APML',
'15'
],
[
'Apache::File',
'S',
'm',
'c',
'O',
'?',
'Methods for working with files',
'APML',
'15'
],
[
'Apache::Handler',
'b',
'm',
'c',
'O',
'?',
'Interface to Apache handler_rec struct',
'APML',
'15'
],
[
'Apache::Log',
'S',
'm',
'c',
'O',
'?',
'ap_log_error interface',
'APML',
'15'
],
[
'Apache::LogFile',
'b',
'm',
'c',
'O',
'?',
'Interface to Apache\'s piped logs, etc.',
'APML',
'15'
],
[
'Apache::Module',
'b',
'm',
'c',
'O',
'?',
'Interface to Apache module struct',
'APML',
'15'
],
[
'Apache::Scoreboard',
'R',
'd',
'c',
'O',
'?',
'Perl interface to Apache\'s scoreboard.h',
'MJH',
'15'
],
[
'Apache::Server',
'S',
'm',
'c',
'O',
'?',
'Interface to Apache server_rec struct',
'APML',
'15'
],
[
'Apache::SubProcess',
'c',
'm',
'c',
'O',
'?',
'Interface to Apache subprocess API',
'APML',
'15'
],
[
'Apache::Table',
'S',
'm',
'c',
'O',
'?',
'Interface to Apache table struct + API',
'APML',
'15'
],
[
'Apache::URI',
'S',
'm',
'c',
'O',
'?',
'URI component parsing and unparsing',
'APML',
'15'
],
[
'Apache::Util',
'S',
'm',
'c',
'f',
'?',
'Interface to Apache\'s util*.c functions',
'APML',
'15'
],
[
'Apache::PATCH',
'b',
'd',
'p',
'f',
'?',
'HTTP PATCH method handler',
'MPB',
'15'
],
[
'Apache::PUT',
'c',
'd',
'p',
'f',
'?',
'HTTP PUT method handler',
'SORTIZ',
'15'
],
[
'Apache::Roaming',
'b',
'd',
'p',
'O',
'?',
'PUT/GET/MOVE/DELETE (Netscape Roaming)',
'JWIED',
'15'
],
[
'Apache::SizeLimit',
'S',
'm',
'p',
'f',
'?',
'Graceful exit for large children',
'APML',
'15'
],
[
'Apache::GTopLimit',
'S',
'd',
'p',
'n',
'p',
'Child exit on small shared or large mem',
'AARE',
'15'
],
[
'Apache::Status',
'S',
'm',
'p',
'f',
'?',
'Embedded interpreter runtime status',
'APML',
'15'
],
[
'Apache::VMonitor',
'M',
'd',
'p',
'n',
'p',
'Visual System and Processes Monitor',
'MJH',
'15'
],
[
'Apache::Watchdog::RunAway',
'R',
'd',
'p',
'n',
'p',
'RunAway processes watchdog/terminator',
'AARE',
'15'
],
[
'Apache::DB',
'a',
'm',
'c',
'O',
'?',
'Hook Perl interactive DB into mod_perl',
'STAS',
'15'
],
[
'Apache::Debug',
'R',
'm',
'p',
'f',
'?',
'mod_perl debugging utilities',
'APML',
'15'
],
[
'Apache::DebugInfo',
'a',
'm',
'p',
'O',
'?',
'Per-request data logging',
'GEOFF',
'15'
],
[
'Apache::DProf',
'b',
'm',
'c',
'f',
'?',
'Hook Devel::DProf into mod_perl',
'DOUGM',
'15'
],
[
'Apache::FakeRequest',
'a',
'm',
'p',
'O',
'?',
'Implement Apache methods off-line',
'APML',
'15'
],
[
'Apache::Leak',
'b',
'm',
'c',
'f',
'?',
'Memory leak tracking routines',
'APML',
'15'
],
[
'Apache::Peek',
'a',
'm',
'c',
'f',
'?',
'Devel::Peek for mod_perl',
'APML',
'15'
],
[
'Apache::SawAmpersand',
'b',
'm',
'p',
'f',
'?',
'Make sure noone is using $&, $\' or $`',
'APML',
'15'
],
[
'Apache::SmallProf',
'b',
'm',
'p',
'f',
'?',
'Hook Devel::SmallProf into mod_perl',
'DOUGM',
'15'
],
[
'Apache::StatINC',
'S',
'm',
'p',
'f',
'?',
'Reload require\'d files when updated',
'APML',
'15'
],
[
'Apache::Symbol',
'b',
'm',
'c',
'O',
'?',
'Things for symbol things',
'APML',
'15'
],
[
'Apache::Symdump',
'b',
'm',
'p',
'f',
'?',
'Symbol table snapshots to disk',
'APML',
'15'
],
[
'Apache::test',
'S',
'm',
'p',
'f',
'?',
'Handy routines for \'make test\' scripts',
'APML',
'15'
],
[
'Apache::Byterun',
'i',
'',
'',
'',
'?',
'Run Perl bytecode modules',
'DOUGM',
'15'
],
[
'Apache::Cookie',
'a',
'm',
'c',
'O',
'?',
'C version of CGI::Cookie',
'APML',
'15'
],
[
'Apache::Icon',
'b',
'd',
'c',
'O',
'?',
'Access to AddIcon* configuration',
'DOUGM',
'15'
],
[
'Apache::Include',
'S',
'm',
'p',
'f',
'?',
'mod_include + Apache::Registry handler',
'APML',
'15'
],
[
'Apache::Mmap',
'b',
'd',
'c',
'f',
'?',
'Share data via Mmap module',
'FLETCH',
'15'
],
[
'Apache::ParseLog',
'b',
'd',
'p',
'O',
'?',
'OO interface to Apache log files',
'AKIRA',
'15'
],
[
'Apache::RegistryLoader',
'S',
'm',
'p',
'O',
'?',
'Apache::Registry startup script loader',
'APML',
'15'
],
[
'Apache::Request',
'a',
'm',
'c',
'O',
'?',
'CGI.pm functionality using API methods',
'APML',
'15'
],
[
'Apache::Safe',
'a',
'm',
'p',
'O',
'?',
'Adaptation of "safecgiperl"',
'APML',
'15'
],
[
'Apache::Session',
'R',
'm',
'p',
'O',
'a',
'Maintain client <-> httpd session/state',
'CWEST',
'15'
],
[
'Apache::Servlet',
'a',
'm',
'p',
'O',
'?',
'Interface to the Java Servlet engine',
'IKLUFT',
'15'
],
[
'Apache::SIG',
'S',
'm',
'p',
'O',
'?',
'Signal handlers for mod_perl',
'APML',
'15'
],
[
'Apache::State',
'i',
'',
'',
'',
'?',
'Powerful state engine',
'RSE',
'15'
],
[
'Apache::TempFile',
'b',
'd',
'p',
'f',
'?',
'Manage temporary files',
'TOMHUGHES',
'15'
],
[
'Apache::Upload',
'a',
'm',
'c',
'O',
'?',
'File upload class',
'APML',
'15'
],
[
'Win32::API',
'R',
'd',
'c',
'O',
'p',
'Perl Win32 API Import Facility',
'ACALPINI',
'22'
],
[
'Unicode::MapUTF8',
'R',
'd',
'p',
'f',
'?',
'Conversions to and from arbitrary charsets',
'SNOWHARE',
'13'
],
[
'DDL::Oracle',
'R',
'd',
'p',
'O',
'?',
'Reverse engineers object DDL; also defrags',
'RVSUTHERL',
'7'
],
[
'ex::override',
'R',
'd',
'p',
'f',
'?',
'perl pragma to override core functions',
'CTWETEN',
'2'
],
[
'Log::Agent::Rotate',
'a',
'd',
'p',
'O',
'a',
'Logfile rotation config and support',
'MROGASKI',
'21'
],
[
'Math::Business::EMA',
'M',
'd',
'p',
'O',
'g',
'An Exponential Moving Average Calculator',
'JETTERO',
'6'
],
[
'Number::Phone::US',
'R',
'd',
'p',
'f',
'?',
'Validates several US phone number formats',
'KENNEDYH',
'11'
],
[
'Tie::Scalar::Timeout',
'a',
'd',
'p',
'r',
'?',
'Scalar variables that time out',
'MARCEL',
'6'
],
[
'Text::DoubleMetaphone',
'a',
'd',
'c',
'f',
'?',
'Convert string to phonetic encoding',
'MAURICE',
'11'
],
[
'CGI::PathInfo',
'R',
'd',
'p',
'O',
'p',
'A lightweight PATH_INFO based CGI package',
'SNOWHARE',
'15'
],
[
'Crypt::TripleDES',
'R',
'd',
'p',
'O',
'?',
'Triple DES encyption.',
'VIPUL',
'14'
],
[
'Crypt::PGP5',
'b',
'd',
'p',
'O',
'p',
'Object-oriented interface to PGP v5.',
'AGUL',
'14'
],
[
'Crypt::PGP6',
'c',
'd',
'p',
'O',
'p',
'Object-oriented Interface to PGP v6.',
'AGUL',
'14'
],
[
'Crypt::PGP',
'c',
'd',
'p',
'O',
'p',
'Unified interface to PGP and GnuPG',
'AGUL',
'14'
],
[
'Crypt::GPG',
'b',
'd',
'p',
'O',
'p',
'Object-oriented interface to GnuPG',
'AGUL',
'14'
],
[
'HTML::Widgets::DateEntry',
'R',
'd',
'p',
'O',
'?',
'Creates date entry widgets for HTML forms.',
'KENNEDYH',
'15'
],
[
'HTML::Widgets::Search',
'R',
'd',
'p',
'O',
'?',
'Perl module for building searches returning',
'FRANKIE',
'15'
],
[
'Net::Z3950',
'R',
'm',
'c',
'O',
'?',
'OO interface (ZOOM) to Yaz Z39.50 toolkit',
'MIRK',
'5'
],
[
'POE::Component::RSS',
'b',
'd',
'p',
'?',
'b',
'Event based RSS interface',
'SUNGO',
'6'
],
[
'POE::Component::SubWrapper',
'b',
'd',
'p',
'?',
'b',
'Event based Module interface',
'SUNGO',
'6'
],
[
'OLE::Storage_Lite',
'a',
'd',
'p',
'O',
'?',
'Simple Class for OLE document interface',
'JMCNAMARA',
'7'
],
[
'Solaris::InstallDB',
'b',
'd',
'p',
'?',
'?',
'Searches for Solaris package/system info',
'CHRISJ',
'4'
],
[
'Solaris::Package',
'b',
'd',
'p',
'O',
'?',
'Access a Solaris package pkginfo file',
'CHRISJ',
'4'
],
[
'Solaris::Contents',
'b',
'd',
'p',
'?',
'?',
'Access a Solaris contents file',
'CHRISJ',
'4'
],
[
'Crypt::ECB',
'M',
'd',
'p',
'h',
'?',
'ECB mode for Crypt::DES, Blowfish, etc.',
'APPEL',
'14'
],
[
'Python',
'b',
'm',
'c',
'f',
'?',
'Interface Python API (for embedded python)',
'GAAS',
'9'
],
[
'Python::Object',
'b',
'm',
'c',
'O',
'?',
'Wrapper for python objects',
'GAAS',
'9'
],
[
'Python::Err',
'b',
'm',
'c',
'O',
'?',
'Wrapper for python exceptions',
'GAAS',
'9'
],
[
'Image::Info',
'R',
'd',
'p',
'O',
'?',
'Extract meta information from image files',
'GAAS',
'18'
],
[
'Astro::Sunrise',
'R',
'd',
'p',
'f',
'p',
'Computes sunrise/sunset for a given day',
'RKHILL',
'23'
],
[
'Getopt::Tiny',
'R',
'd',
'p',
'r',
'a',
'Table of references interface, auto usage()',
'MUIR',
'12'
],
[
'File::BasicFlock',
'R',
'd',
'p',
'f',
'o',
'Simple flock() wrapper',
'MUIR',
'10'
],
[
'Pod::Hlp',
'R',
'd',
'p',
'O',
'?',
'Convert POD to formatted VMS Help text',
'PVHP',
'26'
],
[
'Quantum::Superpositions',
'R',
'd',
'p',
'f',
'p',
'Conjunctive & Disjunctive logic for Perl5',
'LEMBARK',
'6'
],
[
'Class::Contract',
'R',
'd',
'p',
'O',
'?',
'Design-by-Contract OO in Perl.',
'GGOEBEL',
'6'
],
[
'Class::WhiteHole',
'R',
'd',
'p',
'O',
'?',
'Treat unhandled method calls as errors',
'MSCHWERN',
'6'
],
[
'End',
'R',
'd',
'p',
'O',
'?',
'Generalized END {}.',
'ABIGAIL',
'2'
],
[
'Devel::Modlist',
'R',
'd',
'p',
'f',
'?',
'Collect module use information',
'RJRAY',
'3'
],
[
'Net::SSL',
'R',
'd',
'c',
'O',
'?',
'Glue that enables LWP to access https URIs',
'CHAMAS',
'5'
],
[
'Tie::Cycle',
'R',
'd',
'p',
'O',
'?',
'Cycle through a list of values via a scalar.',
'BDFOY',
'6'
],
[
'Array::Reform',
'b',
'm',
'p',
'O',
'p',
'DB-Abstractionlayer/Access via Arrays/Hashes',
'TBONE',
'7'
],
[
'Data::JavaScript',
'R',
'd',
'p',
'r',
'?',
'Dumps structures into JavaScript code',
'SCHOP',
'6'
],
[
'Parse::YALALR',
'b',
'd',
'p',
'O',
'?',
'Yet Another LALR parser',
'SFINK',
'11'
],
[
'Parse::Vipar',
'b',
'd',
'p',
'O',
'?',
'Visual LALR parser debugger',
'SFINK',
'11'
],
[
'Net::Pager',
'R',
'd',
'p',
'O',
'?',
'Send Numeric/AlphaNumeric Pages to any pager',
'ROOTLEVEL',
'5'
],
[
'Net::Whois',
'R',
'd',
'p',
'O',
'p',
'Get+parse "whois" domain data from InterNIC',
'DHUDES',
'5'
],
[
'Net::XWhois',
'R',
'd',
'p',
'O',
'?',
'Whois Client Interface for Perl5.',
'VIPUL',
'5'
],
[
'GraphViz',
'R',
'd',
'p',
'O',
'p',
'Interface to the GraphViz graphing tool',
'LBROCARD',
'18'
],
[
'Font::Fret',
'R',
'd',
'p',
'O',
'?',
'Fret - Font REporting Tool',
'MHOSKEN',
'11'
],
[
'Math::Libm',
'R',
'd',
'c',
'O',
'?',
'Perl extension for the C math library, libm',
'DSLEWART',
'6'
],
[
'RDF::Service',
'a',
'm',
'p',
'O',
'?',
'RDF API with DBI and other backends',
'JONAS',
'11'
],
[
'Locale::Maketext',
'R',
'd',
'p',
'O',
'p',
'Framework for software localization',
'PETDANCE',
'13'
],
[
'Locale::PO',
'R',
'd',
'p',
'O',
'p',
'Manipulate .po entries from gettext',
'ALANSZ',
'13'
],
[
'Inline',
'b',
'd',
'p',
'?',
'p',
'Write Perl subroutines in other languages',
'INGY',
'2'
],
[
'Class::BlackHole',
'R',
'd',
'p',
'O',
'p',
'treat unhandled method calls as no-op',
'SBURKE',
'6'
],
[
'Class::Classless',
'M',
'd',
'p',
'O',
'p',
'Framework for classless OOP',
'SBURKE',
'6'
],
[
'Class::ISA',
'M',
'd',
'p',
'f',
'p',
'Report the search path thru an ISA tree',
'SBURKE',
'6'
],
[
'Business::US_Amort',
'M',
'd',
'p',
'h',
'p',
'US-style loan amortization calculations',
'SBURKE',
'23'
],
[
'Games::Alak',
'R',
'd',
'p',
'f',
'p',
'a simple gomoku-like game',
'AVIF',
'23'
],
[
'Games::Dissociate',
'M',
'd',
'p',
'f',
'p',
'a Dissociated Press algorithm and filter',
'AVIF',
'23'
],
[
'Games::Worms',
'R',
'd',
'p',
'O',
'p',
'A life simulator for Conway/Patterson worms',
'AVIF',
'23'
],
[
'Mac::FileSpec::Unixish',
'M',
'd',
'p',
'f',
'p',
'Unixish-compatability in filespecs',
'SBURKE',
'4'
],
[
'Tree::DAG_Node',
'M',
'd',
'p',
'O',
'p',
'base class for trees',
'SBURKE',
'6'
],
[
'Lingua::EN::Numbers::Ordinate',
'R',
'd',
'p',
'f',
'p',
'go from cardinal (53) to ordinal (53rd)',
'SBURKE',
'11'
],
[
'HTML::Tagset',
'R',
'd',
'p',
'f',
'p',
'data tables useful in parsing HTML',
'PETDANCE',
'15'
],
[
'Tk::TextANSIColor',
'b',
'd',
'p',
'O',
'p',
'use ANSI color codes in Text widget',
'TJENNESS',
'8'
],
[
'Tk::Autoscroll',
'a',
'd',
'p',
'f',
'p',
'Alternative way to scroll',
'SREZIC',
'8'
],
[
'Tk::Axis',
'R',
'm',
'p',
'O',
'?',
'Canvas with Axes',
'TKML',
'8'
],
[
'Tk::CheckBox',
'R',
'd',
'p',
'O',
'?',
'A radio button widget that uses a checkmark',
'DKWILSON',
'8'
],
[
'Tk::ChildNotification',
'R',
'd',
'p',
'O',
'?',
'Alert widget when child is created',
'DKWILSON',
'8'
],
[
'Tk::Clock',
'R',
'd',
'p',
'O',
'p',
'Canvas based Clock widget',
'HMBRAND',
'8'
],
[
'Tk::Cloth',
'R',
'd',
'p',
'O',
'?',
'Object interface to Tk::Canvas and items',
'SREZIC',
'8'
],
[
'Tk::Columns',
'R',
'd',
'p',
'O',
'?',
'Multi column lists w/ resizable borders',
'DKWILSON',
'8'
],
[
'Tk::ComboEntry',
'R',
'd',
'p',
'O',
'?',
'Drop down list + entry widget',
'DKWILSON',
'8'
],
[
'Tk::ContextHelp',
'a',
'd',
'p',
'O',
'p',
'A context-sensitive help system',
'SREZIC',
'8'
],
[
'Tk::Dial',
'R',
'm',
'p',
'O',
'?',
'An alternative to the Scale widget',
'TKML',
'8'
],
[
'Tk::Date',
'b',
'd',
'p',
'O',
'p',
'A date/time widget',
'SREZIC',
'8'
],
[
'Tk::Enscript',
'c',
'd',
'p',
'f',
'p',
'Create postscript from text files using Tk',
'SREZIC',
'8'
],
[
'Tk::FcyEntry',
'a',
'd',
'p',
'O',
'?',
'Entry with bg color depending on -state',
'SREZIC',
'8'
],
[
'Tk::FileDialog',
'R',
'd',
'p',
'O',
'?',
'A highly configurable file selection widget',
'BPOWERS',
'8'
],
[
'Tk::FileEntry',
'a',
'd',
'p',
'O',
'?',
'Primitive clone of Tix FileEntry widget',
'SREZIC',
'8'
],
[
'Tk::FireButton',
'R',
'd',
'p',
'O',
'?',
'Keeps invoking callback when pressed',
'SREZIC',
'8'
],
[
'Tk::FlatCheckbox',
'a',
'd',
'p',
'O',
'p',
'A checkbox suitable for flat reliefs',
'SREZIC',
'8'
],
[
'Tk::FontDialog',
'b',
'd',
'p',
'O',
'p',
'A font dialog widget for perl/Tk',
'SREZIC',
'8'
],
[
'Tk::Getopt',
'a',
'd',
'p',
'O',
'p',
'Configuration interface to Getopt::Long',
'SREZIC',
'8'
],
[
'Tk::HistEntry',
'a',
'd',
'p',
'O',
'p',
'An entry widget with history capability',
'SREZIC',
'8'
],
[
'Tk::HTML',
'b',
'd',
'p',
'O',
'?',
'View HTML in a Tk Text widget',
'PETDANCE',
'8'
],
[
'Tk::IconCanvas',
'R',
'd',
'p',
'O',
'?',
'Canvas with movable iconic interface',
'DKWILSON',
'8'
],
[
'Tk::JPEG',
'R',
'd',
'c',
'O',
'?',
'JPEG loader for Tk::Photo',
'PETDANCE',
'8'
],
[
'Tk::LockDisplay',
'R',
'd',
'p',
'O',
'p',
'Screen saver/lock widget with animation',
'LUSOL',
'8'
],
[
'Tk::Login',
'c',
'd',
'p',
'O',
'?',
'A Login widget (name, passwd, et al)',
'BPOWERS',
'8'
],
[
'Tk::Menustrip',
'R',
'd',
'p',
'O',
'?',
'Another MenuBar',
'DKWILSON',
'8'
],
[
'Tk::More',
'a',
'd',
'p',
'O',
'?',
'A more (or less) like text widget',
'SREZIC',
'8'
],
[
'Tk::Multi',
'R',
'd',
'p',
'O',
'p',
'Manages several Text or Canvas widgets',
'DDUMONT',
'8'
],
[
'Tk::NumEntry',
'R',
'd',
'p',
'O',
'?',
'Numerical entry widget with up/down buttons',
'SREZIC',
'8'
],
[
'Tk::ObjScanner',
'R',
'd',
'p',
'O',
'?',
'Tk data or object scanner',
'DDUMONT',
'8'
],
[
'Tk::Olwm',
'R',
'm',
'p',
'O',
'?',
'Interface to OpenLook toplevels properties',
'TKML',
'8'
],
[
'Tk::Pane',
'R',
'd',
'p',
'O',
'?',
'A Frame that can be scrolled',
'TKML',
'8'
],
[
'Tk::PNG',
'R',
'd',
'c',
'O',
'?',
'PNG loader for Tk::Photo',
'PETDANCE',
'8'
],
[
'Tk::Pod',
'?',
'm',
'p',
'O',
'?',
'POD browser toplevel widget',
'TKML',
'8'
],
[
'Tk::ProgressBar',
'R',
'd',
'p',
'O',
'?',
'Status/progress bar',
'TKML',
'8'
],
[
'Tk::ProgressMeter',
'c',
'd',
'p',
'O',
'?',
'Simple thermometer-style widget w/callbacks',
'BPOWERS',
'8'
],
[
'Tk::RotCanvas',
'R',
'd',
'p',
'O',
'?',
'Canvas with arbitrary rotation support',
'AQUMSIEH',
'8'
],
[
'Tk::SplitFrame',
'R',
'd',
'p',
'O',
'?',
'A sliding separator for two child widgets',
'DKWILSON',
'8'
],
[
'Tk::TabFrame',
'R',
'd',
'p',
'O',
'?',
'A tabbed frame geometry manager',
'DKWILSON',
'8'
],
[
'Tk::TabbedForm',
'R',
'd',
'p',
'O',
'?',
'Ext. TabFrame, allowing managed subwidgets',
'DKWILSON',
'8'
],
[
'Tk::TableEdit',
'R',
'd',
'p',
'O',
'?',
'Simplified interface to a flat file database',
'DKWILSON',
'8'
],
[
'Tk::TableMatrix',
'b',
'd',
'c',
'O',
'?',
'Display data in Table/Spreadsheet format',
'CERNEY',
'8'
],
[
'Tk::TiedListbox',
'R',
'm',
'p',
'O',
'?',
'Gang together Listboxes',
'TKML',
'8'
],
[
'Tk::TFrame',
'R',
'd',
'p',
'O',
'?',
'A Frame with a title',
'SREZIC',
'8'
],
[
'Tk::TIFF',
'a',
'd',
'p',
'O',
'p',
'TIFF loader for Tk::Photo',
'SREZIC',
'8'
],
[
'Tk::Tree',
'R',
'd',
'p',
'O',
'?',
'Create and manipulate Tree widgets',
'CTDEAN',
'8'
],
[
'Tk::TreeGraph',
'R',
'd',
'p',
'O',
'p',
'Widget to draw a tree in a Canvas',
'DDUMONT',
'8'
],
[
'Tk::WaitBox',
'R',
'd',
'p',
'O',
'?',
'A Wait dialog, of the "Please Wait" variety',
'BPOWERS',
'8'
],
[
'Tk::XMLViewer',
'a',
'd',
'p',
'O',
'p',
'Tk widget to display XML',
'SREZIC',
'8'
],
[
'Log::Dispatch::ToTk',
'R',
'd',
'p',
'O',
'p',
'Interface class between Log::Dispatch and Tk',
'DDUMONT',
'8'
],
[
'Log::Dispatch::TkText',
'R',
'd',
'p',
'O',
'p',
'Text widget to log Log::Dispatch messages',
'DDUMONT',
'8'
],
[
'Puppet::Body',
'a',
'd',
'p',
'O',
'?',
'Base class for persistent data',
'DDUMONT',
'8'
],
[
'Puppet::Log',
'b',
'd',
'p',
'O',
'?',
'Logging facility based on Tk',
'DDUMONT',
'8'
],
[
'Puppet::Any',
'a',
'd',
'p',
'O',
'?',
'Base class for an optionnal GUI',
'DDUMONT',
'8'
],
[
'Puppet::VcsTools::History',
'b',
'd',
'p',
'O',
'?',
'VCS (RCS HMS) history viewer based on Canvas',
'DDUMONT',
'8'
],
[
'Puppet::VcsTools::File',
'a',
'd',
'p',
'O',
'?',
'VCS (RCS HMS) file manager',
'DDUMONT',
'8'
],
[
'DBIx::XML_RDB',
'?',
'?',
'?',
'?',
'?',
'Creates XML from DBI datasources',
'MSERGEANT',
'7'
],
[
'XML::DOM',
'b',
'm',
'p',
'O',
'p',
'Implements Level 1 of W3\'s DOM',
'TJMATHER',
'11'
],
[
'XML::Dumper',
'a',
'm',
'p',
'O',
'?',
'Converts XML from/to Perl code',
'MIKEWONG',
'11'
],
[
'XML::Encoding',
'?',
'?',
'?',
'?',
'?',
'Parses encoding map XML files',
'COOPERCL',
'11'
],
[
'XML::Edifact',
'?',
'?',
'?',
'?',
'?',
'Scripts for translating EDIFACT into XML',
'KRAEHE',
'11'
],
[
'XML::Generator',
'b',
'd',
'p',
'O',
'p',
'Generates XML documents',
'BHOLZMAN',
'11'
],
[
'XML::Grove',
'R',
'm',
'p',
'O',
'?',
'Flexible lightweight mid-level XML objects',
'KMACLEOD',
'11'
],
[
'XML::miniXQL',
'?',
'?',
'?',
'?',
'?',
'Simplistic XQL-like search using streams',
'MSERGEANT',
'11'
],
[
'XML::Parser',
'b',
'm',
'c',
'O',
'?',
'Flexible fast parser with plug-in styles',
'COOPERCL',
'11'
],
[
'XML::QL',
'?',
'?',
'?',
'?',
'?',
'Implements the XML Query Language',
'MSERGEANT',
'11'
],
[
'XML::Registry',
'a',
'm',
'p',
'O',
'?',
'Implements a generic XML registry',
'EISEN',
'11'
],
[
'XML::Writer',
'M',
'd',
'p',
'O',
'p',
'Module for writing XML documents',
'JOSEPHW',
'11'
],
[
'XML::XQL',
'a',
'm',
'p',
'O',
'p',
'Performs XQL queries on XML object trees',
'TJMATHER',
'11'
],
[
'Frontier::RPC',
'?',
'?',
'?',
'?',
'?',
'Performs Remote Procedure Calls using XML',
'KMACLEOD',
'11'
],
[
'CGI::XML',
'a',
'm',
'p',
'O',
'?',
'Convert CGI.pm variables to/from XML',
'EISEN',
'15'
],
[
'Algorithm::Graphs::TransitiveClosure',
'R',
'd',
'p',
'O',
'?',
'Calculates the transitive closure',
'ABIGAIL',
'6'
],
[
'Net::SNMP::Interfaces',
'R',
'd',
'p',
'O',
'p',
'Obtain IfTable entries via SNMP',
'JSTOWE',
'5'
],
[
'DBIx::DBSchema',
'b',
'm',
'p',
'O',
'p',
'Database-independent schema objects',
'IVAN',
'7'
],
[
'FCGI::ProcManager',
'b',
'd',
'p',
'O',
'?',
'A FastCGI process manager',
'JURACH',
'15'
],
[
'File::Searcher',
'b',
'd',
'p',
'O',
'?',
'Search filetree do search/replace regexes',
'ASTUBBS',
'10'
],
[
'File::Searcher::Interactive',
'b',
'd',
'p',
'O',
'?',
'Interactive search do search/replace regexes',
'ASTUBBS',
'10'
],
[
'Text::FastTemplate',
'b',
'd',
'p',
'O',
'g',
'Perl subs from line-oriented templates',
'BOZZIO',
'11'
],
[
'HTTP::GHTTP',
'R',
'd',
'c',
'O',
'?',
'Perl interface to the gnome ghttp library',
'MSERGEANT',
'15'
],
[
'XML::XPath',
'R',
'd',
'p',
'O',
'?',
'A set of modules for parsing and evaluating',
'MSERGEANT',
'11'
],
[
'Time::Seconds',
'R',
'd',
'c',
'O',
'?',
'API to convert seconds to other date values',
'MSERGEANT',
'6'
],
[
'Apache::AxKit',
'M',
'm',
'c',
'O',
'o',
'XML Application Server for Apache',
'MSERGEANT',
'15'
],
[
'Apache::Reload',
'R',
'd',
'p',
'O',
'?',
'Reload changed modules (extending StatINC)',
'MSERGEANT',
'15'
],
[
'XML::PYX',
'R',
'd',
'p',
'O',
'?',
'XML to PYX generator',
'MSERGEANT',
'11'
],
[
'XML::XSLT',
'b',
'd',
'p',
'O',
'p',
'Process XSL Transformational sheets',
'JSTOWE',
'11'
],
[
'XML::TreeBuilder',
'R',
'd',
'p',
'O',
'p',
'Build a tree of XML::Element objects',
'JGOFF',
'11'
],
[
'XML::Sablotron',
'R',
'd',
'c',
'O',
'o',
'Interface to the Sablotron XSLT processor',
'PAVELH',
'11'
],
[
'XML::PPD',
'R',
'd',
'p',
'O',
'?',
'PPD file format and XML parsing elements',
'MURRAY',
'11'
],
[
'XML::Element',
'R',
'd',
'p',
'O',
'p',
'XML elements with the same interface as HTML',
'JGOFF',
'11'
],
[
'XML::Doctype',
'R',
'd',
'p',
'O',
'?',
'A DTD object class',
'RBS',
'11'
],
[
'XML::Catalog',
'R',
'd',
'p',
'O',
'p',
'Resolve public identifiers and remap system',
'EBOHLMAN',
'11'
],
[
'XML::AutoWriter',
'R',
'd',
'p',
'O',
'?',
'DOCTYPE based XML output',
'RBS',
'11'
],
[
'Pod::XML',
'R',
'd',
'p',
'O',
'?',
'Generate XML from POD',
'MSERGEANT',
'26'
],
[
'Inline::CPR',
'a',
'd',
'p',
'n',
'?',
'C Perl Run - Embed Perl in C, ala Inline',
'INGY',
'2'
],
[
'Inline::C',
'b',
'd',
'p',
'n',
'p',
'Write Perl subroutines in C',
'INGY',
'2'
],
[
'Inline::CPP',
'b',
'd',
'p',
'O',
'?',
'Easy implementation of C++ extensions',
'NEILW',
'2'
],
[
'Inline::Python',
'a',
'd',
'c',
'O',
'?',
'Easy implementation of Python extensions',
'NEILW',
'2'
],
[
'Crypt::CipherSaber',
'R',
'd',
'p',
'O',
'p',
'OO module for CS-1 and CS-2 encryption',
'CHROMATIC',
'14'
],
[
'ex::constant::vars',
'R',
'd',
'p',
'h',
'?',
'Perl pragma to create readonly variables',
'CTWETEN',
'2'
],
[
'Pod::PP',
'a',
'd',
'p',
'O',
'a',
'A Pod pre-processor',
'RAM',
'26'
],
[
'XML::CSV',
'R',
'm',
'p',
'O',
'a',
'Transform comma separated values to XML',
'ISTERIN',
'11'
],
[
'MLDBM::Sync',
'R',
'd',
'p',
'r',
'p',
'MLDBM wrapper to serialize concurrent access',
'CHAMAS',
'7'
],
[
'Continuus',
'a',
'd',
'p',
'O',
'?',
'Interface to Continuus Code Management tool',
'HENKE',
'3'
],
[
'HTTP::WebTest',
'R',
'd',
'p',
'O',
'p',
'Testing static and dynamic web content',
'ILYAM',
'15'
],
[
'DBD::RDB',
'R',
'd',
'o',
'f',
'?',
'DBI driver for Oracle RDB (OpenVMS only)',
'ASTILLER',
'7'
],
[
'Set::CheckList',
'a',
'd',
'p',
'h',
'?',
'Maintain a list of "to-do" items',
'MIKO',
'6'
],
[
'Mail::VersionTracker',
'b',
'd',
'p',
'O',
'g',
'Parses newsletters from versiontracker.com',
'FOX',
'19'
],
[
'Bundle::Bugzilla',
'R',
'm',
'o',
'n',
'o',
'Bundle to load modules for Bugzilla',
'ZLIPTON',
'25'
],
[
'Mail::Box',
'R',
'm',
'p',
'O',
'p',
'Mail folder manager and MUA backend',
'MARKOV',
'19'
],
[
'Class::Delegate',
'b',
'd',
'p',
'O',
'?',
'Easy-to-use object delegation',
'KSTAR',
'6'
],
[
'Data::MultiValuedHash',
'R',
'd',
'p',
'O',
'p',
'Hash whose keys have multiple ordered values',
'DUNCAND',
'6'
],
[
'CGI::MultiValuedHash',
'b',
'd',
'p',
'O',
'p',
'Store and manipulate url-encoded data',
'DUNCAND',
'15'
],
[
'Mail::Vmailmgr',
'b',
'd',
'p',
'O',
'?',
'A Perl module to use Vmailmgr daemon',
'MARTIN',
'19'
],
[
'Class::StructTemplate',
'a',
'd',
'p',
'O',
'?',
'Facilitates creation of public class-data',
'HEIKOWU',
'6'
],
[
'Class::PublicInternal',
'a',
'd',
'p',
'O',
'?',
'Keep separate hashes of public/internal data',
'MIKO',
'6'
],
[
'Net::SMS',
'R',
'd',
'p',
'O',
'p',
'Send SMS wireless text-messages.',
'ROOTLEVEL',
'5'
],
[
'Net::SMS::Genie',
'R',
'd',
'p',
'O',
'p',
'Send SMS messages using the Genie gateway',
'AWRIGLEY',
'5'
],
[
'Class::ParamParser',
'R',
'd',
'p',
'O',
'p',
'Provides complex parameter list parsing',
'DUNCAND',
'6'
],
[
'HTML::EasyTags',
'R',
'd',
'p',
'O',
'p',
'Make well-formed XHTML or HTML 4 tags, lists',
'DUNCAND',
'15'
],
[
'Shockwave::Lingo',
'i',
'?',
'?',
'?',
'?',
'Collection of modules for Lingo processing',
'MARTIN',
'9'
],
[
'Class::ObjectTemplate',
'R',
'd',
'p',
'O',
'p',
'Optimized template builder base class',
'JASONS',
'6'
],
[
'Class::ObjectTemplate::DB',
'R',
'd',
'p',
'O',
'p',
'Template base class for database objects',
'JASONS',
'6'
],
[
'Bio::Genex',
'R',
'm',
'p',
'O',
'o',
'Store, manipulate gene expression data',
'JASONS',
'23'
],
[
'POE::Component::UserBase',
'R',
'd',
'p',
'O',
'?',
'A component to manage user authentication',
'JGOFF',
'6'
],
[
'CGI::SSI_Parser',
'b',
'd',
'p',
'f',
'?',
'Implement SSI for Perl CGI',
'VADIM',
'15'
],
[
'VMS::Fileutils::Root',
'R',
'd',
'p',
'O',
'?',
'Evade VMS\'s 8 level directory restrictions',
'CLANE',
'4'
],
[
'VMS::Fileutils::SafeName',
'R',
'd',
'p',
'f',
'?',
'Transform filenames to "VMS safe" form',
'CLANE',
'4'
],
[
'Math::FFT',
'a',
'd',
'c',
'O',
'p',
'Perl extension for Fast Fourier Transforms',
'RKOBES',
'6'
],
[
'AltaVista::PerlSDK',
'a',
'd',
'c',
'f',
'?',
'Utilize the AltaVista Search Developer\'s Kit',
'BWILLIAM',
'24'
],
[
'Win32::OLE::OPC',
'R',
'd',
'p',
'O',
'?',
'Ole for Process Control Server Interface',
'MARTINTO',
'22'
],
[
'HTML::FormTemplate',
'b',
'd',
'p',
'O',
'p',
'Make data-defined persistant forms, reports',
'DUNCAND',
'15'
],
[
'Authen::Krb5::Easy',
'b',
'd',
'c',
'f',
'p',
'Easy krb5 client interface using krb libs.',
'SCHALLEE',
'14'
],
[
'Term::ANSIScreen',
'b',
'd',
'p',
'f',
'?',
'Terminal control using ANSI escape sequences',
'AUTRIJUS',
'8'
],
[
'Games::AIBots',
'b',
'm',
'p',
'O',
'p',
'An improved clone of A.I.Wars in Perl',
'AUTRIJUS',
'23'
],
[
'OurNet',
'R',
'm',
'h',
'h',
'p',
'Interface to BBS-based groupware platforms',
'AUTRIJUS',
'15'
],
[
'HPUX::Ioscan',
'b',
'd',
'p',
'h',
'p',
'Perl function to handle HPUX ioscan command',
'CWHITE',
'4'
],
[
'Tie::LDAP',
'b',
'd',
'p',
'r',
'?',
'Ties LDAP database to Perl hash',
'TAIY',
'6'
],
[
'Audio::SoundFile',
'a',
'd',
'c',
'O',
'?',
'Sound I/O based on libsndfile, PDL interface',
'TAIY',
'23'
],
[
'CGI::SecureState',
'R',
'd',
'p',
'O',
'p',
'Securely stores CGI parameters',
'BEHROOZI',
'15'
],
[
'AI::Gene::Sequence',
'R',
'd',
'p',
'O',
'?',
'Base class of mutation methods +gene grammar',
'AJGOUGH',
'23'
],
[
'AI::Gene::Simple',
'R',
'd',
'p',
'O',
'?',
'Base class of mutation methods',
'AJGOUGH',
'23'
],
[
'Data::Iterator',
'R',
'u',
'p',
'O',
'?',
'Simple iteration over complex data strucures',
'HCAMP',
'6'
],
[
'Crypt::PGPSimple',
'c',
'd',
'p',
'O',
'?',
'Basic interface to PGP',
'JHINKLE',
'14'
],
[
'Net::HTTPTunnel',
'a',
'd',
'p',
'O',
'?',
'Tunnel through HTTP proxies with CONNECT',
'RWAHBY',
'5'
],
[
'Tie::CharArray',
'R',
'd',
'p',
'r',
'p',
'Manipulate strings as arrays of characters',
'ILTZU',
'6'
],
[
'Time::Stopwatch',
'R',
'd',
'p',
'r',
'p',
'Tied variables that count seconds',
'ILTZU',
'6'
],
[
'Text::Substitute',
'a',
'd',
'p',
'f',
'?',
'Runtime backslash sequence substitution',
'ILTZU',
'11'
],
[
'Convert::GeekCode',
'b',
'd',
'p',
'h',
'p',
'Convert and generate geek code sequences',
'AUTRIJUS',
'11'
],
[
'Convert::IBM390',
'R',
'd',
'h',
'f',
'p',
'Convert data from/to S/390 representations',
'GROMMEL',
'17'
],
[
'Net::Gnutella',
'b',
'd',
'p',
'O',
'?',
'Gnutella network (v0.4) interface',
'IWADE',
'5'
],
[
'CGI::State',
'b',
'd',
'p',
'f',
'?',
'CGI params into multi-dimensional hash',
'DKUBB',
'15'
],
[
'Image::Imlib2',
'R',
'd',
'c',
'O',
'p',
'Interface to the Imlib2 image library',
'LBROCARD',
'18'
],
[
'HTML::LoL',
'R',
'd',
'p',
'f',
'?',
'Construct HTML from Perl data structures',
'BOBG',
'15'
],
[
'Convert::Morse',
'R',
'd',
'p',
'f',
'p',
'Convert from/to Morse code (.--. . .-. .-..)',
'TELS',
'17'
],
[
'Tie::RangeHash',
'R',
'd',
'p',
'h',
'p',
'Hashes with \'low,high\' ranges as keys',
'RRWO',
'6'
],
[
'CGI::SSI',
'R',
'd',
'p',
'O',
'?',
'Use SSI from CGI scripts',
'JAMES',
'15'
],
[
'Config::Ini',
'R',
'd',
'p',
'O',
'p',
'Accesses Windows .ini and .reg files',
'AVATAR',
'12'
],
[
'Convert::RACE',
'b',
'd',
'p',
'f',
'?',
'Conversion between Unicode and RACE',
'MIYAGAWA',
'17'
],
[
'Quantum::Entanglement',
'R',
'd',
'p',
'h',
'?',
'QM entanglement of variables in perl',
'AJGOUGH',
'6'
],
[
'POE::Component::IRC::Onjoin',
'R',
'd',
'p',
'O',
'g',
'Provides IRC moved message & onjoin services',
'FOX',
'6'
],
[
'Music::GUIDO',
'c',
'd',
'p',
'O',
'?',
'Reads, writes, and manipulates GUIDO scores',
'KARLWARD',
'23'
],
[
'SQL::Generator',
'a',
'd',
'p',
'O',
'g',
'Generate SQL-queries via OO perl',
'MUENALAN',
'11'
],
[
'Apache::ASP::Lite',
'i',
'm',
'p',
'O',
'?',
'Lightweight IIS emulation under Apache',
'FERGUSOR',
'15'
],
[
'Math::BooleanEval',
'b',
'd',
'p',
'O',
'?',
'Parsing and evaluating Boolean expressions',
'MIKO',
'6'
],
[
'Date::Tolkien::Shire',
'R',
'd',
'p',
'O',
'p',
'J.R.R. Tolkien\'s hobbit calendar',
'TBRAUN',
'6'
],
[
'Algorithm::SISort',
'R',
'd',
'c',
'r',
'p',
'Select And Insert sorting algorithm',
'HRAFNKELL',
'6'
],
[
'Net::SSH::Perl',
'b',
'd',
'p',
'O',
'p',
'Perl client Interface to SSH',
'DROLSKY',
'5'
],
[
'Tk::ObjEditor',
'R',
'd',
'p',
'O',
'?',
'Tk widget to edit data or objects',
'DDUMONT',
'8'
],
[
'Tk::ObjEditorDialog',
'R',
'd',
'p',
'O',
'?',
'Tk popup dialog to edit data or objects',
'DDUMONT',
'8'
],
[
'Lingua::Preferred',
'R',
'd',
'p',
'f',
'?',
'Pick a language based on user\'s preferences',
'EDAVIS',
'11'
],
[
'DBD::DtfSQLmac',
'R',
'd',
'p',
'O',
'?',
'dtF/SQL (Mac OS edition) driver for DBI',
'TWEGNER',
'7'
],
[
'Mac::DtfSQL',
'R',
'd',
'c',
'f',
'?',
'Perl interface to the dtF/SQL DB engine',
'TWEGNER',
'4'
],
[
'Embedix::DB',
'b',
'd',
'p',
'O',
'?',
'persistence for ECDs',
'BEPPU',
'23'
],
[
'WWW::Search::FirstGov',
'R',
'd',
'p',
'O',
'?',
'Backend class for searching FirstGov.gov',
'SUTCH',
'15'
],
[
'MP3::Daemon',
'b',
'd',
'p',
'O',
'p',
'A daemon that possesses mpg123',
'BEPPU',
'23'
],
[
'Apache::CVS',
'b',
'd',
'p',
'O',
'?',
'Apache PerlContentHandler for CVS',
'BARBEE',
'15'
],
[
'CGI::FormMagick',
'b',
'm',
'p',
'O',
'p',
'FormMagick',
'MITEL',
'15'
],
[
'Tie::RegexpHash',
'a',
'd',
'p',
'h',
'a',
'Use regular expressions as hash keys',
'RRWO',
'6'
],
[
'Tie::AliasHash',
'R',
'd',
'p',
'r',
'p',
'Hash with key aliases',
'ACALPINI',
'6'
],
[
'Inline::Tcl',
'a',
'd',
'c',
'f',
'?',
'Write Perl subroutines in Tcl',
'RRS',
'2'
],
[
'Math::Polynomial::Solve',
'R',
'd',
'p',
'f',
'p',
'Solve polynomials',
'JGAMBLE',
'6'
],
[
'Digest::UserSID',
'R',
'd',
'p',
'h',
'o',
'Managing session-id\'s with Digest::SHA1',
'XWOLF',
'14'
],
[
'Net::Ping::External',
'b',
'd',
'p',
'f',
'p',
'Cross-platform interface to "ping" utilities',
'COLINM',
'5'
],
[
'Audio::Mixer',
'b',
'd',
'c',
'f',
'?',
'Sound mixer control using ioctl',
'SERGEY',
'23'
],
[
'Crypt::TEA',
'R',
'd',
'c',
'O',
'a',
'Tiny Encryption Algorithm',
'AMS',
'14'
],
[
'Crypt::DSA',
'b',
'd',
'p',
'O',
'p',
'DSA signatures and key generation',
'BTROTT',
'14'
],
[
'Pod::HTML2Pod',
'R',
'd',
'p',
'O',
'p',
'Translate HTML into POD',
'SBURKE',
'26'
],
[
'Math::BigIntFast',
'R',
'd',
'c',
'O',
'p',
'Efficient big integer arithmetic (in C)',
'STBEY',
'6'
],
[
'Oracle::OCI',
'b',
'm',
'c',
'r',
'?',
'Raw interface to the Oracle OCI API',
'TIMB',
'7'
],
[
'Alzabo',
'R',
'd',
'p',
'O',
'p',
'A data modelling tool and RDBMS-OO mapper',
'DROLSKY',
'7'
],
[
'Benchmark::Timer',
'R',
'd',
'p',
'O',
'?',
'Perl code benchmarking tool',
'DCOPPIT',
'3'
],
[
'XML::Excel',
'R',
'm',
'p',
'O',
'a',
'Transform Excel spreadsheet data into XML',
'ISTERIN',
'11'
],
[
'Math::MatrixReal::Ext1',
'R',
'd',
'p',
'O',
'?',
'Convenience extensions for Math::MatrixReal',
'MSOUTH',
'6'
],
[
'Blatte',
'b',
'd',
'p',
'h',
'?',
'Utilities for Blatte language interpreters',
'BOBG',
'9'
],
[
'Blatte::Builtins',
'b',
'd',
'p',
'h',
'?',
'Blatte language standard intrinsics',
'BOBG',
'9'
],
[
'Blatte::Compiler',
'b',
'd',
'p',
'h',
'?',
'Convenient interface for compiling Blatte',
'BOBG',
'9'
],
[
'Blatte::Parser',
'b',
'd',
'p',
'h',
'?',
'Blatte language parser',
'BOBG',
'9'
],
[
'Blatte::Syntax',
'b',
'd',
'p',
'h',
'?',
'Internal Blatte parse-tree objects',
'BOBG',
'9'
],
[
'Blatte::Ws',
'b',
'd',
'p',
'h',
'?',
'Internal Blatte whitespace handler',
'BOBG',
'9'
],
[
'Blatte::HTML',
'b',
'd',
'p',
'h',
'?',
'Intrinsics for writing HTML in Blatte',
'BOBG',
'9'
],
[
'Cache::Cache',
'R',
'd',
'p',
'O',
'p',
'Generic cache interface and implementations',
'DCLINTON',
'17'
],
[
'HTTP::QuickBase',
'R',
'd',
'p',
'O',
'?',
'Wraps the QuickBase HTTP API',
'CVONROES',
'15'
],
[
'Gemstone',
'R',
'd',
'p',
'O',
'?',
'Interface to a GemStone object database',
'YOUD',
'7'
],
[
'FameHLI',
'b',
'd',
'c',
'f',
'g',
'Ports Fame\'s C-API to Perl',
'DAVEO',
'7'
],
[
'Net::ICal',
'a',
'm',
'p',
'O',
'p',
'RFC2445 (iCalendar) protocol tools',
'SRL',
'5'
],
[
'SystemC::Netlist',
'R',
'd',
'p',
'O',
'p',
'Build and lint netlist structures, AUTOs',
'WSNYDER',
'9'
],
[
'SystemC::Parser',
'R',
'd',
'p',
'O',
'p',
'Parse SystemC files',
'WSNYDER',
'9'
],
[
'Net::ITIP',
'c',
'm',
'p',
'O',
'?',
'RFC2446 tools for scheduling events',
'SRL',
'5'
],
[
'Net::IMIP',
'i',
'm',
'p',
'O',
'?',
'RFC2447 tools for event scheduling',
'SRL',
'5'
],
[
'Reefknot::Server',
'i',
'm',
'p',
'O',
'?',
'RFC2445 calendar server',
'SRL',
'16'
],
[
'Reefknot::Client',
'i',
'm',
'p',
'O',
'?',
'RFC2445 calendar client',
'SRL',
'16'
],
[
'Astro::SkyCat',
'c',
'd',
'+',
'O',
'p',
'Interface to ESO SkyCat library',
'TJENNESS',
'23'
],
[
'Carp::Datum',
'a',
'd',
'p',
'f',
'a',
'Debugging And Tracing Ultimate Module',
'SQUIRREL',
'3'
],
[
'CGI::Test',
'a',
'd',
'p',
'O',
'a',
'Off-line CGI test framework',
'MSHILTONJ',
'15'
],
[
'Crypt::NULL',
'R',
'd',
'p',
'O',
'a',
'NULL Encryption Algorithm',
'AMS',
'14'
],
[
'Set::Crontab',
'R',
'd',
'p',
'O',
'a',
'Expand crontab(5)-style integer lists',
'AMS',
'6'
],
[
'SystemC::Vregs',
'R',
'd',
'p',
'O',
'p',
'Build Registers, Classes, Enums from HTML',
'WSNYDER',
'9'
],
[
'Mail::ListDetector',
'b',
'd',
'p',
'O',
'?',
'Mailing list message detector',
'MSTEVENS',
'19'
],
[
'Crypt::OpenSSL::RSA',
'R',
'd',
'c',
'O',
'p',
'Interface to OpenSSL RSA methods',
'IROBERTS',
'14'
],
[
'Netscape::Bookmarks',
'b',
'd',
'p',
'?',
'?',
'Netscape bookmarks',
'BDFOY',
'15'
],
[
'Pod::DocBook',
'a',
'd',
'p',
'O',
'?',
'convert POD to and from DocBook',
'MBERENDS',
'26'
],
[
'Net::ParseWhois',
'R',
'm',
'p',
'O',
'?',
'Get+Parse "whois" domain data',
'ABEROHAM',
'5'
],
[
'WWW::Search::Ebay',
'R',
'd',
'p',
'O',
'p',
'search auctions on www.ebay.com',
'MTHURN',
'15'
],
[
'WWW::Search::Excite',
'R',
'd',
'p',
'O',
'?',
'search on www.excite.com',
'MTHURN',
'15'
],
[
'WWW::Search::HotBot',
'R',
'd',
'p',
'O',
'?',
'search on www.hotbot.com',
'MTHURN',
'15'
],
[
'WWW::Search::Lycos',
'R',
'd',
'p',
'O',
'?',
'search on www.lycos.com',
'MTHURN',
'15'
],
[
'WWW::Search::Magellan',
'R',
'd',
'p',
'O',
'?',
'search on Magellan',
'MTHURN',
'15'
],
[
'WWW::Search::Yahoo',
'R',
'd',
'p',
'O',
'?',
'search various flavors of www.yahoo.com',
'MTHURN',
'15'
],
[
'Language::ML',
'c',
'd',
'p',
'f',
'?',
'Implementation of ML',
'DSPARLING',
'9'
],
[
'File::VirtualPath',
'R',
'd',
'p',
'O',
'p',
'Portable abstraction of a file/dir/url path',
'DUNCAND',
'10'
],
[
'Syntax::Highlight::Perl',
'R',
'd',
'p',
'h',
'p',
'Perform syntax highlighting of Perl code',
'JOHNSCA',
'11'
],
[
'PostScript::PrinterFontMetrics',
'b',
'd',
'p',
'O',
'?',
'Get font metrics from .PFM files',
'JV',
'11'
],
[
'PostScript::BasicTypesetter',
'a',
'd',
'p',
'O',
'?',
'Basic typesetting functions',
'JV',
'11'
],
[
'PostScript::PseudoISO',
'R',
'd',
'p',
'O',
'?',
'Typesetting supprort',
'JV',
'11'
],
[
'PostScript::ISOLatin1Encoding',
'R',
'd',
'p',
'O',
'?',
'ISO Latin1 Encoding vector',
'JV',
'11'
],
[
'PostScript::StandardEncoding',
'R',
'd',
'p',
'f',
'?',
'Adobe Standard Encoding vector',
'JV',
'11'
],
[
'Crypt::DH',
'b',
'd',
'p',
'O',
'p',
'Diffie-Hellman key exchange system',
'BTROTT',
'14'
],
[
'Crypt::PassGen',
'a',
'd',
'p',
'f',
'p',
'Generate pronouncable passwords',
'TJENNESS',
'14'
],
[
'Finance::Streamer',
'a',
'd',
'p',
'O',
'p',
'interface to Datek Streamer',
'JERI',
'23'
],
[
'Data::Buffer',
'b',
'd',
'p',
'O',
'p',
'Read/write buffer class',
'BTROTT',
'6'
],
[
'Mail::PerlTix',
'c',
'm',
'p',
'O',
'?',
'Mail ticketing and transaction system',
'JJARVINEN',
'19'
],
[
'Win32::DriveInfo',
'R',
'd',
'p',
'f',
'?',
'drives on Win32 systems',
'MBLAZ',
'22'
],
[
'Text::xSV',
'b',
'd',
'p',
'O',
'?',
'Read CSV files, handling embedded returns',
'TILLY',
'11'
],
[
'Math::Fleximal',
'a',
'd',
'p',
'O',
'?',
'Arithmetic with any base representation',
'TILLY',
'6'
],
[
'POE::Component::Client::FTP',
'a',
'd',
'p',
'O',
'p',
'POE FTP client',
'MCHING',
'5'
],
[
'Crypt::OpenSSL::Random',
'b',
'd',
'c',
'O',
'p',
'Interface to OpenSSL PRNG methods',
'IROBERTS',
'14'
],
[
'Crypt::OpenSSL::BN',
'b',
'd',
'c',
'O',
'p',
'Interface to OpenSSL arithmetic',
'IROBERTS',
'14'
],
[
'NEXT',
'R',
'd',
'p',
'O',
'?',
'Perl5 implementation of NEXT (RFC190)',
'DCONWAY',
'2'
],
[
'Net::Server',
'b',
'd',
'p',
'O',
'p',
'Extensible (class) oriented internet server',
'RHANDOM',
'5'
],
[
'BabelObjects',
'c',
'd',
'p',
'f',
'?',
'Web Service Framework',
'KERMAGO',
'6'
],
[
'Class::Handler',
'b',
'd',
'p',
'O',
'?',
'Make Apache-like pseudoclass event handlers',
'NWIGER',
'6'
],
[
'Unix::Login',
'b',
'd',
'p',
'h',
'?',
'Customizable Unix login prompt / validation',
'NWIGER',
'4'
],
[
'Text::Header',
'b',
'd',
'p',
'f',
'?',
'Content-independent RFC 822 header functions',
'NWIGER',
'11'
],
[
'HTML::ActiveLink',
'b',
'd',
'p',
'O',
'?',
'Dynamically activate HTML links based on URL',
'NWIGER',
'15'
],
[
'DBIx::XMLMEssage',
'b',
'd',
'p',
'O',
'p',
'Exchange of XML messages between DBI sources',
'ANDREIN',
'7'
],
[
'P4::Client',
'R',
'd',
'+',
'O',
'b',
'Client interface to the Perforce SCM system',
'SMEE',
'24'
],
[
'Net::DHCP::Watch',
'b',
'd',
'p',
'O',
'p',
'A class for monitoring a remote DHCPD server',
'EJDRS',
'5'
],
[
'DBIx::Browse',
'b',
'd',
'p',
'O',
'g',
'A class to browse related tables via CGI/Web',
'EJDRS',
'7'
],
[
'Data::Lazy',
'R',
'd',
'p',
'r',
'p',
'provides "lazy" scalars, arrays and hashes',
'JENDA',
'6'
],
[
'Text::BarGraph',
'R',
'd',
'p',
'O',
'p',
'Generate text bar graph from data in a hash',
'KBAUCOM',
'11'
],
[
'Net::Peep',
'R',
'd',
'p',
'O',
'?',
'Clients for Peep: The Network Auralizer',
'STARKY',
'5'
],
[
'Digest::BubbleBabble',
'b',
'd',
'p',
'f',
'p',
'Create bubble-babble fingerprints',
'BTROTT',
'14'
],
[
'CGI::Portable',
'b',
'd',
'p',
'O',
'p',
'Framework for server-generic web apps',
'DUNCAND',
'15'
],
[
'Crypt::GOST',
'b',
'd',
'p',
'O',
'?',
'GOST encryption algorithm',
'AMS',
'14'
],
[
'Conjury::C',
'R',
'd',
'p',
'h',
'?',
'Generic software construction toolset',
'JWOODYATT',
'3'
],
[
'Conjury::Core',
'R',
'd',
'p',
'h',
'?',
'Generic software construction toolset',
'JWOODYATT',
'3'
],
[
'Conjury::Stage',
'R',
'd',
'p',
'h',
'?',
'Generic software construction toolset',
'JWOODYATT',
'3'
],
[
'Text::EtText',
'R',
'm',
'p',
'O',
'?',
'editable-text format for HTML output',
'JMASON',
'11'
],
[
'DBIx::XHTML_Table',
'M',
'd',
'p',
'O',
'p',
'SQL query result set to XML-based HTML table',
'JEFFA',
'7'
],
[
'Convert::Base',
'a',
'd',
'p',
'h',
'?',
'Convert integers to/from arbitrary bases.',
'VIPUL',
'17'
],
[
'Bleach',
'R',
'd',
'p',
'O',
'?',
'For really clean programs',
'DCONWAY',
'3'
],
[
'Filter::Simple',
'R',
'd',
'p',
'O',
'?',
'Simplified source filtering',
'DCONWAY',
'2'
],
[
'Lingua::Romana::Perligata',
'R',
'd',
'p',
'O',
'?',
'Perl in Latin',
'DCONWAY',
'11'
],
[
'Attribute::Handlers',
'R',
'd',
'p',
'O',
'?',
'Simpler definition of attribute handlers',
'ABERGMAN',
'2'
],
[
'Regexp::Common',
'R',
'd',
'p',
'O',
'?',
'Provide commonly requested regular expr.',
'ABIGAIL',
'2'
],
[
'Regexp::Shellish',
'R',
'd',
'p',
'O',
'?',
'Shell-like regular expressions',
'RBS',
'2'
],
[
'Tk::Pgplot',
'b',
'd',
'c',
'f',
'p',
'Pgplot widget for Tk',
'CPHIL',
'8'
],
[
'Data::Denter',
'R',
'd',
'p',
'O',
'?',
'An alternative to Data::Dumper and Storable.',
'INGY',
'6'
],
[
'Tk::PathEntry',
'a',
'd',
'p',
'O',
'p',
'Entry for selecting paths with completion',
'SREZIC',
'8'
],
[
'SNMP::NPAdmin',
'a',
'd',
'p',
'O',
'?',
'Perl API to query printers via SNMP.',
'BOZZIO',
'5'
],
[
'Devel::Cover',
'a',
'd',
'c',
'h',
'p',
'Code coverage metrics for Perl',
'PJCJ',
'3'
],
[
'Class::Loader',
'b',
'd',
'p',
'O',
'?',
'Load modules & construct objects on demand.',
'VIPUL',
'6'
],
[
'Net::Hesiod',
'b',
'd',
'c',
'h',
'p',
'Interface to Hesiod library API',
'PAYERLE',
'5'
],
[
'Class::Date',
'R',
'd',
'h',
'O',
'p',
'A full-featured date and time class for perl',
'DLUX',
'6'
],
[
'Net::SMPP',
'R',
'd',
'p',
'O',
'p',
'Protocol for sending SMS (to GSM or CDMA).',
'SAMPO',
'5'
],
[
'DBIx::SchemaView',
'a',
'd',
'p',
'f',
'?',
'Retrieving and drawing of DB schema (Tk)',
'MILSO',
'7'
],
[
'DBIx::SystemCatalog',
'R',
'd',
'p',
'O',
'?',
'Accessing system catalog in common databases',
'MILSO',
'7'
],
[
'DBIx::dbMan',
'M',
'd',
'p',
'O',
'p',
'SQL database manipulating tool (also curses)',
'MILSO',
'7'
],
[
'Hints',
'R',
'd',
'p',
'O',
'p',
'Tools for access hints databases (tips)',
'MILSO',
'23'
],
[
'Math::Project',
'R',
'd',
'p',
'O',
'p',
'Compute intersection with upright line',
'MILSO',
'6'
],
[
'Net::DHCPClient',
'b',
'd',
'p',
'O',
'p',
'Interface to DHCP as a client',
'JWALGENB',
'5'
],
[
'DBI::Format',
'b',
'm',
'p',
'O',
'?',
'Defined display formats for data from DBI',
'TLOWERY',
'7'
],
[
'DBD::ADO',
'b',
'm',
'p',
'O',
'p',
'Database interface modules of MS ADO for DBI',
'SGOELDNER',
'7'
],
[
'Convert::PEM',
'b',
'd',
'p',
'O',
'p',
'Read/write encrypted ASN.1 PEM files',
'BTROTT',
'17'
],
[
'Language::DATR::DATR2XML',
'b',
'd',
'p',
'O',
'p',
'Convert DATR to XML and back, wth XSLT & DTD',
'LGODDARD',
'9'
],
[
'HTML::Lint',
'R',
'd',
'p',
'O',
'p',
'HTML validation module (& script)',
'PETDANCE',
'15'
],
[
'DB_File::DB_Database',
'R',
'd',
'p',
'O',
'n',
'DB_File to MultiField Table with Index',
'RANN',
'7'
],
[
'IO::Default',
'R',
'd',
'p',
'O',
'?',
'Replace select() with $DEFOUT, $DEFERR, $DEF',
'NWIGER',
'21'
],
[
'Time::Unix',
'R',
'd',
'p',
'O',
'?',
'Force time() to return secs since UNIX epoch',
'NWIGER',
'6'
],
[
'Regexp::Func',
'a',
'd',
'p',
'f',
'?',
'Replace =~, !~, m//, s/// with functions',
'NWIGER',
'2'
],
[
'Tie::WarnGlobal',
'a',
'd',
'p',
'r',
'?',
'Ties variables to functions, warns on use',
'STEPHEN',
'6'
],
[
'VMS::Mail',
'c',
'd',
'c',
'O',
'?',
'Perl module for accessing callable VMS mail',
'DNORTH',
'4'
],
[
'Class::ArrayObjects',
'R',
'd',
'p',
'h',
'p',
'Utility class for array based objects',
'RONAN',
'6'
],
[
'ReleaseAction',
'b',
'd',
'p',
'h',
'?',
'Trigger actions on destruction of a handle',
'TILLY',
'20'
],
[
'DBD::Excel',
'a',
'd',
'p',
'O',
'p',
'Excel database driver for the DBI module',
'KWITKNR',
'7'
],
[
'Time::TAI64',
'R',
'd',
'p',
'f',
'p',
'Time manipulation in the TAI64* formats',
'JOVAL',
'6'
],
[
'XMLI',
'b',
'd',
'p',
'O',
'a',
'Encapsulates XML drivers',
'ISTERIN',
'11'
],
[
'CSS::SAC',
'b',
'm',
'p',
'O',
'p',
'Perl implementation of the Simple API to CSS',
'BJOERN',
'11'
],
[
'Whitespace',
'M',
'd',
'p',
'O',
'p',
'Detect and cleanup bogus whitespace in files',
'RVAIDH',
'11'
],
[
'Algorithm::LUHN',
'R',
'd',
'p',
'f',
'?',
'Calculate mod 10 Double Add Double checksum',
'TAYERS',
'6'
],
[
'AudioCD',
'b',
'd',
'p',
'O',
'?',
'Extension for controlling Audio CDs',
'SDERLE',
'4'
],
[
'AudioCD::Mac',
'b',
'd',
'c',
'O',
'?',
'Extension for controlling Audio CDs on MacOS',
'AJFRY',
'4'
],
[
'AI::NeuralNet::SOM',
'a',
'd',
'p',
'O',
'p',
'Kohonen Self-Organizing Maps',
'VOISCHEV',
'23'
],
[
'FUSE::Server',
'R',
'm',
'p',
'O',
'p',
'Custom FUSE server creation',
'IAMCAL',
'16'
],
[
'Cmenu',
'b',
'd',
'p',
'f',
'g',
'Curses-based menu and data entry functions',
'DREWF',
'8'
],
[
'PDF',
'R',
'd',
'p',
'O',
'?',
'PDF access and manipulation in Perl',
'ANTRO',
'11'
],
[
'PDF::Core',
'R',
'd',
'p',
'O',
'?',
'Core Library for PDF library',
'ANTRO',
'11'
],
[
'PDF::Parse',
'R',
'd',
'p',
'O',
'?',
'parsing functions for PDF library',
'ANTRO',
'11'
],
[
'PDF::Create',
'R',
'm',
'p',
'O',
'd',
'Create PDF files',
'FTASSIN',
'11'
],
[
'PDF::Labels',
'R',
'd',
'p',
'O',
'p',
'Produce sheets of mailing labels in PDF',
'OWEN',
'11'
],
[
'Apache::Motd',
'R',
'd',
'p',
'h',
'p',
'Add motd functionality to Apache webserver',
'CRAMIREZ',
'15'
],
[
'Language::VBParser',
'a',
'd',
'p',
'?',
'g',
'Visual Basic 6 source parser',
'FRETT',
'11'
],
[
'Proc::Queue',
'M',
'd',
'p',
'f',
'p',
'limits number of concurrent forked processes',
'SALVA',
'4'
],
[
'ex::caution',
'b',
'd',
'p',
'n',
'?',
'Same as use warnings; use strict;',
'YVES',
'2'
],
[
'Win32::MultiMedia::Mci',
'c',
'd',
'c',
'h',
'?',
'An interface for the MCI system on Win32',
'THAMUS',
'22'
],
[
'Win32::MultiMedia::Joystick',
'c',
'd',
'c',
'h',
'?',
'An interface for game controllers on Win32',
'THAMUS',
'22'
],
[
'Data::Compare',
'R',
'd',
'p',
'O',
'?',
'Compare perl data structures',
'FTASSIN',
'6'
],
[
'Data::HexDump',
'R',
'd',
'p',
'O',
'?',
'Hexadecial Dumper',
'FTASSIN',
'6'
],
[
'Data::Hexdumper',
'R',
'd',
'p',
'f',
'a',
'Display binary data in multiple formats',
'DCANTRELL',
'6'
],
[
'Filesys::DiskSpace',
'R',
'd',
'p',
'O',
'?',
'Perl df (requires h2ph)',
'FTASSIN',
'10'
],
[
'Pod::Tree',
'R',
'd',
'p',
'O',
'p',
'Create a static syntax tree for a POD',
'SWMCD',
'26'
],
[
'Image::DeAnim',
'R',
'd',
'p',
'O',
'?',
'Create static GIF file from animated GIF',
'KENMACF',
'18'
],
[
'UDDI',
'R',
'd',
'p',
'O',
'?',
'UDDI client interface',
'GAAS',
'15'
],
[
'IO::String',
'R',
'd',
'p',
'O',
'?',
'IO::File interface for in-core strings',
'GAAS',
'21'
],
[
'IO::Stringy',
'R',
'd',
'p',
'O',
'?',
'I/O on in-core objects like strings/arrays',
'DSKOLL',
'21'
],
[
'Authen::PIN',
'R',
'd',
'p',
'O',
'p',
'Create and verify strong PIN numbers',
'LUISMUNOZ',
'14'
],
[
'Number::Encode',
'R',
'd',
'p',
'O',
'p',
'Encode bit strings into digit strings',
'LUISMUNOZ',
'11'
],
[
'Net::SFTP',
'b',
'd',
'p',
'O',
'p',
'Secure File Transfer Protocol client',
'DROLSKY',
'5'
],
[
'Poetry::Vogon',
'i',
'd',
'p',
'O',
'a',
'Vogon Poetry Generator',
'AMS',
'23'
],
[
'FUSE::Client',
'R',
'm',
'p',
'O',
'p',
'Custom FUSE client creation',
'IAMCAL',
'16'
],
[
'Data::Stash',
'b',
'd',
'p',
'f',
'?',
'Data structures in simple text format',
'HRANICKY',
'6'
],
[
'Prima',
'R',
'm',
'c',
'h',
'b',
'A perl GUI toolkit',
'KARASIK',
'8'
],
[
'Net::LMTP',
'R',
'd',
'p',
'O',
'p',
'LMTP Protocol - RFC2033',
'LHOWARD',
'5'
],
[
'YAML',
'a',
'd',
'p',
'h',
'p',
'YAML Ain\'t Markup Language (tm)',
'INGY',
'6'
],
[
'Workflow',
'b',
'd',
'p',
'O',
'p',
'Simple pure-Perl embeddable workflow',
'JONASBN',
'23'
],
[
'Win32::Process::Info',
'R',
'd',
'p',
'O',
'p',
'Get Win32 process information',
'WYANT',
'22'
],
[
'PerlPoint::Package',
'M',
'm',
'p',
'O',
'a',
'Presentation slide / doc generator framework',
'JSTENZEL',
'11'
],
[
'Business::FedEx::DirectConnect',
'R',
'd',
'p',
'O',
'l',
'Interface to FedEx Ship Manager Direct',
'JPOWERS',
'23'
],
[
'Audio::OSS',
'R',
'd',
'c',
'f',
'?',
'Interface to Open Sound System audio devices',
'DJHD',
'23'
],
[
'Festival::Client::Async',
'R',
'd',
'p',
'O',
'?',
'Festival client blocking or non-blocking',
'DJHD',
'23'
],
[
'Speech::Recognizer::SPX',
'R',
'd',
'c',
'h',
'?',
'Interface to Sphinx-II speech recognition',
'DJHD',
'23'
],
[
'Festival::Client',
'R',
'd',
'p',
'O',
'?',
'Communicate with a Festival server',
'GOSSAMER',
'23'
],
[
'Speech::Festival',
'R',
'd',
'p',
'O',
'?',
'Communicate with a festival server process.',
'RCALEY',
'23'
],
[
'Speech::Festival::Synthesiser',
'R',
'd',
'p',
'O',
'?',
'Simple text-to-speech using festival.',
'RCALEY',
'23'
],
[
'Locale::Currency',
'R',
'd',
'p',
'f',
'?',
'ISO 4217 codes for currencies and funds',
'NEILB',
'13'
],
[
'Graph',
'R',
'd',
'p',
'O',
'?',
'Data structure and ops for directed graphs',
'JHI',
'6'
],
[
'Graph::Reader',
'R',
'd',
'p',
'O',
'?',
'Base class for graph file format reader',
'NEILB',
'6'
],
[
'Graph::Writer',
'R',
'd',
'p',
'O',
'?',
'Base class for graph file format writer',
'NEILB',
'6'
],
[
'Graph::Reader::XML',
'R',
'd',
'p',
'O',
'?',
'Read a Graph from simple XML format',
'NEILB',
'6'
],
[
'Graph::Writer::XML',
'R',
'd',
'p',
'O',
'?',
'Write a Graph in a simple XML format',
'NEILB',
'6'
],
[
'Graph::Writer::Dot',
'R',
'd',
'p',
'O',
'?',
'Write a Graph in file format used by Dot',
'NEILB',
'6'
],
[
'Graph::Writer::VCG',
'R',
'd',
'p',
'O',
'?',
'Write a Graph in file format used by VCG',
'NEILB',
'6'
],
[
'Graph::Writer::daVinci',
'c',
'd',
'p',
'O',
'?',
'Write a Graph in file format used by daVinci',
'NEILB',
'6'
],
[
'Pod::Checker',
'R',
'd',
'p',
'O',
'?',
'Check pod documents for syntax errors',
'BRADAPP',
'26'
],
[
'AppConfig',
'M',
'd',
'p',
'O',
'?',
'Application config (from ARGV, file, ...)',
'ABW',
'12'
],
[
'AppConfig::Std',
'R',
'd',
'p',
'O',
'?',
'Provides standard configuration options',
'NEILB',
'12'
],
[
'Smirch',
'R',
'd',
'p',
'f',
'a',
'For really dirty programs',
'JNAGRA',
'3'
],
[
'SNMP::BridgeQuery',
'b',
'd',
'p',
'f',
'p',
'Query bridge/switch for forwarding database',
'JSHEARER',
'5'
],
[
'Attribute::Types',
'R',
'd',
'p',
'O',
'?',
'Attributes that confer type on variables',
'DCONWAY',
'2'
],
[
'Perl6::Variables',
'R',
'd',
'p',
'O',
'?',
'Perl 6 variable syntax for Perl 5',
'DCONWAY',
'28'
],
[
'Tie::DxHash',
'R',
'd',
'p',
'r',
'p',
'Keeps insertion order; allows duplicate keys',
'KRUSCOE',
'6'
],
[
'Attribute::Memoize',
'R',
'd',
'p',
'O',
'p',
'Attribute interface to Memoize.pm',
'MARCEL',
'2'
],
[
'Attribute::TieClasses',
'R',
'd',
'p',
'O',
'p',
'attribute wrappers for CPAN Tie classes',
'MARCEL',
'2'
],
[
'DBIx::Lookup::Field',
'R',
'd',
'p',
'f',
'p',
'Create a lookup hash from a database table',
'MARCEL',
'7'
],
[
'Attribute::Abstract',
'R',
'd',
'p',
'O',
'p',
'implement abstract methods with attributes',
'MARCEL',
'2'
],
[
'Devel::SearchINC',
'R',
'd',
'p',
'n',
'p',
'loading Perl modules from development dirs',
'MARCEL',
'3'
],
[
'Net::SSH',
'R',
'd',
'p',
'h',
'p',
'Perl extension for secure shell',
'IVAN',
'5'
],
[
'Net::SCP',
'R',
'd',
'p',
'h',
'p',
'Perl extension for secure copy protocol',
'IVAN',
'5'
],
[
'Silly::Werder',
'R',
'd',
'p',
'O',
'g',
'Meaningless gibberish generator',
'CXREG',
'11'
],
[
'Term::Interact',
'b',
'd',
'p',
'O',
'p',
'Get Data Interactively From User',
'PRL',
'8'
],
[
'Parse::Lexer',
'a',
'd',
'p',
'O',
'a',
'Conventional generator of lexical analyzers',
'EKMETT',
'11'
],
[
'Language::Style',
'c',
'd',
'c',
'O',
'a',
'Interpreter/Compiler for the Style Language',
'EKMETT',
'9'
],
[
'Chart::Pie3d',
'a',
'd',
'p',
'O',
'?',
'3d Pie Chart Render',
'EKMETT',
'18'
],
[
'Tk::JComboBox',
'M',
'u',
'p',
'O',
'p',
'Combo Box (similar to java class)',
'RCSEEGE',
'8'
],
[
'GISI',
'a',
'm',
'p',
'O',
'?',
'Geographic Information Systems Interface',
'SORO',
'23'
],
[
'GISI::SHAPE',
'a',
'm',
'c',
'O',
'?',
'ArcView SHAPE file format driver',
'SORO',
'23'
],
[
'GISI::MIFMID',
'a',
'm',
'p',
'O',
'?',
'MapInfo MIFMID file format driver',
'SORO',
'23'
],
[
'Splash::DB',
'?',
'?',
'?',
'?',
'?',
'?',
'BEN',
'7'
],
[
'Apache::DnsZone',
'b',
'd',
'p',
'n',
'a',
'Webbased dns-zone manager for BIND',
'THOMAS',
'15'
],
[
'Log::Detect',
'R',
'd',
'p',
'O',
'a',
'Detect and show error regexps in logfiles',
'WSNYDER',
'21'
],
[
'Log::Delayed',
'R',
'd',
'p',
'O',
'a',
'Delay error exits until multiple errors seen',
'WSNYDER',
'21'
],
[
'Math::Random::MT',
'R',
'd',
'c',
'h',
'a',
'The Mersenne Twister PRNG',
'AMS',
'6'
],
[
'Chart::GRACE',
'R',
'd',
'p',
'h',
'p',
'Interface to GRACE plotting package',
'TJENNESS',
'18'
],
[
'XML::GXML',
'M',
'd',
'p',
'O',
'p',
'XML transformation and XML->HTML conv.',
'JCARTER',
'11'
],
[
'Net::DNSServer',
'c',
'n',
'p',
'O',
'a',
'Secure and Extensible Name Server',
'BBB',
'5'
],
[
'Convert::ASCII::Armor',
'R',
'd',
'p',
'O',
'?',
'Convert binary octets to ASCII armoured msg.',
'VIPUL',
'17'
],
[
'HTTP::Webdav',
'a',
'm',
'h',
'O',
'p',
'Interface to Neon HTTP and WebDAV library',
'GRICHTER',
'15'
],
[
'Term::VT102',
'b',
'd',
'p',
'O',
'a',
'Emulates a colour VT102 terminal in memory',
'AJWOOD',
'8'
],
[
'Image::IPTCInfo',
'R',
'd',
'p',
'O',
'p',
'Extracts IPTC meta-info from images',
'JCARTER',
'18'
],
[
'Imager',
'R',
'm',
'h',
'O',
'p',
'Draws, reads and writes Imagefiles',
'ADDI',
'18'
],
[
'XML::SAXDriver::CSV',
'R',
'm',
'p',
'O',
'p',
'complements XML::CSV, SAX interface',
'ISTERIN',
'11'
],
[
'XML::SAXDriver::Excel',
'R',
'd',
'p',
'O',
'?',
'complements XML::Excel, SAX interface',
'ISTERIN',
'11'
],
[
'File::NFSLock',
'b',
'd',
'p',
'O',
'p',
'NFS compatible (safe) locking utility',
'BBB',
'10'
],
[
'Crypt::Schnorr::AuthSign',
'b',
'd',
'p',
'O',
'p',
'Schnorr Authentication & Signature Protocols',
'AGUL',
'14'
],
[
'Tie::StrictHash',
'R',
'd',
'p',
'O',
'p',
'A hash with strict-like semantics',
'KVAIL',
'6'
],
[
'Replication::Recall::Client',
'a',
'd',
'h',
'f',
'o',
'Recall replication library client interface',
'AGUL',
'5'
],
[
'Replication::Recall::Server',
'a',
'd',
'h',
'f',
'o',
'Recall replication library server interface',
'AGUL',
'5'
],
[
'DBD::Recall',
'a',
'd',
'p',
'O',
'p',
'Transparent database replication layer',
'AGUL',
'7'
],
[
'Replication::Recall::DBServer',
'a',
'd',
'p',
'O',
'p',
'Database replication server using Recall',
'AGUL',
'7'
],
[
'Date::ISO',
'R',
'd',
'p',
'f',
'p',
'Calculate dates in the ISO calendar',
'RBOW',
'6'
],
[
'Date::Discordian',
'R',
'd',
'p',
'f',
'p',
'Calculate dates in the Discordian calendar',
'RBOW',
'6'
],
[
'Date::DayOfWeek',
'R',
'd',
'p',
'f',
'p',
'Calculate day of week for Gregorian dates',
'RBOW',
'6'
],
[
'Date::Easter',
'R',
'd',
'p',
'f',
'p',
'Calculate the date of Easter',
'RBOW',
'6'
],
[
'Date::ICal',
'b',
'd',
'p',
'O',
'p',
'Class for ICal date objects',
'RBOW',
'6'
],
[
'Astro::FITS::Header',
'M',
'd',
'p',
'O',
'g',
'interface to FITS headers',
'AALLAN',
'23'
],
[
'Inline::Java',
'R',
'm',
'h',
'p',
'p',
'Easy implementation of Java extensions',
'PATL',
'2'
],
[
'Text::Quickwrap',
'c',
'd',
'c',
'f',
'?',
'Width limiting fast text wrapper',
'IVANPAN',
'11'
],
[
'Guile',
'a',
'd',
'h',
'h',
'p',
'Perl interface to the Guile interpreter.',
'SAMTREGAR',
'9'
],
[
'File::CacheDir',
'M',
'd',
'p',
'O',
'p',
'auto ttl-based file cleanup without a cron',
'EARL',
'10'
],
[
'Device::ParallelPort',
'R',
'd',
'p',
'O',
'p',
'Low Level access to Parallel Port on all OS',
'SCOTT',
'4'
],
[
'Inline::ASM',
'a',
'd',
'p',
'O',
'?',
'Write Perl subroutines in Assembler',
'NEILW',
'2'
],
[
'Inline::Struct',
'a',
'd',
'p',
'O',
'?',
'Bind C structures directly to Perl.',
'NEILW',
'2'
],
[
'XML::Comma',
'R',
'm',
'p',
'O',
'g',
'Toolkit for managing large "doc" collections',
'KWINDLA',
'11'
],
[
'Sybase::Xfer',
'R',
'd',
'p',
'O',
'?',
'Transfer data between sybase servers',
'SPRAGST',
'7'
],
[
'Embedix::ECD',
'b',
'd',
'p',
'O',
'?',
'represent ECD files as perl objects',
'BEPPU',
'23'
],
[
'DBD::Sprite',
'R',
'd',
'p',
'O',
'?',
'Sprite driver',
'TURNERJW',
'7'
],
[
'Math::VectorReal',
'R',
'd',
'p',
'O',
'p',
'Handling 3D Vector Mathematics',
'ANTHONY',
'6'
],
[
'Tk::Workspace',
'R',
'd',
'p',
'O',
'?',
'Persistent Text/Shell/Command Widgets',
'RKIES',
'8'
],
[
'Tie::GHash',
'a',
'd',
'c',
'f',
'p',
'A smaller hash; interface to Gnome glib hash',
'LBROCARD',
'6'
],
[
'File::Repl',
'b',
'd',
'p',
'O',
'p',
'file/dir structure replication',
'DROBERTS',
'10'
],
[
'HTML::Bricks',
'b',
'm',
'p',
'O',
'b',
'Build web sites without writing code or HTML',
'PETERMCD',
'15'
],
[
'Text::Scan',
'b',
'd',
'c',
'O',
'p',
'Fast text search for large number of keys',
'IWOODHEAD',
'11'
],
[
'Concurrent',
'a',
'd',
'p',
'O',
'p',
'Concurrent and Remotable Objects in Perl',
'VIPUL',
'2'
],
[
'Attribute::Overload',
'R',
'd',
'p',
'O',
'p',
'Attribute that makes overloading easier',
'MARCEL',
'2'
],
[
'Tasks',
'b',
'd',
'p',
'O',
'g',
'Module for tasks/projects and time tracking',
'SERGEY',
'23'
],
[
'Sparky',
'b',
'd',
'p',
'f',
'p',
'support functions for Sparky data collector',
'JLHOLT',
'12'
],
[
'XML::Xerces',
'R',
'm',
'+',
'O',
'o',
'Perl API to Apache Xerces XML Parser',
'JASONS',
'11'
],
[
'XML::GDOME',
'a',
'm',
'c',
'O',
'p',
'Interface to Level 2 DOM gdome library',
'TJMATHER',
'11'
],
[
'Apache::Cookie::Encrypted',
'a',
'd',
'p',
'O',
'p',
'Cookies with value auto encrypted/decrypted',
'JKRASNOO',
'15'
],
[
'CDB_File::BiIndex',
'a',
'u',
'p',
'O',
'l',
'Two directional index based on CDB File',
'MIKEDLR',
'7'
],
[
'Sys::Hostname::Long',
'a',
'd',
'p',
'O',
'p',
'Return the hosts fully qualified name',
'SCOTT',
'4'
],
[
'Lingua::JA::Sort::JIS',
'R',
'd',
'p',
'h',
'p',
'compare and sort Japanese character strings',
'SADAHIRO',
'11'
],
[
'WWW::Link',
'i',
'u',
'p',
'O',
'p',
'Link Testing related modules',
'MIKEDLR',
'15'
],
[
'Tie::TransactHash',
'R',
'u',
'p',
'O',
'g',
'Allows edits on a hash without disturbing it',
'MIKEDLR',
'6'
],
[
'Symbol::Approx::Sub',
'R',
'm',
'p',
'h',
'p',
'Call subroutines using approximate names',
'DAVECROSS',
'2'
],
[
'CDB_File::BiIndex::Generator',
'a',
'u',
'p',
'O',
'l',
'Creates for CDB_File::BiIndexes',
'MIKEDLR',
'7'
],
[
'CDB_File::Generator',
'i',
'u',
'p',
'O',
'g',
'CDB_File::Generator',
'MIKEDLR',
'7'
],
[
'Lingua::KR::Hangul',
'c',
'd',
'p',
'O',
'o',
'Basis function for Hangul character',
'OKLETSGO',
'11'
],
[
'Getopt::GetArgs',
'a',
'd',
'p',
'f',
'p',
'Enhanced argument passing to subroutines',
'BBB',
'12'
],
[
'Date::Handler',
'M',
'd',
'p',
'O',
'p',
'Simple Object oriented Date Handling',
'BBEAUSEJ',
'6'
],
[
'Mail::MboxParser',
'M',
'd',
'p',
'O',
'p',
'Read-only access to UNIX-mailboxes',
'VPARSEVAL',
'19'
],
[
'HTML::Entities::ImodePictogram',
'b',
'd',
'p',
'f',
'p',
'encode / decode i-mode pictogram',
'MIYAGAWA',
'15'
],
[
'IO::Filter',
'a',
'd',
'p',
'O',
'g',
'Generic filters for IO handles.',
'RWMJ',
'21'
],
[
'Date::Japanese::Era',
'a',
'd',
'p',
'O',
'p',
'Year conversion for Japanese Era',
'MIYAGAWA',
'6'
],
[
'Math::Calc::Units',
'b',
'd',
'p',
'f',
'p',
'Unit-aware calculator with readable output',
'SFINK',
'6'
],
[
'WWW::Mail::Hotmail',
'a',
'd',
'p',
'O',
'p',
'Get mail from an HTTPMail server ie. Hotmail',
'HOWARD',
'15'
],
[
'Authen::ACE4',
'R',
'd',
'c',
'O',
'?',
'Perl extension for accessing a SecurID ACE s',
'MIKEM',
'14'
],
[
'Digest::MD4',
'R',
'd',
'c',
'O',
'?',
'Perl interface to the RSA Data Security Inc.',
'MIKEM',
'14'
],
[
'List::Intersperse',
'R',
'd',
'p',
'f',
'?',
'Intersperse / unsort / disperse a list',
'TAYERS',
'6'
],
[
'Lingua::RU::Antimat',
'R',
'd',
'p',
'O',
'p',
'Removes foul language from a Russian string',
'ILYAS',
'11'
],
[
'DBIx::Sequence',
'M',
'd',
'p',
'O',
'p',
'Database independent ID generation',
'BBEAUSEJ',
'7'
],
[
'Cache::Mmap',
'b',
'd',
'h',
'O',
'p',
'Shared data cache using memory mapped files',
'PMH',
'17'
],
[
'Date::Convert::French_Rev',
'a',
'd',
'p',
'O',
'p',
'From/to French Revolutionary Calendar',
'JFORGET',
'6'
],
[
'String::Buffer',
'b',
'd',
'p',
'O',
'p',
'A simple string buffer class.',
'MCKAY',
'11'
],
[
'Date::SundayLetter',
'c',
'd',
'p',
'f',
'p',
'Calculates the Sunday Letters for a given ye',
'RBOW',
'6'
],
[
'Date::Doomsday',
'c',
'd',
'p',
'f',
'p',
'Determine doomsday for a given year',
'RBOW',
'6'
],
[
'Devel::TraceMethods',
'b',
'd',
'p',
'O',
'p',
'Perl module for tracing module calls',
'CHROMATIC',
'3'
],
[
'Getopt::Attribute',
'R',
'd',
'p',
'r',
'p',
'Attribute wrapper for Getopt::Long',
'MARCEL',
'12'
],
[
'C::Include',
'R',
'd',
'p',
'O',
'p',
'Operate C/C++ structs like perl deep struct',
'AMICHAUER',
'9'
],
[
'String::Multibyte',
'R',
'd',
'p',
'O',
'p',
'manipulate multibyte character strings',
'SADAHIRO',
'11'
],
[
'MP3::M3U',
'b',
'd',
'p',
'O',
'g',
'M3u playlist parser',
'ILIAL',
'23'
],
[
'Acme::Buffy',
'R',
'd',
'p',
'h',
'p',
'An encoding scheme for Buffy fans',
'LBROCARD',
'2'
],
[
'AI::Categorize',
'b',
'd',
'p',
'O',
'p',
'Automatically classify documents by content',
'KWILLIAMS',
'23'
],
[
'HTTP::Test',
'i',
'd',
'p',
'O',
'a',
'Web application regression testing framework',
'RAM',
'15'
],
[
'Image::Timeline',
'b',
'd',
'p',
'O',
'p',
'Create GIF or PNG timelines',
'KWILLIAMS',
'18'
],
[
'CGI::MxWidget',
'i',
'd',
'p',
'O',
'a',
'CGI widgets for using with CGI::MxScreen',
'RAM',
'15'
],
[
'ExtUtils::configPL',
'a',
'd',
'p',
'O',
'p',
'configures .PL files',
'PEASE',
'3'
],
[
'Net::OSCAR',
'R',
'm',
'p',
'O',
'p',
'AOL Instant Messenger OSCAR protocol',
'MATTHEWG',
'5'
],
[
'Parse::ABNF',
'c',
'm',
'p',
'O',
'p',
'Augmented Backus-Naur Form (RFC 2234)',
'MATTHEWG',
'11'
],
[
'Crypt::SKey',
'b',
'd',
'p',
'f',
'p',
'Perl S/Key calculator',
'KWILLIAMS',
'14'
],
[
'Apache::AuthExpire',
'b',
'd',
'p',
'f',
'p',
'PerlAuthenHandler to implement time limits',
'JJHORNER',
'15'
],
[
'CDDB',
'R',
'd',
'p',
'O',
'p',
'high-level interface to cddb/freedb protocol',
'RCAPUTO',
'7'
],
[
'Mail::SpamAssassin',
'M',
'm',
'p',
'O',
'o',
'identify spam mail using text analysis',
'JMASON',
'19'
],
[
'Authen::CyrusSASL',
'b',
'd',
'p',
'O',
'a',
'Cyrus-sasl pwcheck/saslauthd authentication.',
'MAKLER',
'14'
],
[
'Apache::OpenIndex',
'R',
'm',
'p',
'f',
'p',
'Apache modperl module to manage site files',
'SANDERSON',
'15'
],
[
'Jabber::Connection',
'i',
'?',
'?',
'?',
'?',
'handle client and component connections',
'QMACRO',
'15'
],
[
'Jabber::RPC',
'i',
'?',
'?',
'?',
'?',
'implements Jabber-RPC (XML-RPC over Jabber)',
'QMACRO',
'15'
],
[
'Jabber::RPC::HTTPgate',
'i',
'?',
'?',
'?',
'?',
'gateway between XML-RPC and Jabber-RPC',
'QMACRO',
'15'
],
[
'Class::MethodMapper',
'R',
'd',
'p',
'O',
'?',
'Abstract Class wrapper for AutoLoader',
'LENZO',
'6'
],
[
'Crypt::SmbHash',
'b',
'd',
'p',
'f',
'g',
'LM/NT hashing, for Samba\'s smbpasswd entries',
'BJKUIT',
'14'
],
[
'DNS::ZoneParse',
'R',
'd',
'p',
'O',
'p',
'Parse and manipulate DNS Zone files',
'SIMONFLK',
'5'
],
[
'XML::Checker',
'a',
'm',
'p',
'O',
'p',
'Validates XML against DTD',
'TJMATHER',
'11'
],
[
'XML::Filter::DetectWS',
'a',
'm',
'p',
'O',
'p',
'PerlSAX filter detects ignorable whitespace',
'TJMATHER',
'11'
],
[
'XML::Filter::Reindent',
'a',
'm',
'p',
'O',
'p',
'Reformats whitespace for pretty printing XML',
'TJMATHER',
'11'
],
[
'XML::Filter::SAXT',
'a',
'm',
'p',
'O',
'p',
'Replicates SAX events to SAX event handlers',
'TJMATHER',
'11'
],
[
'XML::Handler::Composer',
'a',
'm',
'p',
'O',
'p',
'Another XML printer/writer/generator',
'TJMATHER',
'11'
],
[
'XML::Handler::PrintEvents',
'a',
'm',
'p',
'O',
'p',
'Prints PerlSAX events (for debugging)',
'TJMATHER',
'11'
],
[
'XML::RegExp',
'a',
'm',
'p',
'n',
'p',
'Regular expressions for XML tokens',
'TJMATHER',
'11'
],
[
'XML::UM',
'a',
'm',
'p',
'O',
'p',
'Convert UTF-8 strings to any encoding',
'TJMATHER',
'11'
],
[
'POE::Component::Pcap',
'a',
'd',
'h',
'O',
'p',
'POE Interface to Net::Pcap',
'FLETCH',
'6'
],
[
'Slash',
'R',
'm',
'p',
'h',
'g',
'Runs slashdot.org; get it from slashcode.com',
'CNANDOR',
'15'
],
[
'Slash::OurNet',
'a',
'm',
'p',
'O',
'p',
'Slash WebBBS module via OurNet connectivity',
'AUTRIJUS',
'15'
],
[
'OurNet::BBSApp::Sync',
'R',
'm',
'p',
'O',
'p',
'Synchronize OurNet::BBS Objects',
'CLKAO',
'15'
],
[
'Apache::SharedMem',
'a',
'd',
'p',
'O',
'g',
'Share data between Apache children prcesses',
'RSOLIV',
'15'
],
[
'Class::DBI::mysql',
'R',
'm',
'p',
'O',
'p',
'Extensions to Class::DBI for MySQL',
'TMTM',
'6'
],
[
'Finance::NikkeiQuote',
'b',
'd',
'p',
'O',
'?',
'get stock information from Nikkei',
'DAIBA',
'23'
],
[
'Shell::Source',
'b',
'd',
'p',
'O',
'p',
'Run programs and inherit environment changes',
'PJCJ',
'4'
],
[
'Apache::MP3::Skin',
'b',
'd',
'p',
'O',
'p',
'Enables use of skin files with Apache::MP3',
'RGRAFF',
'15'
],
[
'Palm::ThinkDB',
'c',
'd',
'p',
'O',
'a',
'Manipulate ThinkDB TinyBytes for PalmOS',
'EARNESON',
'7'
],
[
'Audio::Ecasound',
'R',
'd',
'h',
'h',
'p',
'ecasound bindings, sound and fx processing',
'BOWMANBS',
'23'
],
[
'CGI::SimpleCache',
'a',
'd',
'p',
'O',
'p',
'Simple and fast cache for CGI modules',
'JSCH',
'15'
],
[
'Scalar::Properties',
'R',
'd',
'p',
'O',
'p',
'run-time properties on scalar variables',
'MARCEL',
'6'
],
[
'Apache::AntiSpam',
'b',
'd',
'p',
'O',
'p',
'AntiSpam filter for web pages',
'MIYAGAWA',
'15'
],
[
'WWW::Cache::Google',
'a',
'd',
'p',
'O',
'p',
'URI class for Google cache',
'MIYAGAWA',
'15'
],
[
'HTML::Index',
'R',
'd',
'p',
'O',
'p',
'Perl extension for indexing HTML files',
'AWRIGLEY',
'15'
],
[
'HTTPD::Log::Filter',
'R',
'd',
'p',
'O',
'p',
'module to filter entries out of an httpd log',
'AWRIGLEY',
'15'
],
[
'Audio::MPEG',
'a',
'd',
'h',
'h',
'g',
'Encode/Decode MPEG Audio (MP3)',
'PTIMOF',
'23'
],
[
'namespace',
'R',
'd',
'p',
'n',
'p',
'Perl pragma to use like C++ namespace alias',
'AMICHAUER',
'99'
],
[
'JUNOS',
'R',
'm',
'p',
'O',
'b',
'Perl interface to Juniper Inc. routers',
'JUNOS',
'24'
],
[
'XML::RDB',
'R',
'd',
'p',
'O',
'b',
'create,populate, & unpop RDB tables from XML',
'METZZO',
'11'
],
[
'Thread::RWLock',
'R',
'd',
'p',
'O',
'p',
'rwlock implementation for perl threads',
'AFERBER',
'2'
],
[
'Image::GD::Thumbnail',
'M',
'd',
'p',
'O',
'p',
'Produce thumbnail images with the GD library',
'LGODDARD',
'18'
],
[
'Bundle::Perl6',
'R',
'd',
'p',
'n',
'p',
'A bundle to install Perl6-related modules',
'MARCEL',
'25'
],
[
'Tie::Hash::Stack',
'b',
'd',
'p',
'r',
'a',
'Maintains an array of hashes like a stack',
'MNEYLON',
'6'
],
[
'XML::Stream',
'R',
'd',
'p',
'O',
'l',
'Module for handling XML Streams',
'REATMON',
'11'
],
[
'Class::MakeMethods',
'R',
'd',
'p',
'O',
'p',
'Generate common types of methods',
'EVO',
'6'
],
[
'Text::MicroMason',
'R',
'd',
'p',
'h',
'p',
'Flexible Templating Engine w. Mason Emulator',
'EVO',
'11'
],
[
'Sys::CPU',
'R',
'd',
'p',
'O',
'?',
'Access CPU info. number, etc on Win and UNIX',
'MZSANFORD',
'4'
],
[
'XML::Canonical',
'a',
'd',
'p',
'O',
'p',
'Perl wrapper to libxml2 Canonical XML',
'TJMATHER',
'11'
],
[
'Apache::Storage',
'R',
'd',
'p',
'O',
'?',
'Storing data in Apache.',
'KROW',
'15'
],
[
'Geo::IP',
'a',
'd',
'p',
'O',
'p',
'Look up country by IP Address',
'TJMATHER',
'23'
],
[
'Module::Use',
'b',
'd',
'p',
'n',
'p',
'Tracks modules loaded by a script',
'JSMITH',
'2'
],
[
'DBIx::TextIndex',
'b',
'd',
'c',
'O',
'p',
'Creates fulltext indexes of SQL text columns',
'DKOCH',
'7'
],
[
'Tie::Concurrent',
'b',
'd',
'p',
'r',
'p',
'Retie a hash when reading/writing.',
'GWYN',
'6'
],
[
'Mail::Verify',
'R',
'd',
'p',
'f',
'b',
'Attempt to verify an email address',
'PETEF',
'19'
],
[
'Data::Tabular::Dumper',
'b',
'd',
'p',
'O',
'p',
'Automate dumping of data to XML, XSL and CSV',
'GWYN',
'6'
],
[
'Religion::Package',
'b',
'd',
'p',
'f',
'p',
'Prepend package name to warn/die messages',
'GWYN',
'20'
],
[
'File::Touch',
'R',
'd',
'p',
'h',
'p',
'Update timestamps, create nonexistent files',
'NWETTERS',
'10'
],
[
'CGI::URI2param',
'R',
'd',
'p',
'f',
'p',
'extract query keys and values out of an URI',
'DOMM',
'15'
],
[
'Archive::Parity',
'a',
'd',
'p',
'f',
'p',
'makes parity file, recover files',
'FGLOCK',
'17'
],
[
'Unicode::Japanese',
'R',
'd',
'h',
'O',
'p',
'Japanese Character Encoding Handler',
'MIKAGE',
'13'
],
[
'Apache::SessionManager',
'R',
'd',
'p',
'O',
'p',
'Manage sessions over HTTP requests',
'ENRYS',
'15'
],
[
'Parse::FixedLength',
'R',
'd',
'p',
'O',
'p',
'Parse strings containing fixed length fields',
'DOUGW',
'11'
],
[
'Archive::Ar',
'R',
'd',
'p',
'O',
'p',
'Read, write and manipulate ar archives',
'JAYBONCI',
'17'
],
[
'Db::Mediasurface',
'b',
'd',
'p',
'O',
'p',
'API and I/O modules for Mediasurface CMS',
'NWETTERS',
'24'
],
[
'Image::WorldMap',
'R',
'd',
'p',
'O',
'?',
'Create graphical world maps of data',
'LBROCARD',
'18'
],
[
'Apache::Clickable',
'b',
'd',
'p',
'O',
'p',
'Make URLs and Emails in HTML clickable',
'MIYAGAWA',
'15'
],
[
'Class::Flyweight',
'a',
'd',
'p',
'O',
'p',
'implement the flyweight pattern in OO perl',
'DKUBB',
'6'
],
[
'JavaScript',
'b',
'm',
'c',
'O',
'p',
'Allowes JavaScript execution withing Perl',
'CLAESJAC',
'9'
],
[
'PDL::IO::HDF5',
'b',
'd',
'c',
'O',
'p',
'PDL Interface to the HDF5 Data Format',
'CERNEY',
'6'
],
[
'Relations',
'a',
'd',
'p',
'h',
'p',
'Database, CGI, and Graph Interfunctionality',
'GAFFER',
'7'
],
[
'Math::BigInt::BitVect',
'R',
'd',
'p',
'h',
'p',
'Use Bit::Vector for Math::BigInt routines',
'TELS',
'6'
],
[
'HTML::Macro',
'M',
'd',
'p',
'O',
'p',
'processes HTML templates',
'SOKOLOV',
'15'
],
[
'Env::Modulecmd',
'R',
'd',
'p',
'h',
'g',
'Interface to modulecmd from Perl',
'ISAACSON',
'4'
],
[
'Net::CIDR',
'R',
'd',
'p',
'f',
'p',
'Manipulate netblock lists in CIDR notation',
'MRSAM',
'5'
],
[
'IO::Tty',
'R',
'd',
'c',
'O',
'g',
'provide an interface to TTYs and PTYs',
'RGIERSIG',
'21'
],
[
'Win32::EventLog::Carp',
'R',
'd',
'p',
'f',
'p',
'For carping in the Windows NT Event Log',
'RRWO',
'22'
],
[
'PerlIO',
'R',
'u',
'c',
'n',
'p',
'On demand loader for PerlIO layers',
'P5P',
'2'
],
[
'PerlIO::gzip',
'R',
'd',
'c',
'O',
'?',
'provide a PerlIO layer to gzip/gunzip',
'NWCLARK',
'2'
],
[
'Inline::Files',
'R',
'd',
'p',
'O',
'?',
'Multiple virtual files after __END__',
'DCONWAY',
'2'
],
[
'Graphics::ColorNames',
'R',
'd',
'p',
'h',
'p',
'provides RGB values for standard color names',
'RRWO',
'18'
],
[
'HTML::Encoding',
'b',
'd',
'p',
'f',
'p',
'Determine encoding of HTML/XHTML documents',
'BJOERN',
'15'
],
[
'Lingua::ZH::HanConvert',
'a',
'd',
'p',
'f',
'p',
'Convert traditional <-> simplified Chinese',
'DIVEC',
'11'
],
[
'XML::NamespaceSupport',
'R',
'm',
'p',
'O',
'p',
'Generic namespace helpers (ported from SAX2)',
'ZOOLEIKA',
'11'
],
[
'NetAddr::IP::Find',
'a',
'd',
'p',
'f',
'p',
'Find IP addresses in plain text',
'MIYAGAWA',
'5'
],
[
'RT',
'R',
'm',
'p',
'O',
'g',
'RT, an enterprise-grade issue tracking syste',
'JESSE',
'23'
],
[
'GDS2',
'R',
'd',
'h',
'O',
'a',
'manipulate GDS2 stream format files',
'SCHUMACK',
'6'
],
[
'Apache::RedirectDBI',
'R',
'd',
'p',
'O',
'?',
'Redirect to different directories by DBI',
'SANDERSON',
'15'
],
[
'Class::Prototyped',
'R',
'd',
'p',
'O',
'p',
'Fast prototype-based OO programming in Perl',
'TEVERETT',
'6'
],
[
'Text::ScriptTemplate',
'R',
'd',
'p',
'O',
'?',
'Lightweight full-featured template processor',
'TAIY',
'11'
],
[
'Unicode::Lite',
'b',
'd',
'p',
'f',
'p',
'Easy conversion between encodings',
'AMICHAUER',
'13'
],
[
'System2',
'b',
'd',
'p',
'f',
'b',
'like system(), but with STDOUT, STDERR avail',
'REICHERT',
'23'
],
[
'RDF::Core',
'c',
'd',
'p',
'O',
'o',
'Basic RDF Tools',
'PAVELH',
'11'
],
[
'Graphics::MNG',
'a',
'd',
'+',
'O',
'p',
'Perl I/F to the MNG library from Gerard Juyn',
'MOTT',
'18'
],
[
'Devel::Constants',
'b',
'd',
'p',
'f',
'p',
'Resolve Constants back to their names',
'CHROMATIC',
'3'
],
[
'Math::BigInt::Pari',
'R',
'd',
'p',
'h',
'p',
'Use Math::Pari for Math::BigInt routines',
'TELS',
'6'
],
[
'Parse::Syntax',
'i',
'd',
'p',
'O',
'p',
'Syntax highlighter for programmers\' forums',
'SHERZODR',
'11'
],
[
'Date::Simple',
'R',
'd',
'p',
'O',
'p',
'A simple date object',
'YVES',
'6'
],
[
'Quantum::Usrn',
'R',
'd',
'p',
'?',
'p',
'Square root of not.',
'KASEI',
'6'
],
[
'Filter::Trigraph',
'b',
'd',
'p',
'n',
'p',
'Understand ANSI C trigraphs in Perl source.',
'KASEI',
'2'
],
[
'Attribute::Deprecated',
'R',
'd',
'p',
'O',
'p',
'Mark deprecated methods',
'KASEI',
'2'
],
[
'Math::RPN',
'R',
'd',
'p',
'f',
'?',
'Reverse Polish Notation Expression Evaluator',
'OWEN',
'6'
],
[
'Devel::Messenger',
'b',
'd',
'p',
'f',
'p',
'Let Your Code Talk to You',
'KOLIBRIE',
'3'
],
[
'Convert::Base32',
'b',
'd',
'p',
'f',
'p',
'Encoding and decoding of base32 strings',
'MIYAGAWA',
'17'
],
[
'IPTables::IPv4::IPQueue',
'R',
'd',
'c',
'O',
'g',
'IPTables userspace packet queuing',
'JMORRIS',
'5'
],
[
'Convert::DUDE',
'b',
'd',
'p',
'f',
'p',
'Conversion between Unicode and DUDE',
'MIYAGAWA',
'17'
],
[
'HTML::FromText',
'R',
'd',
'p',
'O',
'?',
'Mark up text as HTML',
'CWEST',
'15'
],
[
'PDL::NiceSlice',
'b',
'm',
'p',
'f',
'p',
'a nicer slicing syntax for PDL',
'CSOE',
'6'
],
[
'Inline::Guile',
'a',
'm',
'h',
'h',
'p',
'Inline module for Guile Scheme interpreter',
'SAMTREGAR',
'2'
],
[
'Apache::AuthCookieLDAP',
'R',
'd',
'p',
'O',
'?',
'An AuthCookie module backed by LDAP database',
'BJORNARDO',
'15'
],
[
'POE::Component::Client::UserAgent',
'b',
'd',
'p',
'O',
'p',
'LWP and LWP::Parallel based POE web client',
'RCAPUTO',
'15'
],
[
'Lingua::Conjunction',
'R',
'd',
'p',
'f',
'a',
'Convert lists into conjunctions',
'RRWO',
'11'
],
[
'Class::Holon',
'R',
'd',
'p',
'O',
'?',
'Declare hierarchical classes with one line',
'GSLONDON',
'6'
],
[
'Net::CDDBScan',
'b',
'd',
'p',
'O',
'p',
'String search interface to CDDB datbase',
'DSHULTZ',
'5'
],
[
'GSM::SMS',
'R',
'm',
'p',
'h',
'a',
'Modules for sending and receiving SMS',
'JOHANVDB',
'23'
],
[
'Decision::ACL',
'a',
'd',
'p',
'O',
'p',
'Manage and Build Access Control Lists',
'BBEAUSEJ',
'6'
],
[
'XML::Clean',
'a',
'd',
'p',
'f',
'a',
'XMLized text.',
'PKUBANEK',
'11'
],
[
'Crypt::OpenPGP',
'R',
'd',
'p',
'O',
'p',
'Pure-Perl OpenPGP implementation',
'BTROTT',
'14'
],
[
'DBD::PrimeBase',
'b',
'm',
'c',
'?',
'p',
'A primeBase database interface',
'PRIMEBASE',
'7'
],
[
'Astro::Cosmology',
'b',
'd',
'c',
'O',
'p',
'Calculate cosmological distance/volume/times',
'DJBURKE',
'23'
],
[
'Date::Passover',
'i',
'm',
'p',
'f',
'p',
'Calculate date of Passover or Rosh Hashanah',
'RBOW',
'6'
],
[
'Date::Chinese',
'i',
'm',
'p',
'O',
'p',
'Calculations in the Chinese calendar',
'RBOW',
'6'
],
[
'XML::Simple',
'R',
'd',
'p',
'h',
'p',
'Easy API to maintain XML (esp config files)',
'GRANTM',
'11'
],
[
'Net::FTPServer',
'R',
'd',
'c',
'O',
'?',
'Secure, extensible, configurable FTP server',
'RWMJ',
'5'
],
[
'Class::PseudoHash',
'b',
'm',
'p',
'r',
'p',
'Emulates Pseudo-Hash behaviour via overload',
'AUTRIJUS',
'6'
],
[
'SVG::Graph',
'b',
'm',
'p',
'O',
'p',
'Series of Modules to produce SVG graphs',
'ALLENDAY',
'18'
],
[
'Math::SimpleInterest',
'R',
'n',
'p',
'f',
'p',
'Functions for Simple Interest calculations',
'BYOURTH',
'6'
],
[
'Perl6::Interpolators',
'b',
'd',
'p',
'n',
'p',
'Use Perl 6 function-interpolation syntax',
'BRENTDAX',
'28'
],
[
'Convert::TNEF',
'R',
'd',
'p',
'O',
'p',
'Perl module to read TNEF files',
'DOUGW',
'17'
],
[
'Data::MaskPrint',
'b',
'd',
'p',
'O',
'p',
'Allows for exact formatting of data',
'ILYAVERL',
'6'
],
[
'Class::Tangram',
'b',
'd',
'p',
'O',
'a',
'Automated class accessors, Tangram friendly',
'SAMV',
'6'
],
[
'Tivoli',
'S',
'm',
'p',
'f',
'p',
'Tivoli TME10 - Perl Interface',
'RHASE',
'24'
],
[
'Win32::SharedFileOpen',
'R',
'd',
'c',
'f',
'p',
'Interface to Win32 sopen + fsopen functions',
'SHAY',
'22'
],
[
'Net::SMS::Web',
'a',
'd',
'p',
'O',
'p',
'generic module for sending SMS via web',
'AWRIGLEY',
'5'
],
[
'Win32::Guidgen',
'b',
'd',
'p',
'f',
'p',
'Generates GUIDs',
'JOEPHAYES',
'22'
],
[
'VCS::StarTeam',
'b',
'd',
'p',
'f',
'p',
'Provides an interface to StarBase\'s StarTeam',
'JOEPHAYES',
'3'
],
[
'Net::Traceroute6',
'a',
'd',
'p',
'h',
'b',
'Interface to IPv6 traceroute',
'MOHACSI',
'5'
],
[
'XML::Directory',
'R',
'd',
'p',
'O',
'p',
'Returns a content of directory as XML',
'PCIMPRICH',
'11'
],
[
'Test::More',
'R',
'd',
'p',
'O',
'p',
'More functions for writing tests',
'MSCHWERN',
'3'
],
[
'HTML::Processor',
'R',
'd',
'p',
'O',
'p',
'OO Template Processing Library for HTML,Text',
'PSCHNELL',
'15'
],
[
'Sendmail::AccessDB',
'a',
'd',
'p',
'f',
'p',
'Interface to sendmail\'s access.db',
'DREDD',
'19'
],
[
'Net::QMQP',
'a',
'd',
'p',
'O',
'p',
'Interface to Quick Mail Queueing Protocol',
'KOBAYASI',
'5'
],
[
'Net::ICQV5',
'R',
'n',
'p',
'f',
'g',
'Module to send and receive ICQ messages.',
'SNEMAROV',
'5'
],
[
'Net::ICQV5CD',
'R',
'n',
'p',
'f',
'g',
'Crypt/decrypt ICQ protocol V5 packets',
'SNEMAROV',
'5'
],
[
'Net::ICQ2000',
'i',
'n',
'p',
'f',
'g',
'allows send and receive ICQ messages.',
'SNEMAROV',
'5'
],
[
'SVG',
'R',
'm',
'p',
'O',
'p',
'Generate SVG images and files',
'RONAN',
'18'
],
[
'Date::Gregorian',
'b',
'd',
'p',
'O',
'p',
'Gregorian calendar',
'MHASCH',
'6'
],
[
'Crypt::Rijndael_PP',
'b',
'd',
'p',
'h',
'g',
'pure perl implementation of Rijndael (AES)',
'DELTA',
'14'
],
[
'HTML::ParseBrowser',
'R',
'd',
'p',
'O',
'p',
'OO User Agent string parser',
'DODGER',
'15'
],
[
'Object::Realize::Later',
'M',
'd',
'p',
'O',
'p',
'Delay construction of real data until used',
'MARKOV',
'6'
],
[
'HTML::CalendarMonthDB',
'a',
'd',
'p',
'f',
'n',
'Module Generating Persistant HTML Calendars',
'MCVELLA',
'15'
],
[
'Parse::Syslog',
'b',
'd',
'p',
'O',
'p',
'Parse Unix syslog files',
'DSCHWEI',
'11'
],
[
'Apache::ParseControl',
'c',
'd',
'p',
'O',
'p',
'control the parsing of server-side scripts',
'DAPATRICK',
'15'
],
[
'Apache::HTMLView',
'b',
'm',
'p',
'f',
'l',
'A mod_perl module for compiled HTMLView page',
'BJORNARDO',
'15'
],
[
'News::GnusFilter',
'b',
'd',
'p',
'f',
'p',
'gnus MIME-hook filter to score usenet posts',
'JOESUF',
'19'
],
[
'Lingua::JA::Number',
'a',
'd',
'p',
'f',
'p',
'Translate numbers into Japanese',
'MSCHILLI',
'11'
],
[
'Apache::ACEProxy',
'b',
'd',
'p',
'O',
'p',
'IDN compatible ACE proxy server',
'MIYAGAWA',
'15'
],
[
'Oak',
'M',
'm',
'p',
'O',
'p',
'Oak Perl Compoment Tree',
'DRUOSO',
'3'
],
[
'Attribute::Signature',
'b',
'd',
'p',
'h',
'p',
'Signatures on methods and subroutines',
'JDUNCAN',
'2'
],
[
'Filesys::SmbClientParser',
'R',
'd',
'p',
'O',
'p',
'Perl interface to reach Samba ressources',
'ALIAN',
'10'
],
[
'Java::JVM::Classfile',
'R',
'd',
'p',
'O',
'?',
'Parse JVM Classfiles',
'LBROCARD',
'9'
],
[
'WWW::Search::RpmFind',
'R',
'm',
'p',
'O',
'p',
'Search interface for rpmfind.net',
'ALIAN',
'15'
],
[
'Mail::QmailRemote',
'b',
'd',
'p',
'O',
'p',
'send email using qmail-remote directly.',
'IKEBE',
'19'
],
[
'Sub::Quotelike',
'b',
'd',
'p',
'p',
'p',
'Allow to define quotelike functions',
'RGARCIA',
'3'
],
[
'Data::Serializer',
'R',
'd',
'p',
'O',
'p',
'Generic interface to serializer modules',
'NEELY',
'6'
],
[
'SAP::Rfc',
'M',
'd',
'h',
'O',
'p',
'SAP RFC Interface',
'PIERS',
'24'
],
[
'Math::Random',
'R',
'd',
'h',
'f',
'd',
'Random Number Generators',
'GROMMEL',
'6'
],
[
'DBIx::FetchLoop',
'R',
'd',
'p',
'O',
'g',
'Fetch with change detection and aggregates',
'BITS',
'7'
],
[
'Authen::SASL',
'R',
'm',
'p',
'O',
'p',
'SASL authentication framework',
'GBARR',
'14'
],
[
'Authen::SASL::Cyrus',
'a',
'd',
'p',
'O',
'g',
'XS Interface to Cyrus SASL',
'ADAMSON',
'14'
],
[
'Tk::DateEntry',
'R',
'd',
'p',
'O',
'?',
'Drop down calendar for selecting dates',
'SREZIC',
'8'
],
[
'Tk::MListbox',
'R',
'd',
'p',
'O',
'?',
'Multicolumn Listbox.',
'RCSEEGE',
'8'
],
[
'Test::Simple',
'b',
'm',
'p',
'f',
'p',
'Basic utilities for writing tests',
'MSCHWERN',
'3'
],
[
'Mail::Sieve',
'c',
'd',
'p',
'O',
'p',
'RFC 3028 Mail Filtering',
'BRONG',
'19'
],
[
'XML::Writer::String',
'R',
'd',
'p',
'O',
'p',
'Module to capture output from XML::Writer',
'SOLIVER',
'11'
],
[
'Net::FreeDB',
'b',
'd',
'h',
'O',
'p',
'OOP interface to the FreeDB database',
'DSHULTZ',
'5'
],
[
'File::Data',
'R',
'd',
'p',
'O',
'?',
'Prepend, insert, append data into files',
'RFOLEY',
'10'
],
[
'Linux::Cpuinfo',
'R',
'd',
'p',
'O',
'?',
'Object Oriented Interface to /proc/cpuinfo',
'JSTOWE',
'4'
],
[
'Linux::Fuser',
'R',
'd',
'p',
'O',
'?',
'Determine which processes have a file open',
'JSTOWE',
'4'
],
[
'Linux::Svgalib',
'R',
'd',
'c',
'O',
'?',
'Object Oriented Perl interface to svgalib',
'JSTOWE',
'4'
],
[
'Sys::Lastlog',
'R',
'd',
'c',
'O',
'?',
'Provide a moderately Object Oreiented Interf',
'JSTOWE',
'4'
],
[
'Sys::Utmp',
'R',
'd',
'c',
'O',
'?',
'Object(ish) Interface to UTMP files.',
'JSTOWE',
'4'
],
[
'Digest::Perl::MD5',
'M',
'd',
'p',
'h',
'g',
'Pure perl implementation of MD5',
'DELTA',
'14'
],
[
'MySQL::TableInfo',
'R',
'd',
'p',
'O',
'p',
'Access to MySQL table\'s meta data',
'SHERZODR',
'7'
],
[
'Astro::SkyCoords',
'b',
'd',
'p',
'O',
'p',
'celestial coordinates in astronomy',
'GRIXON',
'23'
],
[
'POE::Component::MPG123',
'R',
'd',
'p',
'O',
'b',
'POE Component for accessing and working wit',
'MCASHNER',
'4'
],
[
'Authen::Krb5::KDB',
'b',
'd',
'p',
'O',
'p',
'Parse Kerberos V5 database files',
'DKS',
'14'
],
[
'Net::Google',
'b',
'd',
'p',
'O',
'p',
'Simple OOP-ish interface to the Google API',
'ASCOPE',
'5'
],
[
'Test::Exception',
'M',
'd',
'p',
'f',
'p',
'Functions for testing exception-based code',
'ADIE',
'3'
],
[
'NexTrieve',
'R',
'm',
'p',
'O',
'p',
'Interface to the NexTrieve search engine',
'ELIZABETH',
'24'
],
[
'NexTrieve::Collection',
'R',
'm',
'p',
'O',
'p',
'logical collection object',
'ELIZABETH',
'24'
],
[
'NexTrieve::Collection::Index',
'R',
'm',
'p',
'O',
'p',
'logical index object within a collection',
'ELIZABETH',
'24'
],
[
'NexTrieve::Daemon',
'R',
'm',
'p',
'O',
'p',
'logical daemon object',
'ELIZABETH',
'24'
],
[
'NexTrieve::DBI',
'R',
'm',
'p',
'O',
'p',
'convert DBI statement to document sequence',
'ELIZABETH',
'24'
],
[
'NexTrieve::Docseq',
'R',
'm',
'p',
'O',
'p',
'logical document sequence for indexing',
'ELIZABETH',
'24'
],
[
'NexTrieve::Document',
'R',
'm',
'p',
'O',
'p',
'logical document object',
'ELIZABETH',
'24'
],
[
'NexTrieve::Hitlist',
'R',
'm',
'p',
'O',
'p',
'result of query from search engine',
'ELIZABETH',
'24'
],
[
'NexTrieve::Hitlist::Hit',
'R',
'm',
'p',
'O',
'p',
'a single hit of the result',
'ELIZABETH',
'24'
],
[
'NexTrieve::HTML',
'R',
'm',
'p',
'O',
'p',
'convert HTML-file(s) to logical document(s)',
'ELIZABETH',
'24'
],
[
'NexTrieve::Index',
'R',
'm',
'p',
'O',
'p',
'create an index out of a docseq',
'ELIZABETH',
'24'
],
[
'NexTrieve::Mbox',
'R',
'm',
'p',
'O',
'p',
'convert Unix mailbox to document sequence',
'ELIZABETH',
'24'
],
[
'NexTrieve::Message',
'R',
'm',
'p',
'O',
'p',
'convert Mail::Message object(s) to document(',
'ELIZABETH',
'24'
],
[
'NexTrieve::MIME',
'R',
'm',
'p',
'O',
'p',
'MIME-type conversions for documents',
'ELIZABETH',
'24'
],
[
'NexTrieve::Overview',
'R',
'm',
'p',
'O',
'p',
'an overview of NexTrieve and its Perl suppor',
'ELIZABETH',
'24'
],
[
'NexTrieve::PDF',
'R',
'm',
'p',
'O',
'p',
'Convert PDF-file(s) to logical document(s)',
'ELIZABETH',
'24'
],
[
'NexTrieve::Query',
'R',
'm',
'p',
'O',
'p',
'Create/adapt query',
'ELIZABETH',
'24'
],
[
'NexTrieve::Querylog',
'R',
'm',
'p',
'O',
'p',
'Turn query log into Query objects',
'ELIZABETH',
'24'
],
[
'NexTrieve::Replay',
'R',
'm',
'p',
'O',
'p',
'Turn Querylog into Hitlist for a Search',
'ELIZABETH',
'24'
],
[
'NexTrieve::Resource',
'R',
'm',
'p',
'O',
'p',
'Create/adapt resource-file',
'ELIZABETH',
'24'
],
[
'NexTrieve::RFC822',
'R',
'm',
'p',
'O',
'p',
'Convert message(s) to logical document(s)',
'ELIZABETH',
'24'
],
[
'NexTrieve::Search',
'R',
'm',
'p',
'O',
'p',
'Logical search engine object',
'ELIZABETH',
'24'
],
[
'NexTrieve::Targz',
'R',
'm',
'p',
'O',
'p',
'Maintain a Targz message archive',
'ELIZABETH',
'24'
],
[
'NexTrieve::UTF8',
'R',
'm',
'p',
'O',
'p',
'Change encoding to UTF-8',
'ELIZABETH',
'24'
],
[
'XML::GDOME::XSLT',
'a',
'm',
'c',
'O',
'p',
'XSLT using libxslt and XML::GDOME',
'TJMATHER',
'11'
],
[
'IO::Multiplex',
'b',
'd',
'p',
'h',
'a',
'Manage Input Output on many file handles',
'BBB',
'21'
],
[
'Test::Litmus',
'b',
'd',
'p',
'O',
'o',
'Submit results Litmus testcase manager',
'ZLIPTON',
'3'
],
[
'Openview::Message',
'R',
'd',
'c',
'h',
'p',
'OO and function access to Openview opcmsg()',
'LBAXTER',
'24'
],
[
'HTML::GenToc',
'R',
'd',
'p',
'O',
'g',
'generate table of contents for HTML docs',
'RUBYKAT',
'15'
],
[
'XML::STX',
'a',
'd',
'p',
'O',
'o',
'Pure Perl STX engine',
'PCIMPRICH',
'11'
],
[
'Pod::POM',
'R',
'd',
'p',
'O',
'p',
'Pod Object Model',
'ABW',
'26'
],
[
'Math::Bezier',
'R',
'd',
'p',
'O',
'p',
'Solution of Bezier curves',
'ABW',
'6'
],
[
'Class::Facade',
'b',
'd',
'p',
'O',
'p',
'Interface to one or more delegates',
'ABW',
'6'
],
[
'Apache::Template',
'R',
'd',
'p',
'O',
'p',
'Apache interface to the Template Toolkit',
'ABW',
'15'
],
[
'RDF::Redland',
'M',
'd',
'h',
'O',
'l',
'Redland RDF library',
'DJBECKETT',
'11'
],
[
'XML::Filter::Sort',
'R',
'm',
'p',
'O',
'p',
'SAX filter for sorting elements in XML',
'GRANTM',
'11'
],
[
'SQL::Snippet',
'b',
'd',
'p',
'O',
'p',
'Constraint-based OO Interface to RDBMS',
'PRL',
'7'
],
[
'Hook::Scope',
'b',
'd',
'c',
'f',
'p',
'Register code to run on scope leaves.',
'ABERGMAN',
'20'
],
[
'Lingua::Zompist::Barakhinei',
'a',
'd',
'p',
'f',
'b',
'Inflect Barakhinei nouns, verbs, adjectives',
'PNE',
'11'
],
[
'Lingua::Zompist::Cuezi',
'c',
'd',
'p',
'f',
'b',
'Inflect Cuezi nouns, verbs, and adjectives',
'PNE',
'11'
],
[
'Lingua::Zompist::Kebreni',
'a',
'd',
'p',
'O',
'b',
'Conjugate Kebreni verbs',
'PNE',
'11'
],
[
'Lingua::Zompist::Verdurian',
'b',
'd',
'p',
'f',
'b',
'Inflect Verdurian nouns, verbs, adjectives',
'PNE',
'11'
],
[
'Lingua::Zompist::Cadhinor',
'b',
'd',
'p',
'f',
'b',
'Inflect Cadhinor nouns, verbs, adjectives',
'PNE',
'11'
],
[
'Lingua::Zompist',
'c',
'd',
'h',
'h',
'b',
'Namespace for modules for languages of Almea',
'PNE',
'11'
],
[
'Net::DNS::SEC',
'R',
'd',
'p',
'O',
'd',
'DNSSEC extension to Net::DNS',
'OLAF',
'5'
],
[
'RTF::Tokenizer',
'b',
'd',
'p',
'h',
'p',
'Module for Tokenizing RTF',
'SARGIE',
'11'
],
[
'URI::Sequin',
'R',
'd',
'p',
'f',
'g',
'Takes search terms from URLs',
'SARGIE',
'15'
],
[
'XML::XForms::Generator',
'a',
'd',
'h',
'h',
'p',
'Generator for the creation of XForms',
'DHAGEMAN',
'11'
],
[
'XML::Twig',
'R',
'm',
'p',
'O',
'p',
'A module for easy processing of XML',
'MIROD',
'11'
],
[
'Net::Whois::RIPE',
'M',
'm',
'p',
'O',
'g',
'class implementing a RIPE whois client',
'PAULG',
'5'
],
[
'ConfigReader::Simple',
'R',
'd',
'p',
'O',
'p',
'Read simple configuration file formats',
'BDFOY',
'12'
],
[
'Tie::Toggle',
'R',
'd',
'p',
'r',
'p',
'a scalar flip-flops between two values',
'BDFOY',
'6'
],
[
'POE::Component::Server::HTTP',
'b',
'd',
'p',
'h',
'p',
'POE Web componenet',
'ABERGMAN',
'5'
],
[
'ADT::Queue::Priority',
'c',
'n',
'p',
'h',
'p',
'Abstract Data Type Priority Queue',
'ABERGMAN',
'6'
],
[
'ADT',
'c',
'd',
'h',
'h',
'p',
'Abstract Data Type top level',
'ABERGMAN',
'6'
],
[
'DBD::PgPP',
'b',
'd',
'p',
'O',
'p',
'Pure Perl PostgreSQL driver for the DBI',
'OYAMA',
'7'
],
[
'Debug::FaultAutoBT',
'a',
'd',
'h',
'O',
'a',
'Automatic Backtrace Extractor on SIG Faults',
'STAS',
'3'
],
[
'GD::Gauge',
'b',
'd',
'p',
'O',
'p',
'Create various graphic gauges using GD',
'CCLOUTIER',
'18'
],
[
'Linux::Pid',
'R',
'd',
'p',
'f',
'p',
'Interface to Linux getpp?id functions',
'RGARCIA',
'4'
],
[
'Math::Business::BlackScholes',
'R',
'd',
'p',
'f',
'p',
'Black-Scholes option price model functions',
'ANDERS',
'6'
],
[
'App::Info',
'R',
'd',
'p',
'O',
'p',
'Information about software packages',
'DWHEELER',
'12'
],
[
'Test::Reporter',
'M',
'd',
'p',
'O',
'p',
'sends test results to cpan-testers@perl.org',
'FOX',
'3'
],
[
'Set::CrossProduct',
'R',
'd',
'p',
'O',
'p',
'interact with the cartesian product of sets',
'BDFOY',
'6'
],
[
'XML::OCS',
'c',
'd',
'p',
'O',
'p',
'OCS (Open Content Syndication) parser',
'BHANN',
'11'
],
[
'Module::Signature',
'c',
'd',
'p',
'f',
'p',
'Module signature file manipulation',
'AUDREYT',
'2'
],
[
'Apache::Htaccess',
'R',
'd',
'p',
'O',
'p',
'read and write apache .htaccess files',
'BDFOY',
'15'
],
[
'File::Find::Rule',
'R',
'd',
'p',
'h',
'p',
'Alternative interface to File::Find',
'RCLAMP',
'10'
],
[
'Finance::Bank::Commonwealth',
'b',
'd',
'p',
'O',
'p',
'A web-banking front-end',
'DDICK',
'23'
],
[
'HTTP::SimpleLinkChecker',
'R',
'd',
'p',
'f',
'p',
'get the HTTP status of a URL',
'BDFOY',
'15'
],
[
'Perl6::Parameters',
'b',
'd',
'p',
'n',
'p',
'Use Perl 6-style named parameters',
'BRENTDAX',
'28'
],
[
'MARC::Record',
'R',
'm',
'p',
'O',
'p',
'MARC manipulation (library bibliographic)',
'MOREGAN',
'7'
],
[
'Test::Pod',
'R',
'd',
'p',
'O',
'p',
'Tests POD files for correctness',
'PETDANCE',
'2'
],
[
'Test::Manifest',
'b',
'd',
'p',
'f',
'p',
'configure which test files to run',
'BDFOY',
'3'
],
[
'Log::Dispatch::Win32EventLog',
'R',
'd',
'p',
'O',
'p',
'Log::Dispatch to the Win32 Eventlog',
'ABERGMAN',
'22'
],
[
'Mail::Vacation',
'R',
'd',
'p',
'O',
'p',
'perl implementation of vacation program',
'RFOLEY',
'19'
],
[
'Mail::Vacation::LDAP',
'R',
'd',
'p',
'O',
'p',
'vacation program using LDAP',
'RFOLEY',
'19'
],
[
'Acme::Morse::Audible',
'R',
'd',
'p',
'n',
'p',
'Audio(Morse) Programming with Perl',
'ITRIVIZKI',
'2'
],
[
'Lingua::ZH::CCDICT',
'a',
'd',
'p',
'O',
'p',
'Perl interface to CCDICT Chinese dictionary',
'DROLSKY',
'11'
],
[
'Time::Piece::MySQL',
'R',
'd',
'p',
'O',
'p',
'MySQL-specific functions for Time::Piece',
'KASEI',
'6'
],
[
'HTML::LinkExtractor',
'M',
'd',
'p',
'O',
'p',
'Extract links from an HTML document',
'PODMASTER',
'15'
],
[
'Lingua::ZH::CEDICT',
'R',
'd',
'p',
'O',
'r',
'CEDICT (Chin./Engl. dictionary)-Interface',
'CRENZ',
'11'
],
[
'File::Searcher::Similars',
'M',
'd',
'p',
'f',
'p',
'pick out suspicious duplicate files',
'SUNTONG',
'10'
],
[
'Lingua::FeatureSet',
'a',
'd',
'p',
'O',
'p',
'define phonology-style features for emes',
'KAHN',
'11'
],
[
'UUID',
'R',
'd',
'p',
'f',
'p',
'interface for e2fsprogs UUID (unique idents)',
'LZAP',
'11'
],
[
'Test::Data',
'a',
'd',
'p',
'f',
'p',
'Check data and variable properties and value',
'BDFOY',
'3'
],
[
'Math::Logic::Predicate',
'b',
'd',
'p',
'O',
'p',
'Query a Predicate Logic database',
'LPALMER',
'6'
],
[
'Config::Abstract',
'a',
'd',
'p',
'O',
'p',
'Abstractions for configfiles in many formats',
'AVAJADI',
'12'
],
[
'CGI::Panel',
'b',
'd',
'p',
'O',
'p',
'Event-driven web apps from panel objects',
'RSYMES',
'15'
],
[
'Log::Log4perl',
'a',
'm',
'p',
'O',
'p',
'Log4j implementation in Perl',
'MSCHILLI',
'3'
],
[
'Wx',
'M',
'm',
'+',
'O',
'p',
'interface to the wxWidgets GUI toolkit',
'MBARBON',
'8'
],
[
'Test::ISBN',
'b',
'd',
'p',
'f',
'p',
'Check International Standard Book Numbers',
'BDFOY',
'3'
],
[
'Test::Env',
'b',
'd',
'p',
'f',
'p',
'Test the environment',
'BDFOY',
'3'
],
[
'Tk::Graph',
'b',
'd',
'p',
'O',
'p',
'Realtime Chart Canvas',
'XPIX',
'8'
],
[
'Business::ISMN',
'b',
'd',
'p',
'h',
'p',
'International Standard Music Numbers',
'BDFOY',
'23'
],
[
'Mac::iTunes',
'a',
'd',
'h',
'O',
'p',
'interface to iTunes files and control',
'BDFOY',
'4'
],
[
'Mac::PropertyList',
'b',
'd',
'p',
'f',
'p',
'work with MacOS X plist files',
'BDFOY',
'12'
],
[
'Wx::WidgetMaker',
'c',
'd',
'p',
'O',
'p',
'CGI.pm-like widget library for wxPerl',
'SLANNING',
'8'
],
[
'DBIx::Chart',
'a',
'd',
'p',
'O',
'a',
'extends DBI & SQL w/ charting capabilities',
'DARNOLD',
'7'
],
[
'Graphics::ColorPicker',
'R',
'd',
'p',
'f',
'g',
'WYSIWYG web browser HEX color selector',
'MIKER',
'8'
],
[
'Bundle::KohaSupport',
'R',
'm',
'o',
'n',
'g',
'A bundle of the modules required for Koha',
'KOHA',
'25'
],
[
'Net::BGP',
'a',
'n',
'p',
'O',
'p',
'Object-oriented API to the BGP protocol',
'SSCHECK',
'5'
],
[
'HPUX::LVM',
'b',
'd',
'p',
'O',
'p',
'Interface to HPUX\'s LVM volume manager',
'CWHITE',
'4'
],
[
'Filter::NumberLines',
'R',
'd',
'p',
'n',
'g',
'Source filter for line numbering',
'BEATNIK',
'2'
],
[
'Template::Plugin::StickyQuery',
'b',
'd',
'p',
'O',
'p',
'TT plugin for  HTML::StickyQuery',
'KOBAYASI',
'11'
],
[
'Class::Decorator',
'R',
'd',
'p',
'O',
'p',
'Adds additional responsibilites to an object',
'NWETTERS',
'6'
],
[
'WebService::FreeDB',
'b',
'd',
'p',
'O',
'p',
'A String search interface to FreeDB',
'HMERSCH',
'15'
],
[
'Mac::AppleScript::Glue',
'a',
'd',
'p',
'O',
'p',
'translate Perl into Applescript',
'JLABOVITZ',
'9'
],
[
'AFS',
'R',
'd',
'c',
'O',
'p',
'AFS Distributed File System interface',
'NOG',
'10'
],
[
'PostScript::File',
'b',
'd',
'p',
'O',
'p',
'PostScript File creation with debug support',
'CPWILLMOT',
'11'
],
[
'Hash::Case',
'M',
'd',
'p',
'r',
'p',
'Case-insensitive hash-keys',
'MARKOV',
'6'
],
[
'Geo::Coordinates::Convert',
'a',
'd',
'p',
'f',
'p',
'Converts geographics coordinates to Lambert',
'JPVIDAL',
'23'
],
[
'Log::Dispatch::Jabber',
'b',
'd',
'p',
'O',
'p',
'Log messages via Jabber',
'ASCOPE',
'21'
],
[
'PDF::Report',
'R',
'd',
'p',
'O',
'p',
'Simple PDF document creation.',
'MITTI',
'11'
],
[
'HTTP::Proxy',
'b',
'd',
'p',
'O',
'p',
'HTTP proxy',
'BOOK',
'15'
],
[
'POE::Component::Client::Ping',
'R',
'd',
'p',
'h',
'p',
'concurrent ICMP ping without fork or threads',
'RCAPUTO',
'5'
],
[
'Math::Geometry::Planar',
'R',
'd',
'p',
'O',
'p',
'A collection of planar geometry functions',
'DVDPOL',
'6'
],
[
'Tk::CollapsableFrame',
'R',
'd',
'p',
'O',
'p',
'Frame that opens and closes',
'LUSOL',
'8'
],
[
'Tk::ExecuteCommand',
'R',
'd',
'p',
'O',
'p',
'execute non-blocking system commands',
'LUSOL',
'8'
],
[
'Tk::LCD',
'R',
'd',
'p',
'O',
'p',
'display Liquid Crystal Display symbols',
'LUSOL',
'8'
],
[
'Tk::PhotoRotate',
'R',
'd',
'p',
'O',
'p',
'rotate Photos by arbitrary angles',
'LUSOL',
'8'
],
[
'Tk::Splashscreen',
'R',
'd',
'p',
'O',
'p',
'display a Splashscreen during initialization',
'LUSOL',
'8'
],
[
'Tk::Thumbnail',
'R',
'd',
'p',
'O',
'p',
'Create a Table of shrunken/expanded images',
'LUSOL',
'8'
],
[
'Pod::Simple',
'b',
'd',
'p',
'O',
'p',
'the framework for parsing Pod',
'ARANDAL',
'26'
],
[
'Tk::ProgressBar::Mac',
'R',
'd',
'p',
'O',
'p',
'blue 3-D Macintosh Classic progress bar',
'LUSOL',
'8'
],
[
'Tk::Copy::Mac',
'R',
'd',
'p',
'O',
'p',
'simulate a Macintosh Classic copy dialog',
'LUSOL',
'8'
],
[
'Tk::DatePick',
'R',
'n',
'p',
'O',
'p',
'A simple widget for date entry',
'LAWGON',
'8'
],
[
'Apache::ForwardedFor',
'R',
'd',
'p',
'O',
'p',
'Updates the remote ip for proxied requests',
'JLAWRENC',
'15'
],
[
'Math::Geometry::GPC',
'R',
'd',
'c',
'f',
'p',
'Perl wrapper for Alan Murta\'s gpc library',
'DVDPOL',
'6'
],
[
'Net::LPR',
'R',
'd',
'p',
'O',
'p',
'Connect to an RFC1179 line printer daemon',
'DMLLOYD',
'5'
],
[
'Apache::iTunes',
'a',
'd',
'p',
'O',
'p',
'mod_perl interface to iTunes',
'BDFOY',
'15'
],
[
'Mac::Errors',
'b',
'd',
'p',
'h',
'p',
'MacErrors.h names, numbers, and descriptions',
'BDFOY',
'4'
],
[
'Image::WMF',
'R',
'd',
'p',
'O',
'g',
'Creates and writes windows metafile images',
'TCOX',
'18'
],
[
'SVG::XML',
'R',
'm',
'p',
'O',
'p',
'Generate xml text strings',
'RONAN',
'18'
],
[
'SVG::Element',
'R',
'm',
'p',
'O',
'p',
'Handle XML elements for the SVG module DOM',
'RONAN',
'18'
],
[
'Language::Ook',
'R',
'd',
'p',
'O',
'p',
'an Ook! interpreter',
'JQUELIN',
'9'
],
[
'Apache::Dynagzip',
'R',
'd',
'p',
'h',
'p',
'dynamic gzip compression of outbound stream',
'SLAVA',
'15'
],
[
'Apache::Log::Spread',
'R',
'd',
'p',
'h',
'b',
'Port of mod_log_spread to mod_perl',
'GSCHLOSS',
'15'
],
[
'Math::Nocarry',
'b',
'd',
'p',
'f',
'p',
'perform no-carry arithmetic',
'BDFOY',
'6'
],
[
'Test::File',
'b',
'd',
'p',
'f',
'p',
'test file attributes through Test::Builder',
'BDFOY',
'3'
],
[
'Tk::Calculator::RPN::HP',
'b',
'd',
'p',
'O',
'p',
'Base class for HP RPN calculators.',
'LUSOL',
'8'
],
[
'HTML::SimpleLinkExtor',
'R',
'd',
'p',
'f',
'p',
'a simple way to extract links',
'BDFOY',
'15'
],
[
'Test::URI',
'b',
'd',
'p',
'f',
'p',
'check parts of URI with Test::Builder',
'BDFOY',
'3'
],
[
'Devel::Size',
'b',
'd',
'c',
'f',
'p',
'Report amount of memory a variable uses',
'DSUGAL',
'3'
],
[
'Math::Fractal::DLA',
'b',
'd',
'p',
'O',
'p',
'Creates a DLA-fractal with GD',
'ARCOLF',
'6'
],
[
'News::Search',
'a',
'u',
'p',
'O',
'a',
'console based Usenet news searching toolset',
'SUNTONG',
'19'
],
[
'SVG::DOM',
'R',
'm',
'p',
'O',
'p',
'W3C DOM level 1 support for SVG',
'RONAN',
'18'
],
[
'Time::Duration::sv',
'R',
'd',
'p',
'f',
'p',
'rounded or exact Swedish duratations',
'ABERGMAN',
'6'
],
[
'PostScript::Graph::Bar',
'a',
'd',
'p',
'O',
'a',
'Draw point or line graphs from CSV files',
'CPWILLMOT',
'11'
],
[
'PostScript::Graph::Key',
'b',
'd',
'p',
'O',
'p',
'A Key box accompanying Graph::Paper',
'CPWILLMOT',
'11'
],
[
'PostScript::Graph::Paper',
'b',
'd',
'p',
'O',
'p',
'Produce a blank grid on a PostScript file',
'CPWILLMOT',
'11'
],
[
'PostScript::Graph::Style',
'b',
'd',
'p',
'O',
'p',
'Line, point and bar appearance',
'CPWILLMOT',
'11'
],
[
'PostScript::Graph::XY',
'a',
'd',
'p',
'O',
'a',
'Draw point or line graphs from CSV files',
'CPWILLMOT',
'11'
],
[
'Win32API::MIDI',
'a',
'd',
'h',
'O',
'p',
'Perl extension for MS Windows 32bit MIDI API',
'HAYASHI',
'22'
],
[
'Lingua::FR::Numbers',
'R',
'd',
'p',
'h',
'p',
'Converts numeric values into French strings',
'BRIAC',
'11'
],
[
'Business::NoChex',
'b',
'd',
'p',
'O',
'p',
'An OO interface to the NoChex apc',
'RSZEMETI',
'23'
],
[
'MP3::Mplib',
'a',
'd',
'c',
'h',
'p',
'Read and write access to v1 and v2 mp3-tags',
'VPARSEVAL',
'23'
],
[
'Crypt::CCTB',
'c',
'd',
'p',
'O',
'p',
'Classical Cryptography Tool Box',
'DKS',
'14'
],
[
'CGI::FormBuilder',
'M',
'm',
'p',
'O',
'p',
'Easily generate and process stateful forms',
'NWIGER',
'15'
],
[
'Image::Dot',
'R',
'd',
'p',
'f',
'p',
'create 1x1 pixel image files (pure-perl)',
'RGIERSIG',
'18'
],
[
'Tk::IPEntry',
'b',
'd',
'p',
'O',
'p',
'A megawidget for input of IP-Adresses',
'XPIX',
'8'
],
[
'Tk::MinMaxScale',
'R',
'd',
'p',
'O',
'p',
'Two Scale(s) to get a (min, max) values pair',
'JPVIDAL',
'8'
],
[
'Debug::Trace',
'R',
'd',
'p',
'n',
'p',
'Trace subroutine calls',
'JV',
'3'
],
[
'Bio::MAGE',
'R',
'm',
'p',
'O',
'b',
'microarray gene expression (MAGE) API',
'JASONS',
'23'
],
[
'Math::Random::TT800',
'R',
'd',
'c',
'O',
'p',
'TT800 random number generator (C version)',
'LENDL',
'6'
],
[
'Mail::Sort',
'b',
'd',
'p',
'O',
'g',
'Yet another procmail alike for to split mail',
'THEDEVIL',
'19'
],
[
'Math::Evol',
'b',
'd',
'p',
'f',
'p',
'Evolution Search Optimisation',
'PJB',
'6'
],
[
'Net::DNS::Zone',
'c',
'd',
'p',
'O',
'd',
'DNS Zone file parser, database and signer.',
'OLAF',
'5'
],
[
'Math::ErrorPropagation',
'b',
'd',
'p',
'O',
'p',
'Error of a function of statistical data',
'ZBYS',
'6'
],
[
'Time::JulianDateTime',
'a',
'd',
'p',
'f',
'p',
'Julian Date System w/Time Conversions',
'AQUACADE',
'6'
],
[
'Cisco::IPPhone',
'a',
'd',
'p',
'O',
'p',
'Cisco IP Phone interface using XML Objects',
'MRPALMER',
'23'
],
[
'Filesys::SmbClient',
'R',
'd',
'h',
'O',
'p',
'Provide Perl API for libsmbclient.so',
'ALIAN',
'10'
],
[
'MLDBM::TinyDB',
'b',
'd',
'p',
'O',
'p',
'more-than-flatfile-database',
'DADAMK',
'7'
],
[
'XML::Mini',
'b',
'd',
'p',
'O',
'g',
'pure perl API to create and parse XML',
'PDEEGAN',
'11'
],
[
'Remedy::ARSTools',
'b',
'd',
'p',
'O',
'p',
'Alternative object interface to ARSperl',
'AHICOX',
'23'
],
[
'Geo::Coordinates::UTM',
'R',
'd',
'p',
'f',
'p',
'Translation between  Lat Lon and UTM Coords',
'GRAHAMC',
'23'
],
[
'Variable::Alias',
'b',
'd',
'p',
'f',
'p',
'Make any variable an alias of another',
'BRENTDAX',
'3'
],
[
'DBIx::XML::DataLoader',
'b',
'n',
'p',
'O',
'p',
'load data from xml document into DB',
'CBERNING',
'7'
],
[
'Apache::ChildExit',
'R',
'd',
'p',
'f',
'p',
'alt Apache::Registry END block handler',
'TQISJIM',
'15'
],
[
'Win32::Daemon::Simple',
'b',
'd',
'p',
'r',
'p',
'simplify creating windows services',
'JENDA',
'22'
],
[
'Verilog::CodeGen',
'R',
'd',
'p',
'h',
'p',
'Object-oriented Verilog code generator',
'WVDB',
'9'
],
[
'Apache::GeoIP',
'a',
'd',
'c',
'O',
'p',
'Look up country by IP address',
'RKOBES',
'15'
],
[
'Image::Maps::Plot::FromPostcode',
'M',
'd',
'p',
'O',
'p',
'Plot various maps from postal codes',
'LGODDARD',
'18'
],
[
'Image::Thumbnail',
'M',
'd',
'p',
'O',
'p',
'Thumbnail images from GD or ImageMagick',
'LGODDARD',
'18'
],
[
'Solaris::PerlGcc',
'b',
'm',
'p',
'n',
'a',
'Build modules agaist Solaris perl using gcc',
'SUNCPAN',
'4'
],
[
'PPM::Make',
'b',
'd',
'p',
'O',
'p',
'Make a PPM package from a CPAN distribution',
'RKOBES',
'17'
],
[
'Mac::Carbon',
'a',
'm',
'c',
'h',
'p',
'Mac OS Carbon API',
'CNANDOR',
'4'
],
[
'Mac::Notification',
'R',
'm',
'c',
'h',
'p',
'Notification Manager',
'CNANDOR',
'4'
],
[
'Mac::Sound',
'R',
'm',
'c',
'h',
'p',
'Sound Manager',
'CNANDOR',
'4'
],
[
'Mac::Speech',
'R',
'm',
'c',
'h',
'p',
'Speech Manager',
'CNANDOR',
'4'
],
[
'XML::RSS',
'R',
'd',
'p',
'O',
'p',
'Parse or create Rich Site Summaries (RSS)',
'ABH',
'11'
],
[
'Convert::yEnc',
'a',
'd',
'p',
'O',
'p',
'yEnc decoder, with database of file parts',
'SWMCD',
'17'
],
[
'Devel::LeakTrace',
'b',
'd',
'h',
'n',
'p',
'indicates where variables are leaking from',
'RCLAMP',
'3'
],
[
'Biblio::Thesaurus',
'M',
'm',
'p',
'O',
'g',
'A Multi-Lingue Thesaurus tool;',
'AMBS',
'11'
],
[
'Test::Version',
'a',
'd',
'p',
'f',
'p',
'check for VERSION information in modules',
'PARTICLE',
'3'
],
[
'Tie::PerfectHash',
'R',
'u',
'p',
'h',
'p',
'Minimal Perfect Hash',
'XERN',
'6'
],
[
'Bundle::BDFOY',
'R',
'd',
'p',
'n',
'p',
'bundle for all modules by brian d foy',
'BDFOY',
'25'
],
[
'Tk::Wizard',
'a',
'd',
'p',
'O',
'p',
'Widget for step-by-step process',
'LGODDARD',
'8'
],
[
'HTML::BarChart',
'b',
'd',
'p',
'O',
'p',
'Framework for Rendering HTML Bar Charts',
'TAG',
'15'
],
[
'HTML::BarGraph',
'b',
'd',
'p',
'f',
'p',
'generate multiset bar graphs with plain HTML',
'PODGURSV',
'15'
],
[
'Tk::CursorControl',
'R',
'd',
'p',
'O',
'p',
'Manipulate the mouse cursor programmatically',
'DUNNIGANJ',
'8'
],
[
'Bundle::Test',
'R',
'd',
'h',
'h',
'p',
'group of modules used to build test',
'SZABGAB',
'25'
],
[
'Bundle::SSH',
'R',
'd',
'h',
'O',
'p',
'Install modules to use SSH from Perl',
'SZABGAB',
'25'
],
[
'Term::Twiddle',
'R',
'd',
'p',
'O',
'p',
'twiddles baton while-u-wait for long subrout',
'SCOTTW',
'8'
],
[
'Mail::Procmailrc',
'R',
'd',
'p',
'O',
'p',
'(OO) read/write/parse procmail(1) rc files',
'SCOTTW',
'19'
],
[
'Config::Properties',
'M',
'd',
'p',
'O',
'p',
'Configuration using Java style properties',
'SALVA',
'12'
],
[
'HTTP::Cookies::Mozilla',
'b',
'd',
'p',
'O',
'g',
'work with the Mozilla cookies.txt file',
'BDFOY',
'15'
],
[
'HTTP::Cookies::Omniweb',
'b',
'd',
'p',
'O',
'p',
'work with the OmniWeb cookies.xml file',
'BDFOY',
'15'
],
[
'Text::ASCIITable',
'R',
'd',
'p',
'O',
'p',
'Prints a \'ASCII-art\' formatted table',
'LUNATIC',
'11'
],
[
'Lingua::EN::Namegame',
'b',
'd',
'p',
'h',
'p',
'Converts name to verse as in  Name Game song',
'YUMPY',
'11'
],
[
'Tern::Size::Heuristic',
'b',
'd',
'p',
'f',
'p',
'Guesses terminal size in difficult cases',
'YUMPY',
'5'
],
[
'Term::Size::Heuristic',
'b',
'd',
'p',
'f',
'p',
'Guesses terminal size in difficult cases',
'YUMPY',
'5'
],
[
'File::Find::Rule::XPath',
'R',
'd',
'p',
'h',
'p',
'Find files by XPath expression',
'GRANTM',
'10'
],
[
'Math::XOR',
'R',
'd',
'c',
'f',
'p',
'Package to handle XOR encryption of string b',
'CRAKRJACK',
'14'
],
[
'Win32::Console::ANSI',
'b',
'd',
'c',
'p',
'p',
'Emulate ANSI console on Win32 system',
'JLMOREL',
'22'
],
[
'Text::Orientation',
'b',
'u',
'p',
'O',
'p',
'Text Rotator',
'XERN',
'11'
],
[
'Term::ScreenColor',
'b',
'd',
'p',
'O',
'p',
'terminal control + ANSI color support',
'RUITTENB',
'8'
],
[
'Math::Quaternion',
'b',
'd',
'p',
'O',
'p',
'handling of quaternions and rotations',
'JCHIN',
'6'
],
[
'PHP::Include',
'b',
'd',
'p',
'h',
'p',
'Include PHP files from Perl',
'ESUMMERS',
'11'
],
[
'CGI::Application::PhotoGallery',
'b',
'd',
'p',
'O',
'p',
'module to provide a simple photo gallery',
'BRICAS',
'15'
],
[
'Ogg::Vorbis::Header',
'a',
'd',
'c',
'O',
'g',
'View Vorbis info & comments; edit comments',
'DBP',
'23'
],
[
'Mail::Box::Parser::C',
'b',
'm',
'c',
'O',
'p',
'extends Mail::Box with the speed of C',
'MARKOV',
'19'
],
[
'Algorithm::Merge',
'b',
'd',
'p',
'f',
'p',
'Implements 3-way merge and diff algorithms',
'JSMITH',
'6'
],
[
'Games::Crosswords',
'a',
'u',
'p',
'O',
'p',
'Crosswords Game',
'XERN',
'23'
],
[
'Acme::Playmate',
'a',
'd',
'p',
'O',
'g',
'A object-oriented interface to playboy.com',
'ODEZWART',
'15'
],
[
'PHP::Session',
'R',
'd',
'p',
'O',
'p',
'read / write PHP session files',
'MIYAGAWA',
'11'
],
[
'Readonly',
'R',
'd',
'p',
'r',
'p',
'Create read-only scalars, arrays, hashes.',
'ROODE',
'6'
],
[
'HTTP::Cookies::Safari',
'b',
'd',
'p',
'O',
'p',
'work with Apple Safari cookie files',
'BDFOY',
'15'
],
[
'Term::EditLine',
'b',
'd',
'c',
'O',
'l',
'Perl interface to the NetBSD editline lib',
'PHINYX',
'8'
],
[
'HTTP::Cookies::iCab',
'b',
'd',
'p',
'O',
'p',
'work with iCab cookies',
'BDFOY',
'15'
],
[
'Simulation::Automate',
'a',
'd',
'p',
'f',
'p',
'A Simulation Automation Tool',
'WVDB',
'23'
],
[
'Devel::FindGlobals',
'a',
'd',
'p',
'f',
'p',
'Find global variables and their size',
'CNANDOR',
'3'
],
[
'Mail::Transport::Dbx',
'b',
'd',
'c',
'O',
'p',
'Parse Outlook Express mailboxes',
'VPARSEVAL',
'19'
],
[
'CGI::Echo',
'M',
'd',
'p',
'O',
'o',
'Echo form data to test form design',
'RSAVAGE',
'15'
],
[
'CGI::Explorer',
'M',
'd',
'p',
'O',
'o',
'A CGI support module for trees',
'RSAVAGE',
'15'
],
[
'DBIx::Hash2Table',
'M',
'd',
'p',
'O',
'o',
'Save a hash into a database table',
'RSAVAGE',
'7'
],
[
'DBIx::HTML::ClientDB',
'M',
'd',
'p',
'O',
'o',
'Convert SQL into a JavaScript database',
'RSAVAGE',
'7'
],
[
'DBIx::HTML::LinkedMenus',
'M',
'd',
'p',
'O',
'o',
'Convert db data to 2 linked HTML popup menus',
'RSAVAGE',
'7'
],
[
'DBIx::HTML::PopupRadio',
'M',
'd',
'p',
'O',
'o',
'Convert db data to popup menu or radio group',
'RSAVAGE',
'7'
],
[
'DBIx::Table2Hash',
'M',
'd',
'p',
'O',
'o',
'Read a database table into a hash',
'RSAVAGE',
'7'
],
[
'DBIx::MSSQLReporter',
'M',
'd',
'p',
'O',
'o',
'Interface to MS SQL Server & MS Data Engine',
'RSAVAGE',
'7'
],
[
'Module::MakeDist',
'M',
'd',
'p',
'O',
'o',
'Convert module into distros (*.tgz, *.zip)',
'RSAVAGE',
'2'
],
[
'DNS::Config',
'b',
'd',
'p',
'O',
'p',
'Generic config with specific file adaptor',
'WOLF',
'5'
],
[
'DNS::Zone',
'R',
'd',
'p',
'O',
'p',
'Generic zone with specific file adaptors',
'WOLF',
'5'
],
[
'MMDS',
'M',
'd',
'p',
'h',
'p',
'Minimal Markup Document System',
'JV',
'11'
],
[
'Tibco::Rv',
'R',
'd',
'c',
'O',
'p',
'Perl bindings for TIBCO TIB/Rendezvous',
'STURM',
'24'
],
[
'SOAP::Clean',
'a',
'd',
'p',
'O',
'd',
'For exposing legacy appls as web services',
'STODGHIL',
'5'
],
[
'Apache::FakeCookie',
'R',
'd',
'p',
'O',
'g',
'fake request object for debugging',
'MIKER',
'15'
],
[
'Curses::Application',
'a',
'm',
'p',
'O',
'p',
'Application UI framework for Curses',
'CORLISS',
'8'
],
[
'PHP::MySQL_Session',
'a',
'd',
'p',
'O',
'p',
'read / write PHP session data from MySQL',
'CARCUS',
'11'
],
[
'Rosetta',
'a',
'd',
'p',
'O',
'g',
'Rigorous database portability',
'DUNCAND',
'7'
],
[
'Lingua::TH::Segmentation',
'R',
'u',
'h',
'O',
'p',
'an XS interface to Thai word segment. Lib',
'ROMERUN',
'11'
],
[
'Sub::Regex',
'R',
'u',
'p',
'p',
'p',
'Creating Synonymous Subroutines',
'XERN',
'3'
],
[
'Geo::ShapeFile',
'R',
'd',
'p',
'O',
'p',
'GIS system shape file interface',
'JASONK',
'6'
],
[
'User::Identity',
'a',
'd',
'p',
'O',
'p',
'Define a person',
'MARKOV',
'12'
],
[
'Mail::Identity',
'c',
'm',
'p',
'O',
'p',
'E-mail address handling',
'MARKOV',
'19'
],
[
'Class::Prevayler',
'b',
'd',
'p',
'O',
'a',
'prl-implementation of the prevayler-concept',
'NATHANAEL',
'6'
],
[
'Lingua::GL::Stemmer',
'a',
'u',
'p',
'f',
'p',
'Galician language stemming',
'XERN',
'11'
],
[
'Lingua::PT::Stemmer',
'a',
'u',
'p',
'f',
'p',
'Portuguese language stemming',
'XERN',
'11'
],
[
'UML::Sequence',
'b',
'd',
'p',
'O',
'p',
'draws sequence diagrams by running the code',
'PHILCROW',
'18'
],
[
'MP3::ID3Lib',
'R',
'd',
'?',
'O',
'p',
'ID3v1/ID3v2 Tagging of MP3 files',
'LBROCARD',
'23'
],
[
'DateTime',
'b',
'm',
'p',
'O',
'p',
'A complete, easy to use date and time object',
'DROLSKY',
'6'
],
[
'Lingua::Lexicon::IDP',
'R',
'd',
'p',
'O',
'p',
'OOP methods for Internet Dictionary Project',
'ASCOPE',
'11'
],
[
'Tk::GraphViz',
'b',
'd',
'p',
'O',
'p',
'Render an interactive GraphViz graph',
'JGS',
'8'
],
[
'Class::EHierarchy',
'b',
'd',
'p',
'O',
'g',
'Base class aggregating several OO aspects',
'CORLISS',
'6'
],
[
'Tk::MatchEntry',
'R',
'm',
'p',
'O',
'p',
'Entry widget with advanced auto-completion',
'WHOM',
'8'
],
[
'SWIFT::Factory::MT300',
'c',
'd',
'p',
'O',
'p',
'Provides an MT300 SWIFT message',
'BIKER',
'24'
],
[
'Statistics::PointEstimation',
'b',
'm',
'p',
'O',
'o',
'module to compute the confidence interval',
'YUNFANG',
'6'
],
[
'Statistics::TTest',
'b',
'm',
'p',
'O',
'o',
'module to perform stat T-test',
'YUNFANG',
'6'
],
[
'Wx::ActiveX',
'R',
'd',
'+',
'O',
'g',
'ActiveX controls, IE & Flash for Wx.',
'GMPASSOS',
'8'
],
[
'Tie::RemoteVar',
'a',
'u',
'p',
'r',
'p',
'Share variables everywhere',
'XERN',
'6'
],
[
'Attribute::Property',
'R',
'n',
'p',
'n',
'n',
'Lvalue methods with value validation',
'JUERD',
'2'
],
[
'Language::XSB',
'b',
'd',
'h',
'f',
'p',
'Interface to XSB programming language',
'SALVA',
'9'
],
[
'Language::Prolog::Yaswi',
'b',
'd',
'c',
'f',
'p',
'Yet another interface to SWI-Prolog',
'SALVA',
'9'
],
[
'Language::Prolog::Types',
'b',
'd',
'p',
'h',
'p',
'Prolog types in Perl.',
'SALVA',
'9'
],
[
'Language::Prolog::Sugar',
'R',
'd',
'p',
'p',
'p',
'Syntactic sugar for Prolog term constructors',
'SALVA',
'9'
],
[
'Net::Whois::IP',
'b',
'd',
'p',
'p',
'p',
'IP whois information lookup',
'BSCHMITZ',
'5'
],
[
'POE::Session::GladeXML',
'a',
'd',
'p',
'O',
'g',
'connects Gtk::GladeXML and POE::Session',
'MARTIJN',
'8'
],
[
'Net::EMI::Client',
'R',
'd',
'p',
'O',
'p',
'Provide a Client to send SMS msgs to an SMSC',
'SCHAFFTER',
'5'
],
[
'SWIFT::Factory::BasicHeader',
'b',
'd',
'p',
'O',
'p',
'Provides the Basic Header Block 1 for SWIFT',
'BIKER',
'24'
],
[
'Linksys::Config',
'b',
'd',
'p',
'O',
'g',
'Object to Configure Linksys SOHO Units',
'JTAVARES',
'23'
],
[
'BerkeleyDB::Lite',
'b',
'd',
'p',
'r',
'p',
'Simplified Access to BerkeleyDB Methods',
'TQISJIM',
'7'
],
[
'SWIFT::Factory::ApplicationHeader',
'b',
'd',
'p',
'O',
'p',
'Provides the Appl. Header Block 2 for SWIFT',
'BIKER',
'24'
],
[
'SWIFT::Factory::Tag::Tag15',
'b',
'd',
'p',
'O',
'p',
'Provides a generic TAG15 for SWIFT',
'BIKER',
'24'
],
[
'Chipcard::CTAPI',
'R',
'd',
'h',
'O',
'p',
'Communication with chipcard terminals',
'WHOM',
'4'
],
[
'HTML::Info',
'a',
'd',
'p',
'O',
'l',
'Summarize the structure of an HTML file',
'JPOWERS',
'15'
],
[
'Net::EMI::Common',
'R',
'd',
'p',
'O',
'p',
'Common routines for EMI clients and servers',
'SCHAFFTER',
'5'
],
[
'Acme::Test::Weather',
'i',
'd',
'p',
'f',
'p',
'Test weather conditions on install',
'ASCOPE',
'15'
],
[
'Win32::SoundRec',
'a',
'd',
'p',
'O',
'p',
'Record audio on Win32 platforms',
'JOUKE',
'22'
],
[
'Geo::CountryFlags',
'R',
'd',
'p',
'O',
'g',
'Ctry code to flag.gif from pub domain or dir',
'MIKER',
'23'
],
[
'Geo::Distance',
'M',
'd',
'p',
'O',
'p',
'Calculate Distances and Closest Locations',
'BLUEFEET',
'23'
],
[
'SWIFT::Factory::Tag::Tag30',
'b',
'd',
'p',
'O',
'p',
'Provide a TAG30 for a SWIFT message',
'BIKER',
'24'
],
[
'SWIFT::Factory::Tag::Tag20',
'b',
'd',
'p',
'O',
'p',
'Provides TAG20 for a SWIFT message',
'BIKER',
'24'
],
[
'ExtUtils::ParseXS',
'R',
'd',
'p',
'f',
'p',
'Converts Perl XS code into C code',
'KWILLIAMS',
'3'
],
[
'Module::Build',
'b',
'd',
'p',
'O',
'p',
'Build, test, and install Perl modules',
'KWILLIAMS',
'2'
],
[
'SWIFT::Factory::Tag::Tag21',
'b',
'd',
'p',
'O',
'p',
'Provide a TAG21 for a SWIFT message',
'BIKER',
'24'
],
[
'SWIFT::Factory::Tag::Tag30T',
'b',
'd',
'p',
'O',
'p',
'Provides a TAG30T for a SWIFT message',
'BIKER',
'24'
],
[
'Image::Maps::Plot::FromLatLong',
'R',
'd',
'p',
'O',
'p',
'Plot latitude/longitude points on JPEG maps',
'LGODDARD',
'18'
],
[
'MP3::M3U::Parser',
'R',
'd',
'p',
'O',
'p',
'MP3 playlist parser',
'BURAK',
'11'
],
[
'Geography::Countries::LatLong',
'R',
'd',
'p',
'f',
'p',
'List of mean latidue and longitude',
'LGODDARD',
'23'
],
[
'MasonX::Resolver::PAR',
'b',
'd',
'p',
'O',
'p',
'HTML::Mason Resolver for PAR Archives',
'MRAMBERG',
'15'
],
[
'SWIFT::Factory::Tag::Tag30V',
'b',
'd',
'p',
'O',
'p',
'Provides a TAG30V for SWIFT',
'BIKER',
'24'
],
[
'SQL::Translator',
'R',
'm',
'p',
'O',
'g',
'Convert RDBMS SQL CREATE syntax.',
'KCLARK',
'11'
],
[
'WWW::ShopBot',
'a',
'u',
'p',
'O',
'p',
'General framework for shopping bots',
'XERN',
'15'
],
[
'Lingua::Stem::Snowball::Da',
'R',
'd',
'p',
'O',
'g',
'Stemming algorithm for Danish',
'CINE',
'11'
],
[
'Games::Object',
'a',
'd',
'p',
'O',
'p',
'Provide a base class for game objects',
'PSTEWART',
'23'
],
[
'Parse::PlainConfig',
'M',
'd',
'p',
'O',
'g',
'Human-readable config file parser/generator',
'CORLISS',
'11'
],
[
'CGI::Lite',
'R',
'd',
'p',
'h',
'?',
'Process and decode WWW forms and cookies',
'SMYLERS',
'15'
],
[
'SimpleCDB',
'R',
'a',
'p',
'O',
'?',
'Perl-only Constant Database',
'BENL',
'2'
],
[
'RTF::Reader',
'i',
'd',
'p',
'O',
'a',
'Implements an RTF reader as per RTF Spec 1.7',
'SARGIE',
'11'
],
[
'WebSphere::Payment',
'R',
'd',
'p',
'O',
'p',
'Interface to IBM WebSphere Payment Manager',
'LEMP',
'24'
],
[
'SWIFT::Factory::Tag::Tag17',
'a',
'd',
'p',
'O',
'p',
'Provide a base class for the Tag17x classes',
'BIKER',
'24'
],
[
'SWIFT::Factory::Tag::Tag17A',
'a',
'd',
'p',
'O',
'p',
'Provide a TAG17A for a SWIFT message',
'BIKER',
'24'
],
[
'SWIFT::Factory::Tag::Tag17T',
'a',
'd',
'p',
'O',
'p',
'Provide a TAG17T for a SWIFT message',
'BIKER',
'24'
],
[
'SWIFT::Factory::Tag::Tag17U',
'a',
'd',
'p',
'O',
'p',
'Provide a TAG17U for a SWIFT message',
'BIKER',
'24'
],
[
'Proc::ParallelLoop',
'b',
'd',
'p',
'f',
'p',
'Execute loops in parallel',
'BDARRAH',
'4'
],
[
'Term::Visual',
'b',
'd',
'p',
'O',
'a',
'Curses interface with POE for multitasking',
'LUNARTEAR',
'8'
],
[
'AI::NeuralNet::Kohonen',
'R',
'd',
'p',
'O',
'p',
'Kohonen\'s Self-organising Feature Maps (SOM)',
'LGODDARD',
'23'
],
[
'POE::Component::Client::HTTP',
'b',
'm',
'p',
'O',
'p',
'non-blocking/parallel web requests engine',
'RCAPUTO',
'15'
],
[
'Proc::Reliable',
'R',
'd',
'p',
'O',
'p',
'Easy, reliable managed process execution',
'DGOLD',
'4'
],
[
'Apache::AuthChecker',
'b',
'd',
'p',
'f',
'g',
'Apache module to prevent password attacks',
'SWAMPFOX',
'15'
],
[
'Business::WorldPay::Junior',
'M',
'd',
'p',
'O',
'g',
'Interface to use WorldPay\'s Junior service.',
'CLIFFORDJ',
'23'
],
[
'Sun::Solaris::Task',
'M',
'm',
'c',
'f',
'a',
'Access Solaris Tasks',
'SUNCPAN',
'4'
],
[
'Sun::Solaris::Project',
'M',
'm',
'c',
'f',
'a',
'Access Solaris Projects',
'SUNCPAN',
'4'
],
[
'Sun::Solaris::Exacct',
'M',
'm',
'c',
'h',
'a',
'Access Solaris Extended Accounting',
'SUNCPAN',
'4'
],
[
'Finance::Bank::CreateCard',
'R',
'd',
'p',
'O',
'p',
'CreateCard online banking access from perl',
'RMCKAY',
'23'
],
[
'Physics::Unit',
'R',
'd',
'p',
'O',
'p',
'Manipulate physics units and dimensions.',
'KLORTHO',
'23'
],
[
'HTML::Tabulate',
'R',
'd',
'p',
'O',
'p',
'Render datasets as HTML tables',
'GAVINC',
'15'
],
[
'POEST::Server',
'c',
'd',
'p',
'O',
'p',
'POE Based SMTP Server with Plugin Support',
'CWEST',
'16'
],
[
'Widget::FixedWidthFont::Input',
'b',
'm',
'p',
'O',
'g',
'Widget backend for storing/manipulating text',
'CORLISS',
'8'
],
[
'Cartography::Projection::GCTP',
'b',
'd',
'c',
'f',
'p',
'XS interface for GCTP map projection library',
'DSTAHLKE',
'23'
],
[
'Compress::PPMd',
'b',
'd',
'+',
'O',
'p',
'Interface to PPMd compression library',
'SALVA',
'17'
],
[
'PAR',
'R',
'm',
'h',
'O',
'p',
'Perl Archive Toolkit',
'AUTRIJUS',
'3'
],
[
'DB2::db',
'R',
'd',
'p',
'O',
'p',
'Framework for creating/using IBM DB2',
'DMCBRIDE',
'7'
],
[
'Locale::Maketext::Lexicon',
'R',
'd',
'p',
'p',
'p',
'Use other catalog formats in Maketext',
'AUTRIJUS',
'13'
],
[
'Data::Binder',
'b',
'd',
'p',
'O',
'p',
'map of key-values for simple unification',
'HALLEY',
'6'
],
[
'MasonX::Resolver::CVS',
'R',
'd',
'p',
'O',
'b',
'retrieve components from CVS',
'KORTY',
'15'
],
[
'Class::DBI::Oracle',
'b',
'd',
'p',
'O',
'p',
'Class::DBI extension for Oracle',
'DANIEL',
'6'
],
[
'Algorithm::Cluster',
'R',
'd',
'h',
'f',
'g',
'Perl extension for the C clustering library',
'JNOLAN',
'6'
],
[
'Convert::CharMap',
'a',
'm',
'p',
'O',
'p',
'Conversion between Unicode Character Maps',
'AUTRIJUS',
'11'
],
[
'Devel::Hints',
'R',
'd',
'p',
'f',
'p',
'Access compile-time hints at runtime',
'AUTRIJUS',
'3'
],
[
'Encode::compat',
'R',
'm',
'p',
'f',
'p',
'Encode.pm emulation layer',
'AUTRIJUS',
'13'
],
[
'Encode::HanConvert',
'M',
'd',
'p',
'h',
'p',
'Traditional and Simplified Chinese mappings',
'AUTRIJUS',
'13'
],
[
'Encode::HanExtra',
'R',
'm',
'c',
'p',
'p',
'Extra sets of Chinese encodings',
'AUTRIJUS',
'13'
],
[
'Encode::HanDetect',
'b',
'd',
'p',
'p',
'p',
'Cross-encoding/variant Chinese decoder',
'AUTRIJUS',
'13'
],
[
'ExtUtils::AutoInstall',
'R',
'd',
'p',
'h',
'p',
'Automatic install of dependencies via CPAN',
'AUTRIJUS',
'3'
],
[
'HTML::FromANSI',
'R',
'd',
'p',
'f',
'p',
'Mark up ANSI sequences as HTML',
'AUTRIJUS',
'15'
],
[
'Lingua::ZH::HanDetect',
'b',
'd',
'p',
'f',
'p',
'Guess Chinese text\'s variant and encoding',
'AUTRIJUS',
'11'
],
[
'Lingua::ZH::Keywords',
'b',
'd',
'p',
'f',
'p',
'Extract keywords from Chinese text',
'AUTRIJUS',
'11'
],
[
'Lingua::ZH::Numbers',
'R',
'd',
'p',
'f',
'p',
'Converts numeric values into Chinese',
'AUTRIJUS',
'11'
],
[
'Lingua::ZH::Summarize',
'b',
'd',
'p',
'f',
'p',
'Summarizing bodies of Chinese text',
'AUTRIJUS',
'11'
],
[
'Lingua::ZH::TaBE',
'R',
'd',
'c',
'h',
'p',
'Chinese processing via libtabe',
'AUTRIJUS',
'11'
],
[
'Lingua::ZH::Toke',
'b',
'd',
'p',
'r',
'p',
'Chinese Tokenizer',
'AUTRIJUS',
'11'
],
[
'Lingua::ZH::Wrap',
'a',
'd',
'p',
'f',
'p',
'Wrap Chinese text',
'AUTRIJUS',
'11'
],
[
'Locale::Maketext::Fuzzy',
'?',
'd',
'p',
'O',
'p',
'Maketext from already interpolated strings',
'AUTRIJUS',
'13'
],
[
'Module::ScanDeps',
'R',
'm',
'p',
'h',
'p',
'Recursively scan Perl code for dependencies',
'AUTRIJUS',
'2'
],
[
'Unicode::EastAsianWidth',
'M',
'd',
'p',
'p',
'p',
'East Asian Width properties',
'AUTRIJUS',
'13'
],
[
'WWW::SherlockSearch',
'R',
'd',
'p',
'O',
'p',
'Parse and execute Apple Sherlock 2 plugins',
'AUTRIJUS',
'15'
],
[
'GD::Graph3d',
'M',
'd',
'p',
'O',
'p',
'Create 3d extrusion charts using GD',
'WADG',
'18'
],
[
'OurNet::FuzzyIndex',
'R',
'm',
'p',
'f',
'p',
'Inverted search for double-byte characters',
'AUTRIJUS',
'11'
],
[
'Search::FreeText',
'b',
'd',
'p',
'O',
'p',
'Free text indexing using BM25',
'SNKWATT',
'11'
],
[
'Lingua::ZH::PinyinConvert',
'R',
'u',
'p',
'f',
'p',
'Chinese Pinyin System Translation',
'XERN',
'11'
],
[
'CAD::ProEngineer',
'c',
'd',
'c',
'O',
'p',
'Perl Interface to Pro/Engineer API',
'MMETTES',
'24'
],
[
'B::Deobfuscate',
'a',
'd',
'p',
'O',
'g',
'Deobfuscation support utility',
'JJORE',
'2'
],
[
'Math::MagicSquare::Generator',
'R',
'n',
'p',
'O',
'n',
'Magic Square Generator',
'JUERD',
'6'
],
[
'Math::Calc::Euro',
'R',
'n',
'p',
'O',
'n',
'Convert between EUR and the old currencies',
'JUERD',
'6'
],
[
'Crypt::Caesar',
'R',
'n',
'p',
'f',
'n',
'Decrypt rot-N strings',
'JUERD',
'14'
],
[
'DBIx::Simple',
'R',
'd',
'p',
'O',
'n',
'Easy-to-use OO interface to DBI',
'JUERD',
'7'
],
[
'Lingua::EO::Supersignoj',
'b',
'd',
'p',
'O',
'n',
'Convert Esperanto characters',
'JUERD',
'11'
],
[
'B::Keywords',
'b',
'd',
'p',
'n',
'p',
'Lists of reserved barewords and symbol names',
'JJORE',
'2'
],
[
'Math::Project3D',
'M',
'd',
'p',
'O',
'p',
'Project vectorial function from 3D to plane',
'SMUELLER',
'6'
],
[
'Math::Project3D::Plot',
'M',
'd',
'p',
'O',
'p',
'Plot projections of 3D functions with Imager',
'SMUELLER',
'6'
],
[
'Acme::Chef',
'R',
'd',
'p',
'O',
'p',
'Interpreter for Chef programming language',
'SMUELLER',
'9'
],
[
'Physics::Particles',
'R',
'd',
'p',
'O',
'p',
'Simulate particle dynamics',
'SMUELLER',
'23'
],
[
'HPUX::SDUX',
'a',
'n',
'p',
'f',
'p',
'Helps Perl module management via SD-UX',
'ASARIH',
'4'
],
[
'Tk::Task',
'R',
'd',
'p',
'O',
'p',
'Repetitive background tasks in Tk',
'KVAIL',
'8'
],
[
'Tk::autobind',
'R',
'd',
'p',
'O',
'p',
'Automatic ALT-key bindings for Tk widgets',
'KVAIL',
'8'
],
[
'Tk::Stderr',
'R',
'd',
'p',
'h',
'p',
'capture STDERR into separate window',
'KVAIL',
'8'
],
[
'IBM::LoadLeveler',
'R',
'd',
'c',
'f',
'p',
'Interface to IBM LoadLeveler Job Scheduler',
'HAWKINSM',
'24'
],
[
'Mail::GnuPG',
'b',
'd',
'p',
'O',
'p',
'MIME Email <-> GnuPG::Interface interface',
'RSPIER',
'19'
],
[
'Tie::Tk::Listbox',
'R',
'd',
'p',
'r',
'p',
'Access Tk::Listbox widgets et al as arrays',
'SMUELLER',
'8'
],
[
'POE::Component::Daemon::Win32',
'a',
'd',
'p',
'O',
'p',
'POE interface to Win32::Daemon',
'PGUZIS',
'16'
],
[
'OODoc',
'b',
'd',
'p',
'O',
'p',
'Object Oriented documentation generator',
'MARKOV',
'26'
],
[
'Class::XPath',
'a',
'd',
'p',
'O',
'p',
'adds xpath matching to object trees',
'SAMTREGAR',
'6'
],
[
'Test::FIT',
'a',
'd',
'p',
'O',
'p',
'FIT graphical test framework for Perl',
'INGY',
'3'
],
[
'Module::Install',
'a',
'd',
'p',
'O',
'p',
'Standalone, extensible Perl module installer',
'AUTRIJUS',
'2'
],
[
'Module::Test',
'c',
'd',
'p',
'O',
'p',
'Autobundling, extensible framework for tests',
'INGY',
'2'
],
[
'Exporter::Tidy',
'R',
'd',
'p',
'p',
'n',
'Another way of exporting symbols',
'JUERD',
'2'
],
[
'Module::Include',
'c',
'd',
'p',
'O',
'p',
'Powerful #include templates for Perl code',
'INGY',
'2'
],
[
'DBIx::Informix::Perform',
'b',
'd',
'p',
'h',
'a',
'Informix Perform character DB form emulator',
'WEAV',
'7'
],
[
'Text::Flowchart::Script',
'a',
'u',
'p',
'O',
'p',
'Scripting language for Text::Flowchart',
'XERN',
'11'
],
[
'DateTime::Event::Easter',
'R',
'm',
'p',
'O',
'p',
'Returns Easter events for DateTime objects',
'RICKM',
'6'
],
[
'Data::Favorites',
'R',
'd',
'p',
'O',
'p',
'tally a stream for recently dominant items',
'HALLEY',
'6'
],
[
'CGI::Kwiki',
'c',
'd',
'p',
'O',
'p',
'A Quickie Wiki that\'s not too Tricky',
'INGY',
'15'
],
[
'Win32::MSI',
'b',
'd',
'p',
'O',
'g',
'A database-interface for Windows MSI-Files',
'PMAREK',
'22'
],
[
'Astro::Constants',
'a',
'd',
'p',
'f',
'p',
'Physical constants used in Astronomy',
'DUFFEE',
'23'
],
[
'DBD::Google',
'b',
'd',
'p',
'O',
'p',
'Treat Google as a DBI datasource',
'DARREN',
'7'
],
[
'WWW::SMS',
'S',
'm',
'p',
'h',
'g',
'A Perl framework for sending SMS messages',
'EIM',
'15'
],
[
'HTTP::DAVServer',
'a',
'd',
'p',
'O',
'p',
'responde to WebDAV requests',
'JLAWRENC',
'15'
],
[
'BerkeleyDB::Locks',
'b',
'd',
'h',
'O',
'p',
'Berkeley lock subsystem toolkit',
'TQISJIM',
'7'
],
[
'Linux::LVM',
'b',
'd',
'p',
'f',
'p',
'Linux Logical Volume Manager(LVM) Interface',
'CKERNER',
'4'
],
[
'WordNet::Similarity',
'b',
'd',
'p',
'O',
'g',
'WordNet-based semantic relatedness measures',
'SID',
'11'
],
[
'Linux::MemInfo',
'b',
'd',
'p',
'f',
'p',
'Easy interface into /proc/meminfo',
'CKERNER',
'4'
],
[
'Perl6::Classes',
'b',
'd',
'p',
'n',
'p',
'Perl 6 class syntax for Perl 5',
'LPALMER',
'28'
],
[
'DateTime::Calendar::Mayan',
'b',
'm',
'p',
'O',
'p',
'Mayan Long Count Calendar',
'JHOBLITT',
'6'
],
[
'Finance::Bank::DE::SpardaBank',
'R',
'd',
'p',
'O',
'p',
'Check your SpardaBank accounts with Perl',
'RMORIZ',
'23'
],
[
'HTTP::GetImages',
'M',
'd',
'p',
'O',
'p',
'Spider to scrape images from HTML pages',
'LGODDARD',
'15'
],
[
'DateTime::Format::Builder',
'R',
'm',
'p',
'h',
'p',
'Create DateTime parser classes and objects',
'DROLSKY',
'6'
],
[
'Data::FormValidator::Upload',
'a',
'm',
'p',
'O',
'p',
'Validate Uploads with Data::FormValidators',
'MARKSTOS',
'6'
],
[
'HTML::Diff',
'R',
'd',
'p',
'f',
'a',
'HTML-savvy diffs using regexen',
'EZRAKILTY',
'15'
],
[
'DBIx::FileSystem',
'b',
'd',
'p',
'f',
'g',
'manage tables like a filesystem',
'AFRIKA',
'7'
],
[
'Convert::Binary::C',
'b',
'm',
'c',
'O',
'p',
'Binary Data Conversion using C Types',
'MHX',
'17'
],
[
'Win32::RemoteTOD',
'b',
'd',
'c',
'f',
'p',
'Get the time/timezone of remote Win32 server',
'ARICH',
'22'
],
[
'Chart::Plot::Canvas',
'a',
'd',
'p',
'O',
'a',
'Plot two dimensional data in an Tk Canvas',
'PERRAD',
'18'
],
[
'PDF::Reuse',
'a',
'd',
'p',
'f',
'p',
'Reuse and mass produce PDF documents',
'LARSLUND',
'11'
],
[
'PDF::Reuse::Tutorial',
'a',
'd',
'o',
'n',
'p',
'How to produce documents with PDF::Reuse',
'LARSLUND',
'11'
],
[
'ePortal',
'R',
'd',
'p',
'O',
'o',
'ePortal project backend modules',
'RUSAKOV',
'15'
],
[
'Device::WxM2',
'b',
'd',
'p',
'O',
'g',
'Device driver - Davis Weather Mon. 2 station',
'MMABRY',
'4'
],
[
'Locale::Maketext::Gettext',
'R',
'd',
'p',
'O',
'p',
'Joins the gettext and Maketext frameworks',
'IMACAT',
'13'
],
[
'X::Osd',
'R',
'd',
'c',
'O',
'p',
'Perl glue to libxosd (X OnScreen Display)',
'GOZER',
'8'
],
[
'Search::ContextGraph',
'b',
'd',
'p',
'O',
'g',
'A generic contextual network search engine',
'MCEGLOWS',
'11'
],
[
'Apache::Test',
'S',
'm',
'p',
'h',
'o',
'Framework for testing Apache modules',
'APML',
'15'
],
[
'Cache::FastMemoryCache',
'b',
'd',
'p',
'O',
'o',
'In-memory cache plugin for Cache::Cache',
'MILLAWAY',
'17'
],
[
'Search::VectorSpace',
'b',
'd',
'p',
'O',
'p',
'Vector model search engine',
'MCEGLOWS',
'11'
],
[
'POE::Component::Client::TCPMulti',
'b',
'd',
'p',
'h',
'd',
'Light Multiple Socket Interface for POE',
'TAG',
'5'
],
[
'DateTime::Event::Cron',
'R',
'm',
'p',
'O',
'p',
'DateTime from cron listings',
'MSISK',
'6'
],
[
'Palm::Memo32',
'R',
'd',
'p',
'O',
'a',
'Read & Write Palm Memo32 (pn32) pdbs',
'WARTHURT',
'7'
],
[
'Finance::Shares::Chart',
'a',
'd',
'p',
'O',
'a',
'Display stock data, functions and tests',
'CPWILLMOT',
'23'
],
[
'Finance::Shares::MySQL',
'a',
'd',
'p',
'O',
'a',
'Interface to MySQL database holding quotes',
'CPWILLMOT',
'23'
],
[
'Finance::Bank::DE::NetBank',
'R',
'd',
'p',
'O',
'p',
'Check your NetBank Bank Accounts with Perl',
'RMORIZ',
'23'
],
[
'MusicBrainz::Client',
'R',
'm',
'c',
'O',
'a',
'MusicBrainz Client API',
'SVANZOEST',
'23'
],
[
'Win32::Exchange::Mailbox',
'R',
'd',
'p',
'O',
'p',
'Exchange Mailbox maintenance',
'SMANROSS',
'22'
],
[
'Win32::Exchange::SMTP::Security',
'b',
'd',
'p',
'O',
'p',
'Exchange SMTP access list maintenance',
'SMANROSS',
'22'
],
[
'WWW::Blog::Identify',
'R',
'd',
'p',
'O',
'g',
'Heuristics to identify weblogs from raw HTML',
'MCEGLOWS',
'15'
],
[
'Math::Matrix::SVD',
'b',
'd',
'c',
'f',
'p',
'calcuate singular value decomposition',
'MCEGLOWS',
'23'
],
[
'Shell::POSIX::Select',
'R',
'd',
'p',
'n',
'p',
'The POSIX Shell\'s "select" Loop for Perl',
'YUMPY',
'2'
],
[
'Synergy',
'b',
'd',
'p',
'O',
'g',
'Interface to Telelogic CM Synergy',
'HENKE',
'3'
],
[
'Math::Polyhedra',
'b',
'd',
'p',
'f',
'p',
'vertices, edges, faces of common polyhedra',
'HALLEY',
'6'
],
[
'Geo::Projection',
'b',
'd',
'h',
'O',
'p',
'Mapping latitude/longitude',
'THOSPEL',
'23'
],
[
'Regexp::Tr',
'R',
'd',
'p',
'O',
'g',
'Lightweight run-time tr/// operations',
'CHIA',
'11'
],
[
'Mariachi',
'a',
'm',
'p',
'O',
'p',
'Mariachi - all dancing mail archive generato',
'RCLAMP',
'19'
],
[
'DateTime::Format::Pg',
'b',
'd',
'p',
'O',
'p',
'Parse and format PostgreSQL dates and times',
'DMAKI',
'6'
],
[
'Games::Bingo',
'R',
'd',
'p',
'O',
'a',
'Implementation of the classical bingo game',
'JONASBN',
'23'
],
[
'Lexical::Typeglob',
'b',
'd',
'c',
'f',
'p',
'Like Symbol without a symbol table.',
'JJORE',
'6'
],
[
'Parse::Nessus::NBE',
'R',
'd',
'p',
'f',
'p',
'extract data from Nessus NBE files',
'DKYGER',
'11'
],
[
'Parse::Nessus::ENX',
'R',
'd',
'p',
'f',
'p',
'extract data from Extended NSR (ENX) files',
'DKYGER',
'11'
],
[
'Paper::Specs',
'a',
'd',
'p',
'O',
'p',
'Specifications for paper stock, labels, etc.',
'JONALLEN',
'11'
],
[
'Text::Shift',
'b',
'd',
'p',
'O',
'p',
'Perform shift mappings on text',
'CHIA',
'11'
],
[
'Bundle::ePortal',
'b',
'd',
'p',
'n',
'p',
'Bundle with all ePortal related modules',
'RUSAKOV',
'25'
],
[
'DBIx::BabelKit',
'R',
'd',
'p',
'O',
'p',
'Multilingual Code Description Lookup Table',
'JGORMAN',
'7'
],
[
'DBIx::CodeKit',
'R',
'd',
'p',
'O',
'p',
'Universal Code Description Lookup Table',
'JGORMAN',
'7'
],
[
'Mail::DSN',
'a',
'd',
'p',
'O',
'p',
'Interpret Deliver Status Notifications (DSN)',
'MMCLAGAN',
'19'
],
[
'Heap::Simple',
'R',
'd',
'p',
'O',
'p',
'Simple and fast classic heaps (loader only)',
'THOSPEL',
'6'
],
[
'XML::OPML',
'b',
'd',
'p',
'O',
'p',
'Create, update, and parse OPML documents',
'MADGHOUL',
'11'
],
[
'Text::vFile',
'a',
'd',
'p',
'O',
'p',
'Parses vCard RFC2426 and vCal RFC2445 files',
'JVASILE',
'11'
],
[
'Physics::Springs',
'R',
'd',
'p',
'O',
'p',
'Simulate particle dynamics with springs',
'SMUELLER',
'23'
],
[
'Oracle::Debug',
'c',
'd',
'p',
'O',
'p',
'perldb like interface to Oracle DBMS_DEBUG',
'RFOLEY',
'7'
],
[
'Digest::EMAC',
'R',
'd',
'p',
'f',
'g',
'Uses block ciphers to produce MACs',
'JCDUQUE',
'14'
],
[
'Test::Signature',
'R',
'd',
'p',
'f',
'p',
'Convenience automated testing of SIGNATUREs',
'AUTRIJUS',
'3'
],
[
'Crypt::Misty1',
'R',
'd',
'c',
'O',
'g',
'NESSIE winner for 128-bit key, 64-bit cipher',
'JCDUQUE',
'14'
],
[
'WebService::Mappoint',
'b',
'd',
'p',
'O',
'p',
'Mappoint maps service SOAP access library',
'CGARCIA',
'15'
],
[
'UML::State',
'a',
'd',
'p',
'O',
'p',
'draws state diagrams from simple text files',
'PHILCROW',
'18'
],
[
'SGML::Parser::OpenSP',
'b',
'm',
'+',
'O',
'p',
'XS Interface to the OpenSP SGML/XML Parser',
'BJOERN',
'11'
],
[
'WWW::Extractor',
'a',
'd',
'p',
'O',
'l',
'Semi-automated record extraction from WWW',
'GNALABS',
'15'
],
[
'File::Locate',
'b',
'd',
'c',
'f',
'g',
'Query the locate database',
'VPARSEVAL',
'10'
],
[
'Nmap::Scanner',
'R',
'd',
'p',
'O',
'l',
'Perform and manipulate nmap scans using perl',
'MAXSCHUBE',
'14'
],
[
'AI::ExpertSystem::Simple',
'R',
'd',
'p',
'O',
'p',
'Expert system shell',
'PETERHI',
'23'
],
[
'PDF::API2',
'R',
'm',
'p',
'O',
'o',
'PDF Creation/Modification',
'AREIBENS',
'11'
],
[
'Cisco::Reconfig',
'R',
'd',
'p',
'O',
'p',
'Parse and generate Cisco configuration files',
'MUIR',
'23'
],
[
'Net::QMTP',
'c',
'd',
'p',
'O',
'p',
'Interface to Quick Mail Transfer Protocol',
'JRAFTERY',
'5'
],
[
'Text::Netstring',
'b',
'd',
'p',
'f',
'p',
'Create and manipulate netstrings',
'JRAFTERY',
'11'
],
[
'Crypt::Khazad',
'R',
'd',
'c',
'O',
'g',
'A 64-bit block cipher using a 128-bit key',
'JCDUQUE',
'14'
],
[
'Crypt::Anubis',
'R',
'd',
'c',
'O',
'g',
'A variable-length key, 128-bit block cipher',
'JCDUQUE',
'14'
],
[
'Crypt::Noekeon',
'R',
'd',
'c',
'O',
'g',
'A 128-bit block cipher using a 128-bit key',
'JCDUQUE',
'14'
],
[
'Crypt::Skipjack',
'R',
'd',
'c',
'O',
'g',
'Crypt::CBC-compliant block cipher',
'JCDUQUE',
'14'
],
[
'Crypt::Camellia',
'R',
'd',
'c',
'O',
'g',
'Crypt::CBC-compliant block cipher',
'JCDUQUE',
'14'
],
[
'Digest::Haval256',
'R',
'd',
'c',
'O',
'g',
'A 256-bit one-way hash function',
'JCDUQUE',
'14'
],
[
'Digest::Whirlpool',
'R',
'd',
'c',
'O',
'g',
'A 512-bit one-way hash function',
'JCDUQUE',
'14'
],
[
'Date:Jalali',
'R',
'd',
'p',
'O',
'p',
'Converts Gregorian date to Jalali',
'AHMAD',
'13'
],
[
'Time::Format',
'R',
'd',
'p',
'r',
'p',
'Easy-to-use date/time formatting',
'ROODE',
'6'
],
[
'Crypt::Square',
'R',
'd',
'c',
'O',
'g',
'Crypt::CBC-compliant block cipher',
'JCDUQUE',
'14'
],
[
'Compress::LZW',
'a',
'd',
'p',
'f',
'p',
'Pure perl implementation of LZW',
'MHOWARD',
'17'
],
[
'Text::Cipher',
'R',
'd',
'p',
'O',
'g',
'Flexible text cipher class and interface',
'CHIA',
'11'
],
[
'WWW::Mechanize',
'M',
'd',
'p',
'O',
'p',
'Automates web page form & link interaction',
'PETDANCE',
'15'
],
[
'Crypt::Rainbow',
'R',
'd',
'c',
'O',
'g',
'A Crypt::CBC compliant block cipher',
'JCDUQUE',
'14'
],
[
'Convert::Bencode',
'R',
'd',
'p',
'f',
'p',
'conversion to/from bencoded strings',
'ORCLEV',
'17'
],
[
'Mail::SPF::Query',
'R',
'm',
'p',
'O',
'o',
'Query Sender Permitted From status in DNS',
'FREESIDE',
'19'
],
[
'POE::Component::Server::Syslog',
'R',
'd',
'p',
'O',
'b',
'Syslog server ability for POE',
'SUNGO',
'5'
],
[
'Digest::Elf',
'R',
'd',
'h',
'f',
'g',
'Hash a string into a 32 bit value',
'MCKAY',
'14'
],
[
'Crypt::SEAL2',
'R',
'd',
'c',
'O',
'g',
'The stream cipher, SEAL v 2.0',
'JCDUQUE',
'14'
],
[
'DateTime::Format::Strptime',
'R',
'm',
'p',
'O',
'p',
'Parse and Format DateTimes using Strptime',
'RICKM',
'6'
],
[
'Crypt::Loki97',
'R',
'd',
'c',
'O',
'g',
'A Crypt::CBC compliant 128-bit block cipher',
'JCDUQUE',
'14'
],
[
'Apache::Language',
'M',
'd',
'p',
'r',
'p',
'Transparent I18N support for Apache',
'GOZER',
'15'
],
[
'Tk::ReportBox',
'R',
'd',
'p',
'O',
'p',
'Display of reports',
'LAWGON',
'8'
],
[
'Crypt::Shark',
'R',
'd',
'c',
'O',
'g',
'A 64-bit block cipher that accepts a 128-bit',
'JCDUQUE',
'14'
],
[
'Acme::Floral',
'R',
'd',
'p',
'p',
'p',
'Produces fragrant perl',
'JJORE',
'2'
],
[
'List::Comprehensions',
'a',
'd',
'p',
'f',
'p',
'allows for list comprehensions in Perl',
'OPHIUCI',
'6'
],
[
'Tk::Separator',
'b',
'd',
'p',
'O',
'g',
'Create horizontal and vertical 3D separators',
'WGDAVIS',
'8'
],
[
'CDDB::Fake',
'R',
'd',
'p',
'O',
'p',
'Fallback for missing CDDB info files',
'JV',
'7'
],
[
'Text::Capitalize',
'?',
'?',
'?',
'?',
'?',
'Capitalizes text, I think',
'SYP',
'11'
],
[
'Sub::Assert',
'R',
'd',
'p',
'f',
'p',
'Design-by-contract: pre- and postconditions',
'SMUELLER',
'3'
],
[
'Math::Symbolic',
'R',
'm',
'p',
'h',
'p',
'Symbolic calculations and derivatives',
'SMUELLER',
'6'
],
[
'Physics::Springs::Friction',
'R',
'd',
'p',
'O',
'p',
'Simulate Dynamics with Springs and Friction',
'SMUELLER',
'23'
],
[
'Math::Fractal::Curve',
'R',
'd',
'p',
'O',
'p',
'Generate 2-dimensional fractal curves',
'SMUELLER',
'6'
],
[
'Business::OnlinePayment::E2Payments',
'b',
'd',
'p',
'O',
'd',
'E2Payments eCommerce Interface',
'AIDAN',
'23'
],
[
'Tk::ApplicationNest',
'b',
'u',
'p',
'O',
'p',
'megawidget to  display  a  program window',
'XPIX',
'8'
],
[
'Tk::DBIx',
'b',
'u',
'p',
'O',
'p',
'A bunch of modules to DB interaction.',
'XPIX',
'8'
],
[
'Java::Build',
'b',
'd',
'h',
'h',
'p',
'Controls Java builds from Perl',
'PHILCROW',
'9'
],
[
'Getopt::Long::File',
'b',
'd',
'p',
'f',
'g',
'Command-line options file parser',
'MOINEFOU',
'12'
],
[
'Getargs::Mixed',
'b',
'd',
'p',
'f',
'p',
'Mixed positional/named parameter processor',
'HANENKAMP',
'12'
],
[
'RTSP::Lite',
'b',
'n',
'p',
'O',
'a',
'Lightweight RTSP implementation',
'NABESHIMA',
'5'
],
[
'Encode::Arabic',
'b',
'd',
'p',
'O',
'p',
'Encodings of Arabic',
'SMRZ',
'13'
],
[
'XML::Validator::Schema',
'a',
'd',
'p',
'O',
'p',
'validate XML with a subset of W3C XML Schema',
'SAMTREGAR',
'11'
],
[
'String::Ruby',
'b',
'd',
'c',
'h',
'p',
'Ruby\'s String class ported to Perl',
'VPARSEVAL',
'11'
],
[
'Data::BitMask',
'R',
'd',
'p',
'O',
'a',
'Bitmask manipulation',
'TEVERETT',
'6'
],
[
'Solaris::DeviceTree',
'c',
'd',
'h',
'O',
'p',
'Device tree traversal using libdevinfo etc.',
'DAGOBERT',
'4'
],
[
'HTML::FromMail',
'a',
'm',
'p',
'O',
'g',
'Convert e-mail to HTML',
'MARKOV',
'15'
],
[
'AI::Pathfinding::AStar',
'a',
'd',
'p',
'f',
'p',
'A* Pathfinding Algorithm',
'ACDALTON',
'23'
],
[
'Net::BEEP::Lite',
'b',
'd',
'p',
'O',
'l',
'lightweight BEEP framework',
'DBLACKA',
'5'
],
[
'AxKit::XSP::BasicSession',
'b',
'd',
'p',
'f',
'p',
'Simple session tag library for AxKit',
'KJETILK',
'15'
],
[
'Net::Subnets',
'b',
'd',
'p',
'O',
'p',
'Computing subnets in large scale networks',
'SRI',
'5'
],
[
'Tk::Zinc',
'M',
'm',
'c',
'O',
'l',
'canvas with group transfo clipping openGL',
'ZINCDEV',
'8'
],
[
'Term::Activity',
'R',
'd',
'p',
'O',
'a',
'Term display of processing activity',
'BENNIE',
'8'
],
[
'Net::Milter',
'M',
'd',
'p',
'O',
'p',
'Pure Perl version of MTA end of milter API',
'MGLEE',
'19'
],
[
'Math::Approx::Symbolic',
'R',
'd',
'p',
'O',
'p',
'Symbolic interpolated polynomials',
'SMUELLER',
'6'
],
[
'Tk::Timer',
'i',
'd',
'p',
'O',
'p',
'Tk composite widget for timer display',
'IVORW',
'8'
],
[
'Alien',
'a',
'd',
'p',
'f',
'p',
'Management of non-perl software dependencies',
'ABERGMAN',
'23'
],
[
'Curses::UI::POE',
'b',
'd',
'p',
'p',
'o',
'A subclass that forces Curses::UI to use POE',
'TAG',
'8'
],
[
'File::Stream',
'R',
'd',
'p',
'h',
'p',
'Regular expr. delimited records from streams',
'SMUELLER',
'21'
],
[
'MPEG::Audio::Frame',
'R',
'd',
'p',
'O',
'p',
'A module that parses MPEG frames from FHs',
'NUFFIN',
'23'
],
[
'Algorithm::Hamming::Perl',
'a',
'u',
'p',
'f',
'p',
'ECC Hamming encoding, fixes 1-bit errors',
'BDGREGG',
'6'
],
[
'Bundle::Gnome2',
'b',
'm',
'p',
'n',
'p',
'a bundle to install all Gtk+ 2.x modules.',
'GBROWN',
'25'
],
[
'Win32::UTCFileTime',
'R',
'd',
'c',
'f',
'p',
'Get/set UTC file times with stat/utime',
'SHAY',
'22'
],
[
'Math::Gradient',
'R',
'd',
'p',
'f',
'p',
'Calculate Gradients Between Multiple Numbers',
'CRAKRJACK',
'23'
],
[
'DBD::AnyData',
'b',
'm',
'p',
'O',
'p',
'DBI access to XML, CSV and other formats',
'JZUCKER',
'7'
],
[
'AnyData',
'b',
'm',
'p',
'f',
'p',
'tied hash interface to data in many formats',
'JZUCKER',
'11'
],
[
'DBD::File',
'b',
'm',
'p',
'O',
'p',
'Base class for writing DBI drivers for plain',
'JZUCKER',
'7'
],
[
'XML::LibXML',
'R',
'm',
'h',
'O',
'p',
'Interface to the libxml library',
'PHISH',
'11'
],
[
'AFS::Command',
'R',
'd',
'p',
'O',
'a',
'Wrapper API for AFS Administrative Commands',
'ISAACSON',
'10'
],
[
'Win32::File::VersionInfo',
'R',
'd',
'c',
'f',
'p',
'Reads Win32 exe,dll (PE) version information',
'ALEXEYT',
'22'
],
[
'FindBin::libs',
'M',
'd',
'p',
'p',
'p',
'Auto-use dir\'s found with $FindBin::Bin',
'LEMBARK',
'3'
],
[
'IO::Event',
'b',
'd',
'p',
'O',
'p',
'tied non-blocking filehandles with callbacks',
'MUIR',
'21'
],
[
'Test::MultiFork',
'a',
'd',
'p',
'h',
'p',
'Test suite support for multi-process program',
'MUIR',
'3'
],
[
'Oracle::Trace',
'a',
'd',
'p',
'O',
'p',
'Interface to Oracle Trace files',
'RFOLEY',
'7'
],
[
'Tk::SlideSwitch',
'M',
'd',
'p',
'O',
'p',
'A 2 position horizontal or vertical switch',
'LUSOL',
'8'
],
[
'DMOZ::ParseRDF',
'b',
'd',
'p',
'O',
'p',
'Parse the DMOZ RDF file into smaller chunks',
'PAUL',
'11'
],
[
'Tk::LineNumberText',
'R',
'd',
'p',
'O',
'p',
'Line numbers for any Text-derived widget',
'DUNNIGANJ',
'8'
],
[
'Tk::DynaTabFrame',
'b',
'u',
'p',
'h',
'a',
'Tk Notebook-like widget with >1 tab rows',
'DARNOLD',
'8'
],
[
'Tk::Statusbar',
'R',
'd',
'p',
'O',
'p',
'Tk Statusbar Widget',
'ZABEL',
'8'
],
[
'POE::Exceptions',
'R',
'd',
'p',
'O',
'b',
'Provides exception handling for POE',
'SUNGO',
'20'
],
[
'POE::API::Peek',
'R',
'd',
'p',
'O',
'b',
'Peek into the internals of a running POE env',
'SUNGO',
'3'
],
[
'Mail::SRS',
'R',
'm',
'p',
'O',
'o',
'Sender Rewriting Scheme for SMTP forwarders',
'SHEVEK',
'19'
],
[
'Params::Validate',
'M',
'd',
'h',
'f',
'p',
'Validate sub params against a spec',
'DROLSKY',
'12'
],
[
'HTTP::Recorder',
'a',
'm',
'p',
'O',
'g',
'Record interaction with web sites.',
'LEIRA',
'15'
],
[
'Acme::Wabby',
'R',
'd',
'p',
'O',
'g',
'Generate random sentences based on seed text',
'POZNICK',
'11'
],
[
'W3C::LinkChecker',
'M',
'm',
'p',
'O',
'o',
'The W3C Link Checker',
'SCOP',
'15'
],
[
'Crypt::Rabbit',
'M',
'd',
'c',
'O',
'g',
'The stream cipher Rabbit',
'JCDUQUE',
'14'
],
[
'DBD::MaxDB',
'b',
'm',
'c',
'h',
'p',
'MySQL MaxDB database driver for DBI',
'MAXDB',
'7'
],
[
'Finance::Performance::Calc',
'R',
'd',
'p',
'f',
'p',
'Rate of return calculations',
'PERSICOM',
'23'
],
[
'Lingua::Stem::Fr',
'R',
'd',
'p',
'f',
'p',
'French stemming',
'SDP',
'11'
],
[
'Fortran::Format',
'a',
'd',
'p',
'O',
'p',
'Emulates Fortran 77 formatted output',
'ITUB',
'9'
],
[
'Net::RTSP',
'a',
'd',
'p',
'O',
'g',
'The Perl RTSP client API',
'WGDAVIS',
'5'
],
[
'TeX::Convert::Image',
'b',
'd',
'p',
'O',
'p',
'convert (La)TeX code to images',
'MRTS',
'11'
],
[
'Digest::CRC',
'b',
'd',
'p',
'h',
'p',
'Generic CRC functions',
'OLIMAUL',
'11'
],
[
'POE::Component::Enc::Flac',
'R',
'd',
'p',
'O',
'p',
'Wraps FLAC (lossless audio) encoder flac(1)',
'STE',
'6'
],
[
'Lingua::PT::Conjugate',
'R',
'd',
'p',
'f',
'p',
'Conjugation of Portuguese verbs',
'EGROSS',
'11'
],
[
'Lingua::PT::UnConjugate',
'R',
'd',
'p',
'f',
'p',
'Recognition of conjugated Portuguese verbs',
'EGROSS',
'11'
],
[
'Log::Accounting',
'b',
'd',
'p',
'O',
'p',
'Accounting of network services',
'OLIMAUL',
'21'
],
[
'Log::Accounting::Sendmail',
'b',
'd',
'p',
'O',
'p',
'Accounting for sendmail',
'OLIMAUL',
'21'
],
[
'POE::Component::Enc::Ogg',
'R',
'd',
'p',
'O',
'p',
'Wraps Ogg Vorbis encoder oggenc(1)',
'STE',
'6'
],
[
'Tk::ErrorDump',
'b',
'u',
'p',
'h',
'a',
'ErrorDialog permitting app to save dumpfiles',
'DARNOLD',
'8'
],
[
'HTML::Template::Set',
'b',
'd',
'p',
'O',
'g',
'HTML::Template extension adding set support',
'DJR',
'15'
],
[
'Lingua::Identify',
'M',
'd',
'p',
'f',
'p',
'Language identification',
'COG',
'11'
],
[
'Unix::Admin',
'c',
'd',
'p',
'O',
'p',
'Generic interface to Unix admin tasks.',
'BDA',
'4'
],
[
'Win32::Perfmon',
'R',
'd',
'c',
'O',
'p',
'A perl interface into Windows Perf Monitor',
'GLENSMALL',
'22'
],
[
'Net::iTMS',
'M',
'd',
'p',
'O',
'p',
'Retrieve data from the iTunes Music Store',
'TSIBLEY',
'15'
],
[
'Bundle::W3C::Validator',
'M',
'm',
'p',
'n',
'o',
'Bundle for W3C Markup Validator dependencies',
'SCOP',
'25'
],
[
'WWW::Lyrics',
'R',
'n',
'p',
'O',
'p',
'Fetch song lyrics from the internet',
'CORUSCATE',
'15'
],
[
'Crypt::UnixCrypt_XS',
'b',
'd',
'h',
'f',
'p',
'Perl-xs implementation of crypt(3)',
'BORISZ',
'14'
],
[
'Lingua::PT::Nums2Words',
'R',
'd',
'p',
'f',
'p',
'Converts numbers to Portuguese words',
'COG',
'11'
],
[
'Lingua::PT::Words2Nums',
'R',
'd',
'p',
'f',
'p',
'Converts Portuguese words to numbers',
'COG',
'11'
],
[
'WWW::URLToys',
'a',
'd',
'p',
'f',
'b',
'Find links in HTML, download them to files',
'JDRAGO',
'15'
],
[
'RFID::Matrics',
'b',
'm',
'p',
'O',
'r',
'Interface with Matrics RFID Reader',
'GIFF',
'5'
],
[
'PDF::Template',
'R',
'm',
'p',
'O',
'p',
'Lay out PDF files with a template',
'RKINYON',
'11'
],
[
'Excel::Template',
'R',
'm',
'p',
'O',
'p',
'Templating module that generates Excel',
'RKINYON',
'99'
],
[
'Tree::Menu',
'b',
'd',
'p',
'O',
'p',
'Menus as trees',
'PSHARPE',
'6'
],
[
'Lingua::PT::Inflect',
'R',
'd',
'p',
'f',
'p',
'Portuguese words from singular to plural',
'COG',
'11'
],
[
'HTML::Formulate',
'b',
'd',
'p',
'O',
'p',
'HTML form-generation module',
'GAVINC',
'15'
],
[
'Time::Piece::DB2',
'a',
'n',
'p',
'O',
'g',
'Adds DB2-specific methods to Time::Piece',
'MFERRIS',
'6'
],
[
'Class::DBI::DB2',
'b',
'n',
'p',
'O',
'p',
'Extensions to Class::DBI for DB2',
'MFERRIS',
'6'
],
[
'Class::DBI::Loader::DB2',
'a',
'n',
'p',
'O',
'p',
'Class::DBI::Loader DB2 implementation',
'MFERRIS',
'6'
],
[
'Number::Phone::PT',
'R',
'd',
'p',
'f',
'p',
'Validates Portuguese phone numbers',
'COG',
'11'
],
[
'Mail::Client::Yahoo',
'b',
'd',
'p',
'O',
'p',
'Programatically access Yahoo Webmail',
'JOHNSCA',
'19'
],
[
'Tk::Carp',
'b',
'd',
'p',
'f',
'p',
'Redirect warnings and errors to Tk Dialogs',
'JOHNSCA',
'8'
],
[
'Win32::GUI::Carp',
'b',
'd',
'p',
'f',
'p',
'Redirect warnings and errors to Win32::GUI M',
'JOHNSCA',
'22'
],
[
'HtDig::Htsearch',
'a',
'd',
'p',
'O',
'p',
'Perl object interface to the Htseach program',
'DMUEY',
'24'
],
[
'Text::Beautify',
'R',
'd',
'p',
'f',
'p',
'Beautifies text',
'COG',
'11'
],
[
'PerlIO::locale',
'b',
'd',
'c',
'n',
'p',
'PerlIO layer for the current locale encoding',
'RGARCIA',
'21'
],
[
'Config::Scoped',
'b',
'd',
'p',
'O',
'p',
'feature rich configuration file parser',
'GAISSMAI',
'12'
],
[
'GD::SecurityImage',
'R',
'd',
'p',
'O',
'p',
'Security image (captcha) generator',
'BURAK',
'18'
],
[
'WWW::ImageSpool',
'a',
'd',
'p',
'O',
'p',
'Cache images of interest from the web',
'CRAKRJACK',
'15'
],
[
'RTx::Shredder',
'a',
'd',
'p',
'O',
'p',
'RT Shredder extension',
'RUZ',
'7'
],
[
'Text::Wigwam',
'b',
'd',
'p',
'O',
'p',
'A user-extensible template parser.',
'DJOHNSTON',
'11'
],
[
'URI::OpenURL',
'R',
'd',
'p',
'O',
'p',
'URL encoding of Bibliographic Data',
'TIMBRODY',
'15'
],
[
'Digest::SHA',
'M',
'd',
'c',
'h',
'p',
'Perl extension for SHA-1/224/256/384/512',
'MSHELOR',
'14'
],
[
'CORBA::XPIDL',
'b',
'd',
'p',
'O',
'p',
'XPIDL compiler (for Mozilla)',
'PERRAD',
'9'
],
[
'Tk::DirSelect',
'R',
'd',
'p',
'O',
'a',
'Cross-platform directory selection widget',
'MJCARMAN',
'8'
],
[
'Lingua::PT::Hyphenate',
'R',
'd',
'p',
'f',
'p',
'Separates Portuguese words in syllables',
'COG',
'11'
],
[
'Devel::Truth_Table',
'b',
'd',
'p',
'O',
'a',
'Create and manipulate truth tables',
'MJCARMAN',
'3'
],
[
'Apache::QuickCMS',
'b',
'd',
'p',
'O',
'p',
'A small content management system',
'TMURRAY',
'15'
],
[
'PDF::FDF::Simple',
'b',
'd',
'p',
'O',
'p',
'Read and write (Acrobat) FDF files',
'SCHWIGON',
'11'
],
[
'Business::Payroll::AU::PAYG',
'a',
'd',
'p',
'O',
'p',
'Calculate Australian PAYG tax withholding.',
'PJF',
'23'
],
[
'Tie::Simple',
'b',
'd',
'p',
'r',
'p',
'Create ties without creating full packages',
'HANENKAMP',
'6'
],
[
'Sun::Solaris::Ucred',
'b',
'm',
'h',
'f',
'a',
'Perl interface to Solaris User Credentials',
'SUNCPAN',
'4'
],
[
'Sun::Solaris::Privilege',
'b',
'm',
'h',
'f',
'a',
'Perl interface to Solaris Privileges',
'SUNCPAN',
'4'
],
[
'File::Xcopy',
'c',
'd',
'p',
'O',
'p',
'compare, copy, and move files like xcopy',
'GEOTIGER',
'10'
],
[
'HTML::Chunks',
'R',
'd',
'p',
'O',
'p',
'Nested templates for HTML, XML and XHTML',
'DBALMER',
'15'
],
[
'Mail::GPG',
'R',
'd',
'p',
'O',
'p',
'Handling of GnuPG encrypted / signed mails',
'JRED',
'19'
],
[
'Net::IDN::Encode',
'a',
'd',
'p',
'f',
'p',
'Encoding/Decoding of IDNs',
'CFAERBER',
'13'
],
[
'Oracle::Loader',
'R',
'd',
'p',
'O',
'p',
'Create PL/SQL & control file for Sql*Loader',
'GEOTIGER',
'7'
],
[
'Regexp::Genex',
'a',
'd',
'p',
'f',
'p',
'generate regex matching strings with a regex',
'BOWMANBS',
'11'
],
[
'Scalar::Footnote',
'b',
'd',
'c',
'f',
'p',
'Attach hidden scalars to references',
'SPURKIS',
'6'
],
[
'Term::Shelly',
'c',
'd',
'p',
'O',
'p',
'Yet Another Shell-Kit/ReadLine Interface',
'PSIONIC',
'8'
],
[
'Lingua::AlignmentSet',
'R',
'd',
'p',
'O',
'g',
'handle a word-aligned bilingual corpus',
'PLAMBERT',
'11'
],
[
'Math::MPFR',
'R',
'd',
'c',
'f',
'p',
'Interface to MPFR (floating point) library',
'SISYPHUS',
'6'
],
[
'Data::TimeSeries',
'R',
'd',
'p',
'O',
'g',
'TimeSeries functions and objects',
'TOMMIE',
'6'
],
[
'Tk::ImageButton',
'R',
'd',
'p',
'O',
'p',
'A customisable graphical button',
'DHICKLING',
'8'
],
[
'Games::Sequential',
'a',
'd',
'p',
'O',
'p',
'OO framework for sequential games',
'STIG',
'23'
],
[
'PDL::LAPACK',
'a',
'd',
'h',
'f',
'o',
'Access LAPACK from PDL',
'HBARTEL',
'6'
],
[
'Data::Search',
'a',
'd',
'p',
'f',
'p',
'Searches complex data structures',
'ALX',
'6'
],
[
'Games::AlphaBeta',
'a',
'd',
'p',
'O',
'p',
'OO framework for generic AlphaBeta search',
'STIG',
'23'
],
[
'RFID::Alien',
'b',
'm',
'p',
'O',
'r',
'Interface with Alien RFID reader',
'GIFF',
'5'
],
[
'HTML::Stripper',
'R',
'n',
'p',
'O',
'p',
'Strips HTML markup from bodies of text',
'CORUSCATE',
'15'
],
[
'Net::WWD',
'b',
'd',
'p',
'O',
'a',
'Manipulate network based WWD objects',
'BALESHI',
'15'
],
[
'Fax::DataFax',
'b',
'd',
'p',
'O',
'p',
'Interface for DataFax system from CDSI',
'GEOTIGER',
'7'
],
[
'VCS::CMSynergy',
'R',
'd',
'p',
'O',
'p',
'Interface to Telelogic CM Synergy',
'RSCHUPP',
'3'
],
[
'Digest::SHA::PurePerl',
'R',
'd',
'p',
'h',
'p',
'Perl implementation of SHA-1/224/256/384/512',
'MSHELOR',
'14'
],
[
'Net::CDP',
'b',
'd',
'h',
'O',
'p',
'Cisco Discovery Protocol advertiser/listener',
'MCHAPMAN',
'5'
],
[
'Net::Vypress::Chat',
'a',
'd',
'p',
'O',
'p',
'OO interface to Vypress Chat functions',
'ARTURAZ',
'5'
],
[
'Log::Check',
'a',
'd',
'p',
'O',
'p',
'Log file analysis and event generator',
'LPETERS',
'21'
],
[
'CPAN::AutoINC',
'a',
'd',
'p',
'p',
'p',
'Download and install CPAN modules when used',
'DONS',
'23'
],
[
'HTML::Tooltip::Javascript',
'a',
'd',
'p',
'O',
'p',
'Interface to a Javascript tooltip library',
'UNISOLVE',
'15'
],
[
'Apache::ModBT',
'a',
'd',
'c',
'O',
'o',
'Direct perl connection to a mod_bt tracker.',
'CRAKRJACK',
'16'
],
[
'Config::Magic',
'b',
'd',
'p',
'h',
'p',
'Recognizes configuration files, makes a hash',
'RUSTYP',
'12'
],
[
'MySQL::Backup',
'c',
'd',
'p',
'O',
'p',
'A module for Backuping/restoring mysql DBs',
'DMITRY',
'7'
],
[
'Audio::Moosic',
'R',
'd',
'p',
'O',
'p',
'Moosic client library for Perl',
'FLORA',
'23'
],
[
'Kwiki',
'b',
'd',
'p',
'O',
'p',
'The Kwiki Wiki Building Framework',
'INGY',
'15'
],
[
'Test::Portability::Files',
'R',
'd',
'p',
'f',
'p',
'Check file names portability',
'SAPER',
'3'
],
[
'Mail::Maildir',
'R',
'd',
'p',
'O',
'p',
'Maildir/Maildir++ folder level interface',
'ZEROALTI',
'19'
],
[
'List::Util::Superpositions',
'R',
'd',
'p',
'f',
'p',
'Providing any() and all() for lists',
'RSOD',
'6'
],
[
'Data::Form::Elements',
'b',
'd',
'p',
'O',
'p',
'Form object w/elemental access & validation.',
'PLURAL',
'6'
],
[
'Regexp::Extended',
'a',
'd',
'p',
'r',
'g',
'Wrapper that extends the perl re engine',
'CRUNCHIE',
'11'
],
[
'Text::Query',
'b',
'd',
'p',
'O',
'p',
'Query processing framework',
'EBOHLMAN',
'11'
],
[
'File::Wildcard',
'R',
'd',
'p',
'O',
'p',
'Enhanced glob processing',
'IVORW',
'10'
],
[
'RFID::Base',
'b',
'm',
'p',
'O',
'r',
'Base class for RFID readers and tags',
'GIFF',
'5'
],
[
'RFID::EPC',
'b',
'm',
'p',
'O',
'r',
'Creates and parses EPC RFID tags.',
'GIFF',
'5'
],
[
'SOAP::WSDL',
'a',
'd',
'p',
'O',
'a',
'Complete WSDL support for SOAP::Lite',
'MKUTTER',
'5'
],
[
'Term::Slang',
'M',
'd',
'c',
'h',
'p',
'Interface to the S-Lang terminal library.',
'DANIEL',
'8'
],
[
'Image::MetaData::JPEG',
'c',
'd',
'p',
'O',
'g',
'Access to and modification of JPEG meta-data',
'BETTELLI',
'18'
],
[
'Crypt::OpenSSL::PKCS12',
'R',
'd',
'c',
'O',
'p',
'Interface to OpenSSL\'s PKCS12 functions.',
'DANIEL',
'14'
],
[
'Crypt::OpenSSL::X509',
'R',
'd',
'c',
'O',
'p',
'Interface to OpenSSL\'s X509 functions.',
'DANIEL',
'14'
],
[
'Audio::MikMod',
'M',
'd',
'c',
'h',
'p',
'Interface to the MikMod library',
'DANIEL',
'23'
],
[
'CGI::Untaint::Filenames',
'R',
'd',
'p',
'O',
'p',
'Untaint filenames with path: UNIX, Windows',
'DHUDES',
'15'
],
[
'LWP::Protocol::http::SocketUnix',
'R',
'd',
'p',
'O',
'p',
'Speak HTTP through UNIX sockets',
'FLORA',
'15'
],
[
'CGI::FormFactory',
'a',
'd',
'p',
'O',
'p',
'Module for HTML form production/processing',
'GAVINC',
'15'
],
[
'HTML::Breadcrumbs',
'R',
'd',
'p',
'h',
'p',
'Module for creating HTML \'breadcrumb\' trails',
'GAVINC',
'15'
],
[
'CPAN::Search::Lite::Index',
'a',
'd',
'p',
'O',
'p',
'maintain a searchable CPAN database',
'RKOBES',
'23'
],
[
'IO::File::Lockable',
'R',
'd',
'p',
'O',
'p',
'extended IO::File for locking',
'MAKOTO',
'21'
],
[
'Module::MakefilePL::Parse',
'a',
'a',
'p',
'O',
'p',
'Partially-parse Makefile.PL',
'RRWO',
'3'
],
[
'Wiki::Gateway',
'a',
'm',
'o',
'O',
'g',
'API for interaction with wikis',
'BSHANKS',
'15'
],
[
'Net::DNS::Zone::Parser',
'R',
'd',
'p',
'O',
'd',
'DNS Zonefile preparser',
'OLAF',
'5'
],
[
'File::Remove',
'R',
'd',
'p',
'h',
'p',
'Remove files and directories',
'RSOD',
'10'
],
[
'Net::SAP',
'R',
'd',
'p',
'O',
'p',
'Session Announcement Protocol (rfc2974)',
'NJH',
'5'
],
[
'Net::SDP',
'a',
'd',
'p',
'O',
'p',
'Session Description Protocol (rfc2327)',
'NJH',
'5'
],
[
'Syntax::Highlight::HTML',
'b',
'd',
'p',
'O',
'p',
'Highlight HTML syntax in HTML',
'SAPER',
'11'
],
[
'IPC::DirQueue',
'a',
'd',
'p',
'O',
'p',
'disk-based many-to-many queueing system',
'JMASON',
'5'
],
[
'DBIx::TableReferences::MSSQL',
'b',
'd',
'p',
'O',
'p',
'Discover MSSQL table references',
'EDWARDG',
'7'
],
[
'ClearCase::Base',
'c',
'd',
'p',
'O',
'p',
'Interface with Rational ClearCase Base v2002',
'THUNDERA',
'3'
],
[
'POE::Component::Proxy::TCP',
'R',
'd',
'p',
'O',
'p',
'TCP Proxy Component for POE',
'ANDYPUR',
'16'
],
[
'MasonX::Maypole',
'a',
'd',
'p',
'O',
'p',
'Use HTML::Mason as a frontend to Maypole',
'DAVEBAIRD',
'15'
],
[
'Lingua::GA::Gramadoir',
'b',
'd',
'p',
'O',
'p',
'Check the grammar of Irish language text',
'SCANNELL',
'11'
],
[
'Interface::Param',
'M',
'd',
'p',
'O',
'p',
'Add param()-style methods to your objects',
'SHAUNGUTH',
'3'
],
[
'Tk::SignOnDialog',
'a',
'd',
'p',
'O',
'a',
'Popup dialog for username and password',
'KESZLER',
'8'
],
[
'Wily',
'a',
'd',
'p',
'O',
'p',
'Wily message interface',
'SHOLDEN',
'8'
],
[
'MIME::Lite::TT',
'a',
'd',
'p',
'O',
'p',
'TT enabled MIME::Lite wrapper',
'HORIUCHI',
'15'
],
[
'MIME::Lite::TT::Japanese',
'a',
'd',
'p',
'O',
'p',
'MIME::Lite::TT with Japanese character code',
'HORIUCHI',
'15'
],
[
'Audio::File',
'R',
'd',
'p',
'O',
'g',
'Audio file abstraction library',
'FLORA',
'23'
],
[
'Proc::Forking',
'S',
'd',
'p',
'O',
'g',
'OO interace to fork with load limit',
'FDULAU',
'4'
],
[
'Parse::RPN',
'S',
'd',
'p',
'f',
'g',
'RPN parser/processor (like FORTH)',
'FDULAU',
'11'
],
[
'WWW::Pipeline',
'b',
'd',
'p',
'O',
'p',
'Web Application Framework with Plugins',
'HOWARS',
'15'
],
[
'MP4::Info',
'R',
'd',
'p',
'h',
'p',
'Fetch info from MPEG-4 files',
'JHAR',
'23'
],
[
'Template::Plugin::Data::HTMLDumper',
'R',
'd',
'p',
'O',
'p',
'TT plugin interface to Data::HTMLDumper',
'SUTCH',
'11'
],
[
'Excel::Template::Element::Cell::AutoSize',
'a',
'd',
'p',
'O',
'p',
'Automatically sized cell for Excel::Template',
'THOWELL',
'11'
],
[
'CAD::Drawing',
'R',
'd',
'p',
'O',
'p',
'Flexible Vector Geometry Composition in Perl',
'EWILHELM',
'18'
],
[
'Math::Polygon',
'b',
'd',
'p',
'h',
'p',
'polygon mathematics',
'MARKOV',
'6'
],
[
'Biblio::Document::Parser',
'R',
'm',
'p',
'O',
'g',
'Extracts citations from documents',
'MJEWELL',
'11'
],
[
'Biblio::Citation::Parser',
'R',
'm',
'p',
'O',
'g',
'Parses citations into metadata',
'MJEWELL',
'11'
],
[
'Filter::Crypto',
'R',
'd',
'c',
'h',
'p',
'Create runnable encrypted Perl files',
'SHAY',
'14'
],
[
'Oracle::SQLLoader',
'b',
'd',
'p',
'O',
'p',
'object interface to Oracle\'s SQL*Loader',
'EZRA',
'7'
],
[
'Palm::Magellan::NavCompanion',
'a',
'd',
'p',
'O',
'p',
'Access Magellan\'s GPS Companion waypoints db',
'BDFOY',
'7'
],
[
'AIX::ODM',
'M',
'd',
'p',
'f',
'p',
'Retrieve AIX ODM information',
'DFRENCH',
'4'
],
[
'Benchmark::Forking',
'R',
'd',
'p',
'h',
'p',
'Run benchmarks in separate processes',
'EVO',
'3'
],
[
'Test::LectroTest',
'b',
'm',
'p',
'h',
'p',
'automatic, specification-based testing tool',
'TMOERTEL',
'3'
],
[
'Win32::Process::Perf',
'R',
'n',
'c',
'O',
'p',
'Shows performance counters for a process',
'RPAGITSCH',
'22'
],
[
'Solaris::Disk::SVM',
'b',
'd',
'p',
'O',
'p',
'Read, explore and manipulate SVM configs.',
'JFENAL',
'4'
],
[
'Solaris::Disk::VTOC',
'b',
'd',
'p',
'O',
'p',
'Read Solaris VTOC (aka. slices) from disk',
'JFENAL',
'4'
],
[
'Solaris::Disk::Mnttab',
'b',
'd',
'p',
'O',
'p',
'Read Solaris list of mounted devices',
'JFENAL',
'4'
],
[
'Gtk2::MozEmbed',
'b',
'm',
'c',
'O',
'l',
'Interface to the Mozilla embedding widget',
'TSCH',
'8'
],
[
'Gtk2::TrayManager',
'b',
'm',
'c',
'O',
'l',
'Perl bindings for EggTrayManager',
'BORUP',
'8'
],
[
'Imager::TimelineDiagram',
'a',
'd',
'p',
'O',
'p',
'Create timeline diagrams using Imager',
'MZSANFORD',
'18'
],
[
'XML::ASCX12',
'b',
'd',
'p',
'O',
'l',
'Module to convert ASC X12 EDI to XML',
'KANEY',
'11'
],
[
'HTML::DragAndDrop',
'b',
'd',
'p',
'O',
'p',
'Interface to W.Zorns DragAndDrop library',
'UNISOLVE',
'15'
],
[
'Email::AutoReply',
'b',
'd',
'p',
'O',
'p',
'Email autoresponder development tools',
'AMONSEN',
'19'
],
[
'Language::Frink::Eval',
'a',
'd',
'p',
'O',
'p',
'Wrapper for evaluating Frink expressions',
'CMO',
'9'
],
[
'Genezzo',
'a',
'd',
'p',
'h',
'g',
'extensible database with DBI and tie support',
'JCOHEN',
'7'
],
[
'Apache::AutoLogin',
'b',
'n',
'p',
'f',
'a',
'auto login for basic authentication',
'MMWEBER',
'15'
],
[
'Net::NetSend',
'b',
'd',
'p',
'f',
'p',
'Pure perl implementation of "net send"',
'GREB',
'5'
],
[
'WWW::Dilbert',
'b',
'd',
'p',
'O',
'g',
'Dilbert of the day archive and retrieval',
'NICOLAW',
'15'
],
[
'Myco',
'R',
'd',
'p',
'O',
'p',
'Full featured object-oriented app framework',
'SOMMERB',
'3'
],
[
'Data::Trie',
'c',
'd',
'p',
'O',
'p',
'a small implementation of a letter trie',
'HAMMOND',
'6'
],
[
'Algorithm::BinPack',
'b',
'd',
'p',
'O',
'd',
'efficiently pack items into bins',
'CBTILDEN',
'6'
],
[
'Sys::Uptime',
'b',
'd',
'p',
'f',
'p',
'Get info about the CPU and uptime',
'WIMDH',
'4'
],
[
'Net::Mac::Vendor',
'a',
'd',
'p',
'h',
'p',
'Look up the vendor for a MAC address',
'BDFOY',
'5'
],
[
'define',
'R',
'd',
'p',
'p',
'p',
'Use this pragma to define global constants',
'GGUREVICH',
'27'
],
[
'Language::Zcode',
'a',
'd',
'p',
'O',
'p',
'Parse and translate Z-code story files',
'AKARGER',
'9'
],
[
'Tk::OutlookBar',
'i',
'd',
'p',
'O',
'p',
'Oulook Bar widget for Perl/Tk',
'ZABEL',
'8'
],
[
'Gnome2',
'M',
'm',
'c',
'O',
'l',
'Interface to the 2.x series of GNOME',
'TSCH',
'8'
],
[
'Apache::AuthCAS',
'R',
'd',
'p',
'n',
'g',
'Apache authen module for use with Yale CAS',
'DCASTRO',
'15'
],
[
'File::Split',
'a',
'd',
'p',
'O',
'g',
'Split and Merge files',
'MIDDLETO',
'21'
],
[
'Acme::Umlautify',
'R',
'd',
'p',
'h',
'p',
"\x{c4}dd \x{fc}ml\x{e4}\x{fc}ts t\x{f6} \x{eb}v\x{eb}r\x{ff}th\x{ef}ng!",
'BENNIE',
'11'
],
[
'Acme::Pythonic',
'b',
'd',
'p',
'n',
'p',
'Python whitespace conventions for Perl',
'FXN',
'9'
],
[
'Alarm::Concurrent',
'b',
'd',
'p',
'f',
'p',
'Allow multiple, concurrent alarms',
'JOHNSCA',
'3'
],
[
'Algorithm::SkipList',
'R',
'd',
'p',
'h',
'p',
'Perl implementation of skip lists',
'RRWO',
'6'
],
[
'Apache::AuthzSplitDomainUser',
'b',
'd',
'p',
'f',
'g',
'AuthzHandler that splits the DOMAIN\\user',
'SPEEVES',
'15'
],
[
'Array::LineReader',
'b',
'd',
'p',
'O',
'g',
'read lines of a file by an tied array',
'BHOLSTEN',
'6'
],
[
'Authen::Krb5Password',
'S',
'd',
'c',
'f',
'p',
'Kerberos 5 Password Verification module',
'SHUQUE',
'14'
],
[
'Authen::Users',
'M',
'd',
'p',
'O',
'p',
'DBI based User Authentication',
'BILLH',
'14'
],
[
'Bio::SAGE',
'R',
'd',
'p',
'O',
'p',
'Processing and analysis of SAGE data.',
'SCOTTZED',
'23'
],
[
'Bloom::Filter',
'b',
'm',
'p',
'O',
'g',
'Pure Perl Bloom filter implementation',
'MCEGLOWS',
'6'
],
[
'Bryar::DataSource::SVNRepos',
'a',
'd',
'p',
'O',
'p',
'get your blog entries from an SVN repos',
'MARTIJN',
'7'
],
[
'Business::GestPayCrypt',
'R',
'd',
'p',
'O',
'p',
'Perl interface to the online payment GestPay',
'GAZERRO',
'23'
],
[
'CGI::Application::GDGraph::lines_ap',
'a',
'd',
'p',
'O',
'p',
'Perl extension for CGI::Application',
'JNBROOKES',
'15'
],
[
'CGI::DBTables',
'a',
'd',
'p',
'O',
'g',
'Generate custom HTML tables from DB queries',
'FRIEDO',
'15'
],
[
'CGI::Session::Encrypted',
'b',
'd',
'p',
'O',
'p',
'Encrypted session data in CGI applications',
'SRIHA',
'15'
],
[
'Cache::Bounded',
'R',
'd',
'p',
'O',
'g',
'A speed optimized in-memory size-aware cache',
'BENNIE',
'17'
],
[
'Chemistry::File::PDB',
'a',
'm',
'p',
'O',
'p',
'PDB (Protein Data Bank) file reader/writer',
'ITUB',
'23'
],
[
'Clarion',
'R',
'd',
'p',
'O',
'p',
'Perl module to read Clarion 2.1 .dat files',
'ICHE',
'7'
],
[
'Class::Closure',
'b',
'd',
'p',
'h',
'p',
'Encapsulated, declarative class syntax',
'LPALMER',
'6'
],
[
'Class::DBI::Plugin::CountSearch',
'R',
'd',
'p',
'O',
'p',
'Basic COUNT(*) functionality for Class::DBI',
'HOLBROOK',
'6'
],
[
'Class::Modular',
'R',
'd',
'p',
'O',
'g',
'Modular class generation superclass',
'DON',
'6'
],
[
'DBIx::Objects',
'a',
'd',
'p',
'O',
'p',
'Framework for developing database-bound obje',
'ISAAC',
'7'
],
[
'Data::All',
'b',
'd',
'p',
'h',
'p',
'Access to any data type from any source',
'DELANO',
'6'
],
[
'Data::ID::Exim',
'R',
'd',
'p',
'f',
'p',
'generate Exim message IDs',
'ZEFRAM',
'6'
],
[
'Data::SecsPack',
'R',
'd',
'p',
'h',
'b',
'parse,pack,unpack numbers per SEMI E5-94',
'SOFTDIA',
'6'
],
[
'Date::Simple::Month',
'a',
'd',
'p',
'O',
'p',
'a month of Date::Simple objects',
'HORIUCHI',
'6'
],
[
'Deploy',
'c',
'd',
'p',
'h',
'p',
'Standard-Perl',
'RMICHAUD',
'23'
],
[
'Encode::Registry',
'b',
'd',
'p',
'f',
'p',
'install once, use anywhere for mappings',
'MHOSKEN',
'13'
],
[
'Encode::TECkit',
'b',
'd',
'c',
'O',
'p',
'Complex encoding conversion TECkit wrap',
'MHOSKEN',
'13'
],
[
'Encode::UTR22',
'b',
'd',
'p',
'O',
'p',
'UTR22 complex encoding conversion',
'MHOSKEN',
'13'
],
[
'File::LinearRaid',
'b',
'd',
'p',
'r',
'p',
'Multiple physical files as one seamless file',
'ROSULEK',
'21'
],
[
'Font::FNT',
'b',
'd',
'p',
'O',
'p',
'Load, manipulate, save Windows raster fonts',
'SGOELDNER',
'11'
],
[
'Glib',
'R',
'm',
'h',
'O',
'l',
'Bindings for the glib-2.x UI Toolkit',
'RMCFARLA',
'6'
],
[
'Gtk2',
'M',
'm',
'h',
'O',
'l',
'Bindings for the gtk+-2.x UI Toolkit',
'RMCFARLA',
'8'
],
[
'Image::Magick::BarChart',
'a',
'd',
'p',
'O',
'p',
'Simple interface for creating bar charts',
'AWESTHOLM',
'18'
],
[
'Lingua::Stem::Ru',
'R',
'd',
'p',
'f',
'p',
'Porter\'s stemming algorithm for Russian',
'ALGDR',
'11'
],
[
'Net::Irate',
'a',
'd',
'p',
'O',
'p',
'Perl client interface to Irate service',
'DTHAY',
'5'
],
[
'Net::RULI',
'a',
'd',
'c',
'f',
'g',
'Interface for querying DNS SRV records',
'EMARQUES',
'5'
],
[
'POE::Component::OSCAR',
'b',
'd',
'p',
'O',
'p',
'POE interface to Net::OSCAR module',
'DMCC',
'5'
],
[
'Search::Xapian',
'b',
'm',
'+',
'O',
'p',
'perl bindings for the Xapian search library',
'KILINRAX',
'11'
],
[
'Security::LibPath',
'c',
'd',
'p',
'f',
'p',
'Allows setting of @INC from config file',
'JAMESODEN',
'2'
],
[
'Snippets',
'i',
'd',
'p',
'f',
'a',
'Various, minor bit of reusable code',
'BACHMANN',
'23'
],
[
'Sub::DeferredPartial',
'b',
'd',
'p',
'h',
'p',
'Deferred evaluation / partial application',
'SGOELDNER',
'3'
],
[
'Test::File::Find::Rule',
'R',
'd',
'p',
'O',
'p',
'Test files and directories',
'FABPOT',
'3'
],
[
'Text::Convert::ToImage',
'a',
'd',
'p',
'O',
'p',
'Converts Text to images in various formats',
'HARRY',
'11'
],
[
'Tie::Hash::MultiValue',
'R',
'd',
'p',
'r',
'p',
'Hash w/multiple items under a single key',
'MCMAHON',
'6'
],
[
'Time:Compare',
'b',
'd',
'p',
'O',
'p',
'Module for comparing two time values',
'YAK',
'6'
],
[
'Tree::List2Tree',
'a',
'd',
'p',
'h',
'p',
'Convert list of nodes into tree structure',
'THW',
'6'
],
[
'WIN32::MSI::SummaryInfo',
'R',
'd',
'p',
'O',
'b',
'MSI SummaryInformation stream interface',
'EMPI',
'4'
],
[
'WWW::Scraper::ISBN',
'b',
'd',
'p',
'O',
'p',
'Search for book info by ISBN',
'ASCHAMP',
'15'
],
[
'WWW::Statistics',
'b',
'n',
'p',
'O',
'p',
'A module to generate and manage website stat',
'DUPUISARN',
'15'
],
[
'Win32::GUID',
'R',
'd',
'h',
'f',
'p',
'An interface to Win32 CoCreateGuid()',
'ANDY',
'22'
],
[
'Win32::Resources',
'b',
'd',
'c',
'O',
'p',
'Manipulate windows executable resources',
'FABPOT',
'22'
],
[
'Win32API::File::Time',
'a',
'd',
'p',
'f',
'p',
'Change dates of Windows open files',
'WYANT',
'22'
],
[
'XML::Handler::Trees',
'b',
'd',
'p',
'O',
'p',
'PerlSAX handlers for building tree structure',
'EBOHLMAN',
'11'
],
[
'XRI',
'c',
'm',
'p',
'O',
'g',
'eXtensible Resource Identifier Library',
'FEN',
'15'
],
[
'Text::Normalize',
'S',
'd',
'p',
'f',
'p',
'Normalize Text String',
'DMUEY',
'11'
],
[
'Nokia::File::NFB',
'a',
'd',
'p',
'O',
'p',
'Manipulate Nokia .nfb/c phone backup files.',
'RPRICE',
'24'
],
[
'Vonage::Click2Call',
'a',
'd',
'p',
'O',
'p',
'Interface to Vonage click-2-call feature.',
'MZSANFORD',
'24'
],
[
'Date::Namedays::Simple',
'a',
'd',
'p',
'O',
'p',
'Very lightweight date/nameday mapping',
'FAGZAL',
'6'
],
[
'WWW::Yahoo::DrivingDirections',
'a',
'd',
'p',
'O',
'p',
'Interface to maps.yahoo driving directions',
'KESTER',
'15'
],
[
'XML::Handler::EasyTree::Generator',
'b',
'd',
'p',
'h',
'p',
'extension for generating EasyTree structures',
'WREN',
'11'
],
[
'Locale::KeyedText',
'R',
'd',
'p',
'O',
'l',
'Refer to user messages in programs by keys',
'DUNCAND',
'13'
],
[
'Algorithm::Line::Bresenham',
'a',
'd',
'p',
'f',
'p',
'simple pixellated line-drawing algorithm',
'OSFAMERON',
'6'
],
[
'HTML::EasyTable',
'b',
'n',
'p',
'O',
'p',
'Module for easy HTML table print',
'ANIO',
'15'
],
[
'Danga::Socket',
'M',
'm',
'p',
'O',
'o',
'A non-blocking socket object; uses epoll()',
'BRADFITZ',
'5'
],
[
'FrameMaker::MifTree',
'a',
'd',
'p',
'O',
'p',
'A MIF Parser',
'RST',
'11'
],
[
'Class::MethodFilter',
'a',
'd',
'p',
'O',
'p',
'Easily add filters to accessor-based classes',
'MSTROUT',
'6'
],
[
'Physics::Solar::VSO',
'a',
'd',
'p',
'O',
'p',
'Virtual Solar Observatory interfaces',
'ONEIROS',
'23'
],
[
'NEXT::init',
'R',
'd',
'p',
'p',
'p',
'DWIM data inheritence for hashes and arrays.',
'LEMBARK',
'2'
],
[
'Class::DBI::Test::TempDB',
'R',
'd',
'p',
'O',
'p',
'Maintain a SQLite database for testing CDBI',
'LAMECH',
'6'
],
[
'Image::ExifTool',
'R',
'd',
'p',
'O',
'p',
'Read and write meta information in images',
'EXIFTOOL',
'18'
],
[
'Sys::Filesystem',
'c',
'd',
'p',
'O',
'p',
'Get list of filesystems and their properties',
'NICOLAW',
'4'
],
[
'fields::aliased',
'R',
'd',
'h',
'p',
'p',
'creates lexical aliases to fields',
'KVAIL',
'2'
],
[
'Win32::SAPI5',
'a',
'd',
'p',
'O',
'p',
'Perl interface for the Microsoft Speech API5',
'JOUKE',
'22'
],
[
'Audio::FLAC::Header',
'R',
'd',
'h',
'O',
'p',
'Access to FLAC audio metadata',
'DANIEL',
'23'
],
[
'Audio::FLAC::Decoder',
'R',
'd',
'c',
'O',
'p',
'Perl bindings to the FLAC audio decoder',
'DANIEL',
'23'
],
[
'Graph::Layout::Aesthetic',
'R',
'd',
'h',
'O',
'g',
'Aesthetic Graph Layout',
'THOSPEL',
'6'
],
[
'File::RandomAccess',
'R',
'd',
'p',
'O',
'p',
'Allow random access reads of sequential file',
'EXIFTOOL',
'21'
],
[
'File::Find::Closures',
'c',
'd',
'p',
'f',
'p',
'ready-made \\&wanted functions for File::Find',
'BDFOY',
'10'
],
[
'Net::Packet',
'M',
'd',
'h',
'O',
'a',
'unified framework to send a receive packets',
'GOMOR',
'5'
],
[
'HTTP::Cookies::Find',
'b',
'd',
'p',
'O',
'p',
'Locate cookies for the current user',
'MTHURN',
'15'
],
[
'Text::vCard',
'M',
'd',
'p',
'O',
'p',
'Parse/edit vCard (rfc2426) vcf addressbooks',
'LLAP',
'11'
],
[
'Data::Variant',
'R',
'd',
'p',
'h',
'p',
'Variant datatypes',
'LEIJON',
'6'
],
[
'Email::Send::SMTP::Auth',
'R',
'd',
'p',
'O',
'p',
'Send messages using SMTP with login/password',
'MTHURN',
'19'
],
[
'Multimedia::SDP',
'a',
'd',
'h',
'O',
'l',
'The Session Description Protocol  classes',
'WGDAVIS',
'11'
],
[
'Lingua::Alphabet::Phonetic',
'R',
'd',
'p',
'O',
'p',
'Map ABC\'s to phonetic alphabets',
'MTHURN',
'11'
],
[
'Tie::Assert',
'a',
'd',
'p',
'O',
'p',
'Enforces restrictions on variables\' contents',
'MOLT',
'6'
],
[
'Net::Address::Ethernet',
'R',
'd',
'p',
'f',
'p',
'Find hardware/ethernet/MAC address',
'MTHURN',
'5'
],
[
'Script::Toolbox',
'R',
'u',
'p',
'h',
'p',
'A toolbox for the daily business scripts',
'ECKARDT',
'12'
],
[
'Text::Contraction',
'b',
'd',
'p',
'O',
'p',
'Finds possible expansions for contractions.',
'BHOLZMAN',
'11'
],
[
'POE::Loop::Glib',
'b',
'd',
'p',
'n',
'p',
'POE interface to the Glib mainloop',
'MARTIJN',
'20'
],
[
'Module::Install::Skip',
'R',
'd',
'p',
'O',
'p',
'Module::Install extension',
'RUZ',
'2'
],
[
'Project::Gantt',
'a',
'd',
'p',
'O',
'p',
'Gantt charts for project management',
'AWESTHOLM',
'23'
],
[
'Text::Similarity',
'b',
'd',
'p',
'O',
'g',
'measure the similarity of text documents',
'JASONM',
'11'
],
[
'WWW::Lunarstorm',
'R',
'd',
'p',
'O',
'p',
'Lunarstorm (www.lunarstorm.se) interface',
'BUMBY',
'15'
],
[
'WebService::BabelFish',
'a',
'm',
'p',
'O',
'p',
'OO interface to babel.altavista.com',
'DMUEY',
'15'
],
[
'Business::OnlinePayment::Moneris',
'b',
'd',
'p',
'O',
'p',
'Moneris Online Payment Module',
'DOWNHOM',
'23'
],
[
'Business::Payroll',
'R',
'd',
'p',
'O',
'p',
'Payroll processing pipeline via XML',
'JAMESP',
'23'
],
[
'SVG::Template',
'a',
'm',
'p',
'O',
'g',
'A Templating system for SVG based on SVG.pm',
'RONAN',
'18'
],
[
'Finance::SE::PPM',
'b',
'd',
'p',
'O',
'p',
'Interface to the Swedish PPM pension saving',
'ERWAN',
'23'
],
[
'Net::Chat::Daemon',
'a',
'd',
'p',
'O',
'p',
'Daemon controllable via instant messages',
'SFINK',
'16'
],
[
'Date::Hebrew',
'c',
'd',
'h',
'h',
'g',
'Perl port of libhdate library',
'EPSALON',
'13'
],
[
'Data::Diff',
'a',
'd',
'p',
'h',
'p',
'data structure comparison utility',
'GCAMPBELL',
'6'
],
[
'Business::AU::ACN',
'b',
'd',
'p',
'f',
'p',
'Check an Australian Company Number is valid',
'SCOTT',
'23'
],
[
'Test::WWW::Accessibility',
'i',
'd',
'p',
'f',
'p',
'test web pages for accessibility',
'BDFOY',
'15'
],
[
'MARC::Errorchecks',
'b',
'd',
'p',
'h',
'p',
'Checks for errors in MARC record data',
'EIJABB',
'7'
],
[
'Net::PSYC',
'b',
'd',
'p',
'h',
'p',
'Protocol for SYncronous Conferencing',
'AGOE',
'5'
],
[
'Business::AU::TFN',
'b',
'd',
'p',
'f',
'p',
'Check an Australian Tax File Number (TFN)',
'SCOTT',
'23'
],
[
'Syntax::Highlight::Shell',
'b',
'd',
'p',
'O',
'p',
'Highlight shell scripts',
'SAPER',
'11'
],
[
'POE::Session::Cascading',
'R',
'd',
'p',
'O',
'b',
'Stack-like POE Sessions',
'SUNGO',
'16'
],
[
'POE::Component::DebugShell',
'R',
'd',
'p',
'h',
'b',
'Readline based debug shell for POE',
'SUNGO',
'16'
],
[
'POE::Component::ControlPort',
'R',
'd',
'p',
'h',
'b',
'network control port for POE applications',
'SUNGO',
'16'
],
[
'POE::API::Hooks',
'R',
'd',
'p',
'f',
'b',
'Implement lightweight hooks into POE',
'SUNGO',
'16'
],
[
'Class::Inheritance',
'a',
'n',
'p',
'O',
'p',
'Debug or set multiple inheritance',
'NIELSEN',
'6'
],
[
'Class::Mix',
'R',
'd',
'p',
'f',
'p',
'dynamic class mixing',
'ZEFRAM',
'6'
],
[
'Win32::IIS:SMTP',
'b',
'd',
'p',
'O',
'p',
'Module for sending mail via IIS SMTP',
'GLENSMALL',
'22'
],
[
'XML::GccXml',
'c',
'd',
'p',
'O',
'p',
'Read GCC-XML\'s C/C++ program structure XML',
'MOLT',
'3'
],
[
'Locale::MakePhrase',
'R',
'd',
'p',
'O',
'l',
'Rule based string localisation',
'MATHEW',
'13'
],
[
'Games::Traveller::UWP',
'b',
'd',
'p',
'O',
'p',
'UWP parser for Traveller RPG',
'RJE',
'23'
],
[
'Algorithm::Knapsack',
'b',
'd',
'p',
'O',
'p',
'Brute-force algorithm for knapsack problem',
'ANDALE',
'6'
],
[
'Games::Maze',
'M',
'd',
'p',
'O',
'p',
'Create Mazes as Objects',
'JGAMBLE',
'23'
],
[
'HTTP::Cache::Transparent',
'R',
'm',
'p',
'O',
'p',
'Cache the result of http-gets persistently',
'MATTIASH',
'15'
],
[
'SQL::Abstract::Limit',
'a',
'd',
'p',
'O',
'p',
'portable LIMIT emulation',
'DAVEBAIRD',
'11'
],
[
'Heap::Simple::Perl',
'R',
'd',
'p',
'O',
'p',
'Pure perl implementation for Heap::Simple',
'THOSPEL',
'6'
],
[
'Heap::Simple::XS',
'R',
'd',
'c',
'O',
'p',
'An XS implementation for Heap::Simple',
'THOSPEL',
'6'
],
[
'Acme::Tpyo',
'b',
'd',
'p',
'f',
'p',
'Adds typos to a string',
'SIMCOP',
'11'
],
[
'Lingua::Tolkien::BURL',
'b',
'd',
'p',
'f',
'p',
'Perl in Orkish',
'RJE',
'11'
],
[
'Regexp::Compost',
'c',
'd',
'p',
'O',
'p',
'lexical heuristic reduces alphabet of chars',
'SHIELDS',
'11'
],
[
'Algorithm::Networksort',
'R',
'd',
'p',
'f',
'p',
'Create Sorting Networds',
'JGAMBLE',
'6'
],
[
'DBIx::SimpleQuery',
'a',
'd',
'p',
'h',
'p',
'Query a SQL database with very little code',
'SSIMMS',
'7'
],
[
'Shell::Parser',
'b',
'd',
'p',
'O',
'p',
'Simple shell script parser',
'SAPER',
'11'
],
[
'Tie::Hash::CustomStorage',
'b',
'd',
'p',
'r',
'p',
'Tied hash with tied or object storage',
'DDUMONT',
'6'
],
[
'Class::DBI::Plugin::Pager',
'b',
'd',
'p',
'O',
'p',
'paged queries for CDBI',
'DAVEBAIRD',
'7'
],
[
'Noid',
'b',
'd',
'p',
'f',
'b',
'nice opaque identifier minter and binder',
'JAK',
'7'
],
[
'IPC::Filter',
'R',
'd',
'p',
'f',
'p',
'filter data through an external process',
'ZEFRAM',
'5'
],
[
'WWW::Webjay',
'a',
'd',
'p',
'O',
'g',
'Interface to Webjay.org API',
'SPACEMAN',
'15'
],
[
'Text::SpellChecker',
'b',
'd',
'p',
'O',
'p',
'OO interface to spellcheck blocks of text',
'BDUGGAN',
'11'
],
[
'Tie::Array::CustomStorage',
'b',
'd',
'p',
'r',
'p',
'Tied array with tied or object storage',
'DDUMONT',
'6'
],
[
'Text::Ngram',
'M',
'd',
'p',
'f',
'p',
'Basis for n-gram analysis',
'AMBS',
'11'
],
[
'Text::Affixes',
'R',
'd',
'p',
'f',
'p',
'Prefixes and suffixes analisys of text',
'COG',
'11'
],
[
'Algorithm::ScheduledPath',
'a',
'd',
'p',
'O',
'p',
'Find scheduled paths in a directed graph',
'RRWO',
'6'
],
[
'Games::Score',
'M',
'd',
'p',
'O',
'p',
'Keep track of score in games',
'COG',
'23'
],
[
'IO::Toolkit',
'R',
'm',
'p',
'n',
'p',
'Creates Logfiles for Perl Modules',
'LINMAR',
'8'
],
[
'DBA::Backup',
'a',
'm',
'p',
'O',
'p',
'Manage automated database backups',
'SEANQ',
'7'
],
[
'DBA::Backup::mysql',
'a',
'm',
'p',
'n',
'p',
'MySQL server plugin for DBA::Backup',
'SEANQ',
'7'
],
[
'Win32::SearchPath',
'R',
'd',
'c',
'f',
'p',
'Perl extension for the Win32 API SearchPath',
'CLIVE',
'22'
],
[
'Bio::Affymetrix',
'b',
'd',
'p',
'O',
'p',
'Parses files created by Affymetrix software',
'SKIPPY',
'24'
],
[
'Graph::Clique',
'S',
'n',
'p',
'f',
'o',
'Generation of k-cliques in a graph',
'EWIJAYA',
'6'
],
[
'Mail::DomainKeys',
'b',
'd',
'p',
'O',
'p',
'Perl implementation of Yahoo\'s DomainKeys',
'ANTHONYU',
'19'
],
[
'Class::Data::Reloadable',
'b',
'd',
'p',
'O',
'p',
'inheritable class data survives reloads',
'DAVEBAIRD',
'6'
],
[
'Net::IPP',
'b',
'd',
'p',
'f',
'p',
'Perl Internet Printing Protocol API',
'BIGHIL',
'5'
],
[
'Algorithm::Munkre',
'a',
'm',
'p',
'O',
'g',
'Solution to classical Assignment Problem',
'ANAGHAKK',
'17'
],
[
'Archive::Tar::Stream',
'R',
'd',
'p',
'O',
'p',
'Streaming on-the-fly Tar archive manipulator',
'KIMMORMH',
'17'
],
[
'Class::IntrospectionMethods',
'b',
'd',
'p',
'O',
'p',
'creates methods with introspection',
'DDUMONT',
'6'
],
[
'Algorithm::Munkres',
'a',
'm',
'p',
'O',
'g',
'Solution to classical Assignment Problem',
'ANAGHAKK',
'17'
],
[
'DBIx::SQLEngine',
'R',
'd',
'p',
'O',
'p',
'Extends DBI with high-level operations',
'EVO',
'7'
],
[
'Test::TempDatabase',
'a',
'd',
'p',
'O',
'p',
'Automates creation and dropping of databases',
'BOSU',
'3'
],
[
'Win32::FetchCommand',
'R',
'd',
'c',
'f',
'p',
'Get the command line for a file extension',
'CLIVE',
'22'
],
[
'Net::RTP',
'b',
'd',
'p',
'O',
'l',
'Send and recieve RTP packets (RFC3550)',
'NJH',
'5'
],
[
'Regexp::Assemble',
'R',
'm',
'p',
'O',
'p',
'Combine patterns into single pattern',
'DLAND',
'11'
],
[
'Image::Xbm2bmp',
'b',
'd',
'p',
'O',
'p',
'Convert xbm image  to bmp',
'SHADOWX',
'18'
],
[
'Telephony::CountryDialingCodes',
'R',
'd',
'p',
'O',
'p',
'Int\'l dialing code to country code converter',
'CMANLEY',
'23'
],
[
'Math::Group::Thompson',
'b',
'd',
'p',
'O',
'g',
'Calculate #B(n) on Thompson group F.',
'RALAMOSM',
'23'
],
[
'Mail::Toaster',
'M',
'd',
'p',
'O',
'b',
'a secure full-featured mail server',
'MSIMERSON',
'19'
],
[
'Gtk2::Ex::FormFactory',
'b',
'd',
'p',
'O',
'g',
'Makes building complex Gtk2 GUI\'s easy',
'JRED',
'8'
],
[
'Net::P0f',
'a',
'd',
'p',
'O',
'p',
'Perl wrapper for the P0f utility',
'SAPER',
'5'
],
[
'GD::Barcode::Code93',
'b',
'd',
'p',
'O',
'g',
'GD::Barcode extension for Code93 Symbology',
'DIMARTINO',
'18'
],
[
'Tk::Playlist',
'R',
'd',
'p',
'O',
'p',
'HList widget with "playlist" editing ability',
'CRAKRJACK',
'8'
],
[
'Commands::Guarded',
'b',
'd',
'p',
'h',
'p',
'Better scripting through guarded commands',
'TREY',
'20'
],
[
'Set::Array',
'R',
'd',
'p',
'O',
'p',
'Arrays as objects, with set methods',
'RSAVAGE',
'6'
],
[
'Set::Hash',
'R',
'd',
'p',
'O',
'p',
'Hashes as objects, including set methods',
'RSAVAGE',
'6'
],
[
'Set::String',
'R',
'd',
'p',
'O',
'p',
'Strings as sets of characters',
'RSAVAGE',
'6'
],
[
'GMail::Checker',
'R',
'd',
'p',
'O',
'p',
'GMail wrapper',
'FAYS',
'19'
],
[
'Net::SMS::Clickatell',
'b',
'd',
'p',
'O',
'p',
'Send SMS messages through Clickatell service',
'RALAMOSM',
'24'
],
[
'Lemonldap::Portal',
'b',
'd',
'p',
'O',
'g',
'Lemonldap is a web SSO single sign on',
'EGERMAN',
'15'
],
[
'Chart::Scientific',
'b',
'd',
'p',
'O',
'p',
'A module to make simple scientific 2d plots',
'KESTER',
'18'
],
[
'File::Copy::Recursive',
'R',
'd',
'p',
'f',
'p',
'uses File::Copy to recursively copy dirs',
'DMUEY',
'10'
],
[
'Lemonldap::Portal::Standard',
'b',
'd',
'p',
'O',
'g',
'SSO system based on apache and ldap',
'EGERMAN',
'15'
],
[
'Math::BigInt::GMP',
'R',
'd',
'h',
'f',
'p',
'Use the GMP library for Math::BigInt',
'TELS',
'6'
],
[
'Lemonldap::Portal::Authntsso',
'b',
'd',
'p',
'O',
'g',
'smb authentification for lemonldap SSO',
'EGERMAN',
'15'
],
[
'Lemonldap::Portal::Sslsso',
'b',
'd',
'p',
'O',
'g',
'implementation of client certificate',
'EGERMAN',
'15'
],
[
'SCUBA::Table::NoDeco',
'b',
'd',
'p',
'O',
'p',
'Calculate no-deco limits on repetitive dives',
'PJF',
'23'
],
[
'Finance::Bank::Wachovia',
'b',
'd',
'p',
'O',
'p',
'access account info from Perl via OO module',
'JGARVIN',
'23'
],
[
'News::Article::NoCeM',
'b',
'd',
'p',
'O',
'p',
'a module to generate accurate nocem notices',
'LEEYM',
'19'
],
[
'Verilog::GetInfo',
'R',
'd',
'p',
'O',
'p',
'Get info on Verilog design',
'ROHITM',
'9'
],
[
'POE::Component::Pool::Thread',
'b',
'd',
'p',
'O',
'o',
'Boss session for managing Worker threads',
'TAG',
'5'
],
[
'Teamspeak',
'a',
'd',
'p',
'O',
'p',
'OO Interface to the Voice-Server Teamspeak',
'MALETIN',
'24'
],
[
'Plugin::Installer',
'R',
'd',
'p',
'h',
'p',
'Autoload interface for installing plugins.',
'LEMBARK',
'3'
],
[
'Plugin::Language::DML',
'b',
'd',
'p',
'h',
'p',
'Plugin language handled by Plugin::Installer',
'LEMBARK',
'3'
],
[
'Data::Paginate',
'R',
'd',
'p',
'O',
'p',
'OO interface to paginate data  with 1 module',
'DMUEY',
'6'
],
[
'CGI::Application::Plugin::Stream',
'R',
'd',
'p',
'O',
'p',
'CGI::Application Plugin for streaming files',
'PURDY',
'15'
],
[
'Weather::NOAA::GFS',
'a',
'n',
'p',
'O',
'g',
'forecast weather maps from NOAA GFS site',
'LBECCHI',
'23'
],
[
'POE::Component::IRC',
'M',
'd',
'p',
'h',
'p',
'A POE component for building IRC clients',
'BINGOS',
'5'
],
[
'Data::Validate',
'b',
'd',
'p',
'h',
'p',
'Lightweight data validation and untainting',
'SONNEN',
'6'
],
[
'Test::Numeric',
'R',
'd',
'p',
'f',
'p',
'Testing for numbers.',
'EVDB',
'3'
],
[
'AxKit::XSP::Sendmail',
'M',
'm',
'p',
'h',
'a',
'XSP Taglib for sending email',
'MSERGEANT',
'15'
],
[
'Text::Table',
'R',
'd',
'p',
'O',
'p',
'Organize Data in Tables',
'ANNO',
'11'
],
[
'Math::FresnalZone',
'R',
'd',
'p',
'f',
'p',
'[do not use - remove] misspelled fresnel :)',
'DMUEY',
'23'
],
[
'Template::Plugin::Translit::RU',
'b',
'd',
'p',
'O',
'p',
'TT2 plugin for transliterating cyrillic text',
'LIOL',
'11'
],
[
'iCal::Parser::SAX',
'a',
'd',
'p',
'O',
'p',
'Generate SAX events from an iCalendar',
'RFRANKEL',
'11'
],
[
'iCal::Parser',
'a',
'd',
'p',
'O',
'p',
'Parse iCalendar files into a data structure',
'RFRANKEL',
'11'
],
[
'Lemonldap::Crypto',
'i',
'd',
'p',
'O',
'p',
'Symetric signature for Lemonldap::NG',
'GUIMARD',
'15'
],
[
'Lemonldap::Config::Parameters',
'b',
'd',
'p',
'O',
'g',
'manages the lemonldap SSO configuration',
'EGERMAN',
'15'
],
[
'Math::FresnelZone',
'M',
'd',
'p',
'f',
'p',
'Calculate Fresnel Zone for a distance & freq',
'DMUEY',
'23'
],
[
'Sub::Recursive',
'b',
'd',
'p',
'f',
'p',
'Anonymous memory leak free recursive subs',
'LODIN',
'3'
],
[
'Test::MockRandom',
'R',
'd',
'p',
'h',
'p',
'Override randoms with non-random behavior',
'DAGOLDEN',
'3'
],
[
'Env::Bash',
'R',
'd',
'p',
'h',
'p',
'Perl access to all bash environ variables',
'BEAU',
'4'
],
[
'Voicent',
'R',
'd',
'p',
'f',
'o',
'Make telephone calls using Voicent Gateway',
'ANDREWIK',
'24'
],
[
'XML::DT',
'M',
'd',
'p',
'f',
'p',
'XML Down Translation Module',
'JJOAO',
'11'
],
[
'Tie::Cvs',
'R',
'd',
'p',
'r',
'p',
'Tie hashes with CVS',
'AMBS',
'6'
],
[
'Lingua::PT::PLN',
'S',
'd',
'p',
'f',
'p',
'Portuguese Natural Language Processing',
'AMBS',
'11'
],
[
'Convert::Wiki',
'b',
'd',
'p',
'O',
'g',
'Convert HTML/POD/TXT from/to Wiki code',
'TELS',
'11'
],
[
'Net::IP::Match::XS',
'R',
'd',
'c',
'f',
'p',
'Match an IP address against a range using C',
'BEAU',
'5'
],
[
'Class::DBI::Template',
'b',
'd',
'p',
'O',
'p',
'Class::DBI / Template Toolkit interface',
'JASONK',
'7'
],
[
'CGI::Session::DB2',
'b',
'd',
'p',
'O',
'p',
'DB2 backing for CGI::Session',
'DMCBRIDE',
'15'
],
[
'Filesys::DiskUsage',
'R',
'd',
'p',
'f',
'p',
'Estimate file space usage (similar to `du`)',
'COG',
'10'
],
[
'Unicode::UTF8simple',
'R',
'd',
'p',
'O',
'p',
'Conversions to/from UTF8 from/to characterse',
'GUS',
'13'
],
[
'Palm::SMS',
'R',
'd',
'p',
'O',
'g',
'Manipulate SMS PDB files for PalmOS',
'LOLO',
'7'
],
[
'X11::FreeDesktop::DesktopEntry',
'b',
'd',
'p',
'O',
'p',
'Interface to Freedesktop.org .desktop files',
'GBROWN',
'8'
],
[
'Date::Holidays::AU',
'a',
'd',
'p',
'f',
'p',
'australian public holidays',
'DDICK',
'6'
],
[
'GD::Image::AnimatedGif',
'M',
'd',
'p',
'O',
'p',
'Super easy way to create Animated Gifs w/ GD',
'DMUEY',
'18'
],
[
'Search::Glimpse',
'S',
'd',
'p',
'O',
'p',
'Perl interface to the Glimpse file indexer',
'AMBS',
'11'
],
[
'File::Monitor',
'c',
'd',
'p',
'O',
'p',
'File monitoring interface',
'FAYS',
'10'
],
[
'Finance::Amortization',
'b',
'd',
'p',
'O',
'd',
'Amortization Table interface',
'WAGNER',
'23'
],
[
'Test::Number::Delta',
'R',
'd',
'p',
'f',
'p',
'Test absolute difference between numbers',
'DAGOLDEN',
'3'
],
[
'iCal::Parser::HTML',
'a',
'd',
'p',
'O',
'p',
'Generate HTML calendars from iCalendars',
'RFRANKEL',
'11'
],
[
'Tie::File::AsHash',
'b',
'd',
'p',
'r',
'p',
'Access the lines of a file via a Perl hash',
'CANGELL',
'6'
],
[
'AI::NNFlex',
'a',
'd',
'p',
'O',
'p',
'Flexible API for neural networks',
'CCOLBOURN',
'23'
],
[
'Lingua::Treebank',
'R',
'd',
'p',
'O',
'p',
'convert and use Penn Treebank & others',
'KAHN',
'11'
],
[
'Net::DNS::DynDNS',
'b',
'd',
'p',
'O',
'p',
'Interface to www.dyndns.org',
'DDICK',
'5'
],
[
'Text::Tokenizer',
'M',
'd',
'h',
'O',
'g',
'Text tokenizer',
'SAMSK',
'11'
],
[
'GD::Image::Thumbnail',
'M',
'd',
'p',
'O',
'p',
'GD Subclass to create thumbnails even easier',
'DMUEY',
'18'
],
[
'Text::TagTemplate',
'M',
'd',
'p',
'h',
'l',
'Replace tags with generated content',
'MATISSE',
'11'
],
[
'App::Options',
'R',
'd',
'p',
'f',
'p',
'combine cmdline opts, env vars, config files',
'SPADKINS',
'12'
],
[
'Chatbot::Alpha',
'R',
'd',
'p',
'O',
'g',
'AiChaos Alpha Response Brain',
'KIRSLE',
'11'
],
[
'MathML::Entities',
'b',
'd',
'p',
'f',
'a',
'Convert XHTML+MathML named entities',
'DISTLER',
'15'
],
[
'IPC::UPDmsg',
'b',
'd',
'p',
'O',
'p',
'provides cross platform IPC message passing',
'RLAUGHLIN',
'5'
],
[
'Gtk2::Ex::DBI',
'R',
'd',
'p',
'O',
'l',
'Bind a Gtk2::GladeXML to DB server via DBI',
'DKASAK',
'7'
],
[
'Lemonldap::Portal::Cda',
'b',
'n',
'p',
'O',
'g',
'provides Cross Domain Authentification',
'EGERMAN',
'15'
],
[
'Math::Business::MACD',
'M',
'd',
'p',
'O',
'g',
'extension for calculating MACDs',
'JETTERO',
'6'
],
[
'Math::Business::SMA',
'M',
'd',
'p',
'O',
'g',
'Perl extension for calculating simple moving',
'JETTERO',
'6'
],
[
'Mobile::UserAgent',
'R',
'd',
'p',
'O',
'p',
'Mobile user agent string parsing class.',
'CMANLEY',
'15'
],
[
'GD::Image::Orientation',
'M',
'd',
'p',
'O',
'p',
'Determine if GD image is vertical/horizontal',
'DMUEY',
'18'
],
[
'Java::Swing',
'b',
'd',
'h',
'O',
'p',
'Perl bindings for Java Swing GUI',
'PHILCROW',
'8'
],
[
'Flickr::Upload',
'R',
'd',
'p',
'f',
'p',
'module for uploading to Flickr.com',
'CPB',
'24'
],
[
'Test::MockDBI',
'a',
'd',
'p',
'O',
'p',
'Test by mocking-up DBI',
'MLFISHER',
'3'
],
[
'Finance::Bank::Commerzbank',
'a',
'd',
'p',
'O',
'p',
'Online Banking Interface for Commerzbank  AG',
'TOBI',
'23'
],
[
'Apache::Authen::Program',
'b',
'd',
'p',
'f',
'p',
'authenticate by output of specified program',
'MLFISHER',
'15'
],
[
'Sort::Radix',
'S',
'd',
'p',
'f',
'p',
'A multiple passes distribution algorithm',
'EWIJAYA',
'6'
],
[
'Log::Writer',
'c',
'd',
'h',
'h',
'o',
'Just another logging interface',
'ARPADF',
'21'
],
[
'Games::Go::AGATourn',
'a',
'd',
'p',
'O',
'p',
'parses AGA format tournament files',
'REID',
'23'
],
[
'Finance::Bank::AU::StGeorge',
'b',
'd',
'p',
'O',
'p',
'St George Internet Banking client',
'IWADE',
'23'
],
[
'Time::UTC',
'R',
'd',
'p',
'h',
'p',
'manipulation of UTC in terms of TAI',
'ZEFRAM',
'6'
],
[
'Tie::Constrained',
'R',
'd',
'p',
'r',
'p',
'Pre-validation of changes to variables',
'ZAXO',
'6'
],
[
'List::Part',
'R',
'd',
'p',
'f',
'p',
'Partition one array into several',
'BRENTDAX',
'6'
],
[
'Tie::iCal',
'R',
'd',
'p',
'r',
'p',
'Tie iCal files to Perl hashes',
'BSDZ',
'6'
],
[
'Number::OutlineNumber',
'R',
'd',
'p',
'O',
'p',
'Objects for Outline Numbering strings',
'WILSONPM',
'11'
],
[
'Template::Plugin::Config::General',
'a',
'd',
'p',
'O',
'p',
'TT wrapper around Config::General module',
'LIOL',
'11'
],
[
'Image::Kimdaba',
'b',
'd',
'p',
'f',
'g',
'Parser for the KDE Image Database',
'JMFAYARD',
'18'
],
[
'Net::DHCP',
'b',
'd',
'p',
'O',
'p',
'Interface to DHCP Protocol (RFC2132)',
'SHADINGER',
'5'
],
[
'File::Spec::Link',
'b',
'd',
'p',
'O',
'p',
'reading and resolving symbolic links',
'RMBARKER',
'10'
],
[
'File::Copy::Link',
'b',
'd',
'p',
'f',
'p',
'To replace a link by a copy of the link.',
'RMBARKER',
'10'
],
[
'Games::Diplomacy',
'i',
'n',
'p',
'O',
'p',
'Collection of Diplomacy game modules',
'JAMESTHOM',
'23'
],
[
'Text::Template::Queue',
'S',
'd',
'p',
'O',
'p',
'Easy management for Text::Template objects',
'SILI',
'11'
],
[
'Visio',
'a',
'd',
'p',
'O',
'b',
'mainpulating and creating Visio XML files',
'AAKHTER',
'18'
],
[
'Object::Mediator',
'R',
'd',
'p',
'O',
'p',
'object persistence framework',
'EJS',
'6'
],
[
'Algorithm::SixDegrees',
'b',
'd',
'p',
'O',
'p',
'Find a path through linked elements in a set',
'PETEK',
'6'
],
[
'Lyrics::Fetcher::Google',
'a',
'd',
'p',
'h',
'g',
'Uses google to fetch song lyrics',
'NEBULOUS',
'11'
],
[
'IPC::Shm::Simple',
'a',
'd',
'p',
'O',
'p',
'String data in SysV shared memory.',
'KCODY',
'5'
],
[
'Devel::Fail::Make',
'R',
'd',
'p',
'n',
'p',
'`make` always fails, deliberately',
'MTHURN',
'3'
],
[
'SVG::Template::Graph',
'R',
'd',
'p',
'O',
'p',
'Build line and bar graphs from templates',
'RONAN',
'18'
],
[
'OpenOffice::OODoc',
'R',
'm',
'p',
'O',
'l',
'OpenDocument processing interface',
'JMGDOC',
'11'
],
[
'QWizard',
'M',
'm',
'p',
'O',
'b',
'Easy wizard screens (Gtk2,CGI,Tk,Readline)',
'HARDAKER',
'8'
],
[
'Apache::Voodoo',
'M',
'd',
'p',
'O',
'a',
'Apache/mod_perl web application framework',
'MAVERICK',
'15'
],
[
'Murex',
'c',
'm',
'p',
'O',
'r',
'Murex Configuration',
'LINMAR',
'24'
],
[
'Lemonldap::Handlers::Generic',
'b',
'd',
'p',
'O',
'g',
'Handler for the apache used by lemonldap SSO',
'EGERMAN',
'15'
],
[
'SVG::Manual',
'R',
'd',
'p',
'O',
'p',
'Generate and manipulate SVG XML modules',
'RONAN',
'18'
],
[
'WebService::GoogleMaps',
'a',
'd',
'p',
'f',
'p',
'Retrieves maps from Google Maps',
'KLOHNER',
'15'
],
[
'TiVo::HME',
'a',
'd',
'p',
'O',
'a',
'Pure perl implementation TiVo\'s HME protocol',
'METZZO',
'24'
],
[
'Template::Plugin::SSI',
'R',
'd',
'p',
'O',
'p',
'Plugin to use SSI in Template Toolkit',
'COREY',
'11'
],
[
'DBD::Amazon',
'c',
'd',
'p',
'h',
'a',
'DBI Driver for Amazon ECS API',
'DARNOLD',
'7'
],
[
'Text::Conversation',
'b',
'd',
'p',
'O',
'p',
'Turn a conversation into threads.',
'RCAPUTO',
'11'
],
[
'Test::MockClass',
'a',
'd',
'p',
'O',
'p',
'A module to provide mock classes and objects',
'JJORDAN',
'3'
],
[
'Bundle::Knetrix',
'b',
'd',
'p',
'n',
'n',
'Bundle to install modules for Knetrix',
'ICESPIRIT',
'25'
],
[
'Bio::GMOD',
'b',
'd',
'p',
'O',
'p',
'Unified Generic Model Organism Database API',
'TWH',
'23'
],
[
'Math::Function::Roots',
'b',
'd',
'p',
'f',
'p',
'Collection of Root Finding algorithms',
'SJO',
'6'
],
[
'Maypole::Plugin::Authorization',
'R',
'm',
'p',
'h',
'p',
'Role-based authorization for Maypole apps.',
'DJH',
'14'
],
[
'URI::Obfuscate',
'i',
'd',
'p',
'O',
'g',
'Visually obfuscate a URI',
'DDF',
'15'
],
[
'Error::TryCatch',
'a',
'd',
'p',
'f',
'p',
'OO Exception Handling thru source filtering',
'NILSONSFJ',
'2'
],
[
'Algorithm::Pair::Best',
'a',
'd',
'p',
'O',
'p',
'Pair items according to a \'best score\'',
'REID',
'6'
],
[
'Games::Go::GoPair',
'a',
'd',
'p',
'O',
'p',
'widgets/scripts for running a go tournament',
'REID',
'23'
],
[
'Audio::DB',
'b',
'd',
'p',
'O',
'p',
'Relational DBs of digital audio collections',
'TWH',
'23'
],
[
'Win32::GUI::HyperLink',
'R',
'd',
'p',
'O',
'p',
'A Win32::GUI HyperLink Label',
'ROBERTMAY',
'22'
],
[
'Sys::PortIO',
'a',
'd',
'h',
'f',
'p',
'Perform direct port I/O from Perl',
'ANDREWHO',
'4'
],
[
'Yahoo::Search',
'R',
'd',
'p',
'O',
'b',
'Official interface to Yahoo!s Search API',
'JFRIEDL',
'15'
],
[
'Mac::Growl',
'R',
'm',
'h',
'f',
'b',
'Interface to the Growl framework',
'CNANDOR',
'4'
],
[
'PHP',
'b',
'd',
'h',
'f',
'p',
'embedded PHP interpreter',
'KARASIK',
'9'
],
[
'Math::Fibonacci::Phi',
'a',
'd',
'p',
'f',
'p',
'Adds Phi support to Math::Fibonacci',
'DMUEY',
'23'
],
[
'BBDB::Export',
'b',
'd',
'p',
'O',
'b',
'versatile emacs-bbdb exporter',
'VVU',
'7'
],
[
'Data::Validate::Domain',
'R',
'd',
'p',
'h',
'p',
'Light weight module for validating domains',
'NEELY',
'6'
],
[
'Data::Validate::IP',
'R',
'd',
'p',
'h',
'p',
'Lightweight IP validation module.',
'NEELY',
'6'
],
[
'DBD::TSM',
'a',
'd',
'p',
'O',
'p',
'Perl DBD driver for TSM admin client',
'LBENDAVID',
'7'
],
[
'Net::EPP::Client',
'b',
'n',
'p',
'O',
'p',
'Perl client module for the EPP protocol.',
'GBROWN',
'5'
],
[
'Taint::Runtime',
'b',
'd',
'p',
'f',
'p',
'Runtime enable taint checking',
'RHANDOM',
'2'
],
[
'WWW::Patent::Page',
'a',
'd',
'p',
'O',
'p',
'Patent document pages downloader; OO',
'ANONWB',
'15'
],
[
'List::Rotation::Cycle',
'R',
'd',
'p',
'O',
'p',
'Cycle through a list of values',
'PELAGIC',
'6'
],
[
'Gtk2::Ex::PopupWindow',
'R',
'd',
'p',
'O',
'l',
'A PopupWindow widget for Gtk2',
'LEEDO',
'8'
],
[
'Games::Tournament::BlackJack',
'a',
'd',
'p',
'h',
'p',
'BlackJack Simulation Environment',
'PJACOBS',
'23'
],
[
'MRTG::Parse',
'b',
'd',
'p',
'f',
'l',
'Parse and utilize MRTG logfiles',
'MARIOF',
'11'
],
[
'Games::Perlwar',
'c',
'd',
'p',
'O',
'p',
'Perl variant of the classic Corewar game',
'YANICK',
'23'
],
[
'SQL::Abstract',
'M',
'd',
'p',
'O',
'p',
'Generate SQL from Perl data structures',
'NWIGER',
'7'
],
[
'POE::Loop::Wx',
'a',
'd',
'p',
'f',
'p',
'a bridge to support Wx\'s event loop from POE',
'MIKE',
'8'
],
[
'Syntax::Highlight::Universal',
'R',
'd',
'+',
'h',
'p',
'Syntax highlighter based on Colorer library',
'PALANT',
'11'
],
[
'Devel::Fail::MakeTest',
'R',
'd',
'p',
'n',
'p',
'`make test` always fails, deliberately',
'MTHURN',
'3'
],
[
'WWW::Mechanize:Frames',
'c',
'n',
'p',
'f',
'p',
'WWW::Mechanize extension for frames',
'CPANPERL',
'15'
],
[
'Math::Random::Brownian',
'b',
'd',
'c',
'O',
'p',
'Generates realizations of Brownian Motion',
'WMSZELIGA',
'23'
],
[
'Test::MockTime',
'a',
'd',
'p',
'f',
'p',
'Mock time/localtime for testing',
'DDICK',
'3'
],
[
'File::Format::RIFF',
'R',
'd',
'p',
'O',
'p',
'Resource Interchange File Format/RIFF files',
'STURM',
'21'
],
[
'XML::Tidy',
'R',
'd',
'p',
'O',
'g',
'tidy indenting of XML documents',
'PIP',
'11'
],
[
'XML::Merge',
'R',
'd',
'p',
'O',
'g',
'flexibly merge XML documents',
'PIP',
'11'
],
[
'Games::Cards::Poker',
'R',
'd',
'p',
'f',
'g',
'Pure Perl Poker Functions',
'PIP',
'23'
],
[
'Perl6::Subs',
'a',
'd',
'p',
'p',
'l',
'Define subs in w/named parameters like Perl6',
'CHIPS',
'28'
],
[
'Net::FTP::File',
'R',
'd',
'p',
'O',
'p',
'Simply File operations with Net::FTP',
'DMUEY',
'15'
],
[
'Template::Plugin::HTML::BBCode',
'b',
'd',
'p',
'O',
'p',
'TT2 wrapper around HTML::BBCode module',
'LIOL',
'11'
],
[
'Stream::Reader',
'b',
'd',
'p',
'O',
'p',
'is a stream reader',
'ONDR',
'21'
],
[
'Win32::Word::Writer',
'b',
'd',
'p',
'O',
'p',
'Create Microsoft Word documents',
'JOHANL',
'22'
],
[
'Text::Starfish',
'a',
'd',
'p',
'h',
'p',
'Perl-based System for Text-Embedded Programm',
'VLADO',
'11'
],
[
'Digest::MD5::File',
'R',
'd',
'p',
'O',
'p',
'Digest::MD5 Sub Class to use paths directly',
'DMUEY',
'14'
],
[
'Oracle::Sqlldr',
'a',
'd',
'p',
'O',
'p',
'Perl wrapper around Oracle\'s sqlldr utility.',
'MCGREGOR',
'7'
],
[
'DBD::Pg',
'M',
'm',
'c',
'O',
'p',
'Postgres Driver for DBI',
'DBDPG',
'7'
],
[
'Number::Phone::IE',
'b',
'd',
'p',
'O',
'p',
'Ireland-specific methods for Number::Phone',
'DERMOT',
'11'
],
[
'Cache::Repository',
'b',
'd',
'p',
'O',
'p',
'Generic file repository handling',
'DMCBRIDE',
'17'
],
[
'Tie::Cycle::Sinewave',
'R',
'd',
'p',
'r',
'p',
'Cycle through values following a sinewave',
'DLAND',
'6'
],
[
'Class::AutoloadCAN',
'R',
'd',
'p',
'h',
'p',
'Write CAN instead of AUTOLOAD.',
'TILLY',
'2'
],
[
'Win32::Share',
'c',
'a',
'p',
'O',
'g',
'to create/manage Shares remotely on  machine',
'MNIKHIL',
'22'
],
[
'Text::StripAccents',
'a',
'd',
'p',
'h',
'p',
'Convert accented characters to unaccented.',
'CCOLBOURN',
'11'
],
[
'Bio::ASN1::EntrezGene',
'R',
'd',
'p',
'O',
'p',
'Parser for NCBI Entrez Gene (ASN.1-format)',
'MINGYILIU',
'23'
],
[
'Apache::AuthCookieDBI',
'M',
'd',
'p',
'O',
'l',
'Use a DBI datasource with Apache::AuthCookie',
'MATISSE',
'15'
],
[
'Games::Multiplayer::Manager',
'R',
'd',
'p',
'f',
'g',
'Multiplayer games manager',
'KIRSLE',
'23'
],
[
'Lingua::ManagementSpeak',
'b',
'd',
'p',
'O',
'p',
'Tool to build managerial-sounding documents',
'GRYPHON',
'11'
],
[
'Mobile::WURFL',
'b',
'd',
'p',
'O',
'l',
'Interface to WURFL data file',
'VALDEZ',
'15'
],
[
'Win32::File::Summary',
'R',
'n',
'+',
'O',
'p',
'Shows Win32 File summary informations',
'RPAGITSCH',
'22'
],
[
'Image::Epeg',
'a',
'd',
'h',
'O',
'p',
'Resize jpegs at lightning speed',
'MCURTIS',
'18'
],
[
'Astro::SpaceTrack',
'b',
'd',
'p',
'O',
'p',
'Fetch orbital elements from Space-Track.org',
'WYANT',
'23'
],
[
'Net::SMS::BulkSMS',
'R',
'd',
'p',
'O',
'p',
'send SMS messages via provider bulksms.com',
'PEDWARDS',
'5'
],
[
'WordNet::SenseRelate::AllWords',
'a',
'd',
'p',
'O',
'g',
'Semantically Disambiguate All Words in Text',
'TPEDERSE',
'11'
],
[
'Text::Embed',
'a',
'd',
'p',
'r',
'p',
'seperate unwieldy chunks of text from code',
'MCEWAN',
'11'
],
[
'Gnome2::VFS',
'M',
'm',
'c',
'O',
'l',
'Interface to the GNOME VFS library',
'TSCH',
'21'
],
[
'Business::OnlinePayment::Cybersource',
'b',
'd',
'p',
'O',
'p',
'Cybersource implimentation for B::OP',
'PBOWEN',
'23'
],
[
'File::Rename',
'b',
'd',
'p',
'f',
'p',
'Renaming multiple files: based on eg/rename',
'RMBARKER',
'10'
],
[
'CGI::Application::Plugin::CompressGzip',
'b',
'd',
'p',
'n',
'p',
'Add gzip compression to CGI::Application',
'RHESA',
'15'
],
[
'WebService::Upcoming',
'b',
'd',
'p',
'O',
'p',
'A simple interface for the upcoming.org API',
'GKNAUSS',
'15'
],
[
'Data::Sofu',
'b',
'd',
'p',
'O',
'o',
'Interface to "sofu" files',
'MALUKU',
'6'
],
[
'Geo::PostalAddress',
'a',
'd',
'p',
'O',
'b',
'Country-specific postal address management',
'PAUAMMA',
'13'
],
[
'Proc::Fork',
'R',
'd',
'p',
'f',
'p',
'Simple, intuitive interface to fork()',
'ARISTOTLE',
'4'
],
[
'Net::SMS::MessageNet',
'b',
'd',
'p',
'h',
'p',
'Send SMS messages via messagenet.com.au',
'DDICK',
'5'
],
[
'Apache2::AuthCookieDBI',
'M',
'd',
'p',
'O',
'l',
'MP2 AuthCookie module using a DBI datasource',
'MATISSE',
'15'
],
[
'Apache2::AuthenNTLM',
'b',
'd',
'p',
'O',
'p',
'Microsoft NTLM and Basic User Authentication',
'SPEEVES',
'15'
],
[
'CGI::Getopt',
'b',
'd',
'p',
'O',
'p',
'Enable params from file, commandline and CGI',
'GEOTIGER',
'15'
],
[
'Data::Describe',
'R',
'd',
'p',
'O',
'p',
'Find data type & width for delimted data',
'GEOTIGER',
'6'
],
[
'PDF::ReportWriter',
'b',
'd',
'p',
'O',
'l',
'Renders high-quality business reports to PDF',
'DKASAK',
'11'
],
[
'WWW::Postini',
'a',
'd',
'p',
'O',
'p',
'Interact with Postini mail filtering service',
'PGUZIS',
'15'
],
[
'Sort::Key',
'R',
'd',
'c',
'f',
'p',
'sort objects by some (calculated) key',
'SALVA',
'6'
],
[
'WordNet::SenseRelate::TargetWord',
'a',
'd',
'p',
'O',
'g',
'Semantically Disambiguate Given Word in Text',
'TPEDERSE',
'11'
],
[
'Oracle::Reporter',
'c',
'd',
'p',
'O',
'p',
'Create HTML, CSV and XML from Oracle table',
'GEOTIGER',
'7'
],
[
'HTML::Debug',
'a',
'd',
'p',
'O',
'p',
'Add debugging info to your HTML pages.',
'MRANDALL',
'15'
],
[
'Data::Tabular',
'b',
'd',
'p',
'O',
'g',
'Manipulate and output 2d arrays.',
'GAM',
'6'
],
[
'Mozilla::Backup',
'b',
'a',
'p',
'O',
'p',
'Backup and restore Mozilla profiles',
'RRWO',
'15'
],
[
'Pod::Readme',
'b',
'd',
'p',
'h',
'p',
'Convert Module POD to a README file',
'RRWO',
'3'
],
[
'Apache::SiteControl',
'a',
'd',
'p',
'O',
'g',
'Fine grained web app access control',
'AWKAY',
'15'
],
[
'Text::FixEOL',
'R',
'd',
'p',
'O',
'p',
'Canonicalizes mixed convention EOL/EOF',
'SNOWHARE',
'11'
],
[
'URI::virtual',
'b',
'd',
'p',
'O',
'p',
'Use \'em as bookmarks or mirror lists',
'RPAUL',
'15'
],
[
'Oracle::Schema',
'a',
'd',
'p',
'O',
'p',
'Oracle Schema Information and Management',
'GEOTIGER',
'7'
],
[
'Logfile::EPrints',
'c',
'd',
'p',
'h',
'p',
'Parse Apache logs from GNU EPrints',
'TIMBRODY',
'23'
],
[
'Config::YUM',
'a',
'm',
'p',
'O',
'p',
'Config::YUM is used to parse a yum.conf',
'OPITZ',
'12'
],
[
'Apache2::AuthNetLDAP',
'b',
'd',
'p',
'f',
'p',
'mod_perl2 LDAP authentication module',
'SPEEVES',
'15'
],
[
'Class::DBI::Plugin::DeepAbstractSearch',
'b',
'd',
'p',
'O',
'p',
'deep_search_where() method for Class::DBI',
'SRIHA',
'7'
],
[
'Net::DNS::Check',
'a',
'm',
'p',
'O',
'p',
'Module for easy implement a DNS check tool',
'LLT',
'5'
],
[
'Getopt::GUI::Long',
'R',
'm',
'p',
'O',
'p',
'Auto-GUI extending Getopt::Long',
'HARDAKER',
'12'
],
[
'Oracle::DML',
'a',
'd',
'p',
'O',
'p',
'provides functions for Oracle batch DML',
'GEOTIGER',
'7'
],
[
'Oracle::Trigger',
'b',
'd',
'p',
'O',
'p',
'Perl Module for Creating Oracle triggers',
'GEOTIGER',
'7'
],
[
'Net::DRI',
'R',
'd',
'p',
'O',
'g',
'Interface to Domain Name Registries/ars',
'PMEVZEK',
'5'
],
[
'XML::Parser::Wrapper',
'b',
'd',
'p',
'O',
'p',
'Simple object wrapper around XML::Parser',
'DOWENS',
'11'
],
[
'Net::DNS::TestNS',
'b',
'd',
'p',
'O',
'o',
'Test environment nameserver',
'OLAF',
'16'
],
[
'Spreadsheet::ReadSXC',
'b',
'd',
'p',
'f',
'p',
'Extract OpenOffice 1.x spreadsheet data',
'TERHECHTE',
'7'
],
[
'Data::Traverse',
'R',
'd',
'p',
'f',
'p',
'Depth-first traversal with callbacks',
'FRIEDO',
'6'
],
[
'Net::AudioScrobbler',
'b',
'd',
'p',
'O',
'g',
'Provides an interface to AudioScrobbler',
'LEEDO',
'15'
],
[
'DBIx::Counter',
'b',
'd',
'p',
'O',
'p',
'Named counters stored in a database',
'RHESA',
'7'
],
[
'Crypt::X509',
'b',
'm',
'p',
'O',
'g',
'Pure Perl X.509 Parser',
'JACKSONM',
'14'
],
[
'Apache2::PageKit',
'b',
'm',
'p',
'O',
'o',
'MVCC web framework mod_perl, XML, H:T or TT',
'BORISZ',
'15'
],
[
'Event::RPC',
'b',
'd',
'p',
'O',
'p',
'Transparent Client/Server OO RPC framework',
'JRED',
'16'
],
[
'HPUX::Pstat',
'R',
'd',
'c',
'f',
'p',
'access HPUX kernel stats',
'SCHWENKE',
'4'
],
[
'Math::Telephony::ErlangB',
'b',
'd',
'p',
'f',
'p',
'Erlang B functions for dimensioning',
'POLETTIX',
'6'
],
[
'Class::DBI::Plugin::DeepAbstractSearchPager',
'b',
'd',
'p',
'O',
'p',
'paged CDBI::Plugin::DeepAbstractSearch',
'SRIHA',
'7'
],
[
'Spreadsheet::Read',
'b',
'd',
'p',
'r',
'p',
'Transparent read the data from a spreadsheet',
'HMBRAND',
'8'
],
[
'Template::TagParser',
'a',
'd',
'p',
'O',
'a',
'Parses special tags embedded in a template.',
'PAUL',
'11'
],
[
'Text::Highlight',
'b',
'm',
'p',
'O',
'p',
'a flexible text/code/syntax highlighter',
'ICRF',
'11'
],
[
'Net::CyanChat',
'R',
'd',
'p',
'O',
'g',
'Perl Interface to Cyan Worlds\' Chat Room',
'KIRSLE',
'15'
],
[
'Image::ASCII',
'b',
'n',
'p',
'O',
'p',
'Image to HTML, with bicubic scaling to boot',
'NICK',
'18'
],
[
'Geo::Coordinates::OSGB',
'R',
'd',
'p',
'f',
'p',
'Converts Lat/Lon to British grid references',
'TOBY',
'23'
],
[
'Test::Fixme',
'R',
'd',
'p',
'f',
'p',
'check code for FIXMEs.',
'EVDB',
'3'
],
[
'CLucene',
'R',
'd',
'h',
'O',
'l',
'CLucene C++ free text search engine',
'PEDWARDS',
'11'
],
[
'Win32::Net::Session',
'R',
'n',
'c',
'f',
'p',
'List the Session which connected to a Win32',
'RPAGITSCH',
'22'
],
[
'Net::OpenSoundControl',
'M',
'd',
'p',
'O',
'p',
'OpenSound Control client and server',
'CRENZ',
'5'
],
[
'Data::RandomPerson',
'R',
'd',
'p',
'O',
'p',
'Generate people data to populate databases',
'PETERHI',
'6'
],
[
'OzDB',
'b',
'd',
'p',
'O',
'g',
'The OzDB is a text DB format.',
'NEXEN',
'7'
],
[
'SIL::Shoe',
'b',
'd',
'p',
'O',
'p',
'Handles SIL Shoe/Toolbox files and settings',
'MHOSKEN',
'11'
],
[
'GD::Image::CopyIFS',
'a',
'd',
'c',
'O',
'p',
'fractal-based image copying and resizing',
'RKOBES',
'18'
],
[
'Lingua::FI::Inflect',
'c',
'd',
'p',
'f',
'p',
'Finnish inflect',
'VILJUN',
'11'
],
[
'Parse::Nessus::Plugin',
'b',
'd',
'p',
'O',
'g',
'OO methods to parse Nessus plugins',
'RALAMOSM',
'11'
],
[
'Gtk2::Ex::Datasheet::DBI',
'R',
'd',
'p',
'O',
'l',
'Bind a Gtk2::TreeView to DB server via DBI',
'DKASAK',
'7'
],
[
'LWPx::ParanoidAgent',
'M',
'd',
'p',
'O',
'p',
'paranoid subclass of LWP::UserAgent',
'BRADFITZ',
'15'
],
[
'Class::DataStore',
'R',
'd',
'p',
'O',
'p',
'A simple storage system for object data',
'EFOLLEY',
'6'
],
[
'Zeta',
'R',
'd',
'p',
'O',
'g',
'Generic code foundation for various purposes',
'ZETA',
'23'
],
[
'Tuxedo',
'R',
'd',
'c',
'f',
'p',
'tuxedo binding for perl',
'AFRYER',
'24'
],
[
'POE::Component::Client::SMTP',
'b',
'd',
'p',
'O',
'p',
'Asynchronous email sending with POE',
'ULTRADM',
'3'
],
[
'Data::Postponed',
'R',
'd',
'p',
'f',
'p',
'Delayed evaluation & postfacto changes',
'JJORE',
'6'
],
[
'Config::Find',
'M',
'd',
'p',
'O',
'p',
'find configuration files',
'SALVA',
'12'
],
[
'Net::CyanChat::Server',
'R',
'd',
'p',
'O',
'g',
'Perl interface for a CyanChat server.',
'KIRSLE',
'15'
],
[
'Config::General',
'R',
'd',
'p',
'O',
'a',
'Generic config file parser',
'TLINDEN',
'12'
],
[
'Spreadsheet::WriteExcel::Worksheet::SheetProtection',
'R',
'd',
'p',
'O',
'p',
'Sheet Protection for SWE',
'SRIHA',
'7'
],
[
'Search::Kinosearch',
'a',
'm',
'p',
'O',
'p',
'Search::Kinosearch - search engine library',
'CREAMYG',
'11'
],
[
'Net::TL1',
'a',
'd',
'p',
'O',
'p',
'A management interface for network devices',
'STEVENH',
'5'
],
[
'App::Modular',
'R',
'd',
'p',
'O',
'a',
'Application plugin framework (\'Modularizer\')',
'BCEVC',
'3'
],
[
'File::Tabular',
'M',
'd',
'p',
'O',
'p',
'searching and editing flat tabular files',
'DAMI',
'21'
],
[
'CGI::UploadEasy',
'b',
'u',
'p',
'O',
'p',
'Facilitate file uploads',
'GUNNAR',
'15'
],
[
'Sort::External',
'a',
'd',
'p',
'O',
'p',
'Sort::External - sort huge lists',
'CREAMYG',
'6'
],
[
'XML::ApacheFOP',
'R',
'd',
'p',
'O',
'p',
'Use Apache FOP via Perl to create PDF files.',
'KEN',
'11'
],
[
'PAR::WebStart',
'a',
'd',
'p',
'O',
'p',
'Perl implementation of Java\'s WebStart',
'RKOBES',
'15'
],
[
'IPC::Door',
'a',
'u',
'c',
'h',
'p',
'Perl interface to Solaris door library',
'ASARIH',
'5'
],
[
'Apache2::AuthenSmb',
'R',
'd',
'h',
'f',
'p',
'mod_perl NT Authentication module',
'SPEEVES',
'15'
],
[
'Mac::SysProfile',
'R',
'd',
'p',
'O',
'p',
'Perl access to Mac OSXs system profile info',
'DMUEY',
'4'
],
[
'Postgres::Handler',
'b',
'd',
'p',
'O',
'g',
'Accessors for PostgreSQL data',
'CSA',
'7'
],
[
'Net::FTP::Versioning',
'R',
'd',
'p',
'O',
'p',
'Adds versioning support to Net::FTP',
'BNEGRAO',
'5'
],
[
'Audio::Play::MPG321',
'R',
'd',
'p',
'O',
'g',
'An interface to the mpg321 MP3 player.',
'BREEGSTER',
'23'
],
[
'Ekahau',
'b',
'd',
'p',
'O',
'd',
'Interface to Ekahau location sensing system',
'GIFF',
'24'
],
[
'Find::File::Object',
'b',
'd',
'p',
'O',
'g',
'Find::Find like object oriented',
'NANARDON',
'8'
],
[
'WebSphere::MQTT::Client',
'a',
'd',
'c',
'O',
'p',
'IBM WebSphere MQ Telemetry Transport',
'NJH',
'24'
],
[
'CGI::Application::Plugin::HtmlTidy',
'b',
'm',
'p',
'O',
'p',
'Add HTML::Tidy support to CGI::Application',
'RHESA',
'15'
],
[
'WordNet::Similarity::Visual',
'a',
'd',
'p',
'O',
'g',
'Visualization tools for path based measures',
'KOHLIS',
'11'
],
[
'Geo::IP2Location',
'R',
'd',
'p',
'r',
'p',
'Lookup of geographical info by IP address',
'LOCATION',
'13'
],
[
'File::sudoers',
'c',
'd',
'p',
'O',
'p',
'Interface to sudoers database',
'CMORRIS',
'7'
],
[
'Archive::Cabinet',
'R',
'd',
'h',
'f',
'l',
'Cabinet archive extraction',
'BRADD',
'17'
],
[
'Encode::HEBCI',
'R',
'd',
'p',
'O',
'a',
'HTML Entity Based Codepage Inference',
'JBM',
'13'
],
[
'Math::Random::MT::Auto',
'R',
'd',
'c',
'h',
'd',
'Auto-seeded Mersenne Twister PRNGs',
'JDHEDDEN',
'6'
],
[
'Mail::SPF',
'c',
'd',
'p',
'O',
'p',
'Sender Permitted From - Object Oriented',
'SHEVEK',
'19'
],
[
'xDash',
'R',
'd',
'p',
'O',
'o',
'Integration of applications using Jabber',
'JWACH',
'5'
],
[
'Parse::Debian::Sources',
'i',
'd',
'p',
'O',
'p',
'parse the data from a debian Sources.gz',
'HARDCODE',
'11'
],
[
'OpenOffice::PerlPoint',
'a',
'd',
'p',
'O',
'a',
'Converts OpenOffice docs into PerlPoint.',
'JSTENZEL',
'11'
],
[
'Time::Skew',
'c',
'd',
'p',
'f',
'g',
'compute the skew between two clocks',
'AUGUSTO',
'16'
],
[
'Tree::Node',
'b',
'd',
'c',
'h',
'p',
'Memory-efficient tree node implementation',
'RRWO',
'6'
],
[
'Pod::PerlPoint',
'M',
'm',
'p',
'O',
'p',
'Converts POD documents into PerlPoint.',
'JSTENZEL',
'26'
],
[
'Parse::Debian::Release',
'i',
'd',
'p',
'O',
'p',
'parse the data from a debian Release file',
'HARDCODE',
'11'
],
[
'Mono',
'b',
'd',
'h',
'O',
'l',
'Bindings for Mono',
'AMMMA',
'9'
],
[
'Math::Telephony::ErlangC',
'b',
'd',
'p',
'f',
'p',
'Erlang C functions for dimensioning',
'POLETTIX',
'6'
],
[
'IO::Socket::PortState',
'R',
'd',
'p',
'f',
'p',
'Test state of given hash of ports/protocols',
'DMUEY',
'8'
],
[
'HTML::Chunks::Local',
'R',
'd',
'p',
'O',
'p',
'HTML::Chunks templating with localization',
'MBLYTHE',
'15'
],
[
'HTML::Chunks::Super',
'R',
'd',
'p',
'O',
'p',
'HTML::Chunks templating with conditionals',
'MBLYTHE',
'15'
],
[
'CGI::ContactForm',
'M',
'u',
'p',
'f',
'p',
'Generate a web contact form',
'GUNNAR',
'15'
],
[
'Text::Templet',
'R',
'd',
'p',
'f',
'p',
'Template processor using eval()',
'DPETROV',
'11'
],
[
'Apache2::Filter::HTTPHeadersFixup',
'R',
'd',
'p',
'O',
'p',
'manipulate HTTP headers',
'PGOLLUCCI',
'15'
],
[
'GStreamer',
'b',
'm',
'c',
'O',
'l',
'Interface to the GStreamer library',
'TSCH',
'23'
],
[
'Lemonldap::NG::Handler',
'R',
'd',
'p',
'O',
'p',
'Web-SSO handler based on Apache::Session',
'GUIMARD',
'14'
],
[
'Lemonldap::NG::Portal',
'R',
'd',
'p',
'O',
'p',
'Web-SSO portal based on Apache::Session',
'GUIMARD',
'14'
],
[
'Net::DNS::ValueDomain::DDNS',
'R',
'd',
'p',
'O',
'p',
'Update your Value-Domain DynamicDNS records.',
'TYPESTER',
'16'
],
[
'Net::RGTP',
'a',
'd',
'p',
'O',
'p',
'Access bulletin boards like Cambridge GROGGS',
'MARNANEL',
'5'
],
[
'IO::Socket::PortState::cPanel',
'R',
'd',
'p',
'f',
'p',
'xtnd IO::Socket::PortState for cPanel ports',
'DMUEY',
'8'
],
[
'Apache2::DebugFilter',
'S',
'd',
'p',
'O',
'p',
'Debug mod_perl and native Apache2 filters',
'PGOLLUCCI',
'15'
],
[
'Data::Dumper::HTML',
'R',
'd',
'p',
'f',
'p',
'make Data::Dumper output text/html safe',
'DMUEY',
'6'
],
[
'Geo::Caching',
'b',
'd',
'p',
'O',
'p',
'Interface to query www.geocaching.com',
'CPLEE',
'23'
],
[
'Statistics::Gap',
'a',
'm',
'p',
'O',
'g',
'Estimates the #of clusters in a dataset.',
'ANAGHAKK',
'6'
],
[
'Sub::Timebound',
'R',
'd',
'p',
'f',
'p',
'Timebound execution of subroutine',
'MVR',
'3'
],
[
'Win32::ShellExt',
'a',
'd',
'h',
'h',
'p',
'makes Windows Explorer extensions easy',
'JBNIVOIT',
'22'
],
[
'DBIx::Threaded',
'c',
'd',
'p',
'h',
'p',
'DBI subclass to share handles across threads',
'DARNOLD',
'7'
],
[
'WWW::TVguide::NL',
'R',
'd',
'p',
'O',
'p',
'Fetch Dutch TVguide info from gids.omroep.nl',
'BAS',
'15'
],
[
'WWW::Google::SiteMap',
'b',
'd',
'p',
'f',
'p',
'Create Google sitemaps and sitemap indexes',
'JASONK',
'15'
],
[
'Filter::CommaEquals',
'b',
'd',
'p',
'n',
'p',
'Adds support for ,= to any package or script',
'GRYPHON',
'2'
],
[
'Parse::Debian::SourcesList',
'i',
'd',
'p',
'O',
'p',
'parse the data from a debian Sources.list',
'HARDCODE',
'11'
],
[
'Solstice',
'c',
'd',
'p',
'O',
'o',
'The Solstice Development Framework',
'MCRAWFOR',
'3'
],
[
'WWW::Search::UrbanDictionary',
'R',
'd',
'p',
'O',
'p',
'An search interface for urbandictionary.com.',
'SOCK',
'15'
],
[
'Tk::Gpack',
'b',
'u',
'p',
'f',
'g',
'Group widget packer w/ option abbreviations',
'CROSSWIRE',
'8'
],
[
'Lemonldap::Portal::Session',
'a',
'd',
'p',
'O',
'g',
'parser of lemonldap websso session',
'EGERMAN',
'15'
],
[
'Archive::Chm',
'R',
'd',
'h',
'O',
'p',
'Access HTML Help (.chm) files.',
'APALADE',
'17'
],
[
'Linux::Inotify',
'a',
'd',
'p',
'O',
'p',
'interface to inotify API of the Linux kernel',
'TWERNER',
'4'
],
[
'CGI::NoPoison',
'R',
'd',
'p',
'O',
'p',
'No Poison Null Byte in CGI-Vars',
'SGODIN',
'15'
],
[
'Time::Elapse',
'R',
'd',
'p',
'O',
'p',
'Perl extension for monitoring time convenien',
'SGODIN',
'16'
],
[
'Test::PerlTidy',
'R',
'd',
'p',
'f',
'p',
'check that all your files are tidy',
'EVDB',
'3'
],
[
'Cobalt::LCD',
'b',
'd',
'p',
'O',
'g',
'Perl wrapper for using a Cobalt\'s LCD',
'JEFFW',
'23'
],
[
'Jabber::PubSub::JEAI',
'b',
'n',
'p',
'f',
'g',
'Perl interfaces to Erlang\'s J-EAI server 1.0',
'KAILI',
'23'
],
[
'Mobile::Wurfl',
'R',
'd',
'p',
'O',
'a',
'Wurfl - a perl module interface to WURFL',
'AWRIGLEY',
'15'
],
[
'SQL::QueryBroker',
'a',
'd',
'p',
'O',
'p',
'Send sql queries from files to db',
'NRBRT',
'7'
],
[
'WWW::Search::Bookmarks',
'R',
'd',
'p',
'O',
'p',
'An xmlrpc search interface to bookmarks.com',
'SOCK',
'15'
],
[
'Win32::Filenames',
'R',
'd',
'p',
'f',
'g',
'Validate Microsoft Windows filenames',
'BCH',
'22'
],
[
'SyncSort',
'i',
'd',
'p',
'h',
'a',
'SyncSort Unix Interface',
'MAGO',
'24'
],
[
'WWW::Shorten::KUSO',
'R',
'd',
'p',
'f',
'g',
'WWW::Shorten::KUSO - Short URL using kuso.cc',
'KENWU',
'15'
],
[
'FrameNet::WordNet::Detour',
'b',
'd',
'p',
'O',
'p',
'Generate FrameNet frames for WordNet synsets',
'REITER',
'11'
],
[
'DCOP::Amarok::Player',
'a',
'd',
'p',
'O',
'p',
'Interface to Amarok via dcop',
'JCMULLER',
'8'
],
[
'IO::LCDproc',
'a',
'd',
'p',
'O',
'p',
'Interface to LCDproc from perl',
'JCMULLER',
'8'
],
[
'SOAP::Axis',
'i',
'd',
'h',
'O',
'o',
'Perl bindings to Apache Axis\' C++ Libraries',
'BWMCADAMS',
'5'
],
[
'Symbol::Values',
'R',
'd',
'p',
'h',
'p',
'OO interface to values of symbol',
'KMIYAZAKI',
'2'
],
[
'POE::Component::Growl',
'R',
'd',
'p',
'O',
'p',
'Growl notification dispatcher for POE',
'AAR',
'8'
],
[
'Number::Theory',
'i',
'd',
'p',
'O',
'p',
'Number-theoretic',
'BARUCH',
'11'
],
[
'Bio::Phylo',
'a',
'd',
'p',
'O',
'p',
'Analysis and manipulation of phylogenies.',
'RVOSA',
'23'
],
[
'Apache::AuthTkt',
'b',
'd',
'p',
'O',
'p',
'Apache mod_auth_tkt authentication tickets',
'GAVINC',
'15'
],
[
'Class::Measure',
'b',
'd',
'p',
'O',
'p',
'Create, compare, and convert measurements.',
'BLUEFEET',
'6'
],
[
'Class::AutoAccess',
'R',
'd',
'p',
'O',
'p',
'Zero code accessors dynamic implementation.',
'JETEVE',
'6'
],
[
'WWW::Search::Feedster',
'R',
'd',
'p',
'O',
'p',
'Search Feedster',
'SOCK',
'15'
],
[
'Text::Scraper',
'a',
'd',
'p',
'O',
'a',
'Structured data from (un)structured text',
'MCEWAN',
'11'
],
[
'Text::Record::Cleanser',
'i',
'd',
'p',
'O',
'p',
'Normalize text based records',
'KIMRYAN',
'11'
],
[
'Text::Record::Deduper',
'b',
'd',
'p',
'O',
'p',
'Separate duplicate records from a text file',
'KIMRYAN',
'11'
],
[
'RFID::ISO15693::Tag',
'b',
'n',
'p',
'O',
'd',
'An ISO15693 RFID Tag',
'PAINA',
'5'
],
[
'PHP::Interpreter',
'R',
'm',
'c',
'O',
'a',
'Tightly integrated PHP interpereter',
'GSCHLOSS',
'9'
],
[
'Mirago::Search',
'c',
'd',
'p',
'O',
'p',
'Easy to use interface to the Mirago search',
'PAPILLION',
'24'
],
[
'Mac::Spotlight',
'a',
'd',
'h',
'O',
'p',
'Perl interface to OS X Spotlight service',
'AHOSEY',
'4'
],
[
'Games::Dice::Probability',
'b',
'd',
'p',
'O',
'p',
'Calculate dice probabilities.',
'JAD',
'23'
],
[
'Date::Holidays::PT',
'M',
'd',
'p',
'h',
'p',
'Determine Portuguese public holidays',
'COG',
'13'
],
[
'Date::Say::Czech',
'a',
'd',
'p',
'f',
'p',
'Output dates as text as you would speak it',
'HIHIK',
'13'
],
[
'Chatbot::Alpha::Sort',
'b',
'n',
'p',
'O',
'g',
'Perl class for sorting Alpha documents',
'KIRSLE',
'11'
],
[
'Games::SGF::Tournament',
'R',
'd',
'p',
'O',
'g',
'SGF-based tournament',
'CLOWN',
'23'
],
[
'FileSys::Tree',
'R',
'd',
'p',
'f',
'p',
'Filesys to tree-like format (`tree`)',
'COG',
'10'
],
[
'Rose::DB::Object',
'b',
'm',
'p',
'O',
'p',
'Extensible, high performance RDBMS-OO mapper',
'JSIRACUSA',
'7'
],
[
'WWW::Bookmarks',
'b',
'd',
'p',
'O',
'p',
'An interface to Bookmarks servers',
'SOCK',
'15'
],
[
'Rose::Object',
'b',
'd',
'p',
'O',
'p',
'A simple object base class and method maker.',
'JSIRACUSA',
'6'
],
[
'Rose::HTML::Objects',
'b',
'm',
'p',
'O',
'p',
'Object-oriented HTML form and field widgets.',
'JSIRACUSA',
'15'
],
[
'Rose::DateTime',
'b',
'd',
'p',
'O',
'p',
'DateTime helper functions and parser objects',
'JSIRACUSA',
'6'
],
[
'Bundle::Rose',
'b',
'd',
'p',
'n',
'p',
'The Rose web application framework',
'JSIRACUSA',
'25'
],
[
'Number::Theory::CFrac',
'c',
'd',
'p',
'h',
'p',
'Continued Fraction Object & Methods',
'BARUCH',
'11'
],
[
'Rose',
'b',
'd',
'p',
'O',
'p',
'The Rose web application framework',
'JSIRACUSA',
'15'
],
[
'Rose::URI',
'R',
'd',
'p',
'O',
'p',
'URI object built for efficient manipulation',
'JSIRACUSA',
'15'
],
[
'Test::Spelling',
'b',
'd',
'p',
'f',
'p',
'Check for spelling errors in POD',
'ITUB',
'3'
],
[
'PDL::LinearAlgebra',
'a',
'd',
'c',
'h',
'a',
'Linear algebra utils',
'ELLIPSE',
'6'
],
[
'Hey::heyPass',
'R',
'd',
'p',
'O',
'p',
'Perl Interface to hey.nu Network\'s heyPass',
'WILSOND',
'15'
],
[
'Drupal::Module::Starter',
'b',
'd',
'p',
'O',
'p',
'Save the tedium  of creating Drupal modules',
'SMCNABB',
'15'
],
[
'CORBA::Python',
'a',
'd',
'p',
'O',
'a',
'IDL compiler to language Python mapping',
'PERRAD',
'9'
],
[
'Config::Sofu',
'R',
'd',
'p',
'p',
'o',
'Retrieves and stores complex data structures',
'MALUKU',
'12'
],
[
'Class::GAPI',
'R',
'd',
'p',
'O',
'p',
'Generic API, Base class, autoloaded methods',
'CROSSWIRE',
'6'
],
[
'Devel::PerlySense',
'b',
'm',
'p',
'O',
'p',
'IntelliSense for Perl',
'JOHANL',
'3'
],
[
'Chatbot::Alpha::Syntax',
'R',
'n',
'p',
'O',
'g',
'Syntax checking for Chatbot::Alpha',
'KIRSLE',
'11'
],
[
'Text::Record::Filter',
'i',
'd',
'p',
'O',
'p',
'Filter records in a text file',
'KIMRYAN',
'11'
],
[
'HTML::Template::Compiled',
'b',
'd',
'p',
'O',
'p',
'Simple and fast templating module',
'TINITA',
'15'
],
[
'XML::Spew',
'b',
'd',
'p',
'O',
'p',
'Spew small chunks of XML',
'FRIEDO',
'11'
],
[
'PerlIO::via::CBC',
'R',
'd',
'p',
'O',
'p',
'PerlIO layer for CBC encrypted files',
'ESSKAR',
'14'
],
[
'HTML::TagUtil',
'R',
'd',
'p',
'O',
'p',
'Perl Utlity for HTML tags',
'LINC',
'15'
],
[
'Win32::StreamNames',
'R',
'd',
'c',
'f',
'p',
'List stream names for a file on NTFS',
'CLIVE',
'22'
],
[
'Statistics::CalinskiHarabasz',
'a',
'm',
'p',
'O',
'g',
'Estimates the #of clusters in a dataset',
'ANAGHAKK',
'6'
],
[
'Object::AutoAccessor',
'b',
'd',
'p',
'O',
'p',
'Accessor class by using AUTOLOAD',
'PIA',
'6'
],
[
'Genezzo::Contrib::Clustered',
'c',
'd',
'h',
'h',
'g',
'Shared data cluster support for Genezzo',
'EROLLINS',
'7'
],
[
'BBCode::Parser',
'b',
'd',
'p',
'O',
'p',
'Recursive descent BBCode parser',
'DLKING',
'15'
],
[
'MIDI::Praxis::Variation',
'R',
'n',
'p',
'f',
'p',
'Tools for variation technique using MIDI.',
'CBOURNE',
'23'
],
[
'Statistics::Hartigan',
'a',
'm',
'p',
'f',
'g',
'Estimates the #of clusters in a dataset',
'ANAGHAKK',
'6'
],
[
'Iterator',
'b',
'd',
'p',
'O',
'p',
'A general-purpose iterator class',
'ROODE',
'6'
],
[
'Catalyst::Plugin::Authorization::CDBI::GroupToken',
'a',
'd',
'p',
'O',
'p',
'simplified version of group-role-permission',
'SSC',
'15'
],
[
'Iterator::DBI',
'b',
'd',
'p',
'f',
'p',
'An iterator for returning DBI query results.',
'ROODE',
'7'
],
[
'Iterator::IO',
'b',
'd',
'p',
'f',
'p',
'Filesystem and stream iterators.',
'ROODE',
'21'
],
[
'Iterator::Misc',
'b',
'd',
'p',
'f',
'p',
'Miscellaneous iterator functions.',
'ROODE',
'6'
],
[
'Iterator::Util',
'b',
'd',
'p',
'f',
'p',
'Essential utilities for the Iterator class.',
'ROODE',
'6'
],
[
'Thread::Apartment',
'c',
'd',
'p',
'O',
'a',
'Apartment thread wrapper for Perl objects',
'DARNOLD',
'2'
],
[
'Jeens',
'i',
'n',
'p',
'h',
'g',
'A Wiki/Blog/PIM Manager/Photo Album tool',
'JESSESTAY',
'15'
],
[
'HTTP::Client',
'b',
'd',
'p',
'O',
'p',
'Class for creating HTTP clients',
'LINC',
'15'
],
[
'File::Size',
'R',
'd',
'p',
'f',
'p',
'Get file & directory size in several formats',
'DMUEY',
'10'
],
[
'HTML::PopupTreeSelect::Dynamic',
'R',
'd',
'p',
'O',
'p',
'dynamic version of HTML::PopupTreeSelect',
'SAMTREGAR',
'15'
],
[
'Net::eBay',
'b',
'd',
'p',
'f',
'p',
'Communicates with eBy via their XML API',
'ICHUDOV',
'15'
],
[
'List::MRU',
'b',
'd',
'p',
'O',
'p',
'Most-Recently Used Ordered List',
'GAVINC',
'6'
],
[
'Encode::EUCJPMS',
'a',
'd',
'p',
'n',
'p',
'An encoding module for eucJP-ms',
'NARUSE',
'13'
],
[
'Template::Plugin::Lingua::EN::Inflect',
'b',
'd',
'p',
'O',
'p',
'TT2 interface to Lingua::EN::Inflect',
'ANDREWF',
'11'
],
[
'EB',
'a',
'd',
'p',
'O',
'p',
'Electronic Bookkeeping (Dutch/European)',
'JV',
'23'
],
[
'IO::NestedCapture',
'R',
'd',
'p',
'O',
'p',
'Nested capture of the STD* file handles.',
'HANENKAMP',
'21'
],
[
'Xfce4',
'a',
'm',
'h',
'O',
'l',
'Perl bindings for Xfce 4',
'BJT',
'9'
],
[
'Test::Files',
'b',
'd',
'p',
'f',
'p',
'Test file contents and directory structures',
'PHILCROW',
'3'
],
[
'MegaDistro',
'a',
'm',
'p',
'f',
'p',
'Build a package from a list of perl modules.',
'DBUCHMAN',
'23'
],
[
'Data::Sync',
'a',
'd',
'p',
'O',
'p',
'Simple metadirectory/data pump module',
'CCOLBOURN',
'6'
],
[
'CGI::Ajax',
'b',
'm',
'p',
'O',
'p',
'Export perl methods to javascript for AJAX',
'BCT',
'15'
],
[
'Parse::MediaWikiDump',
'a',
'd',
'p',
'O',
'p',
'Tools to assist in parsing MediaWiki dumps',
'TRIDDLE',
'11'
],
[
'SCGI',
'a',
'd',
'p',
'O',
'p',
'SCGI server interface.',
'VIPERCODE',
'15'
],
[
'Log::Localized',
'R',
'd',
'p',
'f',
'p',
'Make logging localized',
'ERWAN',
'3'
],
[
'Geo::Coordinates::Parser',
'R',
'd',
'p',
'O',
'p',
'Parses a coordinate string',
'CRAIHA',
'23'
],
[
'Device::SerialPort::Xmodem',
'R',
'd',
'p',
'O',
'p',
'Xmodem file transfer protocol',
'MITTI',
'5'
],
[
'Slauth',
'b',
'm',
'p',
'O',
'p',
'Apache 2 auth/authz module with plugins',
'IKLUFT',
'15'
],
[
'Games::Baseball::Scorecard',
'b',
'd',
'h',
'O',
'g',
'Generate baseball scorecards',
'CNANDOR',
'23'
],
[
'ORM',
'b',
'd',
'p',
'O',
'l',
'Object-relational mapper',
'AKIMOV',
'7'
],
[
'Win32::AD::Control::DirSync',
'a',
'd',
'p',
'O',
'p',
'LDAPv3 DirSync control wrapper for Net::LDAP',
'AKR',
'22'
],
[
'Template::Plugin::ASCIITable',
'b',
'd',
'p',
'O',
'p',
'TT2 plugin for Text::ASCIITable',
'DAKKAR',
'11'
],
[
'Lemonldap::Cluster::Status',
'b',
'd',
'p',
'O',
'g',
'aggregates sereval server-status apache page',
'EGERMAN',
'15'
],
[
'Acme::Void',
'b',
'n',
'p',
'f',
'p',
'Provide void and void-ish functions',
'RYOCHIN',
'2'
],
[
'WWW::Google::PageRank',
'R',
'd',
'p',
'O',
'p',
'Query PageRank value from Google',
'YKAR',
'15'
],
[
'CGI::WebApp',
'b',
'd',
'p',
'O',
'g',
'Implementation of WebApp.pm MVC using CGI.pm',
'SHAWNVAN',
'15'
],
[
'Net::SMTP::IPMM',
'R',
'd',
'p',
'O',
'p',
'IronPort Mail-Merge Protocol',
'FRIEDO',
'5'
],
[
'IO::Dir::Recursive',
'R',
'd',
'p',
'r',
'p',
'IO::Dir working recursive',
'FLORA',
'21'
],
[
'Module::Optional',
'R',
'd',
'p',
'p',
'p',
'Breaking dependency chains',
'IVORW',
'2'
],
[
'XML::SAX::ExpatXS',
'M',
'd',
'h',
'O',
'p',
'Perl SAX parser using Expat',
'PCIMPRICH',
'11'
],
[
'XML::Validator::RelaxNG',
'a',
'd',
'p',
'O',
'p',
'RelaxNG schema validator',
'PCIMPRICH',
'11'
],
[
'Solaris::Lgrp',
'b',
'd',
'c',
'h',
'o',
'Interface to Solaris liblgrp(3LIB) library',
'AKOLB',
'4'
],
[
'Text::Textile',
'R',
'd',
'p',
'h',
'a',
'Transforms text in Textile format to HTML.',
'BCHOATE',
'11'
],
[
'Audio::MPD',
'R',
'd',
'p',
'O',
'g',
'Class for talking to MPD (Music Player Daemo',
'NJH',
'23'
],
[
'Gtk2::SourceView',
'R',
'm',
'c',
'O',
'l',
'Perl interface to the GtkSourceView library',
'EBASSI',
'8'
],
[
'Log::WithCallbacks',
'R',
'd',
'p',
'O',
'p',
'Log to a file, data formatted by callbacks.',
'DAOTOAD',
'21'
],
[
'JavaScript::Squish',
'R',
'd',
'p',
'O',
'p',
'Compact JavaScript code to minimal length',
'UNRTST',
'9'
],
[
'Win32::IIS::Admin',
'a',
'd',
'p',
'O',
'p',
'Automate administration of IIS webserver',
'MTHURN',
'22'
],
[
'Tie::Hash::RegexKeys',
'S',
'd',
'p',
'f',
'p',
'Extend Tie::HRegex to retrieve the KEYS in p',
'FDULAU',
'6'
],
[
'CGI::Application::Plugin::DevPopup',
'b',
'm',
'p',
'O',
'p',
'Runtime cgiapp info in a popup window',
'RHESA',
'15'
],
[
'Proc::PID::File::Fcntl',
'R',
'd',
'p',
'O',
'p',
'Manage PID files using fcntl() locks',
'JGMYERS',
'16'
],
[
'DB::Table',
'a',
'd',
'p',
'O',
'p',
'Base class for relational table definitions.',
'KITE',
'7'
],
[
'Chatbot::Alpha::Tutorial',
'R',
'n',
'p',
'n',
'n',
'Beginners Guide to Chatbot::Alpha 2.0',
'KIRSLE',
'11'
],
[
'WWW::Search::ISBNDB',
'R',
'd',
'p',
'O',
'p',
'Search for book information on isbndb.com',
'SOCK',
'15'
],
[
'Crypt::GCrypt',
'R',
'd',
'c',
'O',
'p',
'Perl interface to the GNU Crypto library',
'AAR',
'14'
],
[
'CGI::Application::Plugin::Eparam',
'b',
'n',
'p',
'O',
'p',
'multibyte is made easy to use.',
'ASKADNA',
'15'
],
[
'Tk::TOTD',
'a',
'd',
'p',
'f',
'p',
'Tip Of The Day dialog for PerlTk',
'KIRSLE',
'8'
],
[
'Net::ICQ::On',
'R',
'd',
'p',
'f',
'p',
'ICQ Online Tester',
'JEROMEMCK',
'5'
],
[
'DB::Table::Row',
'a',
'd',
'p',
'O',
'p',
'Interface to a row from a DB::Table object',
'KITE',
'7'
],
[
'CGI::FormManager',
'a',
'd',
'p',
'O',
'p',
'manages forms for rendering and validation',
'ANDREWF',
'15'
],
[
'Teradata::BTET',
'b',
'd',
'c',
'O',
'p',
'Perl interface to Teradata SQL',
'GROMMEL',
'7'
],
[
'Apache::SWIT',
'c',
'd',
'p',
'O',
'p',
'Application server with integrated testing',
'BOSU',
'15'
],
[
'Math::Taylor',
'R',
'd',
'p',
'f',
'p',
'Taylor Polynomials and remainders',
'SMUELLER',
'6'
],
[
'Text::Diff3',
'b',
'n',
'p',
'O',
'g',
'compute three way differences between text',
'TOCIYUKI',
'11'
],
[
'Math::Orthonormalize',
'R',
'd',
'p',
'f',
'p',
'Gram-Schmidt Orthonormalization of vectors',
'SMUELLER',
'6'
],
[
'WWW::Sucksub::Divxstation',
'b',
'n',
'p',
'O',
'p',
'automated access to divxstation.com',
'TFOUCART',
'15'
],
[
'IO::Redirect',
'R',
'd',
'p',
'O',
'p',
'redirect|duplicate FH and restore them',
'DMUEY',
'21'
],
[
'Tie::Judy',
'b',
'd',
'h',
'r',
'p',
'Tie a hash to a Judy array',
'BHOLZMAN',
'6'
],
[
'DBIx::VersionedSchema',
'a',
'd',
'p',
'O',
'p',
'Keeps track of database schema versions',
'BOSU',
'7'
],
[
'Net::DBus',
'b',
'm',
'c',
'O',
'p',
'Binding for DBus messaging protocol',
'DANBERR',
'5'
],
[
'Net::SSH2',
'c',
'd',
'h',
'O',
'p',
'SSH 2 protocol interface',
'DBROBINS',
'5'
],
[
'Object::Trampoline',
'R',
'd',
'p',
'O',
'p',
'Delay object construct, module use.',
'LEMBARK',
'6'
],
[
'ETL::Pequel',
'b',
'd',
'p',
'O',
'g',
'Data processing (ETL) Perl program generator',
'GAFFIE',
'7'
],
[
'SLOOPS',
'R',
'd',
'p',
'O',
'l',
'Simple Light  OO Persist System',
'JETEVE',
'7'
],
[
'SOAP::Data::ComplexType',
'b',
'd',
'p',
'O',
'p',
'Complex SOAP::Data object class interface',
'RYBSKEJ',
'5'
],
[
'Encode::Detect',
'a',
'd',
'+',
'O',
'o',
'An Encoding that detects encoding from data',
'JGMYERS',
'13'
],
[
'Encode::Detect::Detector',
'a',
'd',
'+',
'O',
'o',
'The Mozilla universal charset detector',
'JGMYERS',
'13'
],
[
'RTx::RightsMatrix',
'b',
'm',
'p',
'n',
'p',
'Makes rights mgmt. in Request Tracker easier',
'HTCHAPMAN',
'23'
],
[
'Lingua::DE::Wortschatz',
'R',
'd',
'p',
'f',
'p',
'wortschatz.uni-leipzig.de webservice client',
'SCHROEER',
'11'
],
[
'WWW::Sucksub::Attila',
'b',
'd',
'p',
'O',
'p',
'automated access to attila website',
'TFOUCART',
'15'
],
[
'Finance::Risk',
'i',
'd',
'h',
'O',
'p',
'Provides collection of risk management tools',
'TOM',
'23'
],
[
'PDF::Table',
'b',
'd',
'p',
'O',
'p',
'Utility to create table layouts in PDF::API2',
'RHYTHMAN',
'11'
],
[
'Object::InsideOut',
'R',
'd',
'p',
'p',
'p',
'Comprehensive inside-out object support',
'JDHEDDEN',
'6'
],
[
'Algorithm::CurveFit',
'R',
'd',
'p',
'f',
'p',
'Nonlinear Least Squares Fitting',
'SMUELLER',
'6'
],
[
'Audio::Radio::Sirius',
'a',
'd',
'p',
'O',
'p',
'Control Sirius satellite radio tuners',
'JTATUM',
'23'
],
[
'Lingua::TR::Hyphenate',
'R',
'd',
'p',
'O',
'p',
'a hyphenator for Turkish',
'ENGIN',
'11'
],
[
'ModPerl::PackageRegistry',
'b',
'd',
'p',
'h',
'p',
'Map URIs to package namespaces in apache2',
'CRAKRJACK',
'15'
],
[
'Acme::Scripticide',
'R',
'd',
'p',
'n',
'p',
'destroy the script when it has 0 to live for',
'DMUEY',
'2'
],
[
'Acme::ScriptoPhrenic',
'R',
'd',
'p',
'n',
'p',
'make your script randomly change personality',
'DMUEY',
'2'
],
[
'Acme::Enc',
'R',
'd',
'p',
'n',
'p',
'It Enc[rypts] your scripts, Acme Style',
'DMUEY',
'2'
],
[
'Thread::Barrier',
'b',
'd',
'p',
'O',
'p',
'Thread barriers for Perl',
'MROGASKI',
'2'
],
[
'Config::Model',
'b',
'd',
'p',
'O',
'l',
'Fmwk for validation of system configuration',
'DDUMONT',
'12'
],
[
'SVN::Look',
'R',
'd',
'p',
'O',
'p',
'Improved interface to svnlook',
'DMUEY',
'24'
],
[
'Ratpoison',
'b',
'd',
'h',
'f',
'p',
'Ratpoison - communicate with Ratpoison WM',
'BUU',
'5'
],
[
'Digest::MD5::Reverse',
'S',
'n',
'p',
'f',
'p',
'MD5 Reverse Lookup',
'MWDHK',
'11'
],
[
'Test::RandomResults',
'R',
'd',
'p',
'f',
'p',
'Test non-deterministic functions',
'COG',
'3'
],
[
'Tree',
'R',
'm',
'p',
'O',
'p',
'A tree datastructure',
'RKINYON',
'6'
],
[
'Mail::vpopmaild',
'a',
'd',
'p',
'O',
'g',
'A module for interfacing with vpopmaild',
'DDF',
'19'
],
[
'Class::Classless::DBI',
'b',
'd',
'p',
'O',
'p',
'provides DB methods for classless objects',
'MDASH',
'7'
],
[
'SQL::Interpolate',
'R',
'm',
'p',
'h',
'p',
'Interpolate Perl variables into SQL',
'DMANURA',
'11'
],
[
'IP::Anonymous',
'R',
'd',
'p',
'f',
'p',
'Port of Crypto-PAn to anonymize IP addresses',
'JTK',
'5'
],
[
'DBIx::Interpolate',
'R',
'm',
'p',
'h',
'p',
'Interpolate Perl variables into SQL with DBI',
'DMANURA',
'7'
],
[
'WWW::NanoRef',
'a',
'd',
'p',
'O',
'p',
'Creates shortened URLs via nanoref.com',
'DOWENS',
'15'
],
[
'Business::PayPal::SDK',
'b',
'd',
'o',
'O',
'p',
'Perl interface paypal SDKs',
'LINNIN',
'23'
],
[
'Getopt::Long::Descriptive',
'R',
'd',
'p',
'f',
'p',
'Getopt::Long with usage text and validation',
'HDP',
'12'
],
[
'Math::Symbolic::Custom::CCompiler',
'R',
'd',
'h',
'O',
'p',
'Compile Math::Symbolic trees to C',
'SMUELLER',
'6'
],
[
'WWW::Sucksub::Vostfree',
'b',
'd',
'p',
'O',
'p',
'automated access to vost.free.fr database',
'TFOUCART',
'15'
],
[
'Sys::Gamin',
'R',
'd',
'c',
'O',
'p',
'Interface to Gamin\'s FAM implementation',
'GARNACHO',
'4'
],
[
'Audio::Cuefile::Parser',
'R',
'd',
'p',
'O',
'p',
'Parses audio CD .cue files',
'MATTK',
'23'
],
[
'MonetDB::CLI',
'b',
'm',
'p',
'O',
'o',
'MonetDB Call Level Interface',
'SGOELDNER',
'7'
],
[
'MonetDB::CLI::MapiLib',
'b',
'm',
'p',
'O',
'o',
'MonetDB::CLI impl., using MapiLib',
'SGOELDNER',
'7'
],
[
'MonetDB::CLI::MapiPP',
'b',
'm',
'p',
'O',
'o',
'MonetDB::CLI impl., using the Mapi protocol',
'SGOELDNER',
'7'
],
[
'MonetDB::CLI::MapiXS',
'b',
'm',
'h',
'O',
'o',
'MonetDB::CLI impl., using libMapi',
'SGOELDNER',
'7'
],
[
'Math::Symbolic::Custom::Pattern',
'R',
'd',
'p',
'h',
'p',
'Pattern matching on Math::Symbolic trees',
'SMUELLER',
'6'
],
[
'GMail::IMAPD',
'b',
'd',
'p',
'O',
'p',
'IMAP4 interface to Google\'s webmail service',
'KRS',
'19'
],
[
'Goo',
'a',
'd',
'p',
'O',
'a',
'StickThings together with The Goo',
'NIGE',
'3'
],
[
'Unix::PID',
'R',
'd',
'p',
'O',
'p',
'Utility for getting  Process Id info',
'DMUEY',
'4'
],
[
'WWW::Google::Video',
'R',
'd',
'p',
'O',
'g',
'Fetch the information from Google Video',
'KENWU',
'15'
],
[
'Acme::PIA::Export',
'a',
'd',
'p',
'O',
'p',
'Export Interface to Arcor\'s PIA messaging',
'CHRWIN',
'23'
],
[
'PHP::Session::DB',
'b',
'd',
'p',
'O',
'p',
'read / write PHP session stored on databases',
'RALAMOSM',
'11'
],
[
'Crypt::SaltedHash',
'R',
'd',
'p',
'O',
'p',
'Working with salted hashes',
'ESSKAR',
'14'
],
[
'File::Atomic',
'R',
'd',
'p',
'O',
'p',
'Write files atomically',
'DMUEY',
'10'
],
[
'ExtUtils::ModuleMaker',
'M',
'd',
'p',
'h',
'p',
'Better than h2xs for creating modules',
'JKEENAN',
'3'
],
[
'List::Compare',
'M',
'd',
'p',
'h',
'p',
'Compare elements of two or more lists',
'JKEENAN',
'6'
],
[
'BoxBackup',
'a',
'd',
'p',
'O',
'p',
'Modules related to Ben Summers Box Backup',
'PTHOMSEN',
'16'
],
[
'DBIx::Roles',
'b',
'd',
'p',
'h',
'p',
'Roles for DBI handles',
'KARASIK',
'7'
],
[
'Games::DungeonMaker',
'b',
'd',
'+',
'O',
'g',
'Front-end to the DungeonMaker library',
'ACDALTON',
'23'
],
[
'Math::ConvexHull',
'M',
'd',
'p',
'f',
'p',
'Calculate convex hulls using Graham\'s scan',
'SMUELLER',
'6'
],
[
'Math::SymbolicX::Inline',
'R',
'd',
'p',
'f',
'p',
'Inlined Math::Symbolic functions',
'SMUELLER',
'6'
],
[
'DBIx::Transaction',
'b',
'm',
'p',
'O',
'p',
'DBMS-agnostic nested database transactions',
'CRAKRJACK',
'7'
],
[
'Language::Befunge',
'M',
'm',
'p',
'O',
'p',
'Module to interpret Befunge code.',
'JQUELIN',
'9'
],
[
'Apache::Request::I18N',
'a',
'd',
'p',
'O',
'p',
'I18N extension to Apache::Request',
'FBRIERE',
'15'
],
[
'Bio::MCPrimers',
'R',
'd',
'p',
'f',
'p',
'Design molecular cloning PCR primers',
'SLENK',
'23'
],
[
'Win32::SqlServer',
'R',
'd',
'h',
'O',
'p',
'Access Microsoft SQL Server through OLE DB',
'SOMMAR',
'7'
],
[
'Net::Telnet::Cisco::IOS',
'b',
'd',
'p',
'O',
'p',
'Do basic stuff on a Cisco IOS device',
'KRAKEN',
'5'
],
[
'Color::Scheme',
'R',
'd',
'p',
'O',
'p',
'Generate pleasant color schemes',
'IAN',
'8'
],
[
'Lemonolap::Log4lemon',
'a',
'd',
'p',
'O',
'g',
'datawarehouse framework',
'EGERMAN',
'7'
],
[
'Lemonolap',
'a',
'd',
'p',
'O',
'g',
'On-Line Analytical Processing framework',
'EGERMAN',
'7'
],
[
'Bio::mGen',
'R',
'd',
'p',
'f',
'o',
'Preparsed Genbank for DNA extraction',
'CYBER',
'23'
],
[
'Apache::Upload::I18N',
'a',
'd',
'p',
'O',
'p',
'I18N extension to Apache::Upload',
'FBRIERE',
'15'
],
[
'WWW::Sucksub::Frigo',
'b',
'd',
'p',
'O',
'p',
'automated access to frigorifix web database',
'TFOUCART',
'15'
],
[
'Model3D::WavefrontObject',
'R',
'd',
'p',
'O',
'a',
'Read, manp, write Wavefront Object 3D Models',
'DODGER',
'23'
],
[
'String::Util',
'R',
'd',
'p',
'f',
'p',
'Handy string processing utilities',
'MIKO',
'11'
],
[
'PGPLOT::Simple',
'a',
'd',
'p',
'r',
'p',
'Simple Interface for PGPLOT',
'FMERGES',
'18'
],
[
'Net::USPS',
'a',
'd',
'p',
'O',
'p',
'Perl implementation of USPS Online Tools',
'MITTI',
'15'
],
[
'Class::DBI::Storable',
'a',
'd',
'p',
'h',
'p',
'Mixin Storable hooks for Class::DBI',
'BOWMANBS',
'7'
],
[
'PDF::Report::Table',
'a',
'd',
'p',
'O',
'p',
'Adds Table support to PDF::Report',
'MITTI',
'11'
],
[
'VMS::smg',
'R',
'd',
'c',
'f',
'a',
'VMS specific screen and menu manipulations',
'FRIDA',
'4'
],
[
'CGI::Ex',
'b',
'd',
'p',
'O',
'p',
'Utility Suite - applications made fun & easy',
'RHANDOM',
'15'
],
[
'Tie::Plural::Scalar',
'b',
'd',
'p',
'r',
'p',
'Singular or plural variant based on counter',
'LALLIP',
'6'
],
[
'Text::Printf',
'b',
'd',
'p',
'h',
'p',
'Simple templates with printf-like formatting',
'ROODE',
'11'
],
[
'Time::Normalize',
'b',
'd',
'p',
'f',
'p',
'Standardize date/time input values.',
'ROODE',
'6'
],
[
'HTML::BBReverse',
'b',
'd',
'p',
'O',
'p',
'Module to convert HTML to BBCode and back',
'YORHEL',
'15'
],
[
'PostScript::Simple::Table',
'b',
'd',
'p',
'O',
'p',
'Adds table support to PostScript::Simple',
'MITTI',
'11'
],
[
'XML::RSS::FOXSports',
'b',
'd',
'p',
'O',
'p',
'RSS Parser for FOXSports.com RSS Feeds',
'PEREZ',
'11'
],
[
'Audio::TagLib',
'R',
'm',
'+',
'O',
'a',
'a library for processing audio meta data',
'DONGXU',
'23'
],
[
'IMAP::Client',
'a',
'd',
'p',
'O',
'p',
'Full IMAP client library w/ referral support',
'CONTEB',
'19'
],
[
'HTTP::CryptoCookie',
'M',
'd',
'h',
'O',
'd',
'Highly Secure HTTP Cookies',
'DPARIS',
'15'
],
[
'Class::Unique',
'R',
'd',
'p',
'O',
'p',
'Generate per-instance dynamic subclasses',
'FRIEDO',
'2'
],
[
'CMS::Mediawiki',
'b',
'd',
'p',
'O',
'a',
'Clients and tools for managing different CMS',
'RETOH',
'15'
],
[
'Acme::Homer',
'R',
'd',
'p',
'f',
'p',
'Put a little Homer in your code',
'DMUEY',
'2'
],
[
'POSIX::SchedYield',
'a',
'd',
'c',
'f',
'g',
'Execute POSIX sched_yield system call',
'MARCB',
'4'
],
[
'File::Tail::App',
'R',
'd',
'p',
'O',
'p',
'Easy app maker to proc files as they update',
'DMUEY',
'10'
],
[
'Games::Sudoku::General',
'a',
'd',
'p',
'O',
'p',
'Solve Sudoku and Sudoku-like puzzles',
'WYANT',
'23'
],
[
'Eng::Naval',
'i',
'd',
'p',
'O',
'p',
'ITTC Power Prediction Procedure',
'RAGRO',
'23'
],
[
'Class::Clone',
'b',
'd',
'p',
'f',
'p',
'Subclass & copy a class with code on-the-fly',
'CRAKRJACK',
'2'
],
[
'Perl6::Doc',
'a',
'm',
'p',
'n',
'p',
'Perl 6 Documentation Collection',
'AUTRIJUS',
'28'
],
[
'Hardware::Simulator::MIX',
'c',
'd',
'p',
'O',
'p',
'Knuth\'s famous virtual machine',
'LITCHIE',
'4'
],
[
'Algorithm::Step',
'c',
'd',
'p',
'f',
'p',
'Tracing algorithm steps.',
'LITCHIE',
'23'
],
[
'WWW::Yandex::TIC',
'R',
'n',
'p',
'f',
'p',
'Query Yandex Thematic Index of Citing',
'BASHLOV',
'15'
],
[
'Net::LibLO',
'R',
'd',
'c',
'O',
'g',
'Perl interface for liblo Lightweight OSC lib',
'NJH',
'5'
],
[
'Class::Driver',
'a',
'd',
'p',
'O',
'p',
'Generate driver class heiarchies on-the-fly',
'CRAKRJACK',
'2'
],
[
'DBIx::Wrapper::Config',
'a',
'd',
'p',
'O',
'p',
'Config Module for DBIx::Wrapper',
'DOWENS',
'7'
],
[
'LSF::Hosts',
'a',
'd',
'p',
'O',
'a',
'Retrieve information about LSF hosts',
'AUKJAN',
'5'
],
[
'CGI::Carp::DebugScreen',
'b',
'd',
'p',
'h',
'p',
'provides a decent debug screen for Web app',
'ISHIGAKI',
'15'
],
[
'Chatbot::RiveScript',
'b',
'd',
'p',
'O',
'g',
'Perl RiveScript Interpreter',
'KIRSLE',
'11'
],
[
'Jifty',
'b',
'm',
'p',
'h',
'p',
'Nifty applications in a jiffy',
'JESSE',
'15'
],
[
'Audio::TagLib::Shell',
'R',
'd',
'p',
'f',
'p',
'a mini shell of Audio::TagLib',
'DONGXU',
'23'
],
[
'DBIx::Class::FormTools',
'a',
'd',
'p',
'O',
'p',
'Build forms with multiple interconnected obj',
'DJO',
'15'
],
[
'Net::SMTP::TLS',
'a',
'd',
'p',
'O',
'p',
'TLS and AUTH enabled mail client',
'AWESTHOLM',
'19'
],
[
'Net::UPCDatabase',
'b',
'd',
'p',
'O',
'p',
'Simple OO interface to UPCDatabase.com',
'WILSOND',
'15'
],
[
'Chess::GameClock',
'b',
'd',
'p',
'O',
'p',
'Chess or Go digital Clock for portable pc',
'CHESSKIT',
'23'
],
[
'Archive::Tyd',
'b',
'd',
'p',
'O',
'p',
'Tyd Archiving Algorithm',
'KIRSLE',
'17'
],
[
'Test::CPANpm',
'a',
'd',
'p',
'f',
'p',
'Test CPAN.pm\'s interaction with your module',
'CRAKRJACK',
'3'
],
[
'Catalyst::Plugin::Email::Page',
'b',
'd',
'p',
'O',
'p',
'Simple Plugin for Email Links with Catalyst',
'GHENRY',
'15'
],
[
'Acme::Adjudge',
'R',
'd',
'p',
'h',
'p',
'Award damages by law to a given Acme Module',
'DMUEY',
'2'
],
[
'Catalyst::Plugin::DateTime',
'b',
'd',
'p',
'O',
'p',
'DateTime plugin for Catalyst',
'JKISER',
'15'
],
[
'Apache2::ExplorerDestroyer',
'a',
'd',
'p',
'O',
'p',
'Kill Bill\'s Browser with Google AdSense',
'CRAKRJACK',
'15'
],
[
'Convert::Addressbook::Mozilla2Blackberry',
'R',
'd',
'p',
'O',
'g',
'translate the Mozilla address book to a CSV',
'KRIPT',
'11'
],
[
'Net::Proxy',
'b',
'd',
'p',
'O',
'p',
'Framework for proxying network connections',
'BOOK',
'16'
],
[
'Math::Macopt',
'R',
'u',
'+',
'O',
'l',
'A perl wrapper for macopt++',
'TOM',
'6'
],
[
'Quota::OO',
'R',
'd',
'p',
'O',
'p',
'Object oriented interface to Quota.pm',
'DMUEY',
'4'
],
[
'Acme::Clouseau',
'a',
'd',
'p',
'f',
'p',
'Make your text read like Inspector Clouseau',
'MARTYLOO',
'23'
],
[
'WWW::Salesforce',
'b',
'd',
'p',
'O',
'p',
'Get/Set info from your salesforce account.',
'CAPOEIRAB',
'15'
],
[
'Net::Akismet',
'R',
'd',
'p',
'O',
'p',
'Perl interface to Akismet.',
'NIKOLAY',
'15'
],
[
'WWW::Myspace',
'M',
'd',
'p',
'O',
'p',
'Access your Myspace.com profile in Perl!',
'GRANTG',
'15'
],
[
'ModPerl::ParamBuilder',
'b',
'd',
'p',
'O',
'p',
'Makes custom Apache directives easier',
'FWILES',
'15'
],
[
'Linux::hddtemp',
'b',
'd',
'p',
'O',
'p',
'Monitors hard drive temperatures',
'YORHEL',
'4'
],
[
'Wx::Package::Win32',
'a',
'd',
'c',
'O',
'p',
'Assist packaging of Wx applications on Win32',
'MDOOTSON',
'8'
],
[
'Finance::InteractiveBrokers::TWS',
'a',
'd',
'h',
'O',
'p',
'Lets you use Perl to call IB\'s Java TWS API',
'JSTRAUSS',
'24'
],
[
'Business::AllPay::Code',
'b',
'd',
'p',
'O',
'p',
'An interface to AllPay Code service',
'DWUZIU',
'23'
],
[
'WWW::Akismet',
'R',
'd',
'p',
'O',
'p',
'Perl interface to Akismet.',
'NIKOLAY',
'15'
],
[
'File::Basename::Object',
'b',
'd',
'p',
'O',
'p',
'Object wrapper around File::Basename',
'CRAKRJACK',
'10'
],
[
'WWW::PDAScraper',
'a',
'd',
'p',
'h',
'p',
'Scrape PDA-friendly content from websites',
'CODYP',
'15'
],
[
'Samba::LDAP',
'b',
'm',
'p',
'O',
'g',
'Manage a Samba PDC with an LDAP Backend',
'GHENRY',
'23'
],
[
'HTTP::WebTest::Plugin::Sticky',
'b',
'd',
'p',
'O',
'p',
'Propagate hidden and text form fields',
'HUGUEI',
'15'
],
[
'Tk::LineGraph',
'a',
'd',
'p',
'O',
'g',
'Tk Widget for Line Graphs',
'CLIFFORD',
'8'
],
[
'YATT',
'c',
'd',
'p',
'O',
'p',
'Yet Another Template Toolkit',
'HKOBA',
'15'
],
[
'Linux::Distribution::Packages',
'b',
'd',
'p',
'O',
'p',
'Gets Linux package information.',
'JUDITH',
'4'
],
[
'Tk::Image::Cut',
'a',
'd',
'p',
'O',
'p',
'Graphic user interface to cut pictures',
'KNORR',
'8'
],
[
'CGI::Pager',
'b',
'd',
'p',
'h',
'p',
'Generate HTML pagination linkage easily',
'EGORSH',
'15'
],
[
'Net::MirrorDir',
'c',
'd',
'p',
'O',
'p',
'Perl extension to compare directories',
'KNORR',
'16'
],
[
'Net::DownloadMirror',
'c',
'd',
'p',
'O',
'p',
'mirroring a remote location via FTP',
'KNORR',
'16'
],
[
'Net::UploadMirror',
'c',
'd',
'p',
'O',
'p',
'mirroring a local directory via FTP',
'KNORR',
'16'
],
[
'Tk::Mirror',
'a',
'd',
'p',
'O',
'p',
'graphic user interface to mirror directories',
'KNORR',
'8'
],
[
'Tie::CountLoop',
'R',
'd',
'p',
'h',
'g',
'Counter looping  scalar w. min max inc',
'FDULAU',
'6'
],
[
'OpenOffice::UNO',
'c',
'd',
'+',
'O',
'l',
'OpenOffice.org perlUNO Bridge',
'JOEYATES',
'5'
],
[
'Module::Selector',
'b',
'd',
'p',
'O',
'p',
'Selects the first/best module for a job',
'OKROEGER',
'2'
],
[
'Log::Statistics',
'a',
'd',
'p',
'O',
'b',
'near-real-time statistics from log files',
'VVU',
'21'
],
[
'Getopt::Long::String',
'a',
'd',
'p',
'f',
'p',
'Parses strings option',
'LEVENGLI',
'12'
],
[
'Parallel::Cluster',
'R',
'd',
'p',
'O',
'a',
'Distributed computing w/ multiple machines',
'RJHARMON',
'5'
],
[
'DBD::PgLite',
'a',
'd',
'p',
'O',
'p',
'PostgreSQL emulation mode for SQLite',
'BALDUR',
'7'
],
[
'Cache::BerkeleyDB',
'b',
'd',
'p',
'O',
'p',
'implements the Cache::Cache interface',
'BALDUR',
'17'
],
[
'Sledge::Plugin::Prototype',
'R',
'd',
'p',
'O',
'p',
'wrapper arround HTML::Prototype for Sledge',
'HORIUCHI',
'15'
],
[
'Template::Plugin::AutoLink',
'R',
'd',
'p',
'O',
'p',
'TT plugin to make hyperlink automatically',
'HORIUCHI',
'11'
],
[
'Term::BashTab',
'S',
'd',
'p',
'O',
'p',
'a wrapper of ReadLine with Bash-like <TAB>',
'DONGXU',
'8'
],
[
'Games::Tournament::RoundRobin',
'a',
'd',
'p',
'O',
'p',
'Round-Robin Tournament Schedule Pairings',
'DRBEAN',
'23'
],
[
'Lingua::JA::EDICT',
'c',
'd',
'p',
'O',
'p',
'Interface to EDICT, a Japanese-English dict',
'JKIM',
'11'
],
[
'Salesforce',
'b',
'd',
'p',
'O',
'p',
'Salesforce API Adapter',
'BAYSIDE',
'15'
],
[
'MySQL::Handler',
'b',
'd',
'p',
'O',
'g',
'Simplified MySQL handler for DBD::mysql',
'CSA',
'7'
],
[
'Class::DBI::Loader::Informix',
'b',
'd',
'p',
'O',
'p',
'Informix class for Class::DBI::Loader',
'JSTOWE',
'7'
],
[
'Number::WithError',
'R',
'd',
'p',
'h',
'p',
'Numbers with error propagation and rounding',
'SMUELLER',
'11'
],
[
'Number::WithError::LaTeX',
'R',
'd',
'p',
'h',
'p',
'LaTeX output for Number::WithError',
'SMUELLER',
'11'
],
[
'Device::Cdio',
'a',
'm',
'c',
'O',
'g',
'Encapulates CD-ROM reading and control',
'ROCKY',
'4'
],
[
'LWP::Authen::Negotiate',
'R',
'm',
'p',
'f',
'p',
'GSSAPI based Authentication Plugin for LWP',
'AGROLMS',
'15'
],
[
'Solaris::Modinfo',
'b',
'd',
'p',
'O',
'p',
'object oriented interface for MODINFO',
'SNCK',
'4'
],
[
'Math::Sparse::Matrix',
'a',
'd',
'p',
'O',
'g',
'Sparse Matrix Operations in Perl',
'TPEDERSE',
'6'
],
[
'Math::Sparse::Vector',
'a',
'd',
'p',
'O',
'g',
'Sparse Vector Operations in Perl',
'TPEDERSE',
'6'
],
[
'Math::Logic::Ternary',
'c',
'd',
'p',
'O',
'p',
'ternary logic and related operations',
'MHASCH',
'6'
],
[
'Business::OnlinePayment::InternetSecure',
'b',
'd',
'p',
'O',
'p',
'InternetSecure online payment processor',
'FBRIERE',
'23'
],
[
'Test::Singleton',
'R',
'd',
'p',
'f',
'g',
'Test singleton classes',
'TPG',
'3'
],
[
'DBD::Salesforce',
'a',
'd',
'p',
'O',
'p',
'Treat Salesforce as a datasource for DBI',
'BAYSIDE',
'7'
],
[
'CMMi',
'i',
'd',
'p',
'O',
'p',
'CMMi process implementation - web interface',
'THUNDERA',
'23'
],
[
'Math::Symbolic::Custom::Transformation',
'R',
'd',
'p',
'O',
'p',
'Transform Math::Symbolic trees',
'SMUELLER',
'6'
],
[
'DBIx::Migration::Directories',
'b',
'm',
'p',
'O',
'p',
'Install,up/downgrade&remove database schemas',
'CRAKRJACK',
'7'
],
[
'Net::Oscar',
'b',
'd',
'p',
'O',
'g',
'Perl implementation of the OSCAR - ICQ/AIM',
'SLAFF',
'16'
],
[
'Net::OpenSRS',
'b',
'd',
'p',
'O',
'p',
'Interface to OpenSRS reseller DNS functions',
'MAHLON',
'23'
],
[
'SVG::Metadata',
'R',
'd',
'p',
'O',
'g',
'Retrieves/stores metadata in SVG files',
'BRYCE',
'18'
],
[
'Webalizer::Hist',
'b',
'd',
'p',
'O',
'p',
'Perl module to parse webalizer.hist',
'YORHEL',
'6'
],
[
'Catalyst::Plugin::MortalForward',
'b',
'm',
'p',
'O',
'p',
'Make forward() to throw exception',
'YANNK',
'15'
],
[
'Tree::Suffix',
'b',
'd',
'c',
'O',
'p',
'Interface to the libstree library',
'GRAY',
'6'
],
[
'What',
'R',
'd',
'p',
'O',
'g',
'Find out about running services (MTA, etc)',
'TPG',
'5'
],
[
'Tk::MARC::Editor',
'R',
'd',
'p',
'O',
'p',
'Tk widget for editing MARC records',
'DCHRIS',
'8'
],
[
'WebService::Hatena::BookmarkCount',
'b',
'd',
'p',
'O',
'p',
'Interface for Hatena::Bookmark getCount API',
'KAWASAKI',
'15'
],
[
'Test::HTML::W3C',
'b',
'd',
'p',
'f',
'p',
'W3C HTML validation testing module',
'VICTORF',
'3'
],
[
'Math::Interval',
'c',
'd',
'p',
'O',
'p',
'Interval number data type',
'HOLLYKING',
'6'
],
[
'Luka',
'b',
'd',
'p',
'O',
'g',
'Exception handling and reporting framework',
'TPG',
'20'
],
[
'Class::DBI::Replicated',
'b',
'd',
'p',
'O',
'p',
'support for mysql/pg (slony1) replication',
'HDP',
'7'
],
[
'Class::STL::Containers',
'a',
'd',
'p',
'O',
'g',
'STL-like object management classes',
'GAFFIE',
'6'
],
[
'Bundle::Net::SXIP::Homesite',
'R',
'm',
'p',
'f',
'b',
'Install SXIP Homesite prerequisites',
'KGRENNAN',
'25'
],
[
'Sub::Autostub',
'R',
'd',
'p',
'h',
'p',
'Stub OO and functional calls with logging.',
'LEMBARK',
'3'
],
[
'Freedesktop::Trash',
'c',
'd',
'p',
'O',
'p',
'The Freedesktop.org "Trash Can" standard',
'RRWO',
'4'
],
[
'CPANPLUS',
'R',
'm',
'p',
'O',
'?',
'Command-line access to the CPAN interface',
'KANE',
'23'
],
[
'Net::Abuse::Utils',
'b',
'd',
'p',
'f',
'p',
'Routines useful for processing network abuse',
'MIKEGRB',
'5'
],
[
'HTML::WikiConverter',
'R',
'd',
'p',
'O',
'p',
'Convert HTML to wiki markup',
'DIBERRI',
'15'
],
[
'Hardware::Vhdl::Lexer',
'b',
'd',
'p',
'O',
'a',
'Return Lexical tokens from VHDL source files',
'MYKL',
'9'
],
[
'Devel::ObjectCount',
'b',
'd',
'h',
'f',
'p',
'Count number of objects in memory',
'TBUSCH',
'3'
],
[
'Asterisk::IVR::Dido',
'a',
'd',
'p',
'O',
'b',
'HTML-template-like system for writing IVRs',
'QUINN',
'25'
],
[
'CaCORE',
'b',
'd',
'p',
'O',
'd',
'A Common Framework for Cancer Data Managemen',
'JIANGS',
'23'
],
[
'Hook::Filter',
'R',
'd',
'p',
'f',
'p',
'A runtime firewall for subroutine calls',
'ERWAN',
'20'
],
[
'Apache::AuthPOP3',
'R',
'd',
'p',
'f',
'p',
'Authentication and Authorization via POP3',
'SHERWIN',
'15'
],
[
'Finance::TickerSymbols',
'a',
'd',
'p',
'f',
'p',
'get lists of stock symbols',
'JEZRA',
'23'
],
[
'Parallel::Queue',
'b',
'd',
'p',
'h',
'p',
'Fork a queue N-way parallel',
'LEMBARK',
'5'
],
[
'Devel::GDB',
'S',
'd',
'p',
'O',
'a',
'open and communicate gdb process',
'JEZRA',
'3'
],
[
'Catalyst::Plugin::AutoSession',
'b',
'd',
'p',
'O',
'p',
'Automatically save session variables',
'ICD',
'15'
],
[
'Compress::AsciiFlate',
'S',
'd',
'p',
'O',
'p',
'De/inflates text data. Useful for databases.',
'JIMI',
'17'
],
[
'SAS::Parser',
'b',
'd',
'p',
'O',
'p',
'Classes for parsing SAS programs',
'MLF',
'11'
],
[
'GPS::Poi',
'a',
'd',
'p',
'O',
'g',
'Manages POI files ov2 extension GPS TomTom',
'EGERMAN',
'23'
],
[
'Apache2::JSONRPC',
'a',
'd',
'p',
'O',
'p',
'Object-Oriented JSONRPC dispatch for Apache2',
'CRAKRJACK',
'15'
],
[
'Data::RuledValidator',
'b',
'd',
'p',
'O',
'p',
'Data validator with rule',
'KTAT',
'6'
],
[
'CGI::Application::Plugin::AbstractCallback',
'R',
'm',
'p',
'O',
'p',
'Easy callback extention for C::A',
'ZIGOROU',
'15'
],
[
'Lingua::HU::Numbers',
'a',
'd',
'p',
'f',
'p',
'Converts numbers into hungarian text form',
'SZBALINT',
'11'
],
[
'RiveScript',
'b',
'd',
'p',
'O',
'g',
'Rendering Intelligence Very Easily',
'KIRSLE',
'11'
],
[
'Filter::Template',
'R',
'd',
'p',
'n',
'p',
'Source filter for code templates or macros.',
'RCAPUTO',
'2'
],
[
'Music::Chord::Namer',
'a',
'd',
'p',
'f',
'p',
'You give it notes, it names the chord.',
'JIMI',
'23'
],
[
'Gantry',
'b',
'm',
'p',
'O',
'p',
'Web Application Framework',
'TKEEFER',
'15'
],
[
'CGI::JSONRPC',
'a',
'd',
'p',
'O',
'p',
'Object-Oriented JSONRPC dispatch for CGI',
'CRAKRJACK',
'15'
],
[
'CGI::Session::Plugin::Redirect',
'R',
'd',
'p',
'O',
'p',
'extended redirect method for CGI::Session',
'MAKOTO',
'15'
],
[
'Template::Plugin::NoFollow',
'R',
'd',
'p',
'O',
'p',
'TT plugin to add rel="nofollow" to HTML link',
'GTERMARS',
'11'
],
[
'Cache::Memcached::Tie',
'R',
'd',
'p',
'O',
'g',
'Tie for Cache::Memcached',
'GUGU',
'17'
],
[
'cPanel',
'S',
'd',
'p',
'O',
'p',
'root of our company\'s public modules',
'DMUEY',
'24'
],
[
'cPanel::SyncUtil',
'S',
'd',
'p',
'f',
'p',
'cpanelsync directory utility functions',
'DMUEY',
'24'
],
[
'Games::QuizTaker',
'R',
'd',
'p',
'O',
'p',
'Create and take your own quizzes and tests',
'TSTANLEY',
'23'
],
[
'Mail::DKIM',
'a',
'd',
'p',
'O',
'p',
'Implements DomainKeys Identified Mail (DKIM)',
'JASLONG',
'19'
],
[
'Lingua::JA::Romanize::Japanese',
'b',
'd',
'p',
'O',
'g',
'Romanization of Japanese language',
'KAWASAKI',
'11'
],
[
'Lingua::KO::Romanize::Hangul',
'b',
'd',
'p',
'O',
'p',
'Romanization of Korean language',
'KAWASAKI',
'11'
],
[
'Lingua::ZH::Romanize::Pinyin',
'b',
'd',
'p',
'O',
'd',
'Romanization of Standard Chinese language',
'KAWASAKI',
'11'
],
[
'Net::GPSD',
'b',
'd',
'p',
'O',
'p',
'Provides a perl interface to the gpsd daemon',
'MRDVT',
'16'
],
[
'DCOP',
'b',
'd',
'p',
'O',
'p',
'Extensible inheritable class to dcop.',
'JCMULLER',
'8'
],
[
'DCOP::Amarok',
'b',
'd',
'p',
'O',
'p',
'Interface to Amarok via system\'s dcop',
'JCMULLER',
'8'
],
[
'DCOP::Amarok::Playlist',
'b',
'd',
'p',
'O',
'p',
'Object to manage the playlist of amaroK',
'JCMULLER',
'8'
],
[
'Grid::Transform',
'a',
'd',
'c',
'O',
'p',
'Grid transformations (rotate, flip, etc.)',
'GRAY',
'6'
],
[
'Class::Trigger::Ordered',
'b',
'd',
'p',
'O',
'p',
'Class::Trigger wrapped module',
'BOXPHERE',
'6'
],
[
'HTML::LinkChanger',
'b',
'd',
'p',
'O',
'p',
'Helps change all links in HTML code',
'SERGEYCHE',
'15'
],
[
'Lingua::EL::Poly2Mono',
'a',
'a',
'p',
'f',
'p',
'Convert polytonic Greek text to monotonic',
'SPROUT',
'11'
],
[
'Numbers::Base::DWIM',
'b',
'd',
'p',
'p',
'p',
'Just in time based numeric constant parsing',
'CMO',
'6'
],
[
'Apache2::AuthenDBMCache',
'b',
'd',
'p',
'f',
'p',
'mod_perl Authen accelerator using DBM cache',
'REGGERS',
'15'
],
[
'Apache2::AuthenMSAD',
'b',
'd',
'p',
'f',
'p',
'Apache authentication to MS Active Directory',
'REGGERS',
'15'
],
[
'Catalyst::Plugin::Server',
'b',
'd',
'p',
'O',
'p',
'Server extensions for Catalyst',
'KANE',
'15'
],
[
'AI::FANN',
'b',
'd',
'c',
'O',
'p',
'Fast Artificial Neural Network library',
'SALVA',
'23'
],
[
'Win32::Fonts::Info',
'R',
'u',
'c',
'f',
'p',
'List of installed fonts (families) in window',
'RPAGITSCH',
'22'
],
[
'CGI::Application::Plugin::ActionDispatch',
'b',
'd',
'p',
'O',
'p',
'Used to dispatch requests based on actions.',
'JAYWHY',
'15'
],
[
'CGI::Application::Plugin::JSON',
'i',
'd',
'p',
'O',
'p',
'Change to json format using C::A',
'ZIGOROU',
'15'
],
[
'Email::Fingerprint',
'a',
'd',
'p',
'O',
'p',
'Calculate MD5 or other digests of emails',
'BUDNEY',
'19'
],
[
'SOAP::Amazon::S3',
'c',
'd',
'p',
'O',
'p',
'Classes for accessing Amazon\'s S3',
'KARJALA',
'15'
],
[
'UkrMoney::API',
'c',
'd',
'p',
'O',
'g',
'API for UkrMoney.com payment system',
'DMITRY',
'24'
],
[
'Data::Stack',
'b',
'd',
'p',
'O',
'p',
'OO Stack',
'GPHAT',
'6'
],
[
'Catalyst::Plugin::FormValidator::Simple::OwnCheck',
'b',
'd',
'p',
'O',
'p',
'load your own checker of  your app namespace',
'ADONG',
'15'
],
[
'RT::Client::REST',
'a',
'd',
'p',
'O',
'g',
'Talk to RT using REST protocol.',
'DMITRI',
'23'
],
[
'Apache2::ModBT',
'b',
'm',
'p',
'O',
'o',
'mod_perl interface to mod_bt',
'CRAKRJACK',
'15'
],
[
'Finance::SE::OMX',
'b',
'd',
'p',
'O',
'p',
'Retrieves stock informaton from OMX',
'SCATO',
'23'
],
[
'Lucene',
'b',
'd',
'+',
'O',
'p',
'API to the Lucene search engine',
'TBUSCH',
'11'
],
[
'Inline::WSC',
'R',
'u',
'p',
'f',
'p',
'Use JavaScript and VBScript from within Perl',
'JOHND',
'2'
],
[
'Template::Plugin::ByDate',
'R',
'd',
'p',
'O',
'p',
'TT filter for in/excluding based on date',
'DMCBRIDE',
'11'
],
[
'Tk::GraphItems',
'R',
'd',
'p',
'O',
'p',
'View-side for nodes and edges of Rel-Graphs',
'LAMPRECHT',
'8'
],
[
'Catalyst::Model::DBIC::Schema',
'R',
'm',
'p',
'O',
'p',
'DBIx::Class model for Catalyst',
'MSTROUT',
'15'
],
[
'WebService::MusicBrainz',
'b',
'd',
'p',
'O',
'p',
'Interface to MusicBrainz web services',
'BFAIST',
'15'
],
[
'Catalyst::View::TT',
'M',
'm',
'p',
'O',
'p',
'The Elegant MVC Web Application Framework',
'MRAMBERG',
'15'
],
[
'HTTP::Request::AsCGI',
'M',
'm',
'p',
'O',
'p',
'Setup a CGI enviroment from a HTTP::Request',
'CHANSEN',
'15'
],
[
'Catalyst::Plugin::ConfigLoader',
'R',
'm',
'p',
'O',
'p',
'Load config files of various types',
'BRICAS',
'15'
],
[
'Catalyst::Plugin::DefaultEnd',
'M',
'm',
'p',
'O',
'p',
'A Default End action for Catalyst',
'MRAMBERG',
'15'
],
[
'HTTP::Body',
'M',
'm',
'p',
'O',
'p',
'HTTP Body Parser',
'CHANSEN',
'15'
],
[
'Catalyst::Engine::Apache',
'M',
'm',
'p',
'O',
'p',
'Catalyst engines for mod_perl 1.3, 1.99, 2.x',
'AGRUNDMA',
'15'
],
[
'Catalyst::Engine::HTTP::POE',
'a',
'm',
'p',
'O',
'p',
'Single-threaded multi-tasking Cat engine',
'AGRUNDMA',
'15'
],
[
'Catalyst::Plugin::UploadProgress',
'b',
'm',
'p',
'O',
'p',
'Display file upload progress information',
'AGRUNDMA',
'15'
],
[
'Catalyst::Plugin::I18N',
'M',
'm',
'p',
'O',
'p',
'I18N plugin for Catalyst',
'CHANSEN',
'15'
],
[
'Catalyst::Plugin::StackTrace',
'R',
'm',
'p',
'O',
'p',
'Display a stack trace on the error screen.',
'AGRUNDMA',
'15'
],
[
'Catalyst::Plugin::Authentication',
'S',
'm',
'p',
'O',
'p',
'Authentication support for Catalyst',
'NUFFIN',
'15'
],
[
'Catalyst::Plugin::RequireSSL',
'R',
'm',
'p',
'O',
'p',
'Force SSL mode on select pages',
'AGRUNDMA',
'15'
],
[
'Catalyst::Plugin::PageCache',
'R',
'm',
'p',
'O',
'p',
'Cache the output of entire pages',
'AGRUNDMA',
'15'
],
[
'Catalyst::Plugin::OrderedParams',
'R',
'm',
'p',
'O',
'p',
'Maintain order of submitted form parameters',
'AGRUNDMA',
'15'
],
[
'Catalyst::Plugin::Session',
'S',
'm',
'p',
'O',
'p',
'Session support "parent" plugin for Catalyst',
'NUFFIN',
'15'
],
[
'Catalyst',
'M',
'm',
'p',
'O',
'p',
'The Elegant MVC Web Application Framework',
'MRAMBERG',
'15'
],
[
'Catalyst::Plugin::Authorization::ACL',
'S',
'm',
'p',
'O',
'p',
'ACL support for Catalyst',
'NUFFIN',
'15'
],
[
'Catalyst::Plugin::Scheduler',
'R',
'm',
'p',
'O',
'p',
'Schedule events to run in a cron-like manner',
'AGRUNDMA',
'15'
],
[
'Catalyst::Plugin::Session::Store::DBI',
'R',
'm',
'p',
'O',
'p',
'Store your sessions in a database',
'AGRUNDMA',
'15'
],
[
'Catalyst::Plugin::Authorization::Roles',
'S',
'm',
'p',
'O',
'p',
'RBAC support for Catalyst',
'NUFFIN',
'15'
],
[
'Catalyst::Controller::BindLex',
'S',
'm',
'p',
'O',
'p',
'Bind lexical variables to $c structures',
'NUFFIN',
'15'
],
[
'Catalyst::Plugin::Authentication::Credential::HTTP',
'S',
'm',
'p',
'O',
'p',
'Catalyst HTTP authentication',
'NUFFIN',
'15'
],
[
'Catalyst::Plugin::Authentication::Credential::TypeKey',
'S',
'm',
'p',
'O',
'p',
'Catalyst TypeKey authentication',
'NUFFIN',
'15'
],
[
'Catalyst::Plugin::Static::Simple',
'R',
'm',
'p',
'O',
'p',
'Serve static content painlessly',
'AGRUNDMA',
'15'
],
[
'Catalyst::Engine',
'M',
'm',
'p',
'O',
'p',
'The Elegant MVC Web Application Framework',
'MRAMBERG',
'15'
],
[
'Catalyst::Plugin::Params::Nested',
'M',
'm',
'p',
'O',
'p',
'rails style nested form parameters',
'NUFFIN',
'15'
],
[
'Catalyst::Base',
'M',
'm',
'p',
'O',
'p',
'The Elegant MVC Web Application Framework',
'MRAMBERG',
'15'
],
[
'Catalyst::View',
'M',
'm',
'p',
'f',
'p',
'The Elegant MVC Web Application Framework',
'MRAMBERG',
'15'
],
[
'Catalyst::Model',
'M',
'm',
'p',
'f',
'p',
'The Elegant MVC Web Application Framework',
'MRAMBERG',
'15'
],
[
'Catalyst::Controller',
'M',
'm',
'p',
'f',
'p',
'The Elegant MVC Web Application Framework',
'MRAMBERG',
'15'
],
[
'Catalyst::Plugin::Session::PerUser',
'M',
'm',
'p',
'O',
'p',
'Generalized member/guest session merging',
'NUFFIN',
'15'
],
[
'Catalyst::Plugin::Session::State::Cookie',
'M',
'm',
'p',
'O',
'p',
'Cookie driver for Catalyst sessions',
'NUFFIN',
'15'
],
[
'Catalyst::Plugin::Session::Store::FastMmap',
'S',
'm',
'p',
'O',
'p',
'FastMmap storage for Catalyst sessions',
'NUFFIN',
'15'
],
[
'Catalyst::Plugin::Session::Store::Memcached',
'S',
'm',
'p',
'O',
'p',
'Memcached storage for Catalyst sessions',
'NUFFIN',
'15'
],
[
'Catalyst::View::TT::FunctionGenerator',
'S',
'm',
'p',
'O',
'p',
'Easy function generation for the TT view',
'NUFFIN',
'15'
],
[
'Catalyst::Plugin::Authentication::Store::DBIC',
'M',
'm',
'p',
'O',
'p',
'Catalyst Authentication against DBIC',
'MRAMBERG',
'15'
],
[
'Catalyst::Log::Log4perl',
'M',
'd',
'p',
'O',
'p',
'Integrates Log::Log4perl with Catalyst',
'HOLOWAY',
'15'
],
[
'Catalyst::Plugin::ClamAV',
'b',
'd',
'p',
'O',
'p',
'ClamAV scanning Plugin for Catalyst',
'FUJIWARA',
'15'
],
[
'CGI::Application::Plugin::Upload',
'i',
'd',
'p',
'O',
'p',
'Upload plugin for C::A',
'ZIGOROU',
'15'
],
[
'Template::Plugin::Digest::MD5',
'b',
'd',
'p',
'h',
'p',
'Template Toolkit interface to Digest::MD5',
'ANDREWF',
'11'
],
[
'Template::Plugin::Digest::SHA1',
'b',
'd',
'p',
'h',
'p',
'Template Toolkit interface to Digest::SHA1',
'ANDREWF',
'11'
],
[
'XML::MyXML',
'b',
'd',
'p',
'f',
'p',
'A simple XML module used in SOAP::Amazon::S3',
'KARJALA',
'11'
],
[
'SOAP::MySOAP',
'a',
'd',
'p',
'O',
'p',
'A small SOAP module',
'KARJALA',
'5'
],
[
'Encode',
'S',
'm',
'h',
'h',
'p',
'Character Encodings Handler',
'DANKOGAI',
'13'
],
[
'Jcode',
'R',
'm',
'h',
'h',
'p',
'Japanese Encodings Handler',
'DANKOGAI',
'13'
],
[
'Data::Report',
'b',
'd',
'p',
'O',
'p',
'Flexible framework for reports',
'JV',
'11'
],
[
'Apache::JemplateFilter',
'b',
'd',
'p',
'O',
'p',
'Jemplate compile filter for Apache1',
'FUJIWARA',
'15'
],
[
'Geo::Coder::Canada',
'b',
'd',
'p',
'O',
'p',
'Conversion between addresses and Geocoding',
'JETTRA',
'13'
],
[
'Tk::PerlInheritanceTree',
'R',
'd',
'p',
'O',
'p',
'Display inheritance trees for Perl classes',
'LAMPRECHT',
'3'
],
[
'Algorithm::SpiralSearch',
'b',
'd',
'p',
'f',
'p',
'Function Optimization of Two Parameters',
'MOSTAFAVI',
'23'
],
[
'Tk::PerlMethodList',
'R',
'd',
'p',
'O',
'p',
'Display methods of a Perl class',
'LAMPRECHT',
'3'
],
[
'Reaction',
'c',
'd',
'p',
'O',
'g',
'perl MVC application development platform',
'MSTROUT',
'15'
],
[
'Test::Group',
'R',
'd',
'p',
'h',
'a',
'Group together related tests in a test suite',
'DOMQ',
'3'
],
[
'HTML::TagParser',
'b',
'd',
'p',
'O',
'p',
'Pure Perl HTML Tag Parser',
'KAWASAKI',
'15'
],
[
'Test::Glade',
'R',
'd',
'p',
'h',
'n',
'Validate GladeXML files',
'NMUELLER',
'3'
],
[
'Bigtop',
'b',
'd',
'p',
'O',
'p',
'A web app description language',
'PHILCROW',
'15'
],
[
'Statistics::Forecast',
'R',
'd',
'p',
'O',
'p',
'It calculates a future value.',
'FALCAO',
'6'
],
[
'Filesys::DfPortable',
'R',
'd',
'h',
'f',
'p',
'Portable way to obtain filesystem info.',
'IGUTHRIE',
'10'
],
[
'CGI::Session::DBI',
'R',
'd',
'p',
'n',
'p',
'Use 1+ DBI->connect DBHs to cluster sessions',
'DMUEY',
'15'
],
[
'Boost::Graph',
'R',
'd',
'h',
'O',
'p',
'Interface to the Boost Graph C++ Library',
'DBURDICK',
'6'
],
[
'Tk::TimePick',
'a',
'd',
'p',
'O',
'p',
'extension to pick time syntax mistake-secure',
'KNORR',
'8'
],
[
'Class::InsideOut',
'R',
'd',
'p',
'O',
'p',
'safe, simple inside-out objects',
'DAGOLDEN',
'6'
],
[
'Lucy',
'i',
'm',
'h',
'O',
'o',
'Search engine library.',
'CREAMYG',
'11'
],
[
'WWW::YouTube',
'c',
'd',
'p',
'O',
'p',
'Toplevel Interface to www.youtube.com',
'ERMEYERS',
'15'
],
[
'WWW:Blogger',
'c',
'd',
'p',
'O',
'p',
'Top Level interface to www.blogger.com',
'ERMEYERS',
'15'
],
[
'Class::CodeStyler',
'b',
'd',
'p',
'O',
'g',
'OO API to produce formatted code',
'GAFFIE',
'6'
],
[
'Catalyst::Plugin::Authentication::Credential::PAM',
'b',
'd',
'p',
'O',
'p',
'Authenticate a user against PAM',
'RGARCIA',
'15'
],
[
'Time::UTC::Now',
'R',
'd',
'c',
'f',
'p',
'determine current time in UTC correctly',
'ZEFRAM',
'6'
],
[
'Device::Serdisp',
'b',
'd',
'c',
'O',
'p',
'Perl extension for talking to the serdisplib',
'FUZZ',
'4'
],
[
'DBIx::Romani',
'b',
'd',
'p',
'O',
'g',
'Helps handle differences in SQL dialects.',
'DSNOPEK',
'7'
],
[
'Catalyst::Plugin::CRUD',
'b',
'd',
'p',
'O',
'p',
'CRUD Plugin for Class::DBI adn DBIx::Class',
'BAYSIDE',
'15'
],
[
'XML::DTD',
'b',
'd',
'p',
'O',
'g',
'Parse and process an XML DTD',
'WOHL',
'11'
],
[
'Net::BitTorrent::LibBT::Tracker',
'a',
'm',
'h',
'O',
'o',
'Access a tracker running under libbttracker',
'CRAKRJACK',
'5'
],
[
'DBIx::Log4perl',
'a',
'm',
'p',
'O',
'p',
'An extension to log all DBI SQL activity',
'MJEVANS',
'7'
],
[
'Archive::StringToZip',
'R',
'd',
'p',
'h',
'p',
'Transforms a string to a zip',
'ROBBIEBOW',
'17'
],
[
'Tk::Schedule',
'a',
'd',
'p',
'O',
'p',
'carrying out tasks up to schedule',
'KNORR',
'8'
],
[
'Parse::Colloquy::Bot',
'R',
'm',
'p',
'f',
'o',
'Parse Colloquy bot/client terminal output',
'NICOLAW',
'11'
],
[
'Text::Restructured',
'b',
'd',
'p',
'h',
'p',
'Parse and transform reStructuredText docs',
'NODINE',
'11'
],
[
'Apache2::AuthColloquy',
'R',
'd',
'p',
'f',
'o',
'mod_perl authentication against the Colloquy',
'NICOLAW',
'15'
],
[
'Alien::Dojo',
'R',
'd',
'h',
'O',
'p',
'the Dojo Javascript toolkit wrapped in Perl',
'DOMQ',
'15'
],
[
'WWW::BF2S',
'a',
'd',
'p',
'O',
'p',
'Get Battlefield 2 Player Stats',
'WILSOND',
'15'
],
[
'Bio::Data::Plasmid::CloningVector',
'b',
'd',
'p',
'f',
'a',
'Provides plasmid cloning vector data',
'SLENK',
'23'
],
[
'Authen::Passphrase',
'R',
'd',
'p',
'O',
'p',
'hashed passwords/passphrases as objects',
'ZEFRAM',
'14'
],
[
'Verilog::Info',
'i',
'd',
'p',
'O',
'p',
'Fetches information on Verilog Designs',
'ROHITM',
'9'
],
[
'Sepia',
'b',
'd',
'h',
'h',
'p',
'Simple Emacs Perl Interface',
'SEANO',
'3'
],
[
'GD::Map',
'M',
'd',
'p',
'O',
'p',
'Map drawing tool using lat and long values',
'CJS',
'18'
],
[
'Xmldoom',
'b',
'd',
'p',
'O',
'g',
'Object persistance framework.',
'DSNOPEK',
'3'
],
[
'WWW::GameMonitor',
'b',
'd',
'p',
'O',
'p',
'Get info about public game servers from GM',
'WILSOND',
'15'
],
[
'SOAP::XML::Client',
'M',
'd',
'p',
'O',
'p',
'Talk with SOAP/.net/web services easily',
'LLAP',
'5'
],
[
'Text::Same',
'b',
'd',
'p',
'O',
'p',
'Look for similarities between files',
'KIM',
'11'
],
[
'Baseball::Sabermetrics',
'b',
'd',
'p',
'O',
'p',
'An Easy Baseball Statistic Module',
'VICTOR',
'23'
],
[
'WWW::Simpy',
'c',
'd',
'p',
'O',
'p',
'OOP Simpy (social bookmarking) service API',
'BEADSLAND',
'15'
],
[
'WWW::phpBB',
'b',
'd',
'p',
'O',
'p',
'scrape a phpBB forum',
'STEFANT',
'15'
],
[
'Device::SNP',
'R',
'd',
'p',
'O',
'p',
'Support for GE Fanuc SNP-X serial protocol',
'MIKEM',
'4'
],
[
'WebService::GEPIR',
'i',
'd',
'p',
'O',
'p',
'Program interface for searching EAN on GEPIR',
'ZIGOROU',
'15'
],
[
'Net::Bluetooth',
'R',
'd',
'h',
'h',
'p',
'Perl interface to Bluetooth',
'IGUTHRIE',
'5'
],
[
'Module::Recursive::Require',
'b',
'd',
'p',
'O',
'p',
'This class require module recursively.',
'MASAP',
'23'
],
[
'WWW::BF2Player',
'a',
'd',
'p',
'O',
'p',
'Get Battlefield 2 Player Info',
'WILSOND',
'15'
],
[
'Template::DBI',
'M',
'd',
'p',
'O',
'p',
'DBI extensions for the Template Toolkit',
'ABW',
'11'
],
[
'Template::XML',
'M',
'd',
'p',
'O',
'p',
'XML plugins for the Template Toolkit',
'ABW',
'11'
],
[
'Template::GD',
'M',
'd',
'p',
'O',
'p',
'GD plugins for the Template Toolkit',
'ABW',
'11'
],
[
'Thesaurus::DBI',
'b',
'd',
'p',
'O',
'p',
'Store and query synonyms in an sql database',
'JOSEIBERT',
'6'
],
[
'PIX::Walker',
'b',
'd',
'p',
'O',
'p',
'Process Cisco PIX configs and ACLs',
'LIFO',
'23'
],
[
'Bundle::DBWIZ',
'R',
'd',
'p',
'n',
'g',
'A bundle to install dbWiz:  federated search',
'CALVINM',
'25'
],
[
'Algorithm::Pair::Swiss',
'R',
'd',
'p',
'O',
'p',
'Create pairings for Swiss-rounds tournaments',
'GGOUDSMIT',
'23'
],
[
'Yahoo::Marketing',
'R',
'd',
'p',
'O',
'a',
'SDK for Yahoo Search Marketing Web Services',
'JLAVALLEE',
'24'
],
[
'Net::Newzbin',
'b',
'd',
'p',
'O',
'g',
'Search and download nzb files from Newzbin',
'LEEDO',
'15'
],
[
'Image::BMP',
'R',
'd',
'p',
'O',
'd',
'Read bitmap (bmp) images.  Writing is beta.',
'DAVEOLA',
'18'
],
[
'Logger::Simple',
'R',
'd',
'p',
'O',
'p',
'Log error and description messages',
'TSTANLEY',
'21'
],
[
'Java::JCR',
'R',
'd',
'o',
'O',
'p',
'Use JSR 170 (JCR) repositories from Perl',
'HANENKAMP',
'7'
],
[
'CGI::FormBuilder::Mail::FormatMultiPart',
'R',
'd',
'p',
'O',
'p',
'Plugin for CGI::FormBuilder->mailresults()',
'MARKLE',
'15'
],
[
'Acme::l33t',
'a',
'd',
'p',
'O',
'p',
'Perl interpreter of the l33t language.',
'YANICK',
'9'
],
[
'Hardware::1Wire',
'R',
'd',
'p',
'O',
'p',
'Dallas Semiconductors 1-Wire Bus',
'DVKLEIN',
'4'
],
[
'Unicode::Escape',
'b',
'd',
'p',
'h',
'p',
'Escape and unescape Unicode characters',
'ITWARRIOR',
'13'
],
[
'Math::Interpolator',
'R',
'd',
'p',
'O',
'p',
'interpolate between lazily-evaluated points',
'ZEFRAM',
'6'
],
[
'Win32::IEFavorites',
'b',
'd',
'p',
'O',
'p',
'handles Internet Explorer\'s Favorites',
'ISHIGAKI',
'22'
],
[
'CGI::Auth::Basic',
'R',
'd',
'p',
'O',
'p',
'Basic CGI authentication interface',
'BURAK',
'15'
],
[
'GD::Thumbnail',
'R',
'd',
'p',
'O',
'p',
'Thumbnail maker for GD',
'BURAK',
'18'
],
[
'Text::Template::Simple',
'b',
'd',
'p',
'O',
'p',
'Simple text template engine',
'BURAK',
'11'
],
[
'Finance::Bank::NetBranch',
'b',
'd',
'p',
'O',
'p',
'Manage your NetBranch accounts with Perl',
'KULP',
'24'
],
[
'Mac::PropertyList::SAX',
'b',
'd',
'p',
'f',
'p',
'work with Mac property lists (plists), fast',
'KULP',
'11'
],
[
'Algorithm::QuineMcCluskey',
'a',
'd',
'p',
'O',
'p',
'Solve Quine-McCluskey set-cover problems',
'KULP',
'23'
],
[
'Class::Superclasses',
'R',
'd',
'p',
'O',
'p',
'Find a class\' superclasses',
'RENEEB',
'6'
],
[
'Win32::InternetShortcut',
'b',
'd',
'h',
'O',
'p',
'handles Internet Shortcut (IE\'s Favorite)',
'ISHIGAKI',
'22'
],
[
'Net::UKDomain::Nominet::Automaton',
'R',
'd',
'p',
'O',
'g',
'Interface to Nominet .UK Domain Registry',
'CLIFFORDJ',
'5'
],
[
'Net::TCP::PtyServer',
'b',
'd',
'p',
'f',
'p',
'Server up pseudo-TTYs over incoming TELNET',
'RJLEE',
'16'
],
[
'IPC::Run::Simple',
'R',
'd',
'p',
'f',
'p',
'Simple run() wrapper around system()',
'SFINK',
'5'
],
[
'Language::l33t',
'a',
'd',
'p',
'O',
'p',
'Perl interpreter of the l33t language.',
'YANICK',
'9'
],
[
'DBIx::NamedQuery',
'a',
'd',
'p',
'h',
'p',
'SQL queries are referenced by name from Perl',
'BOLEK',
'7'
],
[
'XML::XPS',
'a',
'd',
'p',
'O',
'g',
'An XPS Document Interface',
'MAIN',
'11'
],
[
'Class::Pluggable',
'a',
'd',
'p',
'O',
'p',
'Makes your subclass pluggable.',
'TAKESHIGE',
'2'
],
[
'Regexp::MultiLanguage',
'a',
'd',
'p',
'O',
'p',
'Use common Regexp in Perl,PHP,JavaScript,etc',
'ROBWALKER',
'11'
],
[
'Net::SynchroEdit::Service',
'a',
'd',
'p',
'O',
'l',
'SynchroEdit response service module',
'KALLEWOOF',
'16'
],
[
'GD::Tab::Ukulele',
'b',
'd',
'p',
'O',
'p',
'Ukulele tab image generator',
'TATENO',
'18'
],
[
'Math::SparseMatrix',
'a',
'd',
'p',
'O',
'g',
'Sparse matrix implementation',
'JMAHESH',
'6'
],
[
'Math::SparseVector',
'R',
'd',
'p',
'O',
'g',
'Sparse vector implementation',
'JMAHESH',
'6'
],
[
'Rose::DB',
'b',
'm',
'p',
'O',
'p',
'A DBI wrapper and abstraction layer.',
'JSIRACUSA',
'7'
],
[
'Wx::Perl::Packager',
'a',
'd',
'p',
'h',
'p',
'Assist packaging Wx applications',
'MDOOTSON',
'8'
],
[
'Time::Clock',
'b',
'd',
'p',
'O',
'p',
'Twenty-four hour clock object',
'JSIRACUSA',
'6'
],
[
'Enom::Base',
'b',
'd',
'p',
'f',
'p',
'Enom xml API Interface',
'JAMSHAID',
'24'
],
[
'Cache::Memcached::XS',
'b',
'd',
'h',
'O',
'p',
'Memcache client using libmemcache C library',
'JCARON',
'17'
],
[
'Win32::PowerPoint',
'b',
'd',
'p',
'O',
'p',
'helps to convert texts to PowerPoint slides',
'ISHIGAKI',
'22'
],
[
'Locale::Maketext::Utils',
'R',
'd',
'p',
'O',
'p',
'Add Utility methods to Locale::Maketext objs',
'DMUEY',
'13'
],
[
'SVN::Statistics',
'c',
'd',
'p',
'O',
'p',
'Subversion (SVN) Statistics using RRDTool',
'LINMAR',
'24'
],
[
'CGI',
'R',
'd',
'p',
'O',
'p',
'Simple Common Gateway Interface Class',
'LDS',
'15'
],
[
'Net::OpenVPN::Manage',
'R',
'd',
'p',
'O',
'p',
'Interact with an OpenVPN management port',
'MEYEAARD',
'5'
],
[
'Term::Menu',
'R',
'd',
'p',
'h',
'p',
'Print an interactive menu and get an answer',
'DAZJORZ',
'8'
],
[
'Devel::DumpSizes',
'b',
'd',
'p',
'f',
'p',
'Get name and size in bytes of all variables',
'CGAUTAM',
'3'
],
[
'Geo::Postcodes',
'b',
'd',
'p',
'h',
'p',
'Postcodes, locations and other information',
'ARNE',
'23'
],
[
'Digest::CMAC',
'b',
'd',
'p',
'O',
'p',
'One-key CBC MAC message authentication code',
'OYAMA',
'14'
],
[
'Data::Alias',
'R',
'd',
'c',
'f',
'p',
'Comprehensive set of aliasing operations',
'XMATH',
'2'
],
[
'GPS::Babel',
'a',
'd',
'p',
'O',
'p',
'Interface to gpsbabel',
'ANDYA',
'23'
],
[
'IPC::Mmap::Share',
'b',
'd',
'p',
'O',
'p',
'Share structures using anonymous mmap',
'ADUITSIS',
'5'
],
[
'Clutter',
'b',
'd',
'c',
'O',
'l',
'Simple GL-based canvas library',
'EBASSI',
'8'
],
[
'Algorithm::SVMLight',
'R',
'd',
'h',
'O',
'p',
'Interface to SVMLight Machine-Learning pkg',
'KWILLIAMS',
'23'
],
[
'Parse::YAPP::KeyValue',
'b',
'd',
'p',
'O',
'b',
'simple parser of key/value pairs',
'DIZ',
'11'
],
[
'PDL::Fit::Levmar',
'b',
'm',
'h',
'h',
'p',
'Levenberg-Marquardt fit/optimization routine',
'JLAPEYRE',
'6'
],
[
'Convert::MIL1750A',
'R',
'd',
'p',
'f',
'p',
'Convert decimal and MIL-STD-1750A hex values',
'JTCLARKE',
'11'
],
[
'Data::Float',
'R',
'd',
'p',
'f',
'p',
'details of the floating point data type',
'ZEFRAM',
'6'
],
[
'Openview::Admin',
'i',
'n',
'p',
'O',
'n',
'Perform Openview(OVO,NNM) tasks',
'NHARALE',
'24'
],
[
'AIX::Perfstat',
'a',
'd',
'c',
'f',
'p',
'A wrapper around the AIX libperfstat library',
'ACIDDEATH',
'4'
],
[
'Win32::SDDL::ACE',
'a',
'd',
'p',
'O',
'p',
'Win32::SDDL ACE object class',
'TOJO',
'22'
],
[
'Tripletail',
'b',
'm',
'h',
'O',
'p',
'Tripletail, a framework for Japanese Web App',
'MIKAGE',
'15'
],
[
'Test::UseAllModules',
'b',
'd',
'p',
'f',
'p',
'do use_ok() for all modules MANIFESTed',
'ISHIGAKI',
'3'
],
[
'Set::Partition',
'R',
'd',
'p',
'O',
'p',
'Enumerate all arrangements of a set',
'DLAND',
'6'
],
[
'Data::Scroller',
'M',
'd',
'p',
'O',
'p',
'rolling pageset style data paging',
'BENH',
'6'
],
[
'BSD::Sysctl',
'a',
'd',
'c',
'h',
'p',
'Sysctl variable access for BSD systems',
'DLAND',
'4'
],
[
'Convert::Number::Greek',
'a',
'd',
'p',
'h',
'p',
'Convert between Arabic and Greek numerals',
'SPROUT',
'17'
],
[
'RT::Extension::QueueWizard',
'R',
'd',
'p',
'n',
'g',
'Clone existing RT queues',
'KEVINR',
'23'
],
[
'CGI::Ex::Template::XS',
'a',
'd',
'c',
'O',
'a',
'Fast TT2/TT3 template processor',
'RHANDOM',
'15'
],
[
'URI::ParseSearchString',
'R',
'd',
'p',
'f',
'p',
'extract search engine query strings',
'SDEN',
'15'
],
[
'Apache2::xForwardedFor',
'R',
'd',
'p',
'f',
'p',
'configure proxy requests',
'JVANASCO',
'15'
],
[
'Authen::PluggableCaptcha',
'R',
'd',
'p',
'O',
'p',
'object oriented framework for CAPTCHA',
'JVANASCO',
'14'
],
[
'Religion::Islam::PrayerTimes',
'R',
'd',
'p',
'O',
'g',
'Musilm prayers times and sunrise calculator',
'MEWSOFT',
'20'
],
[
'Religion::Islam::Qibla',
'R',
'd',
'p',
'O',
'g',
'Qiblah Direction Calculator',
'MEWSOFT',
'20'
],
[
'Religion::Islam::Quran',
'R',
'd',
'p',
'O',
'g',
'Holy Quran book searchable database multi-li',
'MEWSOFT',
'20'
],
[
'SQL::Extended',
'c',
'd',
'p',
'O',
'a',
'SQL::Statement extensions subclasses',
'DARNOLD',
'7'
],
[
'Thread::Sociable',
'c',
'd',
'h',
'h',
'a',
'Performance enhanced threads::shared',
'DARNOLD',
'2'
],
[
'Tk::StyledButton',
'b',
'm',
'p',
'O',
'a',
'Stylized Button widget for Perl/Tk',
'DARNOLD',
'8'
],
[
'Devel::Strace',
'R',
'd',
'p',
'f',
'a',
'strace-like runtime call trace for Perl appl',
'DARNOLD',
'3'
],
[
'Devel::RingBuffer',
'R',
'd',
'h',
'O',
'a',
'Shared memory ring buffers for Perl scripts',
'DARNOLD',
'3'
],
[
'Devel::Psichedb',
'c',
'd',
'h',
'h',
'o',
'interactive, attachable Perl debugger',
'DARNOLD',
'3'
],
[
'Data::SimplePassword',
'c',
'd',
'p',
'O',
'p',
'Simple random password generator',
'RYOCHIN',
'11'
],
[
'Etk',
'b',
'd',
'c',
'O',
'p',
'Bindings for the Enlightenment Toolkit',
'LEVIATHAN',
'8'
],
[
'Chart::EPS_graph',
'R',
'd',
'p',
'O',
'p',
'Generate EPS and PNG graphs',
'APLONIS',
'18'
],
[
'Crypt::Eksblowfish',
'R',
'd',
'c',
'O',
'p',
'the Eksblowfish block cipher',
'ZEFRAM',
'14'
],
[
'Debug::Message',
'R',
'd',
'p',
'O',
'p',
'Let\'s you easily debug print.',
'ATG',
'3'
],
[
'Directory::Scratch',
'R',
'd',
'p',
'O',
'p',
'self-cleaning scratch space for tests',
'JROCKWAY',
'10'
],
[
'Image::Magick::Square',
'b',
'd',
'p',
'f',
'p',
'square image from existing Image::Magick obj',
'LEOCHARRE',
'18'
],
[
'Image::Magick::Thumbnail::NotFound',
'b',
'd',
'p',
'O',
'p',
'make thumbnails as http requests fail',
'LEOCHARRE',
'18'
],
[
'Image::MetaData::GQview',
'b',
'd',
'p',
'O',
'g',
'Perl extension for GQview image metadata',
'KETHGEN',
'18'
],
[
'Net::SAML',
'c',
'd',
'c',
'f',
'o',
'Parse and generate SAML Assertions for SSO',
'SAMPO',
'5'
],
[
'POE::Component::Client::Traceroute',
'b',
'd',
'p',
'O',
'p',
'POE Component for traceroutes',
'AHOYING',
'5'
],
[
'Statistics::Sequences',
'b',
'n',
'p',
'O',
'g',
'Analyse data for sequential structure',
'RGARTON',
'6'
],
[
'Crypt::Eksblowfish::Bcrypt',
'R',
'd',
'p',
'f',
'p',
'Blowfish-based Unix crypt() password hash',
'ZEFRAM',
'14'
],
[
'File::Attributes',
'R',
'd',
'p',
'h',
'p',
'manipulate metadata on files',
'JROCKWAY',
'10'
],
[
'WWW::MySpaceBot',
'b',
'd',
'p',
'O',
'p',
'libwww-perl interface to MySpace.com',
'KIRSLE',
'15'
],
[
'Crypt::OpenSSL::AES',
'a',
'd',
'c',
'O',
'p',
'Interface to AES functionality in OpenSSL',
'TTAR',
'14'
],
[
'Mail::Convert::Mbox::ToEml',
'R',
'u',
'p',
'O',
'p',
'Convert  Mbox to OE single eml files',
'RPAGITSCH',
'19'
],
[
'Win32::Process::User',
'b',
'u',
'c',
'O',
'p',
'get user + domain for a given PID or name',
'RPAGITSCH',
'22'
],
[
'WebService::Basecamp',
'b',
'd',
'p',
'O',
'p',
'Perl interface to the Basecamp API',
'DAVIDB',
'15'
],
[
'Catalyst::Plugin::FormBuilder',
'R',
'd',
'p',
'O',
'p',
'Catalyst FormBuilder Plugin',
'NWIGER',
'15'
],
[
'Class::Std::Slots',
'b',
'd',
'p',
'O',
'a',
'Add signals and slots to Class::Std',
'ANDYA',
'2'
],
[
'Cache::Static',
'R',
'd',
'p',
'O',
'g',
'Caching without freshness concerns',
'BRIANSKI',
'17'
],
[
'SVN::Diff',
'R',
'd',
'p',
'f',
'p',
'Extract Diffs from a subversion server',
'DMUEY',
'24'
],
[
'CGI::Wiki::Store::Mediawiki',
'a',
'd',
'p',
'O',
'p',
'Mediawiki Store for CGI::Wiki',
'DPRICE',
'15'
],
[
'Catalyst::Model::XML::Feed',
'R',
'd',
'p',
'O',
'p',
'use RSS/Atom feeds as a Catalyst model',
'JROCKWAY',
'15'
],
[
'Carp::Clan',
'R',
'd',
'p',
'f',
'p',
'blame errors on callers of "clan" of modules',
'STBEY',
'2'
],
[
'LaTeX::Table',
'a',
'd',
'p',
'O',
'p',
'Automatic generation of LaTeX tables',
'LIMAONE',
'23'
],
[
'Test::Pod::Snippets',
'a',
'd',
'p',
'O',
'p',
'Generate tests from pod code snippets',
'YANICK',
'3'
],
[
'Device::LabJack::Control',
'R',
'd',
'p',
'O',
'p',
'An OO interface to Device::LabJack',
'APLONIS',
'4'
],
[
'Text::MultiMarkdown',
'b',
'd',
'p',
'f',
'o',
'Convert MultiMarkdown syntax to (X)HTML',
'KULP',
'11'
],
[
'IO::Socket::ByteCounter',
'R',
'd',
'p',
'O',
'p',
'Count # of bytes In/Out of an IO::Socket obj',
'DMUEY',
'21'
],
[
'HTTP::Daemon::Threaded',
'c',
'd',
'p',
'O',
'o',
'Apartment threaded HTTP::Daemon',
'DARNOLD',
'15'
],
[
'Template::Multilingual',
'R',
'd',
'p',
'O',
'p',
'Multilingual templates for Template Toolkit',
'CHOLET',
'11'
],
[
'Text::Bidi',
'a',
'd',
'h',
'h',
'p',
'Unicode bidi algorithm-libfribidi interface',
'KAMENSKY',
'11'
],
[
'SMS::Send::TW::PChome',
'R',
'u',
'p',
'O',
'g',
'SMS::Send driver for sms.pchome.com.tw',
'SNOWFLY',
'15'
],
[
'Config::File',
'M',
'd',
'p',
'f',
'p',
'Parse a simple configuration file',
'GWOLF',
'12'
],
[
'Test::TestCoverage',
'a',
'd',
'p',
'f',
'p',
'Test if your test covers all \'public\' method',
'RENEEB',
'3'
],
[
'Params::Profile',
'R',
'd',
'p',
'f',
'o',
'Module for registering parameter profiles',
'MICHIEL',
'12'
],
[
'Catalyst::Plugin::Params::Profile',
'R',
'd',
'p',
'f',
'o',
'Parameter checking with Params::Profile',
'MICHIEL',
'15'
],
[
'Catalyst::Plugin::Log::Message',
'R',
'd',
'p',
'f',
'o',
'Log::Message plugin for Catalyst',
'MICHIEL',
'15'
],
[
'WebService::Eventful',
'R',
'm',
'p',
'O',
'p',
'Interface to the Eventful web services API',
'RADCLIFF',
'15'
],
[
'Linux::Sysfs',
'b',
'd',
'c',
'O',
'l',
'Perl interface to libsysfs',
'FLORA',
'4'
],
[
'Win32::MediaPlayer',
'R',
'u',
'p',
'O',
'a',
'Play audio (wma mp3) video (wmv mpeg avi)',
'KENWU',
'22'
],
[
'Authen::OTP',
'i',
'd',
'p',
'h',
'p',
'RFC 2289 one-time password system',
'ZEFRAM',
'14'
],
[
'Dumpvalue::HTML',
'R',
'd',
'p',
'O',
'p',
'Get HTML safe output from Dumpvalue',
'DMUEY',
'6'
],
[
'Web::Scaffold',
'R',
'd',
'p',
'f',
'g',
'build minimalist fancy web sites',
'MIKER',
'15'
],
[
'Win32::TSA::Notify',
'a',
'd',
'p',
'O',
'p',
'Win32 TSA Notification System',
'THW',
'22'
],
[
'Pod::InComments',
'c',
'd',
'p',
'O',
'p',
'extracts POD hidden in comments',
'ANDREWF',
'3'
],
[
'Net::WSF',
'c',
'd',
'c',
'f',
'o',
'Web Services Framework ID-WSF 2.0, 1.1, etc.',
'SAMPO',
'5'
],
[
'Sub::ForceEval',
'R',
'm',
'p',
'p',
'p',
'rethrow exceptions if eval-ed, else cluck.',
'LEMBARK',
'3'
],
[
'Geo:Gpx',
'R',
'd',
'p',
'O',
'p',
'Conversion of GPX GPS file formats',
'RBOW',
'6'
],
[
'CPAN::Reporter',
'b',
'd',
'p',
'f',
'p',
'Provides Test::Reporter support for CPAN.pm',
'DAGOLDEN',
'23'
],
[
'WebService::YouTube',
'b',
'd',
'p',
'O',
'p',
'Perl interfece to YouTube',
'YOSHIDA',
'15'
],
[
'DBIx::Std',
'R',
'd',
'p',
'O',
'p',
'Standardize a DBI based app\'s DB interaction',
'DMUEY',
'7'
],
[
'Win32::PerlExe::Env',
'a',
'd',
'p',
'f',
'p',
'Get environment of Win32 Perl executables',
'THW',
'22'
],
[
'Games::Freelancer',
'R',
'd',
'p',
'h',
'b',
'interfaces for Microsoft Freelancer data',
'MALUKU',
'24'
],
[
'WebService::ISBNDB',
'a',
'd',
'p',
'O',
'a',
'Data classes for accessing isbndb.com',
'RJRAY',
'15'
],
[
'DBIx::ORM::Declarative',
'b',
'd',
'p',
'O',
'p',
'Creates db objects with descriptive syntax',
'JSCHNEID',
'7'
],
[
'Net::Server::Mail::ESMTP::XFORWARD',
'b',
'd',
'p',
'O',
'p',
'add support to the XFORWARD command',
'GUIMARD',
'19'
],
[
'Module::Versions',
'a',
'd',
'p',
'O',
'p',
'Handle module versions with flex. interface',
'THW',
'3'
],
[
'Net::CBQ',
'i',
'd',
'p',
'f',
'g',
'Class Based Queueing',
'DEEPAK',
'5'
],
[
'DBIx::Timeout',
'R',
'm',
'p',
'O',
'p',
'provides safe timeouts for DBI calls',
'SAMTREGAR',
'7'
],
[
'Test::Trap',
'a',
'd',
'p',
'h',
'p',
'Trap exit codes, exceptions, output, etc.',
'EBHANSSEN',
'3'
],
[
'POE::Filter::FSSocket',
'a',
'm',
'p',
'n',
'o',
'FreeSWITCH event socket POE Filter',
'PTINSLEY',
'5'
],
[
'Clone::More',
'b',
'd',
'h',
'f',
'p',
'Natively copying Perl data structures',
'WAZZUTEKE',
'6'
],
[
'Devel::GDB::Reflect',
'b',
'd',
'p',
'O',
'g',
'C++ reflection API for GDB',
'AFN',
'3'
],
[
'Linux::Bootloader',
'R',
'm',
'p',
'O',
'p',
'Modifies bootloader config files',
'BRYCE',
'4'
],
[
'Lingua::ZH::WordSegment',
'a',
'd',
'p',
'f',
'p',
'Simplified Chinese Word Segmentation',
'CHENYR',
'11'
],
[
'LEGO::NXT',
'a',
'd',
'p',
'O',
'g',
'LEGO NXT direct commands interface',
'COLLINS',
'23'
],
[
'Time::Space::Adaptive',
'R',
'd',
'p',
'O',
'p',
'Time::Piece with dynamic stringify.',
'DPRICE',
'6'
],
[
'Wiki::Toolkit::Store::Mediawiki',
'a',
'd',
'p',
'O',
'p',
'Mediawiki Store for Wiki::Toolkit',
'DPRICE',
'15'
],
[
'Wiki::Toolkit::Mediawiki',
'a',
'd',
'p',
'n',
'p',
'Perl Clone of the PHP Mediawiki',
'DPRICE',
'15'
],
[
'Wiki::Toolkit::Formatter::Mediawiki',
'a',
'd',
'p',
'O',
'p',
'Mediawiki Formatter for Wiki::Toolkit',
'DPRICE',
'15'
],
[
'Geo::Coder::YahooJapan',
'b',
'd',
'p',
'O',
'p',
'a wrapper for Yahoo Japan Geocoder API',
'KUMA',
'23'
],
[
'Template::Plugin::Trac',
'R',
'd',
'p',
'O',
'p',
'TT filter for Text::Trac',
'GTERMARS',
'11'
],
[
'WWW::PkgFind',
'R',
'm',
'p',
'O',
'p',
'Retrieves software packages from web/ftp',
'BRYCE',
'15'
],
[
'Crypt::ProtectedString',
'c',
'd',
'p',
'O',
'p',
'For automated handling of sensitive data.',
'IDO',
'14'
],
[
'Konstrukt',
'b',
'd',
'p',
'O',
'p',
'Web application/design framework',
'TWITTEK',
'15'
],
[
'Data::Generate',
'b',
'd',
'p',
'O',
'p',
'generate high customizable synthetic data',
'DACONTI',
'11'
],
[
'Pod::Perldoc::ToToc',
'b',
'd',
'p',
'O',
'a',
'Translate Pod to a Table of Contents',
'BDFOY',
'26'
],
[
'Task::Catalyst::Tutorial',
'R',
'm',
'p',
'n',
'p',
'install Catalyst Tutorial + dependencies',
'JROCKWAY',
'15'
],
[
'Test::WWW::Selenium::Catalyst',
'b',
'm',
'h',
'O',
'p',
'test your Catalyst app with Selenium',
'JROCKWAY',
'15'
],
[
'Crypt::Trillian3',
'c',
'd',
'p',
'O',
'p',
'Trillian v3.x Encrypt/Decrypt',
'CMORRIS',
'14'
],
[
'WWW::WordPress',
'c',
'd',
'p',
'O',
'p',
'Modul for posting to Wordpress Blogs',
'SENGER',
'15'
],
[
'Tivoli::AccessManager',
'b',
'd',
'h',
'O',
'a',
'OO interface to TAM',
'MIKFIRE',
'24'
],
[
'Business::US::USPS::WebTools',
'a',
'd',
'p',
'O',
'a',
'Perl interface to US Postal Service WebTools',
'BDFOY',
'15'
],
[
'Mozilla::nsID',
'a',
'd',
'c',
'O',
'p',
'Mozilla nsID interface wrapper',
'BOSU',
'15'
],
[
'WWW::Sucksub::Extratitles',
'b',
'd',
'p',
'O',
'p',
'automated access to extratitles.com',
'TFOUCART',
'15'
],
[
'Alien::scriptaculous',
'R',
'd',
'o',
'O',
'p',
'find and install script.aculo.us',
'GTERMARS',
'15'
],
[
'RPC::Object',
'c',
'd',
'p',
'O',
'p',
'A lightweight pure Perl RPC implementation',
'JWU',
'5'
],
[
'Games::FEAR::Log',
'i',
'd',
'p',
'O',
'p',
'Log analyzer for the multiplayer game FEAR',
'EVANK',
'23'
],
[
'Win32::Env',
'R',
'd',
'p',
'f',
'p',
'System/user enviroment variables under Win32',
'ROWAA',
'22'
],
[
'Perl::Tidyview',
'a',
'd',
'p',
'h',
'p',
'A previewer for perltidy reformatting',
'LEIF',
'2'
],
[
'CORBA::omniORB',
'b',
'd',
'+',
'O',
'l',
'Perl module for CORBA 2.x using omniORB',
'HOUSEL',
'5'
],
[
'Text::ASCIIMathML',
'b',
'd',
'p',
'O',
'p',
'Converts ASCIIMathML text to MathML markup',
'NODINE',
'11'
],
[
'Text::Twiddler',
'R',
'd',
'p',
'O',
'p',
'base class to twiddle text in any output',
'DMUEY',
'11'
],
[
'ICS::Simple',
'R',
'd',
'p',
'O',
'p',
'Simple interface to CyberSource ICS2',
'WILSOND',
'15'
],
[
'Mail::QmailSend::MultilogParser',
'b',
'd',
'p',
'f',
'p',
'Parse qmail-send multilog files',
'MASAHITO',
'19'
],
[
'Lingua::TR::Numbers',
'R',
'd',
'p',
'f',
'p',
'Converts numbers into Turkish text',
'BURAK',
'11'
],
[
'Apache::Logmonster',
'M',
'm',
'p',
'O',
'b',
'merge, sort, and process apache log files',
'MSIMERSON',
'16'
],
[
'Math::MultiplicationTable',
'b',
'd',
'p',
'f',
'p',
'Generate multiplication table',
'PMINT',
'23'
],
[
'Ingres::Utility::IINamu',
'a',
'd',
'p',
'O',
'p',
'API to IINAMU Ingres RDBMS utility',
'WORM',
'7'
],
[
'Compress::LZW::Progressive',
'b',
'd',
'p',
'O',
'p',
'Progressive LZW-like compression',
'EWATERS',
'17'
],
[
'POE::Filter::LZW::Progressive',
'a',
'd',
'p',
'O',
'p',
'POE filter using Compress::LZW::Progressive',
'EWATERS',
'16'
],
[
'Parse::DMIDecode',
'R',
'd',
'p',
'O',
'o',
'Interface to SMBIOS under using dmidecode',
'NICOLAW',
'11'
],
[
'Config::LotusNotes',
'R',
'd',
'p',
'O',
'p',
'Access Lotus Notes/Domino configuration',
'ALBERS',
'24'
],
[
'Mac::Accessibility',
'b',
'd',
'p',
'O',
'p',
'Perl wrapper for Accessibility',
'BOGA',
'4'
],
[
'Data::URIEncode',
'b',
'd',
'p',
'f',
'p',
'(En|De)code complex data in key/value URIs',
'RHANDOM',
'6'
],
[
'Test::XML::Order',
'b',
'd',
'p',
'O',
'a',
'Extend Test::XML to test element order.',
'GAM',
'3'
],
[
'SNMP::Persist',
'b',
'd',
'p',
'f',
'g',
'backend for pass_persist feature of net-snmp',
'ANIAS',
'5'
],
[
'Data::Hierarchy::Traverser',
'c',
'd',
'p',
'f',
'p',
'Generic hierarchy structure traversal',
'TIGERPERL',
'23'
],
[
'List::Pairwise',
'R',
'd',
'p',
'f',
'p',
'map/grep arrays and hashes pairwise',
'TDRUGEON',
'6'
],
[
'POE::Component::IMDB',
'R',
'd',
'p',
'O',
'p',
'POE Component to talk to IMDB.com',
'BUU',
'15'
],
[
'Lingua::EN::Conjugate',
'a',
'd',
'p',
'f',
'p',
'Conjugate English verbs',
'RWG',
'11'
],
[
'Ingres::Utility::IIMonitor',
'a',
'd',
'p',
'O',
'p',
'API to iimonitor Ingres RDBMS utility',
'WORM',
'7'
],
[
'Mozilla::PromptService',
'c',
'd',
'h',
'h',
'p',
'wraps Mozilla nsIPromptService interface',
'BOSU',
'15'
],
[
'Mozilla::ObserverService',
'c',
'd',
'h',
'h',
'p',
'Interface to Mozilla nsIObserverService',
'BOSU',
'15'
],
[
'Weather::Underground::StationHistory',
'b',
'd',
'p',
'f',
'p',
'Historical data from http://wunderground.com',
'ELLIOTJS',
'23'
],
[
'Mac::Apps::Seasonality::LoadICAOHistory',
'a',
'd',
'p',
'f',
'p',
'Load data into Seasonality\'s database.',
'ELLIOTJS',
'24'
],
[
'Geo::OGR',
'i',
'm',
'+',
'O',
'p',
'An interface to the OGR library',
'AJOLMA',
'6'
],
[
'Geo::OSR',
'i',
'd',
'p',
'f',
'p',
'Interface to the SR classes in GDAL',
'AJOLMA',
'6'
],
[
'Bio::Trace::ABIF',
'b',
'd',
'p',
'O',
'p',
'Read and parse ABIF file format',
'VITA',
'23'
],
[
'CFEngine::CFPerl',
'b',
'd',
'p',
'h',
'a',
'cfengine parser and extender module',
'TEODOR',
'23'
],
[
'Geo::Spline',
'a',
'd',
'p',
'O',
'p',
'Calculate geographic locations btw GPS fixes',
'MRDVT',
'6'
],
[
'Mozilla::Mechanize::GUITester',
'c',
'd',
'p',
'O',
'p',
'Mozilla::Mechanize with GUI testing',
'BOSU',
'15'
],
[
'WWW::Translate::interNOSTRUM',
'b',
'd',
'p',
'O',
'p',
'Catalan <> Spanish machine translation',
'ENELL',
'15'
],
[
'Security::CVSS',
'b',
'd',
'p',
'O',
'p',
'Calculates CVSS values',
'JDENNIS',
'14'
],
[
'Asterisk::FastAGI',
'b',
'd',
'p',
'O',
'p',
'Provides support for FastAGI.',
'JAYWHY',
'25'
],
[
'Net::Amazon::EC2',
'a',
'd',
'p',
'O',
'a',
'A Perl module to interact with Amazon\'s EC2',
'JKIM',
'23'
],
[
'Mozilla::ConsoleService',
'c',
'd',
'h',
'h',
'p',
'Perl interface to Mozilla nsIConsoleService',
'BOSU',
'15'
],
[
'Geo::HelmertTransform',
'M',
'd',
'p',
'O',
'p',
'Geodetic datum transformations',
'MYSOCIETY',
'23'
],
[
'Bundle::Parrot',
'b',
'm',
'p',
'n',
'p',
'prereqs for developing and testing parrot',
'PARTICLE',
'25'
],
[
'Google::Spreadsheet',
'c',
'd',
'p',
'O',
'p',
'Manipulate Google Spreadsheets data',
'LPETERS',
'7'
],
[
'WWW::Mechanize::Pliant',
'a',
'd',
'p',
'O',
'a',
'crawl Pliant based websites.',
'REITMAN',
'15'
],
[
'Tk::DiffText',
'b',
'd',
'p',
'O',
'p',
'Perl/Tk widget for colorized diffs',
'MJCARMAN',
'8'
],
[
'Catalyst::Plugin::I18N::DBIC',
'b',
'd',
'p',
'O',
'p',
'Load I18N Lexicon data from a database',
'ICD',
'15'
],
[
'WebService::Geograph::API',
'b',
'd',
'p',
'O',
'p',
'Perl interface to the Geograph.co.uk API',
'SDEN',
'15'
],
[
'Color::Calc',
'b',
'd',
'p',
'O',
'p',
'Simple calculations with RGB colors',
'CFAERBER',
'8'
],
[
'Linux::KernelSort',
'a',
'd',
'p',
'O',
'g',
'Sort a list of Linux kernel versions.',
'OGASAWARA',
'4'
],
[
'Statistics::SDT',
'b',
'n',
'p',
'O',
'p',
'Signal detection theory measures',
'RGARTON',
'6'
],
[
'Lexical::Persistence',
'b',
'd',
'p',
'h',
'p',
'Bind lexicals to persistent data.',
'RCAPUTO',
'6'
],
[
'XML::API::WIX2',
'b',
'd',
'p',
'f',
'p',
'WiX ver2 doctype extension to XML::API',
'RBDAVISON',
'3'
],
[
'Games::Go::SGF',
'b',
'd',
'p',
'O',
'p',
'Parse and dissect Standard Go Format files',
'DEG',
'23'
],
[
'Ingres::Utility::Netutil',
'a',
'd',
'p',
'O',
'p',
'API to netutil Ingres RDBMS utility',
'WORM',
'7'
],
[
'Lemonldap::NG::Manager',
'a',
'd',
'p',
'O',
'p',
'Modules to manage Lemonldap::NG system',
'GUIMARD',
'14'
],
[
'XML::Descent',
'b',
'd',
'p',
'O',
'p',
'Simple recursive descent XML parsing',
'ANDYA',
'11'
],
[
'Class::XML::Parser',
'R',
'd',
'p',
'O',
'p',
'Parses an XML message into a class structure',
'MMORGAN',
'6'
],
[
'Time::LST',
'b',
'n',
'p',
'f',
'p',
'Convert datetime to LST via Astro-Time',
'RGARTON',
'6'
],
[
'WWW::Scraper::ISBN::LibUniIt_Driver',
'b',
'd',
'p',
'O',
'p',
'Search driver for libreriauniversitaria.it',
'LUCHA',
'15'
],
[
'Geo::Ellipsoids',
'a',
'm',
'p',
'O',
'p',
'Package for ellipsoid a, b, f and 1/f values',
'MRDVT',
'6'
],
[
'XML::Pastor',
'a',
'd',
'p',
'O',
'p',
'Generate classes/round-trip XML persistence',
'AULUSOY',
'11'
],
[
'Router::Statistics',
'a',
'd',
'p',
'O',
'p',
'The collection of router statistics',
'SHAMROCK',
'23'
],
[
'Crypt::PBC',
'b',
'd',
'h',
'O',
'g',
'OO interface for the Stanford PBC library',
'JETTERO',
'14'
],
[
'Class::CompiledC',
'b',
'd',
'h',
'h',
'a',
'C Structs as Objects;Dynamic generated code',
'BLADE',
'2'
],
[
'Geo::GeoNames',
'a',
'd',
'p',
'O',
'p',
'Perform geographical queries using GeoNames',
'PERHENRIK',
'23'
] );
#];

$verb3 = 0;
sub mycmp_decenda {
   if (${$a}[0] lt ${$b}[0]) {
      prt( "+[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
      return 1;
   }
   if (${$a}[0] gt ${$b}[0]) {
      prt( "-[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
      return -1;
   }
   prt( "=[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
   return 0;
}

sub mycmp_ascenda {
   if (${$a}[0] gt ${$b}[0]) {
      prt( "+[".${$a}[0]."] > [".${$b}[0]."]\n" ) if $verb3;
      return 1;
   }
   if (${$a}[0] lt ${$b}[0]) {
      prt( "-[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
      return -1;
   }
   prt( "=[".${$a}[0]."] = [".${$b}[0]."]\n" ) if $verb3;
   return 0;
}

sub mycmp_ascendac {
   if (uc(${$a}[0]) gt uc(${$b}[0])) {
      prt( "+[".${$a}[0]."] > [".${$b}[0]."]\n" ) if $verb3;
      return 1;
   }
   if (uc(${$a}[0]) lt uc(${$b}[0])) {
      prt( "-[".${$a}[0]."] < [".${$b}[0]."]\n" ) if $verb3;
      return -1;
   }
   prt( "=[".${$a}[0]."] = [".${$b}[0]."]\n" ) if $verb3;
   return 0;
}


$ccnt = scalar @cols;
$mcnt = scalar @mdata;
@smdata = sort mycmp_ascendac @mdata;
$maxwid = 0;
prt( "Module list at $RDate ... $mcnt\n" );
for ($ccnt = 0; $ccnt < $mcnt; $ccnt++) {
	my $nm = $mdata[$ccnt][0];
	my $len = length($nm);
	$maxwid = $len if ($len > $maxwid);
}
for ($ccnt = 0; $ccnt < $mcnt; $ccnt++) {
	my $nm = $smdata[$ccnt][0];
	my $dsc = $smdata[$ccnt][6];
	my $au = $smdata[$ccnt][7];
	$nm .= ' ' while (length($nm) < $maxwid);
	prt( "$nm - $dsc, by $au\n" );
}
prt( "END Module list at $RDate ... $mcnt\n" );

close_log($outfile,1);
exit(0);
