#!/perl -w
# NAME: newfolders.pl
# AIM: given two folders, do a resursive search and report new folder,
# or folders in the first not in the second
# input: first_folder second_folder
use strict;
use warnings;
require 'logfile.pl' or die "Unable to load logfile.pl ...\n";
# log file stuff
my ($LF);
my $outfile = 'temp.'.$0.'.txt';
if ($0 =~ /\w{1}:\\.*/) {
	my @tmpsp = split(/\\/,$0);
	$outfile = 'temp.'.($tmpsp[-1]).'.txt';
}
open_log($outfile);
prt( "$0 ... Hello, World ...\n" );
# DEBUG ONLY
my $dbg1 = 1;	# use default inputs
#my $dffolder = 'C:\FGCVS\OpenSceneGraph';
#my $dsfolder = 'C:\FG\12\OpenSceneGraph';
my $dffolder = 'C:\FGCVS\OpenAL';
my $dsfolder = 'C:\FG\12\OpenAL';
my $dbg2 = 0;	# show folder count as it happens

my $ffolder = '';
my $sfolder = '';
parse_args( @ARGV );
if ( ! -d $ffolder) {
	mydie( "ERROR: $ffolder is NOT a DIRECTORY!\n" );
}
if ( ! -d $sfolder) {
	mydie( "ERROR: $sfolder is NOT a DIRECTORY!\n" );
}
prt( "Processing first=$ffolder, second=$sfolder ...\n" );
my @first = ();
my @second = ();
my $tcnt = 0;
my $gcnt = 0;
@first = process_folder( $ffolder, 0 );
@second = process_folder( $sfolder, 0 );
my $cnt1 = scalar @first;
my $cnt2 = scalar @second;
$gcnt += $tcnt;
prt( "Found first $cnt1, 2nd $cnt2 directories ... $gcnt total ...\n" );
my @newfolders = ();
my $dir1 = '';
my $dir2 = '';
my $ds1 = '';
my $ds2 = '';
my $fnd = 0;
my $tot = ($cnt1 * $cnt2);
my $icnt = 0;

prt( "Moment ... processing 2nd, comparing to 1st, to get NEW folders ... up to $tot interations ...\n" );
foreach $dir1 (@second) {
	$ds1 = submain( $dir1, $sfolder );
	$fnd = 0;
	foreach $dir2 (@first) {
		$ds2 = submain( $dir2, $ffolder );
		if (uc($ds1) eq uc($ds2)) {
			$fnd = 1;
			last;
		}
		$icnt++;
		if (($icnt % 15000) == 0) {
			prt( "Done $icnt of $tot ...\n" );
		}
	}
	if ($fnd == 0) {
		push(@newfolders, $dir1);
	}
	$tot -= $cnt1;
}
prt( "Done $icnt of $tot ...\n" );
prt( "Found ".scalar @newfolders." new folders in $sfolder ...\n" );
foreach $dir1 (@newfolders) {
	##$ds1 = submain($dir1, $sfolder);
	prt( "xdelete -dfr \"$dir1\"\n" );
}
close_log($outfile,1);
exit(0);

###############################
# subs only
sub submain {
	my ($d, $m) = @_;
	return substr($d, length($m)+1);
}
sub process_folder {
	my ($in, $level) = @_;
	if ($level == 0) {
		prt( "\nProcessing folder $in ... \n" );
	}
	my @dirs = ();
	if ( !opendir(DIR, $in) ) {
		prt( "ERROR: Unable to open directory [$in] ...\n" );
		return @dirs;
	}
	my @files = readdir(DIR);
	closedir DIR;
	my $cnt = 0;
	foreach my $file (@files) {
		if (($file eq '.') || ($file eq '..')) {
			next;
		}
		$cnt++;
		my $ff = $in . '\\' . $file;
		if ( -d $ff ) {
			push(@dirs, $ff);
			$tcnt++;
		}
	}
	my $cnt2 = scalar @dirs;
	prt( "Found $cnt items, $cnt2 directories ...\n" ) if $dbg2 && ($cnt2 > 0);
	my @sdirs = @dirs;
	foreach my $dir (@sdirs) {
		my @subdirs = process_folder($dir, ($level + 1));
		foreach $dir (@subdirs) {
			push(@dirs, $dir);
		}
	}
	if ($tcnt > 1000) {
		$gcnt += $tcnt;
		prt( "Got $gcnt folders, so far ...\n" );
		$tcnt = 0;
	}
	return @dirs;
}

sub parse_args {
	my (@av) = @_;
	while (@av) {
		my $arg = shift @av;
		if (length($ffolder)) {
			if (length($sfolder)) {
				prt( "ERROR: Already have first=$ffolder, second=$sfolder ...\n" );
				mydie( "Only input is first_folder second_folder ...\n" );
			}
			$sfolder = $arg;
		} else {
			$ffolder = $arg;
		}
	}
	if ( !length($ffolder) || !length($sfolder) ) {
		if ($dbg1) {
			if (!length($ffolder)) {
				$ffolder = $dffolder;
			}
			if (!length($sfolder)) {
				$sfolder = $dsfolder;
			}
		} else {
			prt( "ERROR: Two folder names not found!\n" );
			mydie( "Useage: first_folder second_folder ...\n" );
		}
	}
}

# eof = newfolders.pl
