#!/usr/bin/perl -w
# NAME: opendir01.pl
# AIM: Open a directory, and get a file list with a specific extension
# 24/07/2010 - some small enhancements
use strict;
use warnings;

my $recursive = 0;

my $in_folder = "C:\\FG\\27\\terragear-cs\\projects\\msvc";

my @dsp_files = ();
my $tot_files = 0;

my $os = $^O;

my $dbg01 = 0;
my $sep = "\\";
if ($os ne 'MSWin32') {
    $sep = '/';
}
sub prt($) { print shift; }

sub get_files($$);

sub get_files($$) {
    my ($ind,$lev) = shift;
    my $cnt = 0;
    my @dirs = ();
    my ($ff,@files,$file);
    prt("Processing directory [$ind]...\n") if ($lev == 0);
    if (opendir( DIR, $ind )) {
	    @files = readdir(DIR);
		closedir DIR;
        foreach $file (@files) {
            next if (($file eq ".") || ($file eq ".."));
            $ff = $ind.$sep.$file;
            if ( -d $ff ) {
                push(@dirs,$ff); # strore the directory
            } else {
                $tot_files++;
                if ((length($file) > 4) && (substr($file,-4) =~ /\.dsp/i)) {
                    $cnt++;
                    prt( "File $cnt: $file\n" ) if ($dbg01);
                    push(@dsp_files, $ff);
                }
            }
        }
        if ($recursive) {
            foreach $ff (@dirs) {
                get_files($ff,($lev + 1));
            }
        }
    } else {
        prt( "ERROR: Unable to open directory [$ind]...\n" );
    }
    return \@dsp_files;
}

sub show_array_ref($) {
    my ($ra) = @_;
    my ($file,$cnt);
    $cnt = 0;
    foreach $file (@{$ra}) {
        $cnt++;
        prt("$cnt: $file\n");
    }
}

sub process_in_folder($) {
    my ($inf) = @_;
    my $rfile_list = get_files( $inf, 0 );
    my $dsp_cnt = scalar @{$rfile_list};
    prt( "Processed $tot_files, to get $dsp_cnt files with '.dsp' extent...\n");
    show_array_ref($rfile_list);
    prt( "Of $tot_files, listed $dsp_cnt...\n");
}

prt( "$0 ... Processing $in_folder... in [$os]\n" );
process_in_folder($in_folder);
exit(0);

# eof - opendir01.pl
