#!/usr/bin/perl
#< pas2inch.pl - to H-pascal/Mb to inches - 20130415

my $INCH_TO_PASCAL = 3386.38866667;
my $PASCAL_TO_INCH = 0.000295299830714;

# QNH with pressure below STD (1013.25 Hpa/Mb)

sub prt($) { print shift; }

if (@ARGV) {
    my $hpas = $ARGV[0];
    if ($hpas =~ /^[-+]?[0-9]*\.?[0-9]+$/) {
        my $inchs = $hpas * 100 * $PASCAL_TO_INCH;
        my $dinch = (int(($inchs + 0.005) * 100) / 100);
        prt("Hpa/Mb $hpas = $dinch inches ($inchs)\n");
    } else {
        prt("Does not appear to be a decimal number [$hpas]!\n");
    }
} else {
    prt("Give decimal Hpa/Mb to convert to inches\n");
}

# eof
