#!/usr/bin/perl -w
# NAME: probe-os.pl
# AIM: Show some information about the Perl version, and the underlying OS
# 14/10/2009 minor update
# 10/03/2009 geoff mclane http://geoffair.net/mperl
use strict;
use warnings;
use Probe::Perl;  # NOTE THIS PACKAGE REQUIREMENT!!! Use PPM to install, if missing!
#use Env qw(ComSpec);
use Env qw(COMSPEC);
use Config;

#my $p = Probe::Perl->new();
 
# Version of this perl as a floating point number
#my $ver = $p->perl_version();
my $ver = Probe::Perl->perl_version();
print "Perl Version [$ver] = Probe::Perl->perl_version()\n";

# Convert a multi-dotted string to a floating point number
#$ver = $p->perl_version_to_float($ver);
#$ver = Probe::Perl->perl_version_to_float($ver);
 
# Check if the given perl is the same as the one currently running
#$bool = $p->perl_is_same($perl_path);
#$bool = Probe::Perl->perl_is_same($perl_path);
 
# Find a path to the currently-running perl
# $path = $p->find_perl_interpreter();
my $path = Probe::Perl->find_perl_interpreter();
print "Path         [$path] = Probe::Perl->find_perl_interpreter()\n";
 
# # Get @INC before run-time additions
# @paths = $p->perl_inc();
# @paths = Probe::Perl->perl_inc();
 
# # Get the general type of operating system
# $type = $p->os_type();
my $type = Probe::Perl->os_type();
print "OS Type      [$type] = Probe::Perl->os_type()\n";

# Access Config.pm values
# $val = $p->config('foo');
# $val = Probe::Perl->config('foo');
# $p->config('foo' => 'bar');  # Set locally
# $p->config_revert('foo');  # Revert

print "Current OS = [$^O] = \$^O\n";
print "Or it is     [$Config{osname}] = \$Config{osname}\n";

if ( defined $COMSPEC ) {
   print "ComSpec    = [$COMSPEC] = \$COMSPEC\n";
   if ( $COMSPEC =~ /\w{1}:/ ) {
      print "This is    = [windows]\n";
   } else {
      print "What is this?\n";
   }
} else {
   print "This is NOT windows.\n";
}

# eof - probe-os.pl = probe OS
