#!/usr/bin/perl -w
# NAME: setxml.pl
# AIM: SPECIAL: Read an input set file list, and process each with fgxmlset.exe or sgxmlset.exe
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Data::Dumper;
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);
my $tempout = $temp_dir.$PATH_SEP."tempxmlset.txt";
my $tempout2 = $temp_dir.$PATH_SEP."tempxmlset2.txt";

# user variables
my $VERS = "0.0.5 2015-01-09";
my $load_log = 0;
# primary files containing the list of 'set' files
my $in_file = 'F:\Projects\aircraft\addsetlist.txt';    # addon list
my $in_file2 = 'F:\Projects\aircraft\fgdataset.txt';    # fgdata list

my $verbosity = 0;
my $out_file = '';
my $fgx_data_dir = 'F:\FGx\fgx-aircraft\data';
my $add_dir = 'D:\FG\fgaddon\Aircraft';
my $fg_root = 'x:\fgdata';
my $fg_air_dir = $fg_root.'\Aircraft';

my $check_for_model = 0;
my $write_fgx_data = 1;
my $use_one_file = 0;    # append ALL specs to ONE file

#my $single_file = $temp_dir.$PATH_SEP."tempspecs.txt";
#my $xmlset = "fgxmlset";
#my $xmllog = 'C:\MDOS\tempfgxml.txt';

my $single_file = $temp_dir.$PATH_SEP."tempspec2.txt";
my $xmlset = "sgxmlset";
my $xmllog = 'C:\MDOS\tempxml.txt';

# ### DEBUG ###
my $debug_on = 0;
my $def_file = 'F:\Projects\aircraft\addsetlist.txt';
#my $def_file = 'C:\GTools\perl\tempset.txt';

### program variables
my @warnings = ();
my $cwd = cwd();
my %air_dirs = (); # $air_dirs{$dir} = [$file,$set];

my %aircraft_dirs = ();
my %model_files = ();


my %common_dirs = (
    'Generic' => 1,
    'Instruments' => 1,
    'Instruments-3d' => 1
    );

my %new_fgaddon = (
    '747-8i' => 1,
    'Caproni-C22J' => 1,
    'Cirrus-SR22' => 1,
    'Dassault-Mystere-IV' => 1,
    'Harrier-GR1' => 1,
    'rah-66' => 1,
    'Sky-sportster' => 1,
    'Su-25' => 1,
    'Tecnam-P2006T' => 1,
    'Tecnam-P2010' => 1,
    'Tu-SB2bis-M103' => 1,
    'XP-67' => 1,
    'Yak-130' => 1,
    );

my %fgdata_dirs = (
    '777' => 1,
    'A6M2' => 1,
    'ASK13' => 1,
    'b1900d' => 1,
    'bo105' => 1,
    'c172p' => 1,
    'CitationX' => 1,
    'Cub' => 1,
    'dhc2' => 1,
    'Dragonfly' => 1,
    'f-14b' => 1,
    'SenecaII' => 1,
    'sopwithCamel' => 1,
    'ufo' => 1,
    'ZLT-NT' => 1,
    );

my %exclude_fgdata = (
    '777-200' => 1
    );

my %exclude_dirs = (
    '737NG' => 1,
    'ATC' => 1,
    'ATC-ML' => 1,
    'c172' => 1,
    'marchetti' => 1,
    'MPCarrier' => 1,
    'shuttle' => 1,
    'UIUC' => 1,
    'tu134' => 1,
    'x24b' => 1
);


sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub mycmp_ascend_num {
   return 1 if ($a > $b);
   return -1 if ($a < $b);
   return 0;
}

sub mycmp_ascend_asc {
   return 1 if (lc($a) gt lc($b));
   return -1 if (lc($a) lt lc($b));
   return 0;
}

my %log_warnings = ();
sub show_log_warning() {
    my @arr = sort keys %log_warnings;
    my ($key,$ra,$cnt);
    $cnt = scalar @arr;
    prt("Got $cnt files with log warnings...\n");
    $cnt = 0;
    foreach $key (@arr) {
        $cnt++;
        $ra = $log_warnings{$key};
        prt("$cnt: $key\n");
        prt(join("\n",@{$ra})."\n");
    }
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$inc,$lnn,$log,@arr,$ra);
    $lnn = 0;
    my $setcnt = 0;
    my $donecnt = 0;
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if (-f $line) {
            $setcnt++;
        }
    }
    prt("Found $setcnt files to process...\n");
    if (-f $tempout2) {
        unlink $tempout2;   # kill any previous to do appending
    }
    foreach $line (@lines) {
        chomp $line;
        $lnn++;
        if (-f $line) {
            prt("$donecnt of $setcnt: $line\n");
            unlink $tempout if (-f $tempout);
            unlink $xmllog if (-f $xmllog);
            system("$xmlset $line -o $tempout -r $fg_root");
            if (-f $tempout) {
                if (open FIL, "<$tempout") {
                    @arr = <FIL>;
                    close FIL;
                    $inc = "# $line\n";
                    $inc .= join("",@arr);
                    append2file($inc,$tempout2);
                }
            }
            if (-f $xmllog) {
                if (open FIL, "<$xmllog") {
                    @arr = <FIL>;
                    close FIL;
                    foreach $log (@arr) {
                        chomp $log;
                        if ($log =~ /^WARNING:\s+(.+)\s+NOT FOUND/) {
                            $log_warnings{$line} = [] if (!defined $log_warnings{$line});
                            $ra = $log_warnings{$line};
                            push(@{$ra},$log);
                        }
                    }
                }
            }

        }
    }
    prt("All written to $tempout2\n");
}

sub get_json_file($) {
    my $dir = shift;
    if (! opendir(DIR,$dir)) {
        pgm_exit(1,"ERROR: Can NOT open $dir\n");
    }
    my @files = readdir(DIR);
    closedir(DIR);
    my ($file,$ff,$cnt);
    my @dirs = ();
    ut_fix_directory(\$dir);
    foreach $file (@files) {
        next if ($file eq '.');
        next if ($file eq '..');
        $ff = $dir.$file;
        if ($file =~ /\.js$/) {
            return $ff;
        }
    }
    prt("Failed to find json in $dir!\n") if (VERB9());
    return "";
}

my @add_dirs = ();
sub get_add_dir($) {
    my $file = shift;
    my ($ra,$ff,$dir);
    foreach $ra (@add_dirs) {
        $ff = ${$ra}[0];
        $dir = ${$ra}[1];
        if ($file eq $dir) {
            return $ra;
        }
        if (lc($file) eq lc($dir)) {
            pgm_exit(1,"ERROR: Case does NOT match '$file' vs '$dir'\n");
            return $ra;
        }
    }
    undef $ra;
    return $ra;
}

#sub get_set_files($) {
#    my $dir = shift;
#    if (! opendir(DIR,$dir)) {
#        pgm_exit(1,"ERROR: Can NOT open $dir\n");
#    }
#    my @files = readdir(DIR);
#    closedir(DIR);
#    my ($file,$ff,$cnt,$json,$ra);
#    ut_fix_directory(\$dir);
#    my @a = ();
#    foreach $file (@files) {
#        next if ($file eq '.');
#        next if ($file eq '..');
#        $ff = $dir.$file;
#        if (-f $ff) {
#            if ($file =~ /-set\.xml$/) {
#                push(@a,$ff);
#            }
#        }
#    }
#    return \@a;
#}

###########################################################
### some models are STILL in fgdata
sub get_fgdata_dirs() {
    my $dir = $fg_air_dir;
    if (! opendir(DIR,$dir)) {
        pgm_exit(1,"ERROR: Can NOT open $dir\n");
    }
    my @files = readdir(DIR);
    closedir(DIR);
    my ($file,$ff,$cnt,$json,$ra,$ra2,$set);
    prt("Seeking all directories from $dir...\n");
    ut_fix_directory(\$dir);
    my $setcnt = 0;
    foreach $file (@files) {
        next if ($file eq '.');
        next if ($file eq '..');
        next if (defined $exclude_dirs{$file});
        $ff = $dir.$file;
        if (-d $ff) {
            my ($ra);
            next if (defined $common_dirs{$file});
            next if (!defined $fgdata_dirs{$file});
            $fgdata_dirs{$file} = 2;
            if (defined $air_dirs{$file}) {
                $ra2 = $air_dirs{$file};
                $set = ${$ra2}[0];
                my @a = ();
                push(@a,$set);
                $ra = \@a;
            } elsif (defined $new_fgaddon{$file}) {
                prtw("WARNING: Skipping NEW addon direcotry '$file'\n");
                next;
            } else {
                prt("get_fgdata_dirs: directory not defined in air_dirs hash\n");
                pgm_exit(1,"Directory $file NOT defined in fgdata! *** FIX ME ***\n");
            }
            ###my $ra = get_set_files($ff);
            $cnt = scalar @{$ra};
            $setcnt += $cnt;
            push(@add_dirs,[$ff,$file,$ra]);
            if (defined $aircraft_dirs{$file}) {
                pgm_exit(1,"Directory $file already defined! *** FIX ME ***\n");
            }
            $aircraft_dirs{$file} = 1;
        }
    }
    my @arr = keys %fgdata_dirs;
    foreach $file (@arr) {
        if ($fgdata_dirs{$file} != 2) {
            prtw("WARNING: Missed dir $file in fgdata_dirs\n");
        }
    }
    $cnt = scalar @add_dirs;
    prt("Got $cnt directories, $setcnt 'set' files, in $dir\n");
    ###pgm_exit(1,"TEMP EXIT\n");
}


sub get_add_dirs() {
    my $dir = $add_dir;
    if (! opendir(DIR,$dir)) {
        pgm_exit(1,"ERROR: Can NOT open $dir\n");
    }
    my @files = readdir(DIR);
    closedir(DIR);
    prt("Seeking all directories from $dir...\n");
    my ($file,$ff,$cnt,$json,$ra,$ra2,$set);
    ut_fix_directory(\$dir);
    my $setcnt = 0;
    my $bgn_cnt = scalar @add_dirs;
    foreach $file (@files) {
        next if ($file eq '.');
        next if ($file eq '..');
        next if (defined $exclude_dirs{$file});
        $ff = $dir.$file;
        if (-d $ff) {
            my $ra;

            if (defined $air_dirs{$file}) {
                $ra2 = $air_dirs{$file};
                $set = ${$ra2}[0];
                my @a = ();
                push(@a,$set);
                $ra = \@a;
            } elsif (defined $new_fgaddon{$file}) {
                prtw("WARNING: Skipping NEW addon directory '$file'\n");
                next;
            } else {
                prt("get_add_dirs: directory not defined in air_dirs hash\n");
                pgm_exit(1,"Directory $file NOT defined in addons! *** FIX ME ***\n");
            }
            ###my $ra = get_set_files($ff);
            $cnt = scalar @{$ra};
            $setcnt += $cnt;
            push(@add_dirs,[$ff,$file,$ra]);
            if (defined $aircraft_dirs{$file}) {
                pgm_exit(1,"Directory $file already defined! *** FIX ME ***\n");
            }
            $aircraft_dirs{$file} = 1;
        }
    }
    $cnt = scalar @add_dirs - $bgn_cnt;;
    prt("Bgn $bgn_cnt, added $cnt directories, $setcnt 'set' files, in $dir\n");
    ### pgm_exit(1,"TEMP EXIT\n");
}

# EXCLUDE these, at least for NOW
my %exclude_fgx_data = (
    'zzz-weapons' => 1,
    'zzz-operations' => 1,
    'asw20-v1-nl' => 1,
    'HondaJet' => 1,
    'seymour' => 1,
    'tu134' => 1
    );

sub get_fgx_json() {
    my $dir = $fgx_data_dir;
    if (! opendir(DIR,$dir)) {
        pgm_exit(1,"ERROR: Can NOT open $dir\n");
    }
    my @files = readdir(DIR);
    closedir(DIR);
    my ($file,$ff,$cnt,$json,$ra,$ra2,$ra3,$set);
    my @dirs = ();
    ut_fix_directory(\$dir);
    foreach $file (@files) {
        next if ($file eq '.');
        next if ($file eq '..');
        next if (defined $exclude_fgx_data{$file});
        $ff = $dir.$file;
        if (-d $ff) {
            push(@dirs,[$ff,$file]);
        }
    }
    $cnt = scalar @dirs;
    prt("Got $cnt directories in $dir\n");
    my @jfiles = ();
    my @missing = ();
    my $fndcnt = 0;
    foreach $ra (@dirs) {
        $dir = ${$ra}[0];
        $file = ${$ra}[1];
        $json = get_json_file($dir);
        if (length($json)) {
            $dir = get_add_dir($file);
            if (! defined $dir) {
                pgm_exit(1,"ERROR: Failed to get add dir for '$file'\n");
            }
            push(@jfiles,[$json,$file,$dir]);
            $fndcnt++ if (length($dir));
        } else {
            push(@missing,$file);
        }
    }
    $cnt = scalar @jfiles;
    prt("Got $cnt json files... matched $fndcnt...\n");
    $cnt = scalar @missing;
    if ($cnt) {
        prt("Missed $cnt: ");
        if (VERB9()) {
            prt(join(" ",@missing));;
        }
        prt("\n");
    }
    my $ofile = $temp_dir.$PATH_SEP."tempxmlset.txt";
    my $sfile = $single_file;
    if ($use_one_file) {
        if (-f $sfile) {
            unlink $sfile;  # using APPEND so delete last
        }
    }
    my (@lines);
    my $jcnt = scalar @jfiles;
    my $dncnt = 0;
    my $dbg_on = 0;
    foreach $ra (@jfiles) {
        $dncnt++;
        $json = ${$ra}[0];  # Three.js JSON file
        $file = ${$ra}[1];  # model DIRECTORY
        if (!$use_one_file) {
            my ($n,$d,$e) = fileparse($file, qr/\.[^.]*/);
            ###$sfile = $temp_dir.$PATH_SEP."temp".$PATH_SEP.$file.".txt";
            if ($write_fgx_data) {
                $sfile = $fgx_data_dir.$PATH_SEP.$file;
                if (! -d $sfile) {
                    pgm_exit(1,"Error: Can NOT locate dir $sfile!\n");
                }
                $sfile .= $PATH_SEP.$n.".ini";
            } else {
                $sfile = $temp_dir.$PATH_SEP."temp".$PATH_SEP.$n.".ini";
            }
        }
        $ra2 = ${$ra}[2];   # this is a ref array [$ff,$file,$ra]
        $ra3 = ${$ra2}[2];
        unlink $ofile if (-f $ofile);
        my $specs = '';
        my $setfile = ${$ra3}[0];
        if (! defined $setfile) {
            prt("setfile not defined in ra3!!!\n");
            prt(Dumper($ra3));
            prt(Dumper($ra));
            pgm_exit(1,"Error abort!");

        }
        prt("$dncnt of $jcnt: json $json, set $setfile\n");
        if ($dbg_on) {
            prt("Output to $sfile\n");
            next;
        }
        system("showthreejs $json -o $ofile");
        if (-f $ofile) {
            if (open INF, "<$ofile") {
                @lines = <INF>;
                close INF;
                $specs .= "# dimensions from '$json' ".lu_get_YYYYMMDD_hhmmss_UTC(time())." UTC\n";
                $specs .= join("",@lines)."\n";
            } else {
                prtw("WARNING: showthreejs $json open $ofile FAILED!\n");
            }
        } else {
            prtw("WARNING: showthreejs $json no out $ofile\n");
        }
        foreach $file (@{$ra3}) {
            unlink $ofile if (-f $ofile);
            unlink $xmllog if (-f $xmllog);
            system("$xmlset $file -r $fg_root -o $ofile");
            if (-f $ofile) {
                if (open INF, "<$ofile") {
                    @lines = <INF>;
                    close INF;
                    $specs .= join("",@lines)."\n";
                } else {
                    prtw("WARNING: $xmlset $file open $ofile FAILED!\n");
                }
            } else {
                prtw("WARNING: $xmlset $file no out $ofile!\n");
            }
            if (-f $xmllog) {
                if (open FIL, "<$xmllog") {
                    my ($log,@arr);
                    @arr = <FIL>;
                    close FIL;
                    foreach $log (@arr) {
                        chomp $log;
                        if ($log =~ /^WARNING:\s+(.+)\s+NOT FOUND/) {
                            $log_warnings{$file} = [] if (!defined $log_warnings{$file});
                            $ra = $log_warnings{$file};
                            push(@{$ra},$log);
                        }
                    }
                }
            }
        }
        if ($use_one_file) {
            append2file($specs,$sfile);
        } else {
            write2file($specs,$sfile);
            prt("Written specs to $sfile\n");
        }
    }
    if ($use_one_file) {
       prt("Written ALL specs to $sfile\n");
    }

    ### pgm_exit(1,"TEMP EXIT\n");
}

#############################################################
## load 'set' files from addsetlist.txt
sub load_add_set() {
    my $file = $in_file;
    if (! open INF, "<$file") {
        pgm_exit(1,"ERROR: Failed to open file $file!\n");
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Loaded $lncnt lines from $file\n");
    my ($line,@arr,$cnt,$dir,$set,$lnn);
    my $ofile = $temp_dir.$PATH_SEP."tempaddset.txt";
    $lnn = 0;
    foreach $line (@lines) {
        $lnn++;
        chomp $line;
        if (! -f $line) {
            pgm_exit(1,"ERROR: Can NOT find file $line! *** FIX FILE $file *** \n");
        }
        @arr = split(/\\/,$line);
        $cnt = scalar @arr;
        if ($cnt != 6) {
            pgm_exit(1,"ERROR: BAD line  $line! *** FIX FILE $file *** \n");
        }
        # D:\FG\fgaddon\Aircraft\Zlin-50lx\z50lx-set.xml
        # 0  1  2       3        4         5
        $dir = $arr[4];
        $set = $arr[5];
        if (defined $air_dirs{$dir}) {
            pgm_exit(1,"ERROR: DIR duplicated $dir, line $line! *** FIX FILE $file *** \n");
        }
        $air_dirs{$dir} = [$line,$set];
        if ($check_for_model) {
            my ($mfile);
            unlink $ofile if (-f $ofile);
            prt("$lnn of $lncnt: $line\n");
            system("$xmlset $line -r $fg_root -o $ofile");
            if (-f $ofile) {
                if (open INF, "<$ofile") {
                    my @lns = <INF>;
                    close INF;
                    my $fnd = 0;
                    foreach $mfile (@lns) {
                        chomp $mfile;
                        if ($mfile =~ /model-file/) {
                            $fnd = 1;
                            @arr = split("=",$mfile);
                            if (scalar @arr == 2) {
                                $mfile = trim_all($arr[1]);
                                $model_files{$mfile} = 1;
                            }
                        }
                    }
                    if (!$fnd) {
                        prtw("WARNING: NO MODEL FILE for $line! *** FIX ME ***\n");
                    }
                }
            } else {
                pgm_exit(1,"ERROR: Failed to create $ofile! *** FIX FILE $file *** \n");
            }
        }

    }

    ###pgm_exit(1,"TEMP EXIT\n");
}

#############################################################
## load 'set' files from fgdataset.txt
sub load_fgdata_set() {
    my $file = $in_file2;
    my $fgdcnt = 5;
    if (! open INF, "<$file") {
        pgm_exit(1,"ERROR: Failed to open file $file!\n");
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Loaded $lncnt lines from $file\n");
    my ($line,@arr,$cnt,$dir,$set,$lnn,$len);
    my $ofile = $temp_dir.$PATH_SEP."tempaddset.txt";
    $lnn = 0;
    foreach $line (@lines) {
        $lnn++;
        chomp $line;
        $line = trim_all($line);
        $len = length($line);
        next if ($len == 0);
        next if ($line =~ /^\#/);
        if (! -f $line) {
            pgm_exit(1,"ERROR: Can NOT find file $line! *** FIX FILE $file *** \n");
        }
        @arr = split(/\\/,$line);
        $cnt = scalar @arr;
        if ($cnt != $fgdcnt) {
            pgm_exit(1,"ERROR: BAD line $line! got $cnt, expected $fgdcnt. *** FIX FILE $file *** \n");
        }
        # X:\fgdata\Aircraft\777\777-300-set.xml
        # 0  1      2        3   4 
        $dir = $arr[3];
        $set = $arr[4];
        if (defined $air_dirs{$dir}) {
            pgm_exit(1,"ERROR: DIR duplicated $dir, line $line! *** FIX FILE $file *** \n");
        }
        $air_dirs{$dir} = [$line,$set];
        if ($check_for_model) {
            my ($mfile);
            unlink $ofile if (-f $ofile);
            prt("$lnn of $lncnt: $line\n");
            system("$xmlset $line -r $fg_root -o $ofile");
            if (-f $ofile) {
                if (open INF, "<$ofile") {
                    my @lns = <INF>;
                    close INF;
                    my $fnd = 0;
                    foreach $mfile (@lns) {
                        chomp $mfile;
                        if ($mfile =~ /model-file/) {
                            $fnd = 1;
                            @arr = split("=",$mfile);
                            if (scalar @arr == 2) {
                                $mfile = trim_all($arr[1]);
                                $model_files{$mfile} = 1;
                            }
                        }
                    }
                    if (!$fnd) {
                        prtw("WARNING: NO MODEL FILE for $line! *** FIX ME ***\n");
                    }
                }
            } else {
                pgm_exit(1,"ERROR: Failed to create $ofile! *** FIX FILE $file *** \n");
            }
        }
    }

    ##pgm_exit(1,"TEMP EXIT\n");
}

my %skip_folders = (
	'Avionics' => 1,
	'Cockpit' => 1,
	'Effects-Submodels' => 1,
	'Engines' => 1,
	'Instruments' => 1,
	'Instruments-3d' => 1,
	'Manual' => 1,
	'Missiles' => 1,
	'Cabine' => 1,
	'Cockpit' => 1,
	'Crew' => 1,
	'EFIS' => 1,
	'Effects' => 1,
	'Engine' => 1,
	'Engines' => 1,
	'Exhausts' => 1,
	'Exterior' => 1,
	'External-objects' => 1,
    'Geometry' => 1,
	'GMeter' => 1,
	'GasHandle' => 1,
	'Guns' => 1,
	'Handles' => 1,
	'Human' => 1,
	'Humans' => 1,
	'Illuminators' => 1,
	'Immat' => 1,
	'Instrumentation' => 1,
	'Instruments3d' => 1,
	'Interior' => 1,
	'LandingLight' => 1,
	'Landinglights' => 1,
	'LedStrip' => 1,
	'LeftPanel' => 1,
	'LeftSwitchPanel' => 1,
	'Light' => 1,
	'Lights' => 1,
	'Loads' => 1,
	'MainPanel' => 1,
	'NASA' => 1,
	'Operations' => 1,
	'Panel' => 1,
	'Parachutes' => 1,
	'Pilot' => 1,
	'Pogos' => 1,
	'Propellers' => 1,
	'Pushback' => 1,
	'Remb' => 1,
	'Rescue' => 1,
	'RightPanel' => 1,
	'RightSwitchPanel' => 1,
	'Rotors' => 1,
	'Seat' => 1,
	'Sprayer' => 1,
	'Stick' => 1,
	'Stickers' => 1,
	'Stores' => 1,
	'Switches' => 1,
	'Tach' => 1,
	'Throttle' => 1,
	'Vzor' => 1,
	'Weapons' => 1,
	'effects' => 1,
	'instruments' => 1,
	'interior' => 1,
	'landinggear' => 1,
	'light' => 1,
	'lights' => 1,
	'panels' => 1,
	'propeller' => 1,
	'propellers' => 1,
	'weapon' => 1,
	'weapons' => 1,
	'wing' => 1,
	'Propeller' => 1,
	'Panels' => 1,
	'Pilot' => 1,
	'Radar' => 1,
	'Stores' => 1,
	'Submodels' => 1,
	'Systems' => 1,
	'Effects' => 1,
	'FlightDeck' => 1,
	'adf' => 1,
	'alt' => 1,
	'alt-2' => 1,
	'altimeter' => 1,
	'asi300' => 1,
	'cdu' => 1,
	'clock' => 1,
	'computing-gun-sights' => 1,
	'egt' => 1,
	'flaps' => 1,
	'garmin196' => 1,
	'ki206' => 1,
	'Kns80' => 1,
	'kr87-adf' => 1,
	'kt70' => 1,
	'kt76a' => 1,
	'kx165' => 1,
	'ky196' => 1,
	'magneto-switch' => 1,
	'mk-viii' => 1,
	'pedals' => 1,
	'primus-1000' => 1,
	'quadrant' => 1,
	'rwr' => 1,
	'tach' => 1,
	'tc' => 1,
	'trim' => 1,
	'vor' => 1,
	'vsi-6' => 1,
	'yoke' => 1,
	'zkv500' => 1
	);

sub show_skip_folders() {
    my @arr = sort mycmp_ascend_asc keys(%skip_folders);
    my ($key,$msg);
    $msg = "static const char *skip_folder[] = {\n";
    foreach $key (@arr) {
        $msg .= "    \"$key\",\n";
    }
    $msg .= "    };\n";
    prt($msg);
    pgm_exit(1,"TEMP EXIT\n");
}

sub show_model_files() {
    my @arr = sort keys %model_files;
    my $cnt = scalar @arr;
    prt("Got $cnt model files...\n");
    my ($file,@arr2,$i,$dcnt,$dir,$mdir,$sdir);
    my %model_subs = ();
    foreach $file (@arr) {
        #prt("$file\n");
        @arr2 = split(/\\/,$file);
        $dcnt = scalar @arr2;
        for ($i = 0; $i < $dcnt; $i++) {
            $dir = $arr2[$i];
            if ($dir eq 'Aircraft') {
                $i++;
                if ($i < $dcnt) {
                    $mdir = $arr2[$i];
                    $i++;
                    $sdir = '';
                    for (; $i < $dcnt; $i++) {
                        $dir = $arr2[$i];
                        last if ($dir =~ /\.ac$/);
                        $sdir .= "\\" if (length($sdir));
                        $sdir .= $dir;
                    }
                    $model_subs{$sdir} = $mdir if (length($sdir));
                }
            }
        }
    }
    @arr = sort keys %model_subs;
    foreach $file (@arr) {
        prt("$file\n");
    }
    pgm_exit(1,"check_for_models: EXIT\n");
}

#########################################
### MAIN ###
###parse_args(@ARGV);
if (! -d $fg_root) {
    pgm_exit(1,"Error: Can NOT 'stat' fg root $fg_root\n");
}
### show_skip_folders();
load_fgdata_set();
load_add_set();
get_fgdata_dirs();
get_add_dirs();
show_model_files() if ($check_for_model);
get_fgx_json();
show_log_warning();

### process_in_file($in_file);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    my $verb = VERB2();
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                $verb = VERB2();
                prt("Verbosity = $verbosity\n") if ($verb);
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if ($verb);
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if ($verb);
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if ($verb);
        }
        shift @av;
    }

    if ($debug_on) {
        prtw("WARNING: DEBUG is ON!\n");
        if (length($in_file) ==  0) {
            $in_file = $def_file;
            prt("Set DEFAULT input to [$in_file]\n");
        }
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - template.pl
