#!/usr/bin/perl -w
# NAME: shownew.pl
# AIM: Quite Specific - Given a cleaned diff file of two file list, show the new 
# files added, and a list of those that have changed
use strict;
use warnings;
use File::Basename;  # split path ($name,$dir,$ext) = fileparse($file [, qr/\.[^.]*/] )
use Cwd;
my $os = $^O;
my $perl_dir = '/home/geoff/bin';
my $PATH_SEP = '/';
my $temp_dir = '/tmp';
if ($os =~ /win/i) {
    $perl_dir = 'C:\GTools\perl';
    $temp_dir = $perl_dir;
    $PATH_SEP = "\\";
}
unshift(@INC, $perl_dir);
require 'lib_utils.pl' or die "Unable to load 'lib_utils.pl' Check paths in \@INC...\n";
# log file stuff
our ($LF);
my $pgmname = $0;
if ($pgmname =~ /(\\|\/)/) {
    my @tmpsp = split(/(\\|\/)/,$pgmname);
    $pgmname = $tmpsp[-1];
}
my $outfile = $temp_dir.$PATH_SEP."temp.$pgmname.txt";
open_log($outfile);

# user variables
my $VERS = "0.0.1 2013-03-17";
my $load_log = 0;
my $in_file = '';
my $verbosity = 0;
my $out_file = '';

# ### DEBUG ###
my $debug_on = 1;
my $def_file = 'D:\Scenery\temp2.diff';

### program variables
my @warnings = ();
my $cwd = cwd();

sub VERB1() { return $verbosity >= 1; }
sub VERB2() { return $verbosity >= 2; }
sub VERB5() { return $verbosity >= 5; }
sub VERB9() { return $verbosity >= 9; }

sub show_warnings($) {
    my ($val) = @_;
    if (@warnings) {
        prt( "\nGot ".scalar @warnings." WARNINGS...\n" );
        foreach my $itm (@warnings) {
           prt("$itm\n");
        }
        prt("\n");
    } else {
        prt( "\nNo warnings issued.\n\n" ) if (VERB9());
    }
}

sub pgm_exit($$) {
    my ($val,$msg) = @_;
    if (length($msg)) {
        $msg .= "\n" if (!($msg =~ /\n$/));
        prt($msg);
    }
    show_warnings($val);
    close_log($outfile,$load_log);
    exit($val);
}


sub prtw($) {
   my ($tx) = shift;
   $tx =~ s/\n$//;
   prt("$tx\n");
   push(@warnings,$tx);
}

sub process_in_file($) {
    my ($inf) = @_;
    if (! open INF, "<$inf") {
        pgm_exit(1,"ERROR: Unable to open file [$inf]\n"); 
    }
    my @lines = <INF>;
    close INF;
    my $lncnt = scalar @lines;
    prt("Processing $lncnt lines, from [$inf]...\n");
    my ($line,$tmp,$lnn,$len,$tline,$ch,$sline,$skip,$dir,$skipped);
    $lnn = 0;
    $skip = 0;
    $skipped = 0;
    $load_log = 1;
    my $plines = 0;
    my $mlines = 0;
    my $slines = 0;
    my $alines = 0;
    my @plus = ();
    my @minus = ();
    my @space = ();
    my @atts = ();
    my $prlnn = 0;
    foreach $line (@lines) {
        $lnn++;
        chomp $line;
        $tline = trim_all($line);
        $len = length($tline);
        #next if ($len == 0);
        $ch = substr($line,0,1);
        if ($line =~ /^@@/) {
            prt("$lnn: $line\n") if (VERB9());
            $skip = 0;
            $alines++;
            push(@atts,[$lnn,$line,$prlnn]);
            $prlnn = $lnn + 1;
        } elsif ($skip) {
            $skipped++;
            next;
        } else {
            $sline = substr($line,1);   # line without 'diff' marker
            if ($ch eq ' ') {
                #   Directory of D:\Scenery\terrascenery\.svn\pristine
                if ($sline =~ /^\s+Directory of (.+)$/) {
                    $dir = $1;
                    if ($dir =~ /\\\.svn/) {
                        $skip = 1;
                    }
                    prt("$lnn: DIR $dir ($skip)\n"); # if (VERB9());
                    $skipped++;
                } else {
                    push(@space,[$lnn,$sline]);
                    $slines++;
                }
            } elsif ($ch eq '+') {
                $plines++;
                if ($line =~ /\+\+\+\s+/) {
                    prt("$lnn: $line\n"); # if (VERB9());
                } else {
                    # get added/changed
                    push(@plus,[$lnn,$sline]);
                }
            } elsif ($ch eq '-') {
                $mlines++;
                if ($line =~ /---\s+/) {
                    prt("$lnn: $line\n"); # if (VERB9());
                } else {
                    # get removal
                    push(@minus,[$lnn,$sline]);
                }
            } else {
                prtw("WARNING: $lnn: WHAT IS THIS $line\n");
            }
        }
    }
    $tmp = $skipped + $slines + $plines + $mlines + $alines;
    prt("Off $lnn lines, skipped $skipped, \@\@ $alines, space $slines, plus $plines, minus $mlines ($tmp)\n");
    my $max = scalar @atts;
    my $scnt = scalar @space;
    my $pcnt = scalar @plus;
    my $mcnt = scalar @minus;
    my ($m,$lnna,$si,$pi,$mi,$lnns,$lnnp,$lnnm,@sarr,@parr,@marr,$tok);
    $si = 0;
    $pi = 0;
    $mi = 0;
    my %hash = ();
    my $prsline = '';
    $sline = '';
    for ($m = 0; $m < $max; $m++) {
        $prsline = $sline;
        $lnna  = $atts[$m][0];
        $sline = $atts[$m][1];
        $prlnn = $atts[$m][2];
        ##next if ($prlnn == 0);
        $tok = $lnna;
        @sarr = ();
        @parr = ();
        @marr = ();
        for (; $si < $scnt; $si++) {
            $lnn  = $space[$si][0];
            $line = $space[$si][1];
            last if ($lnn > $prlnn);
            push(@sarr,[$lnn,$line]);
        }
        for (; $pi < $pcnt; $pi++) {
            $lnn  = $plus[$pi][0];
            $line = $plus[$pi][1];
            last if ($lnn > $prlnn);
            push(@parr,[$lnn,$line]);
        }
        for (; $mi < $mcnt; $mi++) {
            $lnn  = $minus[$mi][0];
            $line = $minus[$mi][1];
            last if ($lnn > $prlnn);
            push(@marr,[$lnn,$line]);
        }
        $hash{$tok}{' '} = [@sarr];
        $hash{$tok}{'+'} = [@parr];
        $hash{$tok}{'-'} = [@marr];
        $hash{$tok}{'@'} = $prsline;
    }
    my @arr = sort keys(%hash);
    $max = scalar @arr;
    prt("Got $max keys...\n");

}

#########################################
### MAIN ###
parse_args(@ARGV);
process_in_file($in_file);
pgm_exit(0,"");
########################################

sub need_arg {
    my ($arg,@av) = @_;
    pgm_exit(1,"ERROR: [$arg] must have a following argument!\n") if (!@av);
}

sub parse_args {
    my (@av) = @_;
    my ($arg,$sarg);
    while (@av) {
        $arg = $av[0];
        if ($arg =~ /^-/) {
            $sarg = substr($arg,1);
            $sarg = substr($sarg,1) while ($sarg =~ /^-/);
            if (($sarg =~ /^h/i)||($sarg eq '?')) {
                give_help();
                pgm_exit(0,"Help exit(0)");
            } elsif ($sarg =~ /^v/) {
                if ($sarg =~ /^v.*(\d+)$/) {
                    $verbosity = $1;
                } else {
                    while ($sarg =~ /^v/) {
                        $verbosity++;
                        $sarg = substr($sarg,1);
                    }
                }
                prt("Verbosity = $verbosity\n") if (VERB1());
            } elsif ($sarg =~ /^l/) {
                if ($sarg =~ /^ll/) {
                    $load_log = 2;
                } else {
                    $load_log = 1;
                }
                prt("Set to load log at end. ($load_log)\n") if (VERB1());
            } elsif ($sarg =~ /^o/) {
                need_arg(@av);
                shift @av;
                $sarg = $av[0];
                $out_file = $sarg;
                prt("Set out file to [$out_file].\n") if (VERB1());
            } else {
                pgm_exit(1,"ERROR: Invalid argument [$arg]! Try -?\n");
            }
        } else {
            $in_file = $arg;
            prt("Set input to [$in_file]\n") if (VERB1());
        }
        shift @av;
    }

    if ($debug_on) {
        ###prtw("WARNING: DEBUG is ON!\n");
        if (length($in_file) ==  0) {
            $in_file = $def_file;
            prt("Set DEFAULT input to [$in_file]\n");
        }
    }
    if (length($in_file) ==  0) {
        pgm_exit(1,"ERROR: No input files found in command!\n");
    }
    if (! -f $in_file) {
        pgm_exit(1,"ERROR: Unable to find in file [$in_file]! Check name, location...\n");
    }
}

sub give_help {
    prt("$pgmname: version $VERS\n");
    prt("Usage: $pgmname [options] in-file\n");
    prt("Options:\n");
    prt(" --help  (-h or -?) = This help, and exit 0.\n");
    prt(" --verb[n]     (-v) = Bump [or set] verbosity. def=$verbosity\n");
    prt(" --load        (-l) = Load LOG at end. ($outfile)\n");
    prt(" --out <file>  (-o) = Write output to this file.\n");
}

# eof - shownew.pl
